/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-pm-mac-0.c,v 1.5 2005/09/15 23:03:48 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/types.h"
#include "sm/sysexits.h"
#include "sm/fcntl.h"
#include "sm/io.h"
#include "sm/ctype.h"
#include "sm/reccom.h"
#include "sm/mta.h"
#define PMILTER_DEBUG_DEFINE 1
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"
#include "sm/pmilter.h"
#include "util.h"
#include "sm/test.h"

#if SM_USE_PMILTER

/*
**  USAGE -- Print usage message to smioerr
**
**	Parameters:
**		prg -- program name
**
**	Returns:
**		exits
*/

static void
usage(const char *prg)
{
	sm_io_fprintf(smioerr, "usage: %s [options]\n"
#if PMILTER_DEBUG
		"-d n             set debug level\n"
#endif
		, prg
		);
	exit(EX_USAGE);
}

#define SM_TEST_RET(cond)	\
	SM_TEST(cond);		\
	if (!(cond))		\
		return

/*
**  TEST_MACROS -- test macro functions
**
**	Parameters:
**		argc -- number of arguments
**
**	Returns:
**		nothing
*/

static void
test_macros(pmg_ctx_P pmg_ctx)
{
	sm_ret_T ret;
	int i;
	pmss_ctx_P pmss_ctx;
	pmse_ctx_P pmse_ctx;
	char *value;
	sm_str_P macs[PM_MAX_MACROS + 1];

	ret = sm_pmss_new(pmg_ctx, &pmss_ctx);
	SM_TEST_RET(ret == SM_SUCCESS);
	ret = sm_pmse_new(pmg_ctx, pmss_ctx, &pmse_ctx);
	SM_TEST_RET(ret == SM_SUCCESS);

	for (i = 0; i <= PM_MAX_MACROS; i++)
	{
		macs[i] = sm_str_new(NULL, 16, 64);
		SM_TEST_RET(macs[i] != NULL);
	}

	ret = sm_pmfi_setmaclist(pmss_ctx, PM_SMST_CONNECT, PMM_SEID, PMM_END);
	SM_TEST_RET(ret == SM_SUCCESS);

	ret = sm_pmfi_setmaclist(pmss_ctx, PM_SMST_CONNECT, PMM_SEID, PMM_END);
	SM_TEST_RET(ret != SM_SUCCESS);

	ret = sm_pmfi_setmaclist(pmss_ctx, PM_SMST_EHLO, PMM_CLIENT_RESOLVE,
				PMM_END);
	SM_TEST_RET(ret == SM_SUCCESS);

	ret = sm_pmfi_setmaclist(pmss_ctx, PM_SMST_MAIL, PMM_AUTH_TYPE,
				PMM_END);
	SM_TEST_RET(ret == SM_SUCCESS);

	ret = sm_pmfi_setmaclist(pmss_ctx, PM_SMST_DOT, PMM_DOT_MSGID,
				PMM_END);
	SM_TEST_RET(ret == SM_SUCCESS);

	ret = sm_pmfi_setmaclist(pmss_ctx, PM_SMST_MAX + 1, PMM_SEID, PMM_END);
	SM_TEST_RET(ret != SM_SUCCESS);

	ret = sm_pmfi_setmaclist(pmss_ctx, PM_SMST_RCPT,
				PMM_MAIL_TAID,
				PMM_MAIL_TAID,
				PMM_MAIL_TAID,
				PMM_MAIL_TAID,
				PMM_MAIL_TAID,
				PMM_MAIL_TAID,
				PMM_MAIL_TAID,
				PMM_MAIL_TAID,
				PMM_END);
	SM_TEST_RET(ret != SM_SUCCESS);

	ret = sm_pmfi_getmac(pmse_ctx, PMM_SRVHOSTNAME, &value);
	SM_TEST(ret != SM_SUCCESS);

	ret = sm_pmfi_getmac(pmse_ctx, PMM_AUTH_TYPE, &value);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(value == NULL);

#define MAC_0	"mac_0"
	ret = sm_str_scat(macs[0], MAC_0);
	SM_TEST_RET(ret == SM_SUCCESS);
#define MAC_1	"mac_1"
	ret = sm_str_scat(macs[1], MAC_1);
	SM_TEST_RET(ret == SM_SUCCESS);

	ret = sm_pmilt_setmacro(pmse_ctx, PM_SMST_MAIL, PMM_AUTH_TYPE, macs[0]);
	SM_TEST_RET(ret == SM_SUCCESS);

	ret = sm_pmilt_setmacro(pmse_ctx, PM_SMST_MAIL, PMM_SRVHOSTNAME, macs[1]);
	SM_TEST(ret != SM_SUCCESS);

	ret = sm_pmfi_getmac(pmse_ctx, PMM_SRVHOSTNAME, &value);
	SM_TEST(ret != SM_SUCCESS);

	ret = sm_pmfi_getmac(pmse_ctx, PMM_AUTH_TYPE, &value);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST_RET(value != NULL);
	SM_TEST(strcmp(value, MAC_0) == 0);

	ret = sm_pmse_free(pmss_ctx, pmse_ctx);
	SM_TEST(ret == SM_SUCCESS);
	ret = sm_pmss_free(pmss_ctx);
	SM_TEST(ret == SM_SUCCESS);
	return;
}

/*
**  MAIN -- PMILTER test server
**
**	Parameters:
**		argc -- number of arguments
**		argv -- vector of arguments
**
**	Returns:
**		exit code
*/

int
main(int argc, char *argv[])
{
	sm_ret_T ret;
	int c;
	pmg_ctx_P pmg_ctx;
	char *prg;

	prg = argv[0];
	pmg_ctx = NULL;
	if (getuid() == 0 || geteuid() == 0)
	{
		sm_io_fprintf(smioerr,
			"%s: ERROR: do not run this as super-user!\n",
			prg);
		exit(EX_USAGE);
	}

	while ((c = getopt(argc, argv, "d:f:r:")) != -1)
	{
		switch (c)
		{
		  case 'd':
#if PMILTER_DEBUG
			pm_debug = atoi(optarg);
#endif
			break;
		  default:
			usage(prg);
			break;
		}
	}

	ret = sm_pmfi_init(&pmg_ctx);
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr, "sev=ERROR, sm_pmfi_init=%x\n", ret);
		goto error;
	}

	sm_test_begin(argc, argv, "test pm mac 0");
	argc -= optind;
	argv += optind;
	test_macros(pmg_ctx);
	return sm_test_end();

  error:
	/* select an appropriate error here... */
	return sm_error_value(ret);
}
#else /* SM_USE_PMILTER */
int
main(int argc, char *argv[])
{
	return 0;
}
#endif /* SM_USE_PMILTER */
