/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: bdbversion.c,v 1.7 2005/03/07 22:45:28 ca Exp $")
#include "sm/io.h"
#include "sm/bdb.h"

/*
**  SM_BDBVERSIONOK -- check Berkeley DB version
**
**	Parameters:
**		none
**
**	Returns:
**		usual sm_error code.
*/

sm_ret_T
sm_bdbversionok(void)
{
	int major_v, minor_v, patch_v;

	/* patch_v is deemed to be unimportant, let's hope Sleepycat agrees */
	(void) db_version(&major_v, &minor_v, &patch_v);
	if (major_v != DB_VERSION_MAJOR || minor_v != DB_VERSION_MINOR)
		return sm_error_perm(SM_EM_BDB, SM_E_VER_MIX);
	return SM_SUCCESS;
}

/*
**  SM_BDBVERSIONPRT -- show Berkeley DB version
**
**	Parameters:
**		fp -- file for output
**
**	Returns:
**		usual sm_error code.
*/

sm_ret_T
sm_bdbversionprt(sm_file_T *fp)
{
	int major_v, minor_v, patch_v;

	(void) db_version(&major_v, &minor_v, &patch_v);
	sm_io_fprintf(fp,
		"Berkeley DB versions:\n"
		"compiled against: major=%2d, minor=%2d, patchlevel=%2d\n"
		"linked against:   major=%2d, minor=%2d, patchlevel=%2d\n"
		, DB_VERSION_MAJOR, DB_VERSION_MINOR, DB_VERSION_PATCH
		, major_v, minor_v, patch_v);
	if (major_v != DB_VERSION_MAJOR || minor_v != DB_VERSION_MINOR)
		return sm_error_perm(SM_EM_MAP, SM_E_VER_MIX);
	return SM_SUCCESS;
}
