/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-id.c,v 1.2 2005/09/04 06:09:59 ca Exp $")

#include "sm/ctype.h"
#include "sm/sysexits.h"
#include "sm/error.h"

#include <stdio.h>

static int Verbose = 0;

static void
usage(const char *prg)
{
	fprintf(stderr,
		"usage: %s [options]\n"
		"options:\n"
		"-o        dummy option\n"
		"-i id     id\n"
		"-V        increase verbosity\n"
		, prg);
	exit(EX_USAGE);
}

int
main(int argc, char *argv[])
{
	bool got;
	int c, id;
	char *prg, *fn;
	FILE *fp;

	prg = argv[0];
	id = -1;
	got = false;
	while ((c = getopt(argc, argv, "hi:oV")) != -1)
	{
		switch (c)
		{
		  case 'o':
			got = true;
			break;
		  case 'i':
			id = strtol(optarg, NULL, 0);
			break;
		  case 'V':
			++Verbose;
			break;
		  case 'h':
		  case '?':
		  default:
			usage(prg);
			break;
		}
	}
	argc -= optind;
	argv += optind;
	if (argc > 0)
	{
		fn = argv[0];
		fp = fopen(fn, "a");
		if (fp == NULL)
			return errno;
		fprintf(fp, "id=%d, pid=%ld\n", id, (long) getpid());
		fclose(fp);
		sleep(2);
	}
	exit(0);
}
