#!/bin/sh
# $Id: t-smconf-0.sh,v 1.70 2005/10/19 18:49:25 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

# read configuration file and print it;
# uses the various modules *prtcnf.c
# Note: some of the output may depend on compile time options, e.g.
# SS_LOGDIR

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`

ERRS=0

CNF=sm0.conf
OUT=sm0.out
OK=sm0.ok

PRG=./smconf

AUTHOPTS=''
TLSOPTS=''

${PRG} -VVV |grep 'SM_USE_TLS' >${OUT} 2>&1
if test -s ${OUT}
then
TLSSRVOPTS='tls {
  # flags to influence behavior related to STARTTLS [see documentation]
  flags={
  }
}
'
else
TLSSRVOPTS=''
fi

${PRG} -VVV |grep 'SM_USE_PMILTER' >${OUT} 2>&1
if test -s ${OUT}
then
PMILTEROPTS='  # socket=union-COULD-NOT-BE-PRINTED;
# policy milter
policy_milter {
  # maximum amount of time to wait for a reply from a policy milter
  timeout=0s;
}
'
else
PMILTEROPTS=""
fi

${PRG} -VVV |grep 'QMGR_TEST' >${OUT} 2>&1
if test -s ${OUT}
then
QMGRTESTOPTS='
tests=0;'
else
QMGRTESTOPTS=""
fi


cat > ${CNF} <<EOF
qmgr {
  queue_return_timeout= 3d;
  retry_min_delay = 23m;
  retry_max_delay = 3h;
  AQ_max_entries = 8192;
  DSN_handling {
    merge_delay_max = 2s;
    max_errors_per_DSN=16;
  }
  smtpc { initial_connections = 19; max_connections = 101; }
  smtps { max_connections = 5;
	max_connection_rate=160; }
  wait_for_server = 4;
  wait_for_client = 3;
  min_disk_space = 1 MB;
  ok_disk_space = 2 MB;
	start_action = wait;
	user = smxq;
	restart_dependencies = { smtps, smtpc, smar };
	path = "/var/spool/smx/libexec/qmgr";
	arguments = "qmgr -f smx.conf";
}

smar {
  Log_Level = 12;
  log { facility = mail; ident = smxar; }
  nameserver = {10.11.12.13, 127.0.0.1};
  dns_timeout = 6;
  address_delimiter=/;
	start_action = wait;
	user = smxm;
	restart_dependencies = { smtps, qmgr };
	path = "/var/spool/smx/libexec/smar";
	arguments = "smar -f smx.conf";
}

smtps {
  flags = {8bitmime, access, delay_checks, };
  cdb_gid = 1200;
  daemon_address = "localhost:1234";
  IO_timeout = 60;
  wait_for_server = 4;
	listen_socket { type=inet; port = 25;}
	start_action = pass;
	pass_fd_socket = smtps/smtpsfd;
	user = smxs;
	path = "/var/spool/smx/libexec/smtps";
	arguments = "smtps -f smx.conf";
}

smtpc {
  remote_port = 25;
  wait_for_server = 4;
  Log_Level = 12;
  IO_timeout = 66;
	start_action = wait;
	user = smxc;
	path = "/var/spool/smx/libexec/smtpc";
	arguments = "smtpc -f smx.conf";
}
EOF

cat > ${OK} <<EOF
QMGR {
# maximum number of entries in AQ (active queue)
AQ_max_entries=8192;
# maximum number of entries in OCC (outgoing connection cache)
OCC_max_entries=0;
IBDB {
  # maximum size of each IBDB file
  size=0B;
  # maximum number of open transactions in IBDB before a commit is performed
  max_open_TAs=0;
  # maximum time between commits to IBDB (micro seconds)
  max_commit_delay=0;
}
IQDB {
  # maximum number of entries in IQDB cache
  max_cache_entries=0;
  # size of hash table for IQDB
  hash_table_entries=0;
}
# minimum amount of free disk space (KB)
min_disk_space=1MB;
# amount of free disk space at which normal operation continues (KB)
ok_disk_space=2MB;
smtpc {
  # initial number of outgoing connections to a single host
  initial_connections=19;
  # maximum number of outgoing connections to a single host
  max_connections=101;
  # maximum number of recipients per transaction (smtp)
  smtp_max_rcpts_per_transaction=0;
  # maximum number of recipients per transaction (lmtp)
  lmtp_max_rcpts_per_transaction=0;
}
smtps {
  # maximum number of open incoming connection from a single host
  max_connections=5;
  # maximum incoming connection rate from a single host
  max_connection_rate=160;
  # size of connection control hash table [experts only]
  connection_control_hash_table_size=0;
}
# minimum time for retrying a delivery
retry_min_delay=23m;
# maximum time for retrying a delivery
retry_max_delay=3h;
# maximum time in queue
queue_return_timeout=3d;
# send delay warning after this time in queue
queue_delay_timeout=0s;
# timeout in address resolver
SMAR_timeout=0s;
# timeout for a single delivery attempt
delivery_timeout=0s;
# maximum time waiting to be scheduled
scheduler_timeout=0s;
# maximum amount of time to wait for a server to become available
wait_for_server=4s;
# maximum amount of time to wait for a client to become available
wait_for_client=3s;
log_level=0;
debug_level=0;${QMGRTESTOPTS}
DSN_handling {
  # maximum number of error messages (failed recipients) in a bounce (DSN)
  max_errors_per_DSN=16;
  # maximum time to wait for merging multiple DSNs into one
  merge_delay_max=2s;
}
DEFEDB {
  # DB page size
  page_size=0B;
  # DB cache size
  cache_size=0B;
  # If non-zero, a checkpoint will be done if more than the amount of KBytes of
  # log data have been written since the last checkpoint
  KBytes_written_for_checkpointing=0KB;
  # Minimum delay between two checkpoints
  delay_between_2_checkpoints=0s;
}
# minimum number of threads [experts only]
min_threads=0;
# maximum number of threads [experts only]
max_threads=0;
# maximum number of file descriptors [experts only]
max_fds=0;
# minimum number of processes
min_processes=0;
# maximum number of processes
max_processes=0;
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=false;
}
SMTPS {
# path of Unix domain socket to exchange file descriptor [use with MCP]
pass_fd_socket="smtps/smtpsfd";
# address for daemon to listen on [do not use with MCP]
daemon_address={localhost:1234, }
# length of listen(2) queue [do not use with MCP]
listen_queue=0;
# log level
log_level=0;
# group id (numeric) to use for CDB files
cdb_gid=1200;
# (unique) id for server (if multiple SMTP servers are configured)
id=0;
# maximum number of transactions per session
max_transactions=0;
# maximum number of recipients per session
max_recipients_per_session=0;
# maximum number of recipients per transaction
max_recipients_per_transaction=0;
# maximum number of hops (Received: headers)
max_hops=0;
# maximum message size (KB)
max_message_size=0KB;
# maximum number of bad SMTP commands per session
max_bad_commands_per_session=0;
# maximum number of SMTP commands with invalid addresses per session
max_invalid_addresses_per_session=0;
# maximum number of nop SMTP commands between transactions
max_nop_commands_between_transactions=0;
# maximum number of bad SMTP commands per transaction
max_bad_commands_per_transaction=0;
# maximum number of nop SMTP commands in a single transaction
max_nop_commands_in_transaction=0;
# maximum number of SMTP commands with invalid addresses per transaction
max_invalid_addresses_per_transaction=0;
# timeout for SMTP I/O operations
io_timeout=1m;
# flags to influence behavior [see documentation]
flags={
  # offer 8BITMIME
  8bitmime,
  # use access map
  access,
  # delay returning results from access check until RCPT stage
  delay_checks,
}
# how to protect recipient addresses [see documentation]
protected_recipients {
  # allow by
  allow_by={
  }
  # match type
  match_type=;
}
# maximum number of threads
max_threads=0;
# maximum number of waiting threads
max_wait_threads=0;
# minimum number of waiting threads
min_wait_threads=0;
# number of processes to start
processes=0;
# maximum amount of time to wait for a server to become available
wait_for_server=4s;
# maximum amount of time to wait for a reply from smar
wait_for_smar=0s;
# debug level
debug_level=0;
${TLSSRVOPTS}${AUTHOPTS}${PMILTEROPTS}listen_socket {
  # socket type
  type=inet;
  # port to listen on
  port=25;
  # bind to this IPv4 address
  address=0.0.0.0;
}
# minimum number of processes
min_processes=0;
# maximum number of processes
max_processes=0;
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=false;
}
SMTPC {
# port to connect to on server
remote_port=25;
# number of processes to start [currently not implemented]
processes=0;
# maximum number of threads
max_threads=0;
# maximum number of waiting threads
max_wait_threads=0;
# minimum number of waiting threads
min_wait_threads=0;
flags=0;
log_level=12;
debug_level=0;
# timeout for SMTP I/O operations
io_timeout=1m6s;
# maximum amount of time to wait for a server to become available
wait_for_server=4s;
# unique id
id=0;
# connect only to this IPv4 address [testing]
connect_only_to=0.0.0.0;
${TLSOPTS}# minimum number of processes
min_processes=0;
# maximum number of processes
max_processes=0;
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=false;
}
SMAR {
# List of nameservers (IPv4 addresses)
nameserver={10.11.12.13, 127.0.0.1, }
DNS_timeout=6s;
log_level=12;
# specify syslog(3) configuration instead of logging to files
log {
  # facility for openlog(3)
  facility=MAIL;
  # ident for openlog(3)
  ident="smxar";
}
# minimum number of threads [experts only]
min_threads=0;
# maximum number of threads [experts only]
max_threads=0;
# maximum number of file descriptors [experts only]
max_fds=0;
# DNS based blacklists
# Greylisting options
greylisting {
  # how long before greylisted can be "confirmed"
  grey_wait=0s;
  # timeout for greylisted entries (didn't "confirm" within that time)
  grey_expire=0s;
  # expire whitelisted entries after this time if necessary
  white_expire=0s;
  # force whitelisted entries to reconfirm after this time
  white_timeout=0s;
  # try to expire entries when this limit is reached
  expire_limit=0;
  # apply netmask to IPv4 address
  netmask=0;
}
# delimiter for address extensions in local part
address_delimiter="/";
# minimum number of processes
min_processes=0;
# maximum number of processes
max_processes=0;
# use id to create name of logfile: Logdir name id . log
use_id_in_logfile_name=false;
}
EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit 1
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
