/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: chkaq.c,v 1.8 2005/09/26 23:43:32 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/string.h"
#include "sm/edbc.h"
#include "sm/qmgr-int.h"
#include "sm/actdb-int.h"
#if AQ_RDQ
# include "sm/aqrdq.h"
#endif /* AQ_RDQ */
#include "qmgr.h"
#include "log.h"

#if QMGR_DEBUG
/*
**  CHKAQ_TA -- Check counters in a transaction with content in AQ
**
**	Parameters:
**		qmgr_ctx -- QMGR context
**		aq_ta -- transaction to check
**
**	Returns:
**		usual sm_error code
**
**	Locking:
**		locks aq_mutex
*/

sm_ret_T
chkaq_ta(qmgr_ctx_P qmgr_ctx, aq_ta_P aq_ta)
{
	sm_ret_T ret;
	uint rcpts, temp, perm;
	aq_ctx_P aq_ctx;
	aq_rcpt_P aq_rcpt;

	ret = SM_SUCCESS;
	if (aq_ta == NULL)
		return ret;
	SM_IS_AQ_TA(aq_ta);
	aq_ctx = qmgr_ctx->qmgr_aq;
	SM_IS_AQ(aq_ctx);

	rcpts = temp = perm = 0;
	for (aq_rcpt = AQR_FIRST(aq_ctx); aq_rcpt != AQR_END(aq_ctx);
	     aq_rcpt = AQR_NEXT(aq_rcpt))
	{
		if (!sm_streq(aq_ta->aqt_ss_ta_id, aq_rcpt->aqr_ss_ta_id))
			continue;
		++rcpts;
		if (smtp_reply_type(aq_rcpt->aqr_status) == SMTP_RTYPE_TEMP)
			++temp;
		else if (smtp_reply_type(aq_rcpt->aqr_status) ==
							SMTP_RTYPE_PERM)
			++perm;
	}

QM_LEV_DPRINTF(2, (QM_DEBFP,
	"func=chkaq_ta, aq_ta=%p, ss_ta=%s, ta_rcpts=%u, ta_total=%u, ta_tried=%u, ta_left=%u, ta_temp=%u, ta_perm=%u, chk_rcpts=%u, chk_temp=%u, chk_perm=%u\n"
	, aq_ta, aq_ta->aqt_ss_ta_id, aq_ta->aqt_rcpts_inaq, aq_ta->aqt_rcpts_tot, aq_ta->aqt_rcpts_tried
	, aq_ta->aqt_rcpts_left, aq_ta->aqt_rcpts_temp, aq_ta->aqt_rcpts_perm
	, rcpts, temp, perm));
	return ret;
}
#endif /* QMGR_DEBUG */
