#!/bin/sh
# $Id: t-rcpts-0.sh,v 1.21 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses.
# Uses t-rcpts-0, "aliases" map, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=rcpts-0.out
RES=rcpts-0.addr
OK=rcpts-0.ok
TPRG=./t-rcpts-0
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi


# create map for smar
rm -f ${ALIMAP}
${MM} <<EOF
user:	local:
a:	<a1@x.y> <a2@y.z>
in2:	<out1@x.y> <int2@b.c>
int2:	<out2@x.y>
loop1:	<loop1@b.c> <int2@b.c>
loop2:	<l2@b.c> <int2@b.c>
l2:	<loop2@b.c> <ext2@b.c>
EOF
if test $? -ne 0
then
  echo "$0: t-mm failed"
  exit 1
fi

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
EOF

TEST=0
# ----------------------------------------
# test 0
${VALGRIND} ${TPRG} -VV '<n@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:          <n@b.c> flags: 4000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=1
# ----------------------------------------
# test 0 with -l
${VALGRIND} ${TPRG} -V -l '<n@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:          <n@b.c> flags: 2000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=2
# ----------------------------------------
# test 1
${VALGRIND} ${TPRG} -VV '<a@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:          <a@b.c> flags: 24200
address:         <a1@x.y> flags: 4000
address:         <a2@y.z> flags: 4000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=3
# ----------------------------------------
# test 1 with -l
${VALGRIND} ${TPRG} -V -l '<a@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:         <a1@x.y> flags: 2000
address:         <a2@y.z> flags: 2000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=4
# ----------------------------------------
# test 2
${VALGRIND} ${TPRG} -VV '<in2@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:        <in2@b.c> flags: 24200
address:       <int2@b.c> flags: 24200
address:       <out1@x.y> flags: 4000
address:       <out2@x.y> flags: 4000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=5
# ----------------------------------------
# test 2 with -l
${VALGRIND} ${TPRG} -V -l '<in2@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:       <out1@x.y> flags: 2000
address:       <out2@x.y> flags: 2000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=6
# ----------------------------------------
# test 3
${VALGRIND} ${TPRG} -VV '<loop1@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:       <int2@b.c> flags: 24200
address:       <out2@x.y> flags: 4000
address:      <loop1@b.c> flags: 24000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=7
# ----------------------------------------
# test 3 with -l
${VALGRIND} ${TPRG} -V -l '<loop1@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:       <out2@x.y> flags: 2000
address:      <loop1@b.c> flags: 22000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=8
# ----------------------------------------
# test 4
${VALGRIND} ${TPRG} -VV '<loop2@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:         <l2@b.c> flags: 24200
address:       <ext2@b.c> flags: 4000
address:       <int2@b.c> flags: 24200
address:       <out2@x.y> flags: 4000
address:      <loop2@b.c> flags: 24200
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=9
# ----------------------------------------
# test 4 with -l
${VALGRIND} ${TPRG} -V -l '<loop2@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
sort > ${OK} <<EOF
address:       <ext2@b.c> flags: 2000
address:       <out2@x.y> flags: 2000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=10
# ----------------------------------------
# test 5
${VALGRIND} ${TPRG} -VV '<user@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:       <user@b.c> flags: 24800
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=11
# ----------------------------------------
# test 5 with -l
${VALGRIND} ${TPRG} -V -l '<user@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:       <user@b.c> flags: 22800
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=12
# ----------------------------------------
# test 6
${VALGRIND} ${TPRG} -VV '<no@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:         <no@b.c> flags: 4000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=13
# ----------------------------------------
# test 6 with -l
${VALGRIND} ${TPRG} -V -l '<no@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:         <no@b.c> flags: 2000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

rm -f ${OUT} ${RES} ${OK}

exit ${ERRS}
