#!/usr/bin/perl

# reads stats and uptime from ipfw for mrtg

$rules_number  = ($ARGV[0] or "10000");
$firewall_name = ($ARGV[1] or "IP Firewall on FreeBSD");
$in_str        = ($ARGV[2] or "in");
$out_str       = ($ARGV[3] or "out");

$data = `/sbin/ipfw -q show $rules_number`;
system  "/sbin/ipfw -q zero $rules_number";

($in_bytes,$out_bytes)=(0,0);

for $record (split "\n",$data) {
 ($rule,$pkts,$bytes,$ident) = split m[\s+],$record,4;
 $in_bytes=$bytes,next  if index($ident,$in_str)>=0;
 $out_bytes=$bytes,next if index($ident,$out_str)>=0;
}

$uptime=$1 if ($record=`/usr/bin/uptime`)=~m[up\s+(.*?,.*?),];
print "$in_bytes\n$out_bytes\n$uptime\n$firewall_name\n";

