#!/usr/bin/perl
#
# Author: Stephan Zouain, Steria AS, Norway October 2009
#
#
# This will look at the $trafficDir directory for HTML files generated using
# the get-all-[daily,weekly,monthly or yearly].pl scripts, parse them and
# generate an HTML file containing the summary for each of the previous 4 HTML
# files listing the number of interfaces down, up and in critical status.
# Giving afterwards the possibility to drill down and see details for every
# report.
#
# Modify this if you wish as long as the above credit is not removed
#

# TWO VARIABLES YOU MUST CHANGE
#
#CHANGE THIS to the directory where the MRTG2 generated HTML files are
$trafficDir="./";
#
# CHANGE THIS to your organization name
$orgName="NewOrganization";
#

#The output file
$outFile = "$trafficDir/index.html";
#

# The following may be changed according to the needs and the interface speeds
# to categorize the critical status in regards to usage on interfaces.
#
# That's for the MAX values
$CRITICAL = 800000;
#

# Refresh interval (minutes) for HTML doc
$refreshInt=10;
#
$refreshSeconds=60*$refreshInt;
#

#Date value
$theDate=`date +"%m/%d/%y %H:%M"`;
#

#Defining the colors
$REDcolor="#ff0000";
$GREENcolor="#00ff00";
$BLACKcolor="#000000";
$WHITEcolor="#ffffff";
#

open(OUT, ">$outFile") || die "Couldn't create $outFile";
&PrintHead;

open(LS, "ls $trafficDir/index*-*ly.html|") || die "Couldn't list directory";
while (<LS>) {
        chop;
        $theFile = $_;
        open(IN, "$theFile") || die "Couldn't open $theFile\n";
        $i=0;
	$j=0;
	$k=0;
	while (<IN>) {
                if (/\<TR\>\<TD BGCOLOR=.*\>\<CENTER\>([0-9.]*)\<\/CENTER\>.*\<CENTER\>([0-9.]*)\<\/CENTER\>.*\<CENTER\>([0-9.]*)\<\/CENTER\>.*\<CENTER\>([0-9.]*)\<\/CENTER\>.*\<CENTER\>([0-9.]*)\<\/CENTER\>.*\<CENTER\>([0-9.]*)\<\/CENTER\>.*\<\/TD\>\<\/TR\>/){
			if (($1 > $CRITICAL) || ($2 > $CRITICAL) || ($3 > $CRITICAL) || ($4 > $CRITICAL) || ($5 > $CRITICAL) || ($6 > $CRITICAL)) {
				$i++;
			} elsif (($1 == 0) && ($2 == 0) && ($3 == 0) && ($4 == 0) && ($5 == 0) && ($6 == 0)) {
				$j++;
                        } else {
				$k++;
			}
		}
	}
        close(IN);
        $theFile =~ s/.*\/index//;
        $theFile =~ s/\.html//;
	printf(OUT "<TR><TD><A HREF=index${theFile}\.html>$theFile statistics </A></TD><TD BGCOLOR=$GREENcolor><CENTER>Number of functional interfaces: <B>$k</B></CENTER></TD><TD BGCOLOR=$REDcolor><CENTER>Number of over-used interfaces: <B>$i</B> </CENTER></TD><TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><CENTER>Number of interfaces down: <B>$j</B> </CENTER></TD></TR><p>\n");
}
close(LS);


&PrintTail;
close(OUT);

sub PrintHead
{
$expTime=&expistr;

print OUT <<EOF;
<HTML>
<HEAD>
<TITLE>$orgName Yearly, monthly, weekly and daily overview of network equipment interfaces</TITLE>
</HEAD>
<META HTTP-EQUIV="Expires" CONTENT="$expTime">
<META HTTP-EQUIV="Refresh" CONTENT=$refreshSeconds>
<BODY bgcolor=#ffffff>
<H1>Statistics over yearly, monthly, weekly and daily usage of interfaces as of $theDate</H1>
<P>This table is updated every $refreshInt minutes and will automatically be updated if you are using a Mozilla compatible browser.<P>
<P>Are considered over-used interfaces with usage over: <FONT COLOR="#ff0000"><B> $CRITICAL </B></font>B\/s<P>
<br><br><br>
<TABLE WIDTH="100%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="80">
EOF
}

sub PrintTail
{
print OUT <<EOF;
</TABLE>
</BODY>
</HTML>
EOF
}

sub expistr {
  my ($time) = time+$refreshInt*60+5;
  my ($wday) = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[(gmtime($time))[6]];
  my ($month) = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep',
                 'Oct','Nov','Dec')[(gmtime($time))[4]];
  my ($mday,$year,$hour,$min,$sec) = (gmtime($time))[3,5,2,1,0];
  if ($mday<10) {$mday = "0$mday"};
  if ($hour<10) {$hour = "0$hour"};
  if ($min<10) {$min = "0$min";}
  if ($sec<10) {$sec = "0$sec";}
  return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
}
