#!/usr/bin/perl
#
# Author: Stephan Zouain, Steria AS, Norway October 2009
# Based on the get-active2.pl script in the MRTG 2.16.2 contribution get-active by Russ Wright, Lawrence Berkeley National Laboratory December 1997 (former credits : Local modifications by Wee-Meng Lee  HP Singapore (colour/lynx)    and Mark Mushkin  HP Santa Clara  (avg/max/min that suit our needs) Last Update on  Oct 14, 1997 )
#
# This will look at the $trafficDir directory for MRTG2 generated HTML
# files, parse them and generate a listing of all interfaces active/inactive
# with their actual and yearly usage in Bytes/second in a file called "index4-yearly.html".
# This is doing alerting as well if the usage of the interface is above ~0.8
# MBytes/s it will be highlighted in red if it is over ~0,4 it will be in
# amber (this is an indicator for links with limited capacities).
#
# modify this if you wish as long as the above credit is not removed
#

# TWO VARIABLES YOU MUST CHANGE
#
#CHANGE THIS to the directory where the MRTG2 generated HTML files are
$trafficDir="./";
#
# CHANGE THIS to your organization name
$orgName="NewOrganization";
#

#The output file
$outFile = "$trafficDir/index4-yearly.html";
#

# The following may be changed according to the needs and the interface speeds
# to highlight stuff.
#
#values over this will be displayed in the specified color
#  these are for the MAX values
$maxAMBER = 400000;
$maxRED = 800000;
#

#Defining the colors
$REDcolor="#ff0000";
$AMBERcolor="#ffff00";
$GREENcolor="#00ff00";
$BLACKcolor="#000000";
$WHITEcolor="#ffffff";
#

# Refresh interval (minutes) for HTML doc
$refreshInt=10;
#
$refreshSeconds=60*$refreshInt;
#

#Date value
$theDate=`date +"%m/%d/%y %H:%M"`;
#

open(LS, "ls $trafficDir/*.[0-9]*.html|") || die "Couldn't list directory";
while (<LS>) {
        chop;
        $theFile = $_;
        open(IN, "$theFile") || die "Couldn't open $theFile\n";
        $i=0;
        while (<IN>) {
                if (/Traffic Analysis for .*[0-9]<BR>(.*)<\/H1> <TABLE>/) {
                        if ($1 =~ /tunnel/i) {
# skip tunnels
                                last;
                        }
                        $desc{$theFile} = $1;
                }
                if (/\<td\>([0-9.]*) B\/s /) {
                        $theList{$theFile}[$i++] = $1;
                }
		if (/\<td\>([0-9.]*) kB\/s /) {
                        $theList{$theFile}[$i++] = $1*1000;
               }
        }
        close(IN);
}
close(LS);

#
#
# the array contains all the percentages:
# daily, weekly, monthly, yearly
# the following 6 for yearly:
# 18 Max In
# 19 Avg In
# 20 Cur In
# 21 Max Out
# 22 Avg Out
# 23 Cur Out
#
#

open(OUT, ">$outFile") || die "Couldn't create $outFile";
&PrintHead;

foreach $key (keys %theList) {
# get sum of both max in and out
         $sumInOut = $theList{$key}[19] + $theList{$key}[22]; # use for avg
         $printList{$key} = $sumInOut;
}


foreach $key (sort by_bytes (keys %printList)) {
        $theRouter = $key;
        $theRouter =~ s/.*\///;
        $theRouter =~ s/\.html//;
        $maxIn= $theList{$key}[18];
        $avgIn= $theList{$key}[19];
        $curIn= $theList{$key}[20];
        $maxOut= $theList{$key}[21];
        $avgOut= $theList{$key}[22];
        $curOut= $theList{$key}[23];

        printf(OUT "<TR>");

        if ($maxIn >= $maxRED) {
                printf(OUT "<TD BGCOLOR=$REDcolor><CENTER>$maxIn</CENTER></TD>");
        } elsif ($maxIn > $maxAMBER) {
                printf(OUT "<TD BGCOLOR=$AMBERcolor><CENTER>$maxIn</CENTER></TD>");
        } elsif ($maxIn == 0) {
                printf(OUT "<TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><CENTER>$maxIn</CENTER></TD>");
        } else {
                printf(OUT "<TD BGCOLOR=$GREENcolor><CENTER>$maxIn</CENTER></TD>");
        }
        printf(OUT "    ");

        if ($maxOut >= $maxRED) {
                printf(OUT "<TD BGCOLOR=$REDcolor><CENTER>$maxOut</CENTER></TD>");
        } elsif ($maxOut > $maxAMBER) {
                printf(OUT "<TD BGCOLOR=$AMBERcolor><CENTER>$maxOut</CENTER></TD>");
        } elsif ($maxOut == 0) {
                printf(OUT "<TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><CENTER>$maxOut</CENTER></TD>");
        } else {
                printf(OUT "<TD BGCOLOR=$GREENcolor><CENTER>$maxOut</CENTER></TD>");
        }
        printf(OUT "    ");

        if ($avgIn >= $maxRED) {
                printf(OUT "<TD BGCOLOR=$REDcolor><CENTER>$avgIn</CENTER></TD>");
        } elsif ($avgIn > $maxAMBER) {
                printf(OUT "<TD BGCOLOR=$AMBERcolor><CENTER>$avgIn</CENTER></TD>");
        } elsif ($avgIn == 0) {
                printf(OUT "<TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><CENTER>$avgIn</CENTER></TD>");
        } else {
                printf(OUT "<TD BGCOLOR=$GREENcolor><CENTER>$avgIn</CENTER></TD>");
        }
        printf(OUT "    ");

        if ($avgOut >= $maxRED) {
                printf(OUT "<TD BGCOLOR=$REDcolor><CENTER>$avgOut</CENTER></TD>");
        } elsif ($avgOut > $maxAMBER) {
                printf(OUT "<TD BGCOLOR=$AMBERcolor><CENTER>$avgOut</CENTER></TD>");
        } elsif ($avgOut == 0) {
                printf(OUT "<TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><CENTER>$avgOut</CENTER></TD>");
        } else {
                printf(OUT "<TD BGCOLOR=$GREENcolor><CENTER>$avgOut</CENTER></TD>");
        }
        printf(OUT "    ");

        if ($curIn >= $maxRED) {
                printf(OUT "<TD BGCOLOR=$REDcolor><CENTER>$curIn</CENTER></TD>");
        } elsif ($curIn > $maxAMBER) {
                printf(OUT "<TD BGCOLOR=$AMBERcolor><CENTER>$curIn</CENTER></TD>");
        } elsif ($curIn == 0) {
                printf(OUT "<TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><CENTER>$curIn</CENTER></TD>");
        } else {
                printf(OUT "<TD BGCOLOR=$GREENcolor><CENTER>$curIn</CENTER></TD>");
        }
        printf(OUT "    ");

        if ($curOut >= $maxRED) {
                printf(OUT "<TD BGCOLOR=$REDcolor><CENTER>$curOut</CENTER></TD>");
        } elsif ($curOut > $maxAMBER) {
                printf(OUT "<TD BGCOLOR=$AMBERcolor><CENTER>$curOut</CENTER></TD>");
        } elsif ($curOut == 0) {
                printf(OUT "<TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><CENTER>$curOut</CENTER></TD>");
        } else {
                printf(OUT "<TD BGCOLOR=$GREENcolor><CENTER>$curOut</CENTER></TD>");
        }
        printf(OUT "    ");

        printf(OUT "<TD><CENTER><A HREF=${theRouter}\.html>$theRouter</A></CENTER></TD></TR><p>\n");

}

&PrintTail;
close(OUT);

sub by_bytes {
        $printList{$b} <=> $printList{$a};
}

sub PrintHead
{
$expTime=&expistr;

print OUT <<EOF;
<HTML>
<HEAD>
<TITLE>$orgName Yearly Statistics for Network Equipment Interfaces</TITLE>
</HEAD>
<META HTTP-EQUIV="Expires" CONTENT="$expTime">
<META HTTP-EQUIV="Refresh" CONTENT=$refreshSeconds>
<BODY bgcolor=$WHITEcolor>
<H1>All monitored interfaces sorted by the most active ones during the year as of $theDate</H1>
<P> The following are sorted by the sum of the yearly average input
and yearly average output (In average B/s + Out average B/s) interface octets. 
This table is updated every $refreshInt minutes and will automatically 
be updated if you are using a Mozilla compatible browser.<P>

<B>Value ranges: </B><P>
<TABLE WIDTH="50%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="43">
<TD BGCOLOR=$REDcolor><B>RED if \> $maxRED </B></TD> 
<TD BGCOLOR=$AMBERcolor><B>YELLOW if \> $maxAMBER </B></TD></B><P>
<TD BGCOLOR=$GREENcolor><B>GREEN if \< $maxAMBER </B></TD>
<TD BGCOLOR=$BLACKcolor><FONT COLOR=$WHITEcolor><B> BLACK if = 0 </B></TD>
</TABLE>
<P>
<BR>
<TABLE WIDTH="100%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="43">
<TR>
<TH >In Max B/s</TH>
<TH >Out Max B/s</TH>
<TH >In Avg B/s</TH>
<TH >Out Avg B/s</TH>
<TH >In Current B/s</TH>
<TH >Out Current B/s</TH>
<TH >Interface</TH></TR>
<P>
EOF
}

sub PrintTail
{
print OUT <<EOF;
</TABLE>
</BODY>
</HTML>
EOF
}

sub expistr {
  my ($time) = time+$refreshInt*60+5;
  my ($wday) = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[(gmtime($time))[6]];
  my ($month) = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep',
                 'Oct','Nov','Dec')[(gmtime($time))[4]];
  my ($mday,$year,$hour,$min,$sec) = (gmtime($time))[3,5,2,1,0];
  if ($mday<10) {$mday = "0$mday"};
  if ($hour<10) {$hour = "0$hour"};
  if ($min<10) {$min = "0$min";}
  if ($sec<10) {$sec = "0$sec";}
  return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
}
