// getPerformanceCounter.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "perfmon.h"

int _tmain(int argc, _TCHAR* argv[])
{
	
	if (argc<1)
	{	
		printf("No Counter specified!\n");
		return -999999;
	}
	
	CPerfMon m_PerfMon;

	if ((argc!=1) && (!m_PerfMon.Initialize()))
	{	
		printf("-2\n");
		return -2;
	}

	int m_nCounter = m_PerfMon.AddCounter(argv[1]);
		
	if (m_nCounter!=0)
	{	
		printf("-3\n");
		return -3;
	}
	
	if (!m_PerfMon.CollectQueryData())
	{
		printf("-1\n");
		return -1;
	}	
	long v_nCounter = m_PerfMon.GetCounterValue(m_nCounter);
	
	if (!m_PerfMon.CollectQueryData())
	{
		printf("-1\n");
		return -1;
	}	
	
	v_nCounter = m_PerfMon.GetCounterValue(m_nCounter);
	printf("%d\n%d\n\n\n",v_nCounter,v_nCounter);

	m_PerfMon.Uninitialize();
	return 0;
}

