#!/usr/bin/perl

# ============================================================================
# Memory Usage script for mrtg
#
#    File:    memmon.pl
#    Author:  Erwin Horjus | erwin.horjus@virgil.nl
#    Version: 1.0
#
#    Date:    24/6/2003
#    Purpose: This script reports memory and swap usage in percentages to mrtg
#
#    Usage:   memmon.pl
#
#    Info:    Designed on Solaris 8 and 9, AIX 4.3 and 5.1 and RedHat 7.3
#             with perl version 5.6.1. For Solaris 9 you need to install the
#             package SUNWaccu and eventually patch 113716-01 if sar doesn't
#             show the Average line when running the sar command below in the
#             SunOS section.
#
#    How it works:
#
#       First the script figures out which operating system is
#       used and then it runs memory and swap commando's on the local
#       machine, calculates percentages used and prints those
#       values to standard output. The script also displays uptime and
#       the hostname.
#
#       Check the readme to use this script in combination with
#       memmon_get.pl. You'll be able to collect and publish all
#       data on a single machine.
#
#    History:
#              24/6/2003 - Initial build by Erwin Horjus
#
# ============================================================================

chop($os=`uname -s`);

# Validate the os
SWITCH:
{
  if ($os =~ /^SunOS$/){last SWITCH;}
  if ($os =~ /^AIX$/){last SWITCH;}
  if ($os =~ /^Linux$/){last SWITCH;}

  # DEFAULT: Die if we can't figure out what the os is
  die "Can't figure out which OS the machine is.\n";
}

$getuptime = `uptime`;

# Execute the appropriate subroutine based on the os
&$os;

print `hostname`;

exit(0);

#=======================================================
# Subroutines: names of subroutines are supported OSs.
#========================================================
sub SunOS {

    $vmstat=`vmstat 1 2 | tail -1`;
    $swap = `swap -s`;
    $mem = `prtconf | grep Memory`;

    # Format total physical memory
    $mem =~ /^Memory\s+size:\s+(\d+)\s+/;
    $mem_total = $1 * 1024;

    # Format free memory
    $vmstat =~ /^\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+/;
    $mem_free = $5;

    # Calculate and format percentage used memory
    $mem_used_perc = (($mem_total - $mem_free) / $mem_total) * 100;
    printf '%.1f', $mem_used_perc;
    print "\n";

    # Calculate used swap space
    $swap =~ /^total:\s+(\w+)\s+bytes\s+allocated\s+\+\s(\w+)\s+reserved\s+\=\s+(\w+)\s+used,\s+(\w+)\s+/;
    chop($swap_used = $3);
    chop($swap_available = $4);
    $swap_total= $swap_used + $swap_available;
    $swap_used_perc = ($swap_used / $swap_total) * 100;
    printf '%.1f', $swap_used_perc;
    print "\n";

    # Print getuptime data for mrtg
    $getuptime =~ /^\s+\d{1,2}:\d{2}..\s+up\s+(\d+)\s+(......),/;
    print $1." ".$2."\n";
}

sub AIX {

    # Real memory
    $mem=`svmon -G | grep memory`;
    $mem =~ /^memory\s+(\d+)\s+(\d+)/;
    $mem_used_perc = ($2 * 100) / $1;
    printf '%.1f', $mem_used_perc;
    print "\n";

    # Paging space
    $paging=`lsps -s | tail -1`;
    $paging =~ /^\s+(\w+)\s+(\w+)/;
    print "$2\n"; # percentage paging used

    # Uptime
    $getuptime =~ /^\s+(\d+):(\d+)(\w+)\s+up\s+(\d+)\s+(\w+)/;
    print $4." ".$5."\n";
}

sub Linux {

    # Real memory
    $mem = `free | grep Mem`;
    $mem =~ /^Mem:\s+(\d+)\s+(\d+)/;
    $mem_used_perc = ($2 * 100) / $1;
    printf '%.1f', $mem_used_perc;
    print "\n";

    # Swap
    $swap = `free | grep Swap`;
    $swap =~ /^Swap:\s+(\d+)\s+(\d+)/;
    $swap_used_perc = ($2 * 100) / $1;
    printf '%.1f', $swap_used_perc;
    print "\n";

    # Uptime
    $getuptime =~ /^\s+\d{1,2}:\d{2}..\s+up\s+(\d+)\s+(\w+),/;
    print $1." ".$2."\n";
}
