#! /opt2/bin/perl -w
#Standard Perl Call
#created by ibgm 1998 for RA/SL
###############################

# parses mrtg-cfg-files and puts the entries into STDOUT
# v0.02 ibgm 05/14/98
#----------------------------------------------------------------------------
$SPACE = "                                                               ";

#open file specified in ARGV[0] in a filehandle, 
print "Content-type: text/plain \n\n";



if ($ARGV[0]) {
	open (FILE, $ARGV[0]) or die "Couldn't open file $ARGV[0], stopped";
}



else {
	&ReadParse;
	if ($in{FILE}) { 
		# read the file	
		open (FILE, $in{FILE}) or die "Couldn't open file $in{FILE}, stopped";
	
	}
	elsif ($in{DEVICE}) {
		# fire up cfgmaker
		# specify here the correct location of cfgmaker. 
		# Maybe you want to place  cfgmaker in the same directory as this script.

		open FILE, "/opt/mrtg/cfgmaker $in{DEVICE} |" or die "fork failed: $?";
	}
	# Parsing STDIN is disabled 
	# else { FILE = \*STDIN;
	# }
	
}
 
parse(\*FILE);


sub parse {
	#looks for entries
	my $fileHandle = shift;
	# parse file for entries, put them into hash
	# hash format: $data{$target}{$option} = $value;

	LINE: while ($_ = <$fileHandle>) {
	
		#Take out any Comments

		# Workdir etc
 		$r = "#";
		if (/.*?WorkDir: (.+)/) {
			print "WorkDir==$1\n";
			next LINE;

		}

		elsif (/.*?IconDir: (.+)/) {
			print "IconDir==$1\n";
			next LINE;

		}

		elsif (/.*?Refresh: (.+)/) {
			print "Refresh==$1\n";
			next LINE;

		}

		elsif (/.*?Interval: (.+)/) {
			print "Interval==$1\n";
			next LINE;

		}



		if (/^# Date\[(.+?)\]: (.+)/) {    
			$data{$1}{Date} = $2;
			next LINE;
		}

		elsif (/^# Creator\[(.+?)\]: (.+)/) {    
			$data{$1}{Creator} = $2;

			next LINE;
		}
	
		elsif (/^# Comment\[(.+?)\]: (.*)/) {    
			$data{$1}{Comment} = $2;
			next LINE;
		}

		next LINE if /^#/; #omit Comment lines

		# if it's a target line, we have to slurp in the port, interface etc as well
		if (/Target\[(.+?)\]: (\d+?):(\w+?)\@(.+?)$/) {    
			$data{$1}{Port} = $2;
			$data{$1}{Community} = $3;
			$data{$1}{Address} = $4;
			next LINE;
		}
		# or maybe it's a target line with a OID?
		elsif (/Target\[(.+?)\]: (.+)\.(\d{1,3})&(.+?)\.\3:(\w+?)\@(.+)/) {    
			$data{$1}{Port} = $3;
			$data{$1}{Address} = $6;
			$data{$1}{Community} = $5;
			$data{$1}{OID1} = $2;
			$data{$1}{OID2} = $4;
			next LINE;
		}
		# if it's a target line here, it is of a special format: we put everything into address
		elsif (/Target\[(.+?)\]:(.*?)$/) {    
			$data{$1}{Address} = $2;
			next LINE;
		}

		# if it's a PageTop line, we have to treat it especially
		elsif (/^PageTop\[(.+?)\]: <H1>(.+?)(<|$)/) {   

			$target = $1;
			$data{$target}{PageTopTitle} = $2;
			next LINE;
		}
	
		# look for the System entry...
		elsif (/.+?System:<\/TD><TD>(.+?)<\/TD/) {
			$data{$target}{System} = $1;
			next LINE;
		}
	
		#... the Maintainer ...
		elsif (/.+?Maintainer:<\/TD><TD>(.+?)<\/TD/) {
			$data{$target}{Maintainer} = $1;
			next LINE;
		}
	
		# ... the interface...
		elsif (/.+?Interface:<\/TD><TD>(.+?)<\/TD/) {
			$data{$target}{Interface} = $1;
			next LINE;
		}
		
		# ... and the IP of the interface...
		elsif (/.+?IP:<\/TD><TD>(.+?)<\/TD>/) {
			$data{$target}{IP} = $1;
			next LINE;
		}

		# ... finally the MaxSpeed, we have to visit the next line as well
		elsif (/.+<TD>(.+?)<\/TD><\/TR>/) {
			$data{$target}{MaxSpeed} = $1;
			next LINE;
		}

		# looks at every entry

		elsif (/(.+?)\[(.+?)\]:(.+)/) {   
			$data{$2}{$1} = $3;
			next LINE;
		}
	

	} #end of while


	# so let's print it...


	foreach $target (reverse sort keys %data) {
		print "Target==$target \n";
		foreach $option (sort keys %{$data{$target}}){
			print "$option==$data{$target}{$option} \n";
		}
	}
}







#######################################################################################
# Adapted from cgi-lib.pl by S.E.Brenner@bioc.cam.ac.uk 
# Copyright 1994 Steven E. Brenner (slightly changed by ibgm)

# Reads the cgi imput
sub ReadParse {
	local (*in) = @_ if @_;
	local ($i, $key, $val);
        
         
		# Format for POST: DEVICE=hostname or FILE=url

	if ( $ENV{'REQUEST_METHOD'} eq "GET" ) { 
		print STDERR "GET";
		$in = $ENV{'QUERY_STRING'}; 
	} elsif ($ENV{'REQUEST_METHOD'} eq "POST") {
		print STDERR "POST";
		read(STDIN,$in,$ENV{'CONTENT_LENGTH'});
	}
                
	@in = split(/&/,$in);
                
	foreach $i (0 .. $#in) {
	
                # Convert plus's to equals
		$in[$i] =~ s/\&/=/g;

		 # Convert%2F to/ (Mikado effect)
		$in[$i] =~ s/\%2F/\//g;

                
		# Split into key and value.
		($key, $val) = split(/=/,$in[$i],2); # splits on the first =.
                
	                
		# Associate key and value. \0 is the multiple separator
		#$in{$key} .= "\0" if (defined($in{$key})); 
		$in{$key} .= $val;
	}
	return length($in);
}  

sub maximum {
	my $max = 0;
	foreach $foo (@_) {
		$foo_len = length($foo);
		$max = $foo_len if $max < $foo_len;
	}
	return $max;
}

sub space {
	my $i = shift(@_);
	substr $SPACE, 0, $i;
}
