package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.awt.event.*;

/** class to import only some interfaces of a device. This can be important if the device is a big router 
 *  and we only want to import maybe one or two interfaces.
 *
 * @author 	Michael Grob for RA/SL
 * @version 	1.01 09/04/98
 */
public class ImportTarget extends MC2 { 

	protected MC2 m;
	protected ImportTarget c;

	/** Constructor that overwrites the constructor in MC2. It doesn't uses all of the GUI components of MC2.
	 *
	 * @param title		String with the window title
	 * @param m		MC2 Object that called me
	 */
	public ImportTarget (String title, MC2 m) {

		this.super(title);

		// create the objects
		this.m = m;
		this.c = this;
		delete_target = new Button("Close");
		Button all = new Button ("Import All");

		// Well, I know, not the best programming style, but I wanted to reuse the buttons intended for other purposes --
		// I had to implement this class fast, so it's just a quick & dirty hack. But it works.

		check_port = new Button("Import Target");
		message = new Label("Select the interface you want to import.                      ");
		GridBagLayout gridbag = new GridBagLayout();

		// create a list with 10 lines
		Font f = new Font("Courier",Font.PLAIN, 12);
		target_list = new List(10);
		target_list.setFont(f);
		target_list.addItem("No Target selected.", 0);	
		list_title = new Label("Target Name       Address       Interface      IP                                                      Port      ");  
		list_title.setFont(f);
		message = new Label("Communicating with interface, please wait...                                                ");

		// create the panel
		// use gridbag for it
		p = new Panel(); 
		p.setLayout(gridbag);
		this.setBackground(Color.lightGray);
		// Entry Components
		AWTHelper.constrain(p, list_title, 0,1,3,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, target_list, 0,2,3,1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0,1.0,0,0,0,0);
		AWTHelper.constrain(p, message, 0,3,3,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, check_port, 0,4,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, all, 1,4,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, delete_target, 2,4,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHEAST, 0.0,0.0,0,0,0,0);
		this.setLayout(gridbag); 
		AWTHelper.constrain(this, p, 1,1,1,1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0,1.0,10,10,10,10);

		// listeners
		target_list.addActionListener(new MyEditHandler());
		target_list.addItemListener(new MyListSelectHandler());
		this.addWindowListener(new MyWindowHandler());
		delete_target.addActionListener(new MyCloseHandler());
		check_port.addActionListener(new MyCheckHandler());
		all.addActionListener(new MyAllHandler());
	}


	/** puts the targets of the Cfg file into the list.
	*/
	protected void putIntoList(){
		String s;
		String Space = "                                                                                                                  ";
		this.target_list.removeAll();

		// put values into the text fields

		for(int i = 0; i<file.getNumberOfTargets(); i++) 	{

			// put the line together
			String t = this.file.getValue(i, "Target");
			String a = this.file.getValue(i, "Address");
			String in = this.file.getValue(i, "Interface");
			String ip = this.file.getValue(i,"IP");
			String p = this.file.getValue(i, "Port");
	
			if (t.length() > 15) {
				s = t.substring(0,13) + "..  ";
			}
			else { 
				s = t+ Space.substring(0, 17 - t.length());
			}

			if (a.length() > 13) {
				s += a.substring(0,11) + "..  ";
			}
			else { 
				s += a + Space.substring(0, 15 - a.length());
			}

			if (in.length() > 12) {
				s += in.substring(0,10) + "..  ";
			}
			else { 
					s += in + Space.substring(0, 14 - in.length());
			}
			if (ip.length() > 50) {
				s += ip.substring(0,48) + "..  ";
			}
			else { 
				s += ip + Space.substring(0, 51 - ip.length());
			}
			if (p.length() > 4) {
				s += p.substring(0,2) + "..";
			}
			else { 
				s += Space.substring(0, 8 - p.length()) + p;
			}
			target_list.addItem(s);
		
		}
	}


//------------------------------------- INNER CLASSES FOR HANDLING THE EVENTS ------------------------

	/** Inner class for handling the double/click on the list
	 */
	class MyEditHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {

			m.current = m.file.addTarget((Target) c.file.Targets.elementAt(current));
			m.putIntoList();
		}
	}


	/** Inner class for the close button
	 */
	class MyCloseHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			c.setVisible(false);
			c.dispose();
		}
	}


	/** Inner class for handling the Item event event -- list_select.
	 */
	class MyListSelectHandler implements ItemListener {

		public void itemStateChanged(ItemEvent e) {
			c.current = (target_list.getSelectedIndex());
		}
	}


	/** Inner class for selecting a target and put it into MC2.
	 */
	class MyCheckHandler implements ActionListener{

		public void actionPerformed(ActionEvent e) {

			m.current = m.file.addTarget((Target) c.file.Targets.elementAt(current));
			m.putIntoList();
		}
	}

	/** Inner class for importing all Targets 
	 */
	class MyAllHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			int i;
			for (i =0; i < c.file.getNumberOfTargets(); i++) {
					m.current = m.file.addTarget((Target) c.file.Targets.elementAt(i));
			}
			m.putIntoList();
			m.target_list.select(current);
			c.setVisible(false);
			c.dispose();
		}
	}


	/** Inner class for handling the window close event.
	 */
	class MyWindowHandler extends WindowAdapter {

		public void windowClosing(WindowEvent e) {
			c.setVisible(false);
			c.dispose();
		}
	}
}
