package ch.swisslife.ibgm.mc2;
import java.awt.*;
/** Data structure for one target
 * It has several fields for the entries and a setValue and a getValue method to access it.
 * 
 * @author 	Michael Grob for RA/SL
 * @version 	1.01, /09/04/98
*/
public class Target extends Object implements java.lang.Cloneable {

	// data structures:

	private String target =""; 
	private String OID1 =""; 
	private String OID2 =""; 
	private String port =""; 
	private String community =""; 
	private String address =""; 

	private String page_top_title =""; 
	private String Interface = ""; 
	private String IP =""; 
	private String maintainer =""; 
	private String system =" "; 
	private String max_speed =""; 

	private String title =""; 
	private String abs_max =""; 
	private String max_bytes =""; 
	private String x_size ="";
	private String y_size ="";

	private String options =""; 	// bits, absolute, gauge etc seperated by ","
	private String unscaled ="";	// looks like dwny 
	private String with_peak ="";	// dito
	private String colours="";	// dito

	private String y_legend =""; 
	private String short_legend =""; 
	private String legend_1 =""; 
	private String legend_2 =""; 
	private String legend_3 =""; 
	private String legend_4 =""; 
	private String legend_i =""; 
	private String legend_o =""; 

	private String date =""; 
	private String creator =""; 
	private String comment =""; 
	
	/**Constructor with targetname. Inistatiates a new target and puts its name into it.
	 * 
	 * @param target	String with the name of the target
	 */
	public Target(String target) {
		this.super();
		this.target = target;
	}



	/** Makes a Copy of itself.
	 *
	 * @return Target with a copy of itself and all its structures.
	 */
	public Target copy(Target t) throws java.lang.CloneNotSupportedException {

		// copy all the strings
		t.target = new String(this.target);
		t.OID1 = new String(this.OID1);
		t.OID2 = new String(this.OID2);
		t.port = new String(this.port);
		t.community = new String(this.community);
		t.address = new String(this.address);
		t.page_top_title = new String(this.page_top_title);
		t.Interface = new String(this.Interface);
		t.IP = new String(this.IP);
		t.maintainer = new String(this.maintainer);
		t.system = new String(this.system);
		t.max_speed = new String(this.max_speed);
		t.title = new String(this.title);
		t.abs_max = new String(this.abs_max);
		t.max_bytes = new String(this.max_bytes);
		t.x_size = new String(this.x_size);
		t.y_size = new String(this.y_size);
		t.options = new String(this.options);
		t.unscaled = new String(this.unscaled);
		t.with_peak = new String(this.with_peak);
		t.colours = new String(this.colours);
		t.y_legend = new String(this.y_legend);
		t.short_legend = new String(this.short_legend);
		t.legend_1 = new String(this.legend_1);
		t.legend_2 = new String(this.legend_2);
		t.legend_3 = new String(this.legend_3);
		t.legend_4 = new String(this.legend_4);
		t.legend_i = new String(this.legend_i);
		t.legend_o = new String(this.legend_o);
		t.date =  new String(this.date);	
		t.creator = new String(this.creator);
		t.comment = new String(this.comment);

		return t;
	}


	/**  Gets the values. The Entry which will be returned must be specified.
	 *
	 * @param arg	String is the entry which will be given back.
 	 * @return	String is the value of the entry
	 */
	public String getValue(String arg) {
		// depending on what the arg is..
		
		if (arg.equals ("Target")) {
			return this.target;
		}
			
		else if (arg.equals ("OID1")) {
			return this.OID1;
		}
				
		else if (arg.equals ("OID2")) {
			return this.OID2;
		}
		
			
		else if (arg.equals ("Port")) {
			return this.port;
		}
				
		else if (arg.equals ("Community")) {
			return this.community;
		}
		
		else if (arg.equals ("Address")) {
			return this.address;
		}
				
		else if (arg.equals ("PageTopTitle")) {
			return this.page_top_title;
		}
				
		else if (arg.equals ("Interface")) {
			return this.Interface;
		}
				
		else if (arg.equals ("IP")) {
			return this.IP;
		}
				
		else if (arg.equals ("Maintainer")) {
			return this.maintainer;
		}
				
		else if (arg.equals ("System")) {
			return this.system;
		}
				
		else if (arg.equals ("MaxSpeed")) {
			return this.max_speed;
		}
				
		else if (arg.equals ("Title")) {
			return this.title;
		}
				
		else if (arg.equals ("AbsMax")) {
			return this.abs_max;
		}
				
		else if (arg.equals ("MaxBytes")) {
			return this.max_bytes;
		}
				
		else if (arg.equals ("XSize")) {
			return this.x_size;
		}
				
		else if (arg.equals ("YSize")) {
			return this.y_size;
		}
		
		else if (arg.equals ("Options")) {
			return this.options;
		}
		
		else if (arg.equals ("Unscaled")) {
			return this.unscaled;
		}
		
		else if (arg.equals ("WithPeak")) {
			return this.with_peak;
		}

		else if (arg.equals ("Colours")) {
			return this.colours;
		}

		else if (arg.equals ("YLegend")) {
			return this.y_legend;
		}
		
		else if (arg.equals ("ShortLegend")) {
			return this.short_legend;
		}
		
		else if (arg.equals ("Legend1")) {
			return this.legend_1;
		}

		else if (arg.equals ("Legend2")) {
			return this.legend_2;
		}

		else if (arg.equals ("Legend3")) {
			return this.legend_3;
		}

		else if (arg.equals ("Legend4")) {
			return this.legend_4;
		}

		else if (arg.equals ("LegendI")) {
			return this.legend_i;
		}

		else if (arg.equals ("LegendO")) {
			return this.legend_o;
		}

		else if (arg.equals ("Date")) {
			return this.date;
		}

		else if (arg.equals ("Creator")) {
			return this.creator;
		}

		else if (arg.equals ("Comment")) {
			return this.comment;
		}
		else {
			return "";
		}
	}
	
	/** Set the values of the entries. The entry must be specified.
	 *
	 * @param arg	String containig which entry
	 * @param value	String to be stored in the entry
	 * @return <code>true</code> if successful <code>false</code> otherwise
	 */
	public boolean setValue(String arg, String value) {
		// depending on what the arg is..
		
		if (arg.equals("Target")) {
			this.target = value;
			return true;
		}
			
		else if (arg.equals("OID1")) {
			this.OID1 = value;
			return true;
		}
				
		else if (arg.equals("OID2")) {
			this.OID2 = value;
			return true;
		}
		
			
		else if (arg.equals("Port")) {
			this.port = value;
			return true;
		}
				
		else if (arg.equals("Community")) {
			this.community = value;
			return true;
		}
		
			
		else if (arg.equals("Address")) {
			this.address = value;
			return true;
		}
				
		else if (arg.equals("PageTopTitle")) {
			this.page_top_title = value;
			return true;
		}
				
		else if (arg.equals("Interface")) {
			this.Interface = value;
			return true;
		}
				
		else if (arg.equals("IP")) {
			this.IP = value;
			return true;
		}
				
		else if (arg.equals("Maintainer")) {
			this.maintainer = value;
			return true;
		}
				
		else if (arg.equals("System")) {
			this.system = value;
			return true;
		}
				
		else if (arg.equals("MaxSpeed")) {
			this.max_speed = value;
			return true;
		}
				
		else if (arg.equals("Title")) {
			this.title = value;
			return true;
		}
				
		else if (arg.equals("AbsMax")) {
			this.abs_max = value;
			return true;
		}
				
		else if (arg.equals("MaxBytes")) {
			this.max_bytes = value;
			return true;
		}
				
		else if (arg.equals("XSize")) {
			this.x_size = value;
			return true;
		}
				
		else if (arg.equals("YSize")) {
			this.y_size = value;
			return true;
		}
		
		else if (arg.equals("Options")) {
			this.options = value;
			return true;
		}
		
		else if (arg.equals("Unscaled")) {
			this.unscaled = value;
			return true;
		}
		
		else if (arg.equals("WithPeak")) {
			this.with_peak = value;
			return true;
		}

		else if (arg.equals("Colours")) {
			this.colours = value;
			return true;
		}

		else if (arg.equals("YLegend")) {
			this.y_legend = value;
			return true;
		}
		
		else if (arg.equals("ShortLegend")) {
			this.short_legend = value;
			return true;
		}
		
		else if (arg.equals("Legend1")) {
			this.legend_1 = value;
			return true;
		}

		else if (arg.equals("Legend2")) {
			this.legend_2 = value;
			return true;
		}

		else if (arg.equals("Legend3")) {
			this.legend_3 = value;
			return true;
		}

		else if (arg.equals("Legend4")) {
			this.legend_4 = value;
			return true;
		}

		else if (arg.equals("LegendI")) {
			this.legend_i = value;
			return true;
		}

		else if (arg.equals("LegendO")) {
			this.legend_o = value;
			return true;
		}

		else if (arg.equals("Date")) {
			this.date = value;
			return true;
		}

		else if (arg.equals("Creator")) {
			this.creator = value;
			return true;
		}

		else if (arg.equals("Comment")) {
			this.comment = value;
			return true;
		}
		else {
			return false;
		}
	}
	
	/** Main Method: Only used for testing. Creates an Instance of itself and fills in some values.
	 * Note: Shouldn't be used in final version.
	 * @param argv	String[] containing the obligate argument vector'
	 */
	public static void main(String[] argv) {
		// tests the things
		
		Target test = new Target("testarget");
		if (test.setValue(argv[0], "test1")) {
			
			System.out.println (test.getValue(argv[0]));
		}
		else
		{	System.out.println("somethin' schief gelaufen");
		}
		
		if (test.setValue(argv[0], "test2")) {
			
			System.out.println (test.getValue(argv[0]));
		}
		else
		{	System.out.println("somethin' schief gelaufen");
		}
	}
}
