#!/usr/bin/python
#
# =====================================================================
# General Purpose SNMP retrieval for mrtg
#
#    File: 	mrtgcmd.py
#    Author: 	Lindsay Haisley <fmouse@fmp.com>
#    Version: 	1.0	
#
#    Date:	3/12/2002
#	
#    Purpose:   I've noticed that mrtg is strongly oriented toward retrieval
#		of traffic information from routers.  A great deal of other
#		numeric information is available from routers, servers and
#		hosts via SNMP which may be of interest to a system
#		administrator.  This script greatly simplifies the use of
#		mrtg in retrieving and graphing such data.
#		
#		This script requires python v1.5.2 or better and the SNMP 
#		modules for python (pysnmp) which can be found at
#		<http://sourceforge.net/projects/pysnmp/>.
#		
#		
#     Usage:	/path/to/mrtgcmd.py host community mib1 mib2 [mult1 [mult2]]
#     
#     		host, community	- as per standard SNMP usage
#     		
#     		mib1, mib2 	- These must be numeric MIB specs formatted
#     				  as python lists inside square brackets. 
#     				  See the included example mrtg
#     				  configuration, example.cfg.  The SNMP
#     				  resources identified must be numeric
#     				  values, either integer or decimal.
#     				  
#     		mult1, mult2	- If a value returned by SNMP is a
#     				  small decimal value, e.g. a system load
#     				  average figure, these multipliers may be
#     				  used scale it to a value more appropriate
#     				  for graphing by mrtg.
#     				  
#     				  The multipliers default to 1 if not
#     				  provided.  You must provide a value for
#     				  mult1 if you wish to specify mult2.
#
#    History:	3/12/2002 -  v1.0, original release
#
#    Example:	Please see the example script included, example.cfg
#

import sys
from pysnmp import session

host 		= sys.argv[1]
community	= sys.argv[2]

try:
	list1 		= eval(sys.argv[3])
	list2 		= eval(sys.argv[4])

except NameError:
	raise "ArgumentTypeError", "3rd and 4th args must be lists"

if (type(list1) != type([])) or (type(list2) != type([])):
	raise "ArgumentTypeError", "3rd and 4th args must be lists"

try:
	mult1 = sys.argv[5]
except IndexError:
	mult1 = "1"
	
try:
	mult2 = sys.argv[6]
except IndexError:
	mult2 = "1"

def getsnmpvalue(hst, com, oit):
	s = session.session (hst, com)
	encoded_objid = s.encode_oid (oit)
	question = s.encode_request ('GETREQUEST', [encoded_objid], [])
	answer = s.send_and_receive (question)
	(encoded_objids, encoded_values) = s.decode_response (answer)
	objids = map (s.decode_value, encoded_objids)
	values = map (s.decode_value, encoded_values)
	return(values[0])
	
# mrtg requires 
# item 1
# item 2
# uptime
# machine name

print float(getsnmpvalue(host, community, list1)) * int(mult1)
print float(getsnmpvalue(host, community, list2)) * int(mult2)

# print uptime
uptime = getsnmpvalue(host, community, [1,3,6,1,2,1,1,3,0])
days = uptime / 8640000
hours = (uptime % 8640000) / 360000
minutes = ((uptime % 8640000) % 360000) / 6000
seconds = float(((uptime % 8640000) % 360000) % 6000) / 100
print "%d days, %02d:%02d:%02.2f" % (days, hours, minutes, seconds)

# print system name
print host
