/* Declaration of types and global variables...
   Parameters are read from the config file in the same format as mrtg.cfg.
   L. Derrien 19/08/99
   Update LD  17/10/00 New structure netmap
   Update LD  14/02/01 Add grapher in netmap struct...
*/ 

#ifndef _CFG_H_
#define _CFG_H_	

/* You should be able to change the number of levels... */
#define NLEVEL 10

#define VERSION "1.2"

typedef unsigned char byte;

typedef struct {
	byte r, g, b;
	} color;

typedef struct cfgentry {
        char ifname[80];
	struct netmap *submap;
        int rounds;
        int ColorIdx, ColorIdxIn, ColorIdxOut;
        int MaxRate, MaxRateIn, MaxRateOut;
        struct cfgentry *nextcfg;
        } cfgentry;
        
typedef struct htmlarea {
	int areatyp;
	char nameref[40];
	char areastr[70];
	struct htmlarea* nextarea;
} htmlarea;

typedef struct netmap {
	char name[40];
	char WDir[80];
	int refresh;
	char pngin[50];
	char pngout[50];
	char grapher[80];
	char HtmlFile[50];
	char HtmlTitle[100];
	char HtmlPageHeader[100];
	char areasdef[50];
	htmlarea *LAreas;
	int level[256];
	cfgentry *LCfgEntry;	
	int globval;
	struct netmap *nextmap;
	} netmap;

netmap *LMap;

color levcolor[NLEVEL];

/* Free the LCfgEntry of a netmap */
void FreeLCfg(netmap *);

/* Free LMap */
void FreeLMap();

/* Create a structure with all the interesting infos in the config file   */
/* The config file use the same format as mrtg.cfg (it could be mrtg.cfg) */
int loadcfg(char *);

#endif