/* Creation of a PNG Image from a reference PNG Image replacing many colors
   by other colors depending on the traffic rate on interfaces.
   Parameters are read from the config file in the same format as mrtg.cfg.
   L. Derrien 19/8/99
   Update. LD 13/10/00
*/

#include <stdio.h>
#include <string.h>

/* BSDI 2.0.1 does not have malloc.h */
#if !defined(bsdi) && !defined(__FreeBSD__) && !defined(__OpenBSD__)
#include <malloc.h>
#endif

/* WATCOM C/C++ 10.6 under Win95/NT */
/* VC++ 6.0 under Win95/NT */
#if defined(__WATCOMC__) || defined(WIN32)
#include <sys\types.h>
#include <direct.h>
#include <io.h>
#endif

#include "def.h"

/* Add a new htmlarea on the top of LAreas for netmap NetM */
int NewHtmlArea(netmap *NetM)
{
  htmlarea *ptr;

  if ((ptr=(htmlarea *)malloc(sizeof(htmlarea))) == NULL) {
        fprintf(stderr, "Not enough memory.\n");
        exit(1);
  }
  ptr->nextarea = NetM->LAreas;
  NetM->LAreas = ptr;
  return(1);
}

/* Add a new entry on the top of LCfgEntry for netmap NetM */
int NewCfgEntry(netmap *NetM)
{
  cfgentry *ptr;

  if ((ptr=(cfgentry *)malloc(sizeof(cfgentry))) == NULL) {
        fprintf(stderr, "Not enough memory.\n");
        exit(1);
  }
  ptr->nextcfg = NetM->LCfgEntry;
  NetM->LCfgEntry = ptr;
  ptr->submap = NULL;
  ptr->ColorIdx = ptr->ColorIdxIn = ptr->ColorIdxOut = -1;
  ptr->MaxRate  = ptr->MaxRateIn  = ptr->MaxRateOut  = -1;
  ptr->rounds = 1;
  return(1);
}

/* Add a new entry on the top of LMap */
int NewNetMap()
{
  netmap *ptr;

  if ((ptr=(netmap *)malloc(sizeof(netmap))) == NULL) {
        fprintf(stderr, "Not enough memory for netmap structure.\n");
        exit(1);
  }
  ptr->nextmap = LMap;
  LMap = ptr;

  /* default values */
  strncpy(ptr->WDir, DefWDir, 80);
  strncpy(ptr->grapher, DefGrapher, 80);
  ptr->HtmlTitle[0] = ptr->HtmlPageHeader[0] = ptr->pngin[0] = '\0';
  ptr->refresh = Defrefresh;
  ptr->globval = -1;
  ptr->LAreas = NULL;
  ptr->LCfgEntry = NULL;
  return(1);
}

/* Free LAreas for the netmap NetM */
void FreeLAreas(netmap *NetM)
{
  htmlarea *ptr;
  
  while (ptr = NetM->LAreas) {
    NetM->LAreas = ptr->nextarea;
    free(ptr);
  }
}

/* Free LCfgEntry for the netmap NetM */
void FreeLCfg(netmap *NetM)
{
  cfgentry *ptr;
  
  while (ptr = NetM->LCfgEntry) {
    NetM->LCfgEntry = ptr->nextcfg;
    free(ptr);
  }
}

/* Free LMap */
void FreeLMap()
{
  netmap *ptr;
  
  while (ptr = LMap) {
    LMap = ptr->nextmap;
    FreeLCfg(ptr);
    FreeLAreas(ptr);
    free(ptr);
  }
}

/* Looking for a LCfgEntry element of netmap NetM */
/* which interface name is str */
/* If not found, we create a new one... */
cfgentry *getCfgIF(netmap *NetM, char *str)
{
  cfgentry *ptr;
  
  ptr = NetM->LCfgEntry;
  
  while (ptr && strcmp(ptr->ifname, str)!=0)
    ptr = ptr->nextcfg;
  if (!ptr) { 
  	NewCfgEntry(NetM); 
  	strncpy(NetM->LCfgEntry->ifname, str, 80); 
  	return(NetM->LCfgEntry); 
  }
  return(ptr);
}

/* Looking for a netmap element which name is str */
/* If not found, we create a new one... */
netmap *getNetMap(char *str)
{
  netmap *ptr = LMap;
    
  while (ptr && strcmp(ptr->name, str)!=0)
    ptr = ptr->nextmap;
  if (!ptr) { 
  	NewNetMap(); 
  	strncpy(LMap->name, str, 40); 
	/* Default file names */
	strncpy(LMap->HtmlFile, str, 40); strcat(LMap->HtmlFile, ".html");
	strncpy(LMap->pngout, str, 40); strcat(LMap->pngout, ".png");
  	return(LMap); 
  }
  return(ptr);
}


/* Create a structure with all the interesting infos in the config file   */
/* The config file use the same format as mrtg.cfg (it could be mrtg.cfg) */
int loadcfg(char *file) 
{
  int iav, lev, precdefmap=0;
  char cfgline[90], ifn[40], cfglold[40]="";
  char *str, *strprm;
  FILE *fp;
  cfgentry *ptr;
  netmap *CurNetMap;
  
  if ((fp = fopen(file, "r")) == NULL) {
  	fprintf(stderr, "Error opening the config file %s\n", file);
  	return(0);
  }

  while (fgets(cfgline, 80, fp)) {

     /* skip comments */
     if (cfgline[0]=='#' || cfgline[0]==' ') continue;
     
     /* creating or looking for the right netmap */
     
     if (strprm=strchr(cfgline, '*')) {
	  strprm[0]='\0'; strprm++;
	  if (precdefmap || strcmp(cfglold, cfgline) != 0) {
	  	CurNetMap = getNetMap(cfgline);
	  	precdefmap = 0; strcpy(cfglold, cfgline);
	  }
     }
     else { /* one default netmap... */
	  strprm = cfgline;
	  if (!precdefmap) {
	  	CurNetMap = getNetMap(DefMapName);
	  	precdefmap = 1;
	  }
     }

/* printf("CurNetmap : %s\n", CurNetMap->name); */

     /* Analyze of config parameters... */
     if (str=strtok(strprm, "[]: \n")) {
          if (strcmp(str, "ColorIdx")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		if (str=strtok(NULL, "[]: \n"))
        			ptr->ColorIdx = atoi(str);
        	}
          }
          else if (strcmp(str, "ColorIdxIn")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		if (str=strtok(NULL, "[]: \n"))
        			ptr->ColorIdxIn = atoi(str);
        	}
          }
          else if (strcmp(str, "ColorIdxOut")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		if (str=strtok(NULL, "[]: \n"))
        			ptr->ColorIdxOut = atoi(str);
        	}
          }
          else if (strcmp(str, "MaxRate")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		if (str=strtok(NULL, "[]: \n")) {
        			ptr->MaxRate = atoi(str);
        			if ((str=strtok(NULL, "[]: \n")) &&
        					strcmp(str, "bps")==0)
        				ptr->MaxRate /= 8;
        		}
        	}
          }
          else if (strcmp(str, "MaxRateIn")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		if (str=strtok(NULL, "[]: \n")) {
        			ptr->MaxRateIn = atoi(str);
        			if ((str=strtok(NULL, "[]: \n")) &&
        					strcmp(str, "bps")==0)
        				ptr->MaxRateIn /= 8;
        		}
        	}
          }
          else if (strcmp(str, "MaxRateOut")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		if (str=strtok(NULL, "[]: \n")) {
        			ptr->MaxRateOut = atoi(str);
        			if ((str=strtok(NULL, "[]: \n")) &&
        					strcmp(str, "bps")==0)
        				ptr->MaxRateOut /= 8;
        		}
        	}
          }
          else if (strcmp(str, "Rounds")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		if (str=strtok(NULL, "[]: \n"))
        			ptr->rounds = atoi(str);
        	}
          }
          else if (strcmp(str, "MapRect")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        	    	strncpy(ifn, str, 40);
        	    	if ((str=strtok(NULL, ":\n"))) {
        	    	   NewHtmlArea(CurNetMap);
        	    	   CurNetMap->LAreas->areatyp = 1;
        	    	   strncpy(CurNetMap->LAreas->nameref, ifn, 40);
        	    	   strncpy(CurNetMap->LAreas->areastr, str, 70);
        	    	}
       		}
          }
          else if (strcmp(str, "MapPoly")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        	    	strncpy(ifn, str, 40);
        	    	if ((str=strtok(NULL, ":\n"))) {
        	    	   NewHtmlArea(CurNetMap);
        	    	   CurNetMap->LAreas->areatyp = 0;
        	    	   strncpy(CurNetMap->LAreas->nameref, ifn, 40);
        	    	   strncpy(CurNetMap->LAreas->areastr, str, 70);
        	    	}
        	}
          }
          else if (strcmp(str, "MapColorIdx")==0) {
        	if (str=strtok(NULL, "[]: \n")) {
        		ptr = getCfgIF(CurNetMap,str);
        		ptr->submap = getNetMap(str);
        		if (str=strtok(NULL, "[]: \n"))
        			ptr->ColorIdx = atoi(str);
        	}
	  }
          else if (strcmp(str, "WorkDir")==0) {
        	if (str=strtok(NULL, ": \n")) {
			strncpy(CurNetMap->WDir, str, 80);
                        /* for Win32 */
                        if (str=strtok(NULL, ":\n")) {
                                strcat(CurNetMap->WDir, ":");
                                strcat(CurNetMap->WDir, str);
                        }                                                                                                                                 
        		if (strcmp(CurNetMap->name, DefMapName)==0) 
				strncpy(DefWDir, CurNetMap->WDir, 80);
		}
	  }
          else if (strcmp(str, "Grapher")==0) {
        	if (str=strtok(NULL, ": \n")) {
			strncpy(CurNetMap->grapher, str, 80);
                        /* for Win32 */
                        if (str=strtok(NULL, ":\n")) {
                                strcat(CurNetMap->grapher, ":");
                                strcat(CurNetMap->grapher, str);
                        }                                                                                                                                 
        		if (strcmp(CurNetMap->name, DefMapName)==0) 
				strncpy(DefGrapher, CurNetMap->grapher, 80);
		}
	  }
          else if (strcmp(str, "Refresh")==0) {
        	if (str=strtok(NULL, ": \n")) {
			CurNetMap->refresh=atoi(str);
        		if (strcmp(CurNetMap->name, DefMapName)==0) 
				Defrefresh=CurNetMap->refresh;
		}
	  }
          else if (strcmp(str, "ImageRef")==0) {
        	if (str=strtok(NULL, ": \n"))
			strncpy(CurNetMap->pngin, str, 50);
	  }
          else if (strcmp(str, "ImageNet")==0) {
        	if (str=strtok(NULL, ": \n"))
			strncpy(CurNetMap->pngout, str, 50);
	  }
          else if (strcmp(str, "HtmlTitle")==0) {
        	if (str=strtok(NULL, ":\n"))
			strncpy(CurNetMap->HtmlTitle, str, 100);
	  }
          else if (strcmp(str, "HtmlPageHeader")==0) {
        	if (str=strtok(NULL, ":\n"))
			strncpy(CurNetMap->HtmlPageHeader, str, 100);
	  }
	  else if (strcmp(str, "HtmlAreasDef")==0) {
        	if (str=strtok(NULL, ": \n"))
			strncpy(CurNetMap->areasdef, str, 50);
	  }
     }
  }
  fclose(fp);
  return(1);
}
