#!/bin/sh

HOSTNAME="myHost (myIP)"
WORKDIR="/usr/local/mrtg/net"
WEBDIR="$WORKDIR/net-stat-html"
FPING="/usr/sbin/fping"
ICONDIR="/mrtg/"
INTERVAL=5
HOST_TIMEOUT=500
MRTG_EXEC="/usr/bin/mrtg"
MAINTAINER="<a href="mailto:pdan@extreme.ro">Dan Podeanu</a>"

function usage () {
	echo "Usage: $0 <hostname>:<ip> .."

	exit
}

if [ "$1" = "" ]; then
	usage
fi

echo "Generating config files:"
echo
echo "Configuring with workdir: $WORKDIR"
echo "Configuring with webdir: $WEBDIR"
echo "Configuring with fping: $FPING"
echo "Configuring with icondir: $ICONDIR"
echo "Configuring with refresh interval: $INTERVAL"
echo "Configuring with host timeout: $HOST_TIMEOUT"
echo ".. don't forget to update corresponding values in $WORKDIR/net.sh"
echo

if [ ! -x $FPING ]; then
	echo "Please modify this script and set FPING to the path to fping."
	echo "(or look into the README file)"
	exit
fi

if [ -s $WORKDIR/mrtg-run.sh ]; then
	echo "Creating backup of mrtg-run file into $WORKDIR/mrtg-run.sh.old"
	mv -f $WORKDIR/mrtg-run.sh $WORKDIR/mrtg-run.sh.old
	chmod -x $WORKDIR/mrtg-run.sh.old
fi
rm -f $WORKDIR/mrtg-run.sh
if [ -s $WORKDIR/add-hosts.sh ]; then
	echo "Creating backup of add hosts file into $WORKDIR/add-hosts.sh.old"
	mv -f $WORKDIR/add-hosts.sh $WORKDIR/add-hosts.sh.old
	chmod -x $WORKDIR/add-hosts.sh.old
fi
rm -f $WORKDIR/add-hosts.sh
if [ -s $WEBDIR/index.html ]; then
	echo "Creating backup of index file into $WEBDIR/index.html.old"
	mv -f $WEBDIR/index.html $WEBDIR/index.html.old
fi
rm -f $WEBDIR/index.html

if [ ! -d $WEBDIR ]; then
	echo "Creating web directory $WEBDIR"
	mkdir -p $WEBDIR
fi

echo "<html>"						>> $WEBDIR/index.html
echo "  <head>"						>> $WEBDIR/index.html
echo "    <title> Network statistics </title>"		>> $WEBDIR/index.html
echo "  </head>"					>> $WEBDIR/index.html
echo "  <body>"						>> $WEBDIR/index.html
echo "    <br><hr>"					>> $WEBDIR/index.html
echo "    <br><br><br>"					>> $WEBDIR/index.html
echo 							>> $WEBDIR/index.html
echo "    <b>Network statistics for $HOSTNAME</b>"	>> $WEBDIR/index.html
echo "    <br><br>"					>> $WEBDIR/index.html
echo 							>> $WEBDIR/index.html

echo "#!/bin/sh"								>> $WORKDIR/add-hosts.sh
echo										>> $WORKDIR/add-hosts.sh
echo "#"									>> $WORKDIR/add-hosts.sh
echo "# Automatically generated file that rebuilds the MRTG configuration"	>> $WORKDIR/add-hosts.sh
echo "# as it was entered at `date`"						>> $WORKDIR/add-hosts.sh
echo "#"									>> $WORKDIR/add-hosts.sh
echo "# If you edit this, please remove this comment aswell."			>> $WORKDIR/add-hosts.sh
echo "#"									>> $WORKDIR/add-hosts.sh
echo										>> $WORKDIR/add-hosts.sh
echo -n "$0"									>> $WORKDIR/add-hosts.sh

echo
echo "---------- GENERATING MRTG CONFIG FILES ----------"
_count=0
while [ ! "$1" = "" ]; do
	echo
	if [ `echo $1` = `echo $1 | tr -d :` ]; then
		echo "Invalid format specification: $1"
		usage
	fi
	_hostname=`echo $1 | cut -f1 -d:`
	_hostip=`echo $1 | cut -f2 -d:`
	
	if [ "$_hostname" = "" -o "$_hostip" = "" ]; then
		echo "Invalid format specification: $1"
		usage

		exit
	fi

	echo " \\"								>> $WORKDIR/add-hosts.sh
	echo -n "	$1"							>> $WORKDIR/add-hosts.sh

	echo "Adding host $_hostname with IP $_hostip:"
	if [ -s $WORKDIR/mrtg-gen-$_hostname.cfg ]; then
		echo "Creating backup of old config file into $WORKDIR/mrtg-gen-$_hostname.cfg.old"
		mv -f $WORKDIR/mrtg-gen-$_hostname.cfg $WORKDIR/mrtg-gen-$_hostname.cfg.old
	fi
	rm -f $WORKDIR/mrtg-gen-$_hostname.cfg

	echo "Creating directory $WEBDIR/$_hostname"
	mkdir -p $WEBDIR/$_hostname

	echo "# MRTG config file automatically generated by $0"				>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "# Please try to not modify it manually. If you do, do not send"		>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "# bug reports to pdan@extreme.ro, as you normally should do."		>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo										>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "WorkDir: $WEBDIR/$_hostname"  						>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "IconDir: $ICONDIR"							>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "Interval: $INTERVAL"							>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo										>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "Title[$_hostname]: $_hostname ($_hostip)"					>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "PageTop[$_hostname]: <H2>Ping response statistics for $_hostname ($_hostip)</H2>"	>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "Target[$_hostname]: \`$WORKDIR/net.sh $_hostname:$_hostip\`"		>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "MaxBytes[$_hostname]: $HOST_TIMEOUT"					>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "Supress[$_hostname]: y"							>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "LegendI[$_hostname]: ping response time"					>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "LegendO[$_hostname]: ping response time"					>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "YLegend[$_hostname]: msec"						>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "ShortLegend[$_hostname]: msec"						>> $WORKDIR/mrtg-gen-$_hostname.cfg
#	echo "Options[$_hostname]: gauge,unknaszero,nopercent"				>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "Options[$_hostname]: gauge,nopercent"					>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "Legend1[$_hostname]: first ping response time"				>> $WORKDIR/mrtg-gen-$_hostname.cfg
	echo "Legend2[$_hostname]: second ping response time"				>> $WORKDIR/mrtg-gen-$_hostname.cfg

	echo "Generated config file: $WORKDIR/mrtg-gen-$_hostname.cfg"


	echo "$MRTG_EXEC $WORKDIR/mrtg-gen-$_hostname.cfg &"				>> $WORKDIR/mrtg-run.sh

	_count=$[$_count + 1]

	_l_name=`echo $_hostname | awk '{ print tolower($1) }'`
	echo "    <a href=\"$_hostname/$_l_name.html\">Statistics for $_hostname</a>"	>> $WEBDIR/index.html
	echo "    <br>"									>> $WEBDIR/index.html
	echo 										>> $WEBDIR/index.html
	shift
done

echo											>> $WORKDIR/add-hosts.sh

echo "    <br><br><br>"									>> $WEBDIR/index.html
echo "    <hr>"        									>> $WEBDIR/index.html
echo "    Page maintained by: $MAINTAINER"						>> $WEBDIR/index.html
echo "  </body>"									>> $WEBDIR/index.html
echo "</html>"										>> $WEBDIR/index.html

chmod +x $WORKDIR/mrtg-run.sh
chmod +x $WORKDIR/add-hosts.sh

echo
echo "---------- GENERATION COMPLETED ----------"
echo
echo "Generated mrtg-run file $WORKDIR/mrtg-run.sh"
echo
echo "Generated add hosts file $WORKDIR/add-hosts.sh, edit/add it to add more hosts to"
echo "the current configuration (and run it, of course)."
echo
echo "Generated html file $WEBDIR/index.html"
echo
echo "Link $WEBDIR someplace in your html structure and add a link to $WEBDIR/index.html"
echo
echo "Copy the MRTG icon files (mrtg/lib/*.png) into a /mrtg/icons/ in your html root directory"
echo
echo "Add the following line in your crontab '*/$INTERVAL * * * *	$WORKDIR/mrtg-run.sh'"
echo "(or ensure that $WORKDIR/mrtg-run.sh is ran every $INTERVAL minutes, if your crontab format differs"
echo
echo ".. don't forget to update corresponding values in $WORKDIR/net.sh"
echo
echo "Done adding $_count host(s)."
