To build and install rsync:

    $ ./configure
    $ make
    # make install

You may set the installation directory and other parameters by options
to ./configure.  To see them, use:

    $ ./configure --help

Configure tries to figure out if the local system uses group "nobody" or
"nogroup" by looking in the /etc/group file.  (This is only used for the
default group of an rsync daemon, which attempts to run with "nobody"
user and group permissions.)  You can change the default user and group
for the daemon by editing the NOBODY_USER and NOBODY_GROUP defines in
config.h, or just override them in your /etc/rsyncd.conf file.

As of 2.4.7, rsync uses Eric Troan's popt option-parsing library.  A
cut-down copy of a recent release is included in the rsync distribution,
and will be used if there is no popt library on your build host, or if
the --with-included-popt option is passed to ./configure.

If you configure using --enable-maintainer-mode, then rsync will try
to pop up an xterm on DISPLAY=:0 if it crashes.  You might find this
useful, but it should be turned off for production builds.

MAKE COMPATIBILITY
------------------

Note that Makefile.in has a rule that uses a wildcard in a prerequisite.  If
your make has a problem with this rule, you will see an error like this:

    Don't know how to make ./*.c

You can change the "proto.h-tstamp" target in Makefile.in to list all the *.c
filenames explicitly in order to avoid this issue.

RPM NOTES
---------

Under packaging you will find .spec files for several distributions.
The .spec file in packaging/lsb can be used for Linux systems that
adhere to the Linux Standards Base (e.g., RedHat and others).

HP-UX NOTES
-----------

The HP-UX 10.10 "bundled" C compiler seems not to be able to cope with
ANSI C.  You may see this error message in config.log if ./configure
fails:

  (Bundled) cc: "configure", line 2162: error 1705: Function prototypes are an ANSI feature.

Install gcc or HP's "ANSI/C Compiler".

MAC OSX NOTES
-------------

Some versions of Mac OS X (Darwin) seem to have an IPv6 stack, but do
not completely implement the "New Sockets" API.  

<http://www.ipv6.org/impl/mac.html> says that Apple started to support
IPv6 in 10.2 (Jaguar).  If your build fails, try again after running
configure with --disable-ipv6.

IBM AIX NOTES
-------------

IBM AIX has a largefile problem with mkstemp.  See IBM PR-51921.
The workaround is to append the below to config.h
	#ifdef _LARGE_FILES
	#undef HAVE_SECURE_MKSTEMP
	#endif
