%define initdir /etc/rc.d/init.d
Summary: Samba SMB client and server
Name: samba
Version: 2.0.10
%define ja_rel 1.2
Release:  ja_%{ja_rel}
Copyright: GNU GPL Version 2
Group: Networking
Source: ftp://ftp.samba.gr.jp/pub/samba-jp/samba-%{version}-ja/samba-%{version}-ja-%{ja_rel}.tar.bz2
Patch1: samba-jp-makefilepath.patch
#Patch4: samba-2.0.7-fixinit.patch
#Patch7: samba-smbprint.patch
#Patch10: samba-2.0.7-system-auth.patch
#Patch13: samba-2.0.7-smbadduser.patch
Patch16: samba-2.0.7-buildroot.patch
Packager: TAKAHASHI Motonobu <monyo@samba.gr.jp>
Requires: pam >= 0.64, gettext >= 0.10, tcp_wrappers
Prereq: chkconfig fileutils
BuildRoot: /var/tmp/samba
Prefix: /usr

%description
Samba provides an SMB server which can be used to provide
network services to SMB (sometimes called "Lan Manager")
clients, including various versions of MS Windows, OS/2,
and other Linux machines. Samba also provides some SMB
clients, which complement the built-in SMB filesystem
in Linux. Samba uses NetBIOS over TCP/IP (NetBT) protocols
and does NOT need NetBEUI (Microsoft Raw NetBIOS frame)
protocol.

Samba-2 features an almost working NT Domain Control
capability and includes the new SWAT (Samba Web Administration
Tool) that allows samba's smb.conf file to be remotely managed
using your favourite web browser. For the time being this is
being enabled on TCP port 901 via inetd.

Please refer to the WHATSNEW.txt document for fixup information.
This binary release includes encrypted password support.
Please read the smb.conf file and ENCRYPTION.txt in the
docs directory for implementation details.

%prep
#cd samba-%{version}-ja-%{ja_rel}
%setup -n samba-%{version}-ja-%{ja_rel}
%patch1 -p1 -b .makefile
#%patch4 -p1 -b .fixinit
#%patch7 -p1 -b .smbprint
#%patch10 -p1 -b .system-auth
#%patch13 -p1 -b .smbadduser
%patch16 -p1 -b .buildroot

%build
cd source
%ifarch i386 sparc
RPM_OPT_FLAGS="$RPM_OPT_FLAGS -D_FILE_OFFSET_BITS=64"
%endif
./configure --prefix=%{prefix} --libdir=/etc/samba \
        --with-lockdir=/var/lock/samba --with-privatedir=/etc/samba \
        --localstatedir=/var/log/samba --with-swatdir=%{prefix}/share/swat \
        --with-sambabook=%{prefix}/share/swat/using_samba \
        --with-smbmount --with-automount --with-quotas --with-pam \
        --with-utmp --with-i18n-swat 
make CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE" all

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/usr/{sbin,bin}
mkdir -p $RPM_BUILD_ROOT%{initdir}
mkdir -p $RPM_BUILD_ROOT/etc/{pam.d,logrotate.d}
mkdir -p $RPM_BUILD_ROOT/var/{lock,log,spool}/samba
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/using_samba

mkdir -p $RPM_BUILD_ROOT/home/samba

cd source 
%makeinstall \
       BINDIR=$RPM_BUILD_ROOT%{_bindir} \
       BASEDIR=$RPM_BUILD_ROOT%{_prefix} \
       SBINDIR=$RPM_BUILD_ROOT%{_sbindir} \
       LOCKDIR=$RPM_BUILD_ROOT/var/lock/samba \
       PRIVATEDIR=$RPM_BUILD_ROOT/etc/samba \
       LIBDIR=$RPM_BUILD_ROOT/etc/samba \
       MANDIR=$RPM_BUILD_ROOT%{_mandir} \
       VARDIR=$RPM_BUILD_ROOT/var/log/samba \
       SWATDIR=$RPM_BUILD_ROOT/usr/share/swat \
       SAMBABOOK=$RPM_BUILD_ROOT/usr/share/swat/using_samba \
       install

cd ..

# Install other stuff
install -m644 examples/smb.conf.default.ja $RPM_BUILD_ROOT/etc/samba/smb.conf
install -m644 packaging/RPM.samba-jp/smbusers $RPM_BUILD_ROOT/etc/samba/smbusers
install -m644 packaging/RPM.samba-jp/samba.pamd-rh72 $RPM_BUILD_ROOT/etc/pam.d/samba
install -m644 packaging/RPM.samba-jp/samba.logrotate $RPM_BUILD_ROOT/etc/logrotate.d/samba
echo 127.0.0.1 localhost > $RPM_BUILD_ROOT/etc/samba/lmhosts

# we need a symlink for mount to recognise the smb filesystem type
ln -s ../%{_bindir}/smbmount $RPM_BUILD_ROOT/sbin/mount.smb
ln -s ../%{_bindir}/smbmount $RPM_BUILD_ROOT/sbin/mount.smbfs

install -m755 source/script/mksmbpasswd.sh $RPM_BUILD_ROOT/usr/bin
install -m755 examples/add-delete-user-script/smb-useradd $RPM_BUILD_ROOT/usr/bin
install -m755 examples/add-delete-user-script/smb-userdel $RPM_BUILD_ROOT/usr/bin

# misc
install -m755 packaging/RPM.samba-jp/smbprint $RPM_BUILD_ROOT%{_bindir}
install -m755 packaging/RPM.samba-jp/smbadduser $RPM_BUILD_ROOT%{_bindir}
install -m755 packaging/RPM.samba-jp/findsmb $RPM_BUILD_ROOT%{_bindir}
install -m755 packaging/RPM.samba-jp/smb.init $RPM_BUILD_ROOT%{initdir}/smb
install -m755 packaging/RPM.samba-jp/smb.init $RPM_BUILD_ROOT%{_sbindir}/samba
install -m644 packaging/RPM.samba-jp/swat.xinetd $RPM_BUILD_ROOT/etc/samba/swat.xinetd

mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
cat > $RPM_BUILD_ROOT/etc/sysconfig/samba <<EOF
# Options to smbd
SMBDOPTIONS="-D"
# Options to nmbd
NMBDOPTIONS="-D"
EOF

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add smb

# add SWAT entry 
if [ -d /etc/xinetd.d ] ; then
  install -m644 /etc/samba/swat.xinetd /etc/xinetd.d/swat
else
  # Add swat entry to /etc/services if not already there
  if !( grep ^[:space:]*swat /etc/services > /dev/null ) then
	echo 'swat		901/tcp				# Add swat service used via inetd' >> /etc/services
  fi

  # Add swat entry to /etc/inetd.conf if needed
  if !( grep ^[:space:]*swat /etc/inetd.conf > /dev/null ) then
	echo 'swat	stream	tcp	nowait.400	root	/usr/sbin/tcpd	%{prefix}/sbin/swat' >> /etc/inetd.conf
  killall -1 inetd || :
  fi
fi

# Create an empty lock file to supress error messages
if [ ! -e /var/lock/samba/STATUS..LCK ]; then
    touch /var/lock/samba/STATUS..LCK
fi

%preun
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del smb
    %{initdir}/smb stop >/dev/null 2>&1
    rm -rf /var/log/samba/* /var/lock/samba/*
fi
exit 0

%postun
# Only delete remnants of samba if this is the final deletion.
if [ $1 = 0 ] ; then

    if [ -f /etc/xinetd.d/swat ]; then
      rm -f /etc/xinetd.d/swat
    fi

    # Remove swat entries from /etc/inetd.conf and /etc/services
    cd /etc
    tmpfile=/etc/tmp.$$
    sed -e '/^[:space:]*swat.*$/d' /etc/inetd.conf > $tmpfile
    mv $tmpfile inetd.conf
    sed -e '/^[:space:]*swat.*$/d' /etc/services > $tmpfile
    mv $tmpfile services
fi

%triggerpostun -- samba < samba-1.9.18p7
if [ $1 != 0 ]; then
    /sbin/chkconfig --add smb
fi

%triggerpostun -- samba < 2.0.5a-3
if [ $1 != 0 ]; then
    [ ! -d /var/lock/samba ] && mkdir -m 0755 /var/lock/samba
    [ ! -d /var/spool/samba ] && mkdir -m 1777 /var/spool/samba
    chmod 644 /etc/services
    [ -f /etc/inetd.conf ] && chmod 644 /etc/inetd.conf
fi

%files
%defattr(-,root,root)
%doc README COPYING Manifest
%doc WHATSNEW.txt Roadmap
%doc docs
%doc examples

%{_sbindir}/smbd
%{_sbindir}/nmbd
%{_bindir}/addtosmbpass
%{_bindir}/mksmbpasswd.sh
%{_bindir}/smbstatus
%{_bindir}/smbpasswd
%{_bindir}/convert_smbpasswd
%{_bindir}/smbadduser
%{_bindir}/smb-useradd
%{_bindir}/smb-userdel
%config(noreplace) /etc/sysconfig/samba
%config(noreplace) /etc/samba/smbusers
%config %{_sbindir}/samba
%attr(755,root,root) %config %{initdir}/smb
%config /etc/logrotate.d/samba
%config /etc/pam.d/samba
%attr(-,root,nobody) %dir /home/samba

%{_mandir}/man1/smbstatus.1*
%{_mandir}/man5/smbpasswd.5*
%{_mandir}/man7/samba.7*
%{_mandir}/man8/smbd.8*
%{_mandir}/man8/nmbd.8*
%{_mandir}/ja/man1/smbstatus.1*
%{_mandir}/ja/man5/smbpasswd.5*
%{_mandir}/ja/man7/samba.7*
%{_mandir}/ja/man8/smbd.8*
%{_mandir}/ja/man8/nmbd.8*

%dir /var/lock/samba
%attr(0700,root,root)   %dir /var/log/samba
%attr(1777,root,root)	%dir /var/spool/samba

#%files swat
%defattr(-,root,root)
%config(noreplace) /etc/samba/swat.xinetd
/usr/share/swat
/usr/share/locale
%{_sbindir}/swat
%{_mandir}/man8/swat.8*
%{_mandir}/ja/man8/swat.8*

#%files client
%defattr(-,root,root)
/sbin/mount.smb
/sbin/mount.smbfs
%{_bindir}/smbmount
%{_bindir}/smbmnt
%{_bindir}/smbumount
%{_mandir}/man8/smbmnt.8*
%{_mandir}/man8/smbmount.8*
%{_mandir}/man8/smbumount.8*
%{_mandir}/ja/man8/smbmnt.8*
%{_mandir}/ja/man8/smbmount.8*
%{_mandir}/ja/man8/smbumount.8*

%{_bindir}/nmblookup
%{_bindir}/findsmb
%{_bindir}/smbclient
#samba-jp %{_bindir}/smbsh
%{_bindir}/smbtar
%{_bindir}/smbprint
%{_bindir}/smbspool
%{_mandir}/man1/nmblookup.1*
%{_mandir}/man1/smbclient.1*
%{_mandir}/man1/smbsh.1*
%{_mandir}/man1/smbtar.1*
%{_mandir}/man8/smbspool.8*
%{_mandir}/ja/man1/nmblookup.1*
%{_mandir}/ja/man1/smbclient.1*
%{_mandir}/ja/man1/smbsh.1*
%{_mandir}/ja/man1/smbtar.1*
%{_mandir}/ja/man8/smbspool.8*

#%files common
%defattr(-,root,root)
%{_bindir}/make_smbcodepage
%{_bindir}/make_unicodemap
%{_bindir}/testparm
%{_bindir}/testprns
%{_bindir}/make_printerdef
%{_bindir}/make_nftable
%{_bindir}/rpcclient
%config(noreplace) /etc/samba/smb.conf
%config(noreplace) /etc/samba/lmhosts
%dir /etc/samba
%dir /etc/samba/codepages
%config /etc/samba/codepages/*
%{_mandir}/man1/make_smbcodepage.1*
%{_mandir}/man1/make_unicodemap.1*
%{_mandir}/man1/testparm.1*
%{_mandir}/man1/testprns.1*
%{_mandir}/man8/smbpasswd.8*
%{_mandir}/man5/smb.conf.5*
%{_mandir}/man5/lmhosts.5*
%{_mandir}/ja/man1/make_smbcodepage.1*
%{_mandir}/ja/man1/make_unicodemap.1*
%{_mandir}/ja/man1/testparm.1*
%{_mandir}/ja/man1/testprns.1*
%{_mandir}/ja/man8/smbpasswd.8*
%{_mandir}/ja/man5/smb.conf.5*
%{_mandir}/ja/man5/lmhosts.5*

%changelog
* Sun Nov 23 2001 TAKAHASHI Motonobu <monyo@samba.gr.jp>
 - Change Target Version to samba-2.0.10-ja-1.2
 - rewritten based on samba-2.0.7 RPM of Red Hat Lionux 7.1

* Sun Nov 05 2001 TAKAHASHI Motonobu <monyo@samba.gr.jp>
 - Remove HowToUseSamba 

* Sun Sep 16 2001 TAKAHASHI Motonobu <monyo@samba.gr.jp>
 - Change Target Version to samba-2.0.10-ja-1.1 .

* Sun Jul 10 2001 Hiroshi Inoue <gamera@quartz.ocn.ne.jp>
 - Include Hankaku Kana filename problem patch from Mr.Takashi SHIRAI.

* Sun Jul 8 2001 Hiroshi Inoue <gamera@quartz.ocn.ne.jp>
 - Change Target Version to samba-2.0.10-ja-1.0 .

* Sat Jun 10 2001 Hiroshi Inoue <gamera@quartz.ocn.ne.jp>
 - No man page was install fix.
 - Spec File modify SWAT JP Document Install correct.
     based on packaging/RedHat/samba2.ja.spec

* Sat Jul 8 2000 TAKAHASHI Motonobu <monyo@samba.gr.jp>
 - Added smb-useradd and smb-userdel scripts
 - Fixed some Japanese expression
 - SWAT is invoked via tcp
 - create STATUS..LCK during installation

* Fri Jul 7 2000 Hiroshi MIURA <miura@samba.gr.jp>
 - Added Japanese manual pages

* Sat May 27 2000 Hiroshi MIURA <miura@samba.gr.jp>
 - Added support for "HowToUseSamba" Document
 - Update spec file Japanese description.

* Sat May 6 2000 Hiroshi MIURA <miura@samba.gr.jp>
 - Added support for "i18n SWAT"

* Fri Apr 14 2000 John H Terpstra <jht@turbolinux.com>
 - Updated unicode map file generation

* Thu Mar 30 2000 Jeremy Allison <jeremy@valinux.com>
 - Added support for "Using Samba" and unicode maps.

* Sat Nov 29 1999 Matthew Vanecek <mev0003@unt.edu>
 - Added a Prefix and changed "/usr" to "%{prefix}"

* Sat Nov 11 1999 Tridge <tridge@linuxcare.com>
 - changed from mount.smb to mount.smbfs

* Sat Oct 9 1999 Tridge <tridge@linuxcare.com>
 - removed smbwrapper
 - added smbmnt and smbmount

* Sun Apr 25 1999 John H Terpstra <jht@samba.org>
 - added smbsh.1 man page

* Fri Mar 26 1999 Andrew Tridgell <tridge@samba.org>
 - added --with-pam as pam is no longer used by default

* Sat Jan 27 1999 Jeremy Allison <jra@samba.org>
 - Removed smbrun binary and tidied up some loose ends

* Sun Oct 25 1998 John H Terpstra <jht@samba.org>
 - Added parameters to /config to ensure smb.conf, lmhosts, 
	and smbusers never gets over-written.

* Sat Oct 24 1998 John H Terpstra <jht@samba.org>
 - removed README.smbsh file from docs area

* Mon Oct 05 1998 John H Terpstra <jht@samba.org>
 - Added rpcclient to binaries list
 - Added smbwrapper stuff

* Fri Aug 21 1998 John H Terpstra <jht@samba.org>
 - Updated for Samba version 2.0 building

* Tue Jul 07 1998 Erik Troan <ewt@redhat.com>
  - updated postun triggerscript to check $0
  - clear /etc/codepages from %preun instead of %postun

* Sat Jul 04 1998 John H Terpstra <jht@samba.org>
 - fixed codepage preservation during update via -Uvh

* Mon Jun 08 1998 Erik Troan <ewt@redhat.com>
  - made the %postun script a tad less agressive; no reason to remove
    the logs or lock file 
  - the %postun and %preun should only exectute if this is the final
    removal
  - migrated %triggerpostun from Red Hat's samba package to work around
    packaging problems in some Red Hat samba releases

* Sun Apr 26 1998 John H Terpstra <jht@samba.org>
 - Tidy up for early alpha releases
 - added findsmb from SGI packaging

* Thu Apr 09 1998 John H Terpstra <jht@samba.org>
 - Updated spec file
 - Included new codepage.936

* Sat Mar 20 1998 John H Terpstra <jht@samba.org>
 - Added swat facility

* Sat Jan 24 1998 John H Terpstra <jht@samba.org>
 - Many optimisations (some suggested by Manoj Kasichainula <manojk@io.com>
  - Use of chkconfig in place of individual symlinks to /etc/rc.d/init/smb
  - Compounded make line
  - Updated smb.init restart mechanism
  - Use compound mkdir -p line instead of individual calls to mkdir
  - Fixed smb.conf file path for log files
  - Fixed smb.conf file path for incoming smb print spool directory
  - Added a number of options to smb.conf file
  - Added smbadduser command (missed from all previous RPMs) - Doooh!
  - Added smbuser file and smb.conf file updates for username map
