/* 
   Unix SMB/Netbios implementation.
   Version 2.0
   SMB wrapper functions
   Copyright (C) Andrew Tridgell 1998
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* NOTE: This file WILL produce compiler warnings. They are unavoidable 

   Do not try and get rid of them by including other include files or
   by including includes.h or proto.h or you will break portability. 
  */

#include "config.h"
#include <sys/types.h>
#include <errno.h>
#include "realcalls.h"

#if defined(__cplusplus) || defined(__STDC__)
#undef __P
#define __P(protos)	protos
#else
#undef __P
#define __P(protos)	()
#endif

#ifndef NULL
# define NULL ((void *)0)
#endif

 int open(char *name, int flags, mode_t mode)
{
	if (smbw_path(name)) {
		return smbw_open(name, flags, mode);
	}

	return real_open(name, flags, mode);
}

#ifdef HAVE__OPEN
 int _open(char *name, int flags, mode_t mode) 
{
	return open(name, flags, mode);
}
#elif HAVE___OPEN
 int __open(char *name, int flags, mode_t mode) 
{
	return open(name, flags, mode);
}
#endif


#ifdef HAVE_OPEN64
# ifdef real_open64
 int open64(char *name, int flags, mode_t mode)
{
	if (smbw_path(name)) {
		return smbw_open(name, flags, mode);
	}

	return real_open64(name, flags, mode);
}
# endif

# ifndef NO_OPEN64_ALIAS
#  ifdef HAVE__OPEN64
 int _open64(char *name, int flags, mode_t mode) 
{
	return open64(name, flags, mode);
}
#  elif HAVE___OPEN64
 int __open64(char *name, int flags, mode_t mode) 
{
	return open64(name, flags, mode);
}
#  endif
# endif
#endif

#ifdef HAVE_PREAD
# ifdef real_pread
 ssize_t pread(int fd, void *buf, size_t size, off_t ofs)
{
	if (smbw_fd(fd)) {
		return smbw_pread(fd, buf, size, ofs);
	}

	return real_pread(fd, buf, size, ofs);
}
# endif
#endif

#if defined(HAVE_PREAD64) && defined(HAVE_EXPLICIT_LARGEFILE_SUPPORT)
 ssize_t pread64(int fd, void *buf, size_t size, off64_t ofs)
{
	if (smbw_fd(fd)) {
		return smbw_pread(fd, buf, size, ofs);
	}

	return real_pread64(fd, buf, size, ofs);
}
#endif

#ifdef HAVE_PWRITE
# ifdef real_pwrite
 ssize_t pwrite(int fd, void *buf, size_t size, off_t ofs)
{
	if (smbw_fd(fd)) {
		return smbw_pwrite(fd, buf, size, ofs);
	}

	return real_pwrite(fd, buf, size, ofs);
}
# endif
#endif

#if defined(HAVE_PWRITE64) && defined(HAVE_EXPLICIT_LARGEFILE_SUPPORT)
 ssize_t pwrite64(int fd, void *buf, size_t size, off64_t ofs)
{
	if (smbw_fd(fd)) {
		return smbw_pwrite(fd, buf, size, ofs);
	}

	return real_pwrite64(fd, buf, size, ofs);
}
#endif


 int chdir(char *name)
{
	return smbw_chdir(name);
}

#ifdef HAVE___CHDIR
 int __chdir(char *name)
{
	return chdir(name);
}
#elif HAVE__CHDIR
 int _chdir(char *name)
{
	return chdir(name);
}
#endif


 int close(int fd)
{
	if (smbw_fd(fd)) {
		return smbw_close(fd);
	}
	if (smbw_local_fd(fd)) {
		errno = EBADF;
		return -1;
	}

	return real_close(fd);
}

#ifdef HAVE___CLOSE
 int __close(int fd)
{
	return close(fd);
}
#elif HAVE__CLOSE
 int _close(int fd)
{
	return close(fd);
}
#endif


 int fchdir(int fd)
{
	return smbw_fchdir(fd);
}

#ifdef HAVE___FCHDIR
 int __fchdir(int fd)
{
	return fchdir(fd);
}
#elif HAVE__FCHDIR
 int _fchdir(int fd)
{
	return fchdir(fd);
}
#endif


 int fcntl(int fd, int cmd, long arg)
{
	if (smbw_fd(fd)) {
		return smbw_fcntl(fd, cmd, arg);
	}

	return real_fcntl(fd, cmd, arg);
}


#ifdef HAVE___FCNTL
 int __fcntl(int fd, int cmd, long arg)
{
	return fcntl(fd, cmd, arg);
}
#elif HAVE__FCNTL
 int _fcntl(int fd, int cmd, long arg)
{
	return fcntl(fd, cmd, arg);
}
#endif



#ifdef real_getdents
 int getdents(int fd, void *dirp, unsigned int count)
{
	if (smbw_fd(fd)) {
		return smbw_getdents(fd, dirp, count);
	}

	return real_getdents(fd, dirp, count);
}
#endif

#ifdef HAVE___GETDENTS
 int __getdents(int fd, void *dirp, unsigned int count)
{
	return getdents(fd, dirp, count);
}
#elif HAVE__GETDENTS
 int _getdents(int fd, void *dirp, unsigned int count)
{
	return getdents(fd, dirp, count);
}
#endif

#ifdef real_getdirentries
 int getdirentries(int fd, char *buf, int nbytes, long *basep)
{
	if (smbw_fd(fd)) {
		return smbw_getdirentries(fd, buf, nbytes, basep);
	}

	return real_getdirentries(fd, buf, nbytes, basep);
}
#endif

#ifdef HAVE___GETDIRENTRIES
 int __getdirentries(int fd, char *buf, int nbytes, long *basep)
{
	return getdirentries(fd, buf, nbytes, basep);
}
#elif HAVE__GETDIRENTRIES
 int _getdirentries(int fd, char *buf, int nbytes, long *basep)
{
	return getdirentries(fd, buf, nbytes, basep);
}
#endif

 off_t lseek(int fd, off_t offset, int whence)
{
	if (smbw_fd(fd)) {
		return smbw_lseek(fd, offset, whence);
	}

	return real_lseek(fd, offset, whence);
}

#ifdef HAVE___LSEEK
 off_t __lseek(int fd, off_t offset, int whence)
{
	return lseek(fd, offset, whence);
}
#elif HAVE__LSEEK
 off_t _lseek(int fd, off_t offset, int whence)
{
	return lseek(fd, offset, whence);
}
#endif


 ssize_t read(int fd, void *buf, size_t count)
{
	if (smbw_fd(fd)) {
		return smbw_read(fd, buf, count);
	}

	return real_read(fd, buf, count);
}

#ifdef HAVE___READ
 ssize_t __read(int fd, void *buf, size_t count)
{
	return read(fd, buf, count);
}
#elif HAVE__READ
 ssize_t _read(int fd, void *buf, size_t count)
{
	return read(fd, buf, count);
}
#endif


 ssize_t write(int fd, void *buf, size_t count)
{
	if (smbw_fd(fd)) {
		return smbw_write(fd, buf, count);
	}

	return real_write(fd, buf, count);
}

#ifdef HAVE___WRITE
 ssize_t __write(int fd, void *buf, size_t count)
{
	return write(fd, buf, count);
}
#elif HAVE__WRITE
 ssize_t _write(int fd, void *buf, size_t count)
{
	return write(fd, buf, count);
}
#endif



 int access(char *name, int mode)
{
	if (smbw_path(name)) {
		return smbw_access(name, mode);
	}

	return real_access(name, mode);
}



 int chmod(char *name,mode_t mode)
{
	if (smbw_path(name)) {
		return smbw_chmod(name, mode);
	}

	return real_chmod(name, mode);
}



 int chown(char *name,uid_t owner, gid_t group)
{
	if (smbw_path(name)) {
		return smbw_chown(name, owner, group);
	}

	return real_chown(name, owner, group);
}


 char *getcwd(char *buf, size_t size)
{
	extern char *smbw_getcwd __P((char *buf, size_t size));

	return (char *)smbw_getcwd(buf, size);
}

#ifndef NO_GETCWD_ALIAS
# if HAVE___GETCWD
 char *__getcwd(char *buf, size_t size)
{
	return getcwd(buf, size);
}
# endif
#endif



 int mkdir(char *name, mode_t mode)
{
	if (smbw_path(name)) {
		return smbw_mkdir(name, mode);
	}

	return real_mkdir(name, mode);
}


#if HAVE___FXSTAT
 int __fxstat(int vers, int fd, void *st)
{
	double xx[32];
	int ret;

	if (smbw_fd(fd)) {
		return smbw_fstat(fd, st);
	}

	ret = real_fstat(fd, xx);
	xstat_convert(vers, xx, st);
	return ret;
}
#endif

#if HAVE___XSTAT
 int __xstat(int vers, char *name, void *st)
{
	double xx[32];
	int ret;

	if (smbw_path(name)) {
		return smbw_stat(name, st);
	}

	ret = real_stat(name, xx);
	xstat_convert(vers, xx, st);
	return ret;
}
#endif


#if HAVE___LXSTAT
 int __lxstat(int vers, char *name, void *st)
{
	double xx[32];
	int ret;

	if (smbw_path(name)) {
		return smbw_stat(name, st);
	}

	ret = real_lstat(name, xx);
	xstat_convert(vers, xx, st);
	return ret;
}
#endif


 int stat(char *name, void *st)
{
#if HAVE___XSTAT
	return __xstat(0, name, st);
#else
	if (smbw_path(name)) {
		return smbw_stat(name, st);
	}
	return real_stat(name, st);
#endif
}

#ifndef NO_STAT_ALIAS
# if HAVE___STAT
 int __stat(char *name, void *st)
{
	return stat(name, st);
}
# endif
#endif

#ifdef HAVE__F64_STAT
 int _F64_stat(char *name, void *st)
{
	return stat(name, st);
}
#endif

 int lstat(char *name, void *st)
{
#if HAVE___LXSTAT
	return __lxstat(0, name, st);
#else
	if (smbw_path(name)) {
		return smbw_stat(name, st);
	}
	return real_lstat(name, st);
#endif
}

#ifndef NO_LSTAT_ALIAS
# if HAVE___LSTAT
 int __lstat(char *name, void *st)
{
	return lstat(name, st);
}
# endif
#endif

#ifdef HAVE__F64_LSTAT
 int _F64_lstat(char *name, void *st)
{
	return lstat(name, st);
}
#endif

 int fstat(int fd, void *st)
{
#if HAVE___LXSTAT
	return __fxstat(0, fd, st);
#else
	if (smbw_fd(fd)) {
		return smbw_fstat(fd, st);
	}
	return real_fstat(fd, st);
#endif
}

#ifndef NO_FSTAT_ALIAS
# if HAVE___FSTAT
 int __fstat(int fd, void *st)
{
	return fstat(fd, st);
}
# endif
#endif

#ifdef HAVE__F64_FSTAT
 int _F64_fstat(int fd, void *st)
{
	return fstat(fd, st);
}
#endif

 int unlink(char *name)
{
	if (smbw_path(name)) {
		return smbw_unlink(name);
	}

	return real_unlink(name);
}


#ifdef HAVE_UTIME
 int utime(char *name,void *tvp)
{
	if (smbw_path(name)) {
		return smbw_utime(name, tvp);
	}

	return real_utime(name, tvp);
}
#endif

#ifdef HAVE_UTIMES

#define utimes	fake_utimes
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#undef utimes

 int utimes(const char *name, const struct timeval *tvp)
{
	if (smbw_path(name)) {
		return smbw_utimes(name, tvp);
	}

	return real_utimes(name, tvp);
}
#endif

 int readlink(char *path, char *buf, size_t bufsize)
{
	if (smbw_path(path)) {
		return smbw_readlink(path, buf, bufsize);
	}

	return real_readlink(path, buf, bufsize);
}


 int rename(char *oldname,char *newname)
{
	int p1, p2;
	p1 = smbw_path(oldname); 
	p2 = smbw_path(newname); 
	if (p1 ^ p2) {
		/* can't cross filesystem boundaries */
		errno = EXDEV;
		return -1;
	}
	if (p1 && p2) {
		return smbw_rename(oldname, newname);
	}

	return real_rename(oldname, newname);
}

 int rmdir(char *name)
{
	if (smbw_path(name)) {
		return smbw_rmdir(name);
	}

	return real_rmdir(name);
}


 int symlink(char *topath,char *frompath)
{
	int p1, p2;
	p1 = smbw_path(topath); 
	p2 = smbw_path(frompath); 
	if (p1 || p2) {
		/* can't handle symlinks */
		errno = EPERM;
		return -1;
	}

	return real_symlink(topath, frompath);
}

 int dup(int fd)
{
	if (smbw_fd(fd)) {
		return smbw_dup(fd);
	}

	return real_dup(fd);
}

#ifndef NO_DUP_ALIAS
# if HAVE___DUP
 int __dup(int fd)
{
	return dup(fd);
}
# endif
#endif

 int dup2(int oldfd, int newfd)
{
	if (smbw_fd(newfd)) {
		close(newfd);
	}

	if (smbw_fd(oldfd)) {
		return smbw_dup2(oldfd, newfd);
	}

	return real_dup2(oldfd, newfd);
}

#ifndef NO_DUP2_ALIAS
# if HAVE___DUP2
 int __dup2(int oldfd, int newfd)
{
	return dup2(oldfd, newfd);
}
# endif
#endif

#ifndef NO_OPENDIR_WRAPPER
 void *opendir(char *name)
{
	extern void *smbw_opendir __P((char *name));
	extern void *real_opendir __P((char *name));

	if (smbw_path(name)) {
		return (void *)smbw_opendir(name);
	}

	return (void *)real_opendir(name);
}

# ifndef NO_OPENDIR_ALIAS
#  ifdef HAVE__OPENDIR
 void *_opendir(char *name)
{
	return opendir(name);
}
#  elif HAVE___OPENDIR
 void *__opendir(char *name)
{
	return opendir(name);
}
#  endif
# endif
#endif

#ifndef NO_READDIR_WRAPPER
 void *readdir(void *dir)
{
	extern void *smbw_readdir __P((void *dir));
	extern void *real_readdir __P((void *dir));

	if (smbw_dirp(dir)) {
		return (void *)smbw_readdir(dir);
	}

	return (void *)real_readdir(dir);
}

# ifndef NO_READDIR_ALIAS
#  ifdef HAVE__READDIR
 void *_readdir(void *dir)
{
	return readdir(dir);
}
#  elif HAVE___READDIR
 void *__readdir(void *dir)
{
	return readdir(dir);
}
#  endif
# endif
#endif

#ifndef NO_READDIR_R_WRAPPER
# if defined(HAVE_POSIX_READDIR_R)
 int readdir_r(void *dir, void *entry, void **result)
{
	if (smbw_dirp(dir)) {
		return smbw_posix_readdir_r(dir, entry, result);
	}

	return real_posix_readdir_r(dir, entry, result);
}

#  ifndef NO_POSIX_READDIR_R_ALIAS
#   ifdef HAVE__READDIR_R
 int _readdir_r(void *dir, void *entry, void **result)
{
	return readdir_r(dir, entry, result);
}
#   elif HAVE___READDIR_R
 int __readdir_r(void *dir, void *entry, void **result)
{
	return readdir_r(dir, entry, result);
}
#   endif
#  endif
# elif defined(HAVE_OLD_READDIR_R)
 void *readdir_r(void *dir, void *entry)
{
	if (smbw_dirp(dir)) {
		return (void *)smbw_old_readdir_r(dir, entry);
	}

	return (void *)real_old_readdir_r(dir, entry);
}

#  ifndef NO_OLD_READDIR_R_ALIAS
#   ifdef HAVE__READDIR_R
 int _readdir_r(void *dir, void *entry)
{
	return readdir_r(dir, entry);
}
#   elif HAVE___READDIR_R
 int __readdir_r(void *dir, void *entry)
{
	return readdir_r(dir, entry);
}
#   endif
#  endif
# endif
#endif

#ifndef NO_CLOSEDIR_WRAPPER
 int closedir(void *dir)
{
	if (smbw_dirp(dir)) {
		return smbw_closedir(dir);
	}

	return real_closedir(dir);
}

# ifndef NO_CLOSEDIR_ALIAS
#  ifdef HAVE__CLOSEDIR
 int _closedir(void *dir)
{
	return closedir(dir);
}
#  elif HAVE___CLOSEDIR
 int __closedir(void *dir)
{
	return closedir(dir);
}
#  endif
# endif
#endif

#ifndef NO_TELLDIR_WRAPPER
 off_t telldir(void *dir)
{
	if (smbw_dirp(dir)) {
		return smbw_telldir(dir);
	}

	return real_telldir(dir);
}

# ifndef NO_TELLDIR_ALIAS
#  if HAVE__TELLDIR
 off_t _telldir(void *dir)
{
	return telldir(dir);
}
#  elif HAVE___TELLDIR
 off_t __telldir(void *dir)
{
	return telldir(dir);
}
#  endif
# endif
#endif

#ifndef NO_SEEKDIR_WRAPPER
 int seekdir(void *dir, off_t offset)
{
	if (smbw_dirp(dir)) {
		smbw_seekdir(dir, offset);
		return 0;
	}

	real_seekdir(dir, offset);
	return 0;
}

# ifndef NO_SEEKDIR_ALIAS
#  if HAVE__SEEKDIR
 int _seekdir(void *dir, off_t offset)
{
	return seekdir(dir, offset);
}
#  elif HAVE___SEEKDIR
 int __seekdir(void *dir, off_t offset)
{
	return seekdir(dir, offset);
}
#  endif
# endif
#endif


#ifndef NO_ACL_WRAPPER
 int  acl(char  *pathp,  int  cmd,  int  nentries, void *aclbufp)
{
	if (smbw_path(pathp)) {
		return smbw_acl(pathp, cmd, nentries, aclbufp);
	}

	return real_acl(pathp, cmd, nentries, aclbufp);
}

# ifndef NO_ACL_ALIAS
#  if HAVE___ACL
 int  __acl(char *pathp, int cmd, int nentries, void *aclbufp)
{
	return acl(pathp, cmd, nentries, aclbufp);
}
#  endif
# endif
#endif

#ifndef NO_FACL_WRAPPER
 int  facl(int fd,  int  cmd,  int  nentries, void *aclbufp)
{
	if (smbw_fd(fd)) {
		return smbw_facl(fd, cmd, nentries, aclbufp);
	}

	return real_facl(fd, cmd, nentries, aclbufp);
}

# ifndef NO_FACL_ALIAS
#  if HAVE___FACL
 int  __facl(int fd, int cmd, int nentries, void *aclbufp)
{
	return facl(fd, cmd, nentries, aclbufp);
}
#  endif
# endif
#endif

 int creat(char *path, mode_t mode)
{
	extern int creat_bits;
	return open(path, creat_bits, mode);
}

#ifdef HAVE_CREAT64
 int creat64(char *path, mode_t mode)
{
	extern int creat_bits;
	return open64(path, creat_bits, mode);
}
#endif

#if defined(HAVE_STRUCT_STAT64)
#ifdef HAVE___XSTAT64
  int __xstat64(int vers, char *name, void *st64)
{
	if (smbw_path(name)) {
		double xx[32];
		int ret;

		ret = smbw_stat(name, xx);
		stat64_convert(xx, st64);
		return ret;
	}

	return real_stat64(name, st64);
}
#endif

#ifdef HAVE___FXSTAT64
  int __fxstat64(int vers, int fd, void *st64)
{
	if (smbw_fd(fd)) {
		double xx[32];
		int ret;

		ret = smbw_fstat(fd, xx);
		stat64_convert(xx, st64);
		return ret;
	}

	return real_fstat64(fd, st64);
}
#endif

#ifdef HAVE___LXSTAT64
  int __lxstat64(int vers, char *name, void *st64)
{
	if (smbw_path(name)) {
		double xx[32];
		int ret;

		ret = smbw_stat(name, xx);
		stat64_convert(xx, st64);
		return ret;
	}

	return real_lstat64(name, st64);
}
#endif

#ifdef HAVE_STAT64
  int stat64(char *name, void *st64)
{
#if HAVE___XSTAT64
	return __xstat64(0, name, st64);
#else
	if (smbw_path(name)) {
		double xx[32];
		int ret = smbw_stat(name, xx);
		stat64_convert(xx, st64);
		return ret;
	}
	return real_stat64(name, st64);
#endif
}

# ifndef NO_STAT64_ALIAS
#  if HAVE___STAT64
  int __stat64(char *name, void *st64)
{
	return stat64(name, st64);
}
#  endif
# endif
#endif

#ifdef HAVE_FSTAT64
  int fstat64(int fd, void *st64)
{
#if HAVE___FXSTAT64
	return __fxstat64(0, fd, st64);
#else
	if (smbw_fd(fd)) {
		double xx[32];
		int ret = smbw_fstat(fd, xx);
		stat64_convert(xx, st64);
		return ret;
	}
	return real_fstat64(fd, st64);
#endif
}

# ifndef NO_FSTAT64_ALIAS
#  if HAVE___FSTAT64
  int __fstat64(int fd, void *st64)
{
	return fstat64(fd, st64);
}
#  endif
# endif
#endif

#ifdef HAVE_LSTAT64
  int lstat64(char *name, void *st64)
{
#if HAVE___LXSTAT64
	return __lxstat64(0, name, st64);
#else
	if (smbw_path(name)) {
		double xx[32];
		int ret = smbw_stat(name, xx);
		stat64_convert(xx, st64);
		return ret;
	}
	return real_lstat64(name, st64);
#endif
}

# ifndef NO_LSTAT64_ALIAS
#  if HAVE___LSTAT64
  int __lstat64(char *name, void *st64)
{
	return lstat64(name, st64);
}
#  endif
# endif
#endif
#endif

#ifdef HAVE_LLSEEK
# ifdef real_llseek
  offset_t llseek(int fd, offset_t ofs, int whence)
{
	if (smbw_fd(fd)) {
		return lseek(fd, ofs, whence);
	}
	return real_llseek(fd, ofs, whence);
}
# endif
#endif

#if defined(HAVE_STRUCT_DIRENT64) || defined(HAVE_GLIBC)
# ifdef HAVE_READDIR64
 void *readdir64(void *dir)
{
	extern void *smbw_readdir __P((void *dir));
	extern void *real_readdir __P((void *dir));
	extern void *real_readdir64 __P((void *dir));
	static double xx[70];
	void *d;

#  ifdef HAVE_STRUCT_DIRENT64
	if (smbw_dirp(dir)) {
		d = (void *)smbw_readdir(dir);
		if (!d) return NULL;
		dirent64_convert(d, xx);
		return xx;
	}
	return (void *)real_readdir64(dir);
#  else
	if (smbw_dirp(dir)) {
		d = (void *)smbw_readdir(dir);
	}
	else {
		d = (void *)real_readdir(dir);
	}
	if (!d) return NULL;
	dirent64_convert(d, xx);
	return xx;
#  endif
}

#  ifndef NO_READDIR64_ALIAS
#   ifdef HAVE__READDIR64
 void *_readdir64(void *dir)
{
	return readdir64(dir);
}
#   elif HAVE___READDIR64
 void *__readdir64(void *dir)
{
	return readdir64(dir);
}
#   endif
#  endif
# endif

# ifdef HAVE_READDIR64_R
# if defined(HAVE_POSIX_READDIR_R)
 int readdir64_r(void *dir, void *entry, void **result)
{
	double xx[70];
	int ret;

#  ifdef HAVE_STRUCT_DIRENT64
	if (smbw_dirp(dir)) {
		dirent64_revert(entry, xx);
		ret = smbw_posix_readdir_r(dir, xx, result);
		if (ret || !result) return ret;
		dirent64_convert(xx, entry);
		*result = entry;
		return ret;
	}
	return real_posix_readdir64_r(dir, entry, result);
#  else
	dirent64_revert(entry, xx);
	if (smbw_dirp(dir)) {
		ret = smbw_posix_readdir_r(dir, xx, result);
	}
	else {
		ret = real_posix_readdir_r(dir, xx, result);
	}
	if (ret || !result) return ret;
	dirent64_convert(xx, entry);
	*result = entry;
	return ret;
#  endif
}

#  ifndef NO_POSIX_READDIR64_R_ALIAS
#   ifdef HAVE__READDIR64
 int _readdir64_r(void *dir, void *entry, void **result)
{
	return readdir64(dir, entry, result);
}
#   elif HAVE___READDIR64
 int __readdir64_r(void *dir, void *entry, void **result)
{
	return readdir64(dir, entry, result);
}
#   endif
#  endif
# elif defined(HAVE_OLD_READDIR_R)
 void *readdir64_r(void *dir, void *entry)
{
	double xx[70];
	void *d;

#  ifdef HAVE_STRUCT_DIRENT64
	if (smbw_dirp(dir)) {
		dirent64_revert(entry, xx);
		d = (void *)smbw_old_readdir_r(dir, xx);
		if (!d) return NULL;
		dirent64_convert(d, entry);
		return entry;
	}
	return (void *)real_old_readdir64_r(dir, dir);
#  else
	dirent64_revert(entry, xx);
	if (smbw_dirp(dir)) {
		d = (void *)smbw_old_readdir_r(dir, xx);
	}
	else {
		d = (void *)real_old_readdir_r(dir, xx);
	}
	if (!d) return NULL;
	dirent64_convert(d, entry);
	return entry;
#  endif
}

#  ifndef NO_OLD_READDIR64_R_ALIAS
#   ifdef HAVE__READDIR64
 void *_readdir64_r(void *dir, void *entry)
{
	return (void *)readdir64(dir, entry);
}
#   elif HAVE___READDIR64
 void *__readdir64_r(void *dir, void *entry)
{
	return (void *)readdir64(dir, entry);
}
#   endif
#  endif
# endif
#endif
#endif

 int fork(void)
{
	return smbw_fork();
}

 int vfork(void)
{
	/* This fake has a risk of deadlock */
	return smbw_fork();
}
