
#include "yodl.h"

static void numbererror (char const *sym, char const *list)
{
    error_gram (sym, 
                "exactly one number in parlist expected instead of %s",
                list);
}

int gram_onenumber (char const *sym, char const *list)
{
    int
        index,
        ret;
        
    if (! list  || ! *list)
        numbererror (sym, list);

    /* try to find counter with name list */
    if ( (index = strtab_find (countername, ncountername, list)) > -1 )
        ret = counterval [index];
    /* nope.. interpret list as a numeric value */
    else if (! sscanf (list, "%d", &ret))
        numbererror (sym, list);

    return (ret);
}
