
#include "yodl.h"

void gram_pipethrough ()
{
    char
        *cmd,                           /* cmd as in yodl input file */
        *pipeto,                        /* stuff to write to cmd */
        *inbuf,                         /* buffer for cmd's output */
        tmpfile [255],                  /* temp filename */
        syscmd [1000];                  /* cmd as for popen() call */
    FILE
        *fcmd,                          /* popen()-ed cmd */
        *foutput;                       /* handle on child's output */
    struct stat
        statbuf;

    cmd = gram_parlist (builtin [mac_pipethrough], 1);

    while (lextok == tok_space ||               /* skip whitespace */
           lextok == tok_newline
          )
        lexer ();
    
    pipeto = gram_parlist (builtin [mac_pipethrough], 1);

    message (3, "%s %s\n", builtin [mac_pipethrough],
             str_short (cmd), str_short (mac_pipethrough)); 
                                    /*
                                        FBB 971029: str_short[] -> str_short()
                                    */

    if (! check_live_data (builtin [mac_pipethrough], cmd))
    {
        free (cmd);
        free (pipeto);
        return;
    }

    sprintf (tmpfile, "%s/yodlpipe.%d", TMPDIR, getpid());
    sprintf (syscmd, "%s > %s", cmd, tmpfile);
    free (cmd);

    if (! (fcmd = popen (syscmd, "w")) )
        showchildstatus (-1, syscmd);           /* .. and exit */
    if (pipeto && *pipeto)
        fputs (pipeto, fcmd);
    fclose (fcmd);
    free (pipeto);

    if (stat (tmpfile, &statbuf))               /* no output file */
        return;

    if (statbuf.st_size == 0)                   /* empty output file */
    {
        unlink (tmpfile);
        return;
    }

    foutput = open_file (tmpfile, "r");         /* open child's output */
    inbuf = xrealloc (0, statbuf.st_size + 1);  /* prepare buffer */
    inbuf [statbuf.st_size] = '\0';
    fread (inbuf, statbuf.st_size, 1, foutput); /* read in buffer */
    
    fclose (foutput);                           /* clean up file */
    unlink (tmpfile);

    lexer_pushstr (inbuf);                      /* paste in buffer */
    free (inbuf);
}
