
#include "yodl.h"

void gram_symbol ()                                 /* handle SYM(blabla) */
{
    int
        symindex;                                   /* index into builtin */
    static void (*gramfun[])(void) =
        {   
            gram_definesymbol,
            gram_includefile,
            gram_noexpand,
            gram_renamemacro,
            gram_undefinesymbol,
            gram_ifdef,
            gram_definemacro,
            gram_char,
            gram_comment,
            gram_typeout,
            gram_definechartable,
            gram_usechartable,
            gram_atexit,
            gram_dummy,
            gram_startdef,
            gram_enddef,
            gram_ifempty,
            gram_undefinemacro,
            gram_newcounter,
            gram_countervalue,
            gram_setcounter,
            gram_addtocounter,
            gram_usecounter,
            gram_error,
            gram_ifzero,
            (void (*)(void)) gram_paragraph,        /* unused, actually */
            gram_subst,
            gram_notrans,
            gram_chdir,
            gram_ifstrequal,
            gram_ifstrsub,
            gram_warning,
            gram_nousermacro,
            gram_system,
            gram_pipethrough,
            gram_uppercase,
            gram_includelit,
            gram_pushchartable,
            gram_popchartable,
        };
                                                    /* lookup the symbol */
    symindex = strtab_find (builtin, nbuiltin, lexbuf);
    
    if (symindex >= 0)                              /* if builtin function: */
    {
        lexer ();                                   /* prepare symbol */
        gramfun [symindex] ();                      /* start function */
    }
    else                                            /* user-defined ? */
    {
        if (! gram_expand ())                       /* try to expand macro */
        {
            output_string (lexbuf);                 /* or literal dump */
            lexer ();
        }
    }
}
