
#include "yodl.h"

int lexer_getc ()
{
    int
        ret;                                        /* returned char */
        
    if (lexer_eof ())                               /* avoid reading beyond */
        return (0);                                 /* EOF */

    if (lexer_pushed)                               /* stacked input? */
    {
        if (! lexer_pushedp)                        /* set initial ptr into */
            lexer_pushedp = lexer_pushed;           /* pushed info */

        ret = *lexer_pushedp;                       /* get next char, update */
        lexer_pushedp++;                            /* ptr into buf */

        if (! *lexer_pushedp)                       /* no more pushed chars? */
        {                                           /* cleanup */
            free (lexer_pushed);
            lexer_pushed = lexer_pushedp = 0;
        }
        return (ret);
    }
    else                                            /* pre-scan input */
    {
        lexer_preread ();
        return (lexer_getc ());                     /* recurse */
    }
}
