
#include "yodl.h"

void lexer_preread ()                   /* we don't have prepushed input */
{                                       /* so get some, and convert SUBST */
    int
        ch,
        index = 0;
    char
        *buf = 0;
        
    while (1)
    {
        ch = fgetc (inf);               /* read char from file */
        
        if (ch == '\n')
            cur_lineno++;               /* update line counter */

        if (feof (inf))                 /* stop at EOF */
            break;

        buf = str_addchar (buf, ch);    /* add to local buf */
        
        if (! subst_mightbe (buf))      /* not a subst? done */
            break;
                                        /* is a real subst? */
        if ( (index = strtab_find (subst, nsubst, buf)) != -1 )
        {
            lexer_pushstr (subst_redef [index]);
            if (gram_hasident (subst_redef [index]))
                lexer_pushchar ('+');
            free (buf);
            return;
        }

    }
    
    if (buf)
    {
        lexer_pushstr (buf);
        free (buf);
    }
}
