
#include "yodl.h"
#include "../../config.h"

void parse_flags (int ac, char **av)
{
    int
        opt;
        
    stdinclude = xstrdup (STD_INCLUDE);
        
    while ( (opt = getopt (ac, av, "?hD:I:l:o:P:p:tvw")) != -1 )
        switch (opt)
        {
            case 'l':
                if (! optarg || ! *optarg ||
                    (sscanf (optarg, "%d", &livedata) < 1)
                   )
                    error ("-l flag needs number");
                break;
                
            case 'D':
                if (! optarg || ! *optarg)
                    error ("-D flag lacks symbol name");
                define = strtab_add (define, &ndefine, optarg);
                break;
                
            case 'I':
                if (! optarg || ! *optarg)
                    error ("-I flag lacks directory name");
                free (stdinclude);
                stdinclude = xstrdup (optarg);
                break;
                
            case 'o':
                if (! optarg || ! *optarg)
                    error ("-o flag lacks output file name");
                outfname = xstrdup (optarg);
                break;
                
            case 'P':
                if (! optarg || ! *optarg)
                    error ("-P flag lacks preload-command");
                lexer_pushstr (optarg);
                break;
                
            case 'p':
                if (! optarg || ! *optarg)
                    error ("-p flag lacks number to specify max passes");
                if (! (maxpass = atoi (optarg)) )
                    error ("bad number after -p flag");
                break;
                
            case 't':
                flags.trace_output = 1;
                break;
                
            case 'v':
                verbose++;
                break;
                
            case 'w':
                flags.warn = 1;
                break;

            case '?':
            case 'h':
            default:
                usage ();
        }
        
    if (ac - optind < 1)
        usage ();
}
