
#include "yodl2html-post.h"

typedef struct
{
    char *tag;
    void (*fun)(STRINGTAB);
} TAGFUN;

static TAGFUN
    tagfun [] = 
    {
        { "documenttype",                   documenttype, },
        { "label",                          label, },
        { "lastnumber",                     lastnumber, },
        { "newfile",                        newfile, },
        { "ref",                            ref, },
        { "tableofcontents",                tableofcontents, },
        { "tocentry",                       tocentry, }, 
        { "bodytagopt",                     bodytagopt, }, 
        { "title",                          title, },
        { "solvelink",                      solvelink, },
        
        { 0,                                unknowntag, }

    };

void handletag (STRINGTAB tab)
{
    int
        i;
        
    if (! tab.str || ! tab.nstr)
        error ("invalid tag request, no tag inside markers");

    tagfun [sizeof (tagfun) / sizeof (TAGFUN) - 1].tag = tab.str [0];

    for (i = 0; ; i++)
        if (! strcmp (tagfun [i].tag, tab.str [1]))
        {
            tagfun [i].fun (tab);
            break;
        }
}

