
#include "yodlfixlabels.h"

void handlenotag (char *buf, int pass)
{
    char
        *cp,                                    /* tmp var */
        *outbuf;                                /* buffer to output */

    if (! pass)                                 /* no actions on first pass */
        return;
        
    outbuf = xstrdup (buf);                     /* assume buffer as-is */
        
    if (act.removeblank)                        /* kill ws request */
    {
        int
            allws = 1;                          /* assume all ws */

        if (act.killblanks)                     /* in killsp state? */
        {
            for (cp = outbuf; *cp; cp++)
                if (! isspace (*cp))            /* found text in buf */
                {
                    char
                        *newoutbuf = xstrdup (cp);
                    free (outbuf);
                    outbuf = newoutbuf;         /* set outbuf */
                    allws = 0;
                    break;
                }
            if (allws)                          /* only ws found? */
            {                                   /* do nothing */
                free (outbuf);
                return;
            }
        }
    }
    
    if (act.protectdot)                         /* protect dots, but not */
    {                                           /* if this is a tag-line */
        if (*outbuf == '.')
        {
            cp = xstrdup (".");
            cp = str_concat (cp, outbuf);
            free (outbuf);
            outbuf = cp;
        }
    }
    
                                                /* all checked, output it */
    if (outbuf && *outbuf)
        output (outf, "%s", outbuf);
    free (outbuf);
}
