
#define EXTERN
#include "yodlfixlabels.h"

int main (int argc, char **argv)
{   
    /* program name for error msg purposes */
    error_setprogname ("yodlfixlabels");
    
    /* parse program flags */
    parseflags (&argc, &argv);

    /* check that we have 2 args */
    if (argc != 3)
        usage ();
        
    /* open necessary files */
    inf = open_file (argv [1], "r");
    if (inf == stdin && !act.onepass)
        error ("in two-pass mode, the input file must be a real file");
    outf = open_file (argv [2], "w");

    /* preform first pass if requested */
    if (! act.onepass)
    {
        runpass (FIRSTPASS);
        fseek (inf, 0, SEEK_SET);
        lineno = 0;
    }
    runpass (LASTPASS);
    
    /* all done */
    return (0);
}
