#!@SHELL@

# Don't hack this script by hand if it's in one of your PATH directories.
# Instead, modify the pre-script in the YODL source package and do a 
# "make installscripts". This script is installed as yodl2manless AND
# as yodl2msless. Different groff macro commands, that's all.

#################################################### Print error msg and die.
error()
{
    echo 'yodl2@INEXT@less:' $@ 1>&2
    exit 1
}

################################################### Print usage info and die.
usage()
{
    cat << ENDUSAGE
    
Yodl2less @TOPLEVEL_VERSION@

Usage: yodl2less [OPTION]... FILE
Options:
    for processing, run "yodl" without arguments to see
This converter runs "yodl2@INEXT@" to convert the input file to groff
format, then runs "@MSTOASCII@" and pipes the output to
the "@LESS@" pager. 
Redirect to send the output to a file, as in
    yodl2@INEXT@less file > output
ENDUSAGE

    exit 1
}

###################################################### Start of main program.

# get all flags
flags=""
inf=""
while [ "$1" != "" ] ; do
    case $1 in
        -*)
            flags="$flags $1"
            shift
            ;;
        *)
            inf=$1
            shift
            ;;
    esac
done

# no input file, nogo
if [ "$inf" = "" ] ; then
    usage
fi

# determine output file
troffile=${inf%%.yo}.@INEXT@

PATH=$PATH:@YODL2LESS_DIR@
yodl2@INEXT@ $flags $inf || error "YODL to @INEXT@ conversion failed"

# are we redirected?
if [ -t ] ; then
    # nope.. pipe into less
    @MSTOASCII@ $troffile | @LESS@
else
    # yep, send it wherever it goes
    @MSTOASCII@ $troffile
fi
