
#include "yodl.h"

void 
sighandler (int sig)
{
  fflush (outf);

  if (sig == SIGSEGV)
    {
      fprintf (stderr,
	       "\n"
	       "Oops! Yodl caused a segment violation.\n"
	       "Bugs will only be fixed if you report them!\n"
	       "Please read Yodl(1) section PROBLEMS on how to report bugs.\n"
	);

      signal (SIGSEGV, SIG_DFL);
      kill (getpid (), SIGSEGV);
      exit (1);
    }

  error ("caught signal %d", sig);
}
