%{
#   include "yodl2html-post.h"

#   define YYSTYPE STRINGTAB
#   define YYDEBUG 1

extern int yylex ();
%}

/* Our tokens. */

%token tok_starttag tok_endtag tok_space tok_string

%% 
/* Grammar definition. */

input:
    input
    element
    |
    element
    ;
    
element:
    tok_space                       {
                                        if (pass)
                                            output (outf, "%s", yytext);
                                    }
    |
    tok_string                      {
                                        if (pass)
                                            output (outf, "%s", yytext);
                                    }
    |
    tagged_sequence
    ;

tagged_sequence:
    tok_starttag
    values
    tok_endtag                      {  
                                        handletag ($2);
                                        stringtab_reset (&$2);
                                    }
    ;
    
values:
    values
    value                           {   
                                        stringtab_addstr (&$$, $2.str [0]);
                                        stringtab_reset (&$2); 
			            }
    |
    value                           { 
                                        stringtab_setstr (&$$, $1.str [0]);
                                        stringtab_reset (&$1);
                                    }
    ;
    
value:
    tok_string                      { stringtab_setstr (&$$, yytext); }
    |
    tok_space                       { stringtab_setstr (&$$, yytext); }
    ;
