/* parser auto-generated by pidl */

#include "includes.h"
#include "autoconf/librpc/gen_ndr/ndr_dns.h"

#include "librpc/gen_ndr/ndr_misc.h"
_PUBLIC_ enum ndr_err_code ndr_push_dns_operation(struct ndr_push *ndr, int ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_operation(struct ndr_pull *ndr, int ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_operation(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_RCODE", DNS_RCODE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_FLAG_BROADCAST", DNS_FLAG_BROADCAST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_FLAG_RECURSION_AVAIL", DNS_FLAG_RECURSION_AVAIL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_FLAG_RECURSION_DESIRED", DNS_FLAG_RECURSION_DESIRED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_FLAG_TRUNCATION", DNS_FLAG_TRUNCATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_FLAG_AUTHORITATIVE", DNS_FLAG_AUTHORITATIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_OPCODE", DNS_OPCODE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "DNS_FLAG_REPLY", DNS_FLAG_REPLY, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_opcode(struct ndr_push *ndr, int ndr_flags, enum dns_opcode r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_opcode(struct ndr_pull *ndr, int ndr_flags, enum dns_opcode *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_opcode(struct ndr_print *ndr, const char *name, enum dns_opcode r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_OPCODE_QUERY: val = "DNS_OPCODE_QUERY"; break;
		case DNS_OPCODE_IQUERY: val = "DNS_OPCODE_IQUERY"; break;
		case DNS_OPCODE_STATUS: val = "DNS_OPCODE_STATUS"; break;
		case DNS_OPCODE_UPDATE: val = "DNS_OPCODE_UPDATE"; break;
		case DNS_OPCODE_RELEASE: val = "DNS_OPCODE_RELEASE"; break;
		case DNS_OPCODE_WACK: val = "DNS_OPCODE_WACK"; break;
		case DNS_OPCODE_REFRESH: val = "DNS_OPCODE_REFRESH"; break;
		case DNS_OPCODE_REFRESH2: val = "DNS_OPCODE_REFRESH2"; break;
		case DNS_OPCODE_MULTI_HOME_REG: val = "DNS_OPCODE_MULTI_HOME_REG"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_rcode(struct ndr_push *ndr, int ndr_flags, enum dns_rcode r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_rcode(struct ndr_pull *ndr, int ndr_flags, enum dns_rcode *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_rcode(struct ndr_print *ndr, const char *name, enum dns_rcode r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_RCODE_OK: val = "DNS_RCODE_OK"; break;
		case DNS_RCODE_FORMERR: val = "DNS_RCODE_FORMERR"; break;
		case DNS_RCODE_SERVFAIL: val = "DNS_RCODE_SERVFAIL"; break;
		case DNS_RCODE_NXDOMAIN: val = "DNS_RCODE_NXDOMAIN"; break;
		case DNS_RCODE_NOTIMP: val = "DNS_RCODE_NOTIMP"; break;
		case DNS_RCODE_REFUSED: val = "DNS_RCODE_REFUSED"; break;
		case DNS_RCODE_YXDOMAIN: val = "DNS_RCODE_YXDOMAIN"; break;
		case DNS_RCODE_YXRRSET: val = "DNS_RCODE_YXRRSET"; break;
		case DNS_RCODE_NXRRSET: val = "DNS_RCODE_NXRRSET"; break;
		case DNS_RCODE_NOTAUTH: val = "DNS_RCODE_NOTAUTH"; break;
		case DNS_RCODE_NOTZONE: val = "DNS_RCODE_NOTZONE"; break;
		case DNS_RCODE_BADSIG: val = "DNS_RCODE_BADSIG"; break;
		case DNS_RCODE_BADKEY: val = "DNS_RCODE_BADKEY"; break;
		case DNS_RCODE_BADTIME: val = "DNS_RCODE_BADTIME"; break;
		case DNS_RCODE_BADMODE: val = "DNS_RCODE_BADMODE"; break;
		case DNS_RCODE_BADNAME: val = "DNS_RCODE_BADNAME"; break;
		case DNS_RCODE_BADALG: val = "DNS_RCODE_BADALG"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_qclass(struct ndr_push *ndr, int ndr_flags, enum dns_qclass r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_qclass(struct ndr_pull *ndr, int ndr_flags, enum dns_qclass *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_qclass(struct ndr_print *ndr, const char *name, enum dns_qclass r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_QCLASS_IN: val = "DNS_QCLASS_IN"; break;
		case DNS_QCLASS_NONE: val = "DNS_QCLASS_NONE"; break;
		case DNS_QCLASS_ANY: val = "DNS_QCLASS_ANY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_qtype(struct ndr_push *ndr, int ndr_flags, enum dns_qtype r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_qtype(struct ndr_pull *ndr, int ndr_flags, enum dns_qtype *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_qtype(struct ndr_print *ndr, const char *name, enum dns_qtype r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_QTYPE_ZERO: val = "DNS_QTYPE_ZERO"; break;
		case DNS_QTYPE_A: val = "DNS_QTYPE_A"; break;
		case DNS_QTYPE_NS: val = "DNS_QTYPE_NS"; break;
		case DNS_QTYPE_MD: val = "DNS_QTYPE_MD"; break;
		case DNS_QTYPE_MF: val = "DNS_QTYPE_MF"; break;
		case DNS_QTYPE_CNAME: val = "DNS_QTYPE_CNAME"; break;
		case DNS_QTYPE_SOA: val = "DNS_QTYPE_SOA"; break;
		case DNS_QTYPE_MB: val = "DNS_QTYPE_MB"; break;
		case DNS_QTYPE_MG: val = "DNS_QTYPE_MG"; break;
		case DNS_QTYPE_MR: val = "DNS_QTYPE_MR"; break;
		case DNS_QTYPE_NULL: val = "DNS_QTYPE_NULL"; break;
		case DNS_QTYPE_WKS: val = "DNS_QTYPE_WKS"; break;
		case DNS_QTYPE_PTR: val = "DNS_QTYPE_PTR"; break;
		case DNS_QTYPE_HINFO: val = "DNS_QTYPE_HINFO"; break;
		case DNS_QTYPE_MINFO: val = "DNS_QTYPE_MINFO"; break;
		case DNS_QTYPE_MX: val = "DNS_QTYPE_MX"; break;
		case DNS_QTYPE_TXT: val = "DNS_QTYPE_TXT"; break;
		case DNS_QTYPE_RP: val = "DNS_QTYPE_RP"; break;
		case DNS_QTYPE_AFSDB: val = "DNS_QTYPE_AFSDB"; break;
		case DNS_QTYPE_X25: val = "DNS_QTYPE_X25"; break;
		case DNS_QTYPE_ISDN: val = "DNS_QTYPE_ISDN"; break;
		case DNS_QTYPE_RT: val = "DNS_QTYPE_RT"; break;
		case DNS_QTYPE_SIG: val = "DNS_QTYPE_SIG"; break;
		case DNS_QTYPE_KEY: val = "DNS_QTYPE_KEY"; break;
		case DNS_QTYPE_AAAA: val = "DNS_QTYPE_AAAA"; break;
		case DNS_QTYPE_LOC: val = "DNS_QTYPE_LOC"; break;
		case DNS_QTYPE_NXT: val = "DNS_QTYPE_NXT"; break;
		case DNS_QTYPE_NETBIOS: val = "DNS_QTYPE_NETBIOS"; break;
		case DNS_QTYPE_SRV: val = "DNS_QTYPE_SRV"; break;
		case DNS_QTYPE_ATMA: val = "DNS_QTYPE_ATMA"; break;
		case DNS_QTYPE_NAPTR: val = "DNS_QTYPE_NAPTR"; break;
		case DNS_QTYPE_DNAME: val = "DNS_QTYPE_DNAME"; break;
		case DNS_QTYPE_DS: val = "DNS_QTYPE_DS"; break;
		case DNS_QTYPE_RRSIG: val = "DNS_QTYPE_RRSIG"; break;
		case DNS_QTYPE_NSEC: val = "DNS_QTYPE_NSEC"; break;
		case DNS_QTYPE_DNSKEY: val = "DNS_QTYPE_DNSKEY"; break;
		case DNS_QTYPE_DHCID: val = "DNS_QTYPE_DHCID"; break;
		case DNS_QTYPE_TKEY: val = "DNS_QTYPE_TKEY"; break;
		case DNS_QTYPE_TSIG: val = "DNS_QTYPE_TSIG"; break;
		case DNS_QTYPE_AXFR: val = "DNS_QTYPE_AXFR"; break;
		case DNS_QTYPE_MAILB: val = "DNS_QTYPE_MAILB"; break;
		case DNS_QTYPE_MAILA: val = "DNS_QTYPE_MAILA"; break;
		case DNS_QTYPE_ALL: val = "DNS_QTYPE_ALL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_tkey_mode(struct ndr_push *ndr, int ndr_flags, enum dns_tkey_mode r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_tkey_mode(struct ndr_pull *ndr, int ndr_flags, enum dns_tkey_mode *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_tkey_mode(struct ndr_print *ndr, const char *name, enum dns_tkey_mode r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_TKEY_MODE_NULL: val = "DNS_TKEY_MODE_NULL"; break;
		case DNS_TKEY_MODE_SERVER: val = "DNS_TKEY_MODE_SERVER"; break;
		case DNS_TKEY_MODE_DH: val = "DNS_TKEY_MODE_DH"; break;
		case DNS_TKEY_MODE_GSSAPI: val = "DNS_TKEY_MODE_GSSAPI"; break;
		case DNS_TKEY_MODE_CLIENT: val = "DNS_TKEY_MODE_CLIENT"; break;
		case DNS_TKEY_MODE_DELETE: val = "DNS_TKEY_MODE_DELETE"; break;
		case DNS_TKEY_MODE_LAST: val = "DNS_TKEY_MODE_LAST"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_name_question(struct ndr_push *ndr, int ndr_flags, const struct dns_name_question *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->name));
		NDR_CHECK(ndr_push_dns_qtype(ndr, NDR_SCALARS, r->question_type));
		NDR_CHECK(ndr_push_dns_qclass(ndr, NDR_SCALARS, r->question_class));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_name_question(struct ndr_pull *ndr, int ndr_flags, struct dns_name_question *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->name));
		NDR_CHECK(ndr_pull_dns_qtype(ndr, NDR_SCALARS, &r->question_type));
		NDR_CHECK(ndr_pull_dns_qclass(ndr, NDR_SCALARS, &r->question_class));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_name_question(struct ndr_print *ndr, const char *name, const struct dns_name_question *r)
{
	ndr_print_struct(ndr, name, "dns_name_question");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dns_string(ndr, "name", r->name);
	ndr_print_dns_qtype(ndr, "question_type", r->question_type);
	ndr_print_dns_qclass(ndr, "question_class", r->question_class);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_rdata_data(struct ndr_push *ndr, int ndr_flags, const struct dns_rdata_data *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->data, r->length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_rdata_data(struct ndr_pull *ndr, int ndr_flags, struct dns_rdata_data *r)
{
	uint32_t size_data_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->length));
		size_data_0 = r->length;
		NDR_PULL_ALLOC_N(ndr, r->data, size_data_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->data, size_data_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_rdata_data(struct ndr_print *ndr, const char *name, const struct dns_rdata_data *r)
{
	ndr_print_struct(ndr, name, "dns_rdata_data");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "length", r->length);
	ndr_print_array_uint8(ndr, "data", r->data, r->length);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dns_soa_record(struct ndr_push *ndr, int ndr_flags, const struct dns_soa_record *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->mname));
		NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->rname));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->refresh));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->retry));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->expire));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minimum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_soa_record(struct ndr_pull *ndr, int ndr_flags, struct dns_soa_record *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->mname));
		NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->rname));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->refresh));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->retry));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->expire));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minimum));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_soa_record(struct ndr_print *ndr, const char *name, const struct dns_soa_record *r)
{
	ndr_print_struct(ndr, name, "dns_soa_record");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dns_string(ndr, "mname", r->mname);
	ndr_print_dns_string(ndr, "rname", r->rname);
	ndr_print_uint32(ndr, "serial", r->serial);
	ndr_print_uint32(ndr, "refresh", r->refresh);
	ndr_print_uint32(ndr, "retry", r->retry);
	ndr_print_uint32(ndr, "expire", r->expire);
	ndr_print_uint32(ndr, "minimum", r->minimum);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_mx_record(struct ndr_push *ndr, int ndr_flags, const struct dns_mx_record *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->preference));
		NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->exchange));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_mx_record(struct ndr_pull *ndr, int ndr_flags, struct dns_mx_record *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->preference));
		NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->exchange));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_mx_record(struct ndr_print *ndr, const char *name, const struct dns_mx_record *r)
{
	ndr_print_struct(ndr, name, "dns_mx_record");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "preference", r->preference);
	ndr_print_dns_string(ndr, "exchange", r->exchange);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_txt_record(struct ndr_push *ndr, int ndr_flags, const struct dns_txt_record *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, strlen(r->txt)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->txt, strlen(r->txt), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_txt_record(struct ndr_pull *ndr, int ndr_flags, struct dns_txt_record *r)
{
	uint32_t size_txt_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->length));
		size_txt_0 = r->length;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->txt, size_txt_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_txt_record(struct ndr_print *ndr, const char *name, const struct dns_txt_record *r)
{
	ndr_print_struct(ndr, name, "dns_txt_record");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->txt):r->length);
	ndr_print_string(ndr, "txt", r->txt);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_srv_record(struct ndr_push *ndr, int ndr_flags, const struct dns_srv_record *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->weight));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->port));
		NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->target));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_srv_record(struct ndr_pull *ndr, int ndr_flags, struct dns_srv_record *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->priority));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->weight));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
		NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->target));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_srv_record(struct ndr_print *ndr, const char *name, const struct dns_srv_record *r)
{
	ndr_print_struct(ndr, name, "dns_srv_record");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "priority", r->priority);
	ndr_print_uint16(ndr, "weight", r->weight);
	ndr_print_uint16(ndr, "port", r->port);
	ndr_print_dns_string(ndr, "target", r->target);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_tkey_record(struct ndr_push *ndr, int ndr_flags, const struct dns_tkey_record *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->algorithm));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->inception));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->expiration));
		NDR_CHECK(ndr_push_dns_tkey_mode(ndr, NDR_SCALARS, r->mode));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->error));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->key_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->key_data, r->key_size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->other_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->other_data, r->other_size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_tkey_record(struct ndr_pull *ndr, int ndr_flags, struct dns_tkey_record *r)
{
	uint32_t size_key_data_0 = 0;
	uint32_t size_other_data_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->algorithm));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->inception));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->expiration));
		NDR_CHECK(ndr_pull_dns_tkey_mode(ndr, NDR_SCALARS, &r->mode));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->error));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->key_size));
		size_key_data_0 = r->key_size;
		NDR_PULL_ALLOC_N(ndr, r->key_data, size_key_data_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->key_data, size_key_data_0));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->other_size));
		size_other_data_0 = r->other_size;
		NDR_PULL_ALLOC_N(ndr, r->other_data, size_other_data_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->other_data, size_other_data_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_tkey_record(struct ndr_print *ndr, const char *name, const struct dns_tkey_record *r)
{
	ndr_print_struct(ndr, name, "dns_tkey_record");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dns_string(ndr, "algorithm", r->algorithm);
	ndr_print_uint32(ndr, "inception", r->inception);
	ndr_print_uint32(ndr, "expiration", r->expiration);
	ndr_print_dns_tkey_mode(ndr, "mode", r->mode);
	ndr_print_uint16(ndr, "error", r->error);
	ndr_print_uint16(ndr, "key_size", r->key_size);
	ndr_print_array_uint8(ndr, "key_data", r->key_data, r->key_size);
	ndr_print_uint16(ndr, "other_size", r->other_size);
	ndr_print_array_uint8(ndr, "other_data", r->other_data, r->other_size);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_tsig_record(struct ndr_push *ndr, int ndr_flags, const struct dns_tsig_record *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->algorithm_name));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->time_prefix));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->fudge));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->mac_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->mac, r->mac_size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->original_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->error));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->other_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->other_data, r->other_size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_tsig_record(struct ndr_pull *ndr, int ndr_flags, struct dns_tsig_record *r)
{
	uint32_t size_mac_0 = 0;
	uint32_t size_other_data_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->algorithm_name));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->time_prefix));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->fudge));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->mac_size));
		size_mac_0 = r->mac_size;
		NDR_PULL_ALLOC_N(ndr, r->mac, size_mac_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->mac, size_mac_0));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->original_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->error));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->other_size));
		size_other_data_0 = r->other_size;
		NDR_PULL_ALLOC_N(ndr, r->other_data, size_other_data_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->other_data, size_other_data_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_tsig_record(struct ndr_print *ndr, const char *name, const struct dns_tsig_record *r)
{
	ndr_print_struct(ndr, name, "dns_tsig_record");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dns_string(ndr, "algorithm_name", r->algorithm_name);
	ndr_print_uint16(ndr, "time_prefix", r->time_prefix);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint16(ndr, "fudge", r->fudge);
	ndr_print_uint16(ndr, "mac_size", r->mac_size);
	ndr_print_array_uint8(ndr, "mac", r->mac, r->mac_size);
	ndr_print_uint16(ndr, "original_id", r->original_id);
	ndr_print_uint16(ndr, "error", r->error);
	ndr_print_uint16(ndr, "other_size", r->other_size);
	ndr_print_array_uint8(ndr, "other_data", r->other_data, r->other_size);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_fake_tsig_rec(struct ndr_push *ndr, int ndr_flags, const struct dns_fake_tsig_rec *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->name));
			NDR_CHECK(ndr_push_dns_qclass(ndr, NDR_SCALARS, r->rr_class));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ttl));
			NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->algorithm_name));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->time_prefix));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->fudge));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->original_id));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->error));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->other_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->other_data, r->other_size));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_fake_tsig_rec(struct ndr_pull *ndr, int ndr_flags, struct dns_fake_tsig_rec *r)
{
	uint32_t size_other_data_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->name));
			NDR_CHECK(ndr_pull_dns_qclass(ndr, NDR_SCALARS, &r->rr_class));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ttl));
			NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->algorithm_name));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->time_prefix));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->fudge));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->original_id));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->error));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->other_size));
			size_other_data_0 = r->other_size;
			NDR_PULL_ALLOC_N(ndr, r->other_data, size_other_data_0);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->other_data, size_other_data_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_fake_tsig_rec(struct ndr_print *ndr, const char *name, const struct dns_fake_tsig_rec *r)
{
	ndr_print_struct(ndr, name, "dns_fake_tsig_rec");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_dns_string(ndr, "name", r->name);
		ndr_print_dns_qclass(ndr, "rr_class", r->rr_class);
		ndr_print_uint32(ndr, "ttl", r->ttl);
		ndr_print_dns_string(ndr, "algorithm_name", r->algorithm_name);
		ndr_print_uint16(ndr, "time_prefix", r->time_prefix);
		ndr_print_uint32(ndr, "time", r->time);
		ndr_print_uint16(ndr, "fudge", r->fudge);
		ndr_print_uint16(ndr, "original_id", r->original_id);
		ndr_print_uint16(ndr, "error", r->error);
		ndr_print_uint16(ndr, "other_size", r->other_size);
		ndr_print_array_uint8(ndr, "other_data", r->other_data, r->other_size);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_rdata(struct ndr_push *ndr, int ndr_flags, const union dns_rdata *r)
{
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			uint32_t level = ndr_push_get_switch_value(ndr, r);
			NDR_CHECK(ndr_push_union_align(ndr, 4));
			switch (level) {
				case DNS_QTYPE_A: {
					NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4_record));
				break; }

				case DNS_QTYPE_NS: {
					NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->ns_record));
				break; }

				case DNS_QTYPE_CNAME: {
					NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->cname_record));
				break; }

				case DNS_QTYPE_SOA: {
					NDR_CHECK(ndr_push_dns_soa_record(ndr, NDR_SCALARS, &r->soa_record));
				break; }

				case DNS_QTYPE_PTR: {
					NDR_CHECK(ndr_push_dns_string(ndr, NDR_SCALARS, r->ptr_record));
				break; }

				case DNS_QTYPE_MX: {
					NDR_CHECK(ndr_push_dns_mx_record(ndr, NDR_SCALARS, &r->mx_record));
				break; }

				case DNS_QTYPE_TXT: {
					NDR_CHECK(ndr_push_dns_txt_record(ndr, NDR_SCALARS, &r->txt_record));
				break; }

				case DNS_QTYPE_AAAA: {
					NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6_record));
				break; }

				case DNS_QTYPE_SRV: {
					NDR_CHECK(ndr_push_dns_srv_record(ndr, NDR_SCALARS, &r->srv_record));
				break; }

				case DNS_QTYPE_TSIG: {
					NDR_CHECK(ndr_push_dns_tsig_record(ndr, NDR_SCALARS, &r->tsig_record));
				break; }

				case DNS_QTYPE_TKEY: {
					NDR_CHECK(ndr_push_dns_tkey_record(ndr, NDR_SCALARS, &r->tkey_record));
				break; }

				default: {
				break; }

			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			uint32_t level = ndr_push_get_switch_value(ndr, r);
			switch (level) {
				case DNS_QTYPE_A:
				break;

				case DNS_QTYPE_NS:
				break;

				case DNS_QTYPE_CNAME:
				break;

				case DNS_QTYPE_SOA:
				break;

				case DNS_QTYPE_PTR:
				break;

				case DNS_QTYPE_MX:
				break;

				case DNS_QTYPE_TXT:
				break;

				case DNS_QTYPE_AAAA:
				break;

				case DNS_QTYPE_SRV:
				break;

				case DNS_QTYPE_TSIG:
				break;

				case DNS_QTYPE_TKEY:
				break;

				default:
				break;

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_rdata(struct ndr_pull *ndr, int ndr_flags, union dns_rdata *r)
{
	uint32_t level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_pull_get_switch_value(ndr, r);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_union_align(ndr, 4));
			switch (level) {
				case DNS_QTYPE_A: {
					NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4_record));
				break; }

				case DNS_QTYPE_NS: {
					NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->ns_record));
				break; }

				case DNS_QTYPE_CNAME: {
					NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->cname_record));
				break; }

				case DNS_QTYPE_SOA: {
					NDR_CHECK(ndr_pull_dns_soa_record(ndr, NDR_SCALARS, &r->soa_record));
				break; }

				case DNS_QTYPE_PTR: {
					NDR_CHECK(ndr_pull_dns_string(ndr, NDR_SCALARS, &r->ptr_record));
				break; }

				case DNS_QTYPE_MX: {
					NDR_CHECK(ndr_pull_dns_mx_record(ndr, NDR_SCALARS, &r->mx_record));
				break; }

				case DNS_QTYPE_TXT: {
					NDR_CHECK(ndr_pull_dns_txt_record(ndr, NDR_SCALARS, &r->txt_record));
				break; }

				case DNS_QTYPE_AAAA: {
					NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6_record));
				break; }

				case DNS_QTYPE_SRV: {
					NDR_CHECK(ndr_pull_dns_srv_record(ndr, NDR_SCALARS, &r->srv_record));
				break; }

				case DNS_QTYPE_TSIG: {
					NDR_CHECK(ndr_pull_dns_tsig_record(ndr, NDR_SCALARS, &r->tsig_record));
				break; }

				case DNS_QTYPE_TKEY: {
					NDR_CHECK(ndr_pull_dns_tkey_record(ndr, NDR_SCALARS, &r->tkey_record));
				break; }

				default: {
				break; }

			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			switch (level) {
				case DNS_QTYPE_A:
				break;

				case DNS_QTYPE_NS:
				break;

				case DNS_QTYPE_CNAME:
				break;

				case DNS_QTYPE_SOA:
				break;

				case DNS_QTYPE_PTR:
				break;

				case DNS_QTYPE_MX:
				break;

				case DNS_QTYPE_TXT:
				break;

				case DNS_QTYPE_AAAA:
				break;

				case DNS_QTYPE_SRV:
				break;

				case DNS_QTYPE_TSIG:
				break;

				case DNS_QTYPE_TKEY:
				break;

				default:
				break;

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_rdata(struct ndr_print *ndr, const char *name, const union dns_rdata *r)
{
	uint32_t level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_print_get_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "dns_rdata");
		switch (level) {
			case DNS_QTYPE_A:
				ndr_print_ipv4address(ndr, "ipv4_record", r->ipv4_record);
			break;

			case DNS_QTYPE_NS:
				ndr_print_dns_string(ndr, "ns_record", r->ns_record);
			break;

			case DNS_QTYPE_CNAME:
				ndr_print_dns_string(ndr, "cname_record", r->cname_record);
			break;

			case DNS_QTYPE_SOA:
				ndr_print_dns_soa_record(ndr, "soa_record", &r->soa_record);
			break;

			case DNS_QTYPE_PTR:
				ndr_print_dns_string(ndr, "ptr_record", r->ptr_record);
			break;

			case DNS_QTYPE_MX:
				ndr_print_dns_mx_record(ndr, "mx_record", &r->mx_record);
			break;

			case DNS_QTYPE_TXT:
				ndr_print_dns_txt_record(ndr, "txt_record", &r->txt_record);
			break;

			case DNS_QTYPE_AAAA:
				ndr_print_ipv6address(ndr, "ipv6_record", r->ipv6_record);
			break;

			case DNS_QTYPE_SRV:
				ndr_print_dns_srv_record(ndr, "srv_record", &r->srv_record);
			break;

			case DNS_QTYPE_TSIG:
				ndr_print_dns_tsig_record(ndr, "tsig_record", &r->tsig_record);
			break;

			case DNS_QTYPE_TKEY:
				ndr_print_dns_tkey_record(ndr, "tkey_record", &r->tkey_record);
			break;

			default:
			break;

		}
		ndr->flags = _flags_save_UNION;
	}
}

_PUBLIC_ void ndr_print_dns_res_rec(struct ndr_print *ndr, const char *name, const struct dns_res_rec *r)
{
	ndr_print_struct(ndr, name, "dns_res_rec");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_dns_string(ndr, "name", r->name);
		ndr_print_dns_qtype(ndr, "rr_type", r->rr_type);
		ndr_print_dns_qclass(ndr, "rr_class", r->rr_class);
		ndr_print_uint32(ndr, "ttl", r->ttl);
		ndr_print_uint16(ndr, "length", r->length);
		ndr_print_set_switch_value(ndr, &r->rdata, r->rr_type);
		ndr_print_dns_rdata(ndr, "rdata", &r->rdata);
		ndr_print_DATA_BLOB(ndr, "unexpected", r->unexpected);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_name_packet(struct ndr_push *ndr, int ndr_flags, const struct dns_name_packet *r)
{
	uint32_t cntr_questions_0;
	uint32_t cntr_answers_0;
	uint32_t cntr_nsrecs_0;
	uint32_t cntr_additional_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->id));
			NDR_CHECK(ndr_push_dns_operation(ndr, NDR_SCALARS, r->operation));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->qdcount));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ancount));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->nscount));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->arcount));
			for (cntr_questions_0 = 0; cntr_questions_0 < r->qdcount; cntr_questions_0++) {
				NDR_CHECK(ndr_push_dns_name_question(ndr, NDR_SCALARS, &r->questions[cntr_questions_0]));
			}
			for (cntr_answers_0 = 0; cntr_answers_0 < r->ancount; cntr_answers_0++) {
				NDR_CHECK(ndr_push_dns_res_rec(ndr, NDR_SCALARS, &r->answers[cntr_answers_0]));
			}
			for (cntr_nsrecs_0 = 0; cntr_nsrecs_0 < r->nscount; cntr_nsrecs_0++) {
				NDR_CHECK(ndr_push_dns_res_rec(ndr, NDR_SCALARS, &r->nsrecs[cntr_nsrecs_0]));
			}
			for (cntr_additional_0 = 0; cntr_additional_0 < r->arcount; cntr_additional_0++) {
				NDR_CHECK(ndr_push_dns_res_rec(ndr, NDR_SCALARS, &r->additional[cntr_additional_0]));
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			for (cntr_answers_0 = 0; cntr_answers_0 < r->ancount; cntr_answers_0++) {
				NDR_CHECK(ndr_push_dns_res_rec(ndr, NDR_BUFFERS, &r->answers[cntr_answers_0]));
			}
			for (cntr_nsrecs_0 = 0; cntr_nsrecs_0 < r->nscount; cntr_nsrecs_0++) {
				NDR_CHECK(ndr_push_dns_res_rec(ndr, NDR_BUFFERS, &r->nsrecs[cntr_nsrecs_0]));
			}
			for (cntr_additional_0 = 0; cntr_additional_0 < r->arcount; cntr_additional_0++) {
				NDR_CHECK(ndr_push_dns_res_rec(ndr, NDR_BUFFERS, &r->additional[cntr_additional_0]));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_name_packet(struct ndr_pull *ndr, int ndr_flags, struct dns_name_packet *r)
{
	uint32_t size_questions_0 = 0;
	uint32_t cntr_questions_0;
	TALLOC_CTX *_mem_save_questions_0;
	uint32_t size_answers_0 = 0;
	uint32_t cntr_answers_0;
	TALLOC_CTX *_mem_save_answers_0;
	uint32_t size_nsrecs_0 = 0;
	uint32_t cntr_nsrecs_0;
	TALLOC_CTX *_mem_save_nsrecs_0;
	uint32_t size_additional_0 = 0;
	uint32_t cntr_additional_0;
	TALLOC_CTX *_mem_save_additional_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->id));
			NDR_CHECK(ndr_pull_dns_operation(ndr, NDR_SCALARS, &r->operation));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->qdcount));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ancount));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->nscount));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->arcount));
			size_questions_0 = r->qdcount;
			NDR_PULL_ALLOC_N(ndr, r->questions, size_questions_0);
			_mem_save_questions_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->questions, 0);
			for (cntr_questions_0 = 0; cntr_questions_0 < size_questions_0; cntr_questions_0++) {
				NDR_CHECK(ndr_pull_dns_name_question(ndr, NDR_SCALARS, &r->questions[cntr_questions_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_questions_0, 0);
			size_answers_0 = r->ancount;
			NDR_PULL_ALLOC_N(ndr, r->answers, size_answers_0);
			_mem_save_answers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->answers, 0);
			for (cntr_answers_0 = 0; cntr_answers_0 < size_answers_0; cntr_answers_0++) {
				NDR_CHECK(ndr_pull_dns_res_rec(ndr, NDR_SCALARS, &r->answers[cntr_answers_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_answers_0, 0);
			size_nsrecs_0 = r->nscount;
			NDR_PULL_ALLOC_N(ndr, r->nsrecs, size_nsrecs_0);
			_mem_save_nsrecs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->nsrecs, 0);
			for (cntr_nsrecs_0 = 0; cntr_nsrecs_0 < size_nsrecs_0; cntr_nsrecs_0++) {
				NDR_CHECK(ndr_pull_dns_res_rec(ndr, NDR_SCALARS, &r->nsrecs[cntr_nsrecs_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nsrecs_0, 0);
			size_additional_0 = r->arcount;
			NDR_PULL_ALLOC_N(ndr, r->additional, size_additional_0);
			_mem_save_additional_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->additional, 0);
			for (cntr_additional_0 = 0; cntr_additional_0 < size_additional_0; cntr_additional_0++) {
				NDR_CHECK(ndr_pull_dns_res_rec(ndr, NDR_SCALARS, &r->additional[cntr_additional_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_additional_0, 0);
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			size_answers_0 = r->ancount;
			_mem_save_answers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->answers, 0);
			for (cntr_answers_0 = 0; cntr_answers_0 < size_answers_0; cntr_answers_0++) {
				NDR_CHECK(ndr_pull_dns_res_rec(ndr, NDR_BUFFERS, &r->answers[cntr_answers_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_answers_0, 0);
			size_nsrecs_0 = r->nscount;
			_mem_save_nsrecs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->nsrecs, 0);
			for (cntr_nsrecs_0 = 0; cntr_nsrecs_0 < size_nsrecs_0; cntr_nsrecs_0++) {
				NDR_CHECK(ndr_pull_dns_res_rec(ndr, NDR_BUFFERS, &r->nsrecs[cntr_nsrecs_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nsrecs_0, 0);
			size_additional_0 = r->arcount;
			_mem_save_additional_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->additional, 0);
			for (cntr_additional_0 = 0; cntr_additional_0 < size_additional_0; cntr_additional_0++) {
				NDR_CHECK(ndr_pull_dns_res_rec(ndr, NDR_BUFFERS, &r->additional[cntr_additional_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_additional_0, 0);
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_name_packet(struct ndr_print *ndr, const char *name, const struct dns_name_packet *r)
{
	uint32_t cntr_questions_0;
	uint32_t cntr_answers_0;
	uint32_t cntr_nsrecs_0;
	uint32_t cntr_additional_0;
	ndr_print_struct(ndr, name, "dns_name_packet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint16(ndr, "id", r->id);
		ndr_print_dns_operation(ndr, "operation", r->operation);
		ndr_print_uint16(ndr, "qdcount", r->qdcount);
		ndr_print_uint16(ndr, "ancount", r->ancount);
		ndr_print_uint16(ndr, "nscount", r->nscount);
		ndr_print_uint16(ndr, "arcount", r->arcount);
		ndr->print(ndr, "%s: ARRAY(%d)", "questions", (int)r->qdcount);
		ndr->depth++;
		for (cntr_questions_0=0;cntr_questions_0<r->qdcount;cntr_questions_0++) {
			ndr_print_dns_name_question(ndr, "questions", &r->questions[cntr_questions_0]);
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "answers", (int)r->ancount);
		ndr->depth++;
		for (cntr_answers_0=0;cntr_answers_0<r->ancount;cntr_answers_0++) {
			ndr_print_dns_res_rec(ndr, "answers", &r->answers[cntr_answers_0]);
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "nsrecs", (int)r->nscount);
		ndr->depth++;
		for (cntr_nsrecs_0=0;cntr_nsrecs_0<r->nscount;cntr_nsrecs_0++) {
			ndr_print_dns_res_rec(ndr, "nsrecs", &r->nsrecs[cntr_nsrecs_0]);
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "additional", (int)r->arcount);
		ndr->depth++;
		for (cntr_additional_0=0;cntr_additional_0<r->arcount;cntr_additional_0++) {
			ndr_print_dns_res_rec(ndr, "additional", &r->additional[cntr_additional_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_decode_dns_name_packet(struct ndr_push *ndr, int flags, const struct decode_dns_name_packet *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_dns_name_packet(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.packet));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_decode_dns_name_packet(struct ndr_pull *ndr, int flags, struct decode_dns_name_packet *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_dns_name_packet(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.packet));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_decode_dns_name_packet(struct ndr_print *ndr, const char *name, int flags, const struct decode_dns_name_packet *r)
{
	ndr_print_struct(ndr, name, "decode_dns_name_packet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "decode_dns_name_packet");
		ndr->depth++;
		ndr_print_dns_name_packet(ndr, "packet", &r->in.packet);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "decode_dns_name_packet");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call dns_calls[] = {
	{
		"decode_dns_name_packet",
		sizeof(struct decode_dns_name_packet),
		(ndr_push_flags_fn_t) ndr_push_decode_dns_name_packet,
		(ndr_pull_flags_fn_t) ndr_pull_decode_dns_name_packet,
		(ndr_print_function_t) ndr_print_decode_dns_name_packet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const dns_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\dns]", 
};

static const struct ndr_interface_string_array dns_endpoints = {
	.count	= 1,
	.names	= dns_endpoint_strings
};

static const char * const dns_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array dns_authservices = {
	.count	= 1,
	.names	= dns_authservice_strings
};


const struct ndr_interface_table ndr_table_dns = {
	.name		= "dns",
	.syntax_id	= {
		{0xa047c001,0x5f22,0x40b0,{0x9d,0x52},{0x70,0x42,0xc4,0x3f,0x71,0x1a}},
		NDR_DNS_VERSION
	},
	.helpstring	= NDR_DNS_HELPSTRING,
	.num_calls	= 1,
	.calls		= dns_calls,
	.endpoints	= &dns_endpoints,
	.authservices	= &dns_authservices
};

