/* server functions auto-generated by pidl */
#include "autoconf/librpc/gen_ndr/ndr_ntsvcs.h"

NTSTATUS dcerpc_server_ntsvcs_init(void);

/* ntsvcs - dcerpc server boilerplate generated by pidl */


static NTSTATUS ntsvcs__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_NTSVCS_BIND
	return DCESRV_INTERFACE_NTSVCS_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ntsvcs__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NTSVCS_UNBIND
	DCESRV_INTERFACE_NTSVCS_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS ntsvcs__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_ntsvcs.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_ntsvcs.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_ntsvcs.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_ntsvcs.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_ntsvcs, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ntsvcs__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct PNP_Disconnect *r2 = (struct PNP_Disconnect *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Disconnect, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_Disconnect(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_Disconnect will reply async\n"));
		}
		break;
	}
	case 1: {
		struct PNP_Connect *r2 = (struct PNP_Connect *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Connect, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_Connect(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_Connect will reply async\n"));
		}
		break;
	}
	case 2: {
		struct PNP_GetVersion *r2 = (struct PNP_GetVersion *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersion, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetVersion(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetVersion will reply async\n"));
		}
		break;
	}
	case 3: {
		struct PNP_GetGlobalState *r2 = (struct PNP_GetGlobalState *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetGlobalState, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetGlobalState(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetGlobalState will reply async\n"));
		}
		break;
	}
	case 4: {
		struct PNP_InitDetection *r2 = (struct PNP_InitDetection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_InitDetection, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_InitDetection(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_InitDetection will reply async\n"));
		}
		break;
	}
	case 5: {
		struct PNP_ReportLogOn *r2 = (struct PNP_ReportLogOn *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ReportLogOn, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_ReportLogOn(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ReportLogOn will reply async\n"));
		}
		break;
	}
	case 6: {
		struct PNP_ValidateDeviceInstance *r2 = (struct PNP_ValidateDeviceInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ValidateDeviceInstance, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_ValidateDeviceInstance(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ValidateDeviceInstance will reply async\n"));
		}
		break;
	}
	case 7: {
		struct PNP_GetRootDeviceInstance *r2 = (struct PNP_GetRootDeviceInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRootDeviceInstance, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetRootDeviceInstance(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetRootDeviceInstance will reply async\n"));
		}
		break;
	}
	case 8: {
		struct PNP_GetRelatedDeviceInstance *r2 = (struct PNP_GetRelatedDeviceInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRelatedDeviceInstance, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetRelatedDeviceInstance(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetRelatedDeviceInstance will reply async\n"));
		}
		break;
	}
	case 9: {
		struct PNP_EnumerateSubKeys *r2 = (struct PNP_EnumerateSubKeys *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_EnumerateSubKeys, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_EnumerateSubKeys(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_EnumerateSubKeys will reply async\n"));
		}
		break;
	}
	case 10: {
		struct PNP_GetDeviceList *r2 = (struct PNP_GetDeviceList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceList, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetDeviceList(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceList will reply async\n"));
		}
		break;
	}
	case 11: {
		struct PNP_GetDeviceListSize *r2 = (struct PNP_GetDeviceListSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceListSize, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetDeviceListSize(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceListSize will reply async\n"));
		}
		break;
	}
	case 12: {
		struct PNP_GetDepth *r2 = (struct PNP_GetDepth *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDepth, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetDepth(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDepth will reply async\n"));
		}
		break;
	}
	case 13: {
		struct PNP_GetDeviceRegProp *r2 = (struct PNP_GetDeviceRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceRegProp, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetDeviceRegProp(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceRegProp will reply async\n"));
		}
		break;
	}
	case 14: {
		struct PNP_SetDeviceRegProp *r2 = (struct PNP_SetDeviceRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceRegProp, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_SetDeviceRegProp(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetDeviceRegProp will reply async\n"));
		}
		break;
	}
	case 15: {
		struct PNP_GetClassInstance *r2 = (struct PNP_GetClassInstance *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassInstance, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetClassInstance(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassInstance will reply async\n"));
		}
		break;
	}
	case 16: {
		struct PNP_CreateKey *r2 = (struct PNP_CreateKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_CreateKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_CreateKey will reply async\n"));
		}
		break;
	}
	case 17: {
		struct PNP_DeleteRegistryKey *r2 = (struct PNP_DeleteRegistryKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteRegistryKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_DeleteRegistryKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeleteRegistryKey will reply async\n"));
		}
		break;
	}
	case 18: {
		struct PNP_GetClassCount *r2 = (struct PNP_GetClassCount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassCount, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetClassCount(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassCount will reply async\n"));
		}
		break;
	}
	case 19: {
		struct PNP_GetClassName *r2 = (struct PNP_GetClassName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassName, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetClassName(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassName will reply async\n"));
		}
		break;
	}
	case 20: {
		struct PNP_DeleteClassKey *r2 = (struct PNP_DeleteClassKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteClassKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_DeleteClassKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeleteClassKey will reply async\n"));
		}
		break;
	}
	case 21: {
		struct PNP_GetInterfaceDeviceAlias *r2 = (struct PNP_GetInterfaceDeviceAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceAlias, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetInterfaceDeviceAlias(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceAlias will reply async\n"));
		}
		break;
	}
	case 22: {
		struct PNP_GetInterfaceDeviceList *r2 = (struct PNP_GetInterfaceDeviceList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceList, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetInterfaceDeviceList(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceList will reply async\n"));
		}
		break;
	}
	case 23: {
		struct PNP_GetInterfaceDeviceListSize *r2 = (struct PNP_GetInterfaceDeviceListSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceListSize, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetInterfaceDeviceListSize(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceListSize will reply async\n"));
		}
		break;
	}
	case 24: {
		struct PNP_RegisterDeviceClassAssociation *r2 = (struct PNP_RegisterDeviceClassAssociation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDeviceClassAssociation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_RegisterDeviceClassAssociation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterDeviceClassAssociation will reply async\n"));
		}
		break;
	}
	case 25: {
		struct PNP_UnregisterDeviceClassAssociation *r2 = (struct PNP_UnregisterDeviceClassAssociation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterDeviceClassAssociation, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_UnregisterDeviceClassAssociation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UnregisterDeviceClassAssociation will reply async\n"));
		}
		break;
	}
	case 26: {
		struct PNP_GetClassRegProp *r2 = (struct PNP_GetClassRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassRegProp, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetClassRegProp(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassRegProp will reply async\n"));
		}
		break;
	}
	case 27: {
		struct PNP_SetClassRegProp *r2 = (struct PNP_SetClassRegProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetClassRegProp, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_SetClassRegProp(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetClassRegProp will reply async\n"));
		}
		break;
	}
	case 28: {
		struct PNP_CreateDevInst *r2 = (struct PNP_CreateDevInst *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateDevInst, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_CreateDevInst(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_CreateDevInst will reply async\n"));
		}
		break;
	}
	case 29: {
		struct PNP_DeviceInstanceAction *r2 = (struct PNP_DeviceInstanceAction *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeviceInstanceAction, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_DeviceInstanceAction(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeviceInstanceAction will reply async\n"));
		}
		break;
	}
	case 30: {
		struct PNP_GetDeviceStatus *r2 = (struct PNP_GetDeviceStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceStatus, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetDeviceStatus(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceStatus will reply async\n"));
		}
		break;
	}
	case 31: {
		struct PNP_SetDeviceProblem *r2 = (struct PNP_SetDeviceProblem *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceProblem, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_SetDeviceProblem(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetDeviceProblem will reply async\n"));
		}
		break;
	}
	case 32: {
		struct PNP_DisableDevInst *r2 = (struct PNP_DisableDevInst *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DisableDevInst, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_DisableDevInst(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DisableDevInst will reply async\n"));
		}
		break;
	}
	case 33: {
		struct PNP_UninstallDevInst *r2 = (struct PNP_UninstallDevInst *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UninstallDevInst, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_UninstallDevInst(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UninstallDevInst will reply async\n"));
		}
		break;
	}
	case 34: {
		struct PNP_AddID *r2 = (struct PNP_AddID *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddID, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_AddID(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddID will reply async\n"));
		}
		break;
	}
	case 35: {
		struct PNP_RegisterDriver *r2 = (struct PNP_RegisterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDriver, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_RegisterDriver(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterDriver will reply async\n"));
		}
		break;
	}
	case 36: {
		struct PNP_QueryRemove *r2 = (struct PNP_QueryRemove *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryRemove, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_QueryRemove(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryRemove will reply async\n"));
		}
		break;
	}
	case 37: {
		struct PNP_RequestDeviceEject *r2 = (struct PNP_RequestDeviceEject *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestDeviceEject, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_RequestDeviceEject(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RequestDeviceEject will reply async\n"));
		}
		break;
	}
	case 38: {
		struct PNP_IsDockStationPresent *r2 = (struct PNP_IsDockStationPresent *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_IsDockStationPresent, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_IsDockStationPresent(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_IsDockStationPresent will reply async\n"));
		}
		break;
	}
	case 39: {
		struct PNP_RequestEjectPC *r2 = (struct PNP_RequestEjectPC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestEjectPC, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_RequestEjectPC(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RequestEjectPC will reply async\n"));
		}
		break;
	}
	case 40: {
		struct PNP_HwProfFlags *r2 = (struct PNP_HwProfFlags *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_HwProfFlags, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_HwProfFlags(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_HwProfFlags will reply async\n"));
		}
		break;
	}
	case 41: {
		struct PNP_GetHwProfInfo *r2 = (struct PNP_GetHwProfInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetHwProfInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetHwProfInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetHwProfInfo will reply async\n"));
		}
		break;
	}
	case 42: {
		struct PNP_AddEmptyLogConf *r2 = (struct PNP_AddEmptyLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddEmptyLogConf, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_AddEmptyLogConf(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddEmptyLogConf will reply async\n"));
		}
		break;
	}
	case 43: {
		struct PNP_FreeLogConf *r2 = (struct PNP_FreeLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeLogConf, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_FreeLogConf(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_FreeLogConf will reply async\n"));
		}
		break;
	}
	case 44: {
		struct PNP_GetFirstLogConf *r2 = (struct PNP_GetFirstLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetFirstLogConf, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetFirstLogConf(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetFirstLogConf will reply async\n"));
		}
		break;
	}
	case 45: {
		struct PNP_GetNextLogConf *r2 = (struct PNP_GetNextLogConf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextLogConf, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetNextLogConf(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetNextLogConf will reply async\n"));
		}
		break;
	}
	case 46: {
		struct PNP_GetLogConfPriority *r2 = (struct PNP_GetLogConfPriority *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetLogConfPriority, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetLogConfPriority(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetLogConfPriority will reply async\n"));
		}
		break;
	}
	case 47: {
		struct PNP_AddResDes *r2 = (struct PNP_AddResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddResDes, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_AddResDes(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddResDes will reply async\n"));
		}
		break;
	}
	case 48: {
		struct PNP_FreeResDes *r2 = (struct PNP_FreeResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeResDes, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_FreeResDes(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_FreeResDes will reply async\n"));
		}
		break;
	}
	case 49: {
		struct PNP_GetNextResDes *r2 = (struct PNP_GetNextResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextResDes, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetNextResDes(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetNextResDes will reply async\n"));
		}
		break;
	}
	case 50: {
		struct PNP_GetResDesData *r2 = (struct PNP_GetResDesData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetResDesData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetResDesData will reply async\n"));
		}
		break;
	}
	case 51: {
		struct PNP_GetResDesDataSize *r2 = (struct PNP_GetResDesDataSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesDataSize, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetResDesDataSize(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetResDesDataSize will reply async\n"));
		}
		break;
	}
	case 52: {
		struct PNP_ModifyResDes *r2 = (struct PNP_ModifyResDes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ModifyResDes, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_ModifyResDes(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ModifyResDes will reply async\n"));
		}
		break;
	}
	case 53: {
		struct PNP_DetectResourceLimit *r2 = (struct PNP_DetectResourceLimit *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DetectResourceLimit, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_DetectResourceLimit(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DetectResourceLimit will reply async\n"));
		}
		break;
	}
	case 54: {
		struct PNP_QueryResConfList *r2 = (struct PNP_QueryResConfList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryResConfList, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_QueryResConfList(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryResConfList will reply async\n"));
		}
		break;
	}
	case 55: {
		struct PNP_SetHwProf *r2 = (struct PNP_SetHwProf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetHwProf, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_SetHwProf(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetHwProf will reply async\n"));
		}
		break;
	}
	case 56: {
		struct PNP_QueryArbitratorFreeData *r2 = (struct PNP_QueryArbitratorFreeData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_QueryArbitratorFreeData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryArbitratorFreeData will reply async\n"));
		}
		break;
	}
	case 57: {
		struct PNP_QueryArbitratorFreeSize *r2 = (struct PNP_QueryArbitratorFreeSize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeSize, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_QueryArbitratorFreeSize(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryArbitratorFreeSize will reply async\n"));
		}
		break;
	}
	case 58: {
		struct PNP_RunDetection *r2 = (struct PNP_RunDetection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RunDetection, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_RunDetection(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RunDetection will reply async\n"));
		}
		break;
	}
	case 59: {
		struct PNP_RegisterNotification *r2 = (struct PNP_RegisterNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterNotification, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_RegisterNotification(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterNotification will reply async\n"));
		}
		break;
	}
	case 60: {
		struct PNP_UnregisterNotification *r2 = (struct PNP_UnregisterNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterNotification, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_UnregisterNotification(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UnregisterNotification will reply async\n"));
		}
		break;
	}
	case 61: {
		struct PNP_GetCustomDevProp *r2 = (struct PNP_GetCustomDevProp *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetCustomDevProp, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetCustomDevProp(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetCustomDevProp will reply async\n"));
		}
		break;
	}
	case 62: {
		struct PNP_GetVersionInternal *r2 = (struct PNP_GetVersionInternal *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersionInternal, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetVersionInternal(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetVersionInternal will reply async\n"));
		}
		break;
	}
	case 63: {
		struct PNP_GetBlockedDriverInfo *r2 = (struct PNP_GetBlockedDriverInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetBlockedDriverInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetBlockedDriverInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetBlockedDriverInfo will reply async\n"));
		}
		break;
	}
	case 64: {
		struct PNP_GetServerSideDeviceInstallFlags *r2 = (struct PNP_GetServerSideDeviceInstallFlags *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetServerSideDeviceInstallFlags, NDR_IN, r2);
		}
		r2->out.result = dcesrv_PNP_GetServerSideDeviceInstallFlags(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetServerSideDeviceInstallFlags will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_ntsvcs, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ntsvcs__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct PNP_Disconnect *r2 = (struct PNP_Disconnect *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_Disconnect replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Disconnect, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_Disconnect\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct PNP_Connect *r2 = (struct PNP_Connect *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_Connect replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_Connect, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_Connect\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct PNP_GetVersion *r2 = (struct PNP_GetVersion *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetVersion replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersion, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetVersion\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct PNP_GetGlobalState *r2 = (struct PNP_GetGlobalState *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetGlobalState replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetGlobalState, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetGlobalState\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct PNP_InitDetection *r2 = (struct PNP_InitDetection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_InitDetection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_InitDetection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_InitDetection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct PNP_ReportLogOn *r2 = (struct PNP_ReportLogOn *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ReportLogOn replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ReportLogOn, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_ReportLogOn\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct PNP_ValidateDeviceInstance *r2 = (struct PNP_ValidateDeviceInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ValidateDeviceInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ValidateDeviceInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_ValidateDeviceInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct PNP_GetRootDeviceInstance *r2 = (struct PNP_GetRootDeviceInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetRootDeviceInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRootDeviceInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetRootDeviceInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct PNP_GetRelatedDeviceInstance *r2 = (struct PNP_GetRelatedDeviceInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetRelatedDeviceInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetRelatedDeviceInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetRelatedDeviceInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct PNP_EnumerateSubKeys *r2 = (struct PNP_EnumerateSubKeys *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_EnumerateSubKeys replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_EnumerateSubKeys, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_EnumerateSubKeys\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct PNP_GetDeviceList *r2 = (struct PNP_GetDeviceList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetDeviceList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct PNP_GetDeviceListSize *r2 = (struct PNP_GetDeviceListSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceListSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceListSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetDeviceListSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct PNP_GetDepth *r2 = (struct PNP_GetDepth *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDepth replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDepth, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetDepth\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct PNP_GetDeviceRegProp *r2 = (struct PNP_GetDeviceRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetDeviceRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct PNP_SetDeviceRegProp *r2 = (struct PNP_SetDeviceRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetDeviceRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_SetDeviceRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct PNP_GetClassInstance *r2 = (struct PNP_GetClassInstance *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassInstance replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassInstance, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetClassInstance\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct PNP_CreateKey *r2 = (struct PNP_CreateKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_CreateKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_CreateKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct PNP_DeleteRegistryKey *r2 = (struct PNP_DeleteRegistryKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeleteRegistryKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteRegistryKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_DeleteRegistryKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct PNP_GetClassCount *r2 = (struct PNP_GetClassCount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassCount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassCount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetClassCount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct PNP_GetClassName *r2 = (struct PNP_GetClassName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetClassName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct PNP_DeleteClassKey *r2 = (struct PNP_DeleteClassKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeleteClassKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeleteClassKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_DeleteClassKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct PNP_GetInterfaceDeviceAlias *r2 = (struct PNP_GetInterfaceDeviceAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetInterfaceDeviceAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct PNP_GetInterfaceDeviceList *r2 = (struct PNP_GetInterfaceDeviceList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetInterfaceDeviceList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct PNP_GetInterfaceDeviceListSize *r2 = (struct PNP_GetInterfaceDeviceListSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetInterfaceDeviceListSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetInterfaceDeviceListSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetInterfaceDeviceListSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct PNP_RegisterDeviceClassAssociation *r2 = (struct PNP_RegisterDeviceClassAssociation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterDeviceClassAssociation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDeviceClassAssociation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_RegisterDeviceClassAssociation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct PNP_UnregisterDeviceClassAssociation *r2 = (struct PNP_UnregisterDeviceClassAssociation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UnregisterDeviceClassAssociation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterDeviceClassAssociation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_UnregisterDeviceClassAssociation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct PNP_GetClassRegProp *r2 = (struct PNP_GetClassRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetClassRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetClassRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetClassRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct PNP_SetClassRegProp *r2 = (struct PNP_SetClassRegProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetClassRegProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetClassRegProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_SetClassRegProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct PNP_CreateDevInst *r2 = (struct PNP_CreateDevInst *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_CreateDevInst replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_CreateDevInst, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_CreateDevInst\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct PNP_DeviceInstanceAction *r2 = (struct PNP_DeviceInstanceAction *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DeviceInstanceAction replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DeviceInstanceAction, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_DeviceInstanceAction\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct PNP_GetDeviceStatus *r2 = (struct PNP_GetDeviceStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetDeviceStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetDeviceStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetDeviceStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct PNP_SetDeviceProblem *r2 = (struct PNP_SetDeviceProblem *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetDeviceProblem replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetDeviceProblem, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_SetDeviceProblem\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct PNP_DisableDevInst *r2 = (struct PNP_DisableDevInst *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DisableDevInst replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DisableDevInst, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_DisableDevInst\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct PNP_UninstallDevInst *r2 = (struct PNP_UninstallDevInst *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UninstallDevInst replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UninstallDevInst, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_UninstallDevInst\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct PNP_AddID *r2 = (struct PNP_AddID *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddID replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddID, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_AddID\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 35: {
		struct PNP_RegisterDriver *r2 = (struct PNP_RegisterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_RegisterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 36: {
		struct PNP_QueryRemove *r2 = (struct PNP_QueryRemove *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryRemove replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryRemove, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_QueryRemove\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 37: {
		struct PNP_RequestDeviceEject *r2 = (struct PNP_RequestDeviceEject *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RequestDeviceEject replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestDeviceEject, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_RequestDeviceEject\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 38: {
		struct PNP_IsDockStationPresent *r2 = (struct PNP_IsDockStationPresent *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_IsDockStationPresent replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_IsDockStationPresent, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_IsDockStationPresent\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 39: {
		struct PNP_RequestEjectPC *r2 = (struct PNP_RequestEjectPC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RequestEjectPC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RequestEjectPC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_RequestEjectPC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 40: {
		struct PNP_HwProfFlags *r2 = (struct PNP_HwProfFlags *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_HwProfFlags replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_HwProfFlags, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_HwProfFlags\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 41: {
		struct PNP_GetHwProfInfo *r2 = (struct PNP_GetHwProfInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetHwProfInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetHwProfInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetHwProfInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 42: {
		struct PNP_AddEmptyLogConf *r2 = (struct PNP_AddEmptyLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddEmptyLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddEmptyLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_AddEmptyLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 43: {
		struct PNP_FreeLogConf *r2 = (struct PNP_FreeLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_FreeLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_FreeLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 44: {
		struct PNP_GetFirstLogConf *r2 = (struct PNP_GetFirstLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetFirstLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetFirstLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetFirstLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 45: {
		struct PNP_GetNextLogConf *r2 = (struct PNP_GetNextLogConf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetNextLogConf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextLogConf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetNextLogConf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 46: {
		struct PNP_GetLogConfPriority *r2 = (struct PNP_GetLogConfPriority *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetLogConfPriority replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetLogConfPriority, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetLogConfPriority\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 47: {
		struct PNP_AddResDes *r2 = (struct PNP_AddResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_AddResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_AddResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_AddResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 48: {
		struct PNP_FreeResDes *r2 = (struct PNP_FreeResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_FreeResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_FreeResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_FreeResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 49: {
		struct PNP_GetNextResDes *r2 = (struct PNP_GetNextResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetNextResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetNextResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetNextResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 50: {
		struct PNP_GetResDesData *r2 = (struct PNP_GetResDesData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetResDesData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetResDesData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 51: {
		struct PNP_GetResDesDataSize *r2 = (struct PNP_GetResDesDataSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetResDesDataSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetResDesDataSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetResDesDataSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 52: {
		struct PNP_ModifyResDes *r2 = (struct PNP_ModifyResDes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_ModifyResDes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_ModifyResDes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_ModifyResDes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 53: {
		struct PNP_DetectResourceLimit *r2 = (struct PNP_DetectResourceLimit *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_DetectResourceLimit replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_DetectResourceLimit, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_DetectResourceLimit\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 54: {
		struct PNP_QueryResConfList *r2 = (struct PNP_QueryResConfList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryResConfList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryResConfList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_QueryResConfList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 55: {
		struct PNP_SetHwProf *r2 = (struct PNP_SetHwProf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_SetHwProf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_SetHwProf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_SetHwProf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 56: {
		struct PNP_QueryArbitratorFreeData *r2 = (struct PNP_QueryArbitratorFreeData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryArbitratorFreeData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_QueryArbitratorFreeData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 57: {
		struct PNP_QueryArbitratorFreeSize *r2 = (struct PNP_QueryArbitratorFreeSize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_QueryArbitratorFreeSize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_QueryArbitratorFreeSize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_QueryArbitratorFreeSize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 58: {
		struct PNP_RunDetection *r2 = (struct PNP_RunDetection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RunDetection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RunDetection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_RunDetection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 59: {
		struct PNP_RegisterNotification *r2 = (struct PNP_RegisterNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_RegisterNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_RegisterNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_RegisterNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 60: {
		struct PNP_UnregisterNotification *r2 = (struct PNP_UnregisterNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_UnregisterNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_UnregisterNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_UnregisterNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 61: {
		struct PNP_GetCustomDevProp *r2 = (struct PNP_GetCustomDevProp *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetCustomDevProp replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetCustomDevProp, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetCustomDevProp\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 62: {
		struct PNP_GetVersionInternal *r2 = (struct PNP_GetVersionInternal *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetVersionInternal replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetVersionInternal, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetVersionInternal\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 63: {
		struct PNP_GetBlockedDriverInfo *r2 = (struct PNP_GetBlockedDriverInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetBlockedDriverInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetBlockedDriverInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetBlockedDriverInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 64: {
		struct PNP_GetServerSideDeviceInstallFlags *r2 = (struct PNP_GetServerSideDeviceInstallFlags *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function PNP_GetServerSideDeviceInstallFlags replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(PNP_GetServerSideDeviceInstallFlags, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in PNP_GetServerSideDeviceInstallFlags\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_ntsvcs, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ntsvcs__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_ntsvcs.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_ntsvcs_interface = {
	.name		= "ntsvcs",
	.syntax_id  = {{0x8d9f4e40,0xa03d,0x11ce,{0x8f,0x69},{0x08,0x00,0x3e,0x30,0x05,0x1b}},1.0},
	.bind		= ntsvcs__op_bind,
	.unbind		= ntsvcs__op_unbind,
	.ndr_pull	= ntsvcs__op_ndr_pull,
	.dispatch	= ntsvcs__op_dispatch,
	.reply		= ntsvcs__op_reply,
	.ndr_push	= ntsvcs__op_ndr_push
};


static NTSTATUS ntsvcs__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_ntsvcs.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_ntsvcs.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_ntsvcs_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("ntsvcs_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool ntsvcs__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_ntsvcs_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_ntsvcs_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_ntsvcs_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool ntsvcs__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_ntsvcs_interface.name, name)==0) {
		memcpy(iface, &dcesrv_ntsvcs_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_ntsvcs_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "ntsvcs";

	/* fill in all the operations */
	ep_server.init_server = ntsvcs__op_init_server;

	ep_server.interface_by_uuid = ntsvcs__op_interface_by_uuid;
	ep_server.interface_by_name = ntsvcs__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'ntsvcs' endpoint server!\n"));
		return ret;
	}

	return ret;
}

