
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_krb5pac.h"
#include "autoconf/librpc/gen_ndr/ndr_krb5pac_c.h"

#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/samr.h"
staticforward PyTypeObject PAC_LOGON_NAME_Type;
staticforward PyTypeObject PAC_SIGNATURE_DATA_Type;
staticforward PyTypeObject PAC_LOGON_INFO_Type;
staticforward PyTypeObject PAC_CONSTRAINED_DELEGATION_Type;
staticforward PyTypeObject PAC_UNKNOWN_12_Type;
staticforward PyTypeObject PAC_LOGON_INFO_CTR_Type;
staticforward PyTypeObject PAC_CONSTRAINED_DELEGATION_CTR_Type;
staticforward PyTypeObject DATA_BLOB_REM_Type;
staticforward PyTypeObject PAC_BUFFER_Type;
staticforward PyTypeObject PAC_DATA_Type;
staticforward PyTypeObject PAC_BUFFER_RAW_Type;
staticforward PyTypeObject PAC_DATA_RAW_Type;
staticforward PyTypeObject PAC_Validate_Type;
staticforward PyTypeObject netsamlogoncache_entry_Type;
staticforward PyTypeObject krb5pac_InterfaceType;

void initkrb5pac(void);static PyTypeObject *Object_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *samr_RidWithAttributeArray_Type;
static PyTypeObject *netr_SamInfo3_Type;
static PyTypeObject *lsa_String_Type;

static PyObject *py_PAC_LOGON_NAME_get_logon_time(PyObject *obj, void *closure)
{
	struct PAC_LOGON_NAME *object = (struct PAC_LOGON_NAME *)pytalloc_get_ptr(obj);
	PyObject *py_logon_time;
	py_logon_time = PyLong_FromLongLong(object->logon_time);
	return py_logon_time;
}

static int py_PAC_LOGON_NAME_set_logon_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_NAME *object = (struct PAC_LOGON_NAME *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->logon_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->logon_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_PAC_LOGON_NAME_get_size(PyObject *obj, void *closure)
{
	struct PAC_LOGON_NAME *object = (struct PAC_LOGON_NAME *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_PAC_LOGON_NAME_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_NAME *object = (struct PAC_LOGON_NAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_LOGON_NAME_get_account_name(PyObject *obj, void *closure)
{
	struct PAC_LOGON_NAME *object = (struct PAC_LOGON_NAME *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
	}
	return py_account_name;
}

static int py_PAC_LOGON_NAME_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_NAME *object = (struct PAC_LOGON_NAME *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->account_name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_PAC_LOGON_NAME_getsetters[] = {
	{ discard_const_p(char, "logon_time"), py_PAC_LOGON_NAME_get_logon_time, py_PAC_LOGON_NAME_set_logon_time },
	{ discard_const_p(char, "size"), py_PAC_LOGON_NAME_get_size, py_PAC_LOGON_NAME_set_size },
	{ discard_const_p(char, "account_name"), py_PAC_LOGON_NAME_get_account_name, py_PAC_LOGON_NAME_set_account_name },
	{ NULL }
};

static PyObject *py_PAC_LOGON_NAME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_LOGON_NAME, type);
}


static PyTypeObject PAC_LOGON_NAME_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_LOGON_NAME",
	.tp_getset = py_PAC_LOGON_NAME_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_LOGON_NAME_new,
};


static PyObject *py_PAC_SIGNATURE_DATA_get_type(PyObject *obj, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = (struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_PAC_SIGNATURE_DATA_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = (struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_SIGNATURE_DATA_get_signature(PyObject *obj, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = (struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(obj);
	PyObject *py_signature;
	py_signature = PyString_FromStringAndSize((char *)(object->signature).data, (object->signature).length);
	return py_signature;
}

static int py_PAC_SIGNATURE_DATA_set_signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_SIGNATURE_DATA *object = (struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(py_obj);
	object->signature = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_PAC_SIGNATURE_DATA_getsetters[] = {
	{ discard_const_p(char, "type"), py_PAC_SIGNATURE_DATA_get_type, py_PAC_SIGNATURE_DATA_set_type },
	{ discard_const_p(char, "signature"), py_PAC_SIGNATURE_DATA_get_signature, py_PAC_SIGNATURE_DATA_set_signature },
	{ NULL }
};

static PyObject *py_PAC_SIGNATURE_DATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_SIGNATURE_DATA, type);
}

static PyObject *py_PAC_SIGNATURE_DATA_ndr_pack(PyObject *py_obj)
{
	struct PAC_SIGNATURE_DATA *object = (struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_SIGNATURE_DATA);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_SIGNATURE_DATA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_SIGNATURE_DATA *object = (struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_SIGNATURE_DATA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_SIGNATURE_DATA);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_SIGNATURE_DATA_ndr_print(PyObject *py_obj)
{
	struct PAC_SIGNATURE_DATA *object = (struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_SIGNATURE_DATA, "PAC_SIGNATURE_DATA", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_SIGNATURE_DATA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_SIGNATURE_DATA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_SIGNATURE_DATA_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_SIGNATURE_DATA_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_SIGNATURE_DATA_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_SIGNATURE_DATA",
	.tp_getset = py_PAC_SIGNATURE_DATA_getsetters,
	.tp_methods = py_PAC_SIGNATURE_DATA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_SIGNATURE_DATA_new,
};


static PyObject *py_PAC_LOGON_INFO_get_info3(PyObject *obj, void *closure)
{
	struct PAC_LOGON_INFO *object = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_info3;
	py_info3 = pytalloc_reference_ex(netr_SamInfo3_Type, pytalloc_get_mem_ctx(obj), &object->info3);
	return py_info3;
}

static int py_PAC_LOGON_INFO_set_info3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_INFO *object = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(netr_SamInfo3_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info3 = *(struct netr_SamInfo3 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_PAC_LOGON_INFO_get_res_group_dom_sid(PyObject *obj, void *closure)
{
	struct PAC_LOGON_INFO *object = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_res_group_dom_sid;
	if (object->res_group_dom_sid == NULL) {
		py_res_group_dom_sid = Py_None;
		Py_INCREF(py_res_group_dom_sid);
	} else {
		py_res_group_dom_sid = pytalloc_reference_ex(dom_sid_Type, object->res_group_dom_sid, object->res_group_dom_sid);
	}
	return py_res_group_dom_sid;
}

static int py_PAC_LOGON_INFO_set_res_group_dom_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_INFO *object = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->res_group_dom_sid);
	if (value == Py_None) {
		object->res_group_dom_sid = NULL;
	} else {
		object->res_group_dom_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->res_group_dom_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_PAC_LOGON_INFO_get_res_groups(PyObject *obj, void *closure)
{
	struct PAC_LOGON_INFO *object = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_res_groups;
	py_res_groups = pytalloc_reference_ex(samr_RidWithAttributeArray_Type, pytalloc_get_mem_ctx(obj), &object->res_groups);
	return py_res_groups;
}

static int py_PAC_LOGON_INFO_set_res_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_INFO *object = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_RidWithAttributeArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->res_groups = *(struct samr_RidWithAttributeArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_PAC_LOGON_INFO_getsetters[] = {
	{ discard_const_p(char, "info3"), py_PAC_LOGON_INFO_get_info3, py_PAC_LOGON_INFO_set_info3 },
	{ discard_const_p(char, "res_group_dom_sid"), py_PAC_LOGON_INFO_get_res_group_dom_sid, py_PAC_LOGON_INFO_set_res_group_dom_sid },
	{ discard_const_p(char, "res_groups"), py_PAC_LOGON_INFO_get_res_groups, py_PAC_LOGON_INFO_set_res_groups },
	{ NULL }
};

static PyObject *py_PAC_LOGON_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_LOGON_INFO, type);
}


static PyTypeObject PAC_LOGON_INFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_LOGON_INFO",
	.tp_getset = py_PAC_LOGON_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_LOGON_INFO_new,
};


static PyObject *py_PAC_CONSTRAINED_DELEGATION_get_proxy_target(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(obj);
	PyObject *py_proxy_target;
	py_proxy_target = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->proxy_target);
	return py_proxy_target;
}

static int py_PAC_CONSTRAINED_DELEGATION_set_proxy_target(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->proxy_target = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_get_num_transited_services(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(obj);
	PyObject *py_num_transited_services;
	py_num_transited_services = PyInt_FromLong(object->num_transited_services);
	return py_num_transited_services;
}

static int py_PAC_CONSTRAINED_DELEGATION_set_num_transited_services(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_transited_services = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_get_transited_services(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(obj);
	PyObject *py_transited_services;
	if (object->transited_services == NULL) {
		py_transited_services = Py_None;
		Py_INCREF(py_transited_services);
	} else {
		py_transited_services = PyList_New(object->num_transited_services);
		if (py_transited_services == NULL) {
			return NULL;
		}
		{
			int transited_services_cntr_1;
			for (transited_services_cntr_1 = 0; transited_services_cntr_1 < object->num_transited_services; transited_services_cntr_1++) {
				PyObject *py_transited_services_1;
				py_transited_services_1 = pytalloc_reference_ex(lsa_String_Type, object->transited_services, &object->transited_services[transited_services_cntr_1]);
				PyList_SetItem(py_transited_services, transited_services_cntr_1, py_transited_services_1);
			}
		}
	}
	return py_transited_services;
}

static int py_PAC_CONSTRAINED_DELEGATION_set_transited_services(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION *object = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->transited_services);
	if (value == Py_None) {
		object->transited_services = NULL;
	} else {
		object->transited_services = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int transited_services_cntr_1;
			object->transited_services = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->transited_services, PyList_GET_SIZE(value));
			if (!object->transited_services) { return -1;; }
			talloc_set_name_const(object->transited_services, "ARRAY: object->transited_services");
			for (transited_services_cntr_1 = 0; transited_services_cntr_1 < PyList_GET_SIZE(value); transited_services_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, transited_services_cntr_1), return -1;);
				if (talloc_reference(object->transited_services, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, transited_services_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->transited_services[transited_services_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, transited_services_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_CONSTRAINED_DELEGATION_getsetters[] = {
	{ discard_const_p(char, "proxy_target"), py_PAC_CONSTRAINED_DELEGATION_get_proxy_target, py_PAC_CONSTRAINED_DELEGATION_set_proxy_target },
	{ discard_const_p(char, "num_transited_services"), py_PAC_CONSTRAINED_DELEGATION_get_num_transited_services, py_PAC_CONSTRAINED_DELEGATION_set_num_transited_services },
	{ discard_const_p(char, "transited_services"), py_PAC_CONSTRAINED_DELEGATION_get_transited_services, py_PAC_CONSTRAINED_DELEGATION_set_transited_services },
	{ NULL }
};

static PyObject *py_PAC_CONSTRAINED_DELEGATION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CONSTRAINED_DELEGATION, type);
}


static PyTypeObject PAC_CONSTRAINED_DELEGATION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_CONSTRAINED_DELEGATION",
	.tp_getset = py_PAC_CONSTRAINED_DELEGATION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_CONSTRAINED_DELEGATION_new,
};


static PyObject *py_PAC_UNKNOWN_12_get_upn_size(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_upn_size;
	py_upn_size = PyInt_FromLong(object->upn_size);
	return py_upn_size;
}

static int py_PAC_UNKNOWN_12_set_upn_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->upn_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_upn_offset(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_upn_offset;
	py_upn_offset = PyInt_FromLong(object->upn_offset);
	return py_upn_offset;
}

static int py_PAC_UNKNOWN_12_set_upn_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->upn_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_domain_size(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_domain_size;
	py_domain_size = PyInt_FromLong(object->domain_size);
	return py_domain_size;
}

static int py_PAC_UNKNOWN_12_set_domain_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->domain_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_domain_offset(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_domain_offset;
	py_domain_offset = PyInt_FromLong(object->domain_offset);
	return py_domain_offset;
}

static int py_PAC_UNKNOWN_12_set_domain_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->domain_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_unknown3(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyInt_FromLong(object->unknown3);
	return py_unknown3;
}

static int py_PAC_UNKNOWN_12_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_unknown4(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyInt_FromLong(object->unknown4);
	return py_unknown4;
}

static int py_PAC_UNKNOWN_12_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown4 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_unknown5(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_PAC_UNKNOWN_12_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_upn_name(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_upn_name;
	if (object->upn_name == NULL) {
		py_upn_name = Py_None;
		Py_INCREF(py_upn_name);
	} else {
		py_upn_name = PyUnicode_Decode(object->upn_name, strlen(object->upn_name), "utf-8", "ignore");
	}
	return py_upn_name;
}

static int py_PAC_UNKNOWN_12_set_upn_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->upn_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->upn_name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_domain_name(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
	}
	return py_domain_name;
}

static int py_PAC_UNKNOWN_12_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->domain_name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_PAC_UNKNOWN_12_get_unknown6(PyObject *obj, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_PAC_UNKNOWN_12_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_UNKNOWN_12 *object = (struct PAC_UNKNOWN_12 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_PAC_UNKNOWN_12_getsetters[] = {
	{ discard_const_p(char, "upn_size"), py_PAC_UNKNOWN_12_get_upn_size, py_PAC_UNKNOWN_12_set_upn_size },
	{ discard_const_p(char, "upn_offset"), py_PAC_UNKNOWN_12_get_upn_offset, py_PAC_UNKNOWN_12_set_upn_offset },
	{ discard_const_p(char, "domain_size"), py_PAC_UNKNOWN_12_get_domain_size, py_PAC_UNKNOWN_12_set_domain_size },
	{ discard_const_p(char, "domain_offset"), py_PAC_UNKNOWN_12_get_domain_offset, py_PAC_UNKNOWN_12_set_domain_offset },
	{ discard_const_p(char, "unknown3"), py_PAC_UNKNOWN_12_get_unknown3, py_PAC_UNKNOWN_12_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_PAC_UNKNOWN_12_get_unknown4, py_PAC_UNKNOWN_12_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_PAC_UNKNOWN_12_get_unknown5, py_PAC_UNKNOWN_12_set_unknown5 },
	{ discard_const_p(char, "upn_name"), py_PAC_UNKNOWN_12_get_upn_name, py_PAC_UNKNOWN_12_set_upn_name },
	{ discard_const_p(char, "domain_name"), py_PAC_UNKNOWN_12_get_domain_name, py_PAC_UNKNOWN_12_set_domain_name },
	{ discard_const_p(char, "unknown6"), py_PAC_UNKNOWN_12_get_unknown6, py_PAC_UNKNOWN_12_set_unknown6 },
	{ NULL }
};

static PyObject *py_PAC_UNKNOWN_12_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_UNKNOWN_12, type);
}


static PyTypeObject PAC_UNKNOWN_12_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_UNKNOWN_12",
	.tp_getset = py_PAC_UNKNOWN_12_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_UNKNOWN_12_new,
};


static PyObject *py_PAC_LOGON_INFO_CTR_get_info(PyObject *obj, void *closure)
{
	struct PAC_LOGON_INFO_CTR *object = (struct PAC_LOGON_INFO_CTR *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&PAC_LOGON_INFO_Type, object->info, object->info);
	}
	return py_info;
}

static int py_PAC_LOGON_INFO_CTR_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_LOGON_INFO_CTR *object = (struct PAC_LOGON_INFO_CTR *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&PAC_LOGON_INFO_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct PAC_LOGON_INFO *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_PAC_LOGON_INFO_CTR_getsetters[] = {
	{ discard_const_p(char, "info"), py_PAC_LOGON_INFO_CTR_get_info, py_PAC_LOGON_INFO_CTR_set_info },
	{ NULL }
};

static PyObject *py_PAC_LOGON_INFO_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_LOGON_INFO_CTR, type);
}

static PyObject *py_PAC_LOGON_INFO_CTR_ndr_pack(PyObject *py_obj)
{
	struct PAC_LOGON_INFO_CTR *object = (struct PAC_LOGON_INFO_CTR *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_LOGON_INFO_CTR);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_LOGON_INFO_CTR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_LOGON_INFO_CTR *object = (struct PAC_LOGON_INFO_CTR *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_LOGON_INFO_CTR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_LOGON_INFO_CTR);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_LOGON_INFO_CTR_ndr_print(PyObject *py_obj)
{
	struct PAC_LOGON_INFO_CTR *object = (struct PAC_LOGON_INFO_CTR *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_LOGON_INFO_CTR, "PAC_LOGON_INFO_CTR", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_LOGON_INFO_CTR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_LOGON_INFO_CTR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_LOGON_INFO_CTR_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_LOGON_INFO_CTR_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_LOGON_INFO_CTR_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_LOGON_INFO_CTR",
	.tp_getset = py_PAC_LOGON_INFO_CTR_getsetters,
	.tp_methods = py_PAC_LOGON_INFO_CTR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_LOGON_INFO_CTR_new,
};


static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_get_info(PyObject *obj, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = (struct PAC_CONSTRAINED_DELEGATION_CTR *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&PAC_CONSTRAINED_DELEGATION_Type, object->info, object->info);
	}
	return py_info;
}

static int py_PAC_CONSTRAINED_DELEGATION_CTR_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = (struct PAC_CONSTRAINED_DELEGATION_CTR *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&PAC_CONSTRAINED_DELEGATION_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct PAC_CONSTRAINED_DELEGATION *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_PAC_CONSTRAINED_DELEGATION_CTR_getsetters[] = {
	{ discard_const_p(char, "info"), py_PAC_CONSTRAINED_DELEGATION_CTR_get_info, py_PAC_CONSTRAINED_DELEGATION_CTR_set_info },
	{ NULL }
};

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_CONSTRAINED_DELEGATION_CTR, type);
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_pack(PyObject *py_obj)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = (struct PAC_CONSTRAINED_DELEGATION_CTR *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_CONSTRAINED_DELEGATION_CTR);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = (struct PAC_CONSTRAINED_DELEGATION_CTR *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CONSTRAINED_DELEGATION_CTR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_CONSTRAINED_DELEGATION_CTR);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_print(PyObject *py_obj)
{
	struct PAC_CONSTRAINED_DELEGATION_CTR *object = (struct PAC_CONSTRAINED_DELEGATION_CTR *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_CONSTRAINED_DELEGATION_CTR, "PAC_CONSTRAINED_DELEGATION_CTR", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_CONSTRAINED_DELEGATION_CTR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_CONSTRAINED_DELEGATION_CTR_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_CONSTRAINED_DELEGATION_CTR_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_CONSTRAINED_DELEGATION_CTR",
	.tp_getset = py_PAC_CONSTRAINED_DELEGATION_CTR_getsetters,
	.tp_methods = py_PAC_CONSTRAINED_DELEGATION_CTR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_CONSTRAINED_DELEGATION_CTR_new,
};


static PyObject *py_DATA_BLOB_REM_get_remaining(PyObject *obj, void *closure)
{
	struct DATA_BLOB_REM *object = (struct DATA_BLOB_REM *)pytalloc_get_ptr(obj);
	PyObject *py_remaining;
	py_remaining = PyString_FromStringAndSize((char *)(object->remaining).data, (object->remaining).length);
	return py_remaining;
}

static int py_DATA_BLOB_REM_set_remaining(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DATA_BLOB_REM *object = (struct DATA_BLOB_REM *)pytalloc_get_ptr(py_obj);
	object->remaining = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_DATA_BLOB_REM_getsetters[] = {
	{ discard_const_p(char, "remaining"), py_DATA_BLOB_REM_get_remaining, py_DATA_BLOB_REM_set_remaining },
	{ NULL }
};

static PyObject *py_DATA_BLOB_REM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DATA_BLOB_REM, type);
}


static PyTypeObject DATA_BLOB_REM_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.DATA_BLOB_REM",
	.tp_getset = py_DATA_BLOB_REM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DATA_BLOB_REM_new,
};

PyObject *py_import_PAC_INFO(TALLOC_CTX *mem_ctx, int level, union PAC_INFO *in)
{
	PyObject *ret;

	switch (level) {
		case PAC_TYPE_LOGON_INFO:
			ret = pytalloc_reference_ex(&PAC_LOGON_INFO_CTR_Type, mem_ctx, &in->logon_info);
			return ret;

		case PAC_TYPE_SRV_CHECKSUM:
			ret = pytalloc_reference_ex(&PAC_SIGNATURE_DATA_Type, mem_ctx, &in->srv_cksum);
			return ret;

		case PAC_TYPE_KDC_CHECKSUM:
			ret = pytalloc_reference_ex(&PAC_SIGNATURE_DATA_Type, mem_ctx, &in->kdc_cksum);
			return ret;

		case PAC_TYPE_LOGON_NAME:
			ret = pytalloc_reference_ex(&PAC_LOGON_NAME_Type, mem_ctx, &in->logon_name);
			return ret;

		case PAC_TYPE_CONSTRAINED_DELEGATION:
			ret = pytalloc_reference_ex(&PAC_CONSTRAINED_DELEGATION_CTR_Type, mem_ctx, &in->constrained_delegation);
			return ret;

		default:
			ret = pytalloc_reference_ex(&DATA_BLOB_REM_Type, mem_ctx, &in->unknown);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union PAC_INFO *py_export_PAC_INFO(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union PAC_INFO *ret = talloc_zero(mem_ctx, union PAC_INFO);
	switch (level) {
		case PAC_TYPE_LOGON_INFO:
			PY_CHECK_TYPE(&PAC_LOGON_INFO_CTR_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon_info = *(struct PAC_LOGON_INFO_CTR *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_SRV_CHECKSUM:
			PY_CHECK_TYPE(&PAC_SIGNATURE_DATA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv_cksum = *(struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_KDC_CHECKSUM:
			PY_CHECK_TYPE(&PAC_SIGNATURE_DATA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->kdc_cksum = *(struct PAC_SIGNATURE_DATA *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_LOGON_NAME:
			PY_CHECK_TYPE(&PAC_LOGON_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon_name = *(struct PAC_LOGON_NAME *)pytalloc_get_ptr(in);
			break;

		case PAC_TYPE_CONSTRAINED_DELEGATION:
			PY_CHECK_TYPE(&PAC_CONSTRAINED_DELEGATION_CTR_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->constrained_delegation = *(struct PAC_CONSTRAINED_DELEGATION_CTR *)pytalloc_get_ptr(in);
			break;

		default:
			PY_CHECK_TYPE(&DATA_BLOB_REM_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->unknown = *(struct DATA_BLOB_REM *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}


static PyObject *py_PAC_BUFFER_get_type(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_PAC_BUFFER_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_get__ndr_size(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(obj);
	PyObject *py__ndr_size;
	py__ndr_size = PyInt_FromLong(object->_ndr_size);
	return py__ndr_size;
}

static int py_PAC_BUFFER_set__ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_ndr_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_BUFFER_get_info(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = py_import_PAC_INFO(object->info, object->type, object->info);
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_PAC_BUFFER_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		{
			union PAC_INFO *info_switch_2;
			info_switch_2 = py_export_PAC_INFO(pytalloc_get_mem_ctx(py_obj), object->type, value);
			if (info_switch_2 == NULL) {
				return -1;
			}
			object->info = info_switch_2;
		}
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_get__pad(PyObject *obj, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_PAC_BUFFER_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_PAC_BUFFER_getsetters[] = {
	{ discard_const_p(char, "type"), py_PAC_BUFFER_get_type, py_PAC_BUFFER_set_type },
	{ discard_const_p(char, "_ndr_size"), py_PAC_BUFFER_get__ndr_size, py_PAC_BUFFER_set__ndr_size },
	{ discard_const_p(char, "info"), py_PAC_BUFFER_get_info, py_PAC_BUFFER_set_info },
	{ discard_const_p(char, "_pad"), py_PAC_BUFFER_get__pad, py_PAC_BUFFER_set__pad },
	{ NULL }
};

static PyObject *py_PAC_BUFFER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_BUFFER, type);
}

static PyObject *py_PAC_BUFFER_ndr_pack(PyObject *py_obj)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_BUFFER);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_BUFFER_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_BUFFER_ndr_print(PyObject *py_obj)
{
	struct PAC_BUFFER *object = (struct PAC_BUFFER *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_BUFFER, "PAC_BUFFER", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_BUFFER_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_BUFFER_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_BUFFER_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_BUFFER_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_BUFFER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_BUFFER",
	.tp_getset = py_PAC_BUFFER_getsetters,
	.tp_methods = py_PAC_BUFFER_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_BUFFER_new,
};


static PyObject *py_PAC_DATA_get_num_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(obj);
	PyObject *py_num_buffers;
	py_num_buffers = PyInt_FromLong(object->num_buffers);
	return py_num_buffers;
}

static int py_PAC_DATA_set_num_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_buffers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_DATA_get_version(PyObject *obj, void *closure)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_PAC_DATA_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_DATA_get_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(obj);
	PyObject *py_buffers;
	py_buffers = PyList_New(object->num_buffers);
	if (py_buffers == NULL) {
		return NULL;
	}
	{
		int buffers_cntr_0;
		for (buffers_cntr_0 = 0; buffers_cntr_0 < object->num_buffers; buffers_cntr_0++) {
			PyObject *py_buffers_0;
			py_buffers_0 = pytalloc_reference_ex(&PAC_BUFFER_Type, object->buffers, &object->buffers[buffers_cntr_0]);
			PyList_SetItem(py_buffers, buffers_cntr_0, py_buffers_0);
		}
	}
	return py_buffers;
}

static int py_PAC_DATA_set_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffers_cntr_0;
		object->buffers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffers, PyList_GET_SIZE(value));
		if (!object->buffers) { return -1;; }
		talloc_set_name_const(object->buffers, "ARRAY: object->buffers");
		for (buffers_cntr_0 = 0; buffers_cntr_0 < PyList_GET_SIZE(value); buffers_cntr_0++) {
			PY_CHECK_TYPE(&PAC_BUFFER_Type, PyList_GET_ITEM(value, buffers_cntr_0), return -1;);
			if (talloc_reference(object->buffers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, buffers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->buffers[buffers_cntr_0] = *(struct PAC_BUFFER *)pytalloc_get_ptr(PyList_GET_ITEM(value, buffers_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_DATA_getsetters[] = {
	{ discard_const_p(char, "num_buffers"), py_PAC_DATA_get_num_buffers, py_PAC_DATA_set_num_buffers },
	{ discard_const_p(char, "version"), py_PAC_DATA_get_version, py_PAC_DATA_set_version },
	{ discard_const_p(char, "buffers"), py_PAC_DATA_get_buffers, py_PAC_DATA_set_buffers },
	{ NULL }
};

static PyObject *py_PAC_DATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_DATA, type);
}

static PyObject *py_PAC_DATA_ndr_pack(PyObject *py_obj)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_DATA);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_DATA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_DATA_ndr_print(PyObject *py_obj)
{
	struct PAC_DATA *object = (struct PAC_DATA *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_DATA, "PAC_DATA", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_DATA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_DATA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_DATA_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_DATA_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_DATA_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_DATA",
	.tp_getset = py_PAC_DATA_getsetters,
	.tp_methods = py_PAC_DATA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_DATA_new,
};


static PyObject *py_PAC_BUFFER_RAW_get_type(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_PAC_BUFFER_RAW_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_RAW_get_ndr_size(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(obj);
	PyObject *py_ndr_size;
	py_ndr_size = PyInt_FromLong(object->ndr_size);
	return py_ndr_size;
}

static int py_PAC_BUFFER_RAW_set_ndr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ndr_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_BUFFER_RAW_get_info(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&DATA_BLOB_REM_Type, object->info, object->info);
	}
	return py_info;
}

static int py_PAC_BUFFER_RAW_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&DATA_BLOB_REM_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct DATA_BLOB_REM *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_PAC_BUFFER_RAW_get__pad(PyObject *obj, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyInt_FromLong(object->_pad);
	return py__pad;
}

static int py_PAC_BUFFER_RAW_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->_pad = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_PAC_BUFFER_RAW_getsetters[] = {
	{ discard_const_p(char, "type"), py_PAC_BUFFER_RAW_get_type, py_PAC_BUFFER_RAW_set_type },
	{ discard_const_p(char, "ndr_size"), py_PAC_BUFFER_RAW_get_ndr_size, py_PAC_BUFFER_RAW_set_ndr_size },
	{ discard_const_p(char, "info"), py_PAC_BUFFER_RAW_get_info, py_PAC_BUFFER_RAW_set_info },
	{ discard_const_p(char, "_pad"), py_PAC_BUFFER_RAW_get__pad, py_PAC_BUFFER_RAW_set__pad },
	{ NULL }
};

static PyObject *py_PAC_BUFFER_RAW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_BUFFER_RAW, type);
}

static PyObject *py_PAC_BUFFER_RAW_ndr_pack(PyObject *py_obj)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_BUFFER_RAW);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_BUFFER_RAW_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER_RAW);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_BUFFER_RAW);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_BUFFER_RAW_ndr_print(PyObject *py_obj)
{
	struct PAC_BUFFER_RAW *object = (struct PAC_BUFFER_RAW *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_BUFFER_RAW, "PAC_BUFFER_RAW", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_BUFFER_RAW_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_BUFFER_RAW_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_BUFFER_RAW_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_BUFFER_RAW_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_BUFFER_RAW_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_BUFFER_RAW",
	.tp_getset = py_PAC_BUFFER_RAW_getsetters,
	.tp_methods = py_PAC_BUFFER_RAW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_BUFFER_RAW_new,
};


static PyObject *py_PAC_DATA_RAW_get_num_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(obj);
	PyObject *py_num_buffers;
	py_num_buffers = PyInt_FromLong(object->num_buffers);
	return py_num_buffers;
}

static int py_PAC_DATA_RAW_set_num_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_buffers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_DATA_RAW_get_version(PyObject *obj, void *closure)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_PAC_DATA_RAW_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_DATA_RAW_get_buffers(PyObject *obj, void *closure)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(obj);
	PyObject *py_buffers;
	py_buffers = PyList_New(object->num_buffers);
	if (py_buffers == NULL) {
		return NULL;
	}
	{
		int buffers_cntr_0;
		for (buffers_cntr_0 = 0; buffers_cntr_0 < object->num_buffers; buffers_cntr_0++) {
			PyObject *py_buffers_0;
			py_buffers_0 = pytalloc_reference_ex(&PAC_BUFFER_RAW_Type, object->buffers, &object->buffers[buffers_cntr_0]);
			PyList_SetItem(py_buffers, buffers_cntr_0, py_buffers_0);
		}
	}
	return py_buffers;
}

static int py_PAC_DATA_RAW_set_buffers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int buffers_cntr_0;
		object->buffers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffers, PyList_GET_SIZE(value));
		if (!object->buffers) { return -1;; }
		talloc_set_name_const(object->buffers, "ARRAY: object->buffers");
		for (buffers_cntr_0 = 0; buffers_cntr_0 < PyList_GET_SIZE(value); buffers_cntr_0++) {
			PY_CHECK_TYPE(&PAC_BUFFER_RAW_Type, PyList_GET_ITEM(value, buffers_cntr_0), return -1;);
			if (talloc_reference(object->buffers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, buffers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->buffers[buffers_cntr_0] = *(struct PAC_BUFFER_RAW *)pytalloc_get_ptr(PyList_GET_ITEM(value, buffers_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_PAC_DATA_RAW_getsetters[] = {
	{ discard_const_p(char, "num_buffers"), py_PAC_DATA_RAW_get_num_buffers, py_PAC_DATA_RAW_set_num_buffers },
	{ discard_const_p(char, "version"), py_PAC_DATA_RAW_get_version, py_PAC_DATA_RAW_set_version },
	{ discard_const_p(char, "buffers"), py_PAC_DATA_RAW_get_buffers, py_PAC_DATA_RAW_set_buffers },
	{ NULL }
};

static PyObject *py_PAC_DATA_RAW_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_DATA_RAW, type);
}

static PyObject *py_PAC_DATA_RAW_ndr_pack(PyObject *py_obj)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_DATA_RAW);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_DATA_RAW_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA_RAW);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_DATA_RAW);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_DATA_RAW_ndr_print(PyObject *py_obj)
{
	struct PAC_DATA_RAW *object = (struct PAC_DATA_RAW *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_DATA_RAW, "PAC_DATA_RAW", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_DATA_RAW_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_DATA_RAW_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_DATA_RAW_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_DATA_RAW_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_DATA_RAW_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_DATA_RAW",
	.tp_getset = py_PAC_DATA_RAW_getsetters,
	.tp_methods = py_PAC_DATA_RAW_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_DATA_RAW_new,
};


static PyObject *py_PAC_Validate_get_MessageType(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(obj);
	PyObject *py_MessageType;
	py_MessageType = PyInt_FromLong(object->MessageType);
	return py_MessageType;
}

static int py_PAC_Validate_set_MessageType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MessageType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_Validate_get_ChecksumLength(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(obj);
	PyObject *py_ChecksumLength;
	py_ChecksumLength = PyInt_FromLong(object->ChecksumLength);
	return py_ChecksumLength;
}

static int py_PAC_Validate_set_ChecksumLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ChecksumLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_Validate_get_SignatureType(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(obj);
	PyObject *py_SignatureType;
	py_SignatureType = PyInt_FromLong(object->SignatureType);
	return py_SignatureType;
}

static int py_PAC_Validate_set_SignatureType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SignatureType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_Validate_get_SignatureLength(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(obj);
	PyObject *py_SignatureLength;
	py_SignatureLength = PyInt_FromLong(object->SignatureLength);
	return py_SignatureLength;
}

static int py_PAC_Validate_set_SignatureLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SignatureLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_PAC_Validate_get_ChecksumAndSignature(PyObject *obj, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(obj);
	PyObject *py_ChecksumAndSignature;
	py_ChecksumAndSignature = PyString_FromStringAndSize((char *)(object->ChecksumAndSignature).data, (object->ChecksumAndSignature).length);
	return py_ChecksumAndSignature;
}

static int py_PAC_Validate_set_ChecksumAndSignature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	object->ChecksumAndSignature = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_PAC_Validate_getsetters[] = {
	{ discard_const_p(char, "MessageType"), py_PAC_Validate_get_MessageType, py_PAC_Validate_set_MessageType },
	{ discard_const_p(char, "ChecksumLength"), py_PAC_Validate_get_ChecksumLength, py_PAC_Validate_set_ChecksumLength },
	{ discard_const_p(char, "SignatureType"), py_PAC_Validate_get_SignatureType, py_PAC_Validate_set_SignatureType },
	{ discard_const_p(char, "SignatureLength"), py_PAC_Validate_get_SignatureLength, py_PAC_Validate_set_SignatureLength },
	{ discard_const_p(char, "ChecksumAndSignature"), py_PAC_Validate_get_ChecksumAndSignature, py_PAC_Validate_set_ChecksumAndSignature },
	{ NULL }
};

static PyObject *py_PAC_Validate_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct PAC_Validate, type);
}

static PyObject *py_PAC_Validate_ndr_pack(PyObject *py_obj)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_PAC_Validate);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_PAC_Validate_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_Validate);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_PAC_Validate);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_PAC_Validate_ndr_print(PyObject *py_obj)
{
	struct PAC_Validate *object = (struct PAC_Validate *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_PAC_Validate, "PAC_Validate", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_PAC_Validate_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_PAC_Validate_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_PAC_Validate_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_PAC_Validate_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject PAC_Validate_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.PAC_Validate",
	.tp_getset = py_PAC_Validate_getsetters,
	.tp_methods = py_PAC_Validate_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_PAC_Validate_new,
};


static PyObject *py_netsamlogoncache_entry_get_timestamp(PyObject *obj, void *closure)
{
	struct netsamlogoncache_entry *object = (struct netsamlogoncache_entry *)pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyInt_FromLong(object->timestamp);
	return py_timestamp;
}

static int py_netsamlogoncache_entry_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netsamlogoncache_entry *object = (struct netsamlogoncache_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timestamp = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netsamlogoncache_entry_get_info3(PyObject *obj, void *closure)
{
	struct netsamlogoncache_entry *object = (struct netsamlogoncache_entry *)pytalloc_get_ptr(obj);
	PyObject *py_info3;
	py_info3 = pytalloc_reference_ex(netr_SamInfo3_Type, pytalloc_get_mem_ctx(obj), &object->info3);
	return py_info3;
}

static int py_netsamlogoncache_entry_set_info3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netsamlogoncache_entry *object = (struct netsamlogoncache_entry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(netr_SamInfo3_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info3 = *(struct netr_SamInfo3 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netsamlogoncache_entry_getsetters[] = {
	{ discard_const_p(char, "timestamp"), py_netsamlogoncache_entry_get_timestamp, py_netsamlogoncache_entry_set_timestamp },
	{ discard_const_p(char, "info3"), py_netsamlogoncache_entry_get_info3, py_netsamlogoncache_entry_set_info3 },
	{ NULL }
};

static PyObject *py_netsamlogoncache_entry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netsamlogoncache_entry, type);
}

static PyObject *py_netsamlogoncache_entry_ndr_pack(PyObject *py_obj)
{
	struct netsamlogoncache_entry *object = (struct netsamlogoncache_entry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netsamlogoncache_entry);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netsamlogoncache_entry_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netsamlogoncache_entry *object = (struct netsamlogoncache_entry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netsamlogoncache_entry);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netsamlogoncache_entry);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netsamlogoncache_entry_ndr_print(PyObject *py_obj)
{
	struct netsamlogoncache_entry *object = (struct netsamlogoncache_entry *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netsamlogoncache_entry, "netsamlogoncache_entry", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netsamlogoncache_entry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netsamlogoncache_entry_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netsamlogoncache_entry_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netsamlogoncache_entry_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netsamlogoncache_entry_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.netsamlogoncache_entry",
	.tp_getset = py_netsamlogoncache_entry_getsetters,
	.tp_methods = py_netsamlogoncache_entry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netsamlogoncache_entry_new,
};


const struct PyNdrRpcMethodDef py_ndr_krb5pac_methods[] = {
	{ NULL }
};

static PyObject *interface_krb5pac_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_krb5pac);
}

#define PY_DOC_KRB5PAC "Active Directory KRB5 PAC"
static PyTypeObject krb5pac_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "krb5pac.krb5pac",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "krb5pac(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_KRB5PAC,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_krb5pac_new,
};

static PyMethodDef krb5pac_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initkrb5pac(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_security;
	PyObject *dep_samba_dcerpc_lsa;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_samba_dcerpc_samr;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_netlogon;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_samba_dcerpc_samr = PyImport_ImportModule("samba.dcerpc.samr");
	if (dep_samba_dcerpc_samr == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_samba_dcerpc_netlogon == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	samr_RidWithAttributeArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "RidWithAttributeArray");
	if (samr_RidWithAttributeArray_Type == NULL)
		return;

	netr_SamInfo3_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "netr_SamInfo3");
	if (netr_SamInfo3_Type == NULL)
		return;

	lsa_String_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "String");
	if (lsa_String_Type == NULL)
		return;

	PAC_LOGON_NAME_Type.tp_base = Object_Type;

	PAC_SIGNATURE_DATA_Type.tp_base = Object_Type;

	PAC_LOGON_INFO_Type.tp_base = Object_Type;

	PAC_CONSTRAINED_DELEGATION_Type.tp_base = Object_Type;

	PAC_UNKNOWN_12_Type.tp_base = Object_Type;

	PAC_LOGON_INFO_CTR_Type.tp_base = Object_Type;

	PAC_CONSTRAINED_DELEGATION_CTR_Type.tp_base = Object_Type;

	DATA_BLOB_REM_Type.tp_base = Object_Type;

	PAC_BUFFER_Type.tp_base = Object_Type;

	PAC_DATA_Type.tp_base = Object_Type;

	PAC_BUFFER_RAW_Type.tp_base = Object_Type;

	PAC_DATA_RAW_Type.tp_base = Object_Type;

	PAC_Validate_Type.tp_base = Object_Type;

	netsamlogoncache_entry_Type.tp_base = Object_Type;

	krb5pac_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&PAC_LOGON_NAME_Type) < 0)
		return;
	if (PyType_Ready(&PAC_SIGNATURE_DATA_Type) < 0)
		return;
	if (PyType_Ready(&PAC_LOGON_INFO_Type) < 0)
		return;
	if (PyType_Ready(&PAC_CONSTRAINED_DELEGATION_Type) < 0)
		return;
	if (PyType_Ready(&PAC_UNKNOWN_12_Type) < 0)
		return;
	if (PyType_Ready(&PAC_LOGON_INFO_CTR_Type) < 0)
		return;
	if (PyType_Ready(&PAC_CONSTRAINED_DELEGATION_CTR_Type) < 0)
		return;
	if (PyType_Ready(&DATA_BLOB_REM_Type) < 0)
		return;
	if (PyType_Ready(&PAC_BUFFER_Type) < 0)
		return;
	if (PyType_Ready(&PAC_DATA_Type) < 0)
		return;
	if (PyType_Ready(&PAC_BUFFER_RAW_Type) < 0)
		return;
	if (PyType_Ready(&PAC_DATA_RAW_Type) < 0)
		return;
	if (PyType_Ready(&PAC_Validate_Type) < 0)
		return;
	if (PyType_Ready(&netsamlogoncache_entry_Type) < 0)
		return;
	if (PyType_Ready(&krb5pac_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&krb5pac_InterfaceType, py_ndr_krb5pac_methods))
		return;

#ifdef PY_PAC_LOGON_NAME_PATCH
	PY_PAC_LOGON_NAME_PATCH(&PAC_LOGON_NAME_Type);
#endif
#ifdef PY_PAC_SIGNATURE_DATA_PATCH
	PY_PAC_SIGNATURE_DATA_PATCH(&PAC_SIGNATURE_DATA_Type);
#endif
#ifdef PY_PAC_LOGON_INFO_PATCH
	PY_PAC_LOGON_INFO_PATCH(&PAC_LOGON_INFO_Type);
#endif
#ifdef PY_PAC_CONSTRAINED_DELEGATION_PATCH
	PY_PAC_CONSTRAINED_DELEGATION_PATCH(&PAC_CONSTRAINED_DELEGATION_Type);
#endif
#ifdef PY_PAC_UNKNOWN_12_PATCH
	PY_PAC_UNKNOWN_12_PATCH(&PAC_UNKNOWN_12_Type);
#endif
#ifdef PY_PAC_LOGON_INFO_CTR_PATCH
	PY_PAC_LOGON_INFO_CTR_PATCH(&PAC_LOGON_INFO_CTR_Type);
#endif
#ifdef PY_PAC_CONSTRAINED_DELEGATION_CTR_PATCH
	PY_PAC_CONSTRAINED_DELEGATION_CTR_PATCH(&PAC_CONSTRAINED_DELEGATION_CTR_Type);
#endif
#ifdef PY_DATA_BLOB_REM_PATCH
	PY_DATA_BLOB_REM_PATCH(&DATA_BLOB_REM_Type);
#endif
#ifdef PY_PAC_BUFFER_PATCH
	PY_PAC_BUFFER_PATCH(&PAC_BUFFER_Type);
#endif
#ifdef PY_PAC_DATA_PATCH
	PY_PAC_DATA_PATCH(&PAC_DATA_Type);
#endif
#ifdef PY_PAC_BUFFER_RAW_PATCH
	PY_PAC_BUFFER_RAW_PATCH(&PAC_BUFFER_RAW_Type);
#endif
#ifdef PY_PAC_DATA_RAW_PATCH
	PY_PAC_DATA_RAW_PATCH(&PAC_DATA_RAW_Type);
#endif
#ifdef PY_PAC_VALIDATE_PATCH
	PY_PAC_VALIDATE_PATCH(&PAC_Validate_Type);
#endif
#ifdef PY_NETSAMLOGONCACHE_ENTRY_PATCH
	PY_NETSAMLOGONCACHE_ENTRY_PATCH(&netsamlogoncache_entry_Type);
#endif
#ifdef PY_KRB5PAC_PATCH
	PY_KRB5PAC_PATCH(&krb5pac_InterfaceType);
#endif

	m = Py_InitModule3("krb5pac", krb5pac_methods, "krb5pac DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "PAC_TYPE_LOGON_INFO", PyInt_FromLong(PAC_TYPE_LOGON_INFO));
	PyModule_AddObject(m, "PAC_TYPE_UNKNOWN_12", PyInt_FromLong(PAC_TYPE_UNKNOWN_12));
	PyModule_AddObject(m, "PAC_TYPE_SRV_CHECKSUM", PyInt_FromLong(PAC_TYPE_SRV_CHECKSUM));
	PyModule_AddObject(m, "NETLOGON_GENERIC_KRB5_PAC_VALIDATE", PyInt_FromLong(3));
	PyModule_AddObject(m, "PAC_TYPE_LOGON_NAME", PyInt_FromLong(PAC_TYPE_LOGON_NAME));
	PyModule_AddObject(m, "PAC_TYPE_KDC_CHECKSUM", PyInt_FromLong(PAC_TYPE_KDC_CHECKSUM));
	PyModule_AddObject(m, "PAC_TYPE_CONSTRAINED_DELEGATION", PyInt_FromLong(PAC_TYPE_CONSTRAINED_DELEGATION));
	Py_INCREF((PyObject *)(void *)&PAC_LOGON_NAME_Type);
	PyModule_AddObject(m, "PAC_LOGON_NAME", (PyObject *)(void *)&PAC_LOGON_NAME_Type);
	Py_INCREF((PyObject *)(void *)&PAC_SIGNATURE_DATA_Type);
	PyModule_AddObject(m, "PAC_SIGNATURE_DATA", (PyObject *)(void *)&PAC_SIGNATURE_DATA_Type);
	Py_INCREF((PyObject *)(void *)&PAC_LOGON_INFO_Type);
	PyModule_AddObject(m, "PAC_LOGON_INFO", (PyObject *)(void *)&PAC_LOGON_INFO_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_Type);
	PyModule_AddObject(m, "PAC_CONSTRAINED_DELEGATION", (PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_Type);
	Py_INCREF((PyObject *)(void *)&PAC_UNKNOWN_12_Type);
	PyModule_AddObject(m, "PAC_UNKNOWN_12", (PyObject *)(void *)&PAC_UNKNOWN_12_Type);
	Py_INCREF((PyObject *)(void *)&PAC_LOGON_INFO_CTR_Type);
	PyModule_AddObject(m, "PAC_LOGON_INFO_CTR", (PyObject *)(void *)&PAC_LOGON_INFO_CTR_Type);
	Py_INCREF((PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_CTR_Type);
	PyModule_AddObject(m, "PAC_CONSTRAINED_DELEGATION_CTR", (PyObject *)(void *)&PAC_CONSTRAINED_DELEGATION_CTR_Type);
	Py_INCREF((PyObject *)(void *)&DATA_BLOB_REM_Type);
	PyModule_AddObject(m, "DATA_BLOB_REM", (PyObject *)(void *)&DATA_BLOB_REM_Type);
	Py_INCREF((PyObject *)(void *)&PAC_BUFFER_Type);
	PyModule_AddObject(m, "PAC_BUFFER", (PyObject *)(void *)&PAC_BUFFER_Type);
	Py_INCREF((PyObject *)(void *)&PAC_DATA_Type);
	PyModule_AddObject(m, "PAC_DATA", (PyObject *)(void *)&PAC_DATA_Type);
	Py_INCREF((PyObject *)(void *)&PAC_BUFFER_RAW_Type);
	PyModule_AddObject(m, "PAC_BUFFER_RAW", (PyObject *)(void *)&PAC_BUFFER_RAW_Type);
	Py_INCREF((PyObject *)(void *)&PAC_DATA_RAW_Type);
	PyModule_AddObject(m, "PAC_DATA_RAW", (PyObject *)(void *)&PAC_DATA_RAW_Type);
	Py_INCREF((PyObject *)(void *)&PAC_Validate_Type);
	PyModule_AddObject(m, "PAC_Validate", (PyObject *)(void *)&PAC_Validate_Type);
	Py_INCREF((PyObject *)(void *)&netsamlogoncache_entry_Type);
	PyModule_AddObject(m, "netsamlogoncache_entry", (PyObject *)(void *)&netsamlogoncache_entry_Type);
	Py_INCREF((PyObject *)(void *)&krb5pac_InterfaceType);
	PyModule_AddObject(m, "krb5pac", (PyObject *)(void *)&krb5pac_InterfaceType);
#ifdef PY_MOD_KRB5PAC_PATCH
	PY_MOD_KRB5PAC_PATCH(m);
#endif

}
