#!/usr/bin/perl -w

#  This code was developped by IDEALX (http://IDEALX.org/) and
#  contributors (their names can be found in the CONTRIBUTORS file).
#
#                 Copyright (C) 2001-2002 IDEALX
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.

# Purpose of smbldap-userdisplay : user (posix,shadow,samba) display

use strict;
use FindBin;
use FindBin qw($RealBin);
use lib "$RealBin/";
use smbldap_tools;

use Getopt::Std;
my %Options;

my $ok = getopts('?', \%Options);

if ( (!$ok) || (@ARGV < 1) || ($Options{'?'}) ) {
  print "Usage: $0 [-?] username\n";
  print "  -?	show this help message\n";
	exit (1);
}

# Read only first @ARGV
my $user = $ARGV[0];

my $lines = read_user($user);
if (!defined($lines)) {
    print "$0: user $user doesn't exist\n";
    exit (1);
}

print "$lines\n";

exit(0);

############################################################

=head1 NAME

       smbldap-usershow.pl - Show a user account informations

=head1 SYNOPSIS

       smbldap-usershow.pl login

=head1 DESCRIPTION

       The smbldap-usershow.pl command displays the informations
       associated with the login. The named user must exist.

=cut

#'
