/* parser auto-generated by pidl */

#include "includes.h"
#include "autoconf/librpc/gen_ndr/ndr_smbXsrv.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_server_id.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_auth.h"
static enum ndr_err_code ndr_push_smbXsrv_version_values(struct ndr_push *ndr, int ndr_flags, enum smbXsrv_version_values r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_values(struct ndr_pull *ndr, int ndr_flags, enum smbXsrv_version_values *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_values(struct ndr_print *ndr, const char *name, enum smbXsrv_version_values r)
{
	const char *val = NULL;

	switch (r) {
		case SMBXSRV_VERSION_0: val = "SMBXSRV_VERSION_0"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_smbXsrv_version_node0(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_version_node0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->min_version));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->max_version));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->current_version));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_node0(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_version_node0 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->min_version));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->max_version));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->current_version));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_node0(struct ndr_print *ndr, const char *name, const struct smbXsrv_version_node0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_version_node0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_smbXsrv_version_values(ndr, "min_version", r->min_version);
	ndr_print_smbXsrv_version_values(ndr, "max_version", r->max_version);
	ndr_print_smbXsrv_version_values(ndr, "current_version", r->current_version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_version_global0(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_version_global0 *r)
{
	uint32_t cntr_nodes_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_nodes));
		for (cntr_nodes_0 = 0; cntr_nodes_0 < r->num_nodes; cntr_nodes_0++) {
			NDR_CHECK(ndr_push_smbXsrv_version_node0(ndr, NDR_SCALARS, &r->nodes[cntr_nodes_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_global0(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_version_global0 *r)
{
	uint32_t _ptr_db_rec;
	uint32_t size_nodes_0 = 0;
	uint32_t cntr_nodes_0;
	TALLOC_CTX *_mem_save_nodes_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_nodes));
		if (r->num_nodes < 1 || r->num_nodes > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		size_nodes_0 = r->num_nodes;
		NDR_PULL_ALLOC_N(ndr, r->nodes, size_nodes_0);
		_mem_save_nodes_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->nodes, 0);
		for (cntr_nodes_0 = 0; cntr_nodes_0 < size_nodes_0; cntr_nodes_0++) {
			NDR_CHECK(ndr_pull_smbXsrv_version_node0(ndr, NDR_SCALARS, &r->nodes[cntr_nodes_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nodes_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_version_global0 *r)
{
	uint32_t cntr_nodes_0;
	ndr_print_struct(ndr, name, "smbXsrv_version_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "num_nodes", r->num_nodes);
	ndr->print(ndr, "%s: ARRAY(%d)", "nodes", (int)r->num_nodes);
	ndr->depth++;
	for (cntr_nodes_0=0;cntr_nodes_0<r->num_nodes;cntr_nodes_0++) {
		ndr_print_smbXsrv_version_node0(ndr, "nodes", &r->nodes[cntr_nodes_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_version_globalU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_version_globalU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_version_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_globalU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_version_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_version_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_version_globalU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_version_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_version_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_version_globalB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_version_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_version_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_version_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_version_globalB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_version_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_version_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_version_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_version_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_version_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_version_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_channel_global0(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_channel_global0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->local_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->local_address, ndr_charset_length(r->local_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_address, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_address, ndr_charset_length(r->remote_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_name, ndr_charset_length(r->remote_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->signing_key));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_session_info_seqnum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_channel_global0(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_channel_global0 *r)
{
	uint32_t size_local_address_0 = 0;
	uint32_t length_local_address_0 = 0;
	uint32_t size_remote_address_0 = 0;
	uint32_t length_remote_address_0 = 0;
	uint32_t size_remote_name_0 = 0;
	uint32_t length_remote_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->local_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->local_address));
		size_local_address_0 = ndr_get_array_size(ndr, &r->local_address);
		length_local_address_0 = ndr_get_array_length(ndr, &r->local_address);
		if (length_local_address_0 > size_local_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_local_address_0, length_local_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_local_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->local_address, length_local_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_address));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_address));
		size_remote_address_0 = ndr_get_array_size(ndr, &r->remote_address);
		length_remote_address_0 = ndr_get_array_length(ndr, &r->remote_address);
		if (length_remote_address_0 > size_remote_address_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_remote_address_0, length_remote_address_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_address_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_address, length_remote_address_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_name));
		size_remote_name_0 = ndr_get_array_size(ndr, &r->remote_name);
		length_remote_name_0 = ndr_get_array_length(ndr, &r->remote_name);
		if (length_remote_name_0 > size_remote_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_remote_name_0, length_remote_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_name, length_remote_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->signing_key));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_session_info_seqnum));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_channel_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_channel_global0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_channel_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_string(ndr, "local_address", r->local_address);
	ndr_print_string(ndr, "remote_address", r->remote_address);
	ndr_print_string(ndr, "remote_name", r->remote_name);
	ndr_print_uint32(ndr, "auth_session_info_seqnum", r->auth_session_info_seqnum);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_global0(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_session_global0 *r)
{
	uint32_t cntr_channels_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_global_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->session_wire_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->creation_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->expiration_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_session_info_seqnum));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->auth_session_info));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->connection_dialect));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->signing_required));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->encryption_required));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->signing_key));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->encryption_key));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->decryption_key));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->application_key));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_channels));
		for (cntr_channels_0 = 0; cntr_channels_0 < r->num_channels; cntr_channels_0++) {
			NDR_CHECK(ndr_push_smbXsrv_channel_global0(ndr, NDR_SCALARS, &r->channels[cntr_channels_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
		if (r->auth_session_info) {
			NDR_CHECK(ndr_push_auth_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->auth_session_info));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_global0(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_session_global0 *r)
{
	uint32_t _ptr_db_rec;
	uint32_t _ptr_auth_session_info;
	TALLOC_CTX *_mem_save_auth_session_info_0;
	uint32_t size_channels_0 = 0;
	uint32_t cntr_channels_0;
	TALLOC_CTX *_mem_save_channels_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_global_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->session_wire_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->creation_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->expiration_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_session_info_seqnum));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_auth_session_info));
		if (_ptr_auth_session_info) {
			NDR_PULL_ALLOC(ndr, r->auth_session_info);
		} else {
			r->auth_session_info = NULL;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->connection_dialect));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->signing_required));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->encryption_required));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->signing_key));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->encryption_key));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->decryption_key));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->application_key));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_channels));
		if (r->num_channels < 1 || r->num_channels > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		size_channels_0 = r->num_channels;
		NDR_PULL_ALLOC_N(ndr, r->channels, size_channels_0);
		_mem_save_channels_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->channels, 0);
		for (cntr_channels_0 = 0; cntr_channels_0 < size_channels_0; cntr_channels_0++) {
			NDR_CHECK(ndr_pull_smbXsrv_channel_global0(ndr, NDR_SCALARS, &r->channels[cntr_channels_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_channels_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
		if (r->auth_session_info) {
			_mem_save_auth_session_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->auth_session_info, 0);
			NDR_CHECK(ndr_pull_auth_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->auth_session_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_auth_session_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_global0 *r)
{
	uint32_t cntr_channels_0;
	ndr_print_struct(ndr, name, "smbXsrv_session_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "session_global_id", r->session_global_id);
	ndr_print_hyper(ndr, "session_wire_id", r->session_wire_id);
	ndr_print_NTTIME(ndr, "creation_time", r->creation_time);
	ndr_print_NTTIME(ndr, "expiration_time", r->expiration_time);
	ndr_print_uint32(ndr, "auth_session_info_seqnum", r->auth_session_info_seqnum);
	ndr_print_ptr(ndr, "auth_session_info", r->auth_session_info);
	ndr->depth++;
	if (r->auth_session_info) {
		ndr_print_auth_session_info(ndr, "auth_session_info", r->auth_session_info);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "connection_dialect", r->connection_dialect);
	ndr_print_uint8(ndr, "signing_required", r->signing_required);
	ndr_print_uint8(ndr, "encryption_required", r->encryption_required);
	ndr_print_uint32(ndr, "num_channels", r->num_channels);
	ndr->print(ndr, "%s: ARRAY(%d)", "channels", (int)r->num_channels);
	ndr->depth++;
	for (cntr_channels_0=0;cntr_channels_0<r->num_channels;cntr_channels_0++) {
		ndr_print_smbXsrv_channel_global0(ndr, "channels", &r->channels[cntr_channels_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_globalU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_session_globalU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_globalU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_session_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_session_globalU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_session_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_session_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_session_globalB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_session_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_session_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_session_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_session_globalB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_session_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_session_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_session_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_session_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_session *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'connection' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->local_id));
		if (r->global == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->nonce_high));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->nonce_low));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'gensec' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'tcon_table' */
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		/* [ignore] 'connection' */
		NDR_CHECK(ndr_push_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		/* [ignore] 'gensec' */
		/* [ignore] 'compat' */
		/* [ignore] 'tcon_table' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_session *r)
{
	uint32_t _ptr_table;
	uint32_t _ptr_db_rec;
	uint32_t _ptr_connection;
	uint32_t _ptr_global;
	TALLOC_CTX *_mem_save_global_0;
	uint32_t _ptr_gensec;
	uint32_t _ptr_compat;
	uint32_t _ptr_tcon_table;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_table));
		_ptr_table = 0;
		if (_ptr_table) {
		} else {
			r->table = NULL;
		}
		/* [ignore] 'table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_connection));
		_ptr_connection = 0;
		if (_ptr_connection) {
		} else {
			r->connection = NULL;
		}
		/* [ignore] 'connection' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->local_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_global));
		if (_ptr_global) {
			NDR_PULL_ALLOC(ndr, r->global);
		} else {
			r->global = NULL;
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->nonce_high));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->nonce_low));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_gensec));
		_ptr_gensec = 0;
		if (_ptr_gensec) {
		} else {
			r->gensec = NULL;
		}
		/* [ignore] 'gensec' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_compat));
		_ptr_compat = 0;
		if (_ptr_compat) {
		} else {
			r->compat = NULL;
		}
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_tcon_table));
		_ptr_tcon_table = 0;
		if (_ptr_tcon_table) {
		} else {
			r->tcon_table = NULL;
		}
		/* [ignore] 'tcon_table' */
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		/* [ignore] 'connection' */
		_mem_save_global_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->global, 0);
		NDR_CHECK(ndr_pull_smbXsrv_session_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_global_0, 0);
		/* [ignore] 'gensec' */
		/* [ignore] 'compat' */
		/* [ignore] 'tcon_table' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session(struct ndr_print *ndr, const char *name, const struct smbXsrv_session *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "table", r->table);
	/* [ignore] 'table' */
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_ptr(ndr, "connection", r->connection);
	/* [ignore] 'connection' */
	ndr_print_uint32(ndr, "local_id", r->local_id);
	ndr_print_ptr(ndr, "global", r->global);
	ndr->depth++;
	ndr_print_smbXsrv_session_global0(ndr, "global", r->global);
	ndr->depth--;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_NTTIME(ndr, "idle_time", r->idle_time);
	ndr_print_hyper(ndr, "nonce_high", r->nonce_high);
	ndr_print_hyper(ndr, "nonce_low", r->nonce_low);
	ndr_print_ptr(ndr, "gensec", r->gensec);
	/* [ignore] 'gensec' */
	ndr_print_ptr(ndr, "compat", r->compat);
	/* [ignore] 'compat' */
	ndr_print_ptr(ndr, "tcon_table", r->tcon_table);
	/* [ignore] 'tcon_table' */
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_sessionU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_sessionU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_session(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_sessionU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_sessionU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_session(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_sessionU(struct ndr_print *ndr, const char *name, const union smbXsrv_sessionU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_sessionU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_session(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_sessionB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_sessionB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_sessionU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_sessionU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_sessionB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_sessionB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_sessionU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_sessionU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_sessionB(struct ndr_print *ndr, const char *name, const struct smbXsrv_sessionB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_sessionB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_sessionU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_close0(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_session_close0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->old_session_global_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->old_session_wire_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->old_creation_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->new_session_wire_id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_close0(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_session_close0 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->old_session_global_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->old_session_wire_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->old_creation_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->new_session_wire_id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_close0(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_close0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_close0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "old_session_global_id", r->old_session_global_id);
	ndr_print_hyper(ndr, "old_session_wire_id", r->old_session_wire_id);
	ndr_print_NTTIME(ndr, "old_creation_time", r->old_creation_time);
	ndr_print_hyper(ndr, "new_session_wire_id", r->new_session_wire_id);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_closeU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_session_closeU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_session_close0(ndr, NDR_SCALARS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_closeU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_session_closeU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_session_close0(ndr, NDR_SCALARS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_closeU(struct ndr_print *ndr, const char *name, const union smbXsrv_session_closeU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_session_closeU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_session_close0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_session_closeB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_session_closeB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_session_closeU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_session_closeU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_session_closeB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_session_closeB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_session_closeU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_session_closeU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_closeB(struct ndr_print *ndr, const char *name, const struct smbXsrv_session_closeB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_closeB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_session_closeU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon_global0(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_tcon_global0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tcon_global_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tcon_wire_id));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->creation_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->share_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->share_name, ndr_charset_length(r->share_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->encryption_required));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_global_id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon_global0(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_tcon_global0 *r)
{
	uint32_t _ptr_db_rec;
	uint32_t size_share_name_0 = 0;
	uint32_t length_share_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tcon_global_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tcon_wire_id));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->creation_time));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->share_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->share_name));
		size_share_name_0 = ndr_get_array_size(ndr, &r->share_name);
		length_share_name_0 = ndr_get_array_length(ndr, &r->share_name);
		if (length_share_name_0 > size_share_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_share_name_0, length_share_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_share_name_0, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->share_name, length_share_name_0, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->encryption_required));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_global_id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_tcon_global0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "tcon_global_id", r->tcon_global_id);
	ndr_print_uint32(ndr, "tcon_wire_id", r->tcon_wire_id);
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_NTTIME(ndr, "creation_time", r->creation_time);
	ndr_print_string(ndr, "share_name", r->share_name);
	ndr_print_uint8(ndr, "encryption_required", r->encryption_required);
	ndr_print_uint32(ndr, "session_global_id", r->session_global_id);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon_globalU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_tcon_globalU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon_globalU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_tcon_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_tcon_globalU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_tcon_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_tcon_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_tcon_globalB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_tcon_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_tcon_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_tcon_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_tcon_globalB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_tcon_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_tcon_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_tcon_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_tcon_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_tcon_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_tcon *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->local_id));
		if (r->global == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_tcon *r)
{
	uint32_t _ptr_table;
	uint32_t _ptr_db_rec;
	uint32_t _ptr_global;
	TALLOC_CTX *_mem_save_global_0;
	uint32_t _ptr_compat;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_table));
		_ptr_table = 0;
		if (_ptr_table) {
		} else {
			r->table = NULL;
		}
		/* [ignore] 'table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->local_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_global));
		if (_ptr_global) {
			NDR_PULL_ALLOC(ndr, r->global);
		} else {
			r->global = NULL;
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_compat));
		_ptr_compat = 0;
		if (_ptr_compat) {
		} else {
			r->compat = NULL;
		}
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		_mem_save_global_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->global, 0);
		NDR_CHECK(ndr_pull_smbXsrv_tcon_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_global_0, 0);
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon(struct ndr_print *ndr, const char *name, const struct smbXsrv_tcon *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "table", r->table);
	/* [ignore] 'table' */
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "local_id", r->local_id);
	ndr_print_ptr(ndr, "global", r->global);
	ndr->depth++;
	ndr_print_smbXsrv_tcon_global0(ndr, "global", r->global);
	ndr->depth--;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_NTTIME(ndr, "idle_time", r->idle_time);
	ndr_print_ptr(ndr, "compat", r->compat);
	/* [ignore] 'compat' */
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tconU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_tconU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_tcon(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tconU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_tconU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_tcon(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tconU(struct ndr_print *ndr, const char *name, const union smbXsrv_tconU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_tconU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_tcon(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_tconB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_tconB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_tconU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_tconU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_tconB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_tconB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_tconU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_tconU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tconB(struct ndr_print *ndr, const char *name, const struct smbXsrv_tconB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tconB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_tconU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open_global0(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_open_global0 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->open_global_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->open_persistent_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->open_volatile_id));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->open_owner));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->open_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->create_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->app_instance_id));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->disconnect_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->durable_timeout_msec));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->durable));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->backend_cookie));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open_global0(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_open_global0 *r)
{
	uint32_t _ptr_db_rec;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->open_global_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->open_persistent_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->open_volatile_id));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->open_owner));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->open_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->create_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->client_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->app_instance_id));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->disconnect_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->durable_timeout_msec));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->durable));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->backend_cookie));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'db_rec' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_global0(struct ndr_print *ndr, const char *name, const struct smbXsrv_open_global0 *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_global0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_server_id(ndr, "server_id", &r->server_id);
	ndr_print_uint32(ndr, "open_global_id", r->open_global_id);
	ndr_print_hyper(ndr, "open_persistent_id", r->open_persistent_id);
	ndr_print_hyper(ndr, "open_volatile_id", r->open_volatile_id);
	ndr_print_dom_sid(ndr, "open_owner", &r->open_owner);
	ndr_print_NTTIME(ndr, "open_time", r->open_time);
	ndr_print_GUID(ndr, "create_guid", &r->create_guid);
	ndr_print_GUID(ndr, "client_guid", &r->client_guid);
	ndr_print_GUID(ndr, "app_instance_id", &r->app_instance_id);
	ndr_print_NTTIME(ndr, "disconnect_time", r->disconnect_time);
	ndr_print_uint32(ndr, "durable_timeout_msec", r->durable_timeout_msec);
	ndr_print_uint8(ndr, "durable", r->durable);
	ndr_print_DATA_BLOB(ndr, "backend_cookie", r->backend_cookie);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open_globalU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_open_globalU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_open_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open_globalU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_open_globalU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_open_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_globalU(struct ndr_print *ndr, const char *name, const union smbXsrv_open_globalU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_open_globalU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_open_global0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_open_globalB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_open_globalB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seqnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_open_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_open_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_open_globalB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_open_globalB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seqnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_open_globalU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_open_globalU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_globalB(struct ndr_print *ndr, const char *name, const struct smbXsrv_open_globalB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_globalB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "seqnum", r->seqnum);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_open_globalU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_open *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'table' */
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->local_id));
		if (r->global == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->idle_time));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_push_smbXsrv_open_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_open *r)
{
	uint32_t _ptr_table;
	uint32_t _ptr_db_rec;
	uint32_t _ptr_global;
	TALLOC_CTX *_mem_save_global_0;
	uint32_t _ptr_compat;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_table));
		_ptr_table = 0;
		if (_ptr_table) {
		} else {
			r->table = NULL;
		}
		/* [ignore] 'table' */
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_db_rec));
		_ptr_db_rec = 0;
		if (_ptr_db_rec) {
		} else {
			r->db_rec = NULL;
		}
		/* [ignore] 'db_rec' */
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->local_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_global));
		if (_ptr_global) {
			NDR_PULL_ALLOC(ndr, r->global);
		} else {
			r->global = NULL;
		}
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->idle_time));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_compat));
		_ptr_compat = 0;
		if (_ptr_compat) {
		} else {
			r->compat = NULL;
		}
		/* [ignore] 'compat' */
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		/* [ignore] 'table' */
		/* [ignore] 'db_rec' */
		_mem_save_global_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->global, 0);
		NDR_CHECK(ndr_pull_smbXsrv_open_global0(ndr, NDR_SCALARS|NDR_BUFFERS, r->global));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_global_0, 0);
		/* [ignore] 'compat' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open(struct ndr_print *ndr, const char *name, const struct smbXsrv_open *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "table", r->table);
	/* [ignore] 'table' */
	ndr_print_ptr(ndr, "db_rec", r->db_rec);
	/* [ignore] 'db_rec' */
	ndr_print_uint32(ndr, "local_id", r->local_id);
	ndr_print_ptr(ndr, "global", r->global);
	ndr->depth++;
	ndr_print_smbXsrv_open_global0(ndr, "global", r->global);
	ndr->depth--;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_NTTIME(ndr, "idle_time", r->idle_time);
	ndr_print_ptr(ndr, "compat", r->compat);
	/* [ignore] 'compat' */
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_openU(struct ndr_push *ndr, int ndr_flags, const union smbXsrv_openU *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->dummy));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_smbXsrv_open(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				if (r->dummy) {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->dummy));
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_openU(struct ndr_pull *ndr, int ndr_flags, union smbXsrv_openU *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_dummy_0;
	uint32_t _ptr_dummy;
	level = ndr_pull_get_switch_value(ndr, r);
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dummy));
				if (_ptr_dummy) {
					NDR_PULL_ALLOC(ndr, r->dummy);
				} else {
					r->dummy = NULL;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_smbXsrv_open(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				if (r->dummy) {
					_mem_save_dummy_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->dummy, 0);
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->dummy));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dummy_0, 0);
				}
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_openU(struct ndr_print *ndr, const char *name, const union smbXsrv_openU *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbXsrv_openU");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_smbXsrv_open(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_ptr(ndr, "dummy", r->dummy);
			ndr->depth++;
			if (r->dummy) {
				ndr_print_hyper(ndr, "dummy", *r->dummy);
			}
			ndr->depth--;
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_smbXsrv_openB(struct ndr_push *ndr, int ndr_flags, const struct smbXsrv_openB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_smbXsrv_version_values(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_push_smbXsrv_openU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_smbXsrv_openU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_smbXsrv_openB(struct ndr_pull *ndr, int ndr_flags, struct smbXsrv_openB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_smbXsrv_version_values(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->version));
		NDR_CHECK(ndr_pull_smbXsrv_openU(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_smbXsrv_openU(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_openB(struct ndr_print *ndr, const char *name, const struct smbXsrv_openB *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_openB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_smbXsrv_version_values(ndr, "version", r->version);
	ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
	ndr_print_set_switch_value(ndr, &r->info, r->version);
	ndr_print_smbXsrv_openU(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_version_global_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_version_global_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_version_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_version_global_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_version_global_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_version_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_version_global_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_version_global_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_version_global_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_version_global_decode");
		ndr->depth++;
		ndr_print_smbXsrv_version_globalB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_version_global_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_global_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_session_global_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_session_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_global_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_session_global_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_session_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_global_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_session_global_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_global_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_session_global_decode");
		ndr->depth++;
		ndr_print_smbXsrv_session_globalB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_session_global_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_session_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_sessionB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_session_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_sessionB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_session_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_session_decode");
		ndr->depth++;
		ndr_print_smbXsrv_sessionB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_session_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_session_close_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_session_close_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_session_closeB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_session_close_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_session_close_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_session_closeB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_session_close_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_session_close_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_session_close_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_session_close_decode");
		ndr->depth++;
		ndr_print_smbXsrv_session_closeB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_session_close_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon_global_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_tcon_global_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_tcon_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon_global_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_tcon_global_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_tcon_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_global_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_tcon_global_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon_global_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_tcon_global_decode");
		ndr->depth++;
		ndr_print_smbXsrv_tcon_globalB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_tcon_global_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_tcon_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_tcon_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_tconB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_tcon_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_tcon_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_tconB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_tcon_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_tcon_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_tcon_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_tcon_decode");
		ndr->depth++;
		ndr_print_smbXsrv_tconB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_tcon_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open_global_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_open_global_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_open_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open_global_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_open_global_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_open_globalB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_global_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_open_global_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_global_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_open_global_decode");
		ndr->depth++;
		ndr_print_smbXsrv_open_globalB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_open_global_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_smbXsrv_open_decode(struct ndr_push *ndr, int flags, const struct smbXsrv_open_decode *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbXsrv_openB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_smbXsrv_open_decode(struct ndr_pull *ndr, int flags, struct smbXsrv_open_decode *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_smbXsrv_openB(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_smbXsrv_open_decode(struct ndr_print *ndr, const char *name, int flags, const struct smbXsrv_open_decode *r)
{
	ndr_print_struct(ndr, name, "smbXsrv_open_decode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbXsrv_open_decode");
		ndr->depth++;
		ndr_print_smbXsrv_openB(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbXsrv_open_decode");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call smbXsrv_calls[] = {
	{
		"smbXsrv_version_global_decode",
		sizeof(struct smbXsrv_version_global_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_version_global_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_version_global_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_version_global_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbXsrv_session_global_decode",
		sizeof(struct smbXsrv_session_global_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_session_global_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_session_global_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_session_global_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbXsrv_session_decode",
		sizeof(struct smbXsrv_session_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_session_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_session_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_session_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbXsrv_session_close_decode",
		sizeof(struct smbXsrv_session_close_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_session_close_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_session_close_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_session_close_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbXsrv_tcon_global_decode",
		sizeof(struct smbXsrv_tcon_global_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_tcon_global_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_tcon_global_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_tcon_global_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbXsrv_tcon_decode",
		sizeof(struct smbXsrv_tcon_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_tcon_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_tcon_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_tcon_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbXsrv_open_global_decode",
		sizeof(struct smbXsrv_open_global_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_open_global_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_open_global_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_open_global_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"smbXsrv_open_decode",
		sizeof(struct smbXsrv_open_decode),
		(ndr_push_flags_fn_t) ndr_push_smbXsrv_open_decode,
		(ndr_pull_flags_fn_t) ndr_pull_smbXsrv_open_decode,
		(ndr_print_function_t) ndr_print_smbXsrv_open_decode,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const smbXsrv_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\smbXsrv]", 
};

static const struct ndr_interface_string_array smbXsrv_endpoints = {
	.count	= 1,
	.names	= smbXsrv_endpoint_strings
};

static const char * const smbXsrv_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array smbXsrv_authservices = {
	.count	= 1,
	.names	= smbXsrv_authservice_strings
};


const struct ndr_interface_table ndr_table_smbXsrv = {
	.name		= "smbXsrv",
	.syntax_id	= {
		{0x07408340,0xae31,0x11e1,{0x97,0xdc},{0x53,0x9f,0x7f,0xdd,0xc0,0x6f}},
		NDR_SMBXSRV_VERSION
	},
	.helpstring	= NDR_SMBXSRV_HELPSTRING,
	.num_calls	= 8,
	.calls		= smbXsrv_calls,
	.endpoints	= &smbXsrv_endpoints,
	.authservices	= &smbXsrv_authservices
};

