/*
 *© Copyright 2009 Opera Software ASA. All rights reserved.
 *
 *This file contains Original Code and/or Contributions to the Original 
 *Code as defined in the Opera Web Applications License (the “License”). 
 *You may not use this file except in compliance with the License. Please 
 *obtain a copy of the License at http://www.opera.com/license/owal/
 *and read it before using this file. 
 *
 *The Original Code and all Contributions to the Original Code distributed 
 *under the License are distributed on an “AS IS” basis, WITHOUT WARRANTY 
 *OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 *SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 *MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 *Please see the License for the specific language governing rights and 
 *limitations under the License.
 */


/**
  * A Dialog library
  * 
  * 
  * Dialog.showMessage(message, options)
  * Dialog.showMessageYesNo(message, options)
  * Dialog.showMessageOkCancel(message, options)
  *
  * message: innerHTML or HTMLElement
  * options: {
  **  title: Title of the Dialog. "Alert", "Error", etc.
  **  callback: The callback function, incase no buttons are provided
  *   
  *-  yes: callback
  *-  no: callback
  *
  *-  ok: callback
  *-  cancel: callback
  * }
  */
var Dialog = {
    defaultOptions:
    {
        buttons: [{ 
            label: 'OK', 
            callback: function(response){ 
                
            }
        }]
    },
    applyDefaults: function(destination, source)
    {
        if ( source == null || typeof(source) != 'object')
        {
            return destination || source;
        }
        destination = destination || ((source instanceof Array) ? [] : {});
        for ( var key in source )
        {
            destination[key] = this.applyDefaults(destination[key], source[key]);
        }
        return destination;
    },
    greyOut: function(turnOff)
    {
        var greyOverlay = document.getElementById("Dialog_greyOverlay");
        if(!greyOverlay)
        {
            greyOverlay = document.createElement('div');
            greyOverlay.id = "Dialog_greyOverlay";
            greyOverlay.style = "position: absolute; top: 0; bottom: 0; left: 0; right: 0;  opacity: 1; z-index: 999;";
            document.body.appendChild(greyOverlay);
        }
        greyOverlay.style.display = (turnOff===false)?"none":"block";
    },
    XHR: function(eventData)
    {
        options = {}
        if(eventData.error === true){
          options.title = eventData.title;
          options.buttons = [];
          options.buttons[0] = {};
          options.buttons[0].label = "Cancel".toLocale();
          options.buttons[0].callback = eventData.cancel;
          options.buttons[1] = {};
          options.buttons[1].label = "Retry".toLocale();
          options.buttons[1].callback = eventData.retry;
        } else {
          options.title = eventData.title;
          options.buttons = [];
          options.buttons[0] = {};
          options.buttons[0].label = "Cancel".toLocale();
          options.buttons[0].callback = eventData.cancel;
        }
        message = eventData.message || "<p class='XHR_busy' style='text-align: center; margin: 4px 0;'><img src='data:image/gif;base64,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' style='width: 80%;'></p>";
        this.showMessage(message, options);
    },
    closeMessage: function(){
        Dialog.greyOut(false);
        var panel = document.getElementById("Dialog_panel");
        if(panel) panel.parentNode.removeChild(panel);
    }
    ,
    promptMessage: function(message, options)
    {
        options = options || {};
        options.input = options.input || {};
        options.input.type = options.input.type || 'text';
        
        this.showMessage(message, options);
    },
    getInput: function(options)
    {
        var field;
        var callback;

        switch ( options.type )
        {
            case 'text':
                field = document.createElement('input');
                field.type = 'text';
                field.value = options['default'] || '';
                callback = function()
                {
                    return field.value;
                }
                break;
            case 'textarea':
                field = document.createElement('textarea');
                field.value = options['default'] || '';
                callback = function()
                {
                    return field.value;
                }
                break;
        }

        if ( options.size && options.size.width ) field.style.width = options.size.width+'px';
        if ( options.size && options.size.height ) field.style.height = options.size.height+'px';

        if ( options.position )
        {
            field.style.position = 'absolute';
            field.style.top = options.position.y+'px';
            field.style.left = options.position.x+'px';
        }
        
        field.className = options.className || '';
        this.applyDefaults(field.style, options.style);

        var container = document.createElement('div');
        container.style.width = '100%';
        container.style.paddingLeft = '5px';
        container.style.paddingRight = '5px';
        container.style.border = '';
        container.appendChild(field);

        return {component: container, valueFunction: callback, field: field};
    },
    showMessage: function(message, options)
    {
        var self = this;
        options = this.applyDefaults(options || {}, this.defaultOptions);
        Dialog.closeMessage();
        Dialog.greyOut();
        var panel = document.createElement('div');
        panel.id = "Dialog_panel";
        if(screen.height <= 250)
        {
             panel.style = "position: absolute; z-index: 1000; padding: 0 5px; -o-background-size: 100%; display: block; width: 90%; margin-top: 2px;"
        }
        else
        { 
            panel.style = "position: absolute; z-index: 1000; padding: 0 5px; -o-background-size: 100%; display: block; width: 90%; margin-top: 10px;"
        }
        if(document.styleSheets)
        {
          document.styleSheets[0].insertRule("#Dialog_panel:after{ display: block; content: ' '; width: 100%; padding: 0 5px; height: 6px; margin: 0 -5px -3px -5px;}", 0);
        }
        // Title
        options.title = (!options.title)?"Alert".toLocale(): options.title;
        var title_pane = document.createElement('h3');
        title_pane.id = "Dialog_title";
        title_pane.style = " display: block; width: 100%; padding: 2px 5px; margin: 0 -5px; margin-top: -5px;";
        title_pane.innerHTML = options.title;
        panel.appendChild(title_pane);

        // Message
        var message_pane = document.createElement('div');
        if (message instanceof Element)
        {
            message_pane.appendChild(message);
        }
        else
        {
            message_pane.innerHTML = message;
        }
        message_pane.id = "Dialog_message_pane";
                  
        if(screen.height <= 250)
        { 
            message_pane.style = /*max-height: 130px;*/" position :absolute;top:15px;padding-top:5px;";
        }
        else
        {
            message_pane.style = /*max-height: 130px;*/" position :absolute;top:25px;padding-top:5px;";
        }
        panel.appendChild(message_pane);

        // Input
        var input;
        if ( options.input )
        {
            input = this.getInput(options.input);
            panel.appendChild(input.component);
        }

        // Buttons
        buttons_pane = document.createElement('div');
        buttons_pane.id = "Dialog_buttons_pane";
        buttons_pane.style = "margin-top: 5px; min-height: 40px;"
        
        if(options.buttons.length == 2)
        {
          buttons_pane.className = "double";
          if(document.styleSheets)
          {
            document.styleSheets[0].insertRule("#Dialog_buttons_pane.double button:first-child{ float:left;}", 0);
            document.styleSheets[0].insertRule("#Dialog_buttons_pane.double button:last-child{ float:right;}", 0);
            document.styleSheets[0].insertRule("#Dialog_buttons_pane.double:after{ clear: both; display: block; content: ' ';}", 0);
          }
        } else {
          buttons_pane.className = "single";
          //landscape in QVGA 
          if(screen.height <= 250)
          { 
               buttons_pane.style = "text-align:center;position:absolute;bottom:-15px;width:100%;";
          }
          //landscape in VGA and WVGA
		  else if(screen.height>250 && screen.height <480)
		  {
			buttons_pane.style = "text-align:center;position:absolute;bottom:-15px;width:100%";
		  }
		  //Others mode and resolution
          else
          {
            buttons_pane.style = "text-align:center;position:absolute;bottom:10%;width:100%";
           }
        }
        for ( var i = 0; i < options.buttons.length; i++ ) { (function(i)
        {
            var button = options.buttons[i];
            var button_frame = document.createElement('button');
            button_frame.style = "";
            var button_frame_text = document.createElement('span');
            button_frame_text.id = "Button_text";
            button_frame_text.innerHTML = button.label;
            button_frame.className = button.className;
            button_frame_text.style = ""
            button_frame.appendChild(button_frame_text);
            

            //opera.postError("Button" + button.label);
            button_frame.onclick = function()
            {
                Dialog.closeMessage();
                if ( input )
                {
                    if ( button.callback ) button.callback(i, button.label, input.valueFunction());
                }
                else
                {
                    if ( button.callback ) button.callback(i, button.label);
                }
                if(panel.parentNode) panel.parentNode.removeChild(panel);
            }
            buttons_pane.appendChild(button_frame);
            buttons_pane.appendChild(document.createTextNode(''));
        }).call(this, i)};
        panel.appendChild(buttons_pane);

        panel.display = 'none';
        document.body.appendChild(panel);
        panel.display = '';
        var greyOverlay = document.getElementById("Dialog_greyOverlay");
        //panel.style.top = (greyOverlay.offsetHeight - panel.offsetHeight) / 2;
        panel.style.left = (greyOverlay.offsetWidth - panel.offsetWidth) / 2;
        
        if ( options.input && options.input.focus ) { input.field.focus() }
        if ( options.input && options.input.select ) { input.field.select() }
    },
    showMessageYesNo: function(message, options)
    {
        this.showMessage(message,
        {
            title: options.title,
            buttons: [
                {
                    label: 'Yes'.toLocale(),
                    callback: options.yes
                },
                {
                    label: 'No'.toLocale(),
                    callback: options.no
                }
            ]
        });
    },
    showMessageOkCancel: function(message, options)
    {
        this.showMessage(message,
        {
            title: options.title,
            buttons: [
                {
                    label: 'OK'.toLocale(),
                    callback: options.ok
                },
                {
                    label: 'Cancel'.toLocale(),
                    callback: options.cancel
                }
            ]
        });
    }
}
/**
  *
  *
  */
document.addEventListener("XHR_fetching", function(evt){
    Dialog.XHR( evt.data, function() {
        
    });
}, false);
document.addEventListener("XHR_receiving", function(evt){
    Dialog.XHR( evt.data, function() {
        
    });
}, false);
document.addEventListener("XHR_error", function(evt){
    Dialog.XHR( evt.data, function() {
        
    });
}, false);
document.addEventListener("XHR_complete", function(evt){
    Dialog.closeMessage();
}, false);


