/**
 *  Copyright 2009 Opera Software ASA. All rights reserved.
 *
 * This file contains Original Code and/or Contributions to the Original 
 * Code as defined in the Opera Web Applications License (the License). 
 * You may not use this file except in compliance with the License. Please 
 * obtain a copy of the License at http://www.opera.com/license/owal/
 * and read it before using this file. 
 *
 * The Original Code and all Contributions to the Original Code distributed 
 * under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 * OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 */

/**
 *  Views
 */
Views = new (function()
{
    var _history        = [],
        _historyIndex   = -1,
        _previous       = '',
        _current        = '';


    /*
     *  show
     *  notes:
     *      * prepend the name of the view by an exclamation mark to force it
     *      * if a view is not forced, trying to show the same view twice will revert to the previous one.
     */
    this.show = function( newView, fromNode )
    {
        var showView    = newView[0]=='!'?newView.slice( 1 ):'';
        if( !showView  )
        {
            if( newView==_current && fromNode!=null && fromNode.hasAttribute('data-view-alternate-target') )
            {
                showView    = fromNode.getAttribute('data-view-alternate-target');
            }
            else
            {
                showView    = newView;
            }
        }
        if( showView )
        {
            var e,f;
            if( e=document.getElementById( showView ) )
            {
                if( f=document.getElementById( _current ) )
                {
                    f.style = '';
                }
                _previous               = _current;
                _current                = showView;
                e.parentNode.scrollTop  = 0;
                e.style                 = 'display:block;';
            }
            else
            {
                var evt = document.createEvent( 'Event' );

                evt.initEvent( 'missingView', true, true );
                evt.data = showView;
                (fromNode||document).dispatchEvent( evt );
            }
        }
        else
        {
            this.show( _previous, fromNode );
        }
    }

    /*
     *  onload -> initialize
     */
    window.addEventListener
    (
        'click',
        function()
        {
            var node = event.srcElement;
            while( node && node.hasAttribute )
            {
                if( node.hasAttribute('data-view-target') )
                {
                    this.show( node.getAttribute('data-view-target'), node );
                    break;
                }
                node = node.parentNode;
            }
        }.bind( this ),
        false
    )

})();