/* Generated by re2c 0.13.6 */
#line 1 "Zend/zend_ini_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6
#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yytext[0]) {                              \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng > 0 && (                          \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len) {  \
	Z_STRVAL_P(retval) = zend_strndup(str, len); \
	Z_STRLEN_P(retval) = len;                    \
	Z_TYPE_P(retval) = IS_STRING;                \
}

#define RETURN_TOKEN(type, str, len) {                       \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED) {      \
		zend_ini_copy_typed_value(ini_lval, type, str, len); \
	} else {                                                 \
		zend_ini_copy_value(ini_lval, str, len);             \
	}                                                        \
	return type;                                             \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh TSRMLS_DC)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(TSRMLS_D)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
int zend_ini_scanner_get_lineno(TSRMLS_D)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
char *zend_ini_scanner_get_filename(TSRMLS_D)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode TSRMLS_DC)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh TSRMLS_CC) == FAILURE) {
		zend_file_handle_dtor(fh TSRMLS_CC);
		return FAILURE;
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode TSRMLS_DC)
{
	int len = strlen(str);

	if (init_ini_scanner(scanner_mode, NULL TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len TSRMLS_CC);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

#line 384 "Zend/zend_ini_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case '\t':	goto yy5;
		case '\n':	goto yy7;
		case '\r':	goto yy9;
		case ' ':	goto yy10;
		case '!':
		case '"':
		case '$':
		case '&':
		case '(':
		case ')':
		case '^':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy11;
		case '#':	goto yy13;
		case '%':
		case '\'':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case ':':
		case '<':
		case '>':
		case '?':
		case '@':
		case ']':	goto yy14;
		case ';':	goto yy15;
		case '=':	goto yy17;
		case 'F':
		case 'f':	goto yy19;
		case 'N':
		case 'n':	goto yy20;
		case 'O':
		case 'o':	goto yy21;
		case 'T':
		case 't':	goto yy22;
		case 'Y':
		case 'y':	goto yy23;
		case '[':	goto yy24;
		default:	goto yy3;
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy27;
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 480 "Zend/zend_ini_scanner.l"
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
#line 522 "Zend/zend_ini_scanner.c"
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy74;
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 626 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 536 "Zend/zend_ini_scanner.c"
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 631 "Zend/zend_ini_scanner.l"
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 548 "Zend/zend_ini_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy77;
		goto yy8;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy27;
				if (yych <= '\t') goto yy73;
				goto yy77;
			} else {
				if (yych == '\r') goto yy78;
				if (yych <= 0x1F) goto yy27;
				goto yy75;
			}
		} else {
			if (yych <= ':') {
				if (yych == '#') goto yy64;
				goto yy27;
			} else {
				if (yych <= ';') goto yy59;
				if (yych == '=') goto yy57;
				goto yy27;
			}
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 554 "Zend/zend_ini_scanner.l"
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
#line 587 "Zend/zend_ini_scanner.c"
yy13:
		YYDEBUG(13, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy65;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy27;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy60;
		YYDEBUG(16, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 608 "Zend/zend_ini_scanner.c"
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy58;
yy18:
		YYDEBUG(18, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 490 "Zend/zend_ini_scanner.l"
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_VALUE TSRMLS_CC);
	}
	return '=';
}
#line 626 "Zend/zend_ini_scanner.c"
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy54;
		if (yych == 'a') goto yy54;
		goto yy27;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy45;
			if (yych <= 'T') goto yy27;
			goto yy46;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy27;
				goto yy45;
			} else {
				if (yych == 'u') goto yy46;
				goto yy27;
			}
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy39;
			if (yych <= 'M') goto yy27;
			goto yy32;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy27;
				goto yy39;
			} else {
				if (yych == 'n') goto yy32;
				goto yy27;
			}
		}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy37;
		if (yych == 'r') goto yy37;
		goto yy27;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy28;
		if (yych == 'e') goto yy28;
		goto yy27;
yy24:
		YYDEBUG(24, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(25, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 405 "Zend/zend_ini_scanner.l"
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW TSRMLS_CC);
	} else {
		yy_push_state(ST_SECTION_VALUE TSRMLS_CC);
	}
	return TC_SECTION;
}
#line 692 "Zend/zend_ini_scanner.c"
yy26:
		YYDEBUG(26, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy27:
		YYDEBUG(27, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy26;
		}
		if (yych == '[') goto yy29;
		goto yy4;
yy28:
		YYDEBUG(28, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy32;
		if (yych == 's') goto yy32;
		goto yy27;
yy29:
		YYDEBUG(29, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(30, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy29;
		}
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 430 "Zend/zend_ini_scanner.l"
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();
	
	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET TSRMLS_CC);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
#line 735 "Zend/zend_ini_scanner.c"
yy32:
		YYDEBUG(32, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(33, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy32;
		}
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy26;
					if (yych <= '\t') goto yy35;
				} else {
					if (yych != '\r') goto yy26;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy26;
				} else {
					if (yych != '&') goto yy26;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy34;
					if (yych <= ':') goto yy26;
				} else {
					if (yych != '=') goto yy26;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy29;
					if (yych <= ']') goto yy26;
				} else {
					if (yych <= 'z') goto yy26;
					if (yych >= 0x7F) goto yy26;
				}
			}
		}
yy34:
		YYDEBUG(34, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 468 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 785 "Zend/zend_ini_scanner.c"
yy35:
		YYDEBUG(35, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(36, *YYCURSOR);
		if (yych == '\t') goto yy35;
		if (yych == ' ') goto yy35;
		goto yy34;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy38;
		if (yych != 'u') goto yy27;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy32;
		if (yych == 'e') goto yy32;
		goto yy27;
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy40;
		if (yych != 'f') goto yy27;
yy40:
		YYDEBUG(40, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(41, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy26;
					if (yych <= '\t') goto yy43;
				} else {
					if (yych != '\r') goto yy26;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy40;
					if (yych >= '#') goto yy26;
				} else {
					if (yych == '%') goto yy26;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy26;
					if (yych >= '*') goto yy26;
				} else {
					if (yych == '<') goto yy26;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy29;
					goto yy26;
				} else {
					if (yych <= '^') goto yy42;
					if (yych <= 'z') goto yy26;
					if (yych >= 0x7F) goto yy26;
				}
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 472 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 859 "Zend/zend_ini_scanner.c"
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		if (yych == '\t') goto yy43;
		if (yych == ' ') goto yy43;
		goto yy42;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy27;
					if (yych <= '\t') goto yy43;
					goto yy42;
				} else {
					if (yych == '\r') goto yy42;
					goto yy27;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy40;
					if (yych <= '"') goto yy42;
					goto yy27;
				} else {
					if (yych == '%') goto yy27;
					if (yych <= '&') goto yy42;
					goto yy27;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy42;
					if (yych <= ':') goto yy27;
					goto yy42;
				} else {
					if (yych == '=') goto yy42;
					if (yych <= 'M') goto yy27;
					goto yy53;
				}
			} else {
				if (yych <= 'm') {
					if (yych == '^') goto yy42;
					goto yy27;
				} else {
					if (yych <= 'n') goto yy53;
					if (yych <= 'z') goto yy27;
					if (yych <= '~') goto yy42;
					goto yy27;
				}
			}
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy47;
		if (yych != 'l') goto yy27;
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy48;
		if (yych != 'l') goto yy27;
yy48:
		YYDEBUG(48, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(49, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy26;
					if (yych <= '\t') goto yy51;
				} else {
					if (yych != '\r') goto yy26;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy48;
					if (yych >= '#') goto yy26;
				} else {
					if (yych == '%') goto yy26;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy26;
					if (yych >= '*') goto yy26;
				} else {
					if (yych == '<') goto yy26;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy29;
					goto yy26;
				} else {
					if (yych <= '^') goto yy50;
					if (yych <= 'z') goto yy26;
					if (yych >= 0x7F) goto yy26;
				}
			}
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 476 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 974 "Zend/zend_ini_scanner.c"
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(52, *YYCURSOR);
		if (yych == '\t') goto yy51;
		if (yych == ' ') goto yy51;
		goto yy50;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy40;
		if (yych == 'e') goto yy40;
		goto yy27;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy55;
		if (yych != 'l') goto yy27;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy56;
		if (yych != 's') goto yy27;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy40;
		if (yych == 'e') goto yy40;
		goto yy27;
yy57:
		YYDEBUG(57, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy58:
		YYDEBUG(58, *YYCURSOR);
		if (yych == '\t') goto yy57;
		if (yych == ' ') goto yy57;
		goto yy18;
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy60:
		YYDEBUG(60, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy59;
		}
		if (yych >= '\r') goto yy63;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 636 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1039 "Zend/zend_ini_scanner.c"
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy61;
		goto yy62;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy65:
		YYDEBUG(65, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy64;
					if (yych >= '\n') goto yy70;
				} else {
					if (yych == '\r') goto yy72;
					goto yy64;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy64;
				} else {
					if (yych != '&') goto yy64;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy66;
					if (yych <= ':') goto yy64;
				} else {
					if (yych != '=') goto yy64;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy68;
					if (yych <= ']') goto yy64;
				} else {
					if (yych <= 'z') goto yy64;
					if (yych >= 0x7F) goto yy64;
				}
			}
		}
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(67, *YYCURSOR);
		if (yych == '\n') goto yy70;
		if (yych == '\r') goto yy72;
		goto yy66;
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(69, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy66;
			if (yych <= '\t') goto yy68;
			if (yych >= '\v') goto yy66;
		} else {
			if (yych <= '\r') goto yy72;
			if (yych == ' ') goto yy68;
			goto yy66;
		}
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
yy71:
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 642 "Zend/zend_ini_scanner.l"
		{ /* #Comment */
	zend_error(E_DEPRECATED, "Comments starting with '#' are deprecated in %s on line %d", zend_ini_scanner_get_filename(TSRMLS_C), SCNG(lineno));
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1125 "Zend/zend_ini_scanner.c"
yy72:
		YYDEBUG(72, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy70;
		goto yy71;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy74:
		YYDEBUG(74, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy6;
				if (yych <= '\t') goto yy73;
				goto yy77;
			} else {
				if (yych == '\r') goto yy78;
				if (yych <= 0x1F) goto yy6;
				goto yy73;
			}
		} else {
			if (yych <= ':') {
				if (yych == '#') goto yy66;
				goto yy6;
			} else {
				if (yych <= ';') goto yy59;
				if (yych == '=') goto yy57;
				goto yy6;
			}
		}
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy26;
					if (yych <= '\t') goto yy73;
				} else {
					if (yych == '\r') goto yy78;
					goto yy26;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy75;
					if (yych <= '"') goto yy4;
					goto yy64;
				} else {
					if (yych == '%') goto yy26;
					goto yy4;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy26;
					if (yych <= ')') goto yy4;
					goto yy26;
				} else {
					if (yych <= ';') goto yy59;
					if (yych <= '<') goto yy26;
					goto yy57;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy29;
					goto yy26;
				} else {
					if (yych <= '^') goto yy4;
					if (yych <= 'z') goto yy26;
					if (yych <= '~') goto yy4;
					goto yy26;
				}
			}
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy8;
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy77;
		goto yy8;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(79, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy83;
		if (yych == '$') goto yy85;
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
yy82:
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 586 "Zend/zend_ini_scanner.l"
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}
		
		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	
	zend_ini_escape_string(ini_lval, yytext, yyleng, '"' TSRMLS_CC);
	return TC_QUOTED_STRING;
}
#line 1301 "Zend/zend_ini_scanner.c"
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy89;
yy84:
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 581 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string ends */
	yy_pop_state(TSRMLS_C);
	return '"';
}
#line 1315 "Zend/zend_ini_scanner.c"
yy85:
		YYDEBUG(85, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy82;
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1329 "Zend/zend_ini_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy89:
		YYDEBUG(89, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy88;
		}
		goto yy84;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66, 194,  64,  66,  66,  64,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			194,  66,  64,  66,  68,  66,  66,   0, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114,  66,  64,  66,  66,  66,  66, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  72,  64,  66,  82, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
		};
		YYDEBUG(90, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy92;
					if (yych <= '\t') goto yy94;
					goto yy95;
				} else {
					if (yych == '\r') goto yy95;
					if (yych >= ' ') goto yy94;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy97;
					if (yych >= '$') goto yy99;
				} else {
					if (yych == '\'') goto yy100;
					if (yych >= '-') goto yy101;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy102;
					if (yych >= '0') goto yy103;
				} else {
					if (yych == ';') goto yy95;
					if (yych >= 'A') goto yy105;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy92;
					if (yych <= '\\') goto yy107;
					if (yych <= ']') goto yy108;
				} else {
					if (yych == '`') goto yy92;
					if (yych <= 'z') goto yy105;
				}
			}
		}
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy111;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 572 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1433 "Zend/zend_ini_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy137;
		}
		if (yych == '"') goto yy139;
		if (yych == ']') goto yy140;
		goto yy111;
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1454 "Zend/zend_ini_scanner.c"
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 576 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 1466 "Zend/zend_ini_scanner.c"
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy96;
			if (yych <= '[') goto yy110;
			goto yy115;
		} else {
			if (yych == '{') goto yy135;
			goto yy110;
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy131;
		}
		goto yy96;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy111;
		if (yych <= '9') goto yy129;
		goto yy111;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy111;
		if (yych <= '9') goto yy127;
		goto yy111;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy104;
				if (yych <= '\f') goto yy111;
			} else {
				if (yych == '"') goto yy104;
				if (yych <= '&') goto yy111;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy123;
				if (yych <= '/') goto yy111;
				goto yy125;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy111;
				} else {
					if (yych != ']') goto yy111;
				}
			}
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 550 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1532 "Zend/zend_ini_scanner.c"
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy121;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy111;
			} else {
				if (yych <= '\r') goto yy106;
				if (yych <= '!') goto yy111;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy111;
			} else {
				if (yych <= ';') goto yy106;
				if (yych != ']') goto yy111;
			}
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 546 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1562 "Zend/zend_ini_scanner.c"
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy110;
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 443 "Zend/zend_ini_scanner.l"
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
#line 1578 "Zend/zend_ini_scanner.c"
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy111:
		YYDEBUG(111, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy110;
		}
		if (yych == '$') goto yy113;
		if (yych != '\\') goto yy93;
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy110;
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy114;
			if (yych <= '[') goto yy110;
			goto yy115;
		} else {
			if (yych != '{') goto yy110;
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy93;
			} else {
				goto yy96;
			}
		} else {
			if (yyaccept == 2) {
				goto yy104;
			} else {
				goto yy106;
			}
		}
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy116;
		}
		if (yych == '\\') goto yy118;
		goto yy110;
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy116;
		}
		if (yych == '\\') goto yy120;
		goto yy110;
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy116;
		}
		if (yych == '\\') goto yy118;
		goto yy110;
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy116;
		}
		if (yych == '\\') goto yy118;
		goto yy110;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy121;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy106;
				if (yych <= '\f') goto yy110;
				goto yy106;
			} else {
				if (yych == '"') goto yy106;
				if (yych <= '#') goto yy110;
				goto yy113;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy106;
				if (yych <= ':') goto yy110;
				goto yy106;
			} else {
				if (yych <= '[') goto yy110;
				if (yych <= '\\') goto yy112;
				if (yych <= ']') goto yy106;
				goto yy110;
			}
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy123;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy104;
				if (yych <= '\f') goto yy110;
				goto yy104;
			} else {
				if (yych == '"') goto yy104;
				if (yych <= '#') goto yy110;
				goto yy113;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy104;
				if (yych <= ':') goto yy110;
				goto yy104;
			} else {
				if (yych <= '[') goto yy110;
				if (yych <= '\\') goto yy112;
				if (yych <= ']') goto yy104;
				goto yy110;
			}
		}
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy110;
					goto yy104;
				} else {
					if (yych == '\r') goto yy104;
					goto yy110;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy104;
					goto yy110;
				} else {
					if (yych <= '$') goto yy113;
					if (yych <= '&') goto yy110;
					goto yy104;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy110;
					goto yy123;
				} else {
					if (yych <= '/') goto yy110;
					if (yych <= '9') goto yy125;
					goto yy110;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy104;
					goto yy110;
				} else {
					if (yych <= '\\') goto yy112;
					if (yych <= ']') goto yy104;
					goto yy110;
				}
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy104;
				if (yych <= '\f') goto yy110;
				goto yy104;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy110;
					goto yy104;
				} else {
					if (yych == '$') goto yy113;
					goto yy110;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy104;
				if (yych <= '/') goto yy110;
				if (yych <= '9') goto yy127;
				goto yy110;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy104;
					goto yy110;
				} else {
					if (yych <= '\\') goto yy112;
					if (yych <= ']') goto yy104;
					goto yy110;
				}
			}
		}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy104;
				if (yych <= '\f') goto yy110;
				goto yy104;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy110;
					goto yy104;
				} else {
					if (yych == '$') goto yy113;
					goto yy110;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy104;
				if (yych <= '/') goto yy110;
				if (yych <= '9') goto yy129;
				goto yy110;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy104;
					goto yy110;
				} else {
					if (yych <= '\\') goto yy112;
					if (yych <= ']') goto yy104;
					goto yy110;
				}
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy131;
		}
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1877 "Zend/zend_ini_scanner.c"
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 1888 "Zend/zend_ini_scanner.c"
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(138, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy137;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy93;
				if (yych <= '\f') goto yy110;
				goto yy93;
			} else {
				if (yych == '"') goto yy139;
				if (yych <= '#') goto yy110;
				goto yy113;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy93;
				if (yych <= ':') goto yy110;
				goto yy93;
			} else {
				if (yych <= '[') goto yy110;
				if (yych <= '\\') goto yy112;
				if (yych <= ']') goto yy140;
				goto yy110;
			}
		}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy98;
yy140:
		YYDEBUG(140, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy109;
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(141, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy145;
			} else {
				if (yych <= '\t') goto yy147;
				if (yych <= '\n') goto yy148;
				goto yy145;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy150;
				if (yych <= 0x1F) goto yy145;
				goto yy147;
			} else {
				if (yych == ';') goto yy151;
				goto yy145;
			}
		}
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(144, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 649 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 1998 "Zend/zend_ini_scanner.c"
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 499 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	char *sc = NULL;
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				/* no break */
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	yyleng = YYCURSOR - SCNG(yy_text);

	/* Eat trailing semicolons */
	while (yytext[yyleng - 1] == ';') {
		yyleng--;
	}

	/* Eat leading and trailing double quotes */
	if (yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	} else if (sc) {
		YYCURSOR = sc;
		yyleng = YYCURSOR - SCNG(yy_text);
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2042 "Zend/zend_ini_scanner.c"
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy146;
			if (yych <= '\n') goto yy159;
			if (yych <= '\f') goto yy146;
			goto yy159;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy146;
				goto yy159;
			} else {
				if (yych == ';') goto yy159;
				goto yy146;
			}
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 540 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2073 "Zend/zend_ini_scanner.c"
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy157;
		goto yy149;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy153;
yy152:
		YYDEBUG(152, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy153:
		YYDEBUG(153, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy152;
		}
		if (yych >= '\r') goto yy156;
yy154:
		YYDEBUG(154, *YYCURSOR);
		++YYCURSOR;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 636 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2107 "Zend/zend_ini_scanner.c"
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy154;
		goto yy155;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy149;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy159:
		YYDEBUG(159, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy158;
		}
		if (yych <= '\f') {
			if (yych == '\n') goto yy157;
		} else {
			if (yych <= '\r') goto yy161;
			if (yych == ';') goto yy152;
		}
		YYDEBUG(160, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 626 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 2141 "Zend/zend_ini_scanner.c"
yy161:
		YYDEBUG(161, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy157;
		goto yy149;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 192,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			192, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(162, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\n') goto yy166;
		} else {
			if (yych <= '\r') goto yy166;
			if (yych == ']') goto yy168;
		}
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy175;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 536 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2205 "Zend/zend_ini_scanner.c"
yy166:
		YYDEBUG(166, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(167, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2215 "Zend/zend_ini_scanner.c"
yy168:
		YYDEBUG(168, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy171;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 424 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2230 "Zend/zend_ini_scanner.c"
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy171:
		YYDEBUG(171, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy170;
		}
		if (yych == '\n') goto yy172;
		if (yych == '\r') goto yy173;
		goto yy169;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy169;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy172;
		goto yy169;
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy175:
		YYDEBUG(175, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy174;
		}
		goto yy165;
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 134, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			134, 132, 128, 132, 136, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			228, 228, 228, 228, 228, 228, 228, 228, 
			228, 228, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 144, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(176, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy178;
					if (yych <= '\t') goto yy180;
					goto yy181;
				} else {
					if (yych == '\r') goto yy181;
					if (yych >= ' ') goto yy180;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy183;
					if (yych >= '$') goto yy185;
				} else {
					if (yych == '\'') goto yy186;
					if (yych >= '-') goto yy187;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy188;
					if (yych >= '0') goto yy189;
				} else {
					if (yych == ';') goto yy181;
					if (yych >= 'A') goto yy191;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy178;
					if (yych <= '\\') goto yy193;
					if (yych <= ']') goto yy194;
				} else {
					if (yych == '`') goto yy178;
					if (yych <= 'z') goto yy191;
				}
			}
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy201;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 572 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2356 "Zend/zend_ini_scanner.c"
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy227;
			goto yy201;
		} else {
			if (yych <= ' ') goto yy227;
			if (yych == '"') goto yy229;
			goto yy201;
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2379 "Zend/zend_ini_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 576 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 2391 "Zend/zend_ini_scanner.c"
yy185:
		YYDEBUG(185, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy182;
			if (yych <= '[') goto yy200;
			goto yy205;
		} else {
			if (yych == '{') goto yy225;
			goto yy200;
		}
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy221;
		}
		goto yy182;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy201;
		if (yych <= '9') goto yy219;
		goto yy201;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy201;
		if (yych <= '9') goto yy217;
		goto yy201;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy190;
				if (yych <= '\f') goto yy201;
			} else {
				if (yych == '"') goto yy190;
				if (yych <= '&') goto yy201;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy213;
				if (yych <= '/') goto yy201;
				goto yy215;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy201;
				} else {
					if (yych != ']') goto yy201;
				}
			}
		}
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 550 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2457 "Zend/zend_ini_scanner.c"
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy211;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy201;
			} else {
				if (yych <= '\r') goto yy192;
				if (yych <= '!') goto yy201;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy201;
			} else {
				if (yych <= ';') goto yy192;
				if (yych != ']') goto yy201;
			}
		}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 546 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 2487 "Zend/zend_ini_scanner.c"
yy193:
		YYDEBUG(193, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy200;
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy197;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 424 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2506 "Zend/zend_ini_scanner.c"
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy197:
		YYDEBUG(197, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy196;
		}
		if (yych == '\n') goto yy198;
		if (yych == '\r') goto yy199;
		goto yy195;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy195;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy198;
		goto yy195;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy201:
		YYDEBUG(201, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy200;
		}
		if (yych == '$') goto yy203;
		if (yych != '\\') goto yy179;
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy200;
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy204;
			if (yych <= '[') goto yy200;
			goto yy205;
		} else {
			if (yych != '{') goto yy200;
		}
yy204:
		YYDEBUG(204, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy179;
			} else {
				goto yy182;
			}
		} else {
			if (yyaccept == 2) {
				goto yy190;
			} else {
				goto yy192;
			}
		}
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy206;
		}
		if (yych == '\\') goto yy208;
		goto yy200;
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(207, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy206;
		}
		if (yych == '\\') goto yy210;
		goto yy200;
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy206;
		}
		if (yych == '\\') goto yy208;
		goto yy200;
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy206;
		}
		if (yych == '\\') goto yy208;
		goto yy200;
yy211:
		YYDEBUG(211, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy211;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy192;
				if (yych <= '\f') goto yy200;
				goto yy192;
			} else {
				if (yych == '"') goto yy192;
				if (yych <= '#') goto yy200;
				goto yy203;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy192;
				if (yych <= ':') goto yy200;
				goto yy192;
			} else {
				if (yych <= '[') goto yy200;
				if (yych <= '\\') goto yy202;
				if (yych <= ']') goto yy192;
				goto yy200;
			}
		}
yy213:
		YYDEBUG(213, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy213;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy190;
				if (yych <= '\f') goto yy200;
				goto yy190;
			} else {
				if (yych == '"') goto yy190;
				if (yych <= '#') goto yy200;
				goto yy203;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy190;
				if (yych <= ':') goto yy200;
				goto yy190;
			} else {
				if (yych <= '[') goto yy200;
				if (yych <= '\\') goto yy202;
				if (yych <= ']') goto yy190;
				goto yy200;
			}
		}
yy215:
		YYDEBUG(215, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy200;
					goto yy190;
				} else {
					if (yych == '\r') goto yy190;
					goto yy200;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy190;
					goto yy200;
				} else {
					if (yych <= '$') goto yy203;
					if (yych <= '&') goto yy200;
					goto yy190;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy200;
					goto yy213;
				} else {
					if (yych <= '/') goto yy200;
					if (yych <= '9') goto yy215;
					goto yy200;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy190;
					goto yy200;
				} else {
					if (yych <= '\\') goto yy202;
					if (yych <= ']') goto yy190;
					goto yy200;
				}
			}
		}
yy217:
		YYDEBUG(217, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy190;
				if (yych <= '\f') goto yy200;
				goto yy190;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy200;
					goto yy190;
				} else {
					if (yych == '$') goto yy203;
					goto yy200;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy190;
				if (yych <= '/') goto yy200;
				if (yych <= '9') goto yy217;
				goto yy200;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy190;
					goto yy200;
				} else {
					if (yych <= '\\') goto yy202;
					if (yych <= ']') goto yy190;
					goto yy200;
				}
			}
		}
yy219:
		YYDEBUG(219, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy190;
				if (yych <= '\f') goto yy200;
				goto yy190;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy200;
					goto yy190;
				} else {
					if (yych == '$') goto yy203;
					goto yy200;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy190;
				if (yych <= '/') goto yy200;
				if (yych <= '9') goto yy219;
				goto yy200;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy190;
					goto yy200;
				} else {
					if (yych <= '\\') goto yy202;
					if (yych <= ']') goto yy190;
					goto yy200;
				}
			}
		}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy221;
		}
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2827 "Zend/zend_ini_scanner.c"
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 2838 "Zend/zend_ini_scanner.c"
yy227:
		YYDEBUG(227, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(228, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy200;
				if (yych <= '\t') goto yy227;
				if (yych <= '\n') goto yy179;
				goto yy200;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy179;
					goto yy200;
				} else {
					if (yych <= ' ') goto yy227;
					if (yych <= '!') goto yy200;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '$') {
					if (yych <= '#') goto yy200;
					goto yy203;
				} else {
					if (yych == '\'') goto yy179;
					goto yy200;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy179;
					goto yy200;
				} else {
					if (yych <= '\\') goto yy202;
					if (yych <= ']') goto yy179;
					goto yy200;
				}
			}
		}
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy184;
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			160, 162, 162, 162, 162, 162, 162, 162, 
			162, 176, 128, 162, 162, 128, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			176, 160, 160, 162, 168, 162, 160,  32, 
			160, 160, 162, 162, 162, 162, 162, 162, 
			230, 230, 230, 230, 230, 230, 230, 230, 
			230, 230, 162, 160, 162, 160, 162, 162, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 162, 162, 160, 166, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 160, 162, 160, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
		};
		YYDEBUG(230, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:	goto yy232;
		case '\t':
		case ' ':	goto yy236;
		case '\n':	goto yy238;
		case '\r':	goto yy240;
		case '!':
		case '&':
		case '(':
		case ')':
		case '^':
		case '|':
		case '~':	goto yy241;
		case '"':	goto yy243;
		case '$':	goto yy245;
		case '\'':	goto yy246;
		case '-':	goto yy247;
		case '.':	goto yy248;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy249;
		case ';':	goto yy251;
		case '=':	goto yy252;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy254;
		case 'F':
		case 'f':	goto yy256;
		case 'N':
		case 'n':	goto yy257;
		case 'O':
		case 'o':	goto yy258;
		case 'T':
		case 't':	goto yy259;
		case 'Y':
		case 'y':	goto yy260;
		default:	goto yy234;
		}
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 649 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3024 "Zend/zend_ini_scanner.c"
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy262;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 568 "Zend/zend_ini_scanner.l"
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 3037 "Zend/zend_ini_scanner.c"
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy316;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 622 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
#line 3050 "Zend/zend_ini_scanner.c"
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 540 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 3063 "Zend/zend_ini_scanner.c"
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy314;
		goto yy239;
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy313;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 558 "Zend/zend_ini_scanner.l"
		{ /* Boolean operators */
	return yytext[0];
}
#line 3081 "Zend/zend_ini_scanner.c"
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 576 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES TSRMLS_CC);
	return '"';
}
#line 3093 "Zend/zend_ini_scanner.c"
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy233;
			if (yych <= '[') goto yy261;
			goto yy268;
		} else {
			if (yych == '{') goto yy310;
			goto yy261;
		}
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy306;
		}
		goto yy233;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy262;
		if (yych <= '9') goto yy304;
		goto yy262;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy262;
		if (yych <= '9') goto yy302;
		goto yy262;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy250;
					if (yych <= 0x08) goto yy262;
				} else {
					if (yych != '\r') goto yy262;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy250;
					if (yych <= '%') goto yy262;
				} else {
					if (yych == '.') goto yy298;
					goto yy262;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy300;
					if (yych <= ':') goto yy262;
				} else {
					if (yych != '=') goto yy262;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy250;
					if (yych <= '{') goto yy262;
				} else {
					if (yych != '~') goto yy262;
				}
			}
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 550 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 3172 "Zend/zend_ini_scanner.c"
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy294;
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 562 "Zend/zend_ini_scanner.l"
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3189 "Zend/zend_ini_scanner.c"
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy263;
		}
		if (yych <= ':') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy262;
				} else {
					if (yych <= '\n') goto yy255;
					if (yych <= '\f') goto yy262;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy262;
				} else {
					if (yych <= '%') goto yy262;
					if (yych >= '*') goto yy262;
				}
			}
		} else {
			if (yych <= '^') {
				if (yych <= '<') {
					if (yych >= '<') goto yy262;
				} else {
					if (yych <= '=') goto yy255;
					if (yych <= ']') goto yy262;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy262;
				} else {
					if (yych != '~') goto yy262;
				}
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 546 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 3236 "Zend/zend_ini_scanner.c"
yy256:
		YYDEBUG(256, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					goto yy262;
				} else {
					if (yych <= '9') goto yy263;
					if (yych == ';') goto yy255;
					goto yy262;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy255;
					if (yych <= '@') goto yy262;
					goto yy290;
				} else {
					if (yych <= 'Z') goto yy263;
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					goto yy263;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy262;
					if (yych <= 'a') goto yy290;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					if (yych <= '\n') goto yy255;
					goto yy262;
				} else {
					if (yych <= '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					if (yych <= '"') goto yy255;
					goto yy262;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					if (yych <= '9') goto yy263;
					goto yy262;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy255;
						goto yy262;
					} else {
						if (yych <= '=') goto yy255;
						if (yych <= '@') goto yy262;
						goto yy263;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy282;
					if (yych == 'U') goto yy283;
					goto yy263;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy262;
						goto yy255;
					} else {
						if (yych == '`') goto yy262;
						goto yy263;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy282;
					if (yych == 'u') goto yy283;
					goto yy263;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy262;
						goto yy255;
					} else {
						if (yych == '~') goto yy255;
						goto yy262;
					}
				}
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					if (yych <= '\n') goto yy255;
					goto yy262;
				} else {
					if (yych <= '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					if (yych <= '"') goto yy255;
					goto yy262;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					if (yych <= '9') goto yy263;
					goto yy262;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy255;
						goto yy262;
					} else {
						if (yych <= '=') goto yy255;
						if (yych <= '@') goto yy262;
						goto yy263;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy277;
					if (yych == 'N') goto yy271;
					goto yy263;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy262;
						goto yy255;
					} else {
						if (yych == '`') goto yy262;
						goto yy263;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy277;
					if (yych == 'n') goto yy271;
					goto yy263;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy262;
						goto yy255;
					} else {
						if (yych == '~') goto yy255;
						goto yy262;
					}
				}
			}
		}
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych == 'R') goto yy275;
					goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy275;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych == 'E') goto yy265;
					goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy265;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy262:
		YYDEBUG(262, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy261;
		}
		if (yych == '$') goto yy266;
		goto yy235;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(264, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy263;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy255;
					goto yy261;
				} else {
					if (yych <= '\n') goto yy255;
					if (yych <= '\f') goto yy261;
					goto yy255;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy261;
					if (yych <= '"') goto yy255;
					goto yy261;
				} else {
					if (yych <= '$') goto yy266;
					if (yych <= '%') goto yy261;
					goto yy255;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy261;
					goto yy255;
				} else {
					if (yych == '=') goto yy255;
					goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy255;
					if (yych <= '{') goto yy261;
					goto yy255;
				} else {
					if (yych == '~') goto yy255;
					goto yy261;
				}
			}
		}
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych == 'S') goto yy271;
					goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy271;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy266:
		YYDEBUG(266, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy267;
			if (yych <= '[') goto yy261;
			goto yy268;
		} else {
			if (yych != '{') goto yy261;
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy235;
				} else {
					goto yy237;
				}
			} else {
				if (yyaccept == 2) {
					goto yy233;
				} else {
					goto yy250;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy255;
				} else {
					goto yy272;
				}
			} else {
				if (yyaccept == 6) {
					goto yy279;
				} else {
					goto yy286;
				}
			}
		}
yy268:
		YYDEBUG(268, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy269;
		}
		goto yy261;
yy269:
		YYDEBUG(269, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(270, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy269;
		}
		if (yych <= 0x00) goto yy235;
		if (yych == '\\') goto yy268;
		goto yy261;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy273;
		}
		if (yych <= ';') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy272;
					if (yych <= '\t') goto yy262;
				} else {
					if (yych != '\r') goto yy262;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy272;
					if (yych <= '%') goto yy262;
				} else {
					if (yych <= '/') goto yy262;
					if (yych <= '9') goto yy263;
					if (yych <= ':') goto yy262;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') {
					if (yych != '=') goto yy262;
				} else {
					if (yych <= 'Z') goto yy263;
					if (yych <= ']') goto yy262;
					if (yych >= '_') goto yy263;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy262;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych >= 0x7F) goto yy262;
				}
			}
		}
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 468 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 3752 "Zend/zend_ini_scanner.c"
yy273:
		YYDEBUG(273, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(274, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy273;
		}
		goto yy272;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych != 'U') goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy276;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych == 'E') goto yy271;
					goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy271;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych != 'F') goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy278;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy263;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy262;
				} else {
					if (yych <= '\t') goto yy280;
					if (yych >= '\v') goto yy262;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy279;
					if (yych <= 0x1F) goto yy262;
					goto yy280;
				} else {
					if (yych <= '"') goto yy279;
					if (yych <= '%') goto yy262;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy262;
				} else {
					if (yych != '=') goto yy262;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy279;
					if (yych <= '{') goto yy262;
				} else {
					if (yych != '~') goto yy262;
				}
			}
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 472 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 3962 "Zend/zend_ini_scanner.c"
yy280:
		YYDEBUG(280, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(281, *YYCURSOR);
		if (yych == '\t') goto yy280;
		if (yych == ' ') goto yy280;
		goto yy279;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy279;
					if (yych <= 0x08) goto yy262;
					if (yych <= '\t') goto yy280;
					goto yy279;
				} else {
					if (yych == '\r') goto yy279;
					if (yych <= 0x1F) goto yy262;
					goto yy280;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy279;
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy279;
					goto yy262;
				} else {
					if (yych <= '9') goto yy263;
					if (yych == ';') goto yy279;
					goto yy262;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy279;
					if (yych <= '@') goto yy262;
					if (yych <= 'M') goto yy263;
					goto yy289;
				} else {
					if (yych <= 'Z') goto yy263;
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy279;
					goto yy263;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy262;
					if (yych == 'n') goto yy289;
					goto yy263;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy262;
						goto yy279;
					} else {
						if (yych == '~') goto yy279;
						goto yy262;
					}
				}
			}
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych != 'L') goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy284;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych != 'L') goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy285;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy263;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy262;
				} else {
					if (yych <= '\t') goto yy287;
					if (yych >= '\v') goto yy262;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy286;
					if (yych <= 0x1F) goto yy262;
					goto yy287;
				} else {
					if (yych <= '"') goto yy286;
					if (yych <= '%') goto yy262;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy262;
				} else {
					if (yych != '=') goto yy262;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy286;
					if (yych <= '{') goto yy262;
				} else {
					if (yych != '~') goto yy262;
				}
			}
		}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 476 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 4177 "Zend/zend_ini_scanner.c"
yy287:
		YYDEBUG(287, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(288, *YYCURSOR);
		if (yych == '\t') goto yy287;
		if (yych == ' ') goto yy287;
		goto yy286;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych == 'E') goto yy278;
					goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy278;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych != 'L') goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy291;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych != 'S') goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy292;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy255;
					if (yych <= 0x08) goto yy262;
					goto yy255;
				} else {
					if (yych == '\r') goto yy255;
					if (yych <= 0x1F) goto yy262;
					goto yy255;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy262;
					if (yych <= ')') goto yy255;
					if (yych <= '/') goto yy262;
					goto yy263;
				} else {
					if (yych == ';') goto yy255;
					if (yych <= '<') goto yy262;
					goto yy255;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy262;
					if (yych == 'E') goto yy278;
					goto yy263;
				} else {
					if (yych <= ']') goto yy262;
					if (yych <= '^') goto yy255;
					if (yych <= '_') goto yy263;
					goto yy262;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy278;
					if (yych <= 'z') goto yy263;
					goto yy262;
				} else {
					if (yych == '}') goto yy262;
					if (yych <= '~') goto yy255;
					goto yy262;
				}
			}
		}
yy293:
		YYDEBUG(293, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy294:
		YYDEBUG(294, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy293;
		}
		if (yych >= '\r') goto yy297;
yy295:
		YYDEBUG(295, *YYCURSOR);
		++YYCURSOR;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 636 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 4412 "Zend/zend_ini_scanner.c"
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy295;
		goto yy296;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(299, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy298;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy250;
					goto yy261;
				} else {
					if (yych <= '\n') goto yy250;
					if (yych <= '\f') goto yy261;
					goto yy250;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy261;
					if (yych <= '"') goto yy250;
					goto yy261;
				} else {
					if (yych <= '$') goto yy266;
					if (yych <= '%') goto yy261;
					goto yy250;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy261;
					goto yy250;
				} else {
					if (yych == '=') goto yy250;
					goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy250;
					if (yych <= '{') goto yy261;
					goto yy250;
				} else {
					if (yych == '~') goto yy250;
					goto yy261;
				}
			}
		}
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(301, *YYCURSOR);
		if (yych <= '.') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy250;
					if (yych <= 0x08) goto yy261;
					goto yy250;
				} else {
					if (yych == '\r') goto yy250;
					goto yy261;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy250;
					if (yych <= '#') goto yy261;
					goto yy266;
				} else {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy250;
					if (yych <= '-') goto yy261;
					goto yy298;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '/') goto yy261;
					if (yych <= '9') goto yy300;
					goto yy261;
				} else {
					if (yych == '<') goto yy261;
					goto yy250;
				}
			} else {
				if (yych <= '{') {
					if (yych == '^') goto yy250;
					goto yy261;
				} else {
					if (yych == '}') goto yy261;
					if (yych <= '~') goto yy250;
					goto yy261;
				}
			}
		}
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(303, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy250;
					if (yych <= 0x08) goto yy261;
					goto yy250;
				} else {
					if (yych == '\r') goto yy250;
					goto yy261;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy250;
					if (yych <= '#') goto yy261;
					goto yy266;
				} else {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy250;
					goto yy261;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy302;
					if (yych <= ':') goto yy261;
					goto yy250;
				} else {
					if (yych == '=') goto yy250;
					goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy250;
					if (yych <= '{') goto yy261;
					goto yy250;
				} else {
					if (yych == '~') goto yy250;
					goto yy261;
				}
			}
		}
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(305, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy250;
					if (yych <= 0x08) goto yy261;
					goto yy250;
				} else {
					if (yych == '\r') goto yy250;
					goto yy261;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy250;
					if (yych <= '#') goto yy261;
					goto yy266;
				} else {
					if (yych <= '%') goto yy261;
					if (yych <= ')') goto yy250;
					goto yy261;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy304;
					if (yych <= ':') goto yy261;
					goto yy250;
				} else {
					if (yych == '=') goto yy250;
					goto yy261;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy250;
					if (yych <= '{') goto yy261;
					goto yy250;
				} else {
					if (yych == '~') goto yy250;
					goto yy261;
				}
			}
		}
yy306:
		YYDEBUG(306, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(307, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy306;
		}
		YYDEBUG(308, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(309, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 415 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 4639 "Zend/zend_ini_scanner.c"
yy310:
		YYDEBUG(310, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(311, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 448 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME TSRMLS_CC);
	return TC_DOLLAR_CURLY;
}
#line 4650 "Zend/zend_ini_scanner.c"
yy312:
		YYDEBUG(312, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy313:
		YYDEBUG(313, *YYCURSOR);
		if (yych == '\t') goto yy312;
		if (yych == ' ') goto yy312;
		goto yy242;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy239;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy316:
		YYDEBUG(316, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy237;
				if (yych <= '\t') goto yy315;
				goto yy314;
			} else {
				if (yych == '\r') goto yy318;
				goto yy237;
			}
		} else {
			if (yych <= '"') {
				if (yych <= ' ') goto yy315;
				if (yych <= '!') goto yy237;
			} else {
				if (yych == ';') goto yy293;
				goto yy237;
			}
		}
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy244;
yy318:
		YYDEBUG(318, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy314;
		goto yy239;
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(319, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy321;
					if (yych <= '\n') goto yy323;
				} else {
					if (yych <= '\r') goto yy323;
					if (yych >= '!') goto yy323;
				}
			} else {
				if (yych <= '%') {
					if (yych == '$') goto yy323;
				} else {
					if (yych != '\'') goto yy323;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= '<') {
					if (yych == ';') goto yy323;
				} else {
					if (yych <= '=') goto yy323;
					if (yych >= '[') goto yy323;
				}
			} else {
				if (yych <= 'z') {
					if (yych == '^') goto yy323;
				} else {
					if (yych == '}') goto yy325;
					if (yych <= '~') goto yy323;
				}
			}
		}
yy321:
		YYDEBUG(321, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy328;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 453 "Zend/zend_ini_scanner.l"
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
#line 4791 "Zend/zend_ini_scanner.c"
yy323:
		YYDEBUG(323, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(324, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 654 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 4801 "Zend/zend_ini_scanner.c"
yy325:
		YYDEBUG(325, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(326, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 463 "Zend/zend_ini_scanner.l"
		{ /* Variable end */
	yy_pop_state(TSRMLS_C);
	return '}';
}
#line 4812 "Zend/zend_ini_scanner.c"
yy327:
		YYDEBUG(327, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy328:
		YYDEBUG(328, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy327;
		}
		goto yy322;
	}
}
#line 658 "Zend/zend_ini_scanner.l"

}
