/* Generated by re2c 0.16 */
#line 1 "Zend/zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2017 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

ZEND_API void zend_lex_tstring(zval *zv)
{
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char*)SCNG(yy_text), SCNG(yy_leng));
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size, offset = 0;
	zend_string *compiled_filename;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == (size_t)-1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_init(file_handle->filename, strlen(file_handle->filename), 0);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release(compiled_filename);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	zend_bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(Z_STR_P(filename));
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release(new_compiled_filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;

	if (Z_STRLEN_P(source_string)==0) {
		return NULL;
	}

	ZVAL_DUP(&tmp, source_string);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(source_string, filename) == SUCCESS) {
		BEGIN(ST_IN_SCRIPTING);
		op_array = zend_compile(ZEND_EVAL_CODE);
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(&tmp);

	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static int zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'r':
					*t++ = '\r';
					Z_STRLEN_P(zendlval)--;
					break;
				case 't':
					*t++ = '\t';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'f':
					*t++ = '\f';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'v':
					*t++ = '\v';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					Z_STRLEN_P(zendlval)--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						Z_STRLEN_P(zendlval)--; /* for the 'x' */

						hex_buf[0] = *(++s);
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;
						size_t byte_len = 0;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							byte_len = 1;
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							byte_len = 2;
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							byte_len = 3;
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							byte_len = 4;
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}

						Z_STRLEN_P(zendlval) -= 2; /* \u */
						Z_STRLEN_P(zendlval) -= (len - byte_len);
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								Z_STRLEN_P(zendlval)--;
							}
						}
						if (octal_buf[2] &&
						    (octal_buf[0] > '3')) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

static zend_always_inline int emit_token(int token, int token_line)
{
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, token_line, SCNG(on_event_context));
	}

	return token;
}

#define RETURN_TOKEN(token) return emit_token(token, start_line);

int lex_scan(zval *zendlval)
{

int start_line = CG(zend_lineno);

restart:
	SCNG(yy_text) = YYCURSOR;


#line 1112 "Zend/zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(1, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy5;
	YYDEBUG(3, *YYCURSOR);
	++YYCURSOR;
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1805 "Zend/zend_language_scanner.l"
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_INLINE_HTML);
}
#line 1209 "Zend/zend_language_scanner.c"
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy4;
	YYDEBUG(6, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy8;
	} else {
		if (yych <= 'P') goto yy10;
		if (yych == 'p') goto yy10;
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1796 "Zend/zend_language_scanner.l"
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
#line 1234 "Zend/zend_language_scanner.c"
yy8:
	YYDEBUG(8, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(9, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1783 "Zend/zend_language_scanner.l"
	{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
#line 1245 "Zend/zend_language_scanner.c"
yy10:
	YYDEBUG(10, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy12;
	if (yych == 'h') goto yy12;
yy11:
	YYDEBUG(11, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy7;
yy12:
	YYDEBUG(12, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy13;
	if (yych != 'p') goto yy11;
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy11;
		if (yych >= '\v') goto yy11;
	} else {
		if (yych <= '\r') goto yy16;
		if (yych != ' ') goto yy11;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	++YYCURSOR;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1789 "Zend/zend_language_scanner.l"
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_OPEN_TAG);
}
#line 1282 "Zend/zend_language_scanner.c"
yy16:
	YYDEBUG(16, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '\n') goto yy14;
	goto yy15;
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(17, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy21;
		} else {
			if (yych <= '`') goto yy22;
			if (yych == '{') goto yy24;
		}
		YYDEBUG(19, *YYCURSOR);
		++YYCURSOR;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2215 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`');
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 1380 "Zend/zend_language_scanner.c"
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy20;
			if (yych <= 'Z') goto yy25;
			if (yych <= '^') goto yy20;
			goto yy25;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy20;
				goto yy25;
			} else {
				if (yych <= '{') goto yy28;
				if (yych <= 0x7F) goto yy20;
				goto yy25;
			}
		}
yy22:
		YYDEBUG(22, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(23, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2159 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
#line 1409 "Zend/zend_language_scanner.c"
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy30;
		goto yy20;
yy25:
		YYDEBUG(25, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy25;
		}
		if (yych == '-') goto yy32;
		if (yych <= '@') goto yy27;
		if (yych <= '[') goto yy34;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1435 "Zend/zend_language_scanner.c"
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1588 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1446 "Zend/zend_language_scanner.c"
yy30:
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2146 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1459 "Zend/zend_language_scanner.c"
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy36;
yy33:
		YYDEBUG(33, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy27;
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1863 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1480 "Zend/zend_language_scanner.c"
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy33;
			if (yych <= 'Z') goto yy37;
			if (yych <= '^') goto yy33;
		} else {
			if (yych <= '`') goto yy33;
			if (yych <= 'z') goto yy37;
			if (yych <= 0x7F) goto yy33;
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1854 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1505 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(39, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy43;
		} else {
			if (yych <= '$') goto yy45;
			if (yych == '{') goto yy46;
		}
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2165 "Zend/zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"');
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 1607 "Zend/zend_language_scanner.c"
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2154 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
#line 1618 "Zend/zend_language_scanner.c"
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy42;
			if (yych <= 'Z') goto yy47;
			if (yych <= '^') goto yy42;
			goto yy47;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy42;
				goto yy47;
			} else {
				if (yych <= '{') goto yy50;
				if (yych <= 0x7F) goto yy42;
				goto yy47;
			}
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy52;
		goto yy42;
yy47:
		YYDEBUG(47, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy47;
		}
		if (yych == '-') goto yy54;
		if (yych <= '@') goto yy49;
		if (yych <= '[') goto yy56;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1662 "Zend/zend_language_scanner.c"
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(51, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1588 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1673 "Zend/zend_language_scanner.c"
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(53, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2146 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1686 "Zend/zend_language_scanner.c"
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy58;
yy55:
		YYDEBUG(55, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy49;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(57, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1863 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1707 "Zend/zend_language_scanner.c"
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy55;
			if (yych <= 'Z') goto yy59;
			if (yych <= '^') goto yy55;
		} else {
			if (yych <= '`') goto yy55;
			if (yych <= 'z') goto yy59;
			if (yych <= 0x7F) goto yy55;
		}
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(60, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1854 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1732 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(61, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(63, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(64, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2132 "Zend/zend_language_scanner.l"
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
#line 1756 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(65, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy69;
		if (yych == '{') goto yy70;
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2257 "Zend/zend_language_scanner.l"
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 1877 "Zend/zend_language_scanner.c"
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy68;
			if (yych <= 'Z') goto yy71;
			if (yych <= '^') goto yy68;
			goto yy71;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy68;
				goto yy71;
			} else {
				if (yych <= '{') goto yy74;
				if (yych <= 0x7F) goto yy68;
				goto yy71;
			}
		}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy76;
		goto yy68;
yy71:
		YYDEBUG(71, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy71;
		}
		if (yych == '-') goto yy78;
		if (yych <= '@') goto yy73;
		if (yych <= '[') goto yy80;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1921 "Zend/zend_language_scanner.c"
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1588 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1932 "Zend/zend_language_scanner.c"
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2146 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1945 "Zend/zend_language_scanner.c"
yy78:
		YYDEBUG(78, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy82;
yy79:
		YYDEBUG(79, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy73;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1863 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1966 "Zend/zend_language_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy79;
			if (yych <= 'Z') goto yy83;
			if (yych <= '^') goto yy79;
		} else {
			if (yych <= '`') goto yy79;
			if (yych <= 'z') goto yy83;
			if (yych <= 0x7F) goto yy79;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1854 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1991 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(85, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy89;
		}
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\n':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy87;
		case ' ':
		case '!':	goto yy92;
		case '"':	goto yy94;
		case '#':	goto yy96;
		case '$':	goto yy98;
		case '%':	goto yy99;
		case '&':	goto yy100;
		case '\'':	goto yy101;
		case '(':	goto yy103;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy104;
		case '*':	goto yy105;
		case '+':	goto yy106;
		case '-':	goto yy107;
		case '.':	goto yy108;
		case '/':	goto yy109;
		case '0':	goto yy110;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy112;
		case ':':	goto yy114;
		case '<':	goto yy115;
		case '=':	goto yy116;
		case '>':	goto yy117;
		case '?':	goto yy118;
		case 'A':
		case 'a':	goto yy119;
		case 'B':
		case 'b':	goto yy121;
		case 'C':
		case 'c':	goto yy122;
		case 'D':
		case 'd':	goto yy123;
		case 'E':
		case 'e':	goto yy124;
		case 'F':
		case 'f':	goto yy125;
		case 'G':
		case 'g':	goto yy126;
		case 'I':
		case 'i':	goto yy129;
		case 'L':
		case 'l':	goto yy130;
		case 'N':
		case 'n':	goto yy131;
		case 'O':
		case 'o':	goto yy132;
		case 'P':
		case 'p':	goto yy133;
		case 'R':
		case 'r':	goto yy134;
		case 'S':
		case 's':	goto yy135;
		case 'T':
		case 't':	goto yy136;
		case 'U':
		case 'u':	goto yy137;
		case 'V':
		case 'v':	goto yy138;
		case 'W':
		case 'w':	goto yy139;
		case 'X':
		case 'x':	goto yy140;
		case 'Y':
		case 'y':	goto yy141;
		case '\\':	goto yy142;
		case '^':	goto yy144;
		case '_':	goto yy145;
		case '`':	goto yy146;
		case '{':	goto yy148;
		case '|':	goto yy150;
		case '}':	goto yy151;
		default:	goto yy127;
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2388 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 2169 "Zend/zend_language_scanner.c"
yy89:
		YYDEBUG(89, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(90, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy89;
		}
		YYDEBUG(91, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1292 "Zend/zend_language_scanner.l"
		{
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_WHITESPACE);
}
#line 2186 "Zend/zend_language_scanner.c"
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy153;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1577 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(yytext[0]);
}
#line 2198 "Zend/zend_language_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2036 "Zend/zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"');
				RETURN_TOKEN(T_CONSTANT_ENCAPSED_STRING);
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
#line 2245 "Zend/zend_language_scanner.c"
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1899 "Zend/zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	RETURN_TOKEN(T_COMMENT);
}
#line 2280 "Zend/zend_language_scanner.c"
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy93;
			if (yych <= 'Z') goto yy155;
			if (yych <= '^') goto yy93;
			goto yy155;
		} else {
			if (yych <= '`') goto yy93;
			if (yych <= 'z') goto yy155;
			if (yych <= 0x7F) goto yy93;
			goto yy155;
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy158;
		goto yy93;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy160;
		if (yych == '=') goto yy162;
		goto yy93;
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1967 "Zend/zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		ZVAL_STRINGL(zendlval, str, sz);
	}
	RETURN_TOKEN(T_CONSTANT_ENCAPSED_STRING);
}
#line 2379 "Zend/zend_language_scanner.c"
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy165;
					if (yych <= 0x1F) goto yy93;
					goto yy165;
				} else {
					if (yych <= '@') goto yy93;
					if (yych == 'C') goto yy93;
					goto yy165;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy165;
					if (yych <= 'H') goto yy93;
					goto yy165;
				} else {
					if (yych == 'O') goto yy165;
					if (yych <= 'Q') goto yy93;
					goto yy165;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy165;
					if (yych <= '`') goto yy93;
					goto yy165;
				} else {
					if (yych == 'd') goto yy165;
					if (yych <= 'e') goto yy93;
					goto yy165;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy165;
					if (yych <= 'n') goto yy93;
					goto yy165;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy93;
						goto yy165;
					} else {
						if (yych == 'u') goto yy165;
						goto yy93;
					}
				}
			}
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy93;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy176;
		if (yych == '=') goto yy178;
		goto yy93;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy180;
		if (yych == '=') goto yy182;
		goto yy93;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy184;
			goto yy93;
		} else {
			if (yych <= '=') goto yy186;
			if (yych <= '>') goto yy188;
			goto yy93;
		}
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy190;
			goto yy93;
		} else {
			if (yych <= '9') goto yy191;
			if (yych == '=') goto yy194;
			goto yy93;
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy196;
			goto yy93;
		} else {
			if (yych <= '/') goto yy96;
			if (yych == '=') goto yy198;
			goto yy93;
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy112;
		}
		if (yych <= 'W') {
			if (yych <= 'A') {
				if (yych == '.') goto yy191;
			} else {
				if (yych <= 'B') goto yy200;
				if (yych == 'E') goto yy201;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'X') goto yy202;
				if (yych == 'b') goto yy200;
			} else {
				if (yych <= 'e') goto yy201;
				if (yych == 'x') goto yy202;
			}
		}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1647 "Zend/zend_language_scanner.l"
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			RETURN_TOKEN(T_LNUMBER);
		}
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				errno = 0;
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_throw_exception(zend_ce_parse_error,
					"Invalid numeric literal", 0);
				ZVAL_UNDEF(zendlval);
				RETURN_TOKEN(T_DNUMBER);
			}
			ZEND_ASSERT(!errno);
			RETURN_TOKEN(T_DNUMBER);
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			RETURN_TOKEN(T_DNUMBER);
		}
	}
	ZEND_ASSERT(!errno);
	RETURN_TOKEN(T_LNUMBER);
}
#line 2554 "Zend/zend_language_scanner.c"
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy112;
		}
		if (yych <= 'D') {
			if (yych == '.') goto yy191;
			goto yy111;
		} else {
			if (yych <= 'E') goto yy201;
			if (yych == 'e') goto yy201;
			goto yy111;
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy203;
		goto yy93;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy93;
		if (yych <= '<') goto yy205;
		if (yych <= '=') goto yy207;
		if (yych <= '>') goto yy209;
		goto yy93;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy93;
		if (yych <= '=') goto yy210;
		if (yych <= '>') goto yy212;
		goto yy93;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy93;
		if (yych <= '=') goto yy214;
		if (yych <= '>') goto yy216;
		goto yy93;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy93;
		if (yych <= '>') goto yy218;
		if (yych <= '?') goto yy220;
		goto yy93;
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy222;
				goto yy128;
			} else {
				if (yych <= 'N') goto yy223;
				if (yych <= 'Q') goto yy128;
				if (yych <= 'R') goto yy224;
				goto yy225;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy222;
				if (yych <= 'm') goto yy128;
				goto yy223;
			} else {
				if (yych <= 'q') goto yy128;
				if (yych <= 'r') goto yy224;
				if (yych <= 's') goto yy225;
				goto yy128;
			}
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1893 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 2640 "Zend/zend_language_scanner.c"
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy128;
				goto yy94;
			} else {
				if (yych == '\'') goto yy101;
				goto yy128;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy227;
				if (yych <= 'Q') goto yy128;
				goto yy228;
			} else {
				if (yych == 'r') goto yy228;
				goto yy128;
			}
		}
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy229;
				goto yy128;
			} else {
				if (yych <= 'L') goto yy230;
				if (yych <= 'N') goto yy128;
				goto yy231;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy229;
				goto yy128;
			} else {
				if (yych <= 'l') goto yy230;
				if (yych == 'o') goto yy231;
				goto yy128;
			}
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy232;
				goto yy128;
			} else {
				if (yych <= 'I') goto yy233;
				if (yych <= 'N') goto yy128;
				goto yy234;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy232;
				goto yy128;
			} else {
				if (yych <= 'i') goto yy233;
				if (yych == 'o') goto yy234;
				goto yy128;
			}
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		switch (yych) {
		case 'C':
		case 'c':	goto yy236;
		case 'L':
		case 'l':	goto yy237;
		case 'M':
		case 'm':	goto yy238;
		case 'N':
		case 'n':	goto yy239;
		case 'V':
		case 'v':	goto yy240;
		case 'X':
		case 'x':	goto yy241;
		default:	goto yy128;
		}
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy242;
				goto yy128;
			} else {
				if (yych <= 'O') goto yy243;
				if (yych <= 'T') goto yy128;
				goto yy244;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy242;
				goto yy128;
			} else {
				if (yych <= 'o') goto yy243;
				if (yych == 'u') goto yy244;
				goto yy128;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy245;
			if (yych <= 'N') goto yy128;
			goto yy246;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy128;
				goto yy245;
			} else {
				if (yych == 'o') goto yy246;
				goto yy128;
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy128:
		YYDEBUG(128, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy127;
		}
		goto yy120;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy247;
				goto yy128;
			} else {
				if (yych <= 'M') goto yy249;
				if (yych <= 'N') goto yy250;
				if (yych <= 'R') goto yy128;
				goto yy251;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy247;
				if (yych <= 'l') goto yy128;
				goto yy249;
			} else {
				if (yych <= 'n') goto yy250;
				if (yych == 's') goto yy251;
				goto yy128;
			}
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy252;
		if (yych == 'i') goto yy252;
		goto yy128;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy253;
			if (yych <= 'D') goto yy128;
			goto yy254;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy128;
				goto yy253;
			} else {
				if (yych == 'e') goto yy254;
				goto yy128;
			}
		}
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy255;
		if (yych == 'r') goto yy255;
		goto yy128;
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy257;
			if (yych <= 'T') goto yy128;
			goto yy258;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy128;
				goto yy257;
			} else {
				if (yych == 'u') goto yy258;
				goto yy128;
			}
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy259;
		if (yych == 'e') goto yy259;
		goto yy128;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy260;
			if (yych <= 'V') goto yy128;
			goto yy261;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy128;
				goto yy260;
			} else {
				if (yych == 'w') goto yy261;
				goto yy128;
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy262;
			if (yych <= 'Q') goto yy128;
			goto yy263;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy128;
				goto yy262;
			} else {
				if (yych == 'r') goto yy263;
				goto yy128;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy264;
			if (yych <= 'R') goto yy128;
			goto yy265;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy128;
				goto yy264;
			} else {
				if (yych == 's') goto yy265;
				goto yy128;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy266;
		if (yych == 'a') goto yy266;
		goto yy128;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy267;
		if (yych == 'h') goto yy267;
		goto yy128;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy268;
		if (yych == 'o') goto yy268;
		goto yy128;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy269;
		if (yych == 'i') goto yy269;
		goto yy128;
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1317 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
#line 2929 "Zend/zend_language_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy270;
		goto yy93;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy272;
		goto yy128;
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2126 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
#line 2950 "Zend/zend_language_scanner.c"
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1582 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN('{');
}
#line 2961 "Zend/zend_language_scanner.c"
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy273;
		if (yych == '|') goto yy275;
		goto yy93;
yy151:
		YYDEBUG(151, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(152, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1594 "Zend/zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_TOKEN('}');
}
#line 2981 "Zend/zend_language_scanner.c"
yy153:
		YYDEBUG(153, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy277;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1481 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
#line 2993 "Zend/zend_language_scanner.c"
yy155:
		YYDEBUG(155, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(156, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy155;
			} else {
				if (yych <= '@') goto yy157;
				if (yych <= 'Z') goto yy155;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy155;
			} else {
				if (yych <= 'z') goto yy155;
				if (yych >= 0x80) goto yy155;
			}
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 3023 "Zend/zend_language_scanner.c"
yy158:
		YYDEBUG(158, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(159, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1525 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
#line 3033 "Zend/zend_language_scanner.c"
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1553 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
#line 3043 "Zend/zend_language_scanner.c"
yy162:
		YYDEBUG(162, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(163, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1537 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
#line 3053 "Zend/zend_language_scanner.c"
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy165:
		YYDEBUG(165, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy164;
		}
		switch (yych) {
		case 'A':
		case 'a':	goto yy167;
		case 'B':
		case 'b':	goto yy168;
		case 'D':
		case 'd':	goto yy169;
		case 'F':
		case 'f':	goto yy170;
		case 'I':
		case 'i':	goto yy171;
		case 'O':
		case 'o':	goto yy172;
		case 'R':
		case 'r':	goto yy173;
		case 'S':
		case 's':	goto yy174;
		case 'U':
		case 'u':	goto yy175;
		default:	goto yy166;
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy93;
				} else {
					goto yy111;
				}
			} else {
				if (yyaccept == 2) {
					goto yy120;
				} else {
					goto yy193;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy197;
				} else {
					goto yy206;
				}
			} else {
				goto yy541;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy279;
		if (yych == 'r') goto yy279;
		goto yy166;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy280;
			if (yych <= 'N') goto yy166;
			goto yy281;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy166;
				goto yy280;
			} else {
				if (yych == 'o') goto yy281;
				goto yy166;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy282;
		if (yych == 'o') goto yy282;
		goto yy166;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy283;
		if (yych == 'l') goto yy283;
		goto yy166;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy284;
		if (yych == 'n') goto yy284;
		goto yy166;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy285;
		if (yych == 'b') goto yy285;
		goto yy166;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy286;
		if (yych == 'e') goto yy286;
		goto yy166;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy287;
		if (yych == 't') goto yy287;
		goto yy166;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy288;
		if (yych == 'n') goto yy288;
		goto yy166;
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy289;
		YYDEBUG(177, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1509 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW);
}
#line 3187 "Zend/zend_language_scanner.c"
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1505 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
#line 3197 "Zend/zend_language_scanner.c"
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1461 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INC);
}
#line 3207 "Zend/zend_language_scanner.c"
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1497 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
#line 3217 "Zend/zend_language_scanner.c"
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1465 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEC);
}
#line 3227 "Zend/zend_language_scanner.c"
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1501 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
#line 3237 "Zend/zend_language_scanner.c"
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1287 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 3248 "Zend/zend_language_scanner.c"
yy190:
		YYDEBUG(190, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy291;
		goto yy166;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy191;
		} else {
			if (yych <= 'E') goto yy201;
			if (yych == 'e') goto yy201;
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1741 "Zend/zend_language_scanner.l"
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	RETURN_TOKEN(T_DNUMBER);
}
#line 3280 "Zend/zend_language_scanner.c"
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(195, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1521 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
#line 3290 "Zend/zend_language_scanner.c"
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy293;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1928 "Zend/zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_TOKEN(T_DOC_COMMENT);
	}

	RETURN_TOKEN(T_COMMENT);
}
#line 3332 "Zend/zend_language_scanner.c"
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1517 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
#line 3342 "Zend/zend_language_scanner.c"
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy294;
		}
		goto yy166;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy297;
			goto yy166;
		} else {
			if (yych <= '-') goto yy297;
			if (yych <= '/') goto yy166;
			if (yych <= '9') goto yy298;
			goto yy166;
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy300;
		}
		goto yy166;
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1313 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
#line 3378 "Zend/zend_language_scanner.c"
yy205:
		YYDEBUG(205, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy206;
		if (yych <= '<') goto yy303;
		if (yych <= '=') goto yy305;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1569 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL);
}
#line 3393 "Zend/zend_language_scanner.c"
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy307;
		YYDEBUG(208, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1489 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
#line 3404 "Zend/zend_language_scanner.c"
yy209:
		YYDEBUG(209, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy154;
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy309;
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1477 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
#line 3419 "Zend/zend_language_scanner.c"
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1445 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
#line 3429 "Zend/zend_language_scanner.c"
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1493 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
#line 3439 "Zend/zend_language_scanner.c"
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy311;
		YYDEBUG(217, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1573 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR);
}
#line 3450 "Zend/zend_language_scanner.c"
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy313;
		if (yych == '\r') goto yy314;
yy219:
		YYDEBUG(219, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1961 "Zend/zend_language_scanner.l"
		{
	BEGIN(INITIAL);
	RETURN_TOKEN(T_CLOSE_TAG);  /* implicit ';' at php-end tag */
}
#line 3464 "Zend/zend_language_scanner.c"
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1325 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_COALESCE);
}
#line 3474 "Zend/zend_language_scanner.c"
yy222:
		YYDEBUG(222, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy315;
		if (yych == 's') goto yy315;
		goto yy128;
yy223:
		YYDEBUG(223, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy316;
		if (yych == 'd') goto yy316;
		goto yy128;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy318;
		if (yych == 'r') goto yy318;
		goto yy128;
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1227 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AS);
}
#line 3505 "Zend/zend_language_scanner.c"
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy319;
		goto yy166;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy320;
		if (yych == 'e') goto yy320;
		goto yy128;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy128;
				goto yy321;
			} else {
				if (yych <= 'R') goto yy128;
				if (yych <= 'S') goto yy322;
				goto yy323;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy321;
				goto yy128;
			} else {
				if (yych <= 's') goto yy322;
				if (yych <= 't') goto yy323;
				goto yy128;
			}
		}
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy324;
			if (yych <= 'N') goto yy128;
			goto yy325;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy128;
				goto yy324;
			} else {
				if (yych == 'o') goto yy325;
				goto yy128;
			}
		}
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy326;
		if (yych == 'n') goto yy326;
		goto yy128;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy327;
			if (yych <= 'E') goto yy128;
			goto yy328;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy128;
				goto yy327;
			} else {
				if (yych == 'f') goto yy328;
				goto yy128;
			}
		}
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy329;
		if (yych == 'e') goto yy329;
		goto yy128;
yy234:
		YYDEBUG(234, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(235, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1195 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DO);
}
#line 3595 "Zend/zend_language_scanner.c"
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy331;
		if (yych == 'h') goto yy331;
		goto yy128;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy332;
		if (yych == 's') goto yy332;
		goto yy128;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy333;
		if (yych == 'p') goto yy333;
		goto yy128;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy334;
		if (yych == 'd') goto yy334;
		goto yy128;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy335;
		if (yych == 'a') goto yy335;
		goto yy128;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy336;
			if (yych <= 'S') goto yy128;
			goto yy337;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy128;
				goto yy336;
			} else {
				if (yych == 't') goto yy337;
				goto yy128;
			}
		}
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy338;
		if (yych == 'n') goto yy338;
		goto yy128;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy339;
		if (yych == 'r') goto yy339;
		goto yy128;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy341;
		if (yych == 'n') goto yy341;
		goto yy128;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy342;
		if (yych == 'o') goto yy342;
		goto yy128;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy343;
		if (yych == 't') goto yy343;
		goto yy128;
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1171 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IF);
}
#line 3684 "Zend/zend_language_scanner.c"
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy344;
		if (yych == 'p') goto yy344;
		goto yy128;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy128;
				goto yy345;
			} else {
				if (yych <= 'R') goto yy128;
				if (yych <= 'S') goto yy346;
				goto yy347;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy345;
				goto yy128;
			} else {
				if (yych <= 's') goto yy346;
				if (yych <= 't') goto yy347;
				goto yy128;
			}
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy348;
		if (yych == 's') goto yy348;
		goto yy128;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy349;
		if (yych == 's') goto yy349;
		goto yy128;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy350;
		if (yych == 'm') goto yy350;
		goto yy128;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy351;
		if (yych == 'w') goto yy351;
		goto yy128;
yy255:
		YYDEBUG(255, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1557 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_OR);
}
#line 3749 "Zend/zend_language_scanner.c"
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy353;
			if (yych <= 'N') goto yy128;
			goto yy354;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy128;
				goto yy353;
			} else {
				if (yych == 'o') goto yy354;
				goto yy128;
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy355;
		if (yych == 'b') goto yy355;
		goto yy128;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy356;
			if (yych <= 'S') goto yy128;
			goto yy357;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy128;
				goto yy356;
			} else {
				if (yych == 't') goto yy357;
				goto yy128;
			}
		}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy358;
		if (yych == 'a') goto yy358;
		goto yy128;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy359;
		if (yych == 'i') goto yy359;
		goto yy128;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy360;
		if (yych == 'r') goto yy360;
		goto yy128;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy361;
			if (yych <= 'X') goto yy128;
			goto yy362;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy128;
				goto yy361;
			} else {
				if (yych == 'y') goto yy362;
				goto yy128;
			}
		}
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy364;
		if (yych == 's') goto yy364;
		goto yy128;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy365;
		if (yych == 'e') goto yy365;
		goto yy128;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy367;
		if (yych == 'r') goto yy367;
		goto yy128;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy369;
		if (yych == 'i') goto yy369;
		goto yy128;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy370;
		if (yych == 'r') goto yy370;
		goto yy128;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy372;
		if (yych == 'e') goto yy372;
		goto yy128;
yy270:
		YYDEBUG(270, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(271, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1545 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
#line 3867 "Zend/zend_language_scanner.c"
yy272:
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		switch (yych) {
		case 'C':
		case 'c':	goto yy373;
		case 'D':
		case 'd':	goto yy374;
		case 'F':
		case 'f':	goto yy375;
		case 'H':
		case 'h':	goto yy376;
		case 'L':
		case 'l':	goto yy377;
		case 'M':
		case 'm':	goto yy378;
		case 'N':
		case 'n':	goto yy379;
		case 'T':
		case 't':	goto yy380;
		default:	goto yy128;
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(274, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1541 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
#line 3899 "Zend/zend_language_scanner.c"
yy275:
		YYDEBUG(275, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(276, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1549 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
#line 3909 "Zend/zend_language_scanner.c"
yy277:
		YYDEBUG(277, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(278, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1473 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
#line 3919 "Zend/zend_language_scanner.c"
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy381;
		if (yych == 'r') goto yy381;
		goto yy166;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy382;
		if (yych == 'n') goto yy382;
		goto yy166;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy383;
		if (yych == 'o') goto yy383;
		goto yy166;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy384;
		if (yych == 'u') goto yy384;
		goto yy166;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy385;
		if (yych == 'o') goto yy385;
		goto yy166;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy386;
		if (yych == 't') goto yy386;
		goto yy166;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy387;
		if (yych == 'j') goto yy387;
		goto yy166;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy388;
		if (yych == 'a') goto yy388;
		goto yy166;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy389;
		if (yych == 'r') goto yy389;
		goto yy166;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy390;
		if (yych == 's') goto yy390;
		goto yy166;
yy289:
		YYDEBUG(289, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(290, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1513 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
#line 3989 "Zend/zend_language_scanner.c"
yy291:
		YYDEBUG(291, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(292, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1321 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
#line 3999 "Zend/zend_language_scanner.c"
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy166;
			if (yych <= '\n') goto yy391;
			goto yy166;
		} else {
			if (yych <= '\r') goto yy391;
			if (yych == ' ') goto yy391;
			goto yy166;
		}
yy294:
		YYDEBUG(294, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(295, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy294;
		}
		YYDEBUG(296, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1619 "Zend/zend_language_scanner.l"
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		RETURN_TOKEN(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		RETURN_TOKEN(T_DNUMBER);
	}
}
#line 4051 "Zend/zend_language_scanner.c"
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy166;
		if (yych >= ':') goto yy166;
yy298:
		YYDEBUG(298, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(299, *YYCURSOR);
		if (yych <= '/') goto yy193;
		if (yych <= '9') goto yy298;
		goto yy193;
yy300:
		YYDEBUG(300, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(301, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy300;
		}
		YYDEBUG(302, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1692 "Zend/zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		RETURN_TOKEN(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		RETURN_TOKEN(T_DNUMBER);
	}
}
#line 4105 "Zend/zend_language_scanner.c"
yy303:
		YYDEBUG(303, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(304, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy303;
				if (yych <= 0x1F) goto yy166;
				goto yy303;
			} else {
				if (yych == '"') goto yy393;
				if (yych <= '&') goto yy166;
				goto yy394;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy166;
				if (yych <= 'Z') goto yy395;
				if (yych <= '^') goto yy166;
				goto yy395;
			} else {
				if (yych <= '`') goto yy166;
				if (yych <= 'z') goto yy395;
				if (yych <= 0x7F) goto yy166;
				goto yy395;
			}
		}
yy305:
		YYDEBUG(305, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(306, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1529 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
#line 4144 "Zend/zend_language_scanner.c"
yy307:
		YYDEBUG(307, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(308, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1485 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SPACESHIP);
}
#line 4154 "Zend/zend_language_scanner.c"
yy309:
		YYDEBUG(309, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(310, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1469 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
#line 4164 "Zend/zend_language_scanner.c"
yy311:
		YYDEBUG(311, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(312, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1533 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
#line 4174 "Zend/zend_language_scanner.c"
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy219;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy313;
		goto yy219;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy397;
		if (yych == 't') goto yy397;
		goto yy128;
yy316:
		YYDEBUG(316, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(317, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1561 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_AND);
}
#line 4202 "Zend/zend_language_scanner.c"
yy318:
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy398;
		if (yych == 'a') goto yy398;
		goto yy128;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy303;
		goto yy166;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy399;
		if (yych == 'a') goto yy399;
		goto yy128;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy400;
		if (yych == 'l') goto yy400;
		goto yy128;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy401;
		if (yych == 'e') goto yy401;
		goto yy128;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy403;
		if (yych == 'c') goto yy403;
		goto yy128;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy404;
		if (yych == 's') goto yy404;
		goto yy128;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy405;
		if (yych == 'n') goto yy405;
		goto yy128;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy128;
			if (yych <= 'S') goto yy406;
			goto yy407;
		} else {
			if (yych <= 'r') goto yy128;
			if (yych <= 's') goto yy406;
			if (yych <= 't') goto yy407;
			goto yy128;
		}
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy408;
		if (yych == 'l') goto yy408;
		goto yy128;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy409;
		if (yych == 'a') goto yy409;
		goto yy128;
yy329:
		YYDEBUG(329, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(330, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1129 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 4287 "Zend/zend_language_scanner.c"
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy410;
		if (yych == 'o') goto yy410;
		goto yy128;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy412;
		if (yych == 'e') goto yy412;
		goto yy128;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy414;
		if (yych == 't') goto yy414;
		goto yy128;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		switch (yych) {
		case 'D':
		case 'd':	goto yy415;
		case 'F':
		case 'f':	goto yy416;
		case 'I':
		case 'i':	goto yy417;
		case 'S':
		case 's':	goto yy418;
		case 'W':
		case 'w':	goto yy419;
		default:	goto yy128;
		}
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy420;
		if (yych == 'l') goto yy420;
		goto yy128;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy422;
		if (yych == 't') goto yy422;
		goto yy128;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy424;
		if (yych == 'e') goto yy424;
		goto yy128;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy425;
		if (yych == 'a') goto yy425;
		goto yy128;
yy339:
		YYDEBUG(339, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy340;
				if (yych <= '9') goto yy127;
			} else {
				if (yych == 'E') goto yy426;
				if (yych <= 'Z') goto yy127;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy127;
			} else {
				if (yych <= 'e') goto yy426;
				if (yych <= 'z') goto yy127;
				if (yych >= 0x80) goto yy127;
			}
		}
yy340:
		YYDEBUG(340, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1199 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOR);
}
#line 4373 "Zend/zend_language_scanner.c"
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy427;
		if (yych == 'c') goto yy427;
		goto yy128;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy428;
		if (yych == 'b') goto yy428;
		goto yy128;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy429;
		if (yych == 'o') goto yy429;
		goto yy128;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy431;
		if (yych == 'l') goto yy431;
		goto yy128;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy432;
		if (yych == 'l') goto yy432;
		goto yy128;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy433;
		if (yych == 't') goto yy433;
		goto yy128;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy434;
		if (yych == 'e') goto yy434;
		goto yy128;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy435;
		if (yych == 'e') goto yy435;
		goto yy128;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy436;
		if (yych == 't') goto yy436;
		goto yy128;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy438;
		if (yych == 'e') goto yy438;
		goto yy128;
yy351:
		YYDEBUG(351, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(352, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1329 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NEW);
}
#line 4446 "Zend/zend_language_scanner.c"
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy439;
			if (yych <= 'U') goto yy128;
			goto yy440;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy128;
				goto yy439;
			} else {
				if (yych == 'v') goto yy440;
				goto yy128;
			}
		}
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy441;
		if (yych == 't') goto yy441;
		goto yy128;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy442;
		if (yych == 'l') goto yy442;
		goto yy128;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy443;
		if (yych == 'u') goto yy443;
		goto yy128;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy444;
		if (yych == 'u') goto yy444;
		goto yy128;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy445;
		if (yych == 't') goto yy445;
		goto yy128;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy446;
		if (yych == 't') goto yy446;
		goto yy128;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy447;
		if (yych == 'o') goto yy447;
		goto yy128;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy448;
		if (yych == 'i') goto yy448;
		goto yy128;
yy362:
		YYDEBUG(362, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(363, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1155 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRY);
}
#line 4523 "Zend/zend_language_scanner.c"
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy449;
		if (yych == 'e') goto yy449;
		goto yy128;
yy365:
		YYDEBUG(365, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(366, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1393 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_USE);
}
#line 4542 "Zend/zend_language_scanner.c"
yy367:
		YYDEBUG(367, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(368, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1337 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_VAR);
}
#line 4555 "Zend/zend_language_scanner.c"
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy450;
		if (yych == 'l') goto yy450;
		goto yy128;
yy370:
		YYDEBUG(370, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(371, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1565 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_XOR);
}
#line 4574 "Zend/zend_language_scanner.c"
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy451;
		if (yych == 'l') goto yy451;
		goto yy128;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy452;
		if (yych == 'l') goto yy452;
		goto yy128;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy453;
		if (yych == 'i') goto yy453;
		goto yy128;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy454;
			if (yych <= 'T') goto yy128;
			goto yy455;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy128;
				goto yy454;
			} else {
				if (yych == 'u') goto yy455;
				goto yy128;
			}
		}
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy456;
		if (yych == 'a') goto yy456;
		goto yy128;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy457;
		if (yych == 'i') goto yy457;
		goto yy128;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy458;
		if (yych == 'e') goto yy458;
		goto yy128;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy459;
		if (yych == 'a') goto yy459;
		goto yy128;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy460;
		if (yych == 'r') goto yy460;
		goto yy128;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy461;
		if (yych == 'a') goto yy461;
		goto yy166;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy462;
		if (yych == 'a') goto yy462;
		goto yy166;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy463;
		if (yych == 'l') goto yy463;
		goto yy166;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy464;
		if (yych == 'b') goto yy464;
		goto yy166;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy465;
		if (yych == 'a') goto yy465;
		goto yy166;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy470;
		if (yych == 'e') goto yy470;
		goto yy467;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy471;
		if (yych == 'e') goto yy471;
		goto yy166;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy472;
		if (yych == 'l') goto yy472;
		goto yy166;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy474;
		if (yych == 'i') goto yy474;
		goto yy166;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy475;
		if (yych == 'e') goto yy475;
		goto yy166;
yy391:
		YYDEBUG(391, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(392, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy197;
			if (yych <= '\n') goto yy391;
			goto yy197;
		} else {
			if (yych <= '\r') goto yy391;
			if (yych == ' ') goto yy391;
			goto yy197;
		}
yy393:
		YYDEBUG(393, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy166;
		if (yych <= '/') goto yy477;
		if (yych <= '9') goto yy166;
		goto yy477;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy166;
		if (yych <= '/') goto yy479;
		if (yych <= '9') goto yy166;
		goto yy479;
yy395:
		YYDEBUG(395, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(396, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy480;
				goto yy166;
			} else {
				if (yych <= '\r') goto yy482;
				if (yych <= '/') goto yy166;
				if (yych <= '9') goto yy395;
				goto yy166;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy395;
				if (yych <= '^') goto yy166;
				goto yy395;
			} else {
				if (yych <= '`') goto yy166;
				if (yych <= 'z') goto yy395;
				if (yych <= 0x7F) goto yy166;
				goto yy395;
			}
		}
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy483;
		if (yych == 'r') goto yy483;
		goto yy128;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy484;
		if (yych == 'y') goto yy484;
		goto yy128;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy486;
		if (yych == 'k') goto yy486;
		goto yy128;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy488;
		if (yych == 'a') goto yy488;
		goto yy128;
yy401:
		YYDEBUG(401, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(402, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1239 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CASE);
}
#line 4792 "Zend/zend_language_scanner.c"
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy489;
		if (yych == 'h') goto yy489;
		goto yy128;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy491;
		if (yych == 's') goto yy491;
		goto yy128;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy493;
		if (yych == 'e') goto yy493;
		goto yy128;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy495;
		if (yych == 't') goto yy495;
		goto yy128;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy497;
		if (yych == 'i') goto yy497;
		goto yy128;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy498;
		if (yych == 'a') goto yy498;
		goto yy128;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy499;
		if (yych == 'u') goto yy499;
		goto yy128;
yy410:
		YYDEBUG(410, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(411, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1259 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ECHO);
}
#line 4847 "Zend/zend_language_scanner.c"
yy412:
		YYDEBUG(412, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy413;
				if (yych <= '9') goto yy127;
			} else {
				if (yych == 'I') goto yy500;
				if (yych <= 'Z') goto yy127;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy127;
			} else {
				if (yych <= 'i') goto yy500;
				if (yych <= 'z') goto yy127;
				if (yych >= 0x80) goto yy127;
			}
		}
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1183 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSE);
}
#line 4875 "Zend/zend_language_scanner.c"
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy501;
		if (yych == 'y') goto yy501;
		goto yy128;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy503;
		if (yych == 'e') goto yy503;
		goto yy128;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy504;
		if (yych == 'o') goto yy504;
		goto yy128;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy505;
		if (yych == 'f') goto yy505;
		goto yy128;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy507;
		if (yych == 'w') goto yy507;
		goto yy128;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy508;
		if (yych == 'h') goto yy508;
		goto yy128;
yy420:
		YYDEBUG(420, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(421, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1369 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EVAL);
}
#line 4924 "Zend/zend_language_scanner.c"
yy422:
		YYDEBUG(422, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(423, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1125 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 4937 "Zend/zend_language_scanner.c"
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy509;
		if (yych == 'n') goto yy509;
		goto yy128;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy510;
		if (yych == 'l') goto yy510;
		goto yy128;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy512;
		if (yych == 'a') goto yy512;
		goto yy128;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy513;
		if (yych == 't') goto yy513;
		goto yy128;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy514;
		if (yych == 'a') goto yy514;
		goto yy128;
yy429:
		YYDEBUG(429, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(430, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1255 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GOTO);
}
#line 4980 "Zend/zend_language_scanner.c"
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy515;
		if (yych == 'e') goto yy515;
		goto yy128;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy516;
		if (yych == 'u') goto yy516;
		goto yy128;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy517;
			if (yych <= 'D') goto yy128;
			goto yy518;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy128;
				goto yy517;
			} else {
				if (yych == 'e') goto yy518;
				goto yy128;
			}
		}
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy519;
		if (yych == 'r') goto yy519;
		goto yy128;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy520;
		if (yych == 't') goto yy520;
		goto yy128;
yy436:
		YYDEBUG(436, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(437, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1449 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LIST);
}
#line 5033 "Zend/zend_language_scanner.c"
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy522;
		if (yych == 's') goto yy522;
		goto yy128;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy523;
		if (yych == 't') goto yy523;
		goto yy128;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy525;
		if (yych == 'a') goto yy525;
		goto yy128;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy526;
		if (yych == 'e') goto yy526;
		goto yy128;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy527;
		if (yych == 'i') goto yy527;
		goto yy128;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy528;
		if (yych == 'i') goto yy528;
		goto yy128;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy529;
		if (yych == 'r') goto yy529;
		goto yy128;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy530;
		if (yych == 'i') goto yy530;
		goto yy128;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy531;
		if (yych == 'c') goto yy531;
		goto yy128;
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy532;
		if (yych == 'w') goto yy532;
		goto yy128;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy534;
		if (yych == 't') goto yy534;
		goto yy128;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy536;
		if (yych == 't') goto yy536;
		goto yy128;
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy538;
		if (yych == 'e') goto yy538;
		goto yy128;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy540;
		if (yych == 'd') goto yy540;
		goto yy128;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy542;
		if (yych == 'a') goto yy542;
		goto yy128;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy543;
		if (yych == 'r') goto yy543;
		goto yy128;
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy544;
		if (yych == 'l') goto yy544;
		goto yy128;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy545;
		if (yych == 'n') goto yy545;
		goto yy128;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy546;
		if (yych == 'l') goto yy546;
		goto yy128;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy547;
		if (yych == 'n') goto yy547;
		goto yy128;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy548;
		if (yych == 't') goto yy548;
		goto yy128;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy549;
		if (yych == 'm') goto yy549;
		goto yy128;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy550;
		if (yych == 'a') goto yy550;
		goto yy128;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy551;
		if (yych == 'y') goto yy551;
		goto yy166;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy553;
		if (yych == 'r') goto yy553;
		goto yy166;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy558;
		if (yych == 'e') goto yy558;
		goto yy555;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy559;
		if (yych == 'l') goto yy559;
		goto yy166;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy472;
		if (yych == 't') goto yy472;
		goto yy166;
yy466:
		YYDEBUG(466, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy467:
		YYDEBUG(467, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy466;
			goto yy166;
		} else {
			if (yych <= ' ') goto yy466;
			if (yych != ')') goto yy166;
		}
		YYDEBUG(468, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(469, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1341 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INT_CAST);
}
#line 5224 "Zend/zend_language_scanner.c"
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy560;
		if (yych == 'g') goto yy560;
		goto yy166;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy561;
		if (yych == 'c') goto yy561;
		goto yy166;
yy472:
		YYDEBUG(472, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(473, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy472;
			goto yy166;
		} else {
			if (yych <= ' ') goto yy472;
			if (yych == ')') goto yy562;
			goto yy166;
		}
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy564;
		if (yych == 'n') goto yy564;
		goto yy166;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy565;
		if (yych == 't') goto yy565;
		goto yy166;
yy476:
		YYDEBUG(476, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy477:
		YYDEBUG(477, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy567;
				goto yy166;
			} else {
				if (yych <= '9') goto yy476;
				if (yych <= '@') goto yy166;
				goto yy476;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy476;
				goto yy166;
			} else {
				if (yych <= 'z') goto yy476;
				if (yych <= 0x7F) goto yy166;
				goto yy476;
			}
		}
yy478:
		YYDEBUG(478, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy479:
		YYDEBUG(479, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy567;
				goto yy166;
			} else {
				if (yych <= '9') goto yy478;
				if (yych <= '@') goto yy166;
				goto yy478;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy478;
				goto yy166;
			} else {
				if (yych <= 'z') goto yy478;
				if (yych <= 0x7F) goto yy166;
				goto yy478;
			}
		}
yy480:
		YYDEBUG(480, *YYCURSOR);
		++YYCURSOR;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2078 "Zend/zend_language_scanner.l"
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	RETURN_TOKEN(T_START_HEREDOC);
}
#line 5368 "Zend/zend_language_scanner.c"
yy482:
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy480;
		goto yy481;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy568;
		if (yych == 'a') goto yy568;
		goto yy128;
yy484:
		YYDEBUG(484, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(485, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1453 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY);
}
#line 5392 "Zend/zend_language_scanner.c"
yy486:
		YYDEBUG(486, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(487, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1247 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BREAK);
}
#line 5405 "Zend/zend_language_scanner.c"
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy569;
		if (yych == 'b') goto yy569;
		goto yy128;
yy489:
		YYDEBUG(489, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(490, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1159 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CATCH);
}
#line 5424 "Zend/zend_language_scanner.c"
yy491:
		YYDEBUG(491, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(492, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1267 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS);
}
#line 5437 "Zend/zend_language_scanner.c"
yy493:
		YYDEBUG(493, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(494, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1333 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLONE);
}
#line 5450 "Zend/zend_language_scanner.c"
yy495:
		YYDEBUG(495, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(496, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1137 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONST);
}
#line 5463 "Zend/zend_language_scanner.c"
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy570;
		if (yych == 'n') goto yy570;
		goto yy128;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy571;
		if (yych == 'r') goto yy571;
		goto yy128;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy572;
		if (yych == 'l') goto yy572;
		goto yy128;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy573;
		if (yych == 'f') goto yy573;
		goto yy128;
yy501:
		YYDEBUG(501, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(502, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1409 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EMPTY);
}
#line 5500 "Zend/zend_language_scanner.c"
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy575;
		if (yych == 'c') goto yy575;
		goto yy128;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy576;
		if (yych == 'r') goto yy576;
		goto yy128;
yy505:
		YYDEBUG(505, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(506, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1179 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDIF);
}
#line 5525 "Zend/zend_language_scanner.c"
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy578;
		if (yych == 'i') goto yy578;
		goto yy128;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy579;
		if (yych == 'i') goto yy579;
		goto yy128;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy580;
		if (yych == 'd') goto yy580;
		goto yy128;
yy510:
		YYDEBUG(510, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy511;
				if (yych <= '9') goto yy127;
			} else {
				if (yych == 'L') goto yy581;
				if (yych <= 'Z') goto yy127;
			}
		} else {
			if (yych <= 'k') {
				if (yych != '`') goto yy127;
			} else {
				if (yych <= 'l') goto yy581;
				if (yych <= 'z') goto yy127;
				if (yych >= 0x80) goto yy127;
			}
		}
yy511:
		YYDEBUG(511, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1425 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINAL);
}
#line 5571 "Zend/zend_language_scanner.c"
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy582;
		if (yych == 'c') goto yy582;
		goto yy128;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy583;
		if (yych == 'i') goto yy583;
		goto yy128;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy584;
		if (yych == 'l') goto yy584;
		goto yy128;
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy586;
		if (yych == 'm') goto yy586;
		goto yy128;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy587;
		if (yych == 'd') goto yy587;
		goto yy128;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy588;
		if (yych == 'n') goto yy588;
		goto yy128;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy589;
		if (yych == 'a') goto yy589;
		goto yy128;
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy590;
		if (yych == 'f') goto yy590;
		goto yy128;
yy520:
		YYDEBUG(520, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(521, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1405 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ISSET);
}
#line 5632 "Zend/zend_language_scanner.c"
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy591;
		if (yych == 'p') goto yy591;
		goto yy128;
yy523:
		YYDEBUG(523, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(524, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1263 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRINT);
}
#line 5651 "Zend/zend_language_scanner.c"
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy592;
		if (yych == 't') goto yy592;
		goto yy128;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy593;
		if (yych == 'c') goto yy593;
		goto yy128;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy594;
		if (yych == 'c') goto yy594;
		goto yy128;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy596;
		if (yych == 'r') goto yy596;
		goto yy128;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy597;
		if (yych == 'n') goto yy597;
		goto yy128;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy599;
		if (yych == 'c') goto yy599;
		goto yy128;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy601;
		if (yych == 'h') goto yy601;
		goto yy128;
yy532:
		YYDEBUG(532, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(533, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1167 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_THROW);
}
#line 5706 "Zend/zend_language_scanner.c"
yy534:
		YYDEBUG(534, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(535, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1275 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT);
}
#line 5719 "Zend/zend_language_scanner.c"
yy536:
		YYDEBUG(536, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(537, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1441 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET);
}
#line 5732 "Zend/zend_language_scanner.c"
yy538:
		YYDEBUG(538, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(539, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1187 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_WHILE);
}
#line 5745 "Zend/zend_language_scanner.c"
yy540:
		YYDEBUG(540, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy127;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy541;
			if (yych <= '\n') goto yy603;
		} else {
			if (yych <= '\r') goto yy603;
			if (yych == ' ') goto yy603;
		}
yy541:
		YYDEBUG(541, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1151 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_YIELD);
}
#line 5767 "Zend/zend_language_scanner.c"
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy605;
		if (yych == 's') goto yy605;
		goto yy128;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy606;
		goto yy128;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy607;
		if (yych == 'e') goto yy607;
		goto yy128;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy608;
		if (yych == 'c') goto yy608;
		goto yy128;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy609;
		if (yych == 't') goto yy609;
		goto yy128;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy610;
		if (yych == 'e') goto yy610;
		goto yy128;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy611;
		if (yych == 'h') goto yy611;
		goto yy128;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy612;
		if (yych == 'e') goto yy612;
		goto yy128;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy613;
		if (yych == 'i') goto yy613;
		goto yy128;
yy551:
		YYDEBUG(551, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(552, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy551;
			goto yy166;
		} else {
			if (yych <= ' ') goto yy551;
			if (yych == ')') goto yy614;
			goto yy166;
		}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy616;
		if (yych == 'y') goto yy616;
		goto yy166;
yy554:
		YYDEBUG(554, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy555:
		YYDEBUG(555, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy554;
			goto yy166;
		} else {
			if (yych <= ' ') goto yy554;
			if (yych != ')') goto yy166;
		}
		YYDEBUG(556, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(557, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1361 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
#line 5863 "Zend/zend_language_scanner.c"
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy618;
		if (yych == 'a') goto yy618;
		goto yy166;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy472;
		if (yych == 'e') goto yy472;
		goto yy166;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy619;
		if (yych == 'e') goto yy619;
		goto yy166;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy620;
		if (yych == 't') goto yy620;
		goto yy166;
yy562:
		YYDEBUG(562, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(563, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1345 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
#line 5897 "Zend/zend_language_scanner.c"
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy616;
		if (yych == 'g') goto yy616;
		goto yy166;
yy565:
		YYDEBUG(565, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(566, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy166;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych == ')') goto yy622;
			goto yy166;
		}
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy480;
		if (yych == '\r') goto yy482;
		goto yy166;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy624;
		if (yych == 'c') goto yy624;
		goto yy128;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy625;
		if (yych == 'l') goto yy625;
		goto yy128;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy626;
		if (yych == 'u') goto yy626;
		goto yy128;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy627;
		if (yych == 'e') goto yy627;
		goto yy128;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy629;
		if (yych == 't') goto yy629;
		goto yy128;
yy573:
		YYDEBUG(573, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(574, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1175 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSEIF);
}
#line 5966 "Zend/zend_language_scanner.c"
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy631;
		if (yych == 'l') goto yy631;
		goto yy128;
yy576:
		YYDEBUG(576, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy577;
				if (yych <= '9') goto yy127;
			} else {
				if (yych == 'E') goto yy632;
				if (yych <= 'Z') goto yy127;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy127;
			} else {
				if (yych <= 'e') goto yy632;
				if (yych <= 'z') goto yy127;
				if (yych >= 0x80) goto yy127;
			}
		}
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1203 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOR);
}
#line 6000 "Zend/zend_language_scanner.c"
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy633;
		if (yych == 't') goto yy633;
		goto yy128;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy634;
		if (yych == 'l') goto yy634;
		goto yy128;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy635;
		if (yych == 's') goto yy635;
		goto yy128;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy637;
		if (yych == 'y') goto yy637;
		goto yy128;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy639;
		if (yych == 'h') goto yy639;
		goto yy128;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy641;
		if (yych == 'o') goto yy641;
		goto yy128;
yy584:
		YYDEBUG(584, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1401 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GLOBAL);
}
#line 6049 "Zend/zend_language_scanner.c"
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy642;
		if (yych == 'e') goto yy642;
		goto yy128;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy643;
		if (yych == 'e') goto yy643;
		goto yy128;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy645;
		if (yych == 'c') goto yy645;
		goto yy128;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy646;
		if (yych == 'd') goto yy646;
		goto yy128;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy647;
		if (yych == 'a') goto yy647;
		goto yy128;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy648;
		if (yych == 'a') goto yy648;
		goto yy128;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy649;
		if (yych == 'e') goto yy649;
		goto yy128;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy651;
		if (yych == 't') goto yy651;
		goto yy128;
yy594:
		YYDEBUG(594, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(595, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1437 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PUBLIC);
}
#line 6110 "Zend/zend_language_scanner.c"
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy652;
		if (yych == 'e') goto yy652;
		goto yy128;
yy597:
		YYDEBUG(597, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1141 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_RETURN);
}
#line 6129 "Zend/zend_language_scanner.c"
yy599:
		YYDEBUG(599, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(600, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1417 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STATIC);
}
#line 6142 "Zend/zend_language_scanner.c"
yy601:
		YYDEBUG(601, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(602, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1231 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SWITCH);
}
#line 6155 "Zend/zend_language_scanner.c"
yy603:
		YYDEBUG(603, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(604, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy166;
				goto yy603;
			} else {
				if (yych == '\r') goto yy603;
				goto yy166;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy603;
				if (yych <= 'E') goto yy166;
				goto yy654;
			} else {
				if (yych == 'f') goto yy654;
				goto yy166;
			}
		}
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy655;
		if (yych == 's') goto yy655;
		goto yy128;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy656;
		goto yy128;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy658;
		goto yy128;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy659;
		if (yych == 't') goto yy659;
		goto yy128;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy660;
		goto yy128;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy661;
		goto yy128;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy662;
		if (yych == 'o') goto yy662;
		goto yy128;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy663;
		if (yych == 's') goto yy663;
		goto yy128;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy664;
		if (yych == 't') goto yy664;
		goto yy128;
yy614:
		YYDEBUG(614, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(615, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1353 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
#line 6239 "Zend/zend_language_scanner.c"
yy616:
		YYDEBUG(616, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(617, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy616;
			goto yy166;
		} else {
			if (yych <= ' ') goto yy616;
			if (yych == ')') goto yy665;
			goto yy166;
		}
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy554;
		if (yych == 'n') goto yy554;
		goto yy166;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy466;
		if (yych == 'r') goto yy466;
		goto yy166;
yy620:
		YYDEBUG(620, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(621, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy620;
			goto yy166;
		} else {
			if (yych <= ' ') goto yy620;
			if (yych == ')') goto yy667;
			goto yy166;
		}
yy622:
		YYDEBUG(622, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(623, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1365 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
#line 6289 "Zend/zend_language_scanner.c"
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy669;
		if (yych == 't') goto yy669;
		goto yy128;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy671;
		if (yych == 'e') goto yy671;
		goto yy128;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy673;
		if (yych == 'e') goto yy673;
		goto yy128;
yy627:
		YYDEBUG(627, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(628, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1215 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DECLARE);
}
#line 6320 "Zend/zend_language_scanner.c"
yy629:
		YYDEBUG(629, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(630, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1243 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEFAULT);
}
#line 6333 "Zend/zend_language_scanner.c"
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy675;
		if (yych == 'a') goto yy675;
		goto yy128;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy676;
		if (yych == 'a') goto yy676;
		goto yy128;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy677;
		if (yych == 'c') goto yy677;
		goto yy128;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy678;
		if (yych == 'e') goto yy678;
		goto yy128;
yy635:
		YYDEBUG(635, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1279 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXTENDS);
}
#line 6370 "Zend/zend_language_scanner.c"
yy637:
		YYDEBUG(637, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(638, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1163 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINALLY);
}
#line 6383 "Zend/zend_language_scanner.c"
yy639:
		YYDEBUG(639, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(640, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1207 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOREACH);
}
#line 6396 "Zend/zend_language_scanner.c"
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy680;
		if (yych == 'n') goto yy680;
		goto yy128;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy682;
		if (yych == 'n') goto yy682;
		goto yy128;
yy643:
		YYDEBUG(643, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy127;
			} else {
				if (yych <= '@') goto yy644;
				if (yych <= 'Z') goto yy127;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy683;
			} else {
				if (yych <= 'z') goto yy127;
				if (yych >= 0x80) goto yy127;
			}
		}
yy644:
		YYDEBUG(644, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1373 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE);
}
#line 6434 "Zend/zend_language_scanner.c"
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy684;
		if (yych == 'e') goto yy684;
		goto yy128;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy685;
		if (yych == 'o') goto yy685;
		goto yy128;
yy647:
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy686;
		if (yych == 'c') goto yy686;
		goto yy128;
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy687;
		if (yych == 'c') goto yy687;
		goto yy128;
yy649:
		YYDEBUG(649, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(650, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1429 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRIVATE);
}
#line 6471 "Zend/zend_language_scanner.c"
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy688;
		if (yych == 'e') goto yy688;
		goto yy128;
yy652:
		YYDEBUG(652, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy127;
			} else {
				if (yych <= '@') goto yy653;
				if (yych <= 'Z') goto yy127;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy689;
			} else {
				if (yych <= 'z') goto yy127;
				if (yych >= 0x80) goto yy127;
			}
		}
yy653:
		YYDEBUG(653, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1381 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE);
}
#line 6503 "Zend/zend_language_scanner.c"
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy690;
		if (yych == 'r') goto yy690;
		goto yy166;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy691;
		goto yy128;
yy656:
		YYDEBUG(656, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(657, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1774 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIR);
}
#line 6527 "Zend/zend_language_scanner.c"
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy692;
		goto yy128;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy694;
		if (yych == 'i') goto yy694;
		goto yy128;
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy695;
		if (yych == 'c') goto yy695;
		goto yy128;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy696;
		goto yy128;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy698;
		if (yych == 'd') goto yy698;
		goto yy128;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy699;
		if (yych == 'p') goto yy699;
		goto yy128;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy700;
		goto yy128;
yy665:
		YYDEBUG(665, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(666, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1349 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STRING_CAST);
}
#line 6576 "Zend/zend_language_scanner.c"
yy667:
		YYDEBUG(667, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(668, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1357 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
#line 6586 "Zend/zend_language_scanner.c"
yy669:
		YYDEBUG(669, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(670, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1421 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ABSTRACT);
}
#line 6599 "Zend/zend_language_scanner.c"
yy671:
		YYDEBUG(671, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(672, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1457 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CALLABLE);
}
#line 6612 "Zend/zend_language_scanner.c"
yy673:
		YYDEBUG(673, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(674, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1251 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONTINUE);
}
#line 6625 "Zend/zend_language_scanner.c"
yy675:
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy701;
		if (yych == 'r') goto yy701;
		goto yy128;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy702;
		if (yych == 'c') goto yy702;
		goto yy128;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy703;
		if (yych == 'h') goto yy703;
		goto yy128;
yy678:
		YYDEBUG(678, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(679, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1191 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDWHILE);
}
#line 6656 "Zend/zend_language_scanner.c"
yy680:
		YYDEBUG(680, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(681, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1133 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNCTION);
}
#line 6669 "Zend/zend_language_scanner.c"
yy682:
		YYDEBUG(682, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy705;
		if (yych == 't') goto yy705;
		goto yy128;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy706;
		if (yych == 'o') goto yy706;
		goto yy128;
yy684:
		YYDEBUG(684, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy707;
		if (yych == 'o') goto yy707;
		goto yy128;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy708;
		if (yych == 'f') goto yy708;
		goto yy128;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy710;
		if (yych == 'e') goto yy710;
		goto yy128;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy712;
		if (yych == 'e') goto yy712;
		goto yy128;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy714;
		if (yych == 'd') goto yy714;
		goto yy128;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy716;
		if (yych == 'o') goto yy716;
		goto yy128;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy717;
		if (yych == 'o') goto yy717;
		goto yy166;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy718;
		goto yy128;
yy692:
		YYDEBUG(692, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(693, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1770 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FILE);
}
#line 6741 "Zend/zend_language_scanner.c"
yy694:
		YYDEBUG(694, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy720;
		if (yych == 'o') goto yy720;
		goto yy128;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy721;
		if (yych == 'o') goto yy721;
		goto yy128;
yy696:
		YYDEBUG(696, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(697, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1766 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LINE);
}
#line 6766 "Zend/zend_language_scanner.c"
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy722;
		goto yy128;
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy723;
		if (yych == 'a') goto yy723;
		goto yy128;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy724;
		goto yy128;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy726;
		if (yych == 'e') goto yy726;
		goto yy128;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy728;
		if (yych == 'h') goto yy728;
		goto yy128;
yy703:
		YYDEBUG(703, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(704, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1235 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDSWITCH);
}
#line 6807 "Zend/zend_language_scanner.c"
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy730;
		if (yych == 's') goto yy730;
		goto yy128;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy732;
		if (yych == 'n') goto yy732;
		goto yy128;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy733;
		if (yych == 'f') goto yy733;
		goto yy128;
yy708:
		YYDEBUG(708, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(709, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1397 "Zend/zend_language_scanner.l"
		{
    RETURN_TOKEN(T_INSTEADOF);
}
#line 6838 "Zend/zend_language_scanner.c"
yy710:
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1271 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INTERFACE);
}
#line 6851 "Zend/zend_language_scanner.c"
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1389 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NAMESPACE);
}
#line 6864 "Zend/zend_language_scanner.c"
yy714:
		YYDEBUG(714, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1433 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PROTECTED);
}
#line 6877 "Zend/zend_language_scanner.c"
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy735;
		if (yych == 'n') goto yy735;
		goto yy128;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy736;
		if (yych == 'm') goto yy736;
		goto yy166;
yy718:
		YYDEBUG(718, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(719, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1750 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS_C);
}
#line 6902 "Zend/zend_language_scanner.c"
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy737;
		if (yych == 'n') goto yy737;
		goto yy128;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy738;
		if (yych == 'm') goto yy738;
		goto yy128;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy739;
		goto yy128;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy741;
		if (yych == 'c') goto yy741;
		goto yy128;
yy724:
		YYDEBUG(724, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(725, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1754 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT_C);
}
#line 6938 "Zend/zend_language_scanner.c"
yy726:
		YYDEBUG(726, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(727, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1219 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDDECLARE);
}
#line 6951 "Zend/zend_language_scanner.c"
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1211 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOREACH);
}
#line 6964 "Zend/zend_language_scanner.c"
yy730:
		YYDEBUG(730, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(731, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1283 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IMPLEMENTS);
}
#line 6977 "Zend/zend_language_scanner.c"
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy742;
		if (yych == 'c') goto yy742;
		goto yy128;
yy733:
		YYDEBUG(733, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(734, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1223 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INSTANCEOF);
}
#line 6996 "Zend/zend_language_scanner.c"
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy743;
		if (yych == 'c') goto yy743;
		goto yy128;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy744;
				goto yy166;
			} else {
				if (yych <= '@') goto yy744;
				if (yych <= 'Z') goto yy166;
				goto yy744;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy166;
				goto yy744;
			} else {
				if (yych <= 'z') goto yy166;
				if (yych <= 0x7F) goto yy744;
				goto yy166;
			}
		}
yy737:
		YYDEBUG(737, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy746;
		goto yy128;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy747;
		if (yych == 'p') goto yy747;
		goto yy128;
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1762 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_METHOD_C);
}
#line 7048 "Zend/zend_language_scanner.c"
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy748;
		if (yych == 'e') goto yy748;
		goto yy128;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy749;
		if (yych == 'e') goto yy749;
		goto yy128;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy751;
		if (yych == 'e') goto yy751;
		goto yy128;
yy744:
		YYDEBUG(744, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(745, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1145 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_YIELD_FROM);
}
#line 7078 "Zend/zend_language_scanner.c"
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy753;
		goto yy128;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy755;
		if (yych == 'i') goto yy755;
		goto yy128;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy756;
		goto yy128;
yy749:
		YYDEBUG(749, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(750, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1377 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE_ONCE);
}
#line 7107 "Zend/zend_language_scanner.c"
yy751:
		YYDEBUG(751, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(752, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1385 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE_ONCE);
}
#line 7120 "Zend/zend_language_scanner.c"
yy753:
		YYDEBUG(753, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1758 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNC_C);
}
#line 7133 "Zend/zend_language_scanner.c"
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy757;
		if (yych == 'l') goto yy757;
		goto yy128;
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy758;
		goto yy128;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy760;
		if (yych == 'e') goto yy760;
		goto yy128;
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1778 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_C);
}
#line 7163 "Zend/zend_language_scanner.c"
yy760:
		YYDEBUG(760, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy761;
		if (yych != 'r') goto yy128;
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 16) {
			goto yy127;
		}
		YYDEBUG(762, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1413 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_HALT_COMPILER);
}
#line 7181 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(763, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy767;
		}
		if (yych <= '^') {
			if (yych <= '-') {
				if (yych >= '-') goto yy770;
			} else {
				if (yych <= '@') goto yy765;
				if (yych <= 'Z') goto yy771;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy771;
			} else {
				if (yych <= 'z') goto yy771;
				if (yych >= 0x80) goto yy771;
			}
		}
yy765:
		YYDEBUG(765, *YYCURSOR);
		++YYCURSOR;
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1307 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
#line 7253 "Zend/zend_language_scanner.c"
yy767:
		YYDEBUG(767, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(768, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy767;
		}
		YYDEBUG(769, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1292 "Zend/zend_language_scanner.l"
		{
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_WHITESPACE);
}
#line 7270 "Zend/zend_language_scanner.c"
yy770:
		YYDEBUG(770, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy774;
		goto yy766;
yy771:
		YYDEBUG(771, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(772, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy771;
		}
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1301 "Zend/zend_language_scanner.l"
		{
	yy_pop_state();
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 7293 "Zend/zend_language_scanner.c"
yy774:
		YYDEBUG(774, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(775, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1297 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 7303 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(776, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy778;
			if (yych <= 'Z') goto yy780;
			if (yych >= '_') goto yy780;
		} else {
			if (yych <= '`') goto yy778;
			if (yych <= 'z') goto yy780;
			if (yych >= 0x80) goto yy780;
		}
yy778:
		YYDEBUG(778, *YYCURSOR);
		++YYCURSOR;
yy779:
		YYDEBUG(779, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1612 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
#line 7367 "Zend/zend_language_scanner.c"
yy780:
		YYDEBUG(780, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy779;
				if (yych <= '9') goto yy782;
				goto yy779;
			} else {
				if (yych <= '[') goto yy782;
				if (yych <= '^') goto yy779;
				goto yy782;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy779;
				if (yych <= 'z') goto yy782;
				goto yy779;
			} else {
				if (yych <= '}') goto yy782;
				if (yych <= 0x7F) goto yy779;
				goto yy782;
			}
		}
yy781:
		YYDEBUG(781, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy782:
		YYDEBUG(782, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy781;
		}
		if (yych <= '@') goto yy783;
		if (yych <= '[') goto yy784;
		if (yych == '}') goto yy784;
yy783:
		YYDEBUG(783, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy779;
yy784:
		YYDEBUG(784, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(785, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1603 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_STRING_VARNAME);
}
#line 7422 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(786, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(788, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(789, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2331 "Zend/zend_language_scanner.l"
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 7489 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,   0, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(790, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy792;
					if (yych <= '\n') goto yy794;
				} else {
					if (yych <= '\r') goto yy794;
					if (yych >= ' ') goto yy794;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy796;
					if (yych <= '#') goto yy794;
					goto yy798;
				} else {
					if (yych == '\'') goto yy794;
					if (yych <= '/') goto yy796;
					goto yy799;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy801;
					if (yych <= '@') goto yy796;
					goto yy803;
				} else {
					if (yych <= '[') goto yy796;
					if (yych <= '\\') goto yy794;
					goto yy806;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy803;
					goto yy796;
				} else {
					if (yych <= 'z') goto yy803;
					if (yych <= '~') goto yy796;
					if (yych >= 0x80) goto yy803;
				}
			}
		}
yy792:
		YYDEBUG(792, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(793, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2388 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 7586 "Zend/zend_language_scanner.c"
yy794:
		YYDEBUG(794, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(795, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1885 "Zend/zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 7600 "Zend/zend_language_scanner.c"
yy796:
		YYDEBUG(796, *YYCURSOR);
		++YYCURSOR;
yy797:
		YYDEBUG(797, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1880 "Zend/zend_language_scanner.l"
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
#line 7612 "Zend/zend_language_scanner.c"
yy798:
		YYDEBUG(798, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy797;
			if (yych <= 'Z') goto yy808;
			if (yych <= '^') goto yy797;
			goto yy808;
		} else {
			if (yych <= '`') goto yy797;
			if (yych <= 'z') goto yy808;
			if (yych <= 0x7F) goto yy797;
			goto yy808;
		}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '9') {
				if (yych >= '0') goto yy811;
			} else {
				if (yych == 'B') goto yy814;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= 'X') goto yy816;
				if (yych >= 'b') goto yy814;
			} else {
				if (yych == 'x') goto yy816;
			}
		}
yy800:
		YYDEBUG(800, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1720 "Zend/zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN(T_NUM_STRING);
}
#line 7663 "Zend/zend_language_scanner.c"
yy801:
		YYDEBUG(801, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(802, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy801;
		}
		goto yy800;
yy803:
		YYDEBUG(803, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(804, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy803;
		}
		YYDEBUG(805, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1893 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 7690 "Zend/zend_language_scanner.c"
yy806:
		YYDEBUG(806, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(807, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1875 "Zend/zend_language_scanner.l"
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
#line 7701 "Zend/zend_language_scanner.c"
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(809, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy808;
			} else {
				if (yych <= '@') goto yy810;
				if (yych <= 'Z') goto yy808;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy808;
			} else {
				if (yych <= 'z') goto yy808;
				if (yych >= 0x80) goto yy808;
			}
		}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 7731 "Zend/zend_language_scanner.c"
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(812, *YYCURSOR);
		if (yych <= '/') goto yy813;
		if (yych <= '9') goto yy811;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1736 "Zend/zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	ZVAL_STRINGL(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_NUM_STRING);
}
#line 7748 "Zend/zend_language_scanner.c"
yy814:
		YYDEBUG(814, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy817;
		}
yy815:
		YYDEBUG(815, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy800;
yy816:
		YYDEBUG(816, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy819;
		}
		goto yy815;
yy817:
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(818, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy817;
		}
		goto yy813;
yy819:
		YYDEBUG(819, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(820, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy819;
		}
		goto yy813;
	}
}
#line 2397 "Zend/zend_language_scanner.l"

}
