/* Generated by re2c 0.15.3 on Tue Jul  4 21:15:17 2017 */
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Derick Rethans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND   1
#define TIMELIB_MINUTE   2
#define TIMELIB_HOUR     3
#define TIMELIB_DAY      4
#define TIMELIB_MONTH    5
#define TIMELIB_YEAR     6
#define TIMELIB_WEEKDAY  7
#define TIMELIB_SPECIAL  8
#define TIMELIB_MICROSEC 9

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.f += (((double) amount * (double) relunit->multiplier) / 1000000); break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 60) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy1521;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych >= 'a') goto yy170;
		} else {
			if (yych <= 'e') goto yy1530;
			if (yych <= 'z') goto yy170;
		}
	}
yy3:
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy1521;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy1521;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy5:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1492;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1493;
				if (yych <= 'N') goto yy165;
				goto yy1491;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1508;
				goto yy170;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1509;
				goto yy170;
			} else {
				if (yych <= 'o') goto yy1507;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy6:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1492;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1493;
				if (yych <= 'N') goto yy165;
				goto yy1491;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1492;
				goto yy165;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1493;
				goto yy165;
			} else {
				if (yych <= 'o') goto yy1491;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy7:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy1461;
		} else {
			if (yych == 'I') goto yy1462;
			if (yych <= 'N') goto yy165;
			goto yy1463;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1476;
			goto yy170;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1477;
				goto yy170;
			} else {
				if (yych <= 'o') goto yy1478;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy8:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy1461;
		} else {
			if (yych == 'I') goto yy1462;
			if (yych <= 'N') goto yy165;
			goto yy1463;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1461;
			goto yy165;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1462;
				goto yy165;
			} else {
				if (yych <= 'o') goto yy1463;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy9:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy164;
	case '0':
	case '1':	goto yy1391;
	case '2':	goto yy1392;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1393;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy165;
	case 'E':	goto yy1386;
	case 'H':	goto yy1387;
	case 'O':	goto yy1388;
	case 'U':	goto yy1389;
	case 'W':	goto yy1390;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy170;
	case 'e':	goto yy1429;
	case 'h':	goto yy1430;
	case 'o':	goto yy1431;
	case 'u':	goto yy1432;
	case 'w':	goto yy1433;
	default:	goto yy3;
	}
yy10:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy164;
	case '0':
	case '1':	goto yy1391;
	case '2':	goto yy1392;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1393;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy165;
	case 'E':
	case 'e':	goto yy1386;
	case 'H':
	case 'h':	goto yy1387;
	case 'O':
	case 'o':	goto yy1388;
	case 'U':
	case 'u':	goto yy1389;
	case 'W':
	case 'w':	goto yy1390;
	default:	goto yy3;
	}
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1374;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1375;
yy12:
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy165;
				goto yy1310;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1311;
				goto yy165;
			} else {
				if (yych <= 'O') goto yy1312;
				if (yych <= 'Q') goto yy165;
				goto yy1313;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy165;
				if (yych <= '`') goto yy3;
				goto yy170;
			} else {
				if (yych <= 'e') goto yy1351;
				if (yych <= 'h') goto yy170;
				goto yy1352;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1353;
				goto yy170;
			} else {
				if (yych <= 'r') goto yy1354;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy14:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy165;
				goto yy1310;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1311;
				goto yy165;
			} else {
				if (yych <= 'O') goto yy1312;
				if (yych <= 'Q') goto yy165;
				goto yy1313;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy165;
				if (yych <= '`') goto yy3;
				goto yy165;
			} else {
				if (yych <= 'e') goto yy1310;
				if (yych <= 'h') goto yy165;
				goto yy1311;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1312;
				goto yy165;
			} else {
				if (yych <= 'r') goto yy1313;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy15:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1296;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1307;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy16:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1296;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1296;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy17:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1276;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1293;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy18:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1276;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1276;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy19:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1219;
				goto yy165;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1218;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1220;
				if (yych <= 'T') goto yy165;
				goto yy1221;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1248;
				if (yych <= 'd') goto yy170;
				goto yy1247;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1249;
				goto yy170;
			} else {
				if (yych <= 'u') goto yy1250;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy20:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1219;
				goto yy165;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1218;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1220;
				if (yych <= 'T') goto yy165;
				goto yy1221;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1219;
				if (yych <= 'd') goto yy165;
				goto yy1218;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1220;
				goto yy165;
			} else {
				if (yych <= 'u') goto yy1221;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy21:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1188;
			if (yych <= 'K') goto yy165;
			goto yy1189;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy170;
			goto yy1206;
		} else {
			if (yych == 'l') goto yy1207;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy22:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1188;
			if (yych <= 'K') goto yy165;
			goto yy1189;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy165;
			goto yy1188;
		} else {
			if (yych == 'l') goto yy1189;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy23:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy165;
			goto yy1062;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'r') goto yy1181;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy24:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy165;
			goto yy1062;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'r') goto yy1062;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy25:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1016;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy1018;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy1028;
					if (yych <= '/') goto yy436;
					goto yy1061;
				} else {
					if (yych <= '9') goto yy1060;
					if (yych <= ':') goto yy1029;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy1018;
					if (yych <= 'C') goto yy12;
					goto yy1018;
				} else {
					if (yych == 'F') goto yy1018;
					goto yy12;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy1018;
					if (yych <= 'L') goto yy12;
					goto yy1018;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy1018;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy1018;
					if (yych <= 'c') goto yy12;
					goto yy1018;
				} else {
					if (yych == 'f') goto yy1018;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy1018;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy1018;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy1018;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy1018;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy1018;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy1018;
					if (yych == 0xC2) goto yy1018;
					goto yy12;
				}
			}
		}
	}
yy26:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy1060;
				} else {
					if (yych <= '9') goto yy1027;
					if (yych <= ':') goto yy447;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy426;
					if (yych <= 'C') goto yy12;
					goto yy426;
				} else {
					if (yych == 'F') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy426;
					if (yych <= 'L') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy426;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy426;
					if (yych <= 'c') goto yy12;
					goto yy426;
				} else {
					if (yych == 'f') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy426;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy426;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy426;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy426;
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy27:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy1027;
				} else {
					if (yych <= '9') goto yy1014;
					if (yych <= ':') goto yy447;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy426;
					if (yych <= 'C') goto yy12;
					goto yy426;
				} else {
					if (yych == 'F') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy426;
					if (yych <= 'L') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy426;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy426;
					if (yych <= 'c') goto yy12;
					goto yy426;
				} else {
					if (yych == 'f') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy426;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy426;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy426;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy426;
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy28:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy1014;
				} else {
					if (yych <= '9') goto yy433;
					if (yych <= ':') goto yy447;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy426;
					if (yych <= 'C') goto yy12;
					goto yy426;
				} else {
					if (yych == 'F') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy426;
					if (yych <= 'L') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy426;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy426;
					if (yych <= 'c') goto yy12;
					goto yy426;
				} else {
					if (yych == 'f') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy426;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy426;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy426;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy426;
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy29:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy433;
				} else {
					if (yych <= ':') goto yy447;
					if (yych <= '@') goto yy12;
					goto yy426;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy426;
					goto yy12;
				} else {
					if (yych == 'G') goto yy12;
					goto yy426;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy12;
					if (yych <= 'P') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'Y') goto yy426;
					if (yych <= '`') goto yy12;
					goto yy426;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy426;
					goto yy12;
				} else {
					if (yych == 'g') goto yy12;
					goto yy426;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy426;
					goto yy12;
				} else {
					if (yych == 'n') goto yy434;
					goto yy426;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy12;
					if (yych <= 'r') goto yy435;
					goto yy429;
				} else {
					if (yych <= 't') goto yy432;
					if (yych <= 'u') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy12;
					goto yy426;
				} else {
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy30:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy404;
	case '0':
	case '1':	goto yy401;
	case '2':	goto yy402;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy403;
	default:	goto yy12;
	}
yy31:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy400;
				if (yych <= 'U') goto yy165;
				goto yy399;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy399;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy32:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy396;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy33:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy394;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy34:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy377;
			if (yych <= 'T') goto yy165;
			goto yy376;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy386;
		} else {
			if (yych == 'u') goto yy385;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy35:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy377;
			if (yych <= 'T') goto yy165;
			goto yy376;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy377;
		} else {
			if (yych == 'u') goto yy376;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy36:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy355;
				goto yy165;
			} else {
				if (yych <= 'P') goto yy354;
				if (yych <= 'T') goto yy165;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'g') goto yy367;
				goto yy170;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy366;
				goto yy170;
			} else {
				if (yych <= 'u') goto yy365;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy37:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy355;
				goto yy165;
			} else {
				if (yych <= 'P') goto yy354;
				if (yych <= 'T') goto yy165;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'g') goto yy355;
				goto yy165;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy354;
				goto yy165;
			} else {
				if (yych <= 'u') goto yy353;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy38:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy165;
			goto yy343;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'c') goto yy348;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy39:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy165;
			goto yy343;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'c') goto yy343;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy40:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy216;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'e') goto yy334;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy41:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy216;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy216;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy42:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'e') goto yy203;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy43:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy189;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy44:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy165;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy181;
			goto yy165;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy45:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy180;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy180;
	goto yy12;
yy46:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy170;
		goto yy3;
	}
yy47:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy165;
		goto yy3;
	}
yy48:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	{
		goto std;
	}
yy50:
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	++YYCURSOR;
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy53:
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy66;
				} else {
					if (yych == 'F') goto yy67;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych >= 'S') goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy70;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych >= 'f') goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy65;
				} else {
					if (yych == 'm') goto yy61;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy70;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych >= 'w') goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
				}
			}
		}
	}
yy56:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept == 3) {
						goto yy74;
					} else {
						goto yy191;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy218;
					} else {
						goto yy232;
					}
				} else {
					if (yyaccept == 7) {
						goto yy246;
					} else {
						goto yy357;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy440;
					} else {
						goto yy455;
					}
				} else {
					if (yyaccept == 11) {
						goto yy576;
					} else {
						goto yy621;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy631;
					} else {
						goto yy728;
					}
				} else {
					if (yyaccept == 15) {
						goto yy748;
					} else {
						goto yy779;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy786;
						} else {
							goto yy813;
						}
					} else {
						goto yy758;
					}
				} else {
					if (yyaccept == 20) {
						goto yy419;
					} else {
						goto yy938;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy807;
					} else {
						goto yy1032;
					}
				} else {
					if (yyaccept == 24) {
						goto yy1040;
					} else {
						goto yy1084;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy1108;
					} else {
						goto yy1284;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1377;
					} else {
						goto yy1415;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1418;
					} else {
						goto yy1498;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1506;
					} else {
						goto yy1529;
					}
				}
			}
		}
	}
yy57:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy54;
	goto yy56;
yy59:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy60:
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy56;
				goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy66;
				} else {
					if (yych == 'F') goto yy67;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy56;
					goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy70;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych <= 'e') goto yy56;
					goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy65;
				} else {
					if (yych != 'm') goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy70;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych <= 'v') goto yy56;
					goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy61:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy138;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy138;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy137;
			if (yych == 's') goto yy139;
			goto yy56;
		}
	}
yy62:
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy134;
	goto yy56;
yy63:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy132;
	if (yych == 's') goto yy132;
	goto yy56;
yy64:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy120;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy120;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy65:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy116;
	if (yych == 'o') goto yy116;
	goto yy56;
yy66:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy115;
	if (yych == 'a') goto yy115;
	goto yy56;
yy67:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy100;
		if (yych <= 'Q') goto yy56;
		goto yy99;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy100;
		} else {
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy68:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy56;
yy69:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy84;
	if (yych == 'e') goto yy84;
	goto yy56;
yy70:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy71;
		if (yych <= 'T') goto yy56;
		goto yy72;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy71:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy79;
	if (yych == 'u') goto yy79;
	goto yy56;
yy72:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy73;
	if (yych != 'e') goto yy56;
yy73:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy75;
	if (yych == 's') goto yy75;
yy74:
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy75:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy76;
	if (yych != 'd') goto yy56;
yy76:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy77;
	if (yych != 'a') goto yy56;
yy77:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych != 'y') goto yy56;
yy78:
	yych = *++YYCURSOR;
	goto yy74;
yy79:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy80;
	if (yych != 'r') goto yy74;
yy80:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy81;
	if (yych != 's') goto yy56;
yy81:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy82;
	if (yych != 'd') goto yy56;
yy82:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy83;
	if (yych != 'a') goto yy56;
yy83:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy84:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy86;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy86;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy92;
	if (yych == 'k') goto yy92;
	goto yy56;
yy86:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy87;
	if (yych != 'n') goto yy74;
yy87:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy88;
	if (yych != 'e') goto yy56;
yy88:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych != 's') goto yy56;
yy89:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy90;
	if (yych != 'd') goto yy56;
yy90:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy91;
	if (yych != 'a') goto yy56;
yy91:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy92:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy93;
		if (yych <= 'R') goto yy74;
		goto yy78;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy74;
		} else {
			if (yych == 's') goto yy78;
			goto yy74;
		}
	}
yy93:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy94;
	if (yych != 'a') goto yy56;
yy94:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy95;
	if (yych != 'y') goto yy56;
yy95:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy78;
	if (yych == 's') goto yy78;
	goto yy74;
yy96:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy97;
	if (yych != 'a') goto yy56;
yy97:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy98;
	if (yych != 'r') goto yy56;
yy98:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy78;
	if (yych == 's') goto yy78;
	goto yy74;
yy99:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy112;
	if (yych == 'i') goto yy112;
	goto yy56;
yy100:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy101;
	if (yych != 'r') goto yy56;
yy101:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy102;
	if (yych != 't') goto yy56;
yy102:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy104;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy104;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy109;
	if (yych == 'i') goto yy109;
	goto yy56;
yy104:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy105;
	if (yych != 'n') goto yy56;
yy105:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy106;
	if (yych != 'i') goto yy56;
yy106:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy107;
	if (yych != 'g') goto yy56;
yy107:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy108;
	if (yych != 'h') goto yy56;
yy108:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy98;
	if (yych == 't') goto yy98;
	goto yy56;
yy109:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy110;
	if (yych != 'g') goto yy56;
yy110:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy111;
	if (yych != 'h') goto yy56;
yy111:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy98;
	if (yych == 't') goto yy98;
	goto yy56;
yy112:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy113;
	if (yych != 'd') goto yy74;
yy113:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy114;
	if (yych != 'a') goto yy56;
yy114:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy115:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy98;
	if (yych == 'y') goto yy98;
	goto yy56;
yy116:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy117;
	if (yych != 'u') goto yy56;
yy117:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy98;
	if (yych == 'r') goto yy98;
	goto yy56;
yy118:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy129;
	if (yych == 'n') goto yy129;
	goto yy56;
yy119:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy124;
	if (yych == 't') goto yy124;
	goto yy56;
yy120:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy121;
	if (yych != 'c') goto yy56;
yy121:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy122;
		if (yych <= 'R') goto yy74;
		goto yy78;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy74;
		} else {
			if (yych == 's') goto yy78;
			goto yy74;
		}
	}
yy122:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy123;
	if (yych != 'n') goto yy56;
yy123:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy124:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy125;
	if (yych != 'u') goto yy74;
yy125:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy126;
	if (yych != 'r') goto yy56;
yy126:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy127;
	if (yych != 'd') goto yy56;
yy127:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy128;
	if (yych != 'a') goto yy56;
yy128:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy129:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy130;
	if (yych != 'd') goto yy74;
yy130:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy131;
	if (yych != 'a') goto yy56;
yy131:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy132:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy133;
	if (yych != 'e') goto yy56;
yy133:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy134:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy135;
	if (yych != 's') goto yy56;
yy135:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy136;
	if (yych != 'e') goto yy74;
yy136:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy137:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy160;
	if (yych == 'n') goto yy160;
	goto yy56;
yy138:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy142;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy141;
			if (yych <= 'M') goto yy56;
			goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy142;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy141;
			if (yych == 'n') goto yy143;
			goto yy56;
		}
	}
yy139:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy140;
	if (yych != 'e') goto yy74;
yy140:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy141:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy153;
	if (yych == 'l') goto yy153;
	goto yy56;
yy142:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy146;
	if (yych == 'r') goto yy146;
	goto yy56;
yy143:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy78;
		if (yych <= 'T') goto yy74;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy74;
			goto yy78;
		} else {
			if (yych != 'u') goto yy74;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy145;
	if (yych != 't') goto yy56;
yy145:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy56;
yy146:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy147;
	if (yych != 'o') goto yy56;
yy147:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy148;
	if (yych != 's') goto yy56;
yy148:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy149;
	if (yych != 'e') goto yy56;
yy149:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy150;
	if (yych != 'c') goto yy56;
yy150:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy151;
	if (yych != 'o') goto yy56;
yy151:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy152;
	if (yych != 'n') goto yy56;
yy152:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy153:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy154;
	if (yych != 'i') goto yy56;
yy154:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy155;
	if (yych != 's') goto yy56;
yy155:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy156;
	if (yych != 'e') goto yy56;
yy156:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy157;
	if (yych != 'c') goto yy56;
yy157:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy158;
	if (yych != 'o') goto yy56;
yy158:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy159;
	if (yych != 'n') goto yy56;
yy159:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy160:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy161;
		if (yych <= 'S') goto yy74;
		goto yy162;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy74;
		} else {
			if (yych == 't') goto yy162;
			goto yy74;
		}
	}
yy161:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy163;
	if (yych == 'a') goto yy163;
	goto yy56;
yy162:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy98;
	if (yych == 'h') goto yy98;
	goto yy56;
yy163:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy164:
	yych = *++YYCURSOR;
	goto yy3;
yy165:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy166;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy166:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy167:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy168;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy168:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy169;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy169:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy164;
	goto yy3;
yy170:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy166;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy171:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy167;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy172:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	goto yy56;
yy173:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy3;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy3;
	}
yy175:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy176:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy177:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy164;
		if (yych <= ',') goto yy3;
		goto yy172;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy3;
		}
	}
yy178:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy179:
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy56;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy56;
	}
yy180:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy165;
		goto yy3;
	}
yy181:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy166;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy166;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy183;
			if (yych <= '@') goto yy3;
			goto yy167;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy183:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy184;
	if (yych <= '2') goto yy185;
	if (yych <= '9') goto yy186;
	goto yy56;
yy184:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy186;
	if (yych <= ':') goto yy187;
	goto yy3;
yy185:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy188;
	} else {
		if (yych <= '9') goto yy164;
		if (yych <= ':') goto yy187;
		goto yy3;
	}
yy186:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy188;
	if (yych <= '9') goto yy164;
	if (yych >= ';') goto yy3;
yy187:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy188;
	if (yych <= '9') goto yy164;
	goto yy3;
yy188:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy164;
	goto yy3;
yy189:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy166;
			if (yych >= 'E') goto yy192;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'd') goto yy190;
			if (yych <= 'e') goto yy192;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy190:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'M') goto yy167;
			goto yy198;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych >= 'a') goto yy167;
		} else {
			if (yych <= 'n') goto yy198;
			if (yych <= 'z') goto yy167;
		}
	}
yy191:
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy192:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy167;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'k') goto yy193;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy193:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy194;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy194:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy195;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy195:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy196;
		if (yych != 'y') goto yy3;
	}
yy196:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy197;
	if (yych != 's') goto yy191;
yy197:
	yych = *++YYCURSOR;
	goto yy191;
yy198:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy199;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy199:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy169;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 's') goto yy200;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy200:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy201;
		if (yych != 'd') goto yy3;
	}
yy201:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy202;
	if (yych != 'a') goto yy56;
yy202:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy203:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy172;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy166;
				goto yy190;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy192;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy171;
			} else {
				if (yych <= 'e') goto yy205;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy198;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy211;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy205:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy193;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'k') goto yy206;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy206:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy194;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy207;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy207:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy195;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy208;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy208:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy196;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy209;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy209:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy172;
			goto yy191;
		} else {
			if (yych <= '/') goto yy172;
			if (yych <= 'R') goto yy191;
			goto yy197;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy172;
			goto yy191;
		} else {
			if (yych == 's') goto yy210;
			if (yych <= 'z') goto yy178;
			goto yy191;
		}
	}
yy210:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy191;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy191;
	}
yy211:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy199;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy212;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy212:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy200;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 's') goto yy213;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy213:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy201;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'd') goto yy214;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy214:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy202;
	if (yych != 'a') goto yy179;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy216:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'c') goto yy217;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy217:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy220;
			} else {
				if (yych == ' ') goto yy220;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
			} else {
				if (yych == 'E') goto yy225;
				goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy167;
			} else {
				if (yych <= 'e') goto yy225;
				if (yych <= 'z') goto yy167;
			}
		}
	}
yy218:
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy219:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy220:
	if (yybm[0+yych] & 32) {
		goto yy219;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy222;
	if (yych <= '3') goto yy223;
	if (yych <= '9') goto yy224;
	goto yy56;
yy221:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy220;
	if (yych <= '0') goto yy324;
	if (yych <= '2') goto yy325;
	if (yych <= '3') goto yy326;
	goto yy220;
yy222:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy323;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy223:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy323;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy230;
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy224:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy230;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy225:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy168;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'm') goto yy226;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy226:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy169;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'b') goto yy227;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy227:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy228;
		if (yych != 'e') goto yy3;
	}
yy228:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych != 'r') goto yy56;
yy229:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy220;
		if (yych <= 0x1F) goto yy218;
		goto yy220;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy218;
			goto yy220;
		} else {
			if (yych <= '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		}
	}
yy230:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy320;
	goto yy56;
yy231:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy319;
	goto yy237;
yy232:
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy233:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy319;
	goto yy237;
yy234:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy319;
	goto yy237;
yy235:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy319;
	goto yy237;
yy236:
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy237:
	if (yybm[0+yych] & 64) {
		goto yy236;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy232;
		if (yych <= '0') goto yy310;
		if (yych <= '1') goto yy311;
		goto yy312;
	} else {
		if (yych <= '9') goto yy313;
		if (yych == 'T') goto yy239;
		goto yy232;
	}
yy238:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy232;
			goto yy240;
		} else {
			if (yych <= '1') goto yy241;
			if (yych <= '2') goto yy242;
			goto yy243;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy232;
		} else {
			if (yych != 't') goto yy232;
		}
	}
yy239:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy308;
	if (yych <= '2') goto yy309;
	if (yych <= '9') goto yy298;
	goto yy56;
yy240:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy56;
	} else {
		if (yych <= '0') goto yy298;
		if (yych <= '9') goto yy243;
		if (yych <= ':') goto yy299;
		goto yy56;
	}
yy241:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy56;
	} else {
		if (yych <= '2') goto yy243;
		if (yych <= '9') goto yy298;
		if (yych <= ':') goto yy244;
		goto yy56;
	}
yy242:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy56;
	} else {
		if (yych <= '4') goto yy298;
		if (yych == ':') goto yy244;
		goto yy56;
	}
yy243:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy244;
	if (yych != ':') goto yy56;
yy244:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy245;
	if (yych <= '9') goto yy247;
	goto yy56;
yy245:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy248;
	} else {
		if (yych <= '9') goto yy291;
		if (yych <= ':') goto yy248;
	}
yy246:
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy247:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy248;
	if (yych != ':') goto yy246;
yy248:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy249;
	if (yych <= '6') goto yy250;
	if (yych <= '9') goto yy251;
	goto yy56;
yy249:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy252;
	goto yy246;
yy250:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy252;
	goto yy246;
yy251:
	yych = *++YYCURSOR;
	goto yy246;
yy252:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy254;
			goto yy246;
		} else {
			if (yych <= ' ') goto yy254;
			if (yych == '(') goto yy254;
			goto yy246;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy246;
			if (yych <= '-') goto yy254;
			goto yy246;
		} else {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy254;
			goto yy246;
		}
	}
yy253:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy254:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy253;
			} else {
				if (yych == ' ') goto yy253;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy257;
				if (yych <= '*') goto yy56;
				goto yy256;
			} else {
				if (yych == '-') goto yy256;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy258;
				if (yych <= 'F') goto yy259;
			} else {
				if (yych == 'P') goto yy258;
				goto yy259;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy260;
				goto yy261;
			} else {
				if (yych <= 'p') goto yy260;
				if (yych <= 'z') goto yy261;
				goto yy56;
			}
		}
	}
yy255:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy251;
		if (yych <= '@') goto yy246;
		goto yy262;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy289;
			goto yy262;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy273;
			goto yy246;
		}
	}
yy256:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy284;
	if (yych <= '2') goto yy285;
	if (yych <= '9') goto yy286;
	goto yy56;
yy257:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy261;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy261;
	goto yy56;
yy258:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych <= '.') goto yy267;
			if (yych <= '@') goto yy246;
			goto yy262;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy268;
			if (yych <= 'Z') goto yy262;
			goto yy246;
		} else {
			if (yych == 'm') goto yy283;
			if (yych <= 'z') goto yy273;
			goto yy246;
		}
	}
yy259:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy262;
		if (yych <= '`') goto yy246;
		if (yych <= 'z') goto yy273;
		goto yy246;
	}
yy260:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych <= '.') goto yy267;
			if (yych <= '@') goto yy246;
			goto yy262;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy268;
			if (yych <= 'Z') goto yy262;
			goto yy246;
		} else {
			if (yych == 'm') goto yy268;
			if (yych <= 'z') goto yy262;
			goto yy246;
		}
	}
yy261:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy262;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy262:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy263;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy263:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy264;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy264:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy265;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy265:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy266;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy266:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy251;
	goto yy246;
yy267:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy272;
	if (yych == 'm') goto yy272;
	goto yy56;
yy268:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy270;
			if (yych <= 0x08) goto yy246;
			goto yy270;
		} else {
			if (yych == ' ') goto yy270;
			if (yych <= '(') goto yy246;
			goto yy251;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy246;
		} else {
			if (yych <= 'Z') goto yy263;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy263;
			goto yy246;
		}
	}
yy269:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy270;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy270:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy272:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy270;
		if (yych == '\t') goto yy270;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy270;
		if (yych == '.') goto yy269;
		goto yy56;
	}
yy273:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy263;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
yy274:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy264;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy278;
			goto yy246;
		}
	}
yy275:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy276;
	if (yych <= '`') goto yy56;
	if (yych >= '{') goto yy56;
yy276:
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy246;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			goto yy246;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy246;
			goto yy275;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy276;
			goto yy246;
		}
	}
yy278:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy265;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy266;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy246;
			goto yy251;
		} else {
			if (yych == '-') goto yy275;
			goto yy246;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy275;
			if (yych <= '^') goto yy246;
			goto yy275;
		} else {
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
yy281:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy275;
		if (yych <= '.') goto yy56;
		goto yy275;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy275;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy281;
			goto yy56;
		}
	}
yy283:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy270;
			if (yych == '\t') goto yy270;
			goto yy246;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy270;
				goto yy246;
			} else {
				if (yych <= ')') goto yy251;
				if (yych <= ',') goto yy246;
				goto yy275;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy269;
			if (yych <= '/') goto yy275;
			if (yych <= '@') goto yy246;
			goto yy263;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy246;
				goto yy275;
			} else {
				if (yych <= '`') goto yy246;
				if (yych <= 'z') goto yy274;
				goto yy246;
			}
		}
	}
yy284:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy286;
	if (yych <= ':') goto yy287;
	goto yy246;
yy285:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy246;
		if (yych >= '5') goto yy288;
	} else {
		if (yych <= '9') goto yy251;
		if (yych <= ':') goto yy287;
		goto yy246;
	}
yy286:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '5') goto yy288;
	if (yych <= '9') goto yy251;
	if (yych >= ';') goto yy246;
yy287:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '5') goto yy288;
	if (yych <= '9') goto yy251;
	goto yy246;
yy288:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy251;
	goto yy246;
yy289:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy251;
		if (yych <= '@') goto yy246;
		goto yy263;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy263;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy263;
			goto yy246;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy246;
			goto yy251;
		} else {
			if (yych == '+') goto yy256;
			goto yy246;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy256;
			if (yych <= '@') goto yy246;
			goto yy264;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy264;
			goto yy246;
		}
	}
yy291:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy292;
			if (yych <= 0x1F) goto yy246;
		} else {
			if (yych == '.') goto yy248;
			if (yych <= '9') goto yy246;
			goto yy248;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy294;
			if (yych <= 'O') goto yy246;
			goto yy294;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy246;
				goto yy294;
			} else {
				if (yych == 'p') goto yy294;
				goto yy246;
			}
		}
	}
yy292:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy292;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy292;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy294;
			if (yych != 'p') goto yy56;
		}
	}
yy294:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy296;
		if (yych == 'm') goto yy296;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy296;
	if (yych != 'm') goto yy56;
yy296:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy270;
		if (yych == '\t') goto yy270;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy270;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy270;
		if (yych <= 0x08) goto yy56;
		goto yy270;
	} else {
		if (yych == ' ') goto yy270;
		goto yy56;
	}
yy298:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy299;
	if (yych != ':') goto yy56;
yy299:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy300;
	if (yych <= '9') goto yy301;
	goto yy56;
yy300:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy302;
		goto yy246;
	} else {
		if (yych <= '9') goto yy301;
		if (yych <= ':') goto yy302;
		goto yy246;
	}
yy301:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy302;
	if (yych != ':') goto yy246;
yy302:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy303;
	if (yych <= '6') goto yy304;
	if (yych <= '9') goto yy251;
	goto yy56;
yy303:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy305;
	goto yy246;
yy304:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy246;
yy305:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy307;
			goto yy246;
		} else {
			if (yych <= ' ') goto yy307;
			if (yych == '(') goto yy307;
			goto yy246;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy246;
			if (yych <= '-') goto yy307;
			goto yy246;
		} else {
			if (yych <= 'Z') goto yy307;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy307;
			goto yy246;
		}
	}
yy306:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy307:
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy56;
			goto yy306;
		} else {
			if (yych == '(') goto yy257;
			if (yych <= '*') goto yy56;
			goto yy256;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy256;
			if (yych <= '@') goto yy56;
			goto yy259;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy255;
				goto yy259;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy261;
				goto yy56;
			}
		}
	}
yy308:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy56;
	} else {
		if (yych <= '9') goto yy298;
		if (yych <= ':') goto yy299;
		goto yy56;
	}
yy309:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy56;
	} else {
		if (yych <= '4') goto yy298;
		if (yych == ':') goto yy299;
		goto yy56;
	}
yy310:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy232;
	} else {
		if (yych <= '0') goto yy317;
		if (yych <= '9') goto yy318;
		if (yych <= ':') goto yy299;
		goto yy232;
	}
yy311:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '2') goto yy318;
		if (yych <= '9') goto yy317;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy312:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '4') goto yy317;
		if (yych <= '9') goto yy314;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy313:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '9') goto yy314;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy314:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy232;
	if (yych >= ':') goto yy232;
yy315:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy232;
	if (yych >= ':') goto yy232;
	yych = *++YYCURSOR;
	goto yy232;
yy317:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy232;
	} else {
		if (yych <= '9') goto yy315;
		if (yych <= ':') goto yy299;
		goto yy232;
	}
yy318:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '9') goto yy315;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy319:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy238;
	goto yy237;
yy320:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy323:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy320;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy324:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy327;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy325:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy327;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy326:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy230;
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy327:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy56;
				if (yych <= ',') goto yy236;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy320;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy330;
	if (yych <= '9') goto yy331;
yy330:
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy331:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy330;
	if (yych >= ':') goto yy330;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy330;
	if (yych >= ':') goto yy330;
	yych = *++YYCURSOR;
	goto yy330;
yy334:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy217;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'c') goto yy335;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy335:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy225;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy337;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy336:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	if (yych <= '/') goto yy220;
	if (yych <= '0') goto yy324;
	if (yych <= '2') goto yy325;
	if (yych <= '3') goto yy326;
	goto yy220;
yy337:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy226;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'm') goto yy338;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy338:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy227;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'b') goto yy339;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy339:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy228;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'e') goto yy340;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy340:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych != 'r') goto yy179;
yy341:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych <= ',') goto yy218;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy172;
			goto yy220;
		} else {
			if (yych == '_') goto yy172;
			goto yy218;
		}
	}
yy342:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	goto yy220;
yy343:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy166;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 't') goto yy344;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy344:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'O') goto yy167;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'o') goto yy345;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy345:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy168;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'b') goto yy346;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy346:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy169;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'e') goto yy347;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy347:
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy229;
		if (yych == 'r') goto yy229;
		goto yy3;
	}
yy348:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy344;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 't') goto yy349;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy349:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'O') goto yy345;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy350;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy350:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy346;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'b') goto yy351;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy351:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy347;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'e') goto yy352;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy352:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy229;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'r') goto yy341;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy353:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy166;
			goto yy361;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'g') goto yy361;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy354:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy166;
			goto yy358;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'r') goto yy358;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy355:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy166;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'o') goto yy356;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy356:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy357;
		if (yych <= 'z') goto yy167;
	}
yy357:
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy358:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'I') goto yy167;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'i') goto yy359;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy359:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy168;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'l') goto yy360;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy360:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy169;
			goto yy218;
		}
	}
yy361:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'U') goto yy167;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'u') goto yy362;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy362:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy168;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 's') goto yy363;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy363:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy364;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy364:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy218;
			goto yy220;
		} else {
			if (yych == ' ') goto yy220;
			goto yy218;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy164;
			if (yych <= ',') goto yy218;
			goto yy220;
		} else {
			if (yych <= '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		}
	}
yy365:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy361;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'g') goto yy372;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy366:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy358;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'r') goto yy369;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy367:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy356;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'o') goto yy368;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy368:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy357;
		} else {
			if (yych == '.') goto yy357;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy357;
			if (yych <= 'Z') goto yy167;
			goto yy357;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy357;
			if (yych <= 'z') goto yy175;
			goto yy357;
		}
	}
yy369:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'I') goto yy359;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'i') goto yy370;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy370:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy360;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'l') goto yy371;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy371:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy342;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy177;
				goto yy218;
			}
		}
	}
yy372:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'U') goto yy362;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy373;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy373:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy363;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 's') goto yy374;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy374:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy364;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy375;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy375:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy342;
			if (yych <= '.') goto yy220;
			goto yy172;
		} else {
			if (yych <= '9') goto yy220;
			if (yych == '_') goto yy172;
			goto yy218;
		}
	}
yy376:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'L') goto yy383;
			if (yych <= 'M') goto yy166;
			goto yy382;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy166;
			goto yy383;
		} else {
			if (yych == 'n') goto yy382;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy377:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy378;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy378:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'U') goto yy167;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'u') goto yy379;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy379:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy380;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy380:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy381;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy381:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy229;
		if (yych == 'y') goto yy229;
		goto yy3;
	}
yy382:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych == 'E') goto yy384;
				goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'e') goto yy384;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy383:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'Y') goto yy167;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'y') goto yy384;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy384:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy168;
			goto yy218;
		}
	}
yy385:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'L') goto yy383;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy382;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy392;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy391;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy386:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy378;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy387;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy387:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'U') goto yy379;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy388;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy388:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy380;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy389;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy389:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy381;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy390;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy390:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy229;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy341;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy391:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy384;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy393;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy392:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'Y') goto yy384;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'y') goto yy393;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy393:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy342;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy176;
				goto yy218;
			}
		}
	}
yy394:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy395:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy396:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy167;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy167;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy399:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy400:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy395;
				goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy401:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy421;
				} else {
					if (yych <= ':') goto yy187;
					if (yych <= 'C') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy3;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy402:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy3;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy421;
					goto yy406;
				} else {
					if (yych <= '9') goto yy407;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy403:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy406;
				} else {
					if (yych <= '9') goto yy407;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy404:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy404;
		goto yy56;
	} else {
		if (yych <= '-') goto yy404;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		goto yy56;
	}
yy406:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy420;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy407:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
yy409:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych != '-') goto yy60;
yy410:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy411;
	if (yych <= '1') goto yy412;
	goto yy56;
yy411:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy413;
	goto yy56;
yy412:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy413:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy415;
	if (yych <= '2') goto yy416;
	if (yych <= '3') goto yy417;
	goto yy56;
yy415:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy418;
	goto yy56;
yy416:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy418;
	goto yy56;
yy417:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy418:
	++YYCURSOR;
yy419:
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy420:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy409;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy421:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy420;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy3;
					goto yy410;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy424:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy426;
	if (yych <= '0') goto yy700;
	if (yych <= '1') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy426;
yy425:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy426:
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy425;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy425;
					if (yych <= ',') goto yy56;
					goto yy541;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy444;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy430;
					if (yych == 'F') goto yy431;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy439;
					goto yy443;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy427;
					if (yych <= 'N') goto yy446;
					goto yy445;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy448;
					if (yych <= 'R') goto yy56;
					goto yy428;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy441;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy442;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy444;
					if (yych == 'd') goto yy430;
					goto yy56;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy431;
					if (yych <= 'g') goto yy56;
					goto yy65;
				} else {
					if (yych == 'j') goto yy443;
					if (yych <= 'l') goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy446;
					if (yych <= 'o') goto yy445;
					goto yy448;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy428;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy427:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy556;
			if (yych <= 'H') goto yy56;
			goto yy138;
		} else {
			if (yych == 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy556;
			if (yych <= 'h') goto yy56;
			goto yy138;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy137;
			} else {
				if (yych == 's') goto yy139;
				goto yy56;
			}
		}
	}
yy428:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1013;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1013;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy429:
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1013;
			if (yych == 'U') goto yy118;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy119;
			if (yych <= 'd') goto yy56;
			goto yy1013;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy693;
			if (yych <= 'u') goto yy118;
			goto yy56;
		}
	}
yy430:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy115;
		if (yych <= 'D') goto yy56;
		goto yy543;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy115;
		} else {
			if (yych == 'e') goto yy543;
			goto yy56;
		}
	}
yy431:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy559;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy100;
			if (yych <= 'Q') goto yy56;
			goto yy99;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy559;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy100;
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy432:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy71;
		if (yych <= 'T') goto yy56;
		goto yy72;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1012;
		} else {
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy433:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy706;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy705;
	goto yy60;
yy434:
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy494;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy693;
		if (yych == 'o') goto yy494;
		goto yy56;
	}
yy435:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy693;
	goto yy56;
yy436:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy630;
	case '3':	goto yy632;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy633;
	case 'A':
	case 'a':	goto yy637;
	case 'D':
	case 'd':	goto yy641;
	case 'F':
	case 'f':	goto yy635;
	case 'J':
	case 'j':	goto yy634;
	case 'M':
	case 'm':	goto yy636;
	case 'N':
	case 'n':	goto yy640;
	case 'O':
	case 'o':	goto yy639;
	case 'S':
	case 's':	goto yy638;
	default:	goto yy56;
	}
yy437:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy580;
	case '1':	goto yy581;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy582;
	case 'A':
	case 'a':	goto yy586;
	case 'D':
	case 'd':	goto yy590;
	case 'F':
	case 'f':	goto yy584;
	case 'J':
	case 'j':	goto yy583;
	case 'M':
	case 'm':	goto yy585;
	case 'N':
	case 'n':	goto yy589;
	case 'O':
	case 'o':	goto yy588;
	case 'S':
	case 's':	goto yy587;
	default:	goto yy542;
	}
yy438:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy542;
		if (yych <= '0') goto yy532;
		goto yy533;
	} else {
		if (yych <= '5') goto yy534;
		if (yych <= '9') goto yy535;
		goto yy542;
	}
yy439:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '.') goto yy496;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy498;
			if (yych == 'I') goto yy531;
		} else {
			if (yych == 'W') goto yy440;
			if (yych <= 'X') goto yy504;
		}
	}
yy440:
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy441:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy529;
			goto yy440;
		}
	}
yy442:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy528;
			goto yy440;
		}
	}
yy443:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy521;
		if (yych <= 'T') goto yy56;
		goto yy520;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy521;
		} else {
			if (yych == 'u') goto yy520;
			goto yy56;
		}
	}
yy444:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy449;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy450;
			if (yych == 'P') goto yy514;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy513;
			if (yych == 'm') goto yy450;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy514;
			if (yych == 'u') goto yy513;
			goto yy56;
		}
	}
yy445:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy508;
	if (yych == 'c') goto yy508;
	goto yy56;
yy446:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy494;
	if (yych == 'o') goto yy494;
	goto yy56;
yy447:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy454;
	if (yych <= '9') goto yy456;
	goto yy56;
yy448:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy450;
		if (yych == 'm') goto yy450;
		goto yy56;
	}
yy449:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy450;
	if (yych != 'm') goto yy56;
yy450:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy452;
		if (yych == '\t') goto yy452;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy452;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy452;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy452:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy454:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy457;
	} else {
		if (yych <= '9') goto yy471;
		if (yych <= ':') goto yy457;
	}
yy455:
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy456:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy457;
	if (yych != ':') goto yy455;
yy457:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy458;
	if (yych <= '6') goto yy459;
	if (yych <= '9') goto yy460;
	goto yy56;
yy458:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy464;
	goto yy455;
yy459:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych == '0') goto yy464;
	goto yy455;
yy460:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy455;
yy461:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy462:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy462;
	goto yy455;
yy464:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy455;
		} else {
			if (yych <= ' ') goto yy465;
			if (yych == '.') goto yy461;
			goto yy455;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy467;
			if (yych == 'P') goto yy467;
			goto yy455;
		} else {
			if (yych <= 'a') goto yy467;
			if (yych == 'p') goto yy467;
			goto yy455;
		}
	}
yy465:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy465;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy465;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy467;
			if (yych != 'p') goto yy56;
		}
	}
yy467:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy469;
		if (yych == 'm') goto yy469;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy469;
	if (yych != 'm') goto yy56;
yy469:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy452;
		if (yych == '\t') goto yy452;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy452;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy452;
		if (yych <= 0x08) goto yy56;
		goto yy452;
	} else {
		if (yych == ' ') goto yy452;
		goto yy56;
	}
yy471:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy472;
			if (yych <= 0x1F) goto yy455;
		} else {
			if (yych == '.') goto yy457;
			if (yych <= '9') goto yy455;
			goto yy475;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy474;
			if (yych <= 'O') goto yy455;
			goto yy474;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy474;
			} else {
				if (yych == 'p') goto yy474;
				goto yy455;
			}
		}
	}
yy472:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy472;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy472;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy474;
			if (yych != 'p') goto yy56;
		}
	}
yy474:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy491;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy492;
		if (yych == 'm') goto yy492;
		goto yy56;
	}
yy475:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy476;
	if (yych <= '6') goto yy477;
	if (yych <= '9') goto yy460;
	goto yy56;
yy476:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy478;
	goto yy455;
yy477:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych != '0') goto yy455;
yy478:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy465;
			if (yych <= 0x1F) goto yy455;
			goto yy465;
		} else {
			if (yych == '.') goto yy479;
			if (yych <= '9') goto yy455;
			goto yy480;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy467;
			if (yych <= 'O') goto yy455;
			goto yy467;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy467;
			} else {
				if (yych == 'p') goto yy467;
				goto yy455;
			}
		}
	}
yy479:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy489;
	goto yy56;
yy480:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy481:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy481;
		} else {
			if (yych != 'A') goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy483;
			if (yych <= '`') goto yy56;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy483:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy485;
		if (yych == 'm') goto yy485;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy485;
	if (yych != 'm') goto yy56;
yy485:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy487:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy489:
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy455;
			goto yy489;
		} else {
			if (yych == 'A') goto yy483;
			goto yy455;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy483;
			if (yych <= '`') goto yy455;
			goto yy483;
		} else {
			if (yych == 'p') goto yy483;
			goto yy455;
		}
	}
yy491:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy492;
	if (yych != 'm') goto yy56;
yy492:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy452;
		if (yych == '\t') goto yy452;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy452;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy452;
		if (yych <= 0x08) goto yy56;
		goto yy452;
	} else {
		if (yych == ' ') goto yy452;
		goto yy56;
	}
yy494:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy495;
	if (yych != 'v') goto yy56;
yy495:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy500;
			if (yych == 'e') goto yy500;
			goto yy440;
		}
	}
yy496:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy497:
	if (yych <= ' ') {
		if (yych == '\t') goto yy496;
		if (yych <= 0x1F) goto yy56;
		goto yy496;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy496;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy498:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy499;
	if (yych <= '9') goto yy505;
yy499:
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy500:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy501;
	if (yych != 'm') goto yy56;
yy501:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy502;
	if (yych != 'b') goto yy56;
yy502:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy503;
	if (yych != 'e') goto yy56;
yy503:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych != 'r') goto yy56;
yy504:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy496;
		if (yych <= 0x1F) goto yy440;
		goto yy496;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy440;
			goto yy496;
		} else {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		}
	}
yy505:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych >= ':') goto yy499;
yy506:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych >= ':') goto yy499;
	yych = *++YYCURSOR;
	goto yy499;
yy508:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy509;
	if (yych != 't') goto yy56;
yy509:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'O') goto yy510;
			if (yych != 'o') goto yy440;
		}
	}
yy510:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy511;
	if (yych != 'b') goto yy56;
yy511:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy512;
	if (yych != 'e') goto yy56;
yy512:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych == 'r') goto yy504;
	goto yy56;
yy513:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy517;
	if (yych == 'g') goto yy517;
	goto yy56;
yy514:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy515;
	if (yych != 'r') goto yy56;
yy515:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'I') goto yy516;
			if (yych != 'i') goto yy440;
		}
	}
yy516:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy504;
	if (yych == 'l') goto yy504;
	goto yy56;
yy517:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy518;
			if (yych != 'u') goto yy440;
		}
	}
yy518:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy519;
	if (yych != 's') goto yy56;
yy519:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy504;
	if (yych == 't') goto yy504;
	goto yy56;
yy520:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy527;
		if (yych <= 'M') goto yy56;
		goto yy526;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy527;
		} else {
			if (yych == 'n') goto yy526;
			goto yy56;
		}
	}
yy521:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy522;
	if (yych != 'n') goto yy56;
yy522:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy523;
			if (yych != 'u') goto yy440;
		}
	}
yy523:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy524;
	if (yych != 'a') goto yy56;
yy524:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy525;
	if (yych != 'r') goto yy56;
yy525:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy504;
	if (yych == 'y') goto yy504;
	goto yy56;
yy526:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy504;
			if (yych == 'e') goto yy504;
			goto yy440;
		}
	}
yy527:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'Y') goto yy504;
			if (yych == 'y') goto yy504;
			goto yy440;
		}
	}
yy528:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy504;
			goto yy440;
		}
	}
yy529:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych != 'I') goto yy440;
		}
	}
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy504;
			goto yy440;
		}
	}
yy531:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy504;
			goto yy440;
		}
	}
yy532:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy565;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy579;
		if (yych <= ':') goto yy457;
		goto yy455;
	}
yy533:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		if (yych <= '.') goto yy565;
		goto yy455;
	} else {
		if (yych <= '2') goto yy579;
		if (yych <= '9') goto yy578;
		if (yych <= ':') goto yy457;
		goto yy455;
	}
yy534:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy565;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy578;
		if (yych <= ':') goto yy457;
		goto yy455;
	}
yy535:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy565;
	} else {
		if (yych == ':') goto yy457;
		goto yy455;
	}
yy536:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy559;
	if (yych == 'e') goto yy559;
	goto yy56;
yy537:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy556;
	if (yych == 'a') goto yy556;
	goto yy56;
yy538:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy514;
		if (yych <= 'T') goto yy56;
		goto yy513;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy514;
		} else {
			if (yych == 'u') goto yy513;
			goto yy56;
		}
	}
yy539:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy549;
	if (yych == 'e') goto yy549;
	goto yy56;
yy540:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy543;
	if (yych == 'e') goto yy543;
	goto yy56;
yy541:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy542:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy541;
	case 'A':
	case 'a':	goto yy538;
	case 'D':
	case 'd':	goto yy540;
	case 'F':
	case 'f':	goto yy536;
	case 'I':	goto yy439;
	case 'J':
	case 'j':	goto yy443;
	case 'M':
	case 'm':	goto yy537;
	case 'N':
	case 'n':	goto yy446;
	case 'O':
	case 'o':	goto yy445;
	case 'S':
	case 's':	goto yy539;
	case 'V':	goto yy441;
	case 'X':	goto yy442;
	default:	goto yy56;
	}
yy543:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy544;
	if (yych != 'c') goto yy56;
yy544:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy545;
			if (yych != 'e') goto yy440;
		}
	}
yy545:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy546;
	if (yych != 'm') goto yy56;
yy546:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy547;
	if (yych != 'b') goto yy56;
yy547:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy548;
	if (yych != 'e') goto yy56;
yy548:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych == 'r') goto yy504;
	goto yy56;
yy549:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy550;
	if (yych != 'p') goto yy56;
yy550:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'T') goto yy551;
			if (yych != 't') goto yy440;
		}
	}
yy551:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy552;
			if (yych != 'e') goto yy440;
		}
	}
yy552:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy553;
	if (yych != 'm') goto yy56;
yy553:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy554;
	if (yych != 'b') goto yy56;
yy554:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy555;
	if (yych != 'e') goto yy56;
yy555:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych == 'r') goto yy504;
	goto yy56;
yy556:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy557;
		if (yych <= 'X') goto yy56;
		goto yy504;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy504;
			goto yy56;
		}
	}
yy557:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'C') goto yy558;
			if (yych != 'c') goto yy440;
		}
	}
yy558:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy504;
	if (yych == 'h') goto yy504;
	goto yy56;
yy559:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy560;
	if (yych != 'b') goto yy56;
yy560:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'R') goto yy561;
			if (yych != 'r') goto yy440;
		}
	}
yy561:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy562;
	if (yych != 'u') goto yy56;
yy562:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy563;
	if (yych != 'a') goto yy56;
yy563:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy564;
	if (yych != 'r') goto yy56;
yy564:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy504;
	if (yych == 'y') goto yy504;
	goto yy56;
yy565:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy572;
	if (yych <= '6') goto yy573;
	if (yych <= '9') goto yy574;
	goto yy56;
yy566:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy568:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy569:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy572:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy577;
	goto yy455;
yy573:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy461;
		goto yy455;
	} else {
		if (yych <= '0') goto yy577;
		if (yych <= '9') goto yy575;
		goto yy455;
	}
yy574:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych >= ':') goto yy455;
yy575:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy576;
	if (yych <= '9') goto yy569;
yy576:
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy577:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy465;
			if (yych <= 0x1F) goto yy455;
			goto yy465;
		} else {
			if (yych == '.') goto yy461;
			if (yych <= '/') goto yy455;
			goto yy569;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy467;
			if (yych <= 'O') goto yy455;
			goto yy467;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy467;
			} else {
				if (yych == 'p') goto yy467;
				goto yy455;
			}
		}
	}
yy578:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy472;
			if (yych <= 0x1F) goto yy455;
			goto yy472;
		} else {
			if (yych == '.') goto yy457;
			if (yych <= '9') goto yy455;
			goto yy457;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy474;
			if (yych <= 'O') goto yy455;
			goto yy474;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy474;
			} else {
				if (yych == 'p') goto yy474;
				goto yy455;
			}
		}
	}
yy579:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy472;
			if (yych <= 0x1F) goto yy455;
			goto yy472;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy455;
				goto yy566;
			} else {
				if (yych <= '.') goto yy565;
				if (yych <= '9') goto yy455;
				goto yy457;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy474;
			if (yych <= 'O') goto yy455;
			goto yy474;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy474;
			} else {
				if (yych == 'p') goto yy474;
				goto yy455;
			}
		}
	}
yy580:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy582;
		goto yy56;
	}
yy581:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy582:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy619;
	if (yych <= '.') goto yy566;
	goto yy56;
yy583:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy615;
		if (yych <= 'T') goto yy56;
		goto yy614;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy615;
		} else {
			if (yych == 'u') goto yy614;
			goto yy56;
		}
	}
yy584:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy612;
	if (yych == 'e') goto yy612;
	goto yy56;
yy585:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy609;
	if (yych == 'a') goto yy609;
	goto yy56;
yy586:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy606;
		if (yych <= 'T') goto yy56;
		goto yy605;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy606;
		} else {
			if (yych == 'u') goto yy605;
			goto yy56;
		}
	}
yy587:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy602;
	if (yych == 'e') goto yy602;
	goto yy56;
yy588:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy600;
	if (yych == 'c') goto yy600;
	goto yy56;
yy589:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy598;
	if (yych == 'o') goto yy598;
	goto yy56;
yy590:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy591;
	if (yych != 'e') goto yy56;
yy591:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy592;
	if (yych != 'c') goto yy56;
yy592:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych >= '.') goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy545;
			if (yych == 'e') goto yy545;
			goto yy440;
		}
	}
yy593:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy497;
	if (yych <= '0') goto yy594;
	if (yych <= '2') goto yy595;
	if (yych <= '3') goto yy596;
	goto yy497;
yy594:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '9') goto yy597;
	goto yy499;
yy595:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '9') goto yy597;
	goto yy499;
yy596:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '1') goto yy597;
	if (yych <= '9') goto yy505;
	goto yy499;
yy597:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '9') goto yy506;
	goto yy499;
yy598:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy599;
	if (yych != 'v') goto yy56;
yy599:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy500;
			if (yych == 'e') goto yy500;
			goto yy440;
		}
	}
yy600:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy601;
	if (yych != 't') goto yy56;
yy601:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'O') goto yy510;
			if (yych == 'o') goto yy510;
			goto yy440;
		}
	}
yy602:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy603;
	if (yych != 'p') goto yy56;
yy603:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'T') goto yy604;
			if (yych != 't') goto yy440;
		}
	}
yy604:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy552;
			if (yych == 'e') goto yy552;
			goto yy440;
		}
	}
yy605:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy608;
	if (yych == 'g') goto yy608;
	goto yy56;
yy606:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy607;
	if (yych != 'r') goto yy56;
yy607:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'I') goto yy516;
			if (yych == 'i') goto yy516;
			goto yy440;
		}
	}
yy608:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy518;
			if (yych == 'u') goto yy518;
			goto yy440;
		}
	}
yy609:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy610;
		if (yych <= 'X') goto yy56;
		goto yy611;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy611;
			goto yy56;
		}
	}
yy610:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'C') goto yy558;
			if (yych == 'c') goto yy558;
			goto yy440;
		}
	}
yy611:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy593;
			goto yy496;
		} else {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		}
	}
yy612:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy613;
	if (yych != 'b') goto yy56;
yy613:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'R') goto yy561;
			if (yych == 'r') goto yy561;
			goto yy440;
		}
	}
yy614:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy618;
		if (yych <= 'M') goto yy56;
		goto yy617;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy618;
		} else {
			if (yych == 'n') goto yy617;
			goto yy56;
		}
	}
yy615:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy616;
	if (yych != 'n') goto yy56;
yy616:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy523;
			if (yych == 'u') goto yy523;
			goto yy440;
		}
	}
yy617:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy504;
			if (yych == 'e') goto yy504;
			goto yy440;
		}
	}
yy618:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'Y') goto yy504;
			if (yych == 'y') goto yy504;
			goto yy440;
		}
	}
yy619:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy620;
	if (yych <= '3') goto yy622;
	if (yych <= '9') goto yy623;
	goto yy56;
yy620:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy629;
		if (yych >= 'n') goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
		}
	}
yy621:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy622:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
			goto yy629;
		} else {
			if (yych <= '9') goto yy568;
			if (yych <= 'm') goto yy621;
			goto yy625;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy623:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy568;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy624:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy628;
	goto yy56;
yy625:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy628;
	goto yy56;
yy626:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy628;
	goto yy56;
yy627:
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy56;
yy628:
	yych = *++YYCURSOR;
	goto yy621;
yy629:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy569;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy630:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy687;
		} else {
			if (yych <= '9') goto yy633;
			if (yych >= 'n') goto yy684;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy685;
		} else {
			if (yych <= 's') goto yy683;
			if (yych <= 't') goto yy686;
		}
	}
yy631:
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy632:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy631;
			goto yy687;
		} else {
			if (yych <= '1') goto yy633;
			if (yych <= 'm') goto yy631;
			goto yy684;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy685;
		} else {
			if (yych <= 's') goto yy683;
			if (yych <= 't') goto yy686;
			goto yy631;
		}
	}
yy633:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy687;
		if (yych <= 'm') goto yy631;
		goto yy684;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy685;
		} else {
			if (yych <= 's') goto yy683;
			if (yych <= 't') goto yy686;
			goto yy631;
		}
	}
yy634:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy682;
		if (yych <= 'T') goto yy56;
		goto yy681;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy682;
		} else {
			if (yych == 'u') goto yy681;
			goto yy56;
		}
	}
yy635:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy680;
	if (yych == 'e') goto yy680;
	goto yy56;
yy636:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy679;
	if (yych == 'a') goto yy679;
	goto yy56;
yy637:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy678;
		if (yych <= 'T') goto yy56;
		goto yy677;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy678;
		} else {
			if (yych == 'u') goto yy677;
			goto yy56;
		}
	}
yy638:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy675;
	if (yych == 'e') goto yy675;
	goto yy56;
yy639:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy674;
	if (yych == 'c') goto yy674;
	goto yy56;
yy640:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy673;
	if (yych == 'o') goto yy673;
	goto yy56;
yy641:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy642;
	if (yych != 'e') goto yy56;
yy642:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy643;
	if (yych != 'c') goto yy56;
yy643:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy644:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy650;
	if (yych <= '2') goto yy651;
	goto yy56;
yy650:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy652;
	goto yy56;
yy651:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy652:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy657;
	if (yych <= '6') goto yy658;
	goto yy56;
yy657:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy659;
	goto yy56;
yy658:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy659:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy660;
	if (yych != ' ') goto yy56;
yy660:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy660;
		} else {
			if (yych == ' ') goto yy660;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy663;
		} else {
			if (yych != 'G') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy671;
	goto yy56;
yy663:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy664;
	if (yych <= '2') goto yy666;
	if (yych <= '9') goto yy667;
	goto yy56;
yy664:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy665;
	if (yych <= '9') goto yy667;
	if (yych <= ':') goto yy668;
yy665:
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy666:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy665;
		if (yych >= '5') goto yy669;
	} else {
		if (yych <= '9') goto yy670;
		if (yych <= ':') goto yy668;
		goto yy665;
	}
yy667:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy665;
	if (yych <= '5') goto yy669;
	if (yych <= '9') goto yy670;
	if (yych >= ';') goto yy665;
yy668:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy665;
	if (yych <= '5') goto yy669;
	if (yych <= '9') goto yy670;
	goto yy665;
yy669:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy665;
	if (yych >= ':') goto yy665;
yy670:
	yych = *++YYCURSOR;
	goto yy665;
yy671:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy663;
	if (yych == '-') goto yy663;
	goto yy56;
yy673:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy643;
	if (yych == 'v') goto yy643;
	goto yy56;
yy674:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy643;
	if (yych == 't') goto yy643;
	goto yy56;
yy675:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy676;
	if (yych != 'p') goto yy56;
yy676:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy644;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy643;
		if (yych == 't') goto yy643;
		goto yy56;
	}
yy677:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy643;
	if (yych == 'g') goto yy643;
	goto yy56;
yy678:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy643;
	if (yych == 'r') goto yy643;
	goto yy56;
yy679:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy643;
		if (yych <= 'X') goto yy56;
		goto yy643;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy643;
		} else {
			if (yych == 'y') goto yy643;
			goto yy56;
		}
	}
yy680:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy643;
	if (yych == 'b') goto yy643;
	goto yy56;
yy681:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy643;
		if (yych <= 'M') goto yy56;
		goto yy643;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy643;
		} else {
			if (yych == 'n') goto yy643;
			goto yy56;
		}
	}
yy682:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy643;
	if (yych == 'n') goto yy643;
	goto yy56;
yy683:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy692;
	goto yy56;
yy684:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy692;
	goto yy56;
yy685:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy692;
	goto yy56;
yy686:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy692;
	goto yy56;
yy687:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy631;
	if (yych >= ':') goto yy631;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy631;
	if (yych >= ':') goto yy631;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy631;
	if (yych >= ':') goto yy631;
	yych = *++YYCURSOR;
	goto yy631;
yy692:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy687;
	goto yy631;
yy693:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy695;
		goto yy542;
	} else {
		if (yych <= '-') goto yy696;
		if (yych <= '.') goto yy695;
		if (yych >= '0') goto yy542;
	}
yy694:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy637;
	case 'D':
	case 'd':	goto yy641;
	case 'F':
	case 'f':	goto yy635;
	case 'J':
	case 'j':	goto yy634;
	case 'M':
	case 'm':	goto yy636;
	case 'N':
	case 'n':	goto yy640;
	case 'O':
	case 'o':	goto yy639;
	case 'S':
	case 's':	goto yy638;
	default:	goto yy56;
	}
yy695:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy542;
	if (yych <= '0') goto yy700;
	if (yych <= '1') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy542;
yy696:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy542;
	if (yych <= '0') goto yy697;
	if (yych <= '1') goto yy698;
	if (yych <= '9') goto yy699;
	goto yy542;
yy697:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy566;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy699;
	goto yy56;
yy698:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy566;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy699:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy566;
	goto yy56;
yy700:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy566;
		goto yy703;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy702;
		goto yy56;
	}
yy701:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy566;
		goto yy703;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy702:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy566;
	if (yych >= '/') goto yy56;
yy703:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy575;
	goto yy56;
yy705:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy749;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy747;
	goto yy60;
yy706:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy715;
	case '1':	goto yy716;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy717;
	case 'A':
	case 'a':	goto yy710;
	case 'D':
	case 'd':	goto yy714;
	case 'F':
	case 'f':	goto yy708;
	case 'J':
	case 'j':	goto yy707;
	case 'M':
	case 'm':	goto yy709;
	case 'N':
	case 'n':	goto yy713;
	case 'O':
	case 'o':	goto yy712;
	case 'S':
	case 's':	goto yy711;
	default:	goto yy56;
	}
yy707:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy746;
		if (yych <= 'T') goto yy56;
		goto yy745;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy746;
		} else {
			if (yych == 'u') goto yy745;
			goto yy56;
		}
	}
yy708:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy744;
	if (yych == 'e') goto yy744;
	goto yy56;
yy709:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy743;
	if (yych == 'a') goto yy743;
	goto yy56;
yy710:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy742;
		if (yych <= 'T') goto yy56;
		goto yy741;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy742;
		} else {
			if (yych == 'u') goto yy741;
			goto yy56;
		}
	}
yy711:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy739;
	if (yych == 'e') goto yy739;
	goto yy56;
yy712:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy738;
	if (yych == 'c') goto yy738;
	goto yy56;
yy713:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy737;
	if (yych == 'o') goto yy737;
	goto yy56;
yy714:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy729;
	if (yych == 'e') goto yy729;
	goto yy56;
yy715:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy722;
	goto yy56;
yy716:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy722;
	goto yy56;
yy717:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy718:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy719;
	if (yych <= '3') goto yy720;
	if (yych <= '9') goto yy721;
	goto yy56;
yy719:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy721;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy720:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '1') goto yy721;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy721:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy625;
		goto yy621;
	} else {
		if (yych <= 'r') goto yy626;
		if (yych <= 's') goto yy624;
		if (yych <= 't') goto yy627;
		goto yy621;
	}
yy722:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy725;
	} else {
		if (yych <= '3') goto yy726;
		if (yych <= '9') goto yy721;
		goto yy56;
	}
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy727;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy725:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy727;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy726:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '1') goto yy727;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy727:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy625;
	} else {
		if (yych <= 'r') goto yy626;
		if (yych <= 's') goto yy624;
		if (yych <= 't') goto yy627;
	}
yy728:
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy729:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy730;
	if (yych != 'c') goto yy56;
yy730:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy731:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy732;
	if (yych <= '2') goto yy733;
	if (yych <= '3') goto yy734;
	goto yy56;
yy732:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy735;
	goto yy56;
yy733:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy735;
	goto yy56;
yy734:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy735:
	++YYCURSOR;
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy737:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy730;
	if (yych == 'v') goto yy730;
	goto yy56;
yy738:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy730;
	if (yych == 't') goto yy730;
	goto yy56;
yy739:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy740;
	if (yych != 'p') goto yy56;
yy740:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy731;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy730;
		if (yych == 't') goto yy730;
		goto yy56;
	}
yy741:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy730;
	if (yych == 'g') goto yy730;
	goto yy56;
yy742:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy730;
	if (yych == 'r') goto yy730;
	goto yy56;
yy743:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy730;
		if (yych <= 'X') goto yy56;
		goto yy730;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy730;
		} else {
			if (yych == 'y') goto yy730;
			goto yy56;
		}
	}
yy744:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy730;
	if (yych == 'b') goto yy730;
	goto yy56;
yy745:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy730;
		if (yych <= 'M') goto yy56;
		goto yy730;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy730;
		} else {
			if (yych == 'n') goto yy730;
			goto yy56;
		}
	}
yy746:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy730;
	if (yych == 'n') goto yy730;
	goto yy56;
yy747:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy755;
				} else {
					if (yych <= ' ') goto yy755;
					if (yych >= '-') goto yy752;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy756;
					if (yych <= '/') goto yy753;
					goto yy769;
				} else {
					if (yych <= '1') goto yy770;
					if (yych <= '2') goto yy772;
					goto yy773;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy54;
					if (yych <= ':') goto yy771;
				} else {
					if (yych <= 'A') goto yy755;
					if (yych >= 'D') goto yy755;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy755;
				} else {
					if (yych <= 'J') goto yy755;
					if (yych >= 'M') goto yy755;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy748;
					if (yych <= 'V') goto yy755;
					goto yy774;
				} else {
					if (yych <= 'Y') goto yy755;
					if (yych >= 'a') goto yy755;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy755;
				} else {
					if (yych != 'g') goto yy755;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy755;
				} else {
					if (yych <= 'o') goto yy755;
					if (yych >= 's') goto yy755;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy755;
				} else {
					if (yych <= 'y') goto yy755;
					if (yych == 0xC2) goto yy755;
				}
			}
		}
	}
yy748:
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy749:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy750;
	case '1':	goto yy751;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy717;
	case 'A':
	case 'a':	goto yy710;
	case 'D':
	case 'd':	goto yy714;
	case 'F':
	case 'f':	goto yy708;
	case 'J':
	case 'j':	goto yy707;
	case 'M':
	case 'm':	goto yy709;
	case 'N':
	case 'n':	goto yy713;
	case 'O':
	case 'o':	goto yy712;
	case 'S':
	case 's':	goto yy711;
	default:	goto yy56;
	}
yy750:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy717;
	goto yy56;
yy751:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy717;
	goto yy56;
yy752:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy937;
	case '1':	goto yy939;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy940;
	case 'A':
	case 'a':	goto yy931;
	case 'D':
	case 'd':	goto yy935;
	case 'F':
	case 'f':	goto yy929;
	case 'J':
	case 'j':	goto yy928;
	case 'M':
	case 'm':	goto yy930;
	case 'N':
	case 'n':	goto yy934;
	case 'O':
	case 'o':	goto yy933;
	case 'S':
	case 's':	goto yy932;
	case 'W':	goto yy936;
	default:	goto yy903;
	}
yy753:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy911;
	if (yych <= '1') goto yy912;
	if (yych <= '9') goto yy913;
	goto yy56;
yy754:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy755:
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy754;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy754;
					if (yych <= ',') goto yy56;
					goto yy902;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy764;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy768;
					if (yych == 'F') goto yy762;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy757;
					goto yy761;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy763;
					goto yy767;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy766;
					if (yych <= 'R') goto yy56;
					goto yy765;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy759;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy760;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy764;
					if (yych <= 'c') goto yy56;
					goto yy768;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy762;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy65;
					if (yych == 'j') goto yy761;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy763;
					if (yych <= 'n') goto yy767;
					goto yy766;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy765;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy756:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy903;
	if (yych <= '0') goto yy895;
	if (yych <= '2') goto yy896;
	if (yych <= '3') goto yy897;
	goto yy903;
yy757:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy894;
	} else {
		if (yych == 'W') goto yy758;
		if (yych <= 'X') goto yy848;
	}
yy758:
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy759:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy892;
	goto yy758;
yy760:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy891;
	goto yy758;
yy761:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy884;
		if (yych <= 'T') goto yy56;
		goto yy883;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy884;
		} else {
			if (yych == 'u') goto yy883;
			goto yy56;
		}
	}
yy762:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy877;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy100;
			if (yych <= 'Q') goto yy56;
			goto yy99;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy877;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy100;
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy763:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy874;
			if (yych <= 'H') goto yy56;
			goto yy138;
		} else {
			if (yych == 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy874;
			if (yych <= 'h') goto yy56;
			goto yy138;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy137;
			} else {
				if (yych == 's') goto yy139;
				goto yy56;
			}
		}
	}
yy764:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy868;
		if (yych <= 'T') goto yy56;
		goto yy867;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy868;
		} else {
			if (yych == 'u') goto yy867;
			goto yy56;
		}
	}
yy765:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy860;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy860;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy766:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy855;
	if (yych == 'c') goto yy855;
	goto yy56;
yy767:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy849;
	if (yych == 'o') goto yy849;
	goto yy56;
yy768:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy115;
		if (yych <= 'D') goto yy56;
		goto yy842;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy115;
		} else {
			if (yych == 'e') goto yy842;
			goto yy56;
		}
	}
yy769:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy839;
	if (yych <= '9') goto yy840;
	goto yy60;
yy770:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy808;
	if (yych <= '9') goto yy787;
	goto yy60;
yy771:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy788;
	if (yych <= '1') goto yy789;
	goto yy56;
yy772:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy787;
	goto yy60;
yy773:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy783;
	if (yych <= '6') goto yy784;
	if (yych <= '9') goto yy54;
	goto yy60;
yy774:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy775;
		if (yych <= '4') goto yy776;
		goto yy777;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy84;
		} else {
			if (yych == 'e') goto yy84;
			goto yy56;
		}
	}
yy775:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy778;
	goto yy56;
yy776:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy778;
	goto yy56;
yy777:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '4') goto yy56;
yy778:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy780;
	if (yych <= '/') goto yy779;
	if (yych <= '7') goto yy781;
yy779:
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy780:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy781:
	++YYCURSOR;
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy783:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy785;
	goto yy60;
yy784:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '6') goto yy785;
	if (yych <= '9') goto yy54;
	goto yy60;
yy785:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy60;
				} else {
					if (yych == 'W') goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy60;
				if (yych == 'd') goto yy60;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy60;
				} else {
					if (yych <= 'h') goto yy60;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy786;
				if (yych != 'v') goto yy60;
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
				}
			}
		}
	}
yy786:
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy787:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy785;
	goto yy60;
yy788:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy790;
	goto yy56;
yy789:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy790:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy792;
	if (yych <= '2') goto yy793;
	if (yych <= '3') goto yy794;
	goto yy56;
yy792:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy795;
	goto yy56;
yy793:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy795;
	goto yy56;
yy794:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy795:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy797;
	if (yych <= '2') goto yy798;
	goto yy56;
yy797:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy799;
	goto yy56;
yy798:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy799:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy804;
	if (yych <= '6') goto yy805;
	goto yy56;
yy804:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy806;
	goto yy56;
yy805:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy806:
	++YYCURSOR;
yy807:
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy808:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych >= '1') goto yy810;
	} else {
		if (yych <= '3') goto yy811;
		if (yych <= '9') goto yy785;
		goto yy60;
	}
yy809:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy786;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy786;
					goto yy812;
				} else {
					if (yych == 'D') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy786;
				if (yych <= 'H') goto yy60;
				goto yy786;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy786;
				} else {
					if (yych == 'V') goto yy786;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy786;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy786;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy786;
				} else {
					if (yych == 'v') goto yy786;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy786;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy786;
				}
			}
		}
	}
yy810:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy786;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy786;
					goto yy812;
				} else {
					if (yych == 'D') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy786;
				if (yych <= 'H') goto yy60;
				goto yy786;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy786;
				} else {
					if (yych == 'V') goto yy786;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy786;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy786;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy786;
				} else {
					if (yych == 'v') goto yy786;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy786;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy786;
				}
			}
		}
	}
yy811:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy786;
				goto yy60;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy786;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy786;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy786;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy786;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy786;
				} else {
					if (yych == 'V') goto yy786;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy786;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy786;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy786;
				} else {
					if (yych == 'v') goto yy786;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy786;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy786;
				}
			}
		}
	}
yy812:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy66;
				} else {
					if (yych == 'F') goto yy67;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych >= 'S') goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy814;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych >= 'f') goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy65;
				} else {
					if (yych == 'm') goto yy61;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy815;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych >= 'w') goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
				}
			}
		}
	}
yy813:
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy814:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy829;
			goto yy830;
		} else {
			if (yych <= '9') goto yy831;
			if (yych <= 'G') goto yy56;
			goto yy71;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy72;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy71;
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy815:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych >= '2') goto yy817;
		} else {
			if (yych <= '9') goto yy818;
			if (yych <= 'G') goto yy56;
			goto yy71;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy72;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy71;
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy823;
	if (yych <= '9') goto yy818;
	goto yy56;
yy817:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy823;
	if (yych <= '5') goto yy819;
	goto yy56;
yy818:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
yy819:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy820:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy821;
	if (yych <= '6') goto yy822;
	goto yy56;
yy821:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy806;
	goto yy56;
yy822:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy56;
yy823:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy824;
	if (yych <= '9') goto yy820;
	goto yy56;
yy824:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy825;
	if (yych <= '6') goto yy826;
	if (yych <= '9') goto yy820;
	goto yy56;
yy825:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy827;
	if (yych <= '6') goto yy828;
	if (yych <= '9') goto yy806;
	goto yy56;
yy826:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy827;
	if (yych <= '5') goto yy821;
	if (yych <= '6') goto yy822;
	goto yy56;
yy827:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy806;
	goto yy807;
yy828:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy807;
yy829:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy838;
	if (yych <= '9') goto yy831;
	if (yych <= ':') goto yy832;
	goto yy56;
yy830:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy838;
		goto yy819;
	} else {
		if (yych == ':') goto yy832;
		goto yy56;
	}
yy831:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy819;
	if (yych != ':') goto yy56;
yy832:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy836;
	if (yych <= '6') goto yy837;
	goto yy56;
yy836:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy806;
	goto yy56;
yy837:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy56;
yy838:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy824;
	if (yych <= '9') goto yy820;
	if (yych <= ':') goto yy832;
	goto yy56;
yy839:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy841;
		goto yy810;
	} else {
		if (yych <= '3') goto yy811;
		if (yych <= '9') goto yy785;
		goto yy60;
	}
yy840:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy809;
		goto yy810;
	} else {
		if (yych <= '3') goto yy811;
		if (yych <= '9') goto yy785;
		goto yy60;
	}
yy841:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy812;
	goto yy60;
yy842:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy843;
	if (yych != 'c') goto yy56;
yy843:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy844;
	if (yych != 'e') goto yy758;
yy844:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy845;
	if (yych != 'm') goto yy56;
yy845:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy846;
	if (yych != 'b') goto yy56;
yy846:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy847;
	if (yych != 'e') goto yy56;
yy847:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych != 'r') goto yy56;
yy848:
	yych = *++YYCURSOR;
	goto yy758;
yy849:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy850;
	if (yych != 'v') goto yy56;
yy850:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy851;
	if (yych != 'e') goto yy758;
yy851:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy852;
	if (yych != 'm') goto yy56;
yy852:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy853;
	if (yych != 'b') goto yy56;
yy853:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy854;
	if (yych != 'e') goto yy56;
yy854:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych == 'r') goto yy848;
	goto yy56;
yy855:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy856;
	if (yych != 't') goto yy56;
yy856:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy857;
	if (yych != 'o') goto yy758;
yy857:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy858;
	if (yych != 'b') goto yy56;
yy858:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy859;
	if (yych != 'e') goto yy56;
yy859:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych == 'r') goto yy848;
	goto yy56;
yy860:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy56;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy121;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy861:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy862;
	if (yych != 't') goto yy758;
yy862:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy863;
	if (yych != 'e') goto yy758;
yy863:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy864;
	if (yych != 'm') goto yy56;
yy864:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy865;
	if (yych != 'b') goto yy56;
yy865:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy866;
	if (yych != 'e') goto yy56;
yy866:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych == 'r') goto yy848;
	goto yy56;
yy867:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy871;
	if (yych == 'g') goto yy871;
	goto yy56;
yy868:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy869;
	if (yych != 'r') goto yy56;
yy869:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy870;
	if (yych != 'i') goto yy758;
yy870:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy848;
	if (yych == 'l') goto yy848;
	goto yy56;
yy871:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy872;
	if (yych != 'u') goto yy758;
yy872:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy873;
	if (yych != 's') goto yy56;
yy873:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy848;
	if (yych == 't') goto yy848;
	goto yy56;
yy874:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy875;
		if (yych <= 'X') goto yy56;
		goto yy848;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy848;
			goto yy56;
		}
	}
yy875:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy876;
	if (yych != 'c') goto yy758;
yy876:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy848;
	if (yych == 'h') goto yy848;
	goto yy56;
yy877:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy878;
	if (yych != 'b') goto yy56;
yy878:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy879;
	if (yych != 'r') goto yy758;
yy879:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy880;
	if (yych != 'u') goto yy56;
yy880:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy881;
	if (yych != 'a') goto yy56;
yy881:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy882;
	if (yych != 'r') goto yy56;
yy882:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy848;
	if (yych == 'y') goto yy848;
	goto yy56;
yy883:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy890;
		if (yych <= 'M') goto yy56;
		goto yy889;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy890;
		} else {
			if (yych == 'n') goto yy889;
			goto yy56;
		}
	}
yy884:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy885;
	if (yych != 'n') goto yy56;
yy885:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy886;
	if (yych != 'u') goto yy758;
yy886:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy887;
	if (yych != 'a') goto yy56;
yy887:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy888;
	if (yych != 'r') goto yy56;
yy888:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy848;
	if (yych == 'y') goto yy848;
	goto yy56;
yy889:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy848;
	if (yych == 'e') goto yy848;
	goto yy758;
yy890:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy848;
	if (yych == 'y') goto yy848;
	goto yy758;
yy891:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy848;
	goto yy758;
yy892:
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy758;
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy848;
	goto yy758;
yy894:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy848;
	goto yy758;
yy895:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy910;
	if (yych <= '9') goto yy909;
	goto yy56;
yy896:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy908;
	goto yy56;
yy897:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy906;
	if (yych <= '6') goto yy905;
	goto yy56;
yy898:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy877;
	if (yych == 'e') goto yy877;
	goto yy56;
yy899:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy874;
	if (yych == 'a') goto yy874;
	goto yy56;
yy900:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy904;
	if (yych == 'e') goto yy904;
	goto yy56;
yy901:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy842;
	if (yych == 'e') goto yy842;
	goto yy56;
yy902:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy903:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy902;
	case 'A':
	case 'a':	goto yy764;
	case 'D':
	case 'd':	goto yy901;
	case 'F':
	case 'f':	goto yy898;
	case 'I':	goto yy757;
	case 'J':
	case 'j':	goto yy761;
	case 'M':
	case 'm':	goto yy899;
	case 'N':
	case 'n':	goto yy767;
	case 'O':
	case 'o':	goto yy766;
	case 'S':
	case 's':	goto yy900;
	case 'V':	goto yy759;
	case 'X':	goto yy760;
	default:	goto yy56;
	}
yy904:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy861;
	if (yych == 'p') goto yy861;
	goto yy56;
yy905:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy907;
	goto yy56;
yy906:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy907:
	yych = *++YYCURSOR;
	goto yy786;
yy908:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy907;
	goto yy56;
yy909:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy907;
	goto yy56;
yy910:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy907;
	goto yy56;
yy911:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy914;
	if (yych <= '9') goto yy922;
	goto yy56;
yy912:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy914;
	if (yych <= '2') goto yy922;
	goto yy56;
yy913:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy914:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy915;
	if (yych <= '3') goto yy916;
	if (yych <= '9') goto yy917;
	goto yy56;
yy915:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '9') goto yy917;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy916:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '1') goto yy917;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy917:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy919;
		goto yy419;
	} else {
		if (yych <= 'r') goto yy920;
		if (yych <= 's') goto yy918;
		if (yych <= 't') goto yy921;
		goto yy419;
	}
yy918:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy418;
	goto yy56;
yy919:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy418;
	goto yy56;
yy920:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy418;
	goto yy56;
yy921:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy418;
	goto yy56;
yy922:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy925;
	} else {
		if (yych <= '3') goto yy926;
		if (yych <= '9') goto yy917;
		goto yy56;
	}
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '9') goto yy927;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy925:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '9') goto yy927;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy926:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '1') goto yy927;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy927:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy418;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy928:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1008;
		if (yych <= 'T') goto yy56;
		goto yy1007;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy1008;
		} else {
			if (yych == 'u') goto yy1007;
			goto yy56;
		}
	}
yy929:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1005;
	if (yych == 'e') goto yy1005;
	goto yy56;
yy930:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1002;
	if (yych == 'a') goto yy1002;
	goto yy56;
yy931:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy999;
		if (yych <= 'T') goto yy56;
		goto yy998;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy999;
		} else {
			if (yych == 'u') goto yy998;
			goto yy56;
		}
	}
yy932:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy995;
	if (yych == 'e') goto yy995;
	goto yy56;
yy933:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy993;
	if (yych == 'c') goto yy993;
	goto yy56;
yy934:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy991;
	if (yych == 'o') goto yy991;
	goto yy56;
yy935:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy989;
	if (yych == 'e') goto yy989;
	goto yy56;
yy936:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy775;
	if (yych <= '4') goto yy776;
	if (yych <= '5') goto yy777;
	goto yy56;
yy937:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy941;
	if (yych <= '/') goto yy938;
	if (yych <= '9') goto yy960;
yy938:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy939:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy941;
	if (yych <= '/') goto yy938;
	if (yych <= '2') goto yy960;
	goto yy938;
yy940:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy938;
yy941:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy942;
	if (yych <= '3') goto yy943;
	if (yych <= '9') goto yy944;
	goto yy56;
yy942:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy621;
			goto yy944;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy943:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy944:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy949;
		if (yych <= 'm') goto yy621;
		goto yy946;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy945:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy959;
	goto yy56;
yy946:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy959;
	goto yy56;
yy947:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy959;
	goto yy56;
yy948:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy959;
	goto yy56;
yy949:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy950;
	if (yych <= '2') goto yy951;
	if (yych <= '9') goto yy952;
	goto yy56;
yy950:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy952;
	if (yych <= ':') goto yy953;
	goto yy56;
yy951:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy952;
	if (yych == ':') goto yy953;
	goto yy56;
yy952:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy953:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy954;
	if (yych <= '9') goto yy955;
	goto yy56;
yy954:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy955;
	if (yych <= ':') goto yy956;
	goto yy56;
yy955:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy956:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy957;
	if (yych <= '6') goto yy958;
	if (yych <= '9') goto yy806;
	goto yy56;
yy957:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy806;
	goto yy807;
yy958:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy807;
yy959:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy949;
	goto yy621;
yy960:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy938;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy963;
	} else {
		if (yych <= '3') goto yy964;
		if (yych <= '9') goto yy944;
		goto yy56;
	}
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy621;
			goto yy965;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy963:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy621;
			goto yy965;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy964:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy965:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy966;
		if (yych <= 'm') goto yy419;
		goto yy946;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy419;
		}
	}
yy966:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy967;
	if (yych <= '2') goto yy968;
	if (yych <= '9') goto yy952;
	goto yy56;
yy967:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy969;
	if (yych <= ':') goto yy953;
	goto yy56;
yy968:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy969;
	if (yych == ':') goto yy953;
	goto yy56;
yy969:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy971;
	if (yych <= '9') goto yy955;
	goto yy56;
yy971:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy972;
	if (yych <= ':') goto yy956;
	goto yy56;
yy972:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy974;
	if (yych <= '6') goto yy975;
	if (yych <= '9') goto yy806;
	goto yy56;
yy974:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy976;
	goto yy807;
yy975:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy807;
yy976:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy807;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy978:
	yyaccept = 22;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy981;
		if (yych <= ',') goto yy807;
		goto yy981;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy807;
			goto yy978;
		} else {
			if (yych != 'G') goto yy807;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy987;
	goto yy56;
yy981:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy982;
	if (yych <= '2') goto yy983;
	if (yych <= '9') goto yy984;
	goto yy56;
yy982:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy984;
	if (yych <= ':') goto yy985;
	goto yy807;
yy983:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy807;
		if (yych >= '5') goto yy986;
	} else {
		if (yych <= '9') goto yy806;
		if (yych <= ':') goto yy985;
		goto yy807;
	}
yy984:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '5') goto yy986;
	if (yych <= '9') goto yy806;
	if (yych >= ';') goto yy807;
yy985:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '5') goto yy986;
	if (yych <= '9') goto yy806;
	goto yy807;
yy986:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy806;
	goto yy807;
yy987:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy981;
	if (yych == '-') goto yy981;
	goto yy56;
yy989:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy990;
	if (yych != 'c') goto yy56;
yy990:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy844;
		if (yych == 'e') goto yy844;
		goto yy758;
	}
yy991:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy992;
	if (yych != 'v') goto yy56;
yy992:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy851;
		if (yych == 'e') goto yy851;
		goto yy758;
	}
yy993:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy994;
	if (yych != 't') goto yy56;
yy994:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'O') goto yy857;
		if (yych == 'o') goto yy857;
		goto yy758;
	}
yy995:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy996;
	if (yych != 'p') goto yy56;
yy996:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'T') goto yy997;
		if (yych != 't') goto yy758;
	}
yy997:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy863;
		if (yych == 'e') goto yy863;
		goto yy758;
	}
yy998:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1001;
	if (yych == 'g') goto yy1001;
	goto yy56;
yy999:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1000;
	if (yych != 'r') goto yy56;
yy1000:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'I') goto yy870;
		if (yych == 'i') goto yy870;
		goto yy758;
	}
yy1001:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'U') goto yy872;
		if (yych == 'u') goto yy872;
		goto yy758;
	}
yy1002:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1003;
		if (yych <= 'X') goto yy56;
		goto yy1004;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy1004;
			goto yy56;
		}
	}
yy1003:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'C') goto yy876;
		if (yych == 'c') goto yy876;
		goto yy758;
	}
yy1004:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy731;
	goto yy758;
yy1005:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1006;
	if (yych != 'b') goto yy56;
yy1006:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'R') goto yy879;
		if (yych == 'r') goto yy879;
		goto yy758;
	}
yy1007:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1011;
		if (yych <= 'M') goto yy56;
		goto yy1010;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy1011;
		} else {
			if (yych == 'n') goto yy1010;
			goto yy56;
		}
	}
yy1008:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1009;
	if (yych != 'n') goto yy56;
yy1009:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'U') goto yy886;
		if (yych == 'u') goto yy886;
		goto yy758;
	}
yy1010:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy848;
		if (yych == 'e') goto yy848;
		goto yy758;
	}
yy1011:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'Y') goto yy848;
		if (yych == 'y') goto yy848;
		goto yy758;
	}
yy1012:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy542;
			goto yy695;
		} else {
			if (yych <= ',') goto yy542;
			if (yych <= '-') goto yy696;
			goto yy695;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy694;
			if (yych <= 'T') goto yy542;
			goto yy79;
		} else {
			if (yych == 'u') goto yy79;
			goto yy542;
		}
	}
yy1013:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy56;
		goto yy550;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy121;
		} else {
			if (yych == 'p') goto yy550;
			goto yy56;
		}
	}
yy1014:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1016;
			goto yy1018;
		} else {
			if (yych <= '-') goto yy1015;
			if (yych <= '.') goto yy695;
			if (yych <= '/') goto yy694;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy434;
			goto yy1018;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy1018;
		}
	}
yy1015:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1019;
	case '1':	goto yy1020;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy582;
	case 'A':
	case 'a':	goto yy586;
	case 'D':
	case 'd':	goto yy590;
	case 'F':
	case 'f':	goto yy584;
	case 'J':
	case 'j':	goto yy583;
	case 'M':
	case 'm':	goto yy585;
	case 'N':
	case 'n':	goto yy589;
	case 'O':
	case 'o':	goto yy588;
	case 'S':
	case 's':	goto yy587;
	default:	goto yy542;
	}
yy1016:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1018;
	if (yych <= '0') goto yy700;
	if (yych <= '1') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy1018;
yy1017:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1018:
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1017;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy1017;
					if (yych <= ',') goto yy56;
					goto yy541;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy538;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy430;
					if (yych == 'F') goto yy431;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy439;
					goto yy443;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy427;
					goto yy446;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy445;
					if (yych <= 'R') goto yy56;
					goto yy428;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy441;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy442;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy538;
					if (yych <= 'c') goto yy56;
					goto yy430;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy431;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy65;
					if (yych == 'j') goto yy443;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy427;
					if (yych <= 'n') goto yy446;
					goto yy445;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy428;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy1019:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy1021;
		goto yy56;
	}
yy1020:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy1021:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy1022;
	if (yych <= '.') goto yy566;
	goto yy56;
yy1022:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy1024;
	} else {
		if (yych <= '3') goto yy1025;
		if (yych <= '9') goto yy623;
		goto yy56;
	}
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy1026;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy1024:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy1026;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy1025:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
		} else {
			if (yych <= '9') goto yy568;
			if (yych <= 'm') goto yy621;
			goto yy625;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy1026:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy728;
		if (yych <= '9') goto yy569;
		if (yych <= 'm') goto yy728;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy728;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy728;
		}
	}
yy1027:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1016;
			if (yych <= ',') goto yy1018;
			goto yy1015;
		} else {
			if (yych <= '.') goto yy1028;
			if (yych <= '/') goto yy694;
			if (yych <= '5') goto yy1030;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1029;
			if (yych == 'n') goto yy434;
			goto yy1018;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy1018;
		}
	}
yy1028:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy542;
		if (yych <= '0') goto yy1052;
		goto yy1053;
	} else {
		if (yych <= '5') goto yy1054;
		if (yych <= '9') goto yy1055;
		goto yy542;
	}
yy1029:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1047;
	if (yych <= '9') goto yy1048;
	goto yy56;
yy1030:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy749;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy755;
				} else {
					if (yych <= ' ') goto yy755;
					if (yych >= '-') goto yy752;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy756;
					if (yych <= '/') goto yy753;
					goto yy1033;
				} else {
					if (yych <= '1') goto yy1034;
					if (yych <= '2') goto yy1035;
					goto yy1036;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy1037;
					if (yych <= '6') goto yy1038;
					goto yy54;
				} else {
					if (yych <= ':') goto yy771;
					if (yych >= 'A') goto yy755;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy755;
				} else {
					if (yych == 'G') goto yy1032;
					if (yych <= 'J') goto yy755;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy755;
					if (yych >= 'S') goto yy755;
				} else {
					if (yych <= 'W') goto yy774;
					if (yych <= 'Y') goto yy755;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy755;
					if (yych >= 'd') goto yy755;
				} else {
					if (yych == 'f') goto yy755;
					if (yych >= 'h') goto yy755;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy755;
				} else {
					if (yych <= 'o') goto yy755;
					if (yych >= 's') goto yy755;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy755;
				} else {
					if (yych <= 'y') goto yy755;
					if (yych == 0xC2) goto yy755;
				}
			}
		}
	}
yy1032:
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1033:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1045;
	if (yych <= '9') goto yy1046;
	goto yy60;
yy1034:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy1044;
	if (yych <= '9') goto yy1043;
	goto yy60;
yy1035:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1043;
	goto yy60;
yy1036:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy1041;
	if (yych <= '6') goto yy1042;
	if (yych <= '9') goto yy1039;
	goto yy60;
yy1037:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1039;
	goto yy60;
yy1038:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1039;
	if (yych <= '9') goto yy54;
	goto yy60;
yy1039:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy60;
				} else {
					if (yych == 'W') goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy60;
				if (yych == 'd') goto yy60;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy60;
				} else {
					if (yych <= 'h') goto yy60;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy1040;
				if (yych != 'v') goto yy60;
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
				}
			}
		}
	}
yy1040:
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1041:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1040;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1040;
					goto yy785;
				} else {
					if (yych == 'D') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1040;
				if (yych <= 'H') goto yy60;
				goto yy1040;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'V') goto yy1040;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1040;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1042:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1040;
				goto yy60;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1040;
					goto yy785;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy1040;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'V') goto yy1040;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1040;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1043:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1040;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1040;
					goto yy785;
				} else {
					if (yych == 'D') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1040;
				if (yych <= 'H') goto yy60;
				goto yy1040;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'V') goto yy1040;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1040;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1044:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1040;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy809;
					goto yy810;
				} else {
					if (yych <= '3') goto yy811;
					if (yych <= '9') goto yy785;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'G') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1040;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1040;
					if (yych <= 'U') goto yy60;
					goto yy1040;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1040;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1045:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1040;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy841;
					goto yy810;
				} else {
					if (yych <= '3') goto yy811;
					if (yych <= '9') goto yy785;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'G') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1040;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1040;
					if (yych <= 'U') goto yy60;
					goto yy1040;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1040;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1046:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1040;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy809;
					goto yy810;
				} else {
					if (yych <= '3') goto yy811;
					if (yych <= '9') goto yy785;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'G') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1040;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1040;
					if (yych <= 'U') goto yy60;
					goto yy1040;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1040;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1047:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1049;
		goto yy455;
	} else {
		if (yych <= '9') goto yy1048;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1048:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1049;
	if (yych != ':') goto yy455;
yy1049:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1050;
	if (yych <= '6') goto yy1051;
	if (yych <= '9') goto yy460;
	goto yy56;
yy1050:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy460;
	goto yy455;
yy1051:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych == '0') goto yy460;
	goto yy455;
yy1052:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy1056;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy1055;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1053:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		if (yych <= '.') goto yy1056;
		goto yy455;
	} else {
		if (yych <= '2') goto yy1055;
		if (yych <= '9') goto yy1048;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1054:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy1056;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy1048;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1055:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
	} else {
		if (yych == ':') goto yy1049;
		goto yy455;
	}
yy1056:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1057;
	if (yych <= '6') goto yy1058;
	if (yych <= '9') goto yy574;
	goto yy56;
yy1057:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy1059;
	goto yy455;
yy1058:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy461;
		goto yy455;
	} else {
		if (yych <= '0') goto yy1059;
		if (yych <= '9') goto yy575;
		goto yy455;
	}
yy1059:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy569;
	goto yy455;
yy1060:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy424;
			if (yych <= ',') goto yy426;
			goto yy1015;
		} else {
			if (yych <= '.') goto yy438;
			if (yych <= '/') goto yy436;
			if (yych <= '5') goto yy1030;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy447;
			if (yych == 'n') goto yy434;
			goto yy426;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy426;
		}
	}
yy1061:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1016;
			if (yych <= ',') goto yy1018;
			goto yy1015;
		} else {
			if (yych <= '.') goto yy1028;
			if (yych <= '/') goto yy436;
			if (yych <= '5') goto yy1030;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1029;
			if (yych == 'n') goto yy434;
			goto yy1018;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy1018;
		}
	}
yy1062:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1063;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1063:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy167;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'v') goto yy1064;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1064:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy168;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'i') goto yy1065;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1065:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy169;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'o') goto yy1066;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1066:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1067;
		if (yych != 'u') goto yy3;
	}
yy1067:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1068;
	if (yych != 's') goto yy56;
yy1068:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1069;
	if (yych != ' ') goto yy56;
yy1069:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1070:
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1069;
				if (yych <= 0x1F) goto yy56;
				goto yy1069;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy1076;
				} else {
					if (yych == 'F') goto yy1077;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1075;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy1071;
					if (yych <= 'R') goto yy56;
					goto yy1074;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1080;
					goto yy1073;
				} else {
					if (yych == 'W') goto yy1079;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1078;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy1076;
					if (yych <= 'e') goto yy56;
					goto yy1077;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy1075;
				} else {
					if (yych != 'm') goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1074;
					goto yy1080;
				} else {
					if (yych <= 'u') goto yy1073;
					if (yych <= 'v') goto yy56;
					goto yy1079;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy1078;
				} else {
					if (yych == 0xC2) goto yy1072;
					goto yy56;
				}
			}
		}
	}
yy1071:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy1155;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy1154;
			if (yych <= 'R') goto yy56;
			goto yy1156;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy1155;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy1154;
			if (yych == 's') goto yy1156;
			goto yy56;
		}
	}
yy1072:
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy1151;
	goto yy56;
yy1073:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1149;
	if (yych == 's') goto yy1149;
	goto yy56;
yy1074:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1136;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1137;
			if (yych <= 'T') goto yy56;
			goto yy1135;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1136;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1137;
			if (yych == 'u') goto yy1135;
			goto yy56;
		}
	}
yy1075:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1133;
	if (yych == 'o') goto yy1133;
	goto yy56;
yy1076:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1132;
	if (yych == 'a') goto yy1132;
	goto yy56;
yy1077:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1117;
		if (yych <= 'Q') goto yy56;
		goto yy1116;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy1117;
		} else {
			if (yych == 'r') goto yy1116;
			goto yy56;
		}
	}
yy1078:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1113;
	if (yych == 'e') goto yy1113;
	goto yy56;
yy1079:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1099;
	if (yych == 'e') goto yy1099;
	goto yy56;
yy1080:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1081;
		if (yych <= 'T') goto yy56;
		goto yy1082;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy1082;
			goto yy56;
		}
	}
yy1081:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1094;
	if (yych == 'u') goto yy1094;
	goto yy56;
yy1082:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1083;
	if (yych != 'e') goto yy56;
yy1083:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych >= ' ') goto yy1085;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1087;
		} else {
			if (yych == 's') goto yy1087;
		}
	}
yy1084:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1085:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy56;
		goto yy1085;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1091;
		} else {
			if (yych == 'o') goto yy1091;
			goto yy56;
		}
	}
yy1087:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1088;
	if (yych != 'd') goto yy56;
yy1088:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1089;
	if (yych != 'a') goto yy56;
yy1089:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych != 'y') goto yy56;
yy1090:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1085;
	if (yych == ' ') goto yy1085;
	goto yy1084;
yy1091:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1092;
	if (yych != 'f') goto yy56;
yy1092:
	++YYCURSOR;
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
yy1094:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1084;
		} else {
			if (yych != 'r') goto yy1084;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1096;
	if (yych != 's') goto yy56;
yy1096:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1097;
	if (yych != 'd') goto yy56;
yy1097:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1098;
	if (yych != 'a') goto yy56;
yy1098:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1099:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1101;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1101;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1107;
	if (yych == 'k') goto yy1107;
	goto yy56;
yy1101:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1084;
		} else {
			if (yych != 'n') goto yy1084;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1103;
	if (yych != 'e') goto yy56;
yy1103:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1104;
	if (yych != 's') goto yy56;
yy1104:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1105;
	if (yych != 'd') goto yy56;
yy1105:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1106;
	if (yych != 'a') goto yy56;
yy1106:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1107:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1110;
		if (yych >= 'S') goto yy1109;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1110;
		} else {
			if (yych == 's') goto yy1109;
		}
	}
yy1108:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1109:
	yych = *++YYCURSOR;
	goto yy1084;
yy1110:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1111;
	if (yych != 'a') goto yy56;
yy1111:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1112;
	if (yych != 'y') goto yy56;
yy1112:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1109;
	if (yych == 's') goto yy1109;
	goto yy1084;
yy1113:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1114;
	if (yych != 'a') goto yy56;
yy1114:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1115;
	if (yych != 'r') goto yy56;
yy1115:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1109;
	if (yych == 's') goto yy1109;
	goto yy1084;
yy1116:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1129;
	if (yych == 'i') goto yy1129;
	goto yy56;
yy1117:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1118;
	if (yych != 'r') goto yy56;
yy1118:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1119;
	if (yych != 't') goto yy56;
yy1119:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1121;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1121;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1126;
	if (yych == 'i') goto yy1126;
	goto yy56;
yy1121:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1122;
	if (yych != 'n') goto yy56;
yy1122:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1123;
	if (yych != 'i') goto yy56;
yy1123:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1124;
	if (yych != 'g') goto yy56;
yy1124:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1125;
	if (yych != 'h') goto yy56;
yy1125:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1115;
	if (yych == 't') goto yy1115;
	goto yy56;
yy1126:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1127;
	if (yych != 'g') goto yy56;
yy1127:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1128;
	if (yych != 'h') goto yy56;
yy1128:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1115;
	if (yych == 't') goto yy1115;
	goto yy56;
yy1129:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1084;
		} else {
			if (yych != 'd') goto yy1084;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1131;
	if (yych != 'a') goto yy56;
yy1131:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1132:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1115;
	if (yych == 'y') goto yy1115;
	goto yy56;
yy1133:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1134;
	if (yych != 'u') goto yy56;
yy1134:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1115;
	if (yych == 'r') goto yy1115;
	goto yy56;
yy1135:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1146;
	if (yych == 'n') goto yy1146;
	goto yy56;
yy1136:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1141;
	if (yych == 't') goto yy1141;
	goto yy56;
yy1137:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1138;
	if (yych != 'c') goto yy56;
yy1138:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1139;
		if (yych <= 'R') goto yy1084;
		goto yy1109;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1084;
		} else {
			if (yych == 's') goto yy1109;
			goto yy1084;
		}
	}
yy1139:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1140;
	if (yych != 'n') goto yy56;
yy1140:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1115;
	if (yych == 'd') goto yy1115;
	goto yy56;
yy1141:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1084;
		} else {
			if (yych != 'u') goto yy1084;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1143;
	if (yych != 'r') goto yy56;
yy1143:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1144;
	if (yych != 'd') goto yy56;
yy1144:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1145;
	if (yych != 'a') goto yy56;
yy1145:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1146:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1084;
		} else {
			if (yych != 'd') goto yy1084;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1148;
	if (yych != 'a') goto yy56;
yy1148:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1149:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1150;
	if (yych != 'e') goto yy56;
yy1150:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1115;
	if (yych == 'c') goto yy1115;
	goto yy56;
yy1151:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1152;
	if (yych != 's') goto yy56;
yy1152:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1153;
	if (yych != 'e') goto yy1084;
yy1153:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1115;
	if (yych == 'c') goto yy1115;
	goto yy56;
yy1154:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1177;
	if (yych == 'n') goto yy1177;
	goto yy56;
yy1155:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1159;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy1158;
			if (yych <= 'M') goto yy56;
			goto yy1160;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1159;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy1158;
			if (yych == 'n') goto yy1160;
			goto yy56;
		}
	}
yy1156:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1157;
	if (yych != 'e') goto yy1084;
yy1157:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1115;
	if (yych == 'c') goto yy1115;
	goto yy56;
yy1158:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1170;
	if (yych == 'l') goto yy1170;
	goto yy56;
yy1159:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1163;
	if (yych == 'r') goto yy1163;
	goto yy56;
yy1160:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1109;
		if (yych <= 'T') goto yy1084;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1084;
			goto yy1109;
		} else {
			if (yych != 'u') goto yy1084;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1162;
	if (yych != 't') goto yy56;
yy1162:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1115;
	if (yych == 'e') goto yy1115;
	goto yy56;
yy1163:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1164;
	if (yych != 'o') goto yy56;
yy1164:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1165;
	if (yych != 's') goto yy56;
yy1165:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1166;
	if (yych != 'e') goto yy56;
yy1166:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1167;
	if (yych != 'c') goto yy56;
yy1167:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1168;
	if (yych != 'o') goto yy56;
yy1168:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1169;
	if (yych != 'n') goto yy56;
yy1169:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1115;
	if (yych == 'd') goto yy1115;
	goto yy56;
yy1170:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1171;
	if (yych != 'i') goto yy56;
yy1171:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1172;
	if (yych != 's') goto yy56;
yy1172:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1173;
	if (yych != 'e') goto yy56;
yy1173:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1174;
	if (yych != 'c') goto yy56;
yy1174:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1175;
	if (yych != 'o') goto yy56;
yy1175:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1176;
	if (yych != 'n') goto yy56;
yy1176:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1115;
	if (yych == 'd') goto yy1115;
	goto yy56;
yy1177:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1085;
			goto yy1084;
		} else {
			if (yych <= ' ') goto yy1085;
			if (yych <= 'C') goto yy1084;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1179;
			goto yy1084;
		} else {
			if (yych <= 'd') goto yy1178;
			if (yych == 't') goto yy1179;
			goto yy1084;
		}
	}
yy1178:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1180;
	if (yych == 'a') goto yy1180;
	goto yy56;
yy1179:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1115;
	if (yych == 'h') goto yy1115;
	goto yy56;
yy1180:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1181:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1063;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1182;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1182:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1064;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'v') goto yy1183;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1183:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1065;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'i') goto yy1184;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1184:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1066;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'o') goto yy1185;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1185:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1067;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1186;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1186:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1068;
	if (yych != 's') goto yy179;
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1069;
		} else {
			if (yych == ' ') goto yy1069;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy56;
		}
	}
yy1188:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy166;
			goto yy1202;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'g') goto yy1202;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1189:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1190;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1190:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy167;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'v') goto yy1191;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1191:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy1192;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1192:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy169;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'n') goto yy1193;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1193:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1194;
		if (yych != 't') goto yy3;
	}
yy1194:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1195;
	if (yych != 'h') goto yy56;
yy1195:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1196;
	if (yych != ' ') goto yy56;
yy1196:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1197:
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1196;
				if (yych <= 0x1F) goto yy56;
				goto yy1196;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy1076;
				} else {
					if (yych == 'F') goto yy1077;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1075;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy1071;
					if (yych <= 'R') goto yy56;
					goto yy1074;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1080;
					goto yy1073;
				} else {
					if (yych != 'W') goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1078;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy1076;
					if (yych <= 'e') goto yy56;
					goto yy1077;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy1075;
				} else {
					if (yych == 'm') goto yy1071;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1074;
					goto yy1080;
				} else {
					if (yych <= 'u') goto yy1073;
					if (yych <= 'v') goto yy56;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy1078;
				} else {
					if (yych == 0xC2) goto yy1072;
					goto yy56;
				}
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1199;
	if (yych != 'e') goto yy56;
yy1199:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1101;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1101;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1201;
	if (yych != 'k') goto yy56;
yy1201:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1110;
		if (yych <= 'R') goto yy56;
		goto yy1109;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy1110;
		} else {
			if (yych == 's') goto yy1109;
			goto yy56;
		}
	}
yy1202:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy167;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'h') goto yy1203;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1203:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1204;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1204:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1196;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1196;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1205;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1205;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1205:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1196;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1196;
		if (yych == ')') goto yy164;
		goto yy3;
	}
yy1206:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1202;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'g') goto yy1214;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1207:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1190;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1208;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1208:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1191;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'v') goto yy1209;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1209:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1192;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1210;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1210:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1193;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'n') goto yy1211;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1211:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1194;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 't') goto yy1212;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1212:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1195;
	if (yych != 'h') goto yy179;
yy1213:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1196;
		} else {
			if (yych == ' ') goto yy1196;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy56;
		}
	}
yy1214:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1203;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'h') goto yy1215;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1215:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1204;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1216;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1216:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1196;
			} else {
				if (yych == ' ') goto yy1196;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy172;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy169;
			} else {
				if (yych <= 'H') goto yy1205;
				if (yych <= 'Z') goto yy169;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'h') goto yy1217;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1217:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1196;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1196;
			if (yych <= '(') goto yy3;
			goto yy164;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy172;
			goto yy3;
		} else {
			if (yych <= '/') goto yy172;
			if (yych == '_') goto yy172;
			goto yy3;
		}
	}
yy1218:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1234;
				goto yy166;
			} else {
				if (yych <= 'P') goto yy1236;
				if (yych <= 'U') goto yy166;
				goto yy1235;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1234;
				goto yy166;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1236;
				goto yy166;
			} else {
				if (yych <= 'v') goto yy1235;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy1219:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy166;
			goto yy1229;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 't') goto yy1229;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1220:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy166;
			goto yy1226;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'x') goto yy1226;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1221:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1222;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1222:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1223;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1223:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1224;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1224:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1225;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1225:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy164;
	goto yy191;
yy1226:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1227;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1227:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1228:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1196;
		} else {
			if (yych == ' ') goto yy1196;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1229:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'T') goto yy167;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'u') goto yy1230;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1230:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'r') goto yy1231;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1231:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1232;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1232:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1233;
		if (yych != 'a') goto yy3;
	}
yy1233:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy1234:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy167;
			goto yy1245;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'o') goto yy1245;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1235:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy167;
			goto yy1242;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'e') goto yy1242;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1236:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'T') goto yy167;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 't') goto yy1237;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1237:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'E') goto yy168;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy168;
			} else {
				if (yych <= 'e') goto yy1238;
				if (yych <= 'z') goto yy168;
				goto yy218;
			}
		}
	}
yy1238:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy169;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'm') goto yy1239;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1239:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1240;
		if (yych != 'b') goto yy3;
	}
yy1240:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1241;
	if (yych != 'e') goto yy56;
yy1241:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy229;
	goto yy56;
yy1242:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy168;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'n') goto yy1243;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1243:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy1244;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1244:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1195;
		if (yych == 'h') goto yy1195;
		goto yy3;
	}
yy1245:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy168;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'n') goto yy1246;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1246:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
			goto yy1205;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1205;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1247:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy172;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy166;
				goto yy1234;
			} else {
				if (yych == 'P') goto yy1236;
				goto yy166;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1235;
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy171;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1263;
				if (yych <= 'o') goto yy171;
				goto yy1265;
			} else {
				if (yych == 'v') goto yy1264;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1248:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1229;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 't') goto yy1258;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1249:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1226;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'x') goto yy1255;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1250:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1222;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1251;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1251:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1223;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1252;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1252:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1224;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1253;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1253:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1225;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1254;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1254:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy164;
		if (yych <= ',') goto yy191;
		goto yy172;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy191;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy191;
		}
	}
yy1255:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1227;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1256;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1256:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1257:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1196;
			if (yych <= 0x1F) goto yy3;
			goto yy1196;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1258:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1230;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy1259;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1259:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1231;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'r') goto yy1260;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1260:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1232;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1261;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1261:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1233;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1262;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1262:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy1263:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1245;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1274;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1264:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1242;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy1271;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1265:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'T') goto yy1237;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1266;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1266:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy168;
			} else {
				if (yych <= 'E') goto yy1238;
				if (yych <= 'Z') goto yy168;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1267;
				if (yych <= 'z') goto yy176;
				goto yy218;
			}
		}
	}
yy1267:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1239;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'm') goto yy1268;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1268:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1240;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1269;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1269:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1241;
	if (yych != 'e') goto yy179;
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy341;
	goto yy179;
yy1271:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1243;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'n') goto yy1272;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1272:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1244;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy1273;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1273:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1195;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1213;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1274:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1246;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'n') goto yy1275;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1275:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1205;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1217;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1276:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'c') goto yy1277;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1277:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy167;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'k') goto yy1278;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1278:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1279;
		if (yych <= '(') goto yy3;
		goto yy164;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1279:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1280;
	if (yych != 'o') goto yy56;
yy1280:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1281;
	if (yych != 'f') goto yy56;
yy1281:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1283;
	if (yych <= '2') goto yy1285;
	if (yych <= '9') goto yy1286;
	goto yy56;
yy1283:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1287;
	if (yych <= '9') goto yy1286;
	goto yy1287;
yy1284:
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1285:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1287;
	if (yych >= '5') goto yy1287;
yy1286:
	yyaccept = 27;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1287:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1286;
			goto yy1284;
		} else {
			if (yych <= ' ') goto yy1286;
			if (yych <= '@') goto yy1284;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1284;
		} else {
			if (yych <= 'a') goto yy1288;
			if (yych != 'p') goto yy1284;
		}
	}
yy1288:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1290;
		if (yych == 'm') goto yy1290;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1290;
	if (yych != 'm') goto yy56;
yy1290:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1292;
		if (yych == '\t') goto yy1292;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1292;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1292;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy1292:
	yych = *++YYCURSOR;
	goto yy1284;
yy1293:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1277;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'c') goto yy1294;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1294:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1278;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'k') goto yy1295;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1295:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1279;
			goto yy3;
		} else {
			if (yych <= ')') goto yy164;
			if (yych == '-') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy172;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1296:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy166;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 's') goto yy1297;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1297:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1298;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1298:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1069;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1299:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1300;
	if (yych != 'd') goto yy1070;
yy1300:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1301;
	if (yych != 'a') goto yy56;
yy1301:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1302;
	if (yych != 'y') goto yy56;
yy1302:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1084;
	} else {
		if (yych <= 'S') goto yy1109;
		if (yych == 's') goto yy1109;
		goto yy1084;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1304;
	if (yych != 'o') goto yy56;
yy1304:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1305;
	if (yych != 'f') goto yy56;
yy1305:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1307:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1297;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 's') goto yy1308;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1308:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1298;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1309;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1309:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1069;
			if (yych <= 0x1F) goto yy3;
			goto yy1299;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1310:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy166;
			goto yy1346;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'b') goto yy1346;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1311:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1336;
			if (yych <= 'Q') goto yy166;
			goto yy1335;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy166;
			goto yy1336;
		} else {
			if (yych == 'r') goto yy1335;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1312:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy166;
			goto yy1332;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'u') goto yy1332;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1313:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1315;
			if (yych <= 'N') goto yy166;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy166;
			goto yy1315;
		} else {
			if (yych == 'o') goto yy1314;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1314:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
			goto yy1318;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1318;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1315:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1316;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1316:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1317;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1317:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
			goto yy1225;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1225;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1318:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1319;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1319:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1320;
		if (yych <= '(') goto yy3;
		goto yy164;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1320:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1321;
	if (yych != 'o') goto yy56;
yy1321:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1322;
	if (yych != 'f') goto yy56;
yy1322:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1324;
	if (yych <= '2') goto yy1325;
	if (yych <= '9') goto yy1326;
	goto yy56;
yy1324:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1327;
	if (yych <= '9') goto yy1326;
	goto yy1327;
yy1325:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1327;
	if (yych >= '5') goto yy1327;
yy1326:
	yyaccept = 27;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1327:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1326;
			goto yy1284;
		} else {
			if (yych <= ' ') goto yy1326;
			if (yych <= '@') goto yy1284;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1284;
		} else {
			if (yych <= 'a') goto yy1328;
			if (yych != 'p') goto yy1284;
		}
	}
yy1328:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1330;
		if (yych == 'm') goto yy1330;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1330;
	if (yych != 'm') goto yy56;
yy1330:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1292;
		if (yych == '\t') goto yy1292;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1292;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1292;
		if (yych <= 0x08) goto yy56;
		goto yy1292;
	} else {
		if (yych == ' ') goto yy1292;
		goto yy56;
	}
yy1332:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy167;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1333;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1333:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1334;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1334:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy169;
			goto yy1205;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'h') goto yy1205;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1335:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy167;
			goto yy1338;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 's') goto yy1338;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1336:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1337;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1337:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1338:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1339;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1339:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1196;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1340:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1341;
	if (yych != 'd') goto yy1197;
yy1341:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1342;
	if (yych != 'a') goto yy56;
yy1342:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1343;
	if (yych != 'y') goto yy56;
yy1343:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1084;
	} else {
		if (yych <= 'S') goto yy1109;
		if (yych == 's') goto yy1109;
		goto yy1084;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1345;
	if (yych != 'o') goto yy56;
yy1345:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1305;
	if (yych == 'f') goto yy1305;
	goto yy56;
yy1346:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'R') goto yy167;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'r') goto yy1347;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1347:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy168;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'u') goto yy1348;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1348:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1349;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1349:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1350;
		if (yych != 'r') goto yy3;
	}
yy1350:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy229;
	if (yych == 'y') goto yy229;
	goto yy56;
yy1351:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1346;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'b') goto yy1369;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1352:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1336;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1335;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1365;
				goto yy171;
			} else {
				if (yych <= 'r') goto yy1364;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1353:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1332;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'u') goto yy1361;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1354:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1315;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1314;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1356;
				goto yy171;
			} else {
				if (yych <= 'o') goto yy1355;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1355:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1318;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1359;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1356:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1316;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1357;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1357:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1317;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1358;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1358:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1225;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1254;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1359:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1319;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1360;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1360:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1320;
			goto yy3;
		} else {
			if (yych <= ')') goto yy164;
			if (yych == '-') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy172;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1361:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1333;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1362;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1362:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1334;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1363;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1363:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1205;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'h') goto yy1217;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1364:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1338;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 's') goto yy1367;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1365:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1337;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1366;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1366:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1367:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1339;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1368;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1368:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1196;
			if (yych <= 0x1F) goto yy3;
			goto yy1340;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1369:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'R') goto yy1347;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1370;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1370:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1348;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'u') goto yy1371;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1371:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1349;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1372;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1372:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1350;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1373;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1373:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy229;
	if (yych == 'y') goto yy341;
	goto yy179;
yy1374:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1375:
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '.') goto yy1378;
	if (yych <= '/') goto yy1377;
	if (yych <= '9') goto yy1375;
yy1377:
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1378:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		timelib_ull i, ms;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		ms = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->relative.f = ((double) ms) / 1000000.0;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1386:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
			goto yy1427;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1427;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1387:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1419;
			if (yych <= 'T') goto yy166;
			goto yy1420;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy166;
			goto yy1419;
		} else {
			if (yych == 'u') goto yy1420;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1388:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1408;
			if (yych <= 'L') goto yy166;
			goto yy1409;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy166;
			goto yy1408;
		} else {
			if (yych == 'm') goto yy1409;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1389:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
			goto yy1404;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1404;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1390:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
			goto yy1400;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1400;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1391:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1029;
		goto yy56;
	} else {
		if (yych <= '9') goto yy1394;
		if (yych <= ':') goto yy1029;
		goto yy56;
	}
yy1392:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1029;
		goto yy56;
	} else {
		if (yych <= '4') goto yy1394;
		if (yych == ':') goto yy1029;
		goto yy56;
	}
yy1393:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1029;
	if (yych == ':') goto yy1029;
	goto yy56;
yy1394:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1029;
		goto yy56;
	} else {
		if (yych <= '5') goto yy1395;
		if (yych == ':') goto yy1029;
		goto yy56;
	}
yy1395:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1032;
	if (yych <= '5') goto yy1397;
	if (yych <= '6') goto yy1398;
	goto yy1032;
yy1397:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1399;
	goto yy56;
yy1398:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy1399:
	yych = *++YYCURSOR;
	goto yy1040;
yy1400:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy167;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'l') goto yy1401;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1401:
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy168;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'f') goto yy1402;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1402:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy1403;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1403:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1195;
		if (yych == 'h') goto yy1195;
		goto yy3;
	}
yy1404:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'R') goto yy167;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 's') goto yy1405;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1405:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy1406;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1406:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1407;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1407:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy197;
		if (yych == 'y') goto yy197;
		goto yy3;
	}
yy1408:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1416;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy167;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1416;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1409:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy167;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'o') goto yy1410;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1410:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'r') goto yy1411;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1411:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy1412;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1412:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1413;
		if (yych != 'o') goto yy3;
	}
yy1413:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1414;
	if (yych != 'w') goto yy56;
yy1414:
	++YYCURSOR;
yy1415:
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1416:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy168;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'y') goto yy1417;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1417:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy169;
		if (yych <= '`') goto yy1418;
		if (yych <= 'z') goto yy169;
	}
yy1418:
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1419:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy167;
			if (yych <= 'R') goto yy1425;
			goto yy1426;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1425;
			if (yych <= 's') goto yy1426;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1420:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'Q') goto yy167;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1421;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1421:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy168;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 's') goto yy1422;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1422:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1423;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1423:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1424;
		if (yych != 'a') goto yy3;
	}
yy1424:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy1425:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1426:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1069;
		} else {
			if (yych == ' ') goto yy1069;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1427:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1428;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1428:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1429:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1427;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1459;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1430:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1419;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1420;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1451;
				goto yy171;
			} else {
				if (yych <= 'u') goto yy1452;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1431:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1408;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1409;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1442;
				goto yy171;
			} else {
				if (yych <= 'm') goto yy1443;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1432:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1404;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1438;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1433:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1400;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1434;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1434:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1401;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'l') goto yy1435;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1435:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1402;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'f') goto yy1436;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1436:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1403;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy1437;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1437:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1195;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1213;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1438:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1405;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 's') goto yy1439;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1439:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1406;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy1440;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1440:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1407;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1441;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1441:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy197;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy210;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1442:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1416;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1449;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy1443:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1410;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1444;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1444:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1411;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'r') goto yy1445;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1445:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1412;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy1446;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1446:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1413;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1447;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1447:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1414;
	if (yych != 'w') goto yy179;
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1415;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1415;
	}
yy1449:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1417;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'y') goto yy1450;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1450:
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1418;
		} else {
			if (yych == '.') goto yy1418;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1418;
			if (yych <= 'Z') goto yy169;
			goto yy1418;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1418;
			if (yych <= 'z') goto yy177;
			goto yy1418;
		}
	}
yy1451:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy172;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy167;
				goto yy1425;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1426;
				goto yy167;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy175;
				goto yy1457;
			} else {
				if (yych <= 's') goto yy1458;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1452:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1421;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1453;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1453:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1422;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 's') goto yy1454;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1454:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1423;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1455;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1455:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1424;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1456;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1456:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy1457:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1458:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1069;
			if (yych <= 0x1F) goto yy3;
			goto yy1069;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1459:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1428;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1460;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1460:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1461:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1473;
			if (yych <= 'X') goto yy166;
			goto yy1474;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy166;
			goto yy1473;
		} else {
			if (yych == 'y') goto yy1474;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1462:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy166;
			goto yy1467;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'd') goto yy1467;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1463:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1464;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1464:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1465;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1465:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1466;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1466:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
			goto yy1225;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1225;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1467:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1468;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1468:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy168;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'i') goto yy1469;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1469:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy169;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'g') goto yy1470;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1470:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1471;
		if (yych != 'h') goto yy3;
	}
yy1471:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1472;
	if (yych != 't') goto yy56;
yy1472:
	yych = *++YYCURSOR;
	goto yy1418;
yy1473:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych == 'C') goto yy1475;
				goto yy167;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'c') goto yy1475;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1474:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy218;
			goto yy221;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy167;
			goto yy218;
		}
	}
yy1475:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy360;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy360;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1476:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1473;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1474;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1488;
				goto yy171;
			} else {
				if (yych <= 'y') goto yy1489;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1477:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1467;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'd') goto yy1482;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1478:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1464;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1479;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1479:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1465;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1480;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1480:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1466;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1481;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1481:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1225;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1254;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1482:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1468;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1483;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1483:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1469;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'i') goto yy1484;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1484:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1470;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'g') goto yy1485;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1485:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1471;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1486;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1486:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1472;
	if (yych != 't') goto yy179;
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1418;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1418;
	}
yy1488:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'C') goto yy1475;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'c') goto yy1490;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1489:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy336;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy167;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1490:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy360;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy371;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1491:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'O') goto yy1499;
			if (yych <= 'U') goto yy166;
			if (yych <= 'V') goto yy1500;
			goto yy1497;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy166;
			goto yy1499;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy166;
				goto yy1500;
			} else {
				if (yych <= 'w') goto yy1497;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy1492:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy166;
			goto yy1496;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'x') goto yy1496;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1493:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1494;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1494:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1495;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1495:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1496:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
			goto yy1426;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1426;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1497:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy1498;
		if (yych <= 'z') goto yy167;
	}
yy1498:
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1499:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
			goto yy1505;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1505;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1500:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'E') goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'e') goto yy1501;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1501:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy168;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'm') goto yy1502;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1502:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy169;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'b') goto yy1503;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1503:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1504;
		if (yych != 'e') goto yy3;
	}
yy1504:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy229;
	goto yy56;
yy1505:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy168;
		if (yych <= '`') goto yy1506;
		if (yych <= 'z') goto yy168;
	}
yy1506:
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1507:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy172;
				if (yych <= '@') goto yy3;
				goto yy166;
			} else {
				if (yych <= 'O') goto yy1499;
				if (yych <= 'U') goto yy166;
				goto yy1500;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1497;
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy171;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1514;
				if (yych <= 'u') goto yy171;
				goto yy1515;
			} else {
				if (yych <= 'w') goto yy1513;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1508:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1496;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'x') goto yy1512;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1509:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1494;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1510;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1510:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1495;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1511;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1511:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1512:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1426;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1458;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1513:
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1498;
		} else {
			if (yych == '.') goto yy1498;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1498;
			if (yych <= 'Z') goto yy167;
			goto yy1498;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1498;
			if (yych <= 'z') goto yy175;
			goto yy1498;
		}
	}
yy1514:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1505;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1520;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1515:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy1501;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy1516;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1516:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1502;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'm') goto yy1517;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1517:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1503;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'b') goto yy1518;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1518:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1504;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1519;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1519:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy341;
	goto yy179;
yy1520:
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1506;
		} else {
			if (yych == '.') goto yy1506;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1506;
			if (yych <= 'Z') goto yy168;
			goto yy1506;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1506;
			if (yych <= 'z') goto yy176;
			goto yy1506;
		}
	}
yy1521:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy166;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 's') goto yy1522;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1522:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1523;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1523:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy1524;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1524:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy1525;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1525:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1526;
		if (yych != 'd') goto yy3;
	}
yy1526:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1527;
	if (yych != 'a') goto yy56;
yy1527:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1528;
	if (yych != 'y') goto yy56;
yy1528:
	++YYCURSOR;
yy1529:
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1530:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1522;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 's') goto yy1531;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1531:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1523;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1532;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1532:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1524;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1533;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1533:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1525;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy1534;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1534:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1526;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1535;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1535:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1527;
	if (yych != 'a') goto yy179;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1528;
	if (yych != 'y') goto yy179;
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1529;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1529;
	}
}

}

#define YYMAXFILL 33

timelib_time* timelib_strtotime(char *s, size_t len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->f == TIMELIB_UNSET) parsed->f = 0;
	} else {
		if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
