<?php
    /*
     * dumpit5.php
     *
     * a command-line script which dumps the given HTML, PHP, ASP, XHTML, etc.
     * file as it is represented in the document model.
     *
     * NOTE: Only works with tidy for PHP 5+, for tidy in 4.3.x, see dumpit.php
     *
     * By: John Coggeshall <john@php.net>
     *
     * Usage; php dumpit5.php <filename>
     */

    $tidy = tidy_parse_file($_SERVER['argv'][1]);

    /* Optionally you can do this here if you want to fix up the document */

    /* $tidy->clean_repair() */

    $tree = $tidy->root();
    dump_tree($tree);
    echo "\n";

    function node_type($type) {

        switch($type) {

            case TIDY_NODETYPE_ROOT: return "Root Node";
            case TIDY_NODETYPE_DOCTYPE: return "DocType Node";
            case TIDY_NODETYPE_COMMENT: return "Comment Node";
            case TIDY_NODETYPE_PROCINS: return "ProcIns Node";
            case TIDY_NODETYPE_TEXT: return "Text Node";
            case TIDY_NODETYPE_START: return "Start Node";
            case TIDY_NODETYPE_END: return "End Node";
            case TIDY_NODETYPE_STARTEND: return "Start/End Node";
            case TIDY_NODETYPE_CDATA: return "CDATA Node";
            case TIDY_NODETYPE_SECTION: return "Section Node";
            case TIDY_NODETYPE_ASP: return "ASP Source Code Node";
            case TIDY_NODETYPE_PHP: return "PHP Source Code Node";
            case TIDY_NODETYPE_JSTE: return "JSTE Source Code";
            case TIDY_NODETYPE_XMLDECL: return "XML Declaration Node";
            default: return "Unknown Node";
        }
    }

    function do_leaf($string, $indent) {
        for($i = 0; $i < $indent; $i++) {
            echo " ";
        }
        echo $string;
    }

    function dump_tree(tidyNode $node, $indent = 0) {

        /* Put something there if the node name is empty */
        $nodename = trim(strtoupper($node->name));
        $nodename = (empty($nodename)) ? "[EMPTY]" : $nodename;

        /* Generate the Node, and a pretty name for it */
        do_leaf(" + $nodename (".node_type($node->type).")\n", $indent);

        /* Check to see if this node is a text node. Text nodes are
           generated by start/end tags and contain the text in between.
           i.e. <B>foo</B> will create a text node with $node->value
           equal to 'foo' */
        if($node->type == TIDY_NODETYPE_TEXT) {
            do_leaf("     |\n", $indent);
            do_leaf("     +---- Value: '{$node->value}'\n", $indent);
        }

        if(count($node->attribute)) {
            do_leaf(" |\n", $indent);
            do_leaf(" +---- Attributes\n", $indent);

            foreach($node->attribute as $name=>$value) {
                @do_leaf("            +-- $name\n", $indent);
                do_leaf("             |     +-- Value: $value\n", $indent);
            }
        }

        /* Recurse along the children to generate the remaining nodes */
        if($node->hasChildren()) {
            foreach($node->child as $child) {
                dump_tree($child, $indent + 3);
            }
        }

    }


?>
