/* Generated by re2c 0.16 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, size_t len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_stack_destroy(&SCNG(nest_location_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->nest_location_stack = SCNG(nest_location_stack);
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = CG(compiled_filename);
	lex_state->lineno = CG(zend_lineno);
	CG(compiled_filename) = NULL;

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_stack_destroy(&SCNG(nest_location_stack));
	SCNG(nest_location_stack) = lex_state->nest_location_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

ZEND_API zend_result zend_lex_tstring(zval *zv, zend_lexer_ident_ref ident_ref)
{
	char *ident = (char *) SCNG(yy_start) + ident_ref.offset;
	size_t length = ident_ref.len;
	if (length == sizeof("<?=")-1 && memcmp(ident, "<?=", sizeof("<?=")-1) == 0) {
		zend_throw_exception(zend_ce_parse_error, "Cannot use \"<?=\" as an identifier", 0);
		return FAILURE;
	}

	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, ident, length, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, ident, length);
	return SUCCESS;
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API zend_result zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return SUCCESS;
}

ZEND_API zend_result open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_init(file_handle->filename, strlen(file_handle->filename), 0);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	zend_bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}

ZEND_API zend_ast *zend_compile_string_to_ast(
		zend_string *code, zend_arena **ast_arena, const char *filename) {
	zval code_zv;
	zend_bool original_in_compilation;
	zend_lex_state original_lex_state;
	zend_ast *ast;

	ZVAL_STR_COPY(&code_zv, code);

	original_in_compilation = CG(in_compilation);
	CG(in_compilation) = 1;

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&code_zv, filename);
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);
	LANG_SCNG(yy_state) = yycINITIAL;

	if (zendparse() != 0) {
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(ast) = NULL;
	}

	/* restore_lexical_state changes CG(ast) and CG(ast_arena) */
	ast = CG(ast);
	*ast_arena = CG(ast_arena);

	zend_restore_lexical_state(&original_lex_state);
	CG(in_compilation) = original_in_compilation;

	zval_ptr_dtor_str(&code_zv);

	return ast;
}

zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		ZVAL_STR(&tmp, zval_get_string(filename));
		filename = &tmp;
	}
	zend_stream_init_filename(&file_handle, Z_STRVAL_P(filename));

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(Z_STR_P(filename));
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (UNEXPECTED(filename == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return retval;
}

ZEND_API void zend_prepare_string_for_scanning(zval *str, const char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release_ex(new_compiled_filename, 0);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zend_string *source_string, const char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;

	if (ZSTR_LEN(source_string) == 0) {
		return NULL;
	}

	ZVAL_STR_COPY(&tmp, source_string);

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&tmp, filename);
	BEGIN(ST_IN_SCRIPTING);
	op_array = zend_compile(ZEND_EVAL_CODE);

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


BEGIN_EXTERN_C()
zend_result highlight_file(const char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

void highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, const char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(str));
		str = &tmp;
	}
	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(str, str_name);
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	if (UNEXPECTED(str == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static zend_result zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] && (octal_buf[0] > '3') && !SCNG(heredoc_scan_ahead)) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
			return str;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static zend_bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, zend_bool using_spaces,
	zend_bool newline_at_start, zend_bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

/* Check that { }, [ ], ( ) are nested correctly */
static void report_bad_nesting(char opening, int opening_lineno, char closing)
{
	char   buf[256];
	size_t used = 0;

	used = snprintf(buf, sizeof(buf), "Unclosed '%c'", opening);

	if (opening_lineno != CG(zend_lineno)) {
		used += snprintf(buf + used, sizeof(buf) - used, " on line %d", opening_lineno);
	}

	if (closing) { 	/* 'closing' will be 0 if at end of file */
		used += snprintf(buf + used, sizeof(buf) - used, " does not match '%c'", closing);
	}

	zend_throw_exception(zend_ce_parse_error, buf, 0);
}

static void enter_nesting(char opening)
{
	zend_nest_location nest_loc = {opening, CG(zend_lineno)};
	zend_stack_push(&SCNG(nest_location_stack), &nest_loc);
}

static zend_result exit_nesting(char closing)
{
	if (zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unmatched '%c'", closing);
		return FAILURE;
	}

	zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
	char opening = nest_loc->text;

	if ((opening == '{' && closing != '}') ||
	    (opening == '[' && closing != ']') ||
	    (opening == '(' && closing != ')')) {
		report_bad_nesting(opening, nest_loc->lineno, closing);
		return FAILURE;
	}

	zend_stack_del_top(&SCNG(nest_location_stack));
	return SUCCESS;
}

static zend_result check_nesting_at_end()
{
	if (!zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
		report_bad_nesting(nest_loc->text, nest_loc->lineno, 0);
		return FAILURE;
	}

	return SUCCESS;
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_TOKEN_WITH_IDENT(_token) do { \
		token = _token; \
		goto emit_token_with_ident; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

#define RETURN_EXIT_NESTING_TOKEN(_token) do { \
		if (exit_nesting(_token) && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(_token); \
		} \
	} while(0)

#define RETURN_END_TOKEN do { \
		if (check_nesting_at_end() && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(END); \
		} \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(1, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy5;
	YYDEBUG(3, *YYCURSOR);
	++YYCURSOR;
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy4;
	YYDEBUG(6, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy8;
	} else {
		if (yych <= 'P') goto yy10;
		if (yych == 'p') goto yy10;
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy8:
	YYDEBUG(8, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(9, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		/* We'll reject this as an identifier in zend_lex_tstring. */
		RETURN_TOKEN_WITH_IDENT(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy12;
	if (yych == 'h') goto yy12;
yy11:
	YYDEBUG(11, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy7;
yy12:
	YYDEBUG(12, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy13;
	if (yych != 'p') goto yy11;
yy13:
	YYDEBUG(13, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '\f') {
		if (yych <= 0x08) goto yy14;
		if (yych <= '\n') goto yy15;
	} else {
		if (yych <= '\r') goto yy17;
		if (yych == ' ') goto yy15;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy15:
	YYDEBUG(15, *YYCURSOR);
	++YYCURSOR;
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy17:
	YYDEBUG(17, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '\n') goto yy15;
	goto yy16;
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,  64,  64, 128,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(18, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '#') goto yy22;
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '!') goto yy21;
yy23:
		YYDEBUG(23, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(24, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy23;
		}
		if (yych >= '\v') goto yy27;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy23;
		}
		if (yych <= '\n') goto yy25;
		goto yy27;
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(29, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy33;
		} else {
			if (yych <= '`') goto yy34;
			if (yych == '{') goto yy36;
		}
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy32;
			if (yych <= 'Z') goto yy37;
			if (yych <= '^') goto yy32;
			goto yy37;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy32;
				goto yy37;
			} else {
				if (yych <= '{') goto yy40;
				if (yych <= 0x7F) goto yy32;
				goto yy37;
			}
		}
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy42;
		goto yy32;
yy37:
		YYDEBUG(37, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy37;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy44;
		} else {
			if (yych <= '?') goto yy46;
			if (yych <= '@') goto yy39;
			if (yych <= '[') goto yy47;
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy40:
		YYDEBUG(40, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy42:
		YYDEBUG(42, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(43, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy49;
yy45:
		YYDEBUG(45, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy39;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy50;
		goto yy45;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy45;
			if (yych <= 'Z') goto yy51;
			if (yych <= '^') goto yy45;
			goto yy51;
		} else {
			if (yych <= '`') goto yy45;
			if (yych <= 'z') goto yy51;
			if (yych <= 0x7F) goto yy45;
			goto yy51;
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy53;
		goto yy45;
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(52, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy45;
			if (yych <= 'Z') goto yy54;
			if (yych <= '^') goto yy45;
		} else {
			if (yych <= '`') goto yy45;
			if (yych <= 'z') goto yy54;
			if (yych <= 0x7F) goto yy45;
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(55, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(56, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy60;
		} else {
			if (yych <= '$') goto yy62;
			if (yych == '{') goto yy63;
		}
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy60:
		YYDEBUG(60, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(61, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy59;
			if (yych <= 'Z') goto yy64;
			if (yych <= '^') goto yy59;
			goto yy64;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy59;
				goto yy64;
			} else {
				if (yych <= '{') goto yy67;
				if (yych <= 0x7F) goto yy59;
				goto yy64;
			}
		}
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy69;
		goto yy59;
yy64:
		YYDEBUG(64, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy64;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy71;
		} else {
			if (yych <= '?') goto yy73;
			if (yych <= '@') goto yy66;
			if (yych <= '[') goto yy74;
		}
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy76;
yy72:
		YYDEBUG(72, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy66;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy77;
		goto yy72;
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy72;
			if (yych <= 'Z') goto yy78;
			if (yych <= '^') goto yy72;
			goto yy78;
		} else {
			if (yych <= '`') goto yy72;
			if (yych <= 'z') goto yy78;
			if (yych <= 0x7F) goto yy72;
			goto yy78;
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy80;
		goto yy72;
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy72;
			if (yych <= 'Z') goto yy81;
			if (yych <= '^') goto yy72;
		} else {
			if (yych <= '`') goto yy72;
			if (yych <= 'z') goto yy81;
			if (yych <= 0x7F) goto yy72;
		}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(83, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(85, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(86, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(87, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy91;
		if (yych == '{') goto yy92;
		YYDEBUG(89, *YYCURSOR);
		++YYCURSOR;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy90;
			if (yych <= 'Z') goto yy93;
			if (yych <= '^') goto yy90;
			goto yy93;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy90;
				goto yy93;
			} else {
				if (yych <= '{') goto yy96;
				if (yych <= 0x7F) goto yy90;
				goto yy93;
			}
		}
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy98;
		goto yy90;
yy93:
		YYDEBUG(93, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(94, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy93;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy100;
		} else {
			if (yych <= '?') goto yy102;
			if (yych <= '@') goto yy95;
			if (yych <= '[') goto yy103;
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy105;
yy101:
		YYDEBUG(101, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy95;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy106;
		goto yy101;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy101;
			if (yych <= 'Z') goto yy107;
			if (yych <= '^') goto yy101;
			goto yy107;
		} else {
			if (yych <= '`') goto yy101;
			if (yych <= 'z') goto yy107;
			if (yych <= 0x7F) goto yy101;
			goto yy107;
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy109;
		goto yy101;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy101;
			if (yych <= 'Z') goto yy110;
			if (yych <= '^') goto yy101;
		} else {
			if (yych <= '`') goto yy101;
			if (yych <= 'z') goto yy110;
			if (yych <= 0x7F) goto yy101;
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(112, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy116;
		}
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\n':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy114;
		case ' ':
		case '!':	goto yy119;
		case '"':	goto yy121;
		case '#':	goto yy123;
		case '$':	goto yy125;
		case '%':	goto yy126;
		case '&':	goto yy127;
		case '\'':	goto yy128;
		case '(':	goto yy130;
		case ')':
		case ']':	goto yy132;
		case '*':	goto yy134;
		case '+':	goto yy135;
		case ',':
		case ';':
		case '@':
		case '~':	goto yy136;
		case '-':	goto yy137;
		case '.':	goto yy138;
		case '/':	goto yy139;
		case '0':	goto yy140;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy142;
		case ':':	goto yy144;
		case '<':	goto yy145;
		case '=':	goto yy146;
		case '>':	goto yy147;
		case '?':	goto yy148;
		case 'A':
		case 'a':	goto yy149;
		case 'B':
		case 'b':	goto yy151;
		case 'C':
		case 'c':	goto yy152;
		case 'D':
		case 'd':	goto yy153;
		case 'E':
		case 'e':	goto yy154;
		case 'F':
		case 'f':	goto yy155;
		case 'G':
		case 'g':	goto yy156;
		case 'I':
		case 'i':	goto yy159;
		case 'L':
		case 'l':	goto yy160;
		case 'M':
		case 'm':	goto yy161;
		case 'N':
		case 'n':	goto yy162;
		case 'O':
		case 'o':	goto yy163;
		case 'P':
		case 'p':	goto yy164;
		case 'R':
		case 'r':	goto yy165;
		case 'S':
		case 's':	goto yy166;
		case 'T':
		case 't':	goto yy167;
		case 'U':
		case 'u':	goto yy168;
		case 'V':
		case 'v':	goto yy169;
		case 'W':
		case 'w':	goto yy170;
		case 'X':
		case 'x':	goto yy171;
		case 'Y':
		case 'y':	goto yy172;
		case '[':	goto yy173;
		case '\\':	goto yy174;
		case '^':	goto yy176;
		case '_':	goto yy177;
		case '`':	goto yy178;
		case '{':	goto yy180;
		case '|':	goto yy182;
		case '}':	goto yy183;
		default:	goto yy157;
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy116;
		}
		YYDEBUG(118, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy185;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '[') goto yy187;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy120;
			if (yych <= 'Z') goto yy189;
			if (yych <= '^') goto yy120;
			goto yy189;
		} else {
			if (yych <= '`') goto yy120;
			if (yych <= 'z') goto yy189;
			if (yych <= 0x7F) goto yy120;
			goto yy189;
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy192;
		goto yy120;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy194;
		if (yych == '=') goto yy196;
		goto yy120;
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(129, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy199;
					if (yych >= ' ') goto yy199;
				} else {
					if (yych <= '@') goto yy131;
					if (yych != 'C') goto yy199;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy199;
					if (yych >= 'I') goto yy199;
				} else {
					if (yych == 'O') goto yy199;
					if (yych >= 'R') goto yy199;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy199;
					if (yych >= 'a') goto yy199;
				} else {
					if (yych == 'd') goto yy199;
					if (yych >= 'f') goto yy199;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy199;
					if (yych >= 'o') goto yy199;
				} else {
					if (yych <= 's') {
						if (yych >= 'r') goto yy199;
					} else {
						if (yych == 'u') goto yy199;
					}
				}
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting(yytext[0]);
	RETURN_TOKEN(yytext[0]);
}
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Check that ] and ) match up properly with a preceding [ or ( */
	RETURN_EXIT_NESTING_TOKEN(yytext[0]);
}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy210;
		if (yych == '=') goto yy212;
		goto yy120;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy214;
		if (yych == '=') goto yy216;
		goto yy120;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy120;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy218;
			goto yy120;
		} else {
			if (yych <= '=') goto yy220;
			if (yych <= '>') goto yy222;
			goto yy120;
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy224;
			goto yy120;
		} else {
			if (yych <= '9') goto yy225;
			if (yych == '=') goto yy228;
			goto yy120;
		}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy230;
			goto yy120;
		} else {
			if (yych <= '/') goto yy232;
			if (yych == '=') goto yy233;
			goto yy120;
		}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych == 'B') goto yy236;
			if (yych <= 'W') goto yy143;
			goto yy238;
		} else {
			if (yych <= 'b') {
				if (yych <= 'a') goto yy143;
				goto yy236;
			} else {
				if (yych == 'x') goto yy238;
				goto yy143;
			}
		}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	zend_bool is_octal = lnum[0] == '0';
	zend_bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy143:
		YYDEBUG(143, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy142;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy235;
			if (yych <= 'D') goto yy141;
			goto yy237;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy141;
				goto yy239;
			} else {
				if (yych == 'e') goto yy237;
				goto yy141;
			}
		}
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy240;
		goto yy120;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy120;
		if (yych <= '<') goto yy242;
		if (yych <= '=') goto yy244;
		if (yych <= '>') goto yy246;
		goto yy120;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy120;
		if (yych <= '=') goto yy247;
		if (yych <= '>') goto yy249;
		goto yy120;
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy120;
		if (yych <= '=') goto yy251;
		if (yych <= '>') goto yy253;
		goto yy120;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych == '-') goto yy255;
			goto yy120;
		} else {
			if (yych <= '>') goto yy256;
			if (yych <= '?') goto yy258;
			goto yy120;
		}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy260;
				goto yy158;
			} else {
				if (yych <= 'N') goto yy261;
				if (yych <= 'Q') goto yy158;
				if (yych <= 'R') goto yy262;
				goto yy263;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy260;
				if (yych <= 'm') goto yy158;
				goto yy261;
			} else {
				if (yych <= 'q') goto yy158;
				if (yych <= 'r') goto yy262;
				if (yych <= 's') goto yy263;
				goto yy158;
			}
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy158;
				goto yy121;
			} else {
				if (yych == '\'') goto yy128;
				goto yy158;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy266;
				if (yych <= 'Q') goto yy158;
				goto yy267;
			} else {
				if (yych == 'r') goto yy267;
				goto yy158;
			}
		}
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy268;
				goto yy158;
			} else {
				if (yych <= 'L') goto yy269;
				if (yych <= 'N') goto yy158;
				goto yy270;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy268;
				goto yy158;
			} else {
				if (yych <= 'l') goto yy269;
				if (yych == 'o') goto yy270;
				goto yy158;
			}
		}
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy271;
				goto yy158;
			} else {
				if (yych <= 'I') goto yy272;
				if (yych <= 'N') goto yy158;
				goto yy273;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy271;
				goto yy158;
			} else {
				if (yych <= 'i') goto yy272;
				if (yych == 'o') goto yy273;
				goto yy158;
			}
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy275;
		case 'L':
		case 'l':	goto yy276;
		case 'M':
		case 'm':	goto yy277;
		case 'N':
		case 'n':	goto yy278;
		case 'V':
		case 'v':	goto yy279;
		case 'X':
		case 'x':	goto yy280;
		default:	goto yy158;
		}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy281;
				goto yy158;
			} else {
				if (yych <= 'N') goto yy282;
				if (yych <= 'O') goto yy284;
				if (yych <= 'T') goto yy158;
				goto yy285;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy281;
				if (yych <= 'm') goto yy158;
				goto yy282;
			} else {
				if (yych <= 'o') goto yy284;
				if (yych == 'u') goto yy285;
				goto yy158;
			}
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'L') goto yy286;
			if (yych <= 'N') goto yy158;
			goto yy287;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy158;
				goto yy286;
			} else {
				if (yych == 'o') goto yy287;
				goto yy158;
			}
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy158:
		YYDEBUG(158, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
		goto yy150;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy288;
				goto yy158;
			} else {
				if (yych <= 'M') goto yy290;
				if (yych <= 'N') goto yy291;
				if (yych <= 'R') goto yy158;
				goto yy292;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy288;
				if (yych <= 'l') goto yy158;
				goto yy290;
			} else {
				if (yych <= 'n') goto yy291;
				if (yych == 's') goto yy292;
				goto yy158;
			}
		}
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy293;
		if (yych == 'i') goto yy293;
		goto yy158;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy294;
		if (yych == 'a') goto yy294;
		goto yy158;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy295;
			if (yych <= 'D') goto yy158;
			goto yy296;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy158;
				goto yy295;
			} else {
				if (yych == 'e') goto yy296;
				goto yy158;
			}
		}
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy297;
		if (yych == 'r') goto yy297;
		goto yy158;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'R') goto yy299;
			if (yych <= 'T') goto yy158;
			goto yy300;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy158;
				goto yy299;
			} else {
				if (yych == 'u') goto yy300;
				goto yy158;
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy301;
		if (yych == 'e') goto yy301;
		goto yy158;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych == 'T') goto yy302;
			if (yych <= 'V') goto yy158;
			goto yy303;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy158;
				goto yy302;
			} else {
				if (yych == 'w') goto yy303;
				goto yy158;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'R') {
			if (yych == 'H') goto yy304;
			if (yych <= 'Q') goto yy158;
			goto yy305;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy158;
				goto yy304;
			} else {
				if (yych == 'r') goto yy305;
				goto yy158;
			}
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych == 'N') goto yy306;
			if (yych <= 'R') goto yy158;
			goto yy307;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy158;
				goto yy306;
			} else {
				if (yych == 's') goto yy307;
				goto yy158;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy308;
		if (yych == 'a') goto yy308;
		goto yy158;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy309;
		if (yych == 'h') goto yy309;
		goto yy158;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy310;
		if (yych == 'o') goto yy310;
		goto yy158;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy311;
		if (yych == 'i') goto yy311;
		goto yy158;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy131;
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy175;
			if (yych <= 'Z') goto yy312;
			if (yych >= '_') goto yy312;
		} else {
			if (yych <= '`') goto yy175;
			if (yych <= 'z') goto yy312;
			if (yych >= 0x80) goto yy312;
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy315;
		goto yy120;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy317;
		goto yy158;
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	enter_nesting('{');
	RETURN_TOKEN('{');
}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy318;
		if (yych == '|') goto yy320;
		goto yy120;
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_EXIT_NESTING_TOKEN('}');
}
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy322;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting('[');
	RETURN_TOKEN(T_ATTRIBUTE);
}
yy189:
		YYDEBUG(189, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy189;
			} else {
				if (yych <= '@') goto yy191;
				if (yych <= 'Z') goto yy189;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy189;
			} else {
				if (yych <= 'z') goto yy189;
				if (yych >= 0x80) goto yy189;
			}
		}
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(195, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(197, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy199:
		YYDEBUG(199, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy198;
		}
		switch (yych) {
		case 'A':
		case 'a':	goto yy201;
		case 'B':
		case 'b':	goto yy202;
		case 'D':
		case 'd':	goto yy203;
		case 'F':
		case 'f':	goto yy204;
		case 'I':
		case 'i':	goto yy205;
		case 'O':
		case 'o':	goto yy206;
		case 'R':
		case 'r':	goto yy207;
		case 'S':
		case 's':	goto yy208;
		case 'U':
		case 'u':	goto yy209;
		default:	goto yy200;
		}
yy200:
		YYDEBUG(200, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 44) {
			if (yyaccept <= 22) {
				if (yyaccept <= 11) {
					if (yyaccept <= 5) {
						if (yyaccept <= 2) {
							if (yyaccept <= 1) {
								if (yyaccept == 0) {
									goto yy131;
								} else {
									goto yy120;
								}
							} else {
								goto yy141;
							}
						} else {
							if (yyaccept <= 4) {
								if (yyaccept == 3) {
									goto yy150;
								} else {
									goto yy227;
								}
							} else {
								goto yy231;
							}
						}
					} else {
						if (yyaccept <= 8) {
							if (yyaccept <= 7) {
								if (yyaccept == 6) {
									goto yy243;
								} else {
									goto yy264;
								}
							} else {
								goto yy274;
							}
						} else {
							if (yyaccept <= 10) {
								if (yyaccept == 9) {
									goto yy283;
								} else {
									goto yy289;
								}
							} else {
								goto yy298;
							}
						}
					}
				} else {
					if (yyaccept <= 17) {
						if (yyaccept <= 14) {
							if (yyaccept <= 13) {
								if (yyaccept == 12) {
									goto yy314;
								} else {
									goto yy342;
								}
							} else {
								goto yy348;
							}
						} else {
							if (yyaccept <= 16) {
								if (yyaccept == 15) {
									goto yy367;
								} else {
									goto yy371;
								}
							} else {
								goto yy383;
							}
						}
					} else {
						if (yyaccept <= 20) {
							if (yyaccept <= 19) {
								if (yyaccept == 18) {
									goto yy393;
								} else {
									goto yy406;
								}
							} else {
								goto yy417;
							}
						} else {
							if (yyaccept == 21) {
								goto yy420;
							} else {
								goto yy422;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 33) {
					if (yyaccept <= 28) {
						if (yyaccept <= 25) {
							if (yyaccept <= 24) {
								if (yyaccept == 23) {
									goto yy425;
								} else {
									goto yy457;
								}
							} else {
								goto yy466;
							}
						} else {
							if (yyaccept <= 27) {
								if (yyaccept == 26) {
									goto yy468;
								} else {
									goto yy476;
								}
							} else {
								goto yy478;
							}
						}
					} else {
						if (yyaccept <= 31) {
							if (yyaccept <= 30) {
								if (yyaccept == 29) {
									goto yy485;
								} else {
									goto yy492;
								}
							} else {
								goto yy541;
							}
						} else {
							if (yyaccept == 32) {
								goto yy543;
							} else {
								goto yy546;
							}
						}
					}
				} else {
					if (yyaccept <= 39) {
						if (yyaccept <= 36) {
							if (yyaccept <= 35) {
								if (yyaccept == 34) {
									goto yy548;
								} else {
									goto yy550;
								}
							} else {
								goto yy552;
							}
						} else {
							if (yyaccept <= 38) {
								if (yyaccept == 37) {
									goto yy558;
								} else {
									goto yy562;
								}
							} else {
								goto yy567;
							}
						}
					} else {
						if (yyaccept <= 42) {
							if (yyaccept <= 41) {
								if (yyaccept == 40) {
									goto yy577;
								} else {
									goto yy579;
								}
							} else {
								goto yy582;
							}
						} else {
							if (yyaccept == 43) {
								goto yy591;
							} else {
								goto yy593;
							}
						}
					}
				}
			}
		} else {
			if (yyaccept <= 66) {
				if (yyaccept <= 55) {
					if (yyaccept <= 50) {
						if (yyaccept <= 47) {
							if (yyaccept <= 46) {
								if (yyaccept == 45) {
									goto yy595;
								} else {
									goto yy597;
								}
							} else {
								goto yy599;
							}
						} else {
							if (yyaccept <= 49) {
								if (yyaccept == 48) {
									goto yy634;
								} else {
									goto yy637;
								}
							} else {
								goto yy645;
							}
						}
					} else {
						if (yyaccept <= 53) {
							if (yyaccept <= 52) {
								if (yyaccept == 51) {
									goto yy655;
								} else {
									goto yy658;
								}
							} else {
								goto yy660;
							}
						} else {
							if (yyaccept == 54) {
								goto yy662;
							} else {
								goto yy690;
							}
						}
					}
				} else {
					if (yyaccept <= 61) {
						if (yyaccept <= 58) {
							if (yyaccept <= 57) {
								if (yyaccept == 56) {
									goto yy692;
								} else {
									goto yy698;
								}
							} else {
								goto yy700;
							}
						} else {
							if (yyaccept <= 60) {
								if (yyaccept == 59) {
									goto yy702;
								} else {
									goto yy706;
								}
							} else {
								goto yy712;
							}
						}
					} else {
						if (yyaccept <= 64) {
							if (yyaccept <= 63) {
								if (yyaccept == 62) {
									goto yy715;
								} else {
									goto yy719;
								}
							} else {
								goto yy732;
							}
						} else {
							if (yyaccept == 65) {
								goto yy734;
							} else {
								goto yy736;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 77) {
					if (yyaccept <= 72) {
						if (yyaccept <= 69) {
							if (yyaccept <= 68) {
								if (yyaccept == 67) {
									goto yy741;
								} else {
									goto yy743;
								}
							} else {
								goto yy755;
							}
						} else {
							if (yyaccept <= 71) {
								if (yyaccept == 70) {
									goto yy759;
								} else {
									goto yy766;
								}
							} else {
								goto yy771;
							}
						}
					} else {
						if (yyaccept <= 75) {
							if (yyaccept <= 74) {
								if (yyaccept == 73) {
									goto yy773;
								} else {
									goto yy775;
								}
							} else {
								goto yy777;
							}
						} else {
							if (yyaccept == 76) {
								goto yy781;
							} else {
								goto yy787;
							}
						}
					}
				} else {
					if (yyaccept <= 83) {
						if (yyaccept <= 80) {
							if (yyaccept <= 79) {
								if (yyaccept == 78) {
									goto yy789;
								} else {
									goto yy791;
								}
							} else {
								goto yy793;
							}
						} else {
							if (yyaccept <= 82) {
								if (yyaccept == 81) {
									goto yy796;
								} else {
									goto yy803;
								}
							} else {
								goto yy808;
							}
						}
					} else {
						if (yyaccept <= 86) {
							if (yyaccept <= 85) {
								if (yyaccept == 84) {
									goto yy816;
								} else {
									goto yy818;
								}
							} else {
								goto yy820;
							}
						} else {
							if (yyaccept == 87) {
								goto yy825;
							} else {
								goto yy828;
							}
						}
					}
				}
			}
		}
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy324;
		if (yych == 'r') goto yy324;
		goto yy200;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy325;
			if (yych <= 'N') goto yy200;
			goto yy326;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy200;
				goto yy325;
			} else {
				if (yych == 'o') goto yy326;
				goto yy200;
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy327;
		if (yych == 'o') goto yy327;
		goto yy200;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy328;
		if (yych == 'l') goto yy328;
		goto yy200;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy329;
		if (yych == 'n') goto yy329;
		goto yy200;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy330;
		if (yych == 'b') goto yy330;
		goto yy200;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy331;
		if (yych == 'e') goto yy331;
		goto yy200;
yy208:
		YYDEBUG(208, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy332;
		if (yych == 't') goto yy332;
		goto yy200;
yy209:
		YYDEBUG(209, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy333;
		if (yych == 'n') goto yy333;
		goto yy200;
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy334;
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy336;
		goto yy200;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy226:
		YYDEBUG(226, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy227;
			if (yych <= '9') goto yy225;
			if (yych >= 'E') goto yy237;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy338;
			} else {
				if (yych == 'e') goto yy237;
			}
		}
yy227:
		YYDEBUG(227, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	zend_bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy228:
		YYDEBUG(228, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(229, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy230:
		YYDEBUG(230, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy339;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy124;
yy233:
		YYDEBUG(233, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy227;
		goto yy226;
yy236:
		YYDEBUG(236, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy340;
		}
		goto yy200;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy343;
			goto yy200;
		} else {
			if (yych <= '-') goto yy343;
			if (yych <= '/') goto yy200;
			if (yych <= '9') goto yy344;
			goto yy200;
		}
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy346;
		}
		goto yy200;
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy142;
		}
		goto yy200;
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(241, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy243;
		if (yych <= '<') goto yy349;
		if (yych <= '=') goto yy351;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy244:
		YYDEBUG(244, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy353;
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy186;
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy355;
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy253:
		YYDEBUG(253, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy357;
		YYDEBUG(254, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy359;
		goto yy200;
yy256:
		YYDEBUG(256, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy361;
		if (yych == '\r') goto yy362;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy258:
		YYDEBUG(258, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy363;
		YYDEBUG(259, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy365;
		if (yych == 's') goto yy365;
		goto yy158;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy366;
		if (yych == 'd') goto yy366;
		goto yy158;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy368;
		if (yych == 'r') goto yy368;
		goto yy158;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_AS);
}
yy265:
		YYDEBUG(265, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy200;
			if (yych <= 'Z') goto yy369;
			if (yych <= '^') goto yy200;
			goto yy369;
		} else {
			if (yych <= '`') goto yy200;
			if (yych <= 'z') goto yy369;
			if (yych <= 0x7F) goto yy200;
			goto yy369;
		}
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy372;
		goto yy200;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy373;
		if (yych == 'e') goto yy373;
		goto yy158;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy158;
				goto yy374;
			} else {
				if (yych <= 'R') goto yy158;
				if (yych <= 'S') goto yy375;
				goto yy376;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy374;
				goto yy158;
			} else {
				if (yych <= 's') goto yy375;
				if (yych <= 't') goto yy376;
				goto yy158;
			}
		}
yy269:
		YYDEBUG(269, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'A') goto yy377;
			if (yych <= 'N') goto yy158;
			goto yy378;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy158;
				goto yy377;
			} else {
				if (yych == 'o') goto yy378;
				goto yy158;
			}
		}
yy270:
		YYDEBUG(270, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy379;
		if (yych == 'n') goto yy379;
		goto yy158;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'F') {
			if (yych == 'C') goto yy380;
			if (yych <= 'E') goto yy158;
			goto yy381;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy158;
				goto yy380;
			} else {
				if (yych == 'f') goto yy381;
				goto yy158;
			}
		}
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy382;
		if (yych == 'e') goto yy382;
		goto yy158;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DO);
}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy384;
		if (yych == 'h') goto yy384;
		goto yy158;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy385;
		if (yych == 's') goto yy385;
		goto yy158;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy386;
		if (yych == 'p') goto yy386;
		goto yy158;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy387;
		if (yych == 'd') goto yy387;
		goto yy158;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy388;
		if (yych == 'a') goto yy388;
		goto yy158;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'I') goto yy389;
			if (yych <= 'S') goto yy158;
			goto yy390;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy158;
				goto yy389;
			} else {
				if (yych == 't') goto yy390;
				goto yy158;
			}
		}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy391;
		if (yych == 'n') goto yy391;
		goto yy158;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FN);
}
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy392;
		if (yych == 'r') goto yy392;
		goto yy158;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy394;
		if (yych == 'n') goto yy394;
		goto yy158;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy395;
		if (yych == 'o') goto yy395;
		goto yy158;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy396;
		if (yych == 't') goto yy396;
		goto yy158;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IF);
}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy397;
		if (yych == 'p') goto yy397;
		goto yy158;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy158;
				goto yy398;
			} else {
				if (yych <= 'R') goto yy158;
				if (yych <= 'S') goto yy399;
				goto yy400;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy398;
				goto yy158;
			} else {
				if (yych <= 's') goto yy399;
				if (yych <= 't') goto yy400;
				goto yy158;
			}
		}
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy401;
		if (yych == 's') goto yy401;
		goto yy158;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy402;
		if (yych == 's') goto yy402;
		goto yy158;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy403;
		if (yych == 't') goto yy403;
		goto yy158;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy404;
		if (yych == 'm') goto yy404;
		goto yy158;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy405;
		if (yych == 'w') goto yy405;
		goto yy158;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_OR);
}
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'I') goto yy407;
			if (yych <= 'N') goto yy158;
			goto yy408;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy158;
				goto yy407;
			} else {
				if (yych == 'o') goto yy408;
				goto yy158;
			}
		}
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy409;
		if (yych == 'b') goto yy409;
		goto yy158;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'Q') goto yy410;
			if (yych <= 'S') goto yy158;
			goto yy411;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy158;
				goto yy410;
			} else {
				if (yych == 't') goto yy411;
				goto yy158;
			}
		}
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy412;
		if (yych == 'a') goto yy412;
		goto yy158;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy413;
		if (yych == 'i') goto yy413;
		goto yy158;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy414;
		if (yych == 'r') goto yy414;
		goto yy158;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'Y') {
			if (yych == 'A') goto yy415;
			if (yych <= 'X') goto yy158;
			goto yy416;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy158;
				goto yy415;
			} else {
				if (yych == 'y') goto yy416;
				goto yy158;
			}
		}
yy306:
		YYDEBUG(306, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy418;
		if (yych == 's') goto yy418;
		goto yy158;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy419;
		if (yych == 'e') goto yy419;
		goto yy158;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy421;
		if (yych == 'r') goto yy421;
		goto yy158;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy423;
		if (yych == 'i') goto yy423;
		goto yy158;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy424;
		if (yych == 'r') goto yy424;
		goto yy158;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy426;
		if (yych == 'e') goto yy426;
		goto yy158;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yyaccept = 12;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(313, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy314;
				if (yych <= '9') goto yy312;
			} else {
				if (yych <= 'Z') goto yy312;
				if (yych >= '\\') goto yy427;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy312;
			} else {
				if (yych <= 'z') goto yy312;
				if (yych >= 0x80) goto yy312;
			}
		}
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_FULLY_QUALIFIED, 1);
}
yy315:
		YYDEBUG(315, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(316, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy317:
		YYDEBUG(317, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy428;
		case 'D':
		case 'd':	goto yy429;
		case 'F':
		case 'f':	goto yy430;
		case 'H':
		case 'h':	goto yy431;
		case 'L':
		case 'l':	goto yy432;
		case 'M':
		case 'm':	goto yy433;
		case 'N':
		case 'n':	goto yy434;
		case 'T':
		case 't':	goto yy435;
		default:	goto yy158;
		}
yy318:
		YYDEBUG(318, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(319, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy320:
		YYDEBUG(320, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(321, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy322:
		YYDEBUG(322, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(323, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy436;
		if (yych == 'r') goto yy436;
		goto yy200;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy437;
		if (yych == 'n') goto yy437;
		goto yy200;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy438;
		if (yych == 'o') goto yy438;
		goto yy200;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy439;
		if (yych == 'u') goto yy439;
		goto yy200;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy440;
		if (yych == 'o') goto yy440;
		goto yy200;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy441;
		if (yych == 't') goto yy441;
		goto yy200;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy442;
		if (yych == 'j') goto yy442;
		goto yy200;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy443;
		if (yych == 'a') goto yy443;
		goto yy200;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy444;
		if (yych == 'r') goto yy444;
		goto yy200;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy445;
		if (yych == 's') goto yy445;
		goto yy200;
yy334:
		YYDEBUG(334, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(335, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy336:
		YYDEBUG(336, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(337, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy338:
		YYDEBUG(338, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy200;
		if (yych <= '9') goto yy225;
		goto yy200;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy200;
			if (yych <= '\n') goto yy446;
			goto yy200;
		} else {
			if (yych <= '\r') goto yy446;
			if (yych == ' ') goto yy446;
			goto yy200;
		}
yy340:
		YYDEBUG(340, *YYCURSOR);
		yyaccept = 13;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(341, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy340;
		}
		if (yych == '_') goto yy236;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	zend_bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy343:
		YYDEBUG(343, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy200;
		if (yych >= ':') goto yy200;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(345, *YYCURSOR);
		if (yych <= '/') goto yy227;
		if (yych <= '9') goto yy344;
		if (yych == '_') goto yy343;
		goto yy227;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yyaccept = 14;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(347, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy346;
		}
		if (yych == '_') goto yy238;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	zend_bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy349:
		YYDEBUG(349, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(350, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy349;
				if (yych <= 0x1F) goto yy200;
				goto yy349;
			} else {
				if (yych == '"') goto yy448;
				if (yych <= '&') goto yy200;
				goto yy449;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy200;
				if (yych <= 'Z') goto yy450;
				if (yych <= '^') goto yy200;
				goto yy450;
			} else {
				if (yych <= '`') goto yy200;
				if (yych <= 'z') goto yy450;
				if (yych <= 0x7F) goto yy200;
				goto yy450;
			}
		}
yy351:
		YYDEBUG(351, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(352, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy353:
		YYDEBUG(353, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(354, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy355:
		YYDEBUG(355, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(356, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy357:
		YYDEBUG(357, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(358, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy359:
		YYDEBUG(359, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(360, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy257;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy361;
		goto yy257;
yy363:
		YYDEBUG(363, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(364, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy365:
		YYDEBUG(365, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy452;
		if (yych == 't') goto yy452;
		goto yy158;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_AND);
}
yy368:
		YYDEBUG(368, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy453;
		if (yych == 'a') goto yy453;
		goto yy158;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yyaccept = 16;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(370, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy371;
				if (yych <= '9') goto yy369;
			} else {
				if (yych <= 'Z') goto yy369;
				if (yych >= '\\') goto yy265;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy369;
			} else {
				if (yych <= 'z') goto yy369;
				if (yych >= 0x80) goto yy369;
			}
		}
yy371:
		YYDEBUG(371, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_QUALIFIED, 0);
}
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy349;
		goto yy200;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy454;
		if (yych == 'a') goto yy454;
		goto yy158;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy455;
		if (yych == 'l') goto yy455;
		goto yy158;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy456;
		if (yych == 'e') goto yy456;
		goto yy158;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy458;
		if (yych == 'c') goto yy458;
		goto yy158;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy459;
		if (yych == 's') goto yy459;
		goto yy158;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy460;
		if (yych == 'n') goto yy460;
		goto yy158;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'R') goto yy158;
			if (yych <= 'S') goto yy461;
			goto yy462;
		} else {
			if (yych <= 'r') goto yy158;
			if (yych <= 's') goto yy461;
			if (yych <= 't') goto yy462;
			goto yy158;
		}
yy380:
		YYDEBUG(380, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy463;
		if (yych == 'l') goto yy463;
		goto yy158;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy464;
		if (yych == 'a') goto yy464;
		goto yy158;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy384:
		YYDEBUG(384, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy465;
		if (yych == 'o') goto yy465;
		goto yy158;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy467;
		if (yych == 'e') goto yy467;
		goto yy158;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy469;
		if (yych == 't') goto yy469;
		goto yy158;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'D':
		case 'd':	goto yy470;
		case 'F':
		case 'f':	goto yy471;
		case 'I':
		case 'i':	goto yy472;
		case 'S':
		case 's':	goto yy473;
		case 'W':
		case 'w':	goto yy474;
		default:	goto yy158;
		}
yy388:
		YYDEBUG(388, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy475;
		if (yych == 'l') goto yy475;
		goto yy158;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy477;
		if (yych == 't') goto yy477;
		goto yy158;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy479;
		if (yych == 'e') goto yy479;
		goto yy158;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy480;
		if (yych == 'a') goto yy480;
		goto yy158;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy393;
				if (yych <= '9') goto yy157;
				if (yych >= 'A') goto yy157;
			} else {
				if (yych <= 'E') goto yy481;
				if (yych <= 'Z') goto yy157;
				if (yych >= '\\') goto yy265;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy157;
				if (yych >= 'a') goto yy157;
			} else {
				if (yych <= 'e') goto yy481;
				if (yych <= 'z') goto yy157;
				if (yych >= 0x80) goto yy157;
			}
		}
yy393:
		YYDEBUG(393, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOR);
}
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy482;
		if (yych == 'c') goto yy482;
		goto yy158;
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy483;
		if (yych == 'b') goto yy483;
		goto yy158;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy484;
		if (yych == 'o') goto yy484;
		goto yy158;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy486;
		if (yych == 'l') goto yy486;
		goto yy158;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy487;
		if (yych == 'l') goto yy487;
		goto yy158;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy488;
		if (yych == 't') goto yy488;
		goto yy158;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy489;
		if (yych == 'e') goto yy489;
		goto yy158;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy490;
		if (yych == 'e') goto yy490;
		goto yy158;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy491;
		if (yych == 't') goto yy491;
		goto yy158;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy493;
		if (yych == 'c') goto yy493;
		goto yy158;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy494;
		if (yych == 'e') goto yy494;
		goto yy158;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NEW);
}
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'V') {
			if (yych == 'N') goto yy495;
			if (yych <= 'U') goto yy158;
			goto yy496;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy158;
				goto yy495;
			} else {
				if (yych == 'v') goto yy496;
				goto yy158;
			}
		}
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy497;
		if (yych == 't') goto yy497;
		goto yy158;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy498;
		if (yych == 'l') goto yy498;
		goto yy158;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy499;
		if (yych == 'u') goto yy499;
		goto yy158;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy500;
		if (yych == 'u') goto yy500;
		goto yy158;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy501;
		if (yych == 't') goto yy501;
		goto yy158;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy502;
		if (yych == 't') goto yy502;
		goto yy158;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy503;
		if (yych == 'o') goto yy503;
		goto yy158;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy504;
		if (yych == 'i') goto yy504;
		goto yy158;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRY);
}
yy418:
		YYDEBUG(418, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy505;
		if (yych == 'e') goto yy505;
		goto yy158;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_USE);
}
yy421:
		YYDEBUG(421, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_VAR);
}
yy423:
		YYDEBUG(423, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy506;
		if (yych == 'l') goto yy506;
		goto yy158;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_XOR);
}
yy426:
		YYDEBUG(426, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy507;
		if (yych == 'l') goto yy507;
		goto yy158;
yy427:
		YYDEBUG(427, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy200;
			if (yych <= 'Z') goto yy312;
			if (yych <= '^') goto yy200;
			goto yy312;
		} else {
			if (yych <= '`') goto yy200;
			if (yych <= 'z') goto yy312;
			if (yych <= 0x7F) goto yy200;
			goto yy312;
		}
yy428:
		YYDEBUG(428, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy508;
		if (yych == 'l') goto yy508;
		goto yy158;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy509;
		if (yych == 'i') goto yy509;
		goto yy158;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'I') goto yy510;
			if (yych <= 'T') goto yy158;
			goto yy511;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy158;
				goto yy510;
			} else {
				if (yych == 'u') goto yy511;
				goto yy158;
			}
		}
yy431:
		YYDEBUG(431, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy512;
		if (yych == 'a') goto yy512;
		goto yy158;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy513;
		if (yych == 'i') goto yy513;
		goto yy158;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy514;
		if (yych == 'e') goto yy514;
		goto yy158;
yy434:
		YYDEBUG(434, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy515;
		if (yych == 'a') goto yy515;
		goto yy158;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy516;
		if (yych == 'r') goto yy516;
		goto yy158;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy517;
		if (yych == 'a') goto yy517;
		goto yy200;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy518;
		if (yych == 'a') goto yy518;
		goto yy200;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy519;
		if (yych == 'l') goto yy519;
		goto yy200;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy520;
		if (yych == 'b') goto yy520;
		goto yy200;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy521;
		if (yych == 'a') goto yy521;
		goto yy200;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy526;
		if (yych == 'e') goto yy526;
		goto yy523;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy527;
		if (yych == 'e') goto yy527;
		goto yy200;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy528;
		if (yych == 'l') goto yy528;
		goto yy200;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy530;
		if (yych == 'i') goto yy530;
		goto yy200;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy531;
		if (yych == 'e') goto yy531;
		goto yy200;
yy446:
		YYDEBUG(446, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(447, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy231;
			if (yych <= '\n') goto yy446;
			goto yy231;
		} else {
			if (yych <= '\r') goto yy446;
			if (yych == ' ') goto yy446;
			goto yy231;
		}
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy200;
		if (yych <= '/') goto yy533;
		if (yych <= '9') goto yy200;
		goto yy533;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy200;
		if (yych <= '/') goto yy535;
		if (yych <= '9') goto yy200;
		goto yy535;
yy450:
		YYDEBUG(450, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(451, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy536;
				goto yy200;
			} else {
				if (yych <= '\r') goto yy538;
				if (yych <= '/') goto yy200;
				if (yych <= '9') goto yy450;
				goto yy200;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy450;
				if (yych <= '^') goto yy200;
				goto yy450;
			} else {
				if (yych <= '`') goto yy200;
				if (yych <= 'z') goto yy450;
				if (yych <= 0x7F) goto yy200;
				goto yy450;
			}
		}
yy452:
		YYDEBUG(452, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy539;
		if (yych == 'r') goto yy539;
		goto yy158;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy540;
		if (yych == 'y') goto yy540;
		goto yy158;
yy454:
		YYDEBUG(454, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'K') goto yy542;
		if (yych == 'k') goto yy542;
		goto yy158;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy544;
		if (yych == 'a') goto yy544;
		goto yy158;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CASE);
}
yy458:
		YYDEBUG(458, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy545;
		if (yych == 'h') goto yy545;
		goto yy158;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy547;
		if (yych == 's') goto yy547;
		goto yy158;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy549;
		if (yych == 'e') goto yy549;
		goto yy158;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy551;
		if (yych == 't') goto yy551;
		goto yy158;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy553;
		if (yych == 'i') goto yy553;
		goto yy158;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy554;
		if (yych == 'a') goto yy554;
		goto yy158;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy555;
		if (yych == 'u') goto yy555;
		goto yy158;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ECHO);
}
yy467:
		YYDEBUG(467, *YYCURSOR);
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'H') {
				if (yych <= '/') goto yy468;
				if (yych <= '9') goto yy157;
				if (yych >= 'A') goto yy157;
			} else {
				if (yych <= 'I') goto yy556;
				if (yych <= 'Z') goto yy157;
				if (yych >= '\\') goto yy265;
			}
		} else {
			if (yych <= 'h') {
				if (yych == '_') goto yy157;
				if (yych >= 'a') goto yy157;
			} else {
				if (yych <= 'i') goto yy556;
				if (yych <= 'z') goto yy157;
				if (yych >= 0x80) goto yy157;
			}
		}
yy468:
		YYDEBUG(468, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSE);
}
yy469:
		YYDEBUG(469, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy557;
		if (yych == 'y') goto yy557;
		goto yy158;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy559;
		if (yych == 'e') goto yy559;
		goto yy158;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy560;
		if (yych == 'o') goto yy560;
		goto yy158;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy561;
		if (yych == 'f') goto yy561;
		goto yy158;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy563;
		if (yych == 'w') goto yy563;
		goto yy158;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy564;
		if (yych == 'h') goto yy564;
		goto yy158;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EVAL);
}
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy565;
		if (yych == 'n') goto yy565;
		goto yy158;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy566;
		if (yych == 'l') goto yy566;
		goto yy158;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy568;
		if (yych == 'a') goto yy568;
		goto yy158;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy569;
		if (yych == 't') goto yy569;
		goto yy158;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy570;
		if (yych == 'a') goto yy570;
		goto yy158;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GOTO);
}
yy486:
		YYDEBUG(486, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy571;
		if (yych == 'e') goto yy571;
		goto yy158;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy572;
		if (yych == 'u') goto yy572;
		goto yy158;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy573;
			if (yych <= 'D') goto yy158;
			goto yy574;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy158;
				goto yy573;
			} else {
				if (yych == 'e') goto yy574;
				goto yy158;
			}
		}
yy489:
		YYDEBUG(489, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy575;
		if (yych == 'r') goto yy575;
		goto yy158;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy576;
		if (yych == 't') goto yy576;
		goto yy158;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yyaccept = 30;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LIST);
}
yy493:
		YYDEBUG(493, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy578;
		if (yych == 'h') goto yy578;
		goto yy158;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy580;
		if (yych == 's') goto yy580;
		goto yy158;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy581;
		if (yych == 't') goto yy581;
		goto yy158;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy583;
		if (yych == 'a') goto yy583;
		goto yy158;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy584;
		if (yych == 'e') goto yy584;
		goto yy158;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy585;
		if (yych == 'i') goto yy585;
		goto yy158;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy586;
		if (yych == 'i') goto yy586;
		goto yy158;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy587;
		if (yych == 'r') goto yy587;
		goto yy158;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy588;
		if (yych == 'i') goto yy588;
		goto yy158;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy589;
		if (yych == 'c') goto yy589;
		goto yy158;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy590;
		if (yych == 'w') goto yy590;
		goto yy158;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy592;
		if (yych == 't') goto yy592;
		goto yy158;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy594;
		if (yych == 't') goto yy594;
		goto yy158;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy596;
		if (yych == 'e') goto yy596;
		goto yy158;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy598;
		if (yych == 'd') goto yy598;
		goto yy158;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy600;
		if (yych == 'a') goto yy600;
		goto yy158;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy601;
		if (yych == 'r') goto yy601;
		goto yy158;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy602;
		if (yych == 'l') goto yy602;
		goto yy158;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy603;
		if (yych == 'n') goto yy603;
		goto yy158;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy604;
		if (yych == 'l') goto yy604;
		goto yy158;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy605;
		if (yych == 'n') goto yy605;
		goto yy158;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy606;
		if (yych == 't') goto yy606;
		goto yy158;
yy515:
		YYDEBUG(515, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy607;
		if (yych == 'm') goto yy607;
		goto yy158;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy608;
		if (yych == 'a') goto yy608;
		goto yy158;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy609;
		if (yych == 'y') goto yy609;
		goto yy200;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy611;
		if (yych == 'r') goto yy611;
		goto yy200;
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy616;
		if (yych == 'e') goto yy616;
		goto yy613;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy617;
		if (yych == 'l') goto yy617;
		goto yy200;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy618;
		if (yych == 't') goto yy618;
		goto yy200;
yy522:
		YYDEBUG(522, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy523:
		YYDEBUG(523, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy522;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy522;
			if (yych != ')') goto yy200;
		}
		YYDEBUG(524, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(525, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy620;
		if (yych == 'g') goto yy620;
		goto yy200;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy621;
		if (yych == 'c') goto yy621;
		goto yy200;
yy528:
		YYDEBUG(528, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(529, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy528;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy528;
			if (yych == ')') goto yy622;
			goto yy200;
		}
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy624;
		if (yych == 'n') goto yy624;
		goto yy200;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy625;
		if (yych == 't') goto yy625;
		goto yy200;
yy532:
		YYDEBUG(532, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy533:
		YYDEBUG(533, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy627;
				goto yy200;
			} else {
				if (yych <= '9') goto yy532;
				if (yych <= '@') goto yy200;
				goto yy532;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy532;
				goto yy200;
			} else {
				if (yych <= 'z') goto yy532;
				if (yych <= 0x7F) goto yy200;
				goto yy532;
			}
		}
yy534:
		YYDEBUG(534, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy535:
		YYDEBUG(535, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy627;
				goto yy200;
			} else {
				if (yych <= '9') goto yy534;
				if (yych <= '@') goto yy200;
				goto yy534;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy534;
				goto yy200;
			} else {
				if (yych <= 'z') goto yy534;
				if (yych <= 0x7F) goto yy200;
				goto yy534;
			}
		}
yy536:
		YYDEBUG(536, *YYCURSOR);
		++YYCURSOR;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	zend_bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation_uses_spaces = 0;
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		zend_string *saved_doc_comment = CG(doc_comment);
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;
		CG(doc_comment) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
		CG(doc_comment) = saved_doc_comment;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy536;
		goto yy537;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy628;
		if (yych == 'a') goto yy628;
		goto yy158;
yy540:
		YYDEBUG(540, *YYCURSOR);
		yyaccept = 31;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy541:
		YYDEBUG(541, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ARRAY);
}
yy542:
		YYDEBUG(542, *YYCURSOR);
		yyaccept = 32;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_BREAK);
}
yy544:
		YYDEBUG(544, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy629;
		if (yych == 'b') goto yy629;
		goto yy158;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yyaccept = 33;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CATCH);
}
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyaccept = 34;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS);
}
yy549:
		YYDEBUG(549, *YYCURSOR);
		yyaccept = 35;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLONE);
}
yy551:
		YYDEBUG(551, *YYCURSOR);
		yyaccept = 36;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONST);
}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy630;
		if (yych == 'n') goto yy630;
		goto yy158;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy631;
		if (yych == 'r') goto yy631;
		goto yy158;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy632;
		if (yych == 'l') goto yy632;
		goto yy158;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy633;
		if (yych == 'f') goto yy633;
		goto yy158;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yyaccept = 37;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EMPTY);
}
yy559:
		YYDEBUG(559, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy635;
		if (yych == 'c') goto yy635;
		goto yy158;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy636;
		if (yych == 'r') goto yy636;
		goto yy158;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yyaccept = 38;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy562:
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDIF);
}
yy563:
		YYDEBUG(563, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy638;
		if (yych == 'i') goto yy638;
		goto yy158;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy639;
		if (yych == 'i') goto yy639;
		goto yy158;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy640;
		if (yych == 'd') goto yy640;
		goto yy158;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yyaccept = 39;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'K') {
				if (yych <= '/') goto yy567;
				if (yych <= '9') goto yy157;
				if (yych >= 'A') goto yy157;
			} else {
				if (yych <= 'L') goto yy641;
				if (yych <= 'Z') goto yy157;
				if (yych >= '\\') goto yy265;
			}
		} else {
			if (yych <= 'k') {
				if (yych == '_') goto yy157;
				if (yych >= 'a') goto yy157;
			} else {
				if (yych <= 'l') goto yy641;
				if (yych <= 'z') goto yy157;
				if (yych >= 0x80) goto yy157;
			}
		}
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINAL);
}
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy642;
		if (yych == 'c') goto yy642;
		goto yy158;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy643;
		if (yych == 'i') goto yy643;
		goto yy158;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy644;
		if (yych == 'l') goto yy644;
		goto yy158;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy646;
		if (yych == 'm') goto yy646;
		goto yy158;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy647;
		if (yych == 'd') goto yy647;
		goto yy158;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy648;
		if (yych == 'n') goto yy648;
		goto yy158;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy649;
		if (yych == 'a') goto yy649;
		goto yy158;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy650;
		if (yych == 'f') goto yy650;
		goto yy158;
yy576:
		YYDEBUG(576, *YYCURSOR);
		yyaccept = 40;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ISSET);
}
yy578:
		YYDEBUG(578, *YYCURSOR);
		yyaccept = 41;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_MATCH);
}
yy580:
		YYDEBUG(580, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy651;
		if (yych == 'p') goto yy651;
		goto yy158;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yyaccept = 42;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRINT);
}
yy583:
		YYDEBUG(583, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy652;
		if (yych == 't') goto yy652;
		goto yy158;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy653;
		if (yych == 'c') goto yy653;
		goto yy158;
yy585:
		YYDEBUG(585, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy654;
		if (yych == 'c') goto yy654;
		goto yy158;
yy586:
		YYDEBUG(586, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy656;
		if (yych == 'r') goto yy656;
		goto yy158;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy657;
		if (yych == 'n') goto yy657;
		goto yy158;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy659;
		if (yych == 'c') goto yy659;
		goto yy158;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy661;
		if (yych == 'h') goto yy661;
		goto yy158;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yyaccept = 43;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_THROW);
}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yyaccept = 44;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT);
}
yy594:
		YYDEBUG(594, *YYCURSOR);
		yyaccept = 45;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_UNSET);
}
yy596:
		YYDEBUG(596, *YYCURSOR);
		yyaccept = 46;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_WHILE);
}
yy598:
		YYDEBUG(598, *YYCURSOR);
		yyaccept = 47;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy599;
			if (yych <= '\n') goto yy663;
			if (yych >= '\r') goto yy663;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy663;
			} else {
				if (yych == '\\') goto yy265;
			}
		}
yy599:
		YYDEBUG(599, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_YIELD);
}
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy665;
		if (yych == 's') goto yy665;
		goto yy158;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy666;
		goto yy158;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy667;
		if (yych == 'e') goto yy667;
		goto yy158;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy668;
		if (yych == 'c') goto yy668;
		goto yy158;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy669;
		if (yych == 't') goto yy669;
		goto yy158;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy670;
		if (yych == 'e') goto yy670;
		goto yy158;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy671;
		if (yych == 'h') goto yy671;
		goto yy158;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy672;
		if (yych == 'e') goto yy672;
		goto yy158;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy673;
		if (yych == 'i') goto yy673;
		goto yy158;
yy609:
		YYDEBUG(609, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(610, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy609;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy609;
			if (yych == ')') goto yy674;
			goto yy200;
		}
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy676;
		if (yych == 'y') goto yy676;
		goto yy200;
yy612:
		YYDEBUG(612, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy613:
		YYDEBUG(613, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy612;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy612;
			if (yych != ')') goto yy200;
		}
		YYDEBUG(614, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(615, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy678;
		if (yych == 'a') goto yy678;
		goto yy200;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy618;
		if (yych != 'e') goto yy200;
yy618:
		YYDEBUG(618, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(619, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy618;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy618;
			if (yych == ')') goto yy679;
			goto yy200;
		}
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy681;
		if (yych == 'e') goto yy681;
		goto yy200;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy682;
		if (yych == 't') goto yy682;
		goto yy200;
yy622:
		YYDEBUG(622, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(623, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_throw_exception(zend_ce_parse_error, "The (real) cast has been removed, use (float) instead", 0);
		RETURN_TOKEN(T_ERROR);
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy676;
		if (yych == 'g') goto yy676;
		goto yy200;
yy625:
		YYDEBUG(625, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(626, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy625;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy625;
			if (yych == ')') goto yy684;
			goto yy200;
		}
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy536;
		if (yych == '\r') goto yy538;
		goto yy200;
yy628:
		YYDEBUG(628, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy686;
		if (yych == 'c') goto yy686;
		goto yy158;
yy629:
		YYDEBUG(629, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy687;
		if (yych == 'l') goto yy687;
		goto yy158;
yy630:
		YYDEBUG(630, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy688;
		if (yych == 'u') goto yy688;
		goto yy158;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy689;
		if (yych == 'e') goto yy689;
		goto yy158;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy691;
		if (yych == 't') goto yy691;
		goto yy158;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyaccept = 48;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSEIF);
}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy693;
		if (yych == 'l') goto yy693;
		goto yy158;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yyaccept = 49;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy637;
				if (yych <= '9') goto yy157;
				if (yych >= 'A') goto yy157;
			} else {
				if (yych <= 'E') goto yy694;
				if (yych <= 'Z') goto yy157;
				if (yych >= '\\') goto yy265;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy157;
				if (yych >= 'a') goto yy157;
			} else {
				if (yych <= 'e') goto yy694;
				if (yych <= 'z') goto yy157;
				if (yych >= 0x80) goto yy157;
			}
		}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOR);
}
yy638:
		YYDEBUG(638, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy695;
		if (yych == 't') goto yy695;
		goto yy158;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy696;
		if (yych == 'l') goto yy696;
		goto yy158;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy697;
		if (yych == 's') goto yy697;
		goto yy158;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy699;
		if (yych == 'y') goto yy699;
		goto yy158;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy701;
		if (yych == 'h') goto yy701;
		goto yy158;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy703;
		if (yych == 'o') goto yy703;
		goto yy158;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yyaccept = 50;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GLOBAL);
}
yy646:
		YYDEBUG(646, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy704;
		if (yych == 'e') goto yy704;
		goto yy158;
yy647:
		YYDEBUG(647, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy705;
		if (yych == 'e') goto yy705;
		goto yy158;
yy648:
		YYDEBUG(648, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy707;
		if (yych == 'c') goto yy707;
		goto yy158;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy708;
		if (yych == 'd') goto yy708;
		goto yy158;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy709;
		if (yych == 'a') goto yy709;
		goto yy158;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy710;
		if (yych == 'a') goto yy710;
		goto yy158;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy711;
		if (yych == 'e') goto yy711;
		goto yy158;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy713;
		if (yych == 't') goto yy713;
		goto yy158;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC);
}
yy656:
		YYDEBUG(656, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy714;
		if (yych == 'e') goto yy714;
		goto yy158;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_RETURN);
}
yy659:
		YYDEBUG(659, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy660:
		YYDEBUG(660, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_STATIC);
}
yy661:
		YYDEBUG(661, *YYCURSOR);
		yyaccept = 54;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_SWITCH);
}
yy663:
		YYDEBUG(663, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(664, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy200;
				goto yy663;
			} else {
				if (yych == '\r') goto yy663;
				goto yy200;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy663;
				if (yych <= 'E') goto yy200;
				goto yy716;
			} else {
				if (yych == 'f') goto yy716;
				goto yy200;
			}
		}
yy665:
		YYDEBUG(665, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy717;
		if (yych == 's') goto yy717;
		goto yy158;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy718;
		goto yy158;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy720;
		goto yy158;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy721;
		if (yych == 't') goto yy721;
		goto yy158;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy722;
		goto yy158;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy723;
		goto yy158;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy724;
		if (yych == 'o') goto yy724;
		goto yy158;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy725;
		if (yych == 's') goto yy725;
		goto yy158;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy726;
		if (yych == 't') goto yy726;
		goto yy158;
yy674:
		YYDEBUG(674, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy676:
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(677, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy676;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy676;
			if (yych == ')') goto yy727;
			goto yy200;
		}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy612;
		if (yych == 'n') goto yy612;
		goto yy200;
yy679:
		YYDEBUG(679, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(680, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy681:
		YYDEBUG(681, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy522;
		if (yych == 'r') goto yy522;
		goto yy200;
yy682:
		YYDEBUG(682, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(683, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy682;
			goto yy200;
		} else {
			if (yych <= ' ') goto yy682;
			if (yych == ')') goto yy729;
			goto yy200;
		}
yy684:
		YYDEBUG(684, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy686:
		YYDEBUG(686, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy731;
		if (yych == 't') goto yy731;
		goto yy158;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy733;
		if (yych == 'e') goto yy733;
		goto yy158;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy735;
		if (yych == 'e') goto yy735;
		goto yy158;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yyaccept = 55;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DECLARE);
}
yy691:
		YYDEBUG(691, *YYCURSOR);
		yyaccept = 56;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DEFAULT);
}
yy693:
		YYDEBUG(693, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy737;
		if (yych == 'a') goto yy737;
		goto yy158;
yy694:
		YYDEBUG(694, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy738;
		if (yych == 'a') goto yy738;
		goto yy158;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy739;
		if (yych == 'c') goto yy739;
		goto yy158;
yy696:
		YYDEBUG(696, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy740;
		if (yych == 'e') goto yy740;
		goto yy158;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yyaccept = 57;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXTENDS);
}
yy699:
		YYDEBUG(699, *YYCURSOR);
		yyaccept = 58;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINALLY);
}
yy701:
		YYDEBUG(701, *YYCURSOR);
		yyaccept = 59;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOREACH);
}
yy703:
		YYDEBUG(703, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy742;
		if (yych == 'n') goto yy742;
		goto yy158;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy744;
		if (yych == 'n') goto yy744;
		goto yy158;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yyaccept = 60;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy706;
				if (yych <= '9') goto yy157;
			} else {
				if (yych <= 'Z') goto yy157;
				if (yych >= '\\') goto yy265;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy745;
			} else {
				if (yych <= 'z') goto yy157;
				if (yych >= 0x80) goto yy157;
			}
		}
yy706:
		YYDEBUG(706, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE);
}
yy707:
		YYDEBUG(707, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy746;
		if (yych == 'e') goto yy746;
		goto yy158;
yy708:
		YYDEBUG(708, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy747;
		if (yych == 'o') goto yy747;
		goto yy158;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy748;
		if (yych == 'c') goto yy748;
		goto yy158;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy749;
		if (yych == 'c') goto yy749;
		goto yy158;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yyaccept = 61;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy712:
		YYDEBUG(712, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE);
}
yy713:
		YYDEBUG(713, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy750;
		if (yych == 'e') goto yy750;
		goto yy158;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yyaccept = 62;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy715;
				if (yych <= '9') goto yy157;
			} else {
				if (yych <= 'Z') goto yy157;
				if (yych >= '\\') goto yy265;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy751;
			} else {
				if (yych <= 'z') goto yy157;
				if (yych >= 0x80) goto yy157;
			}
		}
yy715:
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE);
}
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy752;
		if (yych == 'r') goto yy752;
		goto yy200;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy753;
		goto yy158;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yyaccept = 63;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy719:
		YYDEBUG(719, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DIR);
}
yy720:
		YYDEBUG(720, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy754;
		goto yy158;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy756;
		if (yych == 'i') goto yy756;
		goto yy158;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy757;
		if (yych == 'c') goto yy757;
		goto yy158;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy758;
		goto yy158;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy760;
		if (yych == 'd') goto yy760;
		goto yy158;
yy725:
		YYDEBUG(725, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy761;
		if (yych == 'p') goto yy761;
		goto yy158;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy762;
		goto yy158;
yy727:
		YYDEBUG(727, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(728, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy729:
		YYDEBUG(729, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(730, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy731:
		YYDEBUG(731, *YYCURSOR);
		yyaccept = 64;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy732:
		YYDEBUG(732, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ABSTRACT);
}
yy733:
		YYDEBUG(733, *YYCURSOR);
		yyaccept = 65;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CALLABLE);
}
yy735:
		YYDEBUG(735, *YYCURSOR);
		yyaccept = 66;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONTINUE);
}
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy763;
		if (yych == 'r') goto yy763;
		goto yy158;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy764;
		if (yych == 'c') goto yy764;
		goto yy158;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy765;
		if (yych == 'h') goto yy765;
		goto yy158;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yyaccept = 67;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDWHILE);
}
yy742:
		YYDEBUG(742, *YYCURSOR);
		yyaccept = 68;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNCTION);
}
yy744:
		YYDEBUG(744, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy767;
		if (yych == 't') goto yy767;
		goto yy158;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy768;
		if (yych == 'o') goto yy768;
		goto yy158;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy769;
		if (yych == 'o') goto yy769;
		goto yy158;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy770;
		if (yych == 'f') goto yy770;
		goto yy158;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy772;
		if (yych == 'e') goto yy772;
		goto yy158;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy774;
		if (yych == 'e') goto yy774;
		goto yy158;
yy750:
		YYDEBUG(750, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy776;
		if (yych == 'd') goto yy776;
		goto yy158;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy778;
		if (yych == 'o') goto yy778;
		goto yy158;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy779;
		if (yych == 'o') goto yy779;
		goto yy200;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy780;
		goto yy158;
yy754:
		YYDEBUG(754, *YYCURSOR);
		yyaccept = 69;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy755:
		YYDEBUG(755, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FILE);
}
yy756:
		YYDEBUG(756, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy782;
		if (yych == 'o') goto yy782;
		goto yy158;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy783;
		if (yych == 'o') goto yy783;
		goto yy158;
yy758:
		YYDEBUG(758, *YYCURSOR);
		yyaccept = 70;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy759:
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LINE);
}
yy760:
		YYDEBUG(760, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy784;
		goto yy158;
yy761:
		YYDEBUG(761, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy785;
		if (yych == 'a') goto yy785;
		goto yy158;
yy762:
		YYDEBUG(762, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy786;
		goto yy158;
yy763:
		YYDEBUG(763, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy788;
		if (yych == 'e') goto yy788;
		goto yy158;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy790;
		if (yych == 'h') goto yy790;
		goto yy158;
yy765:
		YYDEBUG(765, *YYCURSOR);
		yyaccept = 71;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDSWITCH);
}
yy767:
		YYDEBUG(767, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy792;
		if (yych == 's') goto yy792;
		goto yy158;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy794;
		if (yych == 'n') goto yy794;
		goto yy158;
yy769:
		YYDEBUG(769, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy795;
		if (yych == 'f') goto yy795;
		goto yy158;
yy770:
		YYDEBUG(770, *YYCURSOR);
		yyaccept = 72;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy771:
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN_WITH_IDENT(T_INSTEADOF);
}
yy772:
		YYDEBUG(772, *YYCURSOR);
		yyaccept = 73;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy773:
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INTERFACE);
}
yy774:
		YYDEBUG(774, *YYCURSOR);
		yyaccept = 74;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy797;
yy775:
		YYDEBUG(775, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NAMESPACE);
}
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyaccept = 75;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy777:
		YYDEBUG(777, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED);
}
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy798;
		if (yych == 'n') goto yy798;
		goto yy158;
yy779:
		YYDEBUG(779, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy799;
		if (yych == 'm') goto yy799;
		goto yy200;
yy780:
		YYDEBUG(780, *YYCURSOR);
		yyaccept = 76;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy781:
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS_C);
}
yy782:
		YYDEBUG(782, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy800;
		if (yych == 'n') goto yy800;
		goto yy158;
yy783:
		YYDEBUG(783, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy801;
		if (yych == 'm') goto yy801;
		goto yy158;
yy784:
		YYDEBUG(784, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy802;
		goto yy158;
yy785:
		YYDEBUG(785, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy804;
		if (yych == 'c') goto yy804;
		goto yy158;
yy786:
		YYDEBUG(786, *YYCURSOR);
		yyaccept = 77;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy787:
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT_C);
}
yy788:
		YYDEBUG(788, *YYCURSOR);
		yyaccept = 78;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy789:
		YYDEBUG(789, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDDECLARE);
}
yy790:
		YYDEBUG(790, *YYCURSOR);
		yyaccept = 79;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy791:
		YYDEBUG(791, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOREACH);
}
yy792:
		YYDEBUG(792, *YYCURSOR);
		yyaccept = 80;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy793:
		YYDEBUG(793, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IMPLEMENTS);
}
yy794:
		YYDEBUG(794, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy805;
		if (yych == 'c') goto yy805;
		goto yy158;
yy795:
		YYDEBUG(795, *YYCURSOR);
		yyaccept = 81;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy796:
		YYDEBUG(796, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INSTANCEOF);
}
yy797:
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy200;
			if (yych <= 'Z') goto yy806;
			if (yych <= '^') goto yy200;
			goto yy806;
		} else {
			if (yych <= '`') goto yy200;
			if (yych <= 'z') goto yy806;
			if (yych <= 0x7F) goto yy200;
			goto yy806;
		}
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy809;
		if (yych == 'c') goto yy809;
		goto yy158;
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy810;
				goto yy200;
			} else {
				if (yych <= '@') goto yy810;
				if (yych <= 'Z') goto yy200;
				goto yy810;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy200;
				goto yy810;
			} else {
				if (yych <= 'z') goto yy200;
				if (yych <= 0x7F) goto yy810;
				goto yy200;
			}
		}
yy800:
		YYDEBUG(800, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy812;
		goto yy158;
yy801:
		YYDEBUG(801, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy813;
		if (yych == 'p') goto yy813;
		goto yy158;
yy802:
		YYDEBUG(802, *YYCURSOR);
		yyaccept = 82;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy803:
		YYDEBUG(803, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_METHOD_C);
}
yy804:
		YYDEBUG(804, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy814;
		if (yych == 'e') goto yy814;
		goto yy158;
yy805:
		YYDEBUG(805, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy815;
		if (yych == 'e') goto yy815;
		goto yy158;
yy806:
		YYDEBUG(806, *YYCURSOR);
		yyaccept = 83;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(807, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy808;
				if (yych <= '9') goto yy806;
			} else {
				if (yych <= 'Z') goto yy806;
				if (yych >= '\\') goto yy797;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy806;
			} else {
				if (yych <= 'z') goto yy806;
				if (yych >= 0x80) goto yy806;
			}
		}
yy808:
		YYDEBUG(808, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_RELATIVE, sizeof("namespace\\") - 1);
}
yy809:
		YYDEBUG(809, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy817;
		if (yych == 'e') goto yy817;
		goto yy158;
yy810:
		YYDEBUG(810, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(811, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_IDENT(T_YIELD_FROM);
}
yy812:
		YYDEBUG(812, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy819;
		goto yy158;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy821;
		if (yych == 'i') goto yy821;
		goto yy158;
yy814:
		YYDEBUG(814, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy822;
		goto yy158;
yy815:
		YYDEBUG(815, *YYCURSOR);
		yyaccept = 84;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy816:
		YYDEBUG(816, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE_ONCE);
}
yy817:
		YYDEBUG(817, *YYCURSOR);
		yyaccept = 85;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy818:
		YYDEBUG(818, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE_ONCE);
}
yy819:
		YYDEBUG(819, *YYCURSOR);
		yyaccept = 86;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy820:
		YYDEBUG(820, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNC_C);
}
yy821:
		YYDEBUG(821, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy823;
		if (yych == 'l') goto yy823;
		goto yy158;
yy822:
		YYDEBUG(822, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy824;
		goto yy158;
yy823:
		YYDEBUG(823, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy826;
		if (yych == 'e') goto yy826;
		goto yy158;
yy824:
		YYDEBUG(824, *YYCURSOR);
		yyaccept = 87;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy825:
		YYDEBUG(825, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NS_C);
}
yy826:
		YYDEBUG(826, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy827;
		if (yych != 'r') goto yy158;
yy827:
		YYDEBUG(827, *YYCURSOR);
		yyaccept = 88;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych == '\\') goto yy265;
yy828:
		YYDEBUG(828, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_HALT_COMPILER);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(829, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy833;
		}
		if (yych <= 'Z') {
			if (yych <= '>') {
				if (yych == '-') goto yy836;
			} else {
				if (yych <= '?') goto yy837;
				if (yych >= 'A') goto yy838;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy838;
			} else {
				if (yych <= 'z') goto yy838;
				if (yych >= 0x80) goto yy838;
			}
		}
		YYDEBUG(831, *YYCURSOR);
		++YYCURSOR;
yy832:
		YYDEBUG(832, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy833:
		YYDEBUG(833, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(834, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy833;
		}
		YYDEBUG(835, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy836:
		YYDEBUG(836, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy841;
		goto yy832;
yy837:
		YYDEBUG(837, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '-') goto yy843;
		goto yy832;
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(839, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy838;
		}
		YYDEBUG(840, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy841:
		YYDEBUG(841, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(842, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy843:
		YYDEBUG(843, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy845;
		YYDEBUG(844, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy832;
yy845:
		YYDEBUG(845, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(846, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(847, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy849;
			if (yych <= 'Z') goto yy851;
			if (yych >= '_') goto yy851;
		} else {
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy851;
			if (yych >= 0x80) goto yy851;
		}
yy849:
		YYDEBUG(849, *YYCURSOR);
		++YYCURSOR;
yy850:
		YYDEBUG(850, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy851:
		YYDEBUG(851, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy850;
				if (yych <= '9') goto yy853;
				goto yy850;
			} else {
				if (yych <= '[') goto yy853;
				if (yych <= '^') goto yy850;
				goto yy853;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy850;
				if (yych <= 'z') goto yy853;
				goto yy850;
			} else {
				if (yych <= '}') goto yy853;
				if (yych <= 0x7F) goto yy850;
				goto yy853;
			}
		}
yy852:
		YYDEBUG(852, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy853:
		YYDEBUG(853, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy852;
		}
		if (yych <= '@') goto yy854;
		if (yych <= '[') goto yy855;
		if (yych == '}') goto yy855;
yy854:
		YYDEBUG(854, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy850;
yy855:
		YYDEBUG(855, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(856, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(857, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(859, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(860, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,   0, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(861, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy863;
					if (yych <= '\n') goto yy865;
				} else {
					if (yych <= '\r') goto yy865;
					if (yych >= ' ') goto yy865;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy867;
					if (yych <= '#') goto yy865;
					goto yy869;
				} else {
					if (yych == '\'') goto yy865;
					if (yych <= '/') goto yy867;
					goto yy870;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy872;
					if (yych <= '@') goto yy867;
					goto yy874;
				} else {
					if (yych <= '[') goto yy867;
					if (yych <= '\\') goto yy865;
					goto yy877;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy874;
					goto yy867;
				} else {
					if (yych <= 'z') goto yy874;
					if (yych <= '~') goto yy867;
					if (yych >= 0x80) goto yy874;
				}
			}
		}
yy863:
		YYDEBUG(863, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(864, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy865:
		YYDEBUG(865, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(866, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy867:
		YYDEBUG(867, *YYCURSOR);
		++YYCURSOR;
yy868:
		YYDEBUG(868, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy869:
		YYDEBUG(869, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy868;
			if (yych <= 'Z') goto yy879;
			if (yych <= '^') goto yy868;
			goto yy879;
		} else {
			if (yych <= '`') goto yy868;
			if (yych <= 'z') goto yy879;
			if (yych <= 0x7F) goto yy868;
			goto yy879;
		}
yy870:
		YYDEBUG(870, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'A') {
				if (yych <= '/') goto yy871;
				if (yych <= '9') goto yy882;
			} else {
				if (yych <= 'B') goto yy885;
				if (yych >= 'X') goto yy887;
			}
		} else {
			if (yych <= 'a') {
				if (yych == '_') goto yy888;
			} else {
				if (yych <= 'b') goto yy885;
				if (yych == 'x') goto yy887;
			}
		}
yy871:
		YYDEBUG(871, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy872:
		YYDEBUG(872, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(873, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy872;
		}
		if (yych == '_') goto yy888;
		goto yy871;
yy874:
		YYDEBUG(874, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(875, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy874;
		}
		YYDEBUG(876, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy877:
		YYDEBUG(877, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(878, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy879:
		YYDEBUG(879, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(880, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy879;
			} else {
				if (yych <= '@') goto yy881;
				if (yych <= 'Z') goto yy879;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy879;
			} else {
				if (yych <= 'z') goto yy879;
				if (yych >= 0x80) goto yy879;
			}
		}
yy881:
		YYDEBUG(881, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy882:
		YYDEBUG(882, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(883, *YYCURSOR);
		if (yych <= '/') goto yy884;
		if (yych <= '9') goto yy882;
		if (yych == '_') goto yy888;
yy884:
		YYDEBUG(884, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy885:
		YYDEBUG(885, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy889;
		}
yy886:
		YYDEBUG(886, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy871;
		} else {
			goto yy884;
		}
yy887:
		YYDEBUG(887, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy891;
		}
		goto yy886;
yy888:
		YYDEBUG(888, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy886;
		if (yych <= '9') goto yy882;
		goto yy886;
yy889:
		YYDEBUG(889, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(890, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy889;
		}
		if (yych == '_') goto yy885;
		goto yy884;
yy891:
		YYDEBUG(891, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(892, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy891;
		}
		if (yych == '_') goto yy887;
		goto yy884;
	}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

emit_token_with_ident:
	if (PARSER_MODE()) {
		elem->ident.offset = SCNG(yy_text) - SCNG(yy_start);
		elem->ident.len = SCNG(yy_leng);
	}
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
