/* Generated by re2c 2.0.3 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@php.net>                                 |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((const char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (const unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6

#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
ZEND_API size_t ini_scanner_globals_offset;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

#define ZEND_SYSTEM_INI CG(ini_parser_unbuffered_errors)

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yyleng) {                                 \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng && (                              \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, ZEND_SYSTEM_INI))


#define RETURN_TOKEN(type, str, len) {                             \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED &&            \
		(YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW))) {\
		zend_ini_copy_typed_value(ini_lval, type, str, len);       \
		Z_EXTRA_P(ini_lval) = 0;                                   \
	} else {                                                       \
		zend_ini_copy_value(ini_lval, str, len);                   \
	}                                                              \
	return type;                                                   \
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(const char *str, unsigned int len)
{
	YYCURSOR = (const YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner() */
static zend_result init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_string_copy(fh->filename);
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner() */
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		zend_string_release(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno() */
ZEND_COLD int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename() */
ZEND_COLD const char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ZSTR_VAL(ini_filename) : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning() */
zend_result zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning() */
zend_result zend_ini_prepare_string_for_scanning(const char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string() */
static void zend_ini_escape_string(zval *lval, const char *str, int len, char quote_type)
{
	char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
					ZEND_FALLTHROUGH;
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VAR_FALLBACK;
			} else {
				if (YYGETCONDITION() < 8) {
					goto yyc_ST_VARNAME;
				} else {
					goto yyc_ST_RAW;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			128, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy13;
		}
		if (yych <= 'M') {
			if (yych <= '$') {
				if (yych <= '\f') {
					if (yych <= 0x08) {
						if (yych >= 0x01) goto yy4;
					} else {
						if (yych <= '\t') goto yy7;
						if (yych <= '\n') goto yy10;
						goto yy4;
					}
				} else {
					if (yych <= 0x1F) {
						if (yych <= '\r') goto yy12;
						goto yy4;
					} else {
						if (yych == '#') goto yy4;
						goto yy15;
					}
				}
			} else {
				if (yych <= ':') {
					if (yych <= '&') {
						if (yych <= '%') goto yy4;
						goto yy15;
					} else {
						if (yych <= '\'') goto yy4;
						if (yych <= ')') goto yy15;
						goto yy4;
					}
				} else {
					if (yych <= '=') {
						if (yych <= ';') goto yy17;
						if (yych <= '<') goto yy4;
						goto yy19;
					} else {
						if (yych == 'F') goto yy22;
						goto yy4;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'X') {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy23;
						goto yy24;
					} else {
						if (yych == 'T') goto yy25;
						goto yy4;
					}
				} else {
					if (yych <= '[') {
						if (yych <= 'Y') goto yy26;
						if (yych <= 'Z') goto yy4;
						goto yy27;
					} else {
						if (yych <= '\\') goto yy4;
						if (yych <= '^') goto yy15;
						goto yy4;
					}
				}
			} else {
				if (yych <= 's') {
					if (yych <= 'm') {
						if (yych <= 'f') goto yy22;
						goto yy4;
					} else {
						if (yych <= 'n') goto yy23;
						if (yych <= 'o') goto yy24;
						goto yy4;
					}
				} else {
					if (yych <= 'y') {
						if (yych <= 't') goto yy25;
						if (yych <= 'x') goto yy4;
						goto yy26;
					} else {
						if (yych <= 'z') goto yy4;
						if (yych <= '~') goto yy15;
						goto yy4;
					}
				}
			}
		}
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy5:
		YYDEBUG(5, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy4;
		}
		if (yych <= '=') goto yy6;
		if (yych <= '[') goto yy29;
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(8, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy7;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy9;
			if (yych <= '\n') goto yy10;
			if (yych >= '\r') goto yy12;
		} else {
			if (yych <= ';') {
				if (yych >= ';') goto yy17;
			} else {
				if (yych == '=') goto yy19;
			}
		}
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
yy11:
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy10;
		goto yy11;
yy13:
		YYDEBUG(13, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(14, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy13;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy6;
					if (yych <= 0x08) goto yy4;
					goto yy7;
				} else {
					if (yych <= '\n') goto yy10;
					if (yych <= '\f') goto yy4;
					goto yy12;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy4;
					if (yych <= '"') goto yy6;
					goto yy4;
				} else {
					if (yych == '%') goto yy4;
					goto yy6;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy4;
					if (yych <= ')') goto yy6;
					goto yy4;
				} else {
					if (yych <= ';') goto yy17;
					if (yych <= '<') goto yy4;
					goto yy19;
				}
			} else {
				if (yych <= '\\') {
					if (yych == '[') goto yy29;
					goto yy4;
				} else {
					if (yych <= '^') goto yy6;
					if (yych <= 'z') goto yy4;
					if (yych <= '~') goto yy6;
					goto yy4;
				}
			}
		}
yy15:
		YYDEBUG(15, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(16, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy17;
		}
		if (yych <= '\n') goto yy32;
		goto yy34;
yy19:
		YYDEBUG(19, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(20, *YYCURSOR);
		if (yych == '\t') goto yy19;
		if (yych == ' ') goto yy19;
		YYDEBUG(21, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_RAW);
	} else {
		BEGIN(ST_VALUE);
	}
	return '=';
}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy35;
		if (yych == 'a') goto yy35;
		goto yy5;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy36;
			if (yych <= 'T') goto yy5;
			goto yy38;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy5;
				goto yy36;
			} else {
				if (yych == 'u') goto yy38;
				goto yy5;
			}
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy39;
			if (yych <= 'M') goto yy5;
			goto yy40;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy5;
				goto yy39;
			} else {
				if (yych == 'n') goto yy40;
				goto yy5;
			}
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy43;
		if (yych == 'r') goto yy43;
		goto yy5;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy44;
		if (yych == 'e') goto yy44;
		goto yy5;
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_SECTION_RAW);
	} else {
		BEGIN(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
yy29:
		YYDEBUG(29, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(30, *YYCURSOR);
		if (yych == '\t') goto yy29;
		if (yych == ' ') goto yy29;
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	BEGIN(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
yy32:
		YYDEBUG(32, *YYCURSOR);
		++YYCURSOR;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy32;
		goto yy33;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy45;
		if (yych == 'l') goto yy45;
		goto yy5;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy37;
					if (yych <= 0x08) goto yy5;
					goto yy46;
				} else {
					if (yych <= '\n') goto yy37;
					if (yych != '\r') goto yy5;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy48;
					if (yych >= '#') goto yy5;
				} else {
					if (yych == '%') goto yy5;
					if (yych >= '\'') goto yy5;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy37;
					if (yych <= ':') goto yy5;
				} else {
					if (yych == '=') goto yy37;
					if (yych <= 'M') goto yy5;
					goto yy50;
				}
			} else {
				if (yych <= 'm') {
					if (yych <= '\\') goto yy5;
					if (yych >= '_') goto yy5;
				} else {
					if (yych <= 'n') goto yy50;
					if (yych <= 'z') goto yy5;
					if (yych >= 0x7F) goto yy5;
				}
			}
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy51;
		if (yych == 'l') goto yy51;
		goto yy5;
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy48;
		if (yych == 'f') goto yy48;
		goto yy5;
yy40:
		YYDEBUG(40, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(41, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy42;
					if (yych <= 0x08) goto yy4;
					goto yy52;
				} else {
					if (yych <= '\n') goto yy42;
					if (yych <= '\f') goto yy4;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy4;
					if (yych <= ' ') goto yy40;
				} else {
					if (yych == '$') goto yy42;
					if (yych <= '%') goto yy4;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy4;
					if (yych >= '*') goto yy4;
				} else {
					if (yych == '<') goto yy4;
				}
			} else {
				if (yych <= '\\') {
					if (yych == '[') goto yy29;
					goto yy4;
				} else {
					if (yych <= '^') goto yy42;
					if (yych <= 'z') goto yy4;
					if (yych >= 0x7F) goto yy4;
				}
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy54;
		if (yych == 'u') goto yy54;
		goto yy5;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy40;
		if (yych == 's') goto yy40;
		goto yy5;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy50;
		if (yych == 's') goto yy50;
		goto yy5;
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		if (yych == '\t') goto yy46;
		if (yych == ' ') goto yy46;
		goto yy37;
yy48:
		YYDEBUG(48, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(49, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy37;
					if (yych <= 0x08) goto yy4;
					goto yy46;
				} else {
					if (yych <= '\n') goto yy37;
					if (yych <= '\f') goto yy4;
					goto yy37;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy4;
					if (yych <= ' ') goto yy48;
					goto yy37;
				} else {
					if (yych == '$') goto yy37;
					if (yych <= '%') goto yy4;
					goto yy37;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy4;
					if (yych <= ')') goto yy37;
					goto yy4;
				} else {
					if (yych == '<') goto yy4;
					goto yy37;
				}
			} else {
				if (yych <= '\\') {
					if (yych == '[') goto yy29;
					goto yy4;
				} else {
					if (yych <= '^') goto yy37;
					if (yych <= 'z') goto yy4;
					if (yych <= '~') goto yy37;
					goto yy4;
				}
			}
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy48;
		if (yych == 'e') goto yy48;
		goto yy5;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy55;
		if (yych == 'l') goto yy55;
		goto yy5;
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(53, *YYCURSOR);
		if (yych == '\t') goto yy52;
		if (yych == ' ') goto yy52;
		goto yy42;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy40;
		if (yych == 'e') goto yy40;
		goto yy5;
yy55:
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(56, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy57;
					if (yych <= 0x08) goto yy4;
					goto yy58;
				} else {
					if (yych <= '\n') goto yy57;
					if (yych <= '\f') goto yy4;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy4;
					if (yych <= ' ') goto yy55;
				} else {
					if (yych == '$') goto yy57;
					if (yych <= '%') goto yy4;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy4;
					if (yych >= '*') goto yy4;
				} else {
					if (yych == '<') goto yy4;
				}
			} else {
				if (yych <= '\\') {
					if (yych == '[') goto yy29;
					goto yy4;
				} else {
					if (yych <= '^') goto yy57;
					if (yych <= 'z') goto yy4;
					if (yych >= 0x7F) goto yy4;
				}
			}
		}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		if (yych == '\t') goto yy58;
		if (yych == ' ') goto yy58;
		goto yy57;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(60, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy65;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy62;
					if (yych <= '\n') goto yy67;
				} else {
					if (yych <= '\r') goto yy67;
					if (yych >= '"') goto yy69;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy71;
				} else {
					if (yych <= '\'') goto yy72;
					if (yych <= ',') goto yy62;
					if (yych <= '.') goto yy73;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy74;
					if (yych >= ';') goto yy67;
				} else {
					if (yych <= '@') goto yy62;
					if (yych <= 'Z') goto yy77;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy80;
					if (yych <= ']') goto yy81;
				} else {
					if (yych == '`') goto yy62;
					if (yych <= 'z') goto yy77;
				}
			}
		}
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy63:
		YYDEBUG(63, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy62;
		}
		if (yych <= '"') goto yy64;
		if (yych <= '$') goto yy83;
		if (yych <= ';') goto yy64;
		if (yych <= '\\') goto yy80;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(66, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy65;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy62;
				if (yych <= '\n') goto yy64;
				if (yych <= '\f') goto yy62;
				goto yy64;
			} else {
				if (yych == '"') goto yy69;
				if (yych <= '#') goto yy62;
				goto yy83;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy64;
				if (yych <= ':') goto yy62;
				goto yy64;
			} else {
				if (yych <= '[') goto yy62;
				if (yych <= '\\') goto yy80;
				if (yych <= ']') goto yy81;
				goto yy62;
			}
		}
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy68;
			if (yych <= '[') goto yy62;
			goto yy85;
		} else {
			if (yych == '{') goto yy87;
			goto yy62;
		}
yy72:
		YYDEBUG(72, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy89;
		}
		goto yy68;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy63;
		if (yych <= '9') goto yy91;
		goto yy63;
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy74;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy76;
				if (yych <= '\f') goto yy62;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy62;
				} else {
					if (yych == '$') goto yy83;
					goto yy62;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy76;
				if (yych == '.') goto yy91;
				goto yy62;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy62;
				} else {
					if (yych <= '\\') goto yy80;
					if (yych >= '^') goto yy62;
				}
			}
		}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(78, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy77;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy79;
				if (yych <= '\f') goto yy62;
			} else {
				if (yych == '"') goto yy79;
				if (yych <= '#') goto yy62;
				goto yy83;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy79;
				if (yych <= ':') goto yy62;
			} else {
				if (yych <= '[') goto yy62;
				if (yych <= '\\') goto yy80;
				if (yych >= '^') goto yy62;
			}
		}
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy62;
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy84;
			if (yych <= '[') goto yy62;
			goto yy85;
		} else {
			if (yych != '{') goto yy62;
		}
yy84:
		YYDEBUG(84, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy64;
			} else {
				goto yy76;
			}
		} else {
			goto yy79;
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy85;
		}
		goto yy62;
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy89:
		YYDEBUG(89, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(90, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy89;
		}
		goto yy93;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(92, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy76;
				if (yych <= '\f') goto yy62;
				goto yy76;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy62;
					goto yy76;
				} else {
					if (yych == '$') goto yy83;
					goto yy62;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy76;
				if (yych <= '/') goto yy62;
				if (yych <= '9') goto yy91;
				goto yy62;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy76;
					goto yy62;
				} else {
					if (yych <= '\\') goto yy80;
					if (yych <= ']') goto yy76;
					goto yy62;
				}
			}
		}
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(94, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(95, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy100;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy97;
					if (yych <= '\n') goto yy102;
				} else {
					if (yych <= '\r') goto yy102;
					if (yych >= '"') goto yy104;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy106;
				} else {
					if (yych <= '\'') goto yy107;
					if (yych <= ',') goto yy97;
					if (yych <= '.') goto yy108;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy109;
					if (yych >= ';') goto yy102;
				} else {
					if (yych <= '@') goto yy97;
					if (yych <= 'Z') goto yy112;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy115;
					if (yych <= ']') goto yy116;
				} else {
					if (yych == '`') goto yy97;
					if (yych <= 'z') goto yy112;
				}
			}
		}
yy97:
		YYDEBUG(97, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy98:
		YYDEBUG(98, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy97;
		}
		if (yych <= '"') goto yy99;
		if (yych <= '$') goto yy119;
		if (yych <= ';') goto yy99;
		if (yych <= '\\') goto yy115;
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(101, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy100;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy97;
				if (yych <= '\n') goto yy99;
				if (yych <= '\f') goto yy97;
				goto yy99;
			} else {
				if (yych == '"') goto yy104;
				if (yych <= '#') goto yy97;
				goto yy119;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy99;
				if (yych <= ':') goto yy97;
				goto yy99;
			} else {
				if (yych <= '[') goto yy97;
				if (yych <= '\\') goto yy115;
				if (yych <= ']') goto yy99;
				goto yy97;
			}
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy103;
			if (yych <= '[') goto yy97;
			goto yy121;
		} else {
			if (yych == '{') goto yy123;
			goto yy97;
		}
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy125;
		}
		goto yy103;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy98;
		if (yych <= '9') goto yy127;
		goto yy98;
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy109;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy111;
				if (yych <= '\f') goto yy97;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy97;
				} else {
					if (yych == '$') goto yy119;
					goto yy97;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy111;
				if (yych == '.') goto yy127;
				goto yy97;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy97;
				} else {
					if (yych <= '\\') goto yy115;
					if (yych >= '^') goto yy97;
				}
			}
		}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy112;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy114;
				if (yych <= '\f') goto yy97;
			} else {
				if (yych == '"') goto yy114;
				if (yych <= '#') goto yy97;
				goto yy119;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy114;
				if (yych <= ':') goto yy97;
			} else {
				if (yych <= '[') goto yy97;
				if (yych <= '\\') goto yy115;
				if (yych >= '^') goto yy97;
			}
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy97;
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy118;
			if (yych <= '\t') goto yy116;
			if (yych <= '\n') goto yy129;
		} else {
			if (yych <= '\r') goto yy130;
			if (yych == ' ') goto yy116;
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy120;
			if (yych <= '[') goto yy97;
			goto yy121;
		} else {
			if (yych != '{') goto yy97;
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy99;
			} else {
				goto yy111;
			}
		} else {
			goto yy114;
		}
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy121;
		}
		goto yy97;
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy125;
		}
		goto yy131;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy111;
				if (yych <= '\f') goto yy97;
				goto yy111;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy97;
					goto yy111;
				} else {
					if (yych == '$') goto yy119;
					goto yy97;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy111;
				if (yych <= '/') goto yy97;
				if (yych <= '9') goto yy127;
				goto yy97;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy111;
					goto yy97;
				} else {
					if (yych <= '\\') goto yy115;
					if (yych <= ']') goto yy111;
					goto yy97;
				}
			}
		}
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		goto yy118;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy129;
		goto yy118;
yy131:
		YYDEBUG(131, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			 80,  82,  82,  82,  82,  82,  82,  82, 
			 82,  84,  64,  82,  82,  64,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 84,  80,  80,  82, 208,  82,  80,  16, 
			 80,  80,  82,  82,  82,  82,  82,  82, 
			122, 122, 122, 122, 122, 122, 122, 122, 
			122, 122,  82,  80,  82,  80,  82,  82, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  82,  82,  80, 114, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  80,  82,  80,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
		};
		YYDEBUG(133, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy140;
		}
		switch (yych) {
		case 0x00:	goto yy135;
		case '\t':
		case '\n':	goto yy143;
		case '\r':	goto yy145;
		case ' ':
		case '!':
		case '&':
		case '(':
		case ')':
		case '^':
		case '|':
		case '~':	goto yy146;
		case '"':	goto yy149;
		case '$':	goto yy151;
		case '\'':	goto yy152;
		case '-':
		case '.':	goto yy153;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy154;
		case ';':	goto yy157;
		case '=':	goto yy159;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy161;
		case 'F':
		case 'f':	goto yy164;
		case 'N':
		case 'n':	goto yy165;
		case 'O':
		case 'o':	goto yy166;
		case 'T':
		case 't':	goto yy167;
		case 'Y':
		case 'y':	goto yy168;
		default:	goto yy137;
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy138:
		YYDEBUG(138, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy137;
		}
		if (yych <= '"') goto yy139;
		if (yych <= '$') goto yy169;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy140:
		YYDEBUG(140, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(141, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy140;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy142;
			if (yych <= '\n') goto yy143;
			if (yych >= '\r') goto yy145;
		} else {
			if (yych <= '"') {
				if (yych >= '"') goto yy149;
			} else {
				if (yych == ';') goto yy157;
			}
		}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy143;
		goto yy144;
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		if (yych == '\t') goto yy146;
		if (yych == ' ') goto yy146;
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Boolean operators */
	return yytext[0];
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(150, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy136;
			if (yych <= '[') goto yy137;
			goto yy171;
		} else {
			if (yych == '{') goto yy172;
			goto yy137;
		}
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy174;
		}
		goto yy136;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy138;
		if (yych <= '9') goto yy176;
		goto yy138;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(155, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy154;
		}
		if (yych <= '-') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy156;
					if (yych <= 0x08) goto yy137;
				} else {
					if (yych != '\r') goto yy137;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy156;
					if (yych <= '#') goto yy137;
					goto yy169;
				} else {
					if (yych <= '%') goto yy137;
					if (yych >= '*') goto yy137;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '.') goto yy176;
					if (yych <= ':') goto yy137;
				} else {
					if (yych != '=') goto yy137;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy156;
					if (yych <= '{') goto yy137;
				} else {
					if (yych != '~') goto yy137;
				}
			}
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(158, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy157;
		}
		if (yych <= '\n') goto yy178;
		goto yy180;
yy159:
		YYDEBUG(159, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(160, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(162, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy161;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy137;
				} else {
					if (yych <= '\n') goto yy163;
					if (yych <= '\f') goto yy137;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy137;
					if (yych >= '#') goto yy137;
				} else {
					if (yych <= '$') goto yy169;
					if (yych <= '%') goto yy137;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy137;
				} else {
					if (yych != '=') goto yy137;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy163;
					if (yych <= '{') goto yy137;
				} else {
					if (yych != '~') goto yy137;
				}
			}
		}
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					goto yy138;
				} else {
					if (yych <= '9') goto yy161;
					if (yych == ';') goto yy163;
					goto yy138;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy163;
					if (yych <= '@') goto yy138;
					goto yy181;
				} else {
					if (yych <= 'Z') goto yy161;
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					goto yy161;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy138;
					if (yych <= 'a') goto yy181;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					if (yych <= '\n') goto yy163;
					goto yy138;
				} else {
					if (yych <= '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					if (yych <= '"') goto yy163;
					goto yy138;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					if (yych <= '9') goto yy161;
					goto yy138;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy163;
						goto yy138;
					} else {
						if (yych <= '=') goto yy163;
						if (yych <= '@') goto yy138;
						goto yy161;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy182;
					if (yych == 'U') goto yy184;
					goto yy161;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy138;
						goto yy163;
					} else {
						if (yych == '`') goto yy138;
						goto yy161;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy182;
					if (yych == 'u') goto yy184;
					goto yy161;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy138;
						goto yy163;
					} else {
						if (yych == '~') goto yy163;
						goto yy138;
					}
				}
			}
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					if (yych <= '\n') goto yy163;
					goto yy138;
				} else {
					if (yych <= '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					if (yych <= '"') goto yy163;
					goto yy138;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					if (yych <= '9') goto yy161;
					goto yy138;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy163;
						goto yy138;
					} else {
						if (yych <= '=') goto yy163;
						if (yych <= '@') goto yy138;
						goto yy161;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy185;
					if (yych == 'N') goto yy186;
					goto yy161;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy138;
						goto yy163;
					} else {
						if (yych == '`') goto yy138;
						goto yy161;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy185;
					if (yych == 'n') goto yy186;
					goto yy161;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy138;
						goto yy163;
					} else {
						if (yych == '~') goto yy163;
						goto yy138;
					}
				}
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'R') goto yy188;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy188;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'E') goto yy189;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy189;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy170;
			if (yych <= '[') goto yy137;
			goto yy171;
		} else {
			if (yych != '{') goto yy137;
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy139;
				} else {
					goto yy156;
				}
			} else {
				goto yy163;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy183;
				} else {
					goto yy187;
				}
			} else {
				goto yy204;
			}
		}
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy190;
		}
		goto yy137;
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(173, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(175, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy174;
		}
		goto yy192;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(177, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy156;
					if (yych <= 0x08) goto yy137;
					goto yy156;
				} else {
					if (yych == '\r') goto yy156;
					goto yy137;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy156;
					if (yych <= '#') goto yy137;
					goto yy169;
				} else {
					if (yych <= '%') goto yy137;
					if (yych <= ')') goto yy156;
					goto yy137;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy176;
					if (yych <= ':') goto yy137;
					goto yy156;
				} else {
					if (yych == '=') goto yy156;
					goto yy137;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy156;
					if (yych <= '{') goto yy137;
					goto yy156;
				} else {
					if (yych == '~') goto yy156;
					goto yy137;
				}
			}
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy178;
		goto yy179;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'L') goto yy194;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy194;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy183;
					if (yych <= 0x08) goto yy138;
					if (yych <= '\t') goto yy195;
				} else {
					if (yych == '\r') goto yy183;
					if (yych <= 0x1F) goto yy138;
					goto yy195;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy183;
					if (yych <= '%') goto yy138;
					if (yych >= '*') goto yy138;
				} else {
					if (yych <= '9') goto yy161;
					if (yych != ';') goto yy138;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy183;
					if (yych <= '@') goto yy138;
					if (yych <= 'M') goto yy161;
					goto yy197;
				} else {
					if (yych <= 'Z') goto yy161;
					if (yych <= ']') goto yy138;
					if (yych >= '_') goto yy161;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy138;
					if (yych == 'n') goto yy197;
					goto yy161;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy138;
					} else {
						if (yych != '~') goto yy138;
					}
				}
			}
		}
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'L') goto yy198;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy198;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'F') goto yy199;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy199;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy161;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy138;
				} else {
					if (yych <= '\t') goto yy200;
					if (yych >= '\v') goto yy138;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy187;
					if (yych <= 0x1F) goto yy138;
					goto yy200;
				} else {
					if (yych <= '"') goto yy187;
					if (yych <= '%') goto yy138;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy138;
				} else {
					if (yych != '=') goto yy138;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy187;
					if (yych <= '{') goto yy138;
				} else {
					if (yych != '~') goto yy138;
				}
			}
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'U') goto yy202;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy202;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'S') goto yy186;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy186;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy190:
		YYDEBUG(190, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy190;
		}
		if (yych <= 0x00) goto yy139;
		if (yych == '\\') goto yy171;
		goto yy137;
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'S') goto yy197;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy197;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yych == '\t') goto yy195;
		if (yych == ' ') goto yy195;
		goto yy183;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'E') goto yy199;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy199;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'L') goto yy203;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy203;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy161;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy183;
					goto yy138;
				} else {
					if (yych <= '\t') goto yy195;
					if (yych <= '\n') goto yy183;
					goto yy138;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy183;
					if (yych <= 0x1F) goto yy138;
					goto yy195;
				} else {
					if (yych <= '"') goto yy183;
					if (yych <= '%') goto yy138;
					goto yy183;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy138;
					goto yy183;
				} else {
					if (yych == '=') goto yy183;
					goto yy138;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy183;
					if (yych <= '{') goto yy138;
					goto yy183;
				} else {
					if (yych == '~') goto yy183;
					goto yy138;
				}
			}
		}
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(201, *YYCURSOR);
		if (yych == '\t') goto yy200;
		if (yych == ' ') goto yy200;
		goto yy187;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy163;
					if (yych <= 0x08) goto yy138;
					goto yy163;
				} else {
					if (yych == '\r') goto yy163;
					if (yych <= 0x1F) goto yy138;
					goto yy163;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy138;
					if (yych <= ')') goto yy163;
					if (yych <= '/') goto yy138;
					goto yy161;
				} else {
					if (yych == ';') goto yy163;
					if (yych <= '<') goto yy138;
					goto yy163;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy138;
					if (yych == 'E') goto yy186;
					goto yy161;
				} else {
					if (yych <= ']') goto yy138;
					if (yych <= '^') goto yy163;
					if (yych <= '_') goto yy161;
					goto yy138;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy186;
					if (yych <= 'z') goto yy161;
					goto yy138;
				} else {
					if (yych == '}') goto yy138;
					if (yych <= '~') goto yy163;
					goto yy138;
				}
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy161;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy138;
				} else {
					if (yych <= '\t') goto yy205;
					if (yych >= '\v') goto yy138;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy204;
					if (yych <= 0x1F) goto yy138;
					goto yy205;
				} else {
					if (yych <= '"') goto yy204;
					if (yych <= '%') goto yy138;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy138;
				} else {
					if (yych != '=') goto yy138;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy204;
					if (yych <= '{') goto yy138;
				} else {
					if (yych != '~') goto yy138;
				}
			}
		}
yy204:
		YYDEBUG(204, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yych == '\t') goto yy205;
		if (yych == ' ') goto yy205;
		goto yy204;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(207, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy209;
		}
		if (yych <= '\r') goto yy212;
		goto yy214;
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy209;
		}
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy214;
		}
		if (yych <= 0x08) goto yy216;
		if (yych <= '\n') goto yy217;
		if (yych == '\r') goto yy218;
yy216:
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		goto yy216;
yy218:
		YYDEBUG(218, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy217;
		goto yy216;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(219, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy223;
		if (yych == '$') goto yy226;
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
yy222:
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	const unsigned char *s = SCNG(yy_text);

	while (s < YYLIMIT) {
		switch (*s++) {
			case '"':
				break;
			case '$':
				if (s < YYLIMIT && *s == '{') {
					break;
				}
				continue;
			case '\\':
				if (s < YYLIMIT) {
					unsigned char escaped = *s++;
					/* A special case for Windows paths, e.g. key="C:\path\" */
					if (escaped == '"' && (s >= YYLIMIT || *s == '\n' || *s == '\r')) {
						break;
					}
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		s--;
		break;
	}

	YYCURSOR = s;
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	Z_EXTRA_P(ini_lval) = 0;
	return TC_QUOTED_STRING;
}
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy223;
		}
		YYDEBUG(225, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
yy226:
		YYDEBUG(226, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy222;
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
	}
/* *********************************** */
yyc_ST_VAR_FALLBACK:
	{
		static const unsigned char yybm[] = {
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,  24,   0,   8,   8,   0,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			 24,   8,   0,   8, 128,   8,   8,   0, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104,   8,   0,   8,   8,   8,   8, 
			  8,  72,  72,  72,  72,  72,  72,  72, 
			 72,  72,  72,  72,  72,  72,  72,  72, 
			 72,  72,  72,  72,  72,  72,  72,  72, 
			 72,  72,  72,   8, 128,   8,   8,  72, 
			  8,  72,  72,  72,  72,  72,  72,  72, 
			 72,  72,  72,  72,  72,  72,  72,  72, 
			 72,  72,  72,  72,  72,  72,  72,  72, 
			 72,  72,  72,   8,   8,   0,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
		};
		YYDEBUG(229, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy234;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy231;
					if (yych <= '\n') goto yy236;
				} else {
					if (yych <= '\r') goto yy236;
					if (yych >= '"') goto yy238;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy240;
				} else {
					if (yych <= '\'') goto yy236;
					if (yych <= ',') goto yy231;
					if (yych <= '.') goto yy241;
				}
			}
		} else {
			if (yych <= '\\') {
				if (yych <= ';') {
					if (yych <= '9') goto yy242;
					if (yych >= ';') goto yy236;
				} else {
					if (yych <= '@') goto yy231;
					if (yych <= 'Z') goto yy245;
					if (yych >= '\\') goto yy248;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy245;
				} else {
					if (yych <= 'z') goto yy245;
					if (yych == '}') goto yy249;
				}
			}
		}
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy232:
		YYDEBUG(232, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy231;
		}
		if (yych <= '"') goto yy233;
		if (yych <= '$') goto yy251;
		if (yych <= ';') goto yy233;
		if (yych <= '\\') goto yy248;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Same as below, but excluding '}' */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(235, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy234;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy231;
				if (yych <= '\n') goto yy233;
				if (yych <= '\f') goto yy231;
				goto yy233;
			} else {
				if (yych == '"') goto yy238;
				if (yych <= '#') goto yy231;
				goto yy251;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy233;
				if (yych <= ':') goto yy231;
				goto yy233;
			} else {
				if (yych <= '\\') {
					if (yych <= '[') goto yy231;
					goto yy248;
				} else {
					if (yych == '}') goto yy233;
					goto yy231;
				}
			}
		}
yy236:
		YYDEBUG(236, *YYCURSOR);
		++YYCURSOR;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy237;
			if (yych <= '[') goto yy231;
			goto yy253;
		} else {
			if (yych == '{') goto yy255;
			goto yy231;
		}
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy232;
		if (yych <= '9') goto yy257;
		goto yy232;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(243, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy242;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy244;
				if (yych <= '\f') goto yy231;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy231;
				} else {
					if (yych == '$') goto yy251;
					goto yy231;
				}
			}
		} else {
			if (yych <= ';') {
				if (yych <= '-') {
					if (yych >= '(') goto yy231;
				} else {
					if (yych <= '.') goto yy257;
					if (yych <= ':') goto yy231;
				}
			} else {
				if (yych <= '\\') {
					if (yych <= '[') goto yy231;
					goto yy248;
				} else {
					if (yych != '}') goto yy231;
				}
			}
		}
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy245;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy247;
				if (yych <= '\f') goto yy231;
			} else {
				if (yych == '"') goto yy247;
				if (yych <= '#') goto yy231;
				goto yy251;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy247;
				if (yych <= ':') goto yy231;
			} else {
				if (yych <= '\\') {
					if (yych <= '[') goto yy231;
					goto yy248;
				} else {
					if (yych != '}') goto yy231;
				}
			}
		}
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy231;
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable/fallback end */
	yy_pop_state();
	return '}';
}
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy252;
			if (yych <= '[') goto yy231;
			goto yy253;
		} else {
			if (yych != '{') goto yy231;
		}
yy252:
		YYDEBUG(252, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy233;
			} else {
				goto yy244;
			}
		} else {
			goto yy247;
		}
yy253:
		YYDEBUG(253, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(254, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy253;
		}
		goto yy231;
yy255:
		YYDEBUG(255, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(258, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy244;
				if (yych <= '\f') goto yy231;
				goto yy244;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy231;
					goto yy244;
				} else {
					if (yych == '$') goto yy251;
					goto yy231;
				}
			}
		} else {
			if (yych <= ';') {
				if (yych <= '/') {
					if (yych <= '\'') goto yy244;
					goto yy231;
				} else {
					if (yych <= '9') goto yy257;
					if (yych <= ':') goto yy231;
					goto yy244;
				}
			} else {
				if (yych <= '\\') {
					if (yych <= '[') goto yy231;
					goto yy248;
				} else {
					if (yych == '}') goto yy244;
					goto yy231;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_VARNAME:
	YYDEBUG(259, *YYCURSOR);
	YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ')') {
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy261;
				if (yych <= 0x08) goto yy263;
			} else {
				if (yych != '\r') goto yy263;
			}
		} else {
			if (yych <= '$') {
				if (yych == '#') goto yy263;
			} else {
				if (yych == '&') goto yy261;
				if (yych <= '\'') goto yy263;
			}
		}
	} else {
		if (yych <= '[') {
			if (yych <= ';') {
				if (yych <= '9') goto yy263;
				if (yych <= ':') goto yy265;
			} else {
				if (yych == '=') goto yy261;
				if (yych <= 'Z') goto yy263;
			}
		} else {
			if (yych <= 'z') {
				if (yych <= '\\') goto yy263;
				if (yych >= '_') goto yy263;
			} else {
				if (yych == '}') goto yy266;
				if (yych >= 0x7F) goto yy263;
			}
		}
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(262, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return 0;
}
yy263:
	YYDEBUG(263, *YYCURSOR);
	++YYCURSOR;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{ /* Variable name */
	if (YYCURSOR[0] == ':' && YYCURSOR[1] == '-') {
		YYCURSOR++;
		goto fallback_lexing;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '=':
			case '\n':
			case '\r':
			case '\t':
			case ';':
			case '&':
			case '|':
			case '^':
			case '$':
			case '~':
			case '(':
			case ')':
			case '{':
			case '}':
			case '!':
			case '"':
			case '[':
			case ']':
				break;
			/* ':' is only allowed if it isn't followed by '-'. */
			case ':':
				if (YYCURSOR[0] == '-') {
					break;
				} else {
					continue;
				}
			default:
				continue;
		}

		YYCURSOR--;
		yyleng = YYCURSOR - SCNG(yy_text);
		break;
	}

	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy268;
	goto yy264;
yy266:
	YYDEBUG(266, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(267, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{ /* Variable/fallback end */
	yy_pop_state();
	return '}';
}
yy268:
	YYDEBUG(268, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(269, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{ /* End Variable name, fallback start */
fallback_lexing:
	yy_pop_state();
	yy_push_state(ST_VAR_FALLBACK);
	return TC_FALLBACK;
}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(270, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy274;
			} else {
				if (yych <= '\t') goto yy276;
				if (yych <= '\n') goto yy277;
				goto yy274;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy279;
				if (yych <= 0x1F) goto yy274;
				goto yy276;
			} else {
				if (yych == ';') goto yy280;
				goto yy274;
			}
		}
		YYDEBUG(272, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(273, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy274:
		YYDEBUG(274, *YYCURSOR);
		++YYCURSOR;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	const unsigned char *sc = NULL;
	EAT_LEADING_WHITESPACE();
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				YYCURSOR++;
				break;
			case '"':
				if (yytext[0] == '"') {
					sc = NULL;
				}
				YYCURSOR++;
				break;
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	if (sc) {
		yyleng = sc - SCNG(yy_text);
	} else {
		yyleng = YYCURSOR - SCNG(yy_text);
	}

	EAT_TRAILING_WHITESPACE();

	/* Eat leading and trailing double quotes */
	if (yyleng > 1 && yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}

	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy275;
			if (yych <= '\n') goto yy283;
			if (yych <= '\f') goto yy275;
			goto yy283;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy275;
				goto yy283;
			} else {
				if (yych == ';') goto yy283;
				goto yy275;
			}
		}
yy277:
		YYDEBUG(277, *YYCURSOR);
		++YYCURSOR;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy277;
		goto yy278;
yy280:
		YYDEBUG(280, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(281, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy280;
		}
		if (yych <= '\n') goto yy285;
		goto yy287;
yy282:
		YYDEBUG(282, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy283:
		YYDEBUG(283, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy282;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy284;
			if (yych <= '\n') goto yy277;
		} else {
			if (yych <= '\r') goto yy279;
			if (yych == ';') goto yy280;
		}
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy285:
		YYDEBUG(285, *YYCURSOR);
		++YYCURSOR;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy285;
		goto yy286;
	}
}

}
