--TEST--
Binary integer strings (32bit)
--SKIPIF--
<?php
if (PHP_INT_SIZE != 4) die("skip this test is for 32bit platform only");
?>
--FILE--
<?php
/* Using binary prefix notation lowercase */
/* Maximum value representable as integer */
$binary = 0b1111111111111111111111111111111;
var_dump($binary);
var_dump(PHP_INT_MAX);

/* Floating number */
$binary = 0b111111010000101010101010101010111111111111111111111111111111111111111111111111111111;
var_dump($binary);

/* Integer */
$binary = 0b1010110;
var_dump($binary);

/* underscore separator */
$binary = 0b1_010110;
var_dump($binary);

/* Ignore leading 0 and _ */
$binary = 0b0_01010110;
var_dump($binary);
$binary = 0b0_1010110;
var_dump($binary);

/* Overflow to infinity */
$binary = 0b111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
var_dump($binary);

/* Using binary prefix notation uppercase */
/* Maximum value representable as integer */
$binary = 0B1111111111111111111111111111111;
var_dump($binary);
var_dump(PHP_INT_MAX);

/* Floating number */
$binary = 0B111111010000101010101010101010111111111111111111111111111111111111111111111111111111;
var_dump($binary);

/* Integer */
$binary = 0B1010110;
var_dump($binary);

/* underscore separator */
$binary = 0B1_010110;
var_dump($binary);

/* Ignore leading 0 and _ */
$binary = 0B0_01010110;
var_dump($binary);
$binary = 0B0_1010110;
var_dump($binary);

/* Overflow to infinity */
$binary = 0B111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
var_dump($binary);

?>
--EXPECT--
int(2147483647)
int(2147483647)
float(1.9119287772983036E+25)
int(86)
int(86)
int(86)
int(86)
float(INF)
int(2147483647)
int(2147483647)
float(1.9119287772983036E+25)
int(86)
int(86)
int(86)
int(86)
float(INF)
