/* TextTransform.c generated by valac 0.30.0, the Vala compiler
 * generated from TextTransform.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TRANSFORM_FLAGS (transform_flags_get_type ())

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

typedef enum  {
	TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS = 1 << 0,
	TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS = 1 << 1,
	TRANSFORM_FLAGS_EXPAND_LINKS = 1 << 2
} TransformFlags;

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};



GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType transform_flags_get_type (void) G_GNUC_CONST;
#define TEXT_TRANSFORM_TRAILING ((guint) (1 << 0))
gboolean text_transform_is_media_url (const gchar* url, const gchar* display_text, guint media_count);
gboolean is_media_candidate (const gchar* url);
gboolean text_transform_is_hashtag (const gchar* entity);
gboolean text_transform_is_link (const gchar* target);
gboolean text_transform_is_quote_link (TextEntity* entity, gint64 quote_id);
gboolean text_transform_is_whitespace (const gchar* s);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
gchar* text_transform_transform_tweet (MiniTweet* tweet, TransformFlags flags, gint64 quote_id);
gchar* text_transform_transform (const gchar* text, TextEntity* entities, int entities_length1, TransformFlags flags, guint media_count, gint64 quote_id);
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType media_get_type (void) G_GNUC_CONST;


void text_entity_copy (const TextEntity* self, TextEntity* dest) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	_tmp0_ = (*self).from;
	(*dest).from = _tmp0_;
	_tmp1_ = (*self).to;
	(*dest).to = _tmp1_;
	_tmp2_ = (*self).display_text;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).display_text);
	(*dest).display_text = _tmp3_;
	_tmp4_ = (*self).tooltip_text;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).tooltip_text);
	(*dest).tooltip_text = _tmp5_;
	_tmp6_ = (*self).target;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).target);
	(*dest).target = _tmp7_;
	_tmp8_ = (*self).info;
	(*dest).info = _tmp8_;
}


void text_entity_destroy (TextEntity* self) {
	_g_free0 ((*self).display_text);
	_g_free0 ((*self).tooltip_text);
	_g_free0 ((*self).target);
}


TextEntity* text_entity_dup (const TextEntity* self) {
	TextEntity* dup;
	dup = g_new0 (TextEntity, 1);
	text_entity_copy (self, dup);
	return dup;
}


void text_entity_free (TextEntity* self) {
	text_entity_destroy (self);
	g_free (self);
}


GType text_entity_get_type (void) {
	static volatile gsize text_entity_type_id__volatile = 0;
	if (g_once_init_enter (&text_entity_type_id__volatile)) {
		GType text_entity_type_id;
		text_entity_type_id = g_boxed_type_register_static ("TextEntity", (GBoxedCopyFunc) text_entity_dup, (GBoxedFreeFunc) text_entity_free);
		g_once_init_leave (&text_entity_type_id__volatile, text_entity_type_id);
	}
	return text_entity_type_id__volatile;
}


GType transform_flags_get_type (void) {
	static volatile gsize transform_flags_type_id__volatile = 0;
	if (g_once_init_enter (&transform_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS, "TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS", "remove-media-links"}, {TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS, "TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS", "remove-trailing-hashtags"}, {TRANSFORM_FLAGS_EXPAND_LINKS, "TRANSFORM_FLAGS_EXPAND_LINKS", "expand-links"}, {0, NULL, NULL}};
		GType transform_flags_type_id;
		transform_flags_type_id = g_enum_register_static ("TransformFlags", values);
		g_once_init_leave (&transform_flags_type_id__volatile, transform_flags_type_id);
	}
	return transform_flags_type_id__volatile;
}


gboolean text_transform_is_media_url (const gchar* url, const gchar* display_text, guint media_count) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (display_text != NULL, FALSE);
	_tmp3_ = url;
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = display_text;
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = is_media_candidate (_tmp2_);
	if (_tmp5_) {
		guint _tmp6_ = 0U;
		_tmp6_ = media_count;
		_tmp1_ = _tmp6_ == ((guint) 1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = display_text;
		_tmp8_ = g_str_has_prefix (_tmp7_, "pic.twitter.com/");
		_tmp0_ = _tmp8_;
	}
	result = _tmp0_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean text_transform_is_hashtag (const gchar* entity) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (entity != NULL, FALSE);
	_tmp0_ = entity;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	result = _tmp1_ == '#';
	return result;
}


gboolean text_transform_is_link (const gchar* target) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	_tmp1_ = target;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = target;
		_tmp4_ = g_str_has_prefix (_tmp3_, "http://");
		if (_tmp4_) {
			_tmp2_ = TRUE;
		} else {
			const gchar* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			_tmp5_ = target;
			_tmp6_ = g_str_has_prefix (_tmp5_, "https://");
			_tmp2_ = _tmp6_;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean text_transform_is_quote_link (TextEntity* entity, gint64 quote_id) {
	gboolean result = FALSE;
	TextEntity _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	TextEntity _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (entity != NULL, FALSE);
	_tmp0_ = *entity;
	_tmp1_ = _tmp0_.target;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = *entity;
	_tmp4_ = _tmp3_.target;
	_tmp5_ = g_str_has_prefix (_tmp4_, "https://twitter.com/");
	if (_tmp5_) {
		TextEntity _tmp6_ = {0};
		const gchar* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp6_ = *entity;
		_tmp7_ = _tmp6_.target;
		_tmp8_ = quote_id;
		_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("/status/", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_str_has_suffix (_tmp7_, _tmp12_);
		_tmp2_ = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gboolean text_transform_is_whitespace (const gchar* s) {
	gboolean result = FALSE;
	gunichar c = 0U;
	g_return_val_if_fail (s != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp1_ = NULL;
				gunichar _tmp2_ = 0U;
				gboolean _tmp3_ = FALSE;
				gunichar _tmp4_ = 0U;
				gboolean _tmp5_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				_tmp1_ = s;
				_tmp3_ = string_get_next_char (_tmp1_, &i, &_tmp2_);
				c = _tmp2_;
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = c;
				_tmp5_ = g_unichar_isgraph (_tmp4_);
				if (_tmp5_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gchar* text_transform_transform_tweet (MiniTweet* tweet, TransformFlags flags, gint64 quote_id) {
	gchar* result = NULL;
	MiniTweet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	MiniTweet* _tmp2_ = NULL;
	TextEntity* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	TransformFlags _tmp4_ = 0;
	MiniTweet* _tmp5_ = NULL;
	Media** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (IS_MINI_TWEET (tweet), NULL);
	_tmp0_ = tweet;
	_tmp1_ = _tmp0_->text;
	_tmp2_ = tweet;
	_tmp3_ = _tmp2_->entities;
	_tmp3__length1 = _tmp2_->entities_length1;
	_tmp4_ = flags;
	_tmp5_ = tweet;
	_tmp6_ = _tmp5_->medias;
	_tmp6__length1 = _tmp5_->medias_length1;
	_tmp7_ = quote_id;
	_tmp8_ = text_transform_transform (_tmp1_, _tmp3_, _tmp3__length1, _tmp4_, (guint) _tmp6__length1, _tmp7_);
	result = _tmp8_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch86_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch86_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally86;
	__catch86_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally86:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* text_transform_transform (const gchar* text, TextEntity* entities, int entities_length1, TransformFlags flags, guint media_count, gint64 quote_id) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	guint last_end = 0U;
	guint cur_end = 0U;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean last_entity_was_trailing = FALSE;
	TextEntity* _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	GString* _tmp144_ = NULL;
	const gchar* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	guint _tmp147_ = 0U;
	gint _tmp148_ = 0;
	gchar* _tmp149_ = NULL;
	gchar* _tmp150_ = NULL;
	GString* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	gchar* _tmp153_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	last_end = (guint) 0;
	_tmp1_ = text;
	_tmp2_ = g_utf8_strlen (_tmp1_, (gssize) -1);
	cur_end = (guint) _tmp2_;
	{
		gint i = 0;
		TextEntity* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp3_ = entities;
		_tmp3__length1 = entities_length1;
		i = _tmp3__length1 - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gchar* btw = NULL;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				TextEntity* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				TextEntity _tmp11_ = {0};
				guint _tmp12_ = 0U;
				gint _tmp13_ = 0;
				const gchar* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				gint _tmp16_ = 0;
				const gchar* _tmp17_ = NULL;
				TextEntity* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				TextEntity _tmp20_ = {0};
				guint _tmp21_ = 0U;
				gint _tmp22_ = 0;
				gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp34_ = FALSE;
				TextEntity* _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gint _tmp36_ = 0;
				TextEntity _tmp37_ = {0};
				guint _tmp38_ = 0U;
				guint _tmp39_ = 0U;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = text;
				_tmp8_ = text;
				_tmp9_ = entities;
				_tmp9__length1 = entities_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = _tmp11_.to;
				_tmp13_ = string_index_of_nth_char (_tmp8_, (glong) _tmp12_);
				_tmp14_ = text;
				_tmp15_ = cur_end;
				_tmp16_ = string_index_of_nth_char (_tmp14_, (glong) _tmp15_);
				_tmp17_ = text;
				_tmp18_ = entities;
				_tmp18__length1 = entities_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp21_ = _tmp20_.to;
				_tmp22_ = string_index_of_nth_char (_tmp17_, (glong) _tmp21_);
				_tmp23_ = string_substring (_tmp7_, (glong) _tmp13_, (glong) (_tmp16_ - _tmp22_));
				btw = _tmp23_;
				_tmp25_ = btw;
				_tmp26_ = text_transform_is_whitespace (_tmp25_);
				if (!_tmp26_) {
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp27_ = btw;
					_tmp28_ = strlen (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp24_ = _tmp29_ > 0;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					_g_free0 (btw);
					break;
				} else {
					TextEntity* _tmp30_ = NULL;
					gint _tmp30__length1 = 0;
					gint _tmp31_ = 0;
					TextEntity _tmp32_ = {0};
					guint _tmp33_ = 0U;
					_tmp30_ = entities;
					_tmp30__length1 = entities_length1;
					_tmp31_ = i;
					_tmp32_ = _tmp30_[_tmp31_];
					_tmp33_ = _tmp32_.to;
					cur_end = _tmp33_;
				}
				_tmp35_ = entities;
				_tmp35__length1 = entities_length1;
				_tmp36_ = i;
				_tmp37_ = _tmp35_[_tmp36_];
				_tmp38_ = _tmp37_.to;
				_tmp39_ = cur_end;
				if (_tmp38_ == _tmp39_) {
					gboolean _tmp40_ = FALSE;
					TextEntity* _tmp41_ = NULL;
					gint _tmp41__length1 = 0;
					gint _tmp42_ = 0;
					TextEntity _tmp43_ = {0};
					const gchar* _tmp44_ = NULL;
					gboolean _tmp45_ = FALSE;
					_tmp41_ = entities;
					_tmp41__length1 = entities_length1;
					_tmp42_ = i;
					_tmp43_ = _tmp41_[_tmp42_];
					_tmp44_ = _tmp43_.display_text;
					_tmp45_ = text_transform_is_hashtag (_tmp44_);
					if (_tmp45_) {
						_tmp40_ = TRUE;
					} else {
						TextEntity* _tmp46_ = NULL;
						gint _tmp46__length1 = 0;
						gint _tmp47_ = 0;
						TextEntity _tmp48_ = {0};
						const gchar* _tmp49_ = NULL;
						gboolean _tmp50_ = FALSE;
						_tmp46_ = entities;
						_tmp46__length1 = entities_length1;
						_tmp47_ = i;
						_tmp48_ = _tmp46_[_tmp47_];
						_tmp49_ = _tmp48_.target;
						_tmp50_ = text_transform_is_link (_tmp49_);
						_tmp40_ = _tmp50_;
					}
					_tmp34_ = _tmp40_;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					TextEntity* _tmp51_ = NULL;
					gint _tmp51__length1 = 0;
					gint _tmp52_ = 0;
					TextEntity* _tmp53_ = NULL;
					gint _tmp53__length1 = 0;
					gint _tmp54_ = 0;
					guint _tmp55_ = 0U;
					TextEntity* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					gint _tmp57_ = 0;
					TextEntity _tmp58_ = {0};
					guint _tmp59_ = 0U;
					_tmp51_ = entities;
					_tmp51__length1 = entities_length1;
					_tmp52_ = i;
					_tmp53_ = entities;
					_tmp53__length1 = entities_length1;
					_tmp54_ = i;
					_tmp55_ = _tmp53_[_tmp54_].info;
					_tmp53_[_tmp54_].info = _tmp55_ | TEXT_TRANSFORM_TRAILING;
					_tmp56_ = entities;
					_tmp56__length1 = entities_length1;
					_tmp57_ = i;
					_tmp58_ = _tmp56_[_tmp57_];
					_tmp59_ = _tmp58_.from;
					cur_end = _tmp59_;
				} else {
					_g_free0 (btw);
					break;
				}
				_g_free0 (btw);
			}
		}
	}
	last_entity_was_trailing = FALSE;
	_tmp60_ = entities;
	_tmp60__length1 = entities_length1;
	{
		TextEntity* entity_collection = NULL;
		gint entity_collection_length1 = 0;
		gint _entity_collection_size_ = 0;
		gint entity_it = 0;
		entity_collection = _tmp60_;
		entity_collection_length1 = _tmp60__length1;
		for (entity_it = 0; entity_it < _tmp60__length1; entity_it = entity_it + 1) {
			TextEntity _tmp61_ = {0};
			TextEntity entity = {0};
			text_entity_copy (&entity_collection[entity_it], &_tmp61_);
			entity = _tmp61_;
			{
				gchar* before = NULL;
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				guint _tmp64_ = 0U;
				gint _tmp65_ = 0;
				const gchar* _tmp66_ = NULL;
				TextEntity _tmp67_ = {0};
				guint _tmp68_ = 0U;
				gint _tmp69_ = 0;
				const gchar* _tmp70_ = NULL;
				guint _tmp71_ = 0U;
				gint _tmp72_ = 0;
				gchar* _tmp73_ = NULL;
				gboolean _tmp74_ = FALSE;
				gboolean _tmp75_ = FALSE;
				gboolean _tmp80_ = FALSE;
				gboolean _tmp81_ = FALSE;
				TransformFlags _tmp82_ = 0;
				gboolean _tmp90_ = FALSE;
				gboolean _tmp91_ = FALSE;
				TransformFlags _tmp92_ = 0;
				TransformFlags _tmp105_ = 0;
				TextEntity _tmp142_ = {0};
				guint _tmp143_ = 0U;
				_tmp62_ = text;
				_tmp63_ = text;
				_tmp64_ = last_end;
				_tmp65_ = string_index_of_nth_char (_tmp63_, (glong) _tmp64_);
				_tmp66_ = text;
				_tmp67_ = entity;
				_tmp68_ = _tmp67_.from;
				_tmp69_ = string_index_of_nth_char (_tmp66_, (glong) _tmp68_);
				_tmp70_ = text;
				_tmp71_ = last_end;
				_tmp72_ = string_index_of_nth_char (_tmp70_, (glong) _tmp71_);
				_tmp73_ = string_substring (_tmp62_, (glong) _tmp65_, (glong) (_tmp69_ - _tmp72_));
				before = _tmp73_;
				_tmp75_ = last_entity_was_trailing;
				if (_tmp75_) {
					const gchar* _tmp76_ = NULL;
					gboolean _tmp77_ = FALSE;
					_tmp76_ = before;
					_tmp77_ = text_transform_is_whitespace (_tmp76_);
					_tmp74_ = _tmp77_;
				} else {
					_tmp74_ = FALSE;
				}
				if (!_tmp74_) {
					GString* _tmp78_ = NULL;
					const gchar* _tmp79_ = NULL;
					_tmp78_ = builder;
					_tmp79_ = before;
					g_string_append (_tmp78_, _tmp79_);
				}
				_tmp82_ = flags;
				if ((_tmp82_ & TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS) == TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS) {
					TextEntity _tmp83_ = {0};
					guint _tmp84_ = 0U;
					_tmp83_ = entity;
					_tmp84_ = _tmp83_.info;
					_tmp81_ = (_tmp84_ & TEXT_TRANSFORM_TRAILING) > ((guint) 0);
				} else {
					_tmp81_ = FALSE;
				}
				if (_tmp81_) {
					TextEntity _tmp85_ = {0};
					const gchar* _tmp86_ = NULL;
					gboolean _tmp87_ = FALSE;
					_tmp85_ = entity;
					_tmp86_ = _tmp85_.display_text;
					_tmp87_ = text_transform_is_hashtag (_tmp86_);
					_tmp80_ = _tmp87_;
				} else {
					_tmp80_ = FALSE;
				}
				if (_tmp80_) {
					TextEntity _tmp88_ = {0};
					guint _tmp89_ = 0U;
					_tmp88_ = entity;
					_tmp89_ = _tmp88_.to;
					last_end = _tmp89_;
					last_entity_was_trailing = TRUE;
					_g_free0 (before);
					text_entity_destroy (&entity);
					continue;
				}
				last_entity_was_trailing = FALSE;
				_tmp92_ = flags;
				if ((_tmp92_ & TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS) == TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS) {
					TextEntity _tmp93_ = {0};
					const gchar* _tmp94_ = NULL;
					TextEntity _tmp95_ = {0};
					const gchar* _tmp96_ = NULL;
					guint _tmp97_ = 0U;
					gboolean _tmp98_ = FALSE;
					_tmp93_ = entity;
					_tmp94_ = _tmp93_.target;
					_tmp95_ = entity;
					_tmp96_ = _tmp95_.display_text;
					_tmp97_ = media_count;
					_tmp98_ = text_transform_is_media_url (_tmp94_, _tmp96_, _tmp97_);
					_tmp91_ = _tmp98_;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					_tmp90_ = TRUE;
				} else {
					gboolean _tmp99_ = FALSE;
					gint64 _tmp100_ = 0LL;
					_tmp100_ = quote_id;
					if (_tmp100_ != ((gint64) 0)) {
						gint64 _tmp101_ = 0LL;
						gboolean _tmp102_ = FALSE;
						_tmp101_ = quote_id;
						_tmp102_ = text_transform_is_quote_link (&entity, _tmp101_);
						_tmp99_ = _tmp102_;
					} else {
						_tmp99_ = FALSE;
					}
					_tmp90_ = _tmp99_;
				}
				if (_tmp90_) {
					TextEntity _tmp103_ = {0};
					guint _tmp104_ = 0U;
					_tmp103_ = entity;
					_tmp104_ = _tmp103_.to;
					last_end = _tmp104_;
					_g_free0 (before);
					text_entity_destroy (&entity);
					continue;
				}
				_tmp105_ = flags;
				if ((_tmp105_ & TRANSFORM_FLAGS_EXPAND_LINKS) == TRANSFORM_FLAGS_EXPAND_LINKS) {
					TextEntity _tmp106_ = {0};
					const gchar* _tmp107_ = NULL;
					gchar _tmp108_ = '\0';
					_tmp106_ = entity;
					_tmp107_ = _tmp106_.display_text;
					_tmp108_ = string_get (_tmp107_, (glong) 0);
					if (_tmp108_ == '@') {
						GString* _tmp109_ = NULL;
						TextEntity _tmp110_ = {0};
						const gchar* _tmp111_ = NULL;
						_tmp109_ = builder;
						_tmp110_ = entity;
						_tmp111_ = _tmp110_.display_text;
						g_string_append (_tmp109_, _tmp111_);
					} else {
						const gchar* _tmp112_ = NULL;
						TextEntity _tmp113_ = {0};
						const gchar* _tmp114_ = NULL;
						GString* _tmp117_ = NULL;
						_tmp113_ = entity;
						_tmp114_ = _tmp113_.target;
						_tmp112_ = _tmp114_;
						if (_tmp112_ == NULL) {
							TextEntity _tmp115_ = {0};
							const gchar* _tmp116_ = NULL;
							_tmp115_ = entity;
							_tmp116_ = _tmp115_.display_text;
							_tmp112_ = _tmp116_;
						}
						_tmp117_ = builder;
						g_string_append (_tmp117_, _tmp112_);
					}
				} else {
					const gchar* _tmp118_ = NULL;
					TextEntity _tmp119_ = {0};
					const gchar* _tmp120_ = NULL;
					GString* _tmp123_ = NULL;
					GString* _tmp124_ = NULL;
					GString* _tmp125_ = NULL;
					TextEntity _tmp126_ = {0};
					const gchar* _tmp127_ = NULL;
					GString* _tmp135_ = NULL;
					GString* _tmp136_ = NULL;
					TextEntity _tmp137_ = {0};
					const gchar* _tmp138_ = NULL;
					gchar* _tmp139_ = NULL;
					gchar* _tmp140_ = NULL;
					GString* _tmp141_ = NULL;
					_tmp119_ = entity;
					_tmp120_ = _tmp119_.target;
					_tmp118_ = _tmp120_;
					if (_tmp118_ == NULL) {
						TextEntity _tmp121_ = {0};
						const gchar* _tmp122_ = NULL;
						_tmp121_ = entity;
						_tmp122_ = _tmp121_.display_text;
						_tmp118_ = _tmp122_;
					}
					_tmp123_ = builder;
					_tmp124_ = g_string_append (_tmp123_, "<span underline=\"none\"><a href=\"");
					_tmp125_ = g_string_append (_tmp124_, _tmp118_);
					g_string_append (_tmp125_, "\"");
					_tmp126_ = entity;
					_tmp127_ = _tmp126_.tooltip_text;
					if (_tmp127_ != NULL) {
						GString* _tmp128_ = NULL;
						GString* _tmp129_ = NULL;
						TextEntity _tmp130_ = {0};
						const gchar* _tmp131_ = NULL;
						gchar* _tmp132_ = NULL;
						gchar* _tmp133_ = NULL;
						GString* _tmp134_ = NULL;
						_tmp128_ = builder;
						_tmp129_ = g_string_append (_tmp128_, " title=\"");
						_tmp130_ = entity;
						_tmp131_ = _tmp130_.tooltip_text;
						_tmp132_ = string_replace (_tmp131_, "&", "&amp;amp;");
						_tmp133_ = _tmp132_;
						_tmp134_ = g_string_append (_tmp129_, _tmp133_);
						g_string_append (_tmp134_, "\"");
						_g_free0 (_tmp133_);
					}
					_tmp135_ = builder;
					g_string_append (_tmp135_, ">");
					_tmp136_ = builder;
					_tmp137_ = entity;
					_tmp138_ = _tmp137_.display_text;
					_tmp139_ = string_replace (_tmp138_, "&", "&amp;");
					_tmp140_ = _tmp139_;
					g_string_append (_tmp136_, _tmp140_);
					_g_free0 (_tmp140_);
					_tmp141_ = builder;
					g_string_append (_tmp141_, "</a></span>");
				}
				_tmp142_ = entity;
				_tmp143_ = _tmp142_.to;
				last_end = _tmp143_;
				_g_free0 (before);
				text_entity_destroy (&entity);
			}
		}
	}
	_tmp144_ = builder;
	_tmp145_ = text;
	_tmp146_ = text;
	_tmp147_ = last_end;
	_tmp148_ = string_index_of_nth_char (_tmp146_, (glong) _tmp147_);
	_tmp149_ = string_substring (_tmp145_, (glong) _tmp148_, (glong) -1);
	_tmp150_ = _tmp149_;
	g_string_append (_tmp144_, _tmp150_);
	_g_free0 (_tmp150_);
	_tmp151_ = builder;
	_tmp152_ = _tmp151_->str;
	_tmp153_ = g_strdup (_tmp152_);
	result = _tmp153_;
	_g_string_free0 (builder);
	return result;
}



