/* UserUtils.c generated by valac 0.30.0, the Vala compiler
 * generated from UserUtils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>


#define TYPE_FRIENDSHIP (friendship_get_type ())
typedef struct _Friendship Friendship;

#define TYPE_CURSOR (cursor_get_type ())
typedef struct _Cursor Cursor;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _friendship_free0(var) ((var == NULL) ? NULL : (var = (friendship_free (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _UserUtilsLoadFriendshipData UserUtilsLoadFriendshipData;
#define _cursor_free0(var) ((var == NULL) ? NULL : (var = (cursor_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _UserUtilsLoadFollowersData UserUtilsLoadFollowersData;
typedef struct _UserUtilsLoadFollowingData UserUtilsLoadFollowingData;

struct _Friendship {
	gboolean followed_by;
	gboolean following;
	gboolean want_retweets;
	gboolean blocking;
};

struct _Cursor {
	gint64 next_cursor;
	gboolean full;
	JsonNode* json_object;
};

struct _UserUtilsLoadFriendshipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	gint64 user_id;
	Friendship* result;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	Account* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	RestProxyCall* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	JsonNode* root;
	JsonNode* _tmp16_;
	RestProxyCall* _tmp17_;
	JsonNode* _tmp18_;
	JsonNode* _tmp19_;
	GError* e;
	GError* _tmp20_;
	const gchar* _tmp21_;
	JsonObject* relationship;
	JsonNode* _tmp22_;
	JsonObject* _tmp23_;
	JsonObject* _tmp24_;
	JsonObject* _tmp25_;
	JsonObject* target;
	JsonObject* _tmp26_;
	JsonObject* _tmp27_;
	JsonObject* _tmp28_;
	JsonObject* source;
	JsonObject* _tmp29_;
	JsonObject* _tmp30_;
	JsonObject* _tmp31_;
	Friendship friendship;
	JsonObject* _tmp32_;
	gboolean _tmp33_;
	JsonObject* _tmp34_;
	gboolean _tmp35_;
	JsonObject* _tmp36_;
	gboolean _tmp37_;
	JsonObject* _tmp38_;
	gboolean _tmp39_;
	Friendship* _tmp40_;
	GError * _inner_error_;
};

struct _UserUtilsLoadFollowersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	gint64 user_id;
	Cursor* old_cursor;
	Cursor* result;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	Cursor* _tmp15_;
	RestProxyCall* _tmp16_;
	Cursor* _tmp17_;
	gint64 _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	JsonNode* root;
	JsonNode* _tmp21_;
	RestProxyCall* _tmp22_;
	JsonNode* _tmp23_;
	JsonNode* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	JsonObject* root_obj;
	JsonNode* _tmp27_;
	JsonObject* _tmp28_;
	JsonObject* _tmp29_;
	JsonArray* user_array;
	JsonObject* _tmp30_;
	JsonArray* _tmp31_;
	JsonArray* _tmp32_;
	Cursor cursor;
	JsonObject* _tmp33_;
	gint64 _tmp34_;
	JsonArray* _tmp35_;
	guint _tmp36_;
	JsonObject* _tmp37_;
	JsonNode* _tmp38_;
	JsonNode* _tmp39_;
	Cursor _tmp40_;
	Cursor* _tmp41_;
	Cursor* _tmp42_;
	GError * _inner_error_;
};

struct _UserUtilsLoadFollowingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	gint64 user_id;
	Cursor* old_cursor;
	Cursor* result;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	Cursor* _tmp15_;
	RestProxyCall* _tmp16_;
	Cursor* _tmp17_;
	gint64 _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	JsonNode* root;
	JsonNode* _tmp21_;
	RestProxyCall* _tmp22_;
	JsonNode* _tmp23_;
	JsonNode* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	JsonObject* root_obj;
	JsonNode* _tmp27_;
	JsonObject* _tmp28_;
	JsonObject* _tmp29_;
	JsonArray* user_array;
	JsonObject* _tmp30_;
	JsonArray* _tmp31_;
	JsonArray* _tmp32_;
	Cursor cursor;
	JsonObject* _tmp33_;
	gint64 _tmp34_;
	JsonArray* _tmp35_;
	guint _tmp36_;
	JsonObject* _tmp37_;
	JsonNode* _tmp38_;
	JsonNode* _tmp39_;
	Cursor _tmp40_;
	Cursor* _tmp41_;
	Cursor* _tmp42_;
	GError * _inner_error_;
};



GType friendship_get_type (void) G_GNUC_CONST;
Friendship* friendship_dup (const Friendship* self);
void friendship_free (Friendship* self);
GType cursor_get_type (void) G_GNUC_CONST;
Cursor* cursor_dup (const Cursor* self);
void cursor_free (Cursor* self);
void cursor_copy (const Cursor* self, Cursor* dest);
void cursor_destroy (Cursor* self);
static void _vala_JsonNode_free (JsonNode* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void user_utils_load_friendship_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
void user_utils_load_friendship (Account* account, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
Friendship* user_utils_load_friendship_finish (GAsyncResult* _res_);
static gboolean user_utils_load_friendship_co (UserUtilsLoadFriendshipData* _data_);
OAuthProxy* account_get_proxy (Account* self);
gint64 account_get_id (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void user_utils_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void user_utils_load_followers_data_free (gpointer _data);
void user_utils_load_followers (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_followers_finish (GAsyncResult* _res_);
static gboolean user_utils_load_followers_co (UserUtilsLoadFollowersData* _data_);
static void user_utils_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void user_utils_load_following_data_free (gpointer _data);
void user_utils_load_following (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_);
Cursor* user_utils_load_following_finish (GAsyncResult* _res_);
static gboolean user_utils_load_following_co (UserUtilsLoadFollowingData* _data_);
static void user_utils_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);


Friendship* friendship_dup (const Friendship* self) {
	Friendship* dup;
	dup = g_new0 (Friendship, 1);
	memcpy (dup, self, sizeof (Friendship));
	return dup;
}


void friendship_free (Friendship* self) {
	g_free (self);
}


GType friendship_get_type (void) {
	static volatile gsize friendship_type_id__volatile = 0;
	if (g_once_init_enter (&friendship_type_id__volatile)) {
		GType friendship_type_id;
		friendship_type_id = g_boxed_type_register_static ("Friendship", (GBoxedCopyFunc) friendship_dup, (GBoxedFreeFunc) friendship_free);
		g_once_init_leave (&friendship_type_id__volatile, friendship_type_id);
	}
	return friendship_type_id__volatile;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


void cursor_copy (const Cursor* self, Cursor* dest) {
	gint64 _tmp0_ = 0LL;
	gboolean _tmp1_ = FALSE;
	JsonNode* _tmp2_ = NULL;
	JsonNode* _tmp3_ = NULL;
	_tmp0_ = (*self).next_cursor;
	(*dest).next_cursor = _tmp0_;
	_tmp1_ = (*self).full;
	(*dest).full = _tmp1_;
	_tmp2_ = (*self).json_object;
	_tmp3_ = __vala_JsonNode_copy0 (_tmp2_);
	__vala_JsonNode_free0 ((*dest).json_object);
	(*dest).json_object = _tmp3_;
}


void cursor_destroy (Cursor* self) {
	__vala_JsonNode_free0 ((*self).json_object);
}


Cursor* cursor_dup (const Cursor* self) {
	Cursor* dup;
	dup = g_new0 (Cursor, 1);
	cursor_copy (self, dup);
	return dup;
}


void cursor_free (Cursor* self) {
	cursor_destroy (self);
	g_free (self);
}


GType cursor_get_type (void) {
	static volatile gsize cursor_type_id__volatile = 0;
	if (g_once_init_enter (&cursor_type_id__volatile)) {
		GType cursor_type_id;
		cursor_type_id = g_boxed_type_register_static ("Cursor", (GBoxedCopyFunc) cursor_dup, (GBoxedFreeFunc) cursor_free);
		g_once_init_leave (&cursor_type_id__volatile, cursor_type_id);
	}
	return cursor_type_id__volatile;
}


static void user_utils_load_friendship_data_free (gpointer _data) {
	UserUtilsLoadFriendshipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_friendship_free0 (_data_->result);
	g_slice_free (UserUtilsLoadFriendshipData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void user_utils_load_friendship (Account* account, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserUtilsLoadFriendshipData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	_data_ = g_slice_new0 (UserUtilsLoadFriendshipData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, user_utils_load_friendship);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_utils_load_friendship_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = user_id;
	_data_->user_id = _tmp2_;
	user_utils_load_friendship_co (_data_);
}


Friendship* user_utils_load_friendship_finish (GAsyncResult* _res_) {
	Friendship* result;
	UserUtilsLoadFriendshipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void user_utils_load_friendship_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserUtilsLoadFriendshipData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_utils_load_friendship_co (_data_);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _friendship_dup0 (gpointer self) {
	return self ? friendship_dup (self) : NULL;
}


static gboolean user_utils_load_friendship_co (UserUtilsLoadFriendshipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_proxy (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/friendships/show.json");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "GET");
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->account;
	_data_->_tmp8_ = 0LL;
	_data_->_tmp8_ = account_get_id (_data_->_tmp7_);
	_data_->_tmp9_ = 0LL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_add_param (_data_->_tmp6_, "source_id", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->call;
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->user_id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_tmp12_, "target_id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	_data_->root = NULL;
	{
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp17_, user_utils_load_friendship_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp16_ = _data_->_tmp18_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch87_g_error;
		}
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp16_;
		_data_->_tmp16_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp19_;
		__vala_JsonNode_free0 (_data_->_tmp16_);
	}
	goto __finally87;
	__catch87_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->e;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		g_warning ("UserUtils.vala:47: %s", _data_->_tmp21_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally87:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->root;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = json_node_get_object (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = json_object_get_object_member (_data_->_tmp23_, "relationship");
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _json_object_ref0 (_data_->_tmp24_);
	_data_->relationship = _data_->_tmp25_;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->relationship;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = json_object_get_object_member (_data_->_tmp26_, "target");
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _json_object_ref0 (_data_->_tmp27_);
	_data_->target = _data_->_tmp28_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->relationship;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = json_object_get_object_member (_data_->_tmp29_, "source");
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _json_object_ref0 (_data_->_tmp30_);
	_data_->source = _data_->_tmp31_;
	memset (&_data_->friendship, 0, sizeof (Friendship));
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->target;
	_data_->_tmp33_ = FALSE;
	_data_->_tmp33_ = json_object_get_boolean_member (_data_->_tmp32_, "following");
	_data_->friendship.followed_by = _data_->_tmp33_;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->target;
	_data_->_tmp35_ = FALSE;
	_data_->_tmp35_ = json_object_get_boolean_member (_data_->_tmp34_, "followed_by");
	_data_->friendship.following = _data_->_tmp35_;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->source;
	_data_->_tmp37_ = FALSE;
	_data_->_tmp37_ = json_object_get_boolean_member (_data_->_tmp36_, "want_retweets");
	_data_->friendship.want_retweets = _data_->_tmp37_;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->source;
	_data_->_tmp39_ = FALSE;
	_data_->_tmp39_ = json_object_get_boolean_member (_data_->_tmp38_, "blocking");
	_data_->friendship.blocking = _data_->_tmp39_;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _friendship_dup0 (&_data_->friendship);
	_data_->result = _data_->_tmp40_;
	_json_object_unref0 (_data_->source);
	_json_object_unref0 (_data_->target);
	_json_object_unref0 (_data_->relationship);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_json_object_unref0 (_data_->source);
	_json_object_unref0 (_data_->target);
	_json_object_unref0 (_data_->relationship);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void user_utils_load_followers_data_free (gpointer _data) {
	UserUtilsLoadFollowersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_cursor_free0 (_data_->old_cursor);
	_cursor_free0 (_data_->result);
	g_slice_free (UserUtilsLoadFollowersData, _data_);
}


static gpointer _cursor_dup0 (gpointer self) {
	return self ? cursor_dup (self) : NULL;
}


void user_utils_load_followers (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserUtilsLoadFollowersData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Cursor* _tmp3_ = NULL;
	Cursor* _tmp4_ = NULL;
	_data_ = g_slice_new0 (UserUtilsLoadFollowersData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, user_utils_load_followers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_utils_load_followers_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = user_id;
	_data_->user_id = _tmp2_;
	_tmp3_ = old_cursor;
	_tmp4_ = _cursor_dup0 (_tmp3_);
	_cursor_free0 (_data_->old_cursor);
	_data_->old_cursor = _tmp4_;
	user_utils_load_followers_co (_data_);
}


Cursor* user_utils_load_followers_finish (GAsyncResult* _res_) {
	Cursor* result;
	UserUtilsLoadFollowersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void user_utils_load_followers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserUtilsLoadFollowersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_utils_load_followers_co (_data_);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gboolean user_utils_load_followers_co (UserUtilsLoadFollowersData* _data_) {
	static const gint requested = 25;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_proxy (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/followers/list.json");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "GET");
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	_data_->_tmp7_ = 0LL;
	_data_->_tmp7_ = _data_->user_id;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	rest_proxy_call_add_param (_data_->_tmp6_, "user_id", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strdup_printf ("%i", requested);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	rest_proxy_call_add_param (_data_->_tmp10_, "count", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "skip_status", "true");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp14_, "include_user_entities", "false");
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->old_cursor;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->call;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->old_cursor;
		_data_->_tmp18_ = 0LL;
		_data_->_tmp18_ = (*_data_->_tmp17_).next_cursor;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp18_);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_;
		rest_proxy_call_add_param (_data_->_tmp16_, "cursor", _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
	}
	_data_->root = NULL;
	{
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp22_, user_utils_load_followers_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp21_ = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch88_g_error;
		}
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->_tmp21_;
		_data_->_tmp21_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp24_;
		__vala_JsonNode_free0 (_data_->_tmp21_);
	}
	goto __finally88;
	__catch88_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->e;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning ("UserUtils.vala:85: %s", _data_->_tmp26_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally88:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->root;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = json_node_get_object (_data_->_tmp27_);
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _json_object_ref0 (_data_->_tmp28_);
	_data_->root_obj = _data_->_tmp29_;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->root_obj;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = json_object_get_array_member (_data_->_tmp30_, "users");
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _json_array_ref0 (_data_->_tmp31_);
	_data_->user_array = _data_->_tmp32_;
	memset (&_data_->cursor, 0, sizeof (Cursor));
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->root_obj;
	_data_->_tmp34_ = 0LL;
	_data_->_tmp34_ = json_object_get_int_member (_data_->_tmp33_, "next_cursor");
	_data_->cursor.next_cursor = _data_->_tmp34_;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->user_array;
	_data_->_tmp36_ = 0U;
	_data_->_tmp36_ = json_array_get_length (_data_->_tmp35_);
	_data_->cursor.full = _data_->_tmp36_ < ((guint) requested);
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->root_obj;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = json_object_get_member (_data_->_tmp37_, "users");
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = __vala_JsonNode_copy0 (_data_->_tmp38_);
	__vala_JsonNode_free0 (_data_->cursor.json_object);
	_data_->cursor.json_object = _data_->_tmp39_;
	memset (&_data_->_tmp40_, 0, sizeof (Cursor));
	_data_->_tmp40_ = _data_->cursor;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _cursor_dup0 (&_data_->_tmp40_);
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->_tmp41_;
	cursor_destroy (&_data_->_tmp40_);
	_data_->result = _data_->_tmp42_;
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	cursor_destroy (&_data_->cursor);
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void user_utils_load_following_data_free (gpointer _data) {
	UserUtilsLoadFollowingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_cursor_free0 (_data_->old_cursor);
	_cursor_free0 (_data_->result);
	g_slice_free (UserUtilsLoadFollowingData, _data_);
}


void user_utils_load_following (Account* account, gint64 user_id, Cursor* old_cursor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserUtilsLoadFollowingData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	Cursor* _tmp3_ = NULL;
	Cursor* _tmp4_ = NULL;
	_data_ = g_slice_new0 (UserUtilsLoadFollowingData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, user_utils_load_following);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_utils_load_following_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = user_id;
	_data_->user_id = _tmp2_;
	_tmp3_ = old_cursor;
	_tmp4_ = _cursor_dup0 (_tmp3_);
	_cursor_free0 (_data_->old_cursor);
	_data_->old_cursor = _tmp4_;
	user_utils_load_following_co (_data_);
}


Cursor* user_utils_load_following_finish (GAsyncResult* _res_) {
	Cursor* result;
	UserUtilsLoadFollowingData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void user_utils_load_following_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserUtilsLoadFollowingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_utils_load_following_co (_data_);
}


static gboolean user_utils_load_following_co (UserUtilsLoadFollowingData* _data_) {
	static const gint requested = 25;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_proxy (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/friends/list.json");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "GET");
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	_data_->_tmp7_ = 0LL;
	_data_->_tmp7_ = _data_->user_id;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	rest_proxy_call_add_param (_data_->_tmp6_, "user_id", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strdup_printf ("%i", requested);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	rest_proxy_call_add_param (_data_->_tmp10_, "count", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "skip_status", "true");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp14_, "include_user_entities", "false");
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->old_cursor;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->call;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->old_cursor;
		_data_->_tmp18_ = 0LL;
		_data_->_tmp18_ = (*_data_->_tmp17_).next_cursor;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp18_);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_;
		rest_proxy_call_add_param (_data_->_tmp16_, "cursor", _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
	}
	_data_->root = NULL;
	{
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp22_, user_utils_load_following_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp21_ = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch89_g_error;
		}
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->_tmp21_;
		_data_->_tmp21_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp24_;
		__vala_JsonNode_free0 (_data_->_tmp21_);
	}
	goto __finally89;
	__catch89_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->e;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning ("UserUtils.vala:121: %s", _data_->_tmp26_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally89:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->root;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = json_node_get_object (_data_->_tmp27_);
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _json_object_ref0 (_data_->_tmp28_);
	_data_->root_obj = _data_->_tmp29_;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->root_obj;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = json_object_get_array_member (_data_->_tmp30_, "users");
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _json_array_ref0 (_data_->_tmp31_);
	_data_->user_array = _data_->_tmp32_;
	memset (&_data_->cursor, 0, sizeof (Cursor));
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->root_obj;
	_data_->_tmp34_ = 0LL;
	_data_->_tmp34_ = json_object_get_int_member (_data_->_tmp33_, "next_cursor");
	_data_->cursor.next_cursor = _data_->_tmp34_;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->user_array;
	_data_->_tmp36_ = 0U;
	_data_->_tmp36_ = json_array_get_length (_data_->_tmp35_);
	_data_->cursor.full = _data_->_tmp36_ < ((guint) requested);
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->root_obj;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = json_object_get_member (_data_->_tmp37_, "users");
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = __vala_JsonNode_copy0 (_data_->_tmp38_);
	__vala_JsonNode_free0 (_data_->cursor.json_object);
	_data_->cursor.json_object = _data_->_tmp39_;
	memset (&_data_->_tmp40_, 0, sizeof (Cursor));
	_data_->_tmp40_ = _data_->cursor;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _cursor_dup0 (&_data_->_tmp40_);
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->_tmp41_;
	cursor_destroy (&_data_->_tmp40_);
	_data_->result = _data_->_tmp42_;
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	cursor_destroy (&_data_->cursor);
	_json_array_unref0 (_data_->user_array);
	_json_object_unref0 (_data_->root_obj);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}



