/* This file is auto-generated by optc-gen.awk.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "options.h"
#include "tm.h"
#include "opts.h"
#include "intl.h"
#include "insn-attr-common.h"

#include "diagnostic-color.h"
#include "pretty-print.h"

static const struct cl_enum_arg cl_enum_asm_dialect_data[] = 
{
  { "att", ASM_ATT, 0 },
  { "intel", ASM_INTEL, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_asm_dialect_set (void *var, int value)
{
  *((enum asm_dialect *) var) = (enum asm_dialect) value;
}

static int
cl_enum_asm_dialect_get (const void *var)
{
  return (int) *((const enum asm_dialect *) var);
}

static const struct cl_enum_arg cl_enum_calling_abi_data[] = 
{
  { "ms", MS_ABI, 0 },
  { "sysv", SYSV_ABI, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_calling_abi_set (void *var, int value)
{
  *((enum calling_abi *) var) = (enum calling_abi) value;
}

static int
cl_enum_calling_abi_get (const void *var)
{
  return (int) *((const enum calling_abi *) var);
}

static const struct cl_enum_arg cl_enum_cmodel_data[] = 
{
  { "32", CM_32, 0 },
  { "kernel", CM_KERNEL, 0 },
  { "large", CM_LARGE, 0 },
  { "medium", CM_MEDIUM, 0 },
  { "small", CM_SMALL, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_cmodel_set (void *var, int value)
{
  *((enum cmodel *) var) = (enum cmodel) value;
}

static int
cl_enum_cmodel_get (const void *var)
{
  return (int) *((const enum cmodel *) var);
}

static const struct cl_enum_arg cl_enum_diagnostic_color_rule_data[] = 
{
  { "always", DIAGNOSTICS_COLOR_YES, 0 },
  { "auto", DIAGNOSTICS_COLOR_AUTO, 0 },
  { "never", DIAGNOSTICS_COLOR_NO, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostic_color_rule_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostic_color_rule_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_diagnostic_prefixing_rule_data[] = 
{
  { "every-line", DIAGNOSTICS_SHOW_PREFIX_EVERY_LINE, 0 },
  { "once", DIAGNOSTICS_SHOW_PREFIX_ONCE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_diagnostic_prefixing_rule_set (void *var, int value)
{
  *((int *) var) = (int) value;
}

static int
cl_enum_diagnostic_prefixing_rule_get (const void *var)
{
  return (int) *((const int *) var);
}

static const struct cl_enum_arg cl_enum_excess_precision_data[] = 
{
  { "fast", EXCESS_PRECISION_FAST, 0 },
  { "standard", EXCESS_PRECISION_STANDARD, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_excess_precision_set (void *var, int value)
{
  *((enum excess_precision *) var) = (enum excess_precision) value;
}

static int
cl_enum_excess_precision_get (const void *var)
{
  return (int) *((const enum excess_precision *) var);
}

static const struct cl_enum_arg cl_enum_fp_contract_mode_data[] = 
{
  { "fast", FP_CONTRACT_FAST, 0 },
  { "off", FP_CONTRACT_OFF, 0 },
  { "on", FP_CONTRACT_OFF, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_fp_contract_mode_set (void *var, int value)
{
  *((enum fp_contract_mode *) var) = (enum fp_contract_mode) value;
}

static int
cl_enum_fp_contract_mode_get (const void *var)
{
  return (int) *((const enum fp_contract_mode *) var);
}

static const struct cl_enum_arg cl_enum_fpmath_unit_data[] = 
{
  { "387", FPMATH_387, 0 },
  { "387+sse", (enum fpmath_unit) (FPMATH_SSE | FPMATH_387), 0 },
  { "387,sse", (enum fpmath_unit) (FPMATH_SSE | FPMATH_387), 0 },
  { "both", (enum fpmath_unit) (FPMATH_SSE | FPMATH_387), 0 },
  { "sse", FPMATH_SSE, 0 },
  { "sse+387", (enum fpmath_unit) (FPMATH_SSE | FPMATH_387), 0 },
  { "sse,387", (enum fpmath_unit) (FPMATH_SSE | FPMATH_387), 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_fpmath_unit_set (void *var, int value)
{
  *((enum fpmath_unit *) var) = (enum fpmath_unit) value;
}

static int
cl_enum_fpmath_unit_get (const void *var)
{
  return (int) *((const enum fpmath_unit *) var);
}

static const struct cl_enum_arg cl_enum_ira_algorithm_data[] = 
{
  { "CB", IRA_ALGORITHM_CB, 0 },
  { "priority", IRA_ALGORITHM_PRIORITY, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_ira_algorithm_set (void *var, int value)
{
  *((enum ira_algorithm *) var) = (enum ira_algorithm) value;
}

static int
cl_enum_ira_algorithm_get (const void *var)
{
  return (int) *((const enum ira_algorithm *) var);
}

static const struct cl_enum_arg cl_enum_ira_region_data[] = 
{
  { "all", IRA_REGION_ALL, 0 },
  { "mixed", IRA_REGION_MIXED, 0 },
  { "one", IRA_REGION_ONE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_ira_region_set (void *var, int value)
{
  *((enum ira_region *) var) = (enum ira_region) value;
}

static int
cl_enum_ira_region_get (const void *var)
{
  return (int) *((const enum ira_region *) var);
}

static const struct cl_enum_arg cl_enum_ix86_veclibabi_data[] = 
{
  { "acml", ix86_veclibabi_type_acml, 0 },
  { "svml", ix86_veclibabi_type_svml, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_ix86_veclibabi_set (void *var, int value)
{
  *((enum ix86_veclibabi *) var) = (enum ix86_veclibabi) value;
}

static int
cl_enum_ix86_veclibabi_get (const void *var)
{
  return (int) *((const enum ix86_veclibabi *) var);
}

static const struct cl_enum_arg cl_enum_pmode_data[] = 
{
  { "long", PMODE_DI, 0 },
  { "short", PMODE_SI, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_pmode_set (void *var, int value)
{
  *((enum pmode *) var) = (enum pmode) value;
}

static int
cl_enum_pmode_get (const void *var)
{
  return (int) *((const enum pmode *) var);
}

static const struct cl_enum_arg cl_enum_stack_protector_guard_data[] = 
{
  { "global", SSP_GLOBAL, 0 },
  { "tls", SSP_TLS, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_stack_protector_guard_set (void *var, int value)
{
  *((enum stack_protector_guard *) var) = (enum stack_protector_guard) value;
}

static int
cl_enum_stack_protector_guard_get (const void *var)
{
  return (int) *((const enum stack_protector_guard *) var);
}

static const struct cl_enum_arg cl_enum_stack_reuse_level_data[] = 
{
  { "all", SR_ALL, 0 },
  { "named_vars", SR_NAMED_VARS, 0 },
  { "none", SR_NONE, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_stack_reuse_level_set (void *var, int value)
{
  *((enum stack_reuse_level *) var) = (enum stack_reuse_level) value;
}

static int
cl_enum_stack_reuse_level_get (const void *var)
{
  return (int) *((const enum stack_reuse_level *) var);
}

static const struct cl_enum_arg cl_enum_stringop_alg_data[] = 
{
  { "byte_loop", loop_1_byte, 0 },
  { "libcall", libcall, 0 },
  { "loop", loop, 0 },
  { "rep_4byte", rep_prefix_4_byte, 0 },
  { "rep_8byte", rep_prefix_8_byte, 0 },
  { "rep_byte", rep_prefix_1_byte, 0 },
  { "unrolled_loop", unrolled_loop, 0 },
  { "vector_loop", vector_loop, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_stringop_alg_set (void *var, int value)
{
  *((enum stringop_alg *) var) = (enum stringop_alg) value;
}

static int
cl_enum_stringop_alg_get (const void *var)
{
  return (int) *((const enum stringop_alg *) var);
}

static const struct cl_enum_arg cl_enum_symbol_visibility_data[] = 
{
  { "default", VISIBILITY_DEFAULT, 0 },
  { "hidden", VISIBILITY_HIDDEN, 0 },
  { "internal", VISIBILITY_INTERNAL, 0 },
  { "protected", VISIBILITY_PROTECTED, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_symbol_visibility_set (void *var, int value)
{
  *((enum symbol_visibility *) var) = (enum symbol_visibility) value;
}

static int
cl_enum_symbol_visibility_get (const void *var)
{
  return (int) *((const enum symbol_visibility *) var);
}

static const struct cl_enum_arg cl_enum_tls_dialect_data[] = 
{
  { "gnu", TLS_DIALECT_GNU, 0 },
  { "gnu2", TLS_DIALECT_GNU2, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_tls_dialect_set (void *var, int value)
{
  *((enum tls_dialect *) var) = (enum tls_dialect) value;
}

static int
cl_enum_tls_dialect_get (const void *var)
{
  return (int) *((const enum tls_dialect *) var);
}

static const struct cl_enum_arg cl_enum_tls_model_data[] = 
{
  { "global-dynamic", TLS_MODEL_GLOBAL_DYNAMIC, 0 },
  { "initial-exec", TLS_MODEL_INITIAL_EXEC, 0 },
  { "local-dynamic", TLS_MODEL_LOCAL_DYNAMIC, 0 },
  { "local-exec", TLS_MODEL_LOCAL_EXEC, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_tls_model_set (void *var, int value)
{
  *((enum tls_model *) var) = (enum tls_model) value;
}

static int
cl_enum_tls_model_get (const void *var)
{
  return (int) *((const enum tls_model *) var);
}

static const struct cl_enum_arg cl_enum_vect_cost_model_data[] = 
{
  { "cheap", VECT_COST_MODEL_CHEAP, 0 },
  { "dynamic", VECT_COST_MODEL_DYNAMIC, 0 },
  { "unlimited", VECT_COST_MODEL_UNLIMITED, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_vect_cost_model_set (void *var, int value)
{
  *((enum vect_cost_model *) var) = (enum vect_cost_model) value;
}

static int
cl_enum_vect_cost_model_get (const void *var)
{
  return (int) *((const enum vect_cost_model *) var);
}

static const struct cl_enum_arg cl_enum_vtv_priority_data[] = 
{
  { "none", VTV_NO_PRIORITY, 0 },
  { "preinit", VTV_PREINIT_PRIORITY, 0 },
  { "std", VTV_STANDARD_PRIORITY, 0 },
  { NULL, 0, 0 }
};

static void
cl_enum_vtv_priority_set (void *var, int value)
{
  *((enum vtv_priority *) var) = (enum vtv_priority) value;
}

static int
cl_enum_vtv_priority_get (const void *var)
{
  return (int) *((const enum vtv_priority *) var);
}

const struct cl_enum cl_enums[] =
{
  {
    "Known assembler dialects (for use with the -masm-dialect= option):",
    NULL,
    cl_enum_asm_dialect_data,
    sizeof (enum asm_dialect),
    cl_enum_asm_dialect_set,
    cl_enum_asm_dialect_get
  },
  {
    "Known ABIs (for use with the -mabi= option):",
    NULL,
    cl_enum_calling_abi_data,
    sizeof (enum calling_abi),
    cl_enum_calling_abi_set,
    cl_enum_calling_abi_get
  },
  {
    "Known code models (for use with the -mcmodel= option):",
    NULL,
    cl_enum_cmodel_data,
    sizeof (enum cmodel),
    cl_enum_cmodel_set,
    cl_enum_cmodel_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostic_color_rule_data,
    sizeof (int),
    cl_enum_diagnostic_color_rule_set,
    cl_enum_diagnostic_color_rule_get
  },
  {
    NULL,
    NULL,
    cl_enum_diagnostic_prefixing_rule_data,
    sizeof (int),
    cl_enum_diagnostic_prefixing_rule_set,
    cl_enum_diagnostic_prefixing_rule_get
  },
  {
    NULL,
    "unknown excess precision style %qs",
    cl_enum_excess_precision_data,
    sizeof (enum excess_precision),
    cl_enum_excess_precision_set,
    cl_enum_excess_precision_get
  },
  {
    NULL,
    "unknown floating point contraction style %qs",
    cl_enum_fp_contract_mode_data,
    sizeof (enum fp_contract_mode),
    cl_enum_fp_contract_mode_set,
    cl_enum_fp_contract_mode_get
  },
  {
    "Valid arguments to -mfpmath=:",
    NULL,
    cl_enum_fpmath_unit_data,
    sizeof (enum fpmath_unit),
    cl_enum_fpmath_unit_set,
    cl_enum_fpmath_unit_get
  },
  {
    NULL,
    "unknown IRA algorithm %qs",
    cl_enum_ira_algorithm_data,
    sizeof (enum ira_algorithm),
    cl_enum_ira_algorithm_set,
    cl_enum_ira_algorithm_get
  },
  {
    NULL,
    "unknown IRA region %qs",
    cl_enum_ira_region_data,
    sizeof (enum ira_region),
    cl_enum_ira_region_set,
    cl_enum_ira_region_get
  },
  {
    "Known vectorization library ABIs (for use with the -mveclibabi= option):",
    NULL,
    cl_enum_ix86_veclibabi_data,
    sizeof (enum ix86_veclibabi),
    cl_enum_ix86_veclibabi_set,
    cl_enum_ix86_veclibabi_get
  },
  {
    "Known address mode (for use with the -maddress-mode= option):",
    NULL,
    cl_enum_pmode_data,
    sizeof (enum pmode),
    cl_enum_pmode_set,
    cl_enum_pmode_get
  },
  {
    "Known stack protector guard (for use with the -mstack-protector-guard= option):",
    NULL,
    cl_enum_stack_protector_guard_data,
    sizeof (enum stack_protector_guard),
    cl_enum_stack_protector_guard_set,
    cl_enum_stack_protector_guard_get
  },
  {
    NULL,
    "unknown Stack Reuse Level %qs",
    cl_enum_stack_reuse_level_data,
    sizeof (enum stack_reuse_level),
    cl_enum_stack_reuse_level_set,
    cl_enum_stack_reuse_level_get
  },
  {
    "Valid arguments to -mstringop-strategy=:",
    NULL,
    cl_enum_stringop_alg_data,
    sizeof (enum stringop_alg),
    cl_enum_stringop_alg_set,
    cl_enum_stringop_alg_get
  },
  {
    NULL,
    "unrecognized visibility value %qs",
    cl_enum_symbol_visibility_data,
    sizeof (enum symbol_visibility),
    cl_enum_symbol_visibility_set,
    cl_enum_symbol_visibility_get
  },
  {
    "Known TLS dialects (for use with the -mtls-dialect= option):",
    NULL,
    cl_enum_tls_dialect_data,
    sizeof (enum tls_dialect),
    cl_enum_tls_dialect_set,
    cl_enum_tls_dialect_get
  },
  {
    NULL,
    "unknown TLS model %qs",
    cl_enum_tls_model_data,
    sizeof (enum tls_model),
    cl_enum_tls_model_set,
    cl_enum_tls_model_get
  },
  {
    NULL,
    "unknown vectorizer cost model %qs",
    cl_enum_vect_cost_model_data,
    sizeof (enum vect_cost_model),
    cl_enum_vect_cost_model_set,
    cl_enum_vect_cost_model_get
  },
  {
    NULL,
    "unknown vtable verify initialization priority %qs",
    cl_enum_vtv_priority_data,
    sizeof (enum vtv_priority),
    cl_enum_vtv_priority_set,
    cl_enum_vtv_priority_get
  },
};
const unsigned int cl_enums_count = 20;

const struct gcc_options global_options_init =
{
  RECIP_MASK_DEFAULT, /* recip_mask */
  0, /* frame_larger_than_size */
  TARGET_64BIT_DEFAULT | TARGET_SUBTARGET_ISA_DEFAULT, /* ix86_isa_flags */
  0, /* ix86_isa_flags_explicit */
  0, /* larger_than_size */
  false, /* dump_base_name_prefixed */
  0, /* exit_after_options */
  0, /* flag_dump_all_passed */
  0, /* flag_opts_finished */
  false, /* flag_stack_usage_info */
  false, /* flag_warn_unused_result */
  false, /* in_lto_p */
  0, /* use_gnu_debug_info_extensions */
  0, /* warn_frame_larger_than */
  0, /* warn_larger_than */
  0, /* help_enum_printed */
  0, /* help_printed */
  0, /* main_input_basename */
  0, /* main_input_filename */
  DINFO_LEVEL_NONE, /* debug_info_level */
  NO_DEBUG, /* write_symbols */
  { DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY }, /* debug_struct_generic */
  { DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY, DINFO_STRUCT_FILE_ANY }, /* debug_struct_ordinary */
  NO_STACK_CHECK, /* flag_stack_check */
  0, /* param_values */
  1, /* flag_complex_method */
  0, /* flag_debug_asm */
  0, /* flag_dump_rtl_in_asm */
  0, /* flag_evaluation_order */
  0, /* flag_gen_aux_info */
  0, /* flag_generate_lto */
  0, /* flag_print_asm_name */
  0, /* flag_shlib */
  0, /* ix86_target_flags_explicit */
  0, /* main_input_baselength */
  0, /* optimize */
  0, /* optimize_debug */
  0, /* optimize_fast */
  0, /* optimize_size */
  0, /* recip_mask_explicit */
  0, /* rtl_dump_and_exit */
  0, /* target_flags */
  0, /* flag_sanitize */
  0, /* help_columns */
  TARGET_DEFAULT_PACK_STRUCT, /* initial_max_fld_align */
  0, /* flag_instrument_functions_exclude_files */
  0, /* flag_instrument_functions_exclude_functions */
  0, /* help_flag */
  0, /* no_sysroot_suffix */
  0, /* flag_preprocess_only */
  0, /* warn_abi */
  0, /* warn_abi_tag */
  0, /* warn_address */
  0, /* warn_aggregate_return */
  1, /* warn_aggressive_loop_optimizations */
  0, /* warn_array_bounds */
  0, /* warn_assign_intercept */
  1, /* warn_attributes */
  0, /* warn_bad_function_cast */
  0, /* warn_cxx_compat */
  0, /* warn_cxx0x_compat */
  0, /* warn_cast_align */
  0, /* warn_cast_qual */
  0, /* warn_char_subscripts */
  0, /* warn_clobbered */
  0, /* warn_conditionally_supported */
  0, /* warn_conversion */
  1, /* warn_conversion_null */
  1, /* warn_coverage_mismatch */
  1, /* warn_cpp */
  0, /* warn_ctor_dtor_privacy */
  0, /* cpp_warn_date_time */
  0, /* warn_declaration_after_statement */
  1, /* warn_delete_incomplete */
  0, /* warn_delnonvdtor */
  1, /* warn_deprecated */
  1, /* warn_deprecated_decl */
  0, /* warn_disabled_optimization */
  1, /* warn_div_by_zero */
  0, /* warn_double_promotion */
  0, /* warn_ecpp */
  0, /* warn_empty_body */
  -1, /* warn_enum_compare */
  0, /* warnings_are_errors */
  0, /* extra_warnings */
  0, /* flag_extraneous_semicolon */
  0, /* flag_fatal_errors */
  0, /* warn_float_conversion */
  0, /* warn_float_equal */
  0, /* warn_format_contains_nul */
  0, /* warn_format_extra_args */
  0, /* warn_format_nonliteral */
  0, /* warn_format_security */
  0, /* warn_format_y2k */
  0, /* warn_format_zero_length */
  0, /* warn_format */
  1, /* warn_free_nonheap_object */
  0, /* warn_ignored_qualifiers */
  0, /* warn_implicit */
  -1, /* warn_implicit_function_declaration */
  0, /* warn_implicit_int */
  1, /* warn_inh_var_ctor */
  0, /* warn_init_self */
  0, /* warn_inline */
  1, /* warn_int_to_pointer_cast */
  1, /* warn_invalid_memory_model */
  1, /* warn_invalid_offsetof */
  0, /* warn_jump_misses_init */
  0, /* warn_logical_op */
  -1, /* warn_long_long */
  -1, /* warn_main */
  0, /* warn_maybe_uninitialized */
  0, /* warn_missing_braces */
  0, /* warn_missing_declarations */
  0, /* warn_missing_field_initializers */
  0, /* warn_missing_parameter_type */
  0, /* warn_missing_prototypes */
  -1, /* warn_narrowing */
  0, /* warn_nested_externs */
  0, /* warn_noexcept */
  1, /* warn_nontemplate_friend */
  0, /* warn_nonvdtor */
  0, /* warn_nonnull */
  0, /* warn_old_style_cast */
  0, /* warn_old_style_declaration */
  0, /* warn_old_style_definition */
  0, /* warn_openmp_simd */
  1, /* flag_newer */
  1, /* warn_overflow */
  0, /* warn_overlength_strings */
  0, /* warn_overloaded_virtual */
  0, /* warn_override_init */
  0, /* warn_packed */
  -1, /* warn_packed_bitfield_compat */
  0, /* warn_padded */
  0, /* warn_parentheses */
  0, /* pedantic */
  1, /* warn_pmf2ptr */
  0, /* warn_pointer_arith */
  0, /* warn_pointer_sign */
  1, /* warn_pointer_to_int_cast */
  1, /* warn_pragmas */
  1, /* warn_property_assign_default */
  1, /* warn_protocol */
  1, /* warn_psabi */
  0, /* warn_redundant_decls */
  0, /* flag_redundant */
  0, /* warn_reorder */
  1, /* warn_return_local_addr */
  0, /* warn_return_type */
  0, /* warn_selector */
  0, /* warn_sequence_point */
  0, /* warn_shadow */
  0, /* warn_sign_compare */
  0, /* warn_sign_conversion */
  0, /* warn_sign_promo */
  0, /* warn_sizeof_pointer_memaccess */
  0, /* warn_stack_protect */
  -1, /* warn_stack_usage */
  0, /* warn_strict_aliasing */
  0, /* warn_strict_null_sentinel */
  0, /* warn_strict_overflow */
  0, /* warn_strict_prototypes */
  0, /* warn_strict_selector_match */
  0, /* warn_suggest_attribute_const */
  0, /* warn_suggest_attribute_format */
  0, /* warn_suggest_attribute_noreturn */
  0, /* warn_suggest_attribute_pure */
  0, /* warn_switch */
  0, /* warn_switch_default */
  0, /* warn_switch_enum */
  1, /* warn_sync_nand */
  0, /* warn_synth */
  0, /* warn_system_headers */
  0, /* warn_traditional */
  0, /* warn_traditional_conversion */
  0, /* warn_trampolines */
  0, /* warn_type_limits */
  0, /* warn_undeclared_selector */
  0, /* warn_uninitialized */
  0, /* warn_unknown_pragmas */
  0, /* warn_unsafe_loop_optimizations */
  0, /* warn_unsuffixed_float_constants */
  0, /* warn_unused */
  0, /* warn_unused_but_set_parameter */
  0, /* warn_unused_but_set_variable */
  0, /* warn_unused_function */
  0, /* warn_unused_label */
  0, /* warn_unused_local_typedefs */
  0, /* cpp_warn_unused_macros */
  0, /* warn_unused_parameter */
  1, /* warn_unused_result */
  0, /* warn_unused_value */
  0, /* warn_unused_variable */
  0, /* warn_useless_cast */
  1, /* warn_varargs */
  1, /* cpp_warn_variadic_macros */
  0, /* warn_vector_operation_performance */
  1, /* warn_virtual_move_assign */
  -1, /* warn_vla */
  0, /* warn_volatile_register_var */
  0, /* warn_write_strings */
  0, /* warn_zero_as_null_pointer_constant */
  0, /* aux_info_file_name */
  0, /* aux_base_name */
  0, /* dump_base_name */
  0, /* dump_dir_name */
  0, /* flag_pic */
  0, /* flag_pie */
  2, /* flag_abi_version */
  1, /* flag_access_control */
  0, /* ada_specs_parent */
  1, /* flag_aggressive_loop_optimizations */
  0, /* align_functions */
  0, /* align_jumps */
  0, /* align_labels */
  0, /* align_loops */
  0, /* flag_allow_parameterless_variadic_functions */
  0, /* flag_no_asm */
  1, /* flag_assert */
  0, /* flag_associative_math */
  0, /* flag_asynchronous_unwind_tables */
  1, /* flag_auto_inc_dec */
  0, /* flag_bootstrap_classes */
  0, /* flag_bounds_check */
  0, /* flag_branch_on_count_reg */
  0, /* flag_branch_probabilities */
  0, /* flag_branch_target_load_optimize */
  0, /* flag_branch_target_load_optimize2 */
  0, /* flag_btr_bb_exclusive */
  0, /* flag_building_libgcc */
  0, /* flag_no_builtin */
  0, /* common_deferred_options */
  0, /* flag_caller_saves */
  0, /* flag_check_data_deps */
  0, /* flag_check_new */
  0, /* flag_check_references */
  0, /* flag_cilkplus */
  0, /* flag_combine_stack_adjustments */
  0, /* flag_no_common */
  0, /* flag_compare_debug */
  0, /* flag_compare_debug_opt */
  0, /* flag_compare_elim_after_reload */
  0, /* flag_conserve_space */
  0, /* flag_conserve_stack */
  512, /* max_constexpr_depth */
  0, /* flag_cprop_registers */
  0, /* flag_crossjumping */
  0, /* flag_cse_follow_jumps */
  0, /* flag_cx_fortran_rules */
  0, /* flag_cx_limited_range */
  0, /* flag_data_sections */
  1, /* flag_dce */
  0, /* flag_debug_types_section */
  -1, /* flag_declone_ctor_dtor */
  0, /* flag_deduce_init_list */
  0, /* flag_defer_pop */
  0, /* flag_delayed_branch */
  0, /* flag_delete_dead_exceptions */
  1, /* flag_delete_null_pointer_checks */
  0, /* flag_devirtualize */
  0, /* flag_devirtualize_speculatively */
  DIAGNOSTICS_COLOR_NO, /* flag_diagnostics_show_color */
  1, /* flag_diagnostics_show_caret */
  1, /* flag_diagnostics_show_option */
  1, /* flag_dse */
  0, /* flag_dump_ada_spec */
  0, /* flag_dump_ada_spec_slim */
  0, /* flag_dump_final_insns */
  0, /* flag_dump_go_spec */
  0, /* flag_dump_noaddr */
  0, /* flag_dump_passes */
  0, /* flag_dump_unnumbered */
  0, /* flag_dump_unnumbered_links */
  HAVE_GAS_CFI_DIRECTIVE, /* flag_dwarf2_cfi_asm */
  1, /* flag_early_inlining */
  1, /* flag_elide_constructors */
  0, /* flag_eliminate_dwarf2_dups */
  0, /* flag_debug_only_used_symbols */
  1, /* flag_eliminate_unused_debug_types */
  0, /* flag_emit_class_debug_always */
  0, /* flag_emit_class_files */
  1, /* flag_enforce_eh_specs */
  0, /* flag_exceptions */
  EXCESS_PRECISION_DEFAULT, /* flag_excess_precision_cmdline */
  0, /* flag_expensive_optimizations */
  -1, /* flag_extern_tls_init */
  0, /* flag_fat_lto_objects */
  0, /* flag_filelist_file */
  0, /* flag_finite_math_only */
  0, /* flag_float_store */
  1, /* flag_new_for_scope */
  0, /* flag_force_classes_archive_check */
  0, /* flag_forward_propagate */
  FP_CONTRACT_FAST, /* flag_fp_contract_mode */
  0, /* flag_friend_injection */
  0, /* flag_no_function_cse */
  0, /* flag_function_sections */
  0, /* flag_gcse */
  0, /* flag_gcse_after_reload */
  0, /* flag_gcse_las */
  1, /* flag_gcse_lm */
  0, /* flag_gcse_sm */
  0, /* flag_no_gnu_keywords */
  NEXT_OBJC_RUNTIME, /* flag_next_runtime */
  0, /* flag_tm */
  1, /* flag_gnu_unique */
  -1, /* flag_gnu89_inline */
  1, /* go_check_divide_overflow */
  1, /* go_check_divide_zero */
  0, /* flag_graphite */
  0, /* flag_graphite_identity */
  0, /* flag_guess_branch_prob */
  0, /* flag_hash_synchronization */
  0, /* flag_hoist_adjacent_loads */
  0, /* flag_no_ident */
  0, /* flag_if_conversion */
  0, /* flag_if_conversion2 */
  1, /* flag_implement_inlines */
  1, /* flag_implicit_inline_templates */
  1, /* flag_implicit_templates */
  1, /* flag_indirect_classes */
  0, /* flag_indirect_dispatch */
  0, /* flag_indirect_inlining */
  0, /* flag_inhibit_size_directive */
  0, /* flag_no_inline */
  1, /* flag_inline_atomics */
  0, /* flag_inline_functions */
  0, /* flag_inline_functions_called_once */
  0, /* flag_inline_small_functions */
  0, /* flag_instrument_function_entry_exit */
  0, /* flag_ipa_cp */
  0, /* flag_ipa_cp_clone */
  0, /* flag_ipa_profile */
  0, /* flag_ipa_pta */
  0, /* flag_ipa_pure_const */
  0, /* flag_ipa_reference */
  0, /* flag_ipa_sra */
  IRA_ALGORITHM_CB, /* flag_ira_algorithm */
  1, /* flag_ira_hoist_pressure */
  0, /* flag_ira_loop_pressure */
  IRA_REGION_AUTODETECT, /* flag_ira_region */
  1, /* flag_ira_share_save_slots */
  1, /* flag_ira_share_spill_slots */
  5, /* flag_ira_verbose */
  0, /* flag_isolate_erroneous_paths_attribute */
  0, /* flag_isolate_erroneous_paths_dereference */
  1, /* flag_ivopts */
  0, /* flag_jni */
  1, /* flag_jump_tables */
  1, /* flag_keep_inline_dllexport */
  0, /* flag_keep_inline_functions */
  1, /* flag_keep_static_consts */
  0, /* flag_lax_vector_conversions */
  -1, /* flag_leading_underscore */
  0, /* flag_live_range_shrinkage */
  0, /* flag_loop_block */
  0, /* flag_loop_interchange */
  0, /* flag_loop_optimize_isl */
  0, /* flag_loop_parallelize_all */
  0, /* flag_loop_strip_mine */
  -1, /* flag_lto_compression_level */
  0, /* flag_lto_partition_1to1 */
  0, /* flag_lto_partition_balanced */
  0, /* flag_lto_partition_max */
  0, /* flag_lto_partition_none */
  0, /* flag_lto_report */
  0, /* flag_lto_report_wpa */
  0, /* flag_lto */
  0, /* flag_ltrans */
  0, /* ltrans_output_list */
  1, /* flag_errno_math */
  0, /* flag_max_errors */
  0, /* mem_report */
  0, /* mem_report_wpa */
  1, /* flag_merge_constants */
  1, /* flag_merge_debug_strings */
  0, /* flag_modulo_sched */
  0, /* flag_modulo_sched_allow_regmoves */
  0, /* flag_move_loop_invariants */
  0, /* flag_ms_extensions */
  1, /* flag_nil_receivers */
  0, /* flag_non_call_exceptions */
  0, /* flag_no_nonansi_builtin */
  0, /* flag_nothrow_opt */
  0, /* flag_objc_abi */
  0, /* flag_objc_call_cxx_cdtors */
  0, /* flag_objc_direct_dispatch */
  0, /* flag_objc_exceptions */
  0, /* flag_objc_gc */
  0, /* flag_objc_nilcheck */
  -1, /* flag_objc_sjlj_exceptions */
  0, /* flag_objc1_only */
  0, /* flag_omit_frame_pointer */
  0, /* flag_openmp */
  0, /* flag_openmp_simd */
  0, /* flag_opt_info */
  0, /* flag_optimize_sibling_calls */
  0, /* flag_optimize_sci */
  0, /* flag_optimize_strlen */
  0, /* flag_pack_struct */
  0, /* flag_partial_inlining */
  DEFAULT_PCC_STRUCT_RETURN, /* flag_pcc_struct_return */
  0, /* flag_peel_loops */
  0, /* flag_no_peephole */
  0, /* flag_peephole2 */
  0, /* flag_permissive */
  0, /* flag_plan9_extensions */
  0, /* post_ipa_mem_report */
  0, /* pre_ipa_mem_report */
  0, /* flag_predictive_commoning */
  -1, /* flag_prefetch_loop_arrays */
  1, /* flag_pretty_templates */
  0, /* profile_flag */
  0, /* profile_arc_flag */
  0, /* flag_profile_correction */
  0, /* profile_data_prefix */
  0, /* flag_profile_reorder_functions */
  0, /* profile_report */
  0, /* flag_profile_use */
  0, /* flag_profile_values */
  0, /* flag_reciprocal_math */
  0, /* flag_record_gcc_switches */
  0, /* flag_reduced_reflection */
  0, /* flag_ree */
  2, /* flag_rename_registers */
  0, /* flag_reorder_blocks */
  0, /* flag_reorder_blocks_and_partition */
  0, /* flag_reorder_functions */
  0, /* flag_replace_objc_classes */
  1, /* go_require_return_statement */
  0, /* flag_rerun_cse_after_loop */
  0, /* flag_resched_modulo_sched */
  0, /* flag_rounding_math */
  1, /* flag_rtti */
  1, /* flag_sched_critical_path_heuristic */
  1, /* flag_sched_dep_count_heuristic */
  1, /* flag_sched_group_heuristic */
  1, /* flag_schedule_interblock */
  1, /* flag_sched_last_insn_heuristic */
  0, /* flag_sched_pressure */
  1, /* flag_sched_rank_heuristic */
  1, /* flag_schedule_speculative */
  1, /* flag_sched_spec_insn_heuristic */
  0, /* flag_schedule_speculative_load */
  0, /* flag_schedule_speculative_load_dangerous */
  0, /* flag_sched_stalled_insns */
  1, /* flag_sched_stalled_insns_dep */
  0, /* sched_verbose_param */
  0, /* flag_sched2_use_superblocks */
  0, /* flag_schedule_insns */
  0, /* flag_schedule_insns_after_reload */
  0, /* flag_section_anchors */
  0, /* flag_sel_sched_pipelining */
  0, /* flag_sel_sched_pipelining_outer_loops */
  0, /* flag_sel_sched_reschedule_pipelined */
  0, /* flag_selective_scheduling */
  0, /* flag_selective_scheduling2 */
  0, /* flag_short_double */
  0, /* flag_short_enums */
  0, /* flag_short_wchar */
  1, /* flag_show_column */
  0, /* flag_shrink_wrap */
  0, /* flag_signaling_nans */
  1, /* flag_signed_bitfields */
  0, /* flag_signed_char */
  1, /* flag_signed_zeros */
  VECT_COST_MODEL_UNLIMITED, /* flag_simd_cost_model */
  0, /* flag_single_precision_constant */
  1, /* flag_split_ivs_in_unroller */
  -1, /* flag_split_stack */
  0, /* flag_split_wide_types */
  0, /* flag_stack_protect */
  SR_ALL, /* flag_stack_reuse */
  0, /* flag_stack_usage */
  0, /* flag_detailed_statistics */
  1, /* flag_store_check */
  0, /* flag_strict_aliasing */
  0, /* flag_strict_enums */
  0, /* flag_strict_overflow */
  -1, /* flag_strict_volatile_bitfields */
  1, /* flag_sync_libcalls */
  0, /* flag_syntax_only */
  10, /* template_backtrace_limit */
  0, /* flag_test_coverage */
  0, /* flag_thread_jumps */
  1, /* flag_threadsafe_statics */
  0, /* time_report */
  TLS_MODEL_GLOBAL_DYNAMIC, /* flag_tls_default */
  2, /* flag_toplevel_reorder */
  0, /* flag_tracer */
  1, /* flag_trapping_math */
  0, /* flag_trapv */
  0, /* flag_tree_bit_ccp */
  0, /* flag_tree_builtin_call_dce */
  0, /* flag_tree_ccp */
  0, /* flag_tree_ch */
  2, /* flag_ssa_coalesce_vars */
  0, /* flag_tree_copy_prop */
  0, /* flag_tree_copyrename */
  2, /* flag_tree_cselim */
  0, /* flag_tree_dce */
  0, /* flag_tree_dom */
  0, /* flag_tree_dse */
  1, /* flag_tree_forwprop */
  0, /* flag_tree_fre */
  0, /* flag_tree_loop_distribute_patterns */
  0, /* flag_tree_loop_distribution */
  -1, /* flag_tree_loop_if_convert */
  0, /* flag_tree_loop_if_convert_stores */
  1, /* flag_tree_loop_im */
  1, /* flag_tree_loop_ivcanon */
  1, /* flag_tree_loop_optimize */
  0, /* flag_tree_loop_vectorize */
  0, /* flag_tree_live_range_split */
  1, /* flag_tree_parallelize_loops */
  0, /* flag_tree_partial_pre */
  1, /* flag_tree_phiprop */
  0, /* flag_tree_pre */
  0, /* flag_tree_pta */
  1, /* flag_tree_reassoc */
  1, /* flag_tree_scev_cprop */
  0, /* flag_tree_sink */
  0, /* flag_tree_slp_vectorize */
  0, /* flag_tree_slsr */
  0, /* flag_tree_sra */
  0, /* flag_tree_switch_conversion */
  0, /* flag_tree_tail_merge */
  0, /* flag_tree_ter */
  0, /* flag_tree_vectorize */
  0, /* flag_tree_vrp */
  1, /* flag_unit_at_a_time */
  0, /* flag_unroll_all_loops */
  0, /* flag_unroll_loops */
  0, /* flag_unsafe_loop_optimizations */
  0, /* flag_unsafe_math_optimizations */
  0, /* flag_unswitch_loops */
  0, /* flag_unwind_tables */
  0, /* flag_use_atomic_builtins */
  0, /* flag_use_boehm_gc */
  DEFAULT_USE_CXA_ATEXIT, /* flag_use_cxa_atexit */
  2, /* flag_use_cxa_get_exception_ptr */
  1, /* flag_use_divide_subroutine */
  0, /* flag_use_linker_plugin */
  2, /* flag_var_tracking */
  2, /* flag_var_tracking_assignments */
  0, /* flag_var_tracking_assignments_toggle */
  0, /* flag_var_tracking_uninit */
  0, /* flag_variable_expansion_in_unroller */
  VECT_COST_MODEL_DEFAULT, /* flag_vect_cost_model */
  0, /* flag_verbose_asm */
  0, /* flag_visibility_ms_compat */
  VISIBILITY_DEFAULT, /* default_visibility */
  0, /* flag_value_profile_transformations */
  VTV_NO_PRIORITY, /* flag_vtable_verify */
  0, /* flag_vtv_counts */
  0, /* flag_vtv_debug */
  1, /* flag_weak */
  2, /* flag_web */
  0, /* flag_whole_program */
  -1, /* flag_working_directory */
  0, /* flag_wpa */
  0, /* flag_wrapv */
  1, /* flag_zero_initialized_in_bss */
  0, /* flag_zero_link */
  4, /* dwarf_version */
  0, /* flag_gen_declaration */
  -1, /* debug_generate_pub_sections */
  1, /* dwarf_record_gcc_switches */
  0, /* dwarf_split_debug_info */
  0, /* dwarf_strict */
  0, /* flag_gtoggle */
  0, /* imultiarch */
  0, /* plugindir_string */
  SYSV_ABI, /* ix86_abi */
  PMODE_SI, /* ix86_pmode */
  0, /* ix86_arch_string */
  ASM_ATT, /* ix86_asm_dialect */
  0, /* ix86_branch_cost */
  CM_32, /* ix86_cmodel */
  0, /* flag_dispatch_scheduler */
  0, /* ix86_dump_tunes */
  -1, /* flag_fentry */
  0, /* ix86_force_drap */
  FPMATH_387, /* ix86_fpmath */
  0, /* ix86_incoming_stack_boundary_arg */
  DEFAULT_LARGE_SECTION_THRESHOLD, /* ix86_section_threshold */
  0, /* ix86_tune_memcpy_strategy */
  0, /* ix86_tune_memset_strategy */
  0, /* ix86_tune_no_default */
  0, /* ix86_preferred_stack_boundary_arg */
  0, /* ix86_recip_name */
  0, /* ix86_regparm */
  0, /* ix86_sse2avx */
  SSP_TLS, /* ix86_stack_protector_guard */
  -1, /* ix86_force_align_arg_pointer */
  no_stringop, /* ix86_stringop_alg */
  TLS_DIALECT_GNU, /* ix86_tls_dialect */
  0, /* ix86_tune_ctrl_string */
  0, /* ix86_tune_string */
  ix86_veclibabi_type_none, /* ix86_veclibabi_type */
  0, /* asm_file_name */
  0, /* pass_exit_codes */
  0, /* flag_pedantic_errors */
  0, /* use_pipes */
  0, /* print_file_name */
  0, /* print_multi_directory */
  0, /* print_multi_lib */
  0, /* print_multi_os_directory */
  0, /* print_multiarch */
  0, /* print_prog_name */
  0, /* print_search_dirs */
  0, /* print_sysroot */
  0, /* print_sysroot_headers_suffix */
  0, /* quiet_flag */
  0, /* report_times */
  0, /* flag_undef */
  0, /* verbose_flag */
  0, /* version_flag */
  0, /* inhibit_warnings */
  0, /* wrapper_string */
  0, /* VAR_malign_functions_ (private state) */
#undef x_VAR_malign_functions_
  0, /* VAR_malign_jumps_ (private state) */
#undef x_VAR_malign_jumps_
  0, /* VAR_malign_loops_ (private state) */
#undef x_VAR_malign_loops_
  0, /* VAR_mpc32 (private state) */
#undef x_VAR_mpc32
  0, /* VAR_mpc64 (private state) */
#undef x_VAR_mpc64
  0, /* VAR_mpc80 (private state) */
#undef x_VAR_mpc80
  false, /* frontend_set_flag_associative_math */
  false, /* frontend_set_flag_cx_limited_range */
  false, /* frontend_set_flag_finite_math_only */
  false, /* frontend_set_flag_errno_math */
  false, /* frontend_set_flag_reciprocal_math */
  false, /* frontend_set_flag_rounding_math */
  false, /* frontend_set_flag_signaling_nans */
  false, /* frontend_set_flag_signed_zeros */
  false, /* frontend_set_flag_trapping_math */
  false, /* frontend_set_flag_unsafe_math_optimizations */
};

struct gcc_options global_options;
struct gcc_options global_options_set;

const char * const lang_names[] =
{
  "Ada",
  "AdaSCIL",
  "AdaWhy",
  "C",
  "C++",
  "Fortran",
  "Go",
  "Java",
  "LTO",
  "ObjC",
  "ObjC++",
  0
};

const unsigned int cl_options_count = N_OPTS;

#if (1U << 11) > CL_MIN_OPTION_CLASS
  #error the number of languages exceeds the implementation limit
#endif
const unsigned int cl_lang_count = 11;

const struct cl_option cl_options[] =
{
  { "-###",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--CLASSPATH",
    0,
    0,
    0,
    NULL, NULL, OPT_fclasspath_, N_OPTS, 10, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--all-warnings",
    0,
    0,
    0,
    NULL, NULL, OPT_Wall, N_OPTS, 13, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--ansi",
    0,
    0,
    0,
    NULL, NULL, OPT_ansi, N_OPTS, 5, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--assemble",
    0,
    0,
    0,
    NULL, NULL, OPT_S, N_OPTS, 9, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--assert",
    0,
    "assertion missing after %qs",
    0,
    NULL, NULL, OPT_A, N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--assert=",
    0,
    "assertion missing after %qs",
    0,
    NULL, NULL, OPT_A, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--bootclasspath",
    0,
    0,
    0,
    NULL, NULL, OPT_fbootclasspath_, N_OPTS, 14, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--classpath",
    0,
    0,
    0,
    NULL, NULL, OPT_fclasspath_, N_OPTS, 10, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--comments",
    0,
    0,
    0,
    NULL, NULL, OPT_C, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--comments-in-macros",
    0,
    0,
    0,
    NULL, NULL, OPT_CC, N_OPTS, 19, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--compile",
    0,
    0,
    0,
    NULL, NULL, OPT_c, N_OPTS, 8, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--coverage",
    0,
    0,
    0,
    NULL, NULL, OPT_coverage, N_OPTS, 9, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--debug",
    0,
    0,
    0,
    NULL, NULL, OPT_g, N_OPTS, 6, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--define-macro",
    0,
    "macro name missing after %qs",
    0,
    NULL, NULL, OPT_D, N_OPTS, 13, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--define-macro=",
    0,
    "macro name missing after %qs",
    0,
    NULL, NULL, OPT_D, N_OPTS, 14, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--dependencies",
    0,
    0,
    0,
    NULL, NULL, OPT_M, N_OPTS, 13, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--dump",
    0,
    0,
    0,
    NULL, NULL, OPT_d, N_OPTS, 5, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--dump=",
    0,
    0,
    0,
    NULL, NULL, OPT_d, N_OPTS, 6, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--dumpbase",
    0,
    0,
    0,
    NULL, NULL, OPT_dumpbase, N_OPTS, 9, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--dumpdir",
    0,
    0,
    0,
    NULL, NULL, OPT_dumpdir, N_OPTS, 8, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--encoding",
    0,
    0,
    0,
    NULL, NULL, OPT_fencoding_, N_OPTS, 9, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--entry",
    0,
    0,
    0,
    NULL, NULL, OPT_e, N_OPTS, 6, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--entry=",
    0,
    0,
    0,
    NULL, NULL, OPT_e, N_OPTS, 7, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--extdirs",
    0,
    0,
    0,
    NULL, NULL, OPT_fextdirs_, N_OPTS, 8, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--extra-warnings",
    0,
    0,
    0,
    NULL, NULL, OPT_Wextra, N_OPTS, 15, -1,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--for-assembler",
    0,
    0,
    0,
    NULL, NULL, OPT_Xassembler, N_OPTS, 14, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--for-assembler=",
    0,
    0,
    0,
    NULL, NULL, OPT_Xassembler, N_OPTS, 15, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--for-linker",
    0,
    0,
    0,
    NULL, NULL, OPT_Xlinker, N_OPTS, 11, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--for-linker=",
    0,
    0,
    0,
    NULL, NULL, OPT_Xlinker, N_OPTS, 12, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--force-link",
    0,
    0,
    0,
    NULL, NULL, OPT_u, N_OPTS, 11, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--force-link=",
    0,
    0,
    0,
    NULL, NULL, OPT_u, N_OPTS, 12, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--help",
    "Display this information",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_help_flag), 0, CLVC_BOOLEAN, 0 },
  { "--help=",
    "--help=<class>	Display descriptions of a specific class of options.  <class> is one or more of optimizers, target, warnings, undocumented, params",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    -1, 0, CLVC_STRING, 0 },
  { "--imacros",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_imacros, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--imacros=",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_imacros, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_include, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-barrier",
    0,
    0,
    0,
    "-", NULL, OPT_I, N_OPTS, 16, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--include-directory",
    0,
    "missing path after %qs",
    0,
    NULL, NULL, OPT_I, N_OPTS, 18, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-directory-after",
    0,
    "missing path after %qs",
    0,
    NULL, NULL, OPT_idirafter, N_OPTS, 24, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-directory-after=",
    0,
    "missing path after %qs",
    0,
    NULL, NULL, OPT_idirafter, N_OPTS, 25, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-directory=",
    0,
    "missing path after %qs",
    0,
    NULL, NULL, OPT_I, N_OPTS, 19, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-prefix",
    0,
    0,
    0,
    NULL, NULL, OPT_iprefix, N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-prefix=",
    0,
    0,
    0,
    NULL, NULL, OPT_iprefix, N_OPTS, 16, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-with-prefix",
    0,
    0,
    0,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 20, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-with-prefix-after",
    0,
    0,
    0,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 26, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-with-prefix-after=",
    0,
    0,
    0,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 27, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-with-prefix-before",
    0,
    0,
    0,
    NULL, NULL, OPT_iwithprefixbefore, N_OPTS, 27, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-with-prefix-before=",
    0,
    0,
    0,
    NULL, NULL, OPT_iwithprefixbefore, N_OPTS, 28, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include-with-prefix=",
    0,
    0,
    0,
    NULL, NULL, OPT_iwithprefix, N_OPTS, 21, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--include=",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_include, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--language",
    0,
    0,
    0,
    NULL, NULL, OPT_x, N_OPTS, 9, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--language=",
    0,
    0,
    0,
    NULL, NULL, OPT_x, N_OPTS, 10, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--library-directory",
    0,
    0,
    0,
    NULL, NULL, OPT_L, N_OPTS, 18, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--library-directory=",
    0,
    0,
    0,
    NULL, NULL, OPT_L, N_OPTS, 19, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--no-canonical-prefixes",
    0,
    0,
    0,
    NULL, NULL, OPT_no_canonical_prefixes, N_OPTS, 22, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--no-integrated-cpp",
    0,
    0,
    0,
    NULL, NULL, OPT_no_integrated_cpp, N_OPTS, 18, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--no-line-commands",
    0,
    0,
    0,
    NULL, NULL, OPT_P, N_OPTS, 17, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--no-standard-includes",
    0,
    0,
    0,
    NULL, NULL, OPT_nostdinc, N_OPTS, 21, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--no-standard-libraries",
    0,
    0,
    0,
    NULL, NULL, OPT_nostdlib, N_OPTS, 22, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--no-sysroot-suffix",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_no_sysroot_suffix), 0, CLVC_BOOLEAN, 0 },
  { "--no-warnings",
    0,
    0,
    0,
    NULL, NULL, OPT_w, N_OPTS, 12, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--optimize",
    0,
    0,
    0,
    NULL, NULL, OPT_O, N_OPTS, 9, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--output",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_o, N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--output-class-directory",
    0,
    0,
    0,
    NULL, NULL, OPT_foutput_class_dir_, N_OPTS, 23, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--output-class-directory=",
    0,
    0,
    0,
    NULL, NULL, OPT_foutput_class_dir_, N_OPTS, 24, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--output-pch=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--output=",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_o, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--param",
    "--param <param>=<value>	Set parameter <param> to value.  See below for a complete list of parameters",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--param=",
    0,
    0,
    0,
    NULL, NULL, OPT__param, N_OPTS, 7, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--pass-exit-codes",
    0,
    0,
    0,
    NULL, NULL, OPT_pass_exit_codes, N_OPTS, 16, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--pedantic",
    0,
    0,
    0,
    NULL, NULL, OPT_Wpedantic, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--pedantic-errors",
    0,
    0,
    0,
    NULL, NULL, OPT_pedantic_errors, N_OPTS, 16, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--pie",
    0,
    0,
    0,
    NULL, NULL, OPT_pie, N_OPTS, 4, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--pipe",
    0,
    0,
    0,
    NULL, NULL, OPT_pipe, N_OPTS, 5, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--prefix",
    0,
    0,
    0,
    NULL, NULL, OPT_B, N_OPTS, 7, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--prefix=",
    0,
    0,
    0,
    NULL, NULL, OPT_B, N_OPTS, 8, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--preprocess",
    0,
    0,
    0,
    NULL, NULL, OPT_E, N_OPTS, 11, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-file-name",
    0,
    0,
    0,
    NULL, NULL, OPT_print_file_name_, N_OPTS, 16, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--print-file-name=",
    0,
    0,
    0,
    NULL, NULL, OPT_print_file_name_, N_OPTS, 17, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--print-libgcc-file-name",
    0,
    0,
    0,
    NULL, NULL, OPT_print_libgcc_file_name, N_OPTS, 23, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-missing-file-dependencies",
    0,
    0,
    0,
    NULL, NULL, OPT_MG, N_OPTS, 32, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-multi-directory",
    0,
    0,
    0,
    NULL, NULL, OPT_print_multi_directory, N_OPTS, 22, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-multi-lib",
    0,
    0,
    0,
    NULL, NULL, OPT_print_multi_lib, N_OPTS, 16, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-multi-os-directory",
    0,
    0,
    0,
    NULL, NULL, OPT_print_multi_os_directory, N_OPTS, 25, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-multiarch",
    0,
    0,
    0,
    NULL, NULL, OPT_print_multiarch, N_OPTS, 16, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-prog-name",
    0,
    0,
    0,
    NULL, NULL, OPT_print_prog_name_, N_OPTS, 16, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--print-prog-name=",
    0,
    0,
    0,
    NULL, NULL, OPT_print_prog_name_, N_OPTS, 17, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--print-search-dirs",
    0,
    0,
    0,
    NULL, NULL, OPT_print_search_dirs, N_OPTS, 18, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-sysroot",
    0,
    0,
    0,
    NULL, NULL, OPT_print_sysroot, N_OPTS, 14, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--print-sysroot-headers-suffix",
    0,
    0,
    0,
    NULL, NULL, OPT_print_sysroot_headers_suffix, N_OPTS, 29, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--profile",
    0,
    0,
    0,
    NULL, NULL, OPT_p, N_OPTS, 8, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--resource",
    0,
    0,
    0,
    NULL, NULL, OPT_fcompile_resource_, N_OPTS, 9, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--resource=",
    0,
    0,
    0,
    NULL, NULL, OPT_fcompile_resource_, N_OPTS, 10, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--save-temps",
    0,
    0,
    0,
    NULL, NULL, OPT_save_temps, N_OPTS, 11, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--shared",
    0,
    0,
    0,
    NULL, NULL, OPT_shared, N_OPTS, 7, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--specs",
    0,
    0,
    0,
    NULL, NULL, OPT_specs_, N_OPTS, 6, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--specs=",
    0,
    0,
    0,
    NULL, NULL, OPT_specs_, N_OPTS, 7, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--static",
    0,
    0,
    0,
    NULL, NULL, OPT_static, N_OPTS, 7, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--symbolic",
    0,
    0,
    0,
    NULL, NULL, OPT_symbolic, N_OPTS, 9, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--sysroot",
    0,
    0,
    0,
    NULL, NULL, OPT__sysroot_, N_OPTS, 8, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--sysroot=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--target-help",
    "Alias for --help=target",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--time",
    0,
    0,
    0,
    NULL, NULL, OPT_time, N_OPTS, 5, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--trace-includes",
    0,
    0,
    0,
    NULL, NULL, OPT_H, N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--traditional",
    0,
    0,
    0,
    NULL, NULL, OPT_traditional, N_OPTS, 12, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--traditional-cpp",
    0,
    0,
    0,
    NULL, NULL, OPT_traditional_cpp, N_OPTS, 16, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--trigraphs",
    0,
    0,
    0,
    NULL, NULL, OPT_trigraphs, N_OPTS, 10, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--undefine-macro",
    0,
    "macro name missing after %qs",
    0,
    NULL, NULL, OPT_U, N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--undefine-macro=",
    0,
    "macro name missing after %qs",
    0,
    NULL, NULL, OPT_U, N_OPTS, 16, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--user-dependencies",
    0,
    0,
    0,
    NULL, NULL, OPT_MM, N_OPTS, 18, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--verbose",
    0,
    0,
    0,
    NULL, NULL, OPT_v, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--version",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "--write-dependencies",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_MD, N_OPTS, 19, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "--write-user-dependencies",
    0,
    "missing filename after %qs",
    0,
    NULL, NULL, OPT_MMD, N_OPTS, 24, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-A",
    "-A<question>=<answer>	Assert the <answer> to <question>.  Putting '-' before <question> disables the <answer> to <question>",
    "assertion missing after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-B",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-C",
    "Do not discard comments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-CC",
    "Do not discard comments in macro expansions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-CLASSPATH",
    0,
    0,
    0,
    NULL, NULL, OPT_fclasspath_, N_OPTS, 9, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-D",
    "-D<macro>[=<val>]	Define a <macro> with <val> as its value.  If just <macro> is given, <val> is taken to be 1",
    "macro name missing after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-E",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_preprocess_only), 0, CLVC_BOOLEAN, 0 },
  { "-F",
    "-F <dir>	Add <dir> to the end of the main framework include path",
    "missing path after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-H",
    "Print the name of header files as they are used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-I",
    "-I <dir>	Add <dir> to the end of the main include path",
    "missing path after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_Go | CL_Java | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-J",
    "-J<directory>	Put MODULE files in 'directory'",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_Fortran | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-L",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_Go | CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-M",
    "Generate make dependencies",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-MD",
    "Generate make dependencies and compile",
    "missing filename after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-MD_",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, -1,
    CL_Java | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-MF",
    "-MF <file>	Write dependency output to the given file",
    "missing filename after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-MG",
    "Treat missing header files as generated files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-MM",
    "Like -M but ignore system header files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-MMD",
    "Like -MD but ignore system header files",
    "missing filename after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_SEPARATE,
    0, 0, 0, 0, 1 /* NoDriverArg */, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-MMD_",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, -1,
    CL_Java | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-MP",
    "Generate phony targets for all headers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-MQ",
    "-MQ <target>	Add a MAKE-quoted target",
    "missing makefile target after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-MT",
    "-MT <target>	Add an unquoted target",
    "missing makefile target after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-N",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-O",
    "-O<number>	Set optimization level to <number>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Ofast",
    "Optimize for speed disregarding exact standards compliance",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_O, 5, -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Og",
    "Optimize for debugging experience rather than speed or size",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_O, 2, -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Os",
    "Optimize for space rather than speed",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_O, 2, -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-P",
    "Do not generate #line directives",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Q",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Qn",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, 146,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Qy",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, 145,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-R",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-S",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-T",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Tbss",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_T, 4, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Tbss=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_T, 5, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Tdata",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_T, 5, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Tdata=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_T, 6, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Ttext",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_T, 5, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Ttext=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_T, 6, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-U",
    "-U<macro>	Undefine <macro>",
    "macro name missing after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-W",
    "This switch is deprecated; use -Wextra instead",
    0,
    0,
    NULL, NULL, OPT_Wextra, N_OPTS, 1, -1,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wa,",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 158,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Wabi",
    "Warn about things that will change when compiling with an ABI-compliant compiler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 159,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_abi), 0, CLVC_BOOLEAN, 0 },
  { "-Wabi-tag",
    "Warn if a subobject has an abi_tag attribute that the complete object type does not have",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 160,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_abi_tag), 0, CLVC_BOOLEAN, 0 },
  { "-Waddress",
    "Warn about suspicious uses of memory addresses",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 161,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_address), 0, CLVC_BOOLEAN, 0 },
  { "-Waggregate-return",
    "Warn about returning structures, unions or arrays",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 162,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_aggregate_return), 0, CLVC_BOOLEAN, 0 },
  { "-Waggressive-loop-optimizations",
    "Warn if a loop with constant number of iterations triggers undefined behavior",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 30, 163,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_aggressive_loop_optimizations), 0, CLVC_BOOLEAN, 0 },
  { "-Waliasing",
    "Warn about possible aliasing of dummy arguments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 164,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Walign-commons",
    "Warn about alignment of COMMON blocks",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 165,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wall",
    "Enable most warning messages",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 166,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_Go | CL_Java | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wall-deprecation",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 167,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wall-javadoc",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 168,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wampersand",
    "Warn about missing ampersand in continued character constants",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 169,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Warray-bounds",
    "Warn if an array is accessed out of bounds",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 170,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_array_bounds), 0, CLVC_BOOLEAN, 0 },
  { "-Warray-temporaries",
    "Warn about creation of array temporaries",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 171,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wassert-identifier",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 172,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wassign-intercept",
    "Warn whenever an Objective-C assignment is being intercepted by the garbage collector",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 173,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_assign_intercept), 0, CLVC_BOOLEAN, 0 },
  { "-Wattributes",
    "Warn about inappropriate attribute usage",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 174,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_attributes), 0, CLVC_BOOLEAN, 0 },
  { "-Wbad-function-cast",
    "Warn about casting functions to incompatible types",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 175,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_bad_function_cast), 0, CLVC_BOOLEAN, 0 },
  { "-Wboxing",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 176,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wbuiltin-macro-redefined",
    "Warn when a built-in preprocessor macro is undefined or redefined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 177,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wc++-compat",
    "Warn about C constructs that are not in the common subset of C and C++",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 178,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cxx_compat), 0, CLVC_BOOLEAN, 0 },
  { "-Wc++0x-compat",
    "Deprecated in favor of -Wc++11-compat",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 179,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cxx0x_compat), 0, CLVC_BOOLEAN, 0 },
  { "-Wc++11-compat",
    "Warn about C++ constructs whose meaning differs between ISO C++ 1998 and ISO C++ 2011",
    0,
    0,
    NULL, NULL, OPT_Wc__0x_compat, N_OPTS, 13, 180,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wc-binding-type",
    "Warn if the type of a variable might be not interoperable with C",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 181,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wcast-align",
    "Warn about pointer casts which increase alignment",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 182,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cast_align), 0, CLVC_BOOLEAN, 0 },
  { "-Wcast-qual",
    "Warn about casts which discard qualifiers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 183,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cast_qual), 0, CLVC_BOOLEAN, 0 },
  { "-Wchar-concat",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 184,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wchar-subscripts",
    "Warn about subscripts whose type is \"char\"",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 185,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_char_subscripts), 0, CLVC_BOOLEAN, 0 },
  { "-Wcharacter-truncation",
    "Warn about truncated character expressions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 186,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wclobbered",
    "Warn about variables that might be changed by \"longjmp\" or \"vfork\"",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 187,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_clobbered), 0, CLVC_BOOLEAN, 0 },
  { "-Wcomment",
    "Warn about possibly nested block comments, and C++ comments spanning more than one physical line",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 188,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wcomments",
    "Synonym for -Wcomment",
    0,
    0,
    NULL, NULL, OPT_Wcomment, N_OPTS, 9, 189,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wcompare-reals",
    "Warn about equality comparisons involving REAL or COMPLEX expressions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 190,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wcondition-assign",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 191,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wconditionally-supported",
    "Warn for conditionally-supported constructs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 192,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_conditionally_supported), 0, CLVC_BOOLEAN, 0 },
  { "-Wconstructor-name",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 193,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wconversion",
    "Warn for implicit type conversions that may change a value",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 194,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_conversion), 0, CLVC_BOOLEAN, 0 },
  { "-Wconversion-extra",
    "Warn about most implicit conversions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 195,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wconversion-null",
    "Warn for converting NULL from/to a non-pointer type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 196,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_conversion_null), 0, CLVC_BOOLEAN, 0 },
  { "-Wcoverage-mismatch",
    "Warn in case profiles in -fprofile-use do not match",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 197,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_coverage_mismatch), 0, CLVC_BOOLEAN, 0 },
  { "-Wcpp",
    "Warn when a #warning directive is encountered",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 198,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_cpp), 0, CLVC_BOOLEAN, 0 },
  { "-Wctor-dtor-privacy",
    "Warn when all constructors and destructors are private",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 199,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ctor_dtor_privacy), 0, CLVC_BOOLEAN, 0 },
  { "-Wdate-time",
    "Warn about __TIME__, __DATE__ and __TIMESTAMP__ usage",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 200,
    CL_Fortran | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_date_time), 0, CLVC_BOOLEAN, 0 },
  { "-Wdeclaration-after-statement",
    "Warn when a declaration is found after a statement",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, 201,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_declaration_after_statement), 0, CLVC_BOOLEAN, 0 },
  { "-Wdelete-incomplete",
    "Warn when deleting a pointer to incomplete type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 202,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_delete_incomplete), 0, CLVC_BOOLEAN, 0 },
  { "-Wdelete-non-virtual-dtor",
    "Warn about deleting polymorphic objects with non-virtual destructors",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 203,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_delnonvdtor), 0, CLVC_BOOLEAN, 0 },
  { "-Wdep-ann",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 204,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wdeprecated",
    "Warn if a deprecated compiler feature, class, method, or field is used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 205,
    CL_C | CL_CXX | CL_Java | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated), 0, CLVC_BOOLEAN, 0 },
  { "-Wdeprecated-declarations",
    "Warn about uses of __attribute__((deprecated)) declarations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 206,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_deprecated_decl), 0, CLVC_BOOLEAN, 0 },
  { "-Wdisabled-optimization",
    "Warn when an optimization pass is disabled",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 207,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_disabled_optimization), 0, CLVC_BOOLEAN, 0 },
  { "-Wdiscouraged",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 208,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wdiv-by-zero",
    "Warn about compile-time integer division by zero",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 209,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_div_by_zero), 0, CLVC_BOOLEAN, 0 },
  { "-Wdouble-promotion",
    "Warn about implicit conversions from \"float\" to \"double\"",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 210,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_double_promotion), 0, CLVC_BOOLEAN, 0 },
  { "-Weffc++",
    "Warn about violations of Effective C++ style rules",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 211,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ecpp), 0, CLVC_BOOLEAN, 0 },
  { "-Wempty-block",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 212,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wempty-body",
    "Warn about an empty body in an if or else statement",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 213,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_empty_body), 0, CLVC_BOOLEAN, 0 },
  { "-Wendif-labels",
    "Warn about stray tokens after #elif and #endif",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 214,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wenum-compare",
    "Warn about comparison of different enum types",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 215,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_enum_compare), 0, CLVC_BOOLEAN, 0 },
  { "-Wenum-identifier",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 216,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wenum-switch",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 217,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Werror",
    "Treat all warnings as errors",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 218,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warnings_are_errors), 0, CLVC_BOOLEAN, 0 },
  { "-Werror-implicit-function-declaration",
    "This switch is deprecated; use -Werror=implicit-function-declaration instead",
    0,
    0,
    "implicit-function-declaration", NULL, OPT_Werror_, N_OPTS, 36, -1,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Werror=",
    "Treat specified warning as error",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 220,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Wextra",
    "Print extra (possibly unwanted) warnings",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 221,
    CL_Fortran | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_extra_warnings), 0, CLVC_BOOLEAN, 0 },
  { "-Wextraneous-semicolon",
    "Warn if deprecated empty statements are found",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 222,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_extraneous_semicolon), 0, CLVC_BOOLEAN, 0 },
  { "-Wfallthrough",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 223,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wfatal-errors",
    "Exit on the first error occurred",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 224,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fatal_errors), 0, CLVC_BOOLEAN, 0 },
  { "-Wfield-hiding",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 225,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wfinal-bound",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 226,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wfinally",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 227,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wfloat-conversion",
    "Warn for implicit type conversions that cause loss of floating point precision",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 228,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_float_conversion), 0, CLVC_BOOLEAN, 0 },
  { "-Wfloat-equal",
    "Warn if testing floating point numbers for equality",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 229,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_float_equal), 0, CLVC_BOOLEAN, 0 },
  { "-Wforbidden",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 230,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wformat",
    "Warn about printf/scanf/strftime/strfmon format string anomalies",
    0,
    0,
    "1", "0", OPT_Wformat_, N_OPTS, 7, 231,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wformat-contains-nul",
    "Warn about format strings that contain NUL bytes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 232,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_contains_nul), 0, CLVC_BOOLEAN, 0 },
  { "-Wformat-extra-args",
    "Warn if passing too many arguments to a function for its format string",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 233,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_extra_args), 0, CLVC_BOOLEAN, 0 },
  { "-Wformat-nonliteral",
    "Warn about format strings that are not literals",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 234,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_nonliteral), 0, CLVC_BOOLEAN, 0 },
  { "-Wformat-security",
    "Warn about possible security problems with format functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 235,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_security), 0, CLVC_BOOLEAN, 0 },
  { "-Wformat-y2k",
    "Warn about strftime formats yielding 2-digit years",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 236,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_y2k), 0, CLVC_BOOLEAN, 0 },
  { "-Wformat-zero-length",
    "Warn about zero-length formats",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 237,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format_zero_length), 0, CLVC_BOOLEAN, 0 },
  { "-Wformat=",
    "Warn about printf/scanf/strftime/strfmon format string anomalies",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_format), 0, CLVC_BOOLEAN, 0 },
  { "-Wframe-larger-than=",
    "-Wframe-larger-than=<number>	Warn if a function's stack frame requires more than <number> bytes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wfree-nonheap-object",
    "Warn when attempting to free a non-heap object",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 240,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_free_nonheap_object), 0, CLVC_BOOLEAN, 0 },
  { "-Wfunction-elimination",
    "Warn about function call elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 241,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Whiding",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 242,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wignored-qualifiers",
    "Warn whenever type qualifiers are ignored.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 243,
    CL_C | CL_CXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_ignored_qualifiers), 0, CLVC_BOOLEAN, 0 },
  { "-Wimplicit",
    "Warn about implicit declarations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 244,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit), 0, CLVC_BOOLEAN, 0 },
  { "-Wimplicit-function-declaration",
    "Warn about implicit function declarations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 30, 245,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit_function_declaration), 0, CLVC_BOOLEAN, 0 },
  { "-Wimplicit-int",
    "Warn when a declaration does not specify a type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 246,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_implicit_int), 0, CLVC_BOOLEAN, 0 },
  { "-Wimplicit-interface",
    "Warn about calls with implicit interface",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 247,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wimplicit-procedure",
    "Warn about called procedures not explicitly declared",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 248,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wimport",
    0,
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 7, 249,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Windirect-static",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 250,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Winherited-variadic-ctor",
    "Warn about C++11 inheriting constructors when the base has a variadic constructor",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 251,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_inh_var_ctor), 0, CLVC_BOOLEAN, 0 },
  { "-Winit-self",
    "Warn about variables which are initialized to themselves",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 252,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_init_self), 0, CLVC_BOOLEAN, 0 },
  { "-Winline",
    "Warn when an inlined function cannot be inlined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 253,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_inline), 0, CLVC_BOOLEAN, 0 },
  { "-Wint-to-pointer-cast",
    "Warn when there is a cast to a pointer from an integer of a different size",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 254,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_int_to_pointer_cast), 0, CLVC_BOOLEAN, 0 },
  { "-Wintf-annotation",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 255,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wintf-non-inherited",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 256,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wintrinsic-shadow",
    "Warn if a user-procedure has the same name as an intrinsic",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 257,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wintrinsics-std",
    "Warn on intrinsics not part of the selected standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 258,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Winvalid-memory-model",
    "Warn when an atomic memory model parameter is known to be outside the valid range.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 259,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_invalid_memory_model), 0, CLVC_BOOLEAN, 0 },
  { "-Winvalid-offsetof",
    "Warn about invalid uses of the \"offsetof\" macro",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 260,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_invalid_offsetof), 0, CLVC_BOOLEAN, 0 },
  { "-Winvalid-pch",
    "Warn about PCH files that are found but not used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 261,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wjavadoc",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 262,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wjump-misses-init",
    "Warn when a jump misses a variable initialization",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 263,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_jump_misses_init), 0, CLVC_BOOLEAN, 0 },
  { "-Wl,",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 264,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Wlarger-than-",
    0,
    0,
    0,
    NULL, NULL, OPT_Wlarger_than_, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_UNDOCUMENTED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Wlarger-than=",
    "-Wlarger-than=<number>	Warn if an object is larger than <number> bytes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wline-truncation",
    "Warn about truncated source lines",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 267,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wliteral-suffix",
    "Warn when a string or character literal is followed by a ud-suffix which does not begin with an underscore.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 268,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wlocal-hiding",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 269,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wlogical-op",
    "Warn when a logical operator is suspiciously always evaluating to true or false",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 270,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_logical_op), 0, CLVC_BOOLEAN, 0 },
  { "-Wlong-long",
    "Do not warn about using \"long long\" when -pedantic",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 271,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_long_long), 0, CLVC_BOOLEAN, 0 },
  { "-Wmain",
    "Warn about suspicious declarations of \"main\"",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 272,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_main), 0, CLVC_BOOLEAN, 0 },
  { "-Wmasked-catch-block",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 273,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wmaybe-uninitialized",
    "Warn about maybe uninitialized automatic variables",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 274,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_maybe_uninitialized), 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-braces",
    "Warn about possibly missing braces around initializers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 275,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_braces), 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-declarations",
    "Warn about global functions without previous declarations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 276,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_declarations), 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-field-initializers",
    "Warn about missing fields in struct initializers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, 277,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_field_initializers), 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-format-attribute",
    0,
    0,
    0,
    NULL, NULL, OPT_Wsuggest_attribute_format, N_OPTS, 25, 278,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-include-dirs",
    "Warn about user-specified include directories that do not exist",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 279,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-noreturn",
    0,
    0,
    0,
    NULL, NULL, OPT_Wsuggest_attribute_noreturn, N_OPTS, 17, 280,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-parameter-type",
    "Warn about function parameters declared without a type specifier in K&R-style functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 281,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_parameter_type), 0, CLVC_BOOLEAN, 0 },
  { "-Wmissing-prototypes",
    "Warn about global functions without prototypes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 282,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_missing_prototypes), 0, CLVC_BOOLEAN, 0 },
  { "-Wmudflap",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 8, 283,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wmultichar",
    "Warn about use of multi-character character constants",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 284,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wnarrowing",
    "Warn about narrowing conversions within { } that are ill-formed in C++11",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 285,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_narrowing), 0, CLVC_BOOLEAN, 0 },
  { "-Wnested-externs",
    "Warn about \"extern\" declarations not at file scope",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 286,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nested_externs), 0, CLVC_BOOLEAN, 0 },
  { "-Wnls",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 287,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wno-effect-assign",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 288,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wnoexcept",
    "Warn when a noexcept expression evaluates to false even though the expression can't actually throw",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 289,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_noexcept), 0, CLVC_BOOLEAN, 0 },
  { "-Wnon-template-friend",
    "Warn when non-templatized friend functions are declared within a template",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 290,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nontemplate_friend), 0, CLVC_BOOLEAN, 0 },
  { "-Wnon-virtual-dtor",
    "Warn about non-virtual destructors",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 291,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nonvdtor), 0, CLVC_BOOLEAN, 0 },
  { "-Wnonnull",
    "Warn about NULL being passed to argument slots marked as requiring non-NULL",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 292,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_nonnull), 0, CLVC_BOOLEAN, 0 },
  { "-Wnormalized=",
    "-Wnormalized=<id|nfc|nfkc>	Warn about non-normalised Unicode strings",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 293,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Wnull",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 294,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wold-style-cast",
    "Warn if a C-style cast is used in a program",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 295,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_old_style_cast), 0, CLVC_BOOLEAN, 0 },
  { "-Wold-style-declaration",
    "Warn for obsolescent usage in a declaration",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 296,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_old_style_declaration), 0, CLVC_BOOLEAN, 0 },
  { "-Wold-style-definition",
    "Warn if an old-style parameter definition is used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 297,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_old_style_definition), 0, CLVC_BOOLEAN, 0 },
  { "-Wopenmp-simd",
    "Warn if a simd directive is overridden by the vectorizer cost model",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 298,
    CL_C | CL_CXX | CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_openmp_simd), 0, CLVC_BOOLEAN, 0 },
  { "-Wout-of-date",
    "Warn if .class files are out of date",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 299,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_newer), 0, CLVC_BOOLEAN, 0 },
  { "-Wover-ann",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 300,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Woverflow",
    "Warn about overflow in arithmetic expressions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 301,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_overflow), 0, CLVC_BOOLEAN, 0 },
  { "-Woverlength-strings",
    "Warn if a string is longer than the maximum portable length specified by the standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 302,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_overlength_strings), 0, CLVC_BOOLEAN, 0 },
  { "-Woverloaded-virtual",
    "Warn about overloaded virtual function names",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 303,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_overloaded_virtual), 0, CLVC_BOOLEAN, 0 },
  { "-Woverride-init",
    "Warn about overriding initializers without side effects",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 304,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_override_init), 0, CLVC_BOOLEAN, 0 },
  { "-Wp,",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 305,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Wpacked",
    "Warn when the packed attribute has no effect on struct layout",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 306,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_packed), 0, CLVC_BOOLEAN, 0 },
  { "-Wpacked-bitfield-compat",
    "Warn about packed bit-fields whose offset changed in GCC 4.4",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 307,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_packed_bitfield_compat), 0, CLVC_BOOLEAN, 0 },
  { "-Wpadded",
    "Warn when padding is required to align structure members",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 308,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_padded), 0, CLVC_BOOLEAN, 0 },
  { "-Wparam-assign",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 309,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wparentheses",
    "Warn about possibly missing parentheses",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 310,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_parentheses), 0, CLVC_BOOLEAN, 0 },
  { "-Wpedantic",
    "Issue warnings needed for strict compliance to the standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 311,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_pedantic), 0, CLVC_BOOLEAN, 0 },
  { "-Wpkg-default-method",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 312,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wpmf-conversions",
    "Warn when converting the type of pointers to member functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 313,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pmf2ptr), 0, CLVC_BOOLEAN, 0 },
  { "-Wpointer-arith",
    "Warn about function pointer arithmetic",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 314,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pointer_arith), 0, CLVC_BOOLEAN, 0 },
  { "-Wpointer-sign",
    "Warn when a pointer differs in signedness in an assignment",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 315,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pointer_sign), 0, CLVC_BOOLEAN, 0 },
  { "-Wpointer-to-int-cast",
    "Warn when a pointer is cast to an integer of a different size",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 316,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pointer_to_int_cast), 0, CLVC_BOOLEAN, 0 },
  { "-Wpragmas",
    "Warn about misuses of pragmas",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 317,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_pragmas), 0, CLVC_BOOLEAN, 0 },
  { "-Wproperty-assign-default",
    "Warn if a property for an Objective-C object has no assign semantics specified",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 318,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_property_assign_default), 0, CLVC_BOOLEAN, 0 },
  { "-Wprotocol",
    "Warn if inherited methods are unimplemented",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 319,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_protocol), 0, CLVC_BOOLEAN, 0 },
  { "-Wpsabi",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 320,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_psabi), 0, CLVC_BOOLEAN, 0 },
  { "-Wraw",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 321,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wreal-q-constant",
    "Warn about real-literal-constants with 'q' exponent-letter",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 322,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wrealloc-lhs",
    "Warn when a left-hand-side array variable is reallocated",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 323,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wrealloc-lhs-all",
    "Warn when a left-hand-side variable is reallocated",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 324,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wredundant-decls",
    "Warn about multiple declarations of the same object",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 325,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_redundant_decls), 0, CLVC_BOOLEAN, 0 },
  { "-Wredundant-modifiers",
    "Warn if modifiers are specified when not necessary",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 326,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_redundant), 0, CLVC_BOOLEAN, 0 },
  { "-Wreorder",
    "Warn when the compiler reorders code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 327,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_reorder), 0, CLVC_BOOLEAN, 0 },
  { "-Wreturn-local-addr",
    "Warn about returning a pointer/reference to a local or temporary variable.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 328,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_return_local_addr), 0, CLVC_BOOLEAN, 0 },
  { "-Wreturn-type",
    "Warn whenever a function's return type defaults to \"int\" (C), or about inconsistent return types (C++)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 329,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_return_type), 0, CLVC_BOOLEAN, 0 },
  { "-Wselector",
    "Warn if a selector has multiple methods",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 330,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_selector), 0, CLVC_BOOLEAN, 0 },
  { "-Wsequence-point",
    "Warn about possible violations of sequence point rules",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 331,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sequence_point), 0, CLVC_BOOLEAN, 0 },
  { "-Wserial",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 332,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wshadow",
    "Warn when one local variable shadows another",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 333,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_shadow), 0, CLVC_BOOLEAN, 0 },
  { "-Wsign-compare",
    "Warn about signed-unsigned comparisons",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 334,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sign_compare), 0, CLVC_BOOLEAN, 0 },
  { "-Wsign-conversion",
    "Warn for implicit type conversions between signed and unsigned integers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 335,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sign_conversion), 0, CLVC_BOOLEAN, 0 },
  { "-Wsign-promo",
    "Warn when overload promotes from unsigned to signed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 336,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sign_promo), 0, CLVC_BOOLEAN, 0 },
  { "-Wsizeof-pointer-memaccess",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 337,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sizeof_pointer_memaccess), 0, CLVC_BOOLEAN, 0 },
  { "-Wspecial-param-hiding",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 338,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wstack-protector",
    "Warn when not issuing stack smashing protection for some reason",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 339,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_stack_protect), 0, CLVC_BOOLEAN, 0 },
  { "-Wstack-usage=",
    "Warn if stack usage might be larger than specified amount",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_stack_usage), 0, CLVC_BOOLEAN, 0 },
  { "-Wstatic-access",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 341,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wstatic-receiver",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 342,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-aliasing",
    "Warn about code which might break strict aliasing rules",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 343,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-aliasing=",
    "Warn about code which might break strict aliasing rules",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_aliasing), 0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-null-sentinel",
    "Warn about uncasted NULL used as sentinel",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 345,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_null_sentinel), 0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-overflow",
    "Warn about optimizations that assume that signed overflow is undefined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 346,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-overflow=",
    "Warn about optimizations that assume that signed overflow is undefined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED | CL_WARNING,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_overflow), 0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-prototypes",
    "Warn about unprototyped function declarations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 348,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_prototypes), 0, CLVC_BOOLEAN, 0 },
  { "-Wstrict-selector-match",
    "Warn if type signatures of candidate methods do not match exactly",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 349,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_strict_selector_match), 0, CLVC_BOOLEAN, 0 },
  { "-Wsuggest-attribute=const",
    "Warn about functions which might be candidates for __attribute__((const))",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 350,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_const), 0, CLVC_BOOLEAN, 0 },
  { "-Wsuggest-attribute=format",
    "Warn about functions which might be candidates for format attributes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 351,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_format), 0, CLVC_BOOLEAN, 0 },
  { "-Wsuggest-attribute=noreturn",
    "Warn about functions which might be candidates for __attribute__((noreturn))",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, 352,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_noreturn), 0, CLVC_BOOLEAN, 0 },
  { "-Wsuggest-attribute=pure",
    "Warn about functions which might be candidates for __attribute__((pure))",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 353,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_suggest_attribute_pure), 0, CLVC_BOOLEAN, 0 },
  { "-Wsuppress",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 354,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wsurprising",
    "Warn about \"suspicious\" constructs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 355,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wswitch",
    "Warn about enumerated switches, with no default, missing a case",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 356,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch), 0, CLVC_BOOLEAN, 0 },
  { "-Wswitch-default",
    "Warn about enumerated switches missing a \"default:\" statement",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 357,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch_default), 0, CLVC_BOOLEAN, 0 },
  { "-Wswitch-enum",
    "Warn about all enumerated switches missing a specific case",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 358,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_switch_enum), 0, CLVC_BOOLEAN, 0 },
  { "-Wsync-nand",
    "Warn when __sync_fetch_and_nand and __sync_nand_and_fetch built-in functions are used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 359,
    CL_C | CL_CXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_sync_nand), 0, CLVC_BOOLEAN, 0 },
  { "-Wsynth",
    "Deprecated.  This switch has no effect",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 360,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_synth), 0, CLVC_BOOLEAN, 0 },
  { "-Wsynthetic-access",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 361,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wsystem-headers",
    "Do not suppress warnings from system headers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 362,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_system_headers), 0, CLVC_BOOLEAN, 0 },
  { "-Wtabs",
    "Permit nonconforming uses of the tab character",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 363,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wtarget-lifetime",
    "Warn if the pointer in a pointer assignment might outlive its target",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 364,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wtasks",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 365,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wtraditional",
    "Warn about features not present in traditional C",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 366,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_traditional), 0, CLVC_BOOLEAN, 0 },
  { "-Wtraditional-conversion",
    "Warn of prototypes causing type conversions different from what would happen in the absence of prototype",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 367,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_traditional_conversion), 0, CLVC_BOOLEAN, 0 },
  { "-Wtrampolines",
    "Warn whenever a trampoline is generated",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 368,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_trampolines), 0, CLVC_BOOLEAN, 0 },
  { "-Wtrigraphs",
    "Warn if trigraphs are encountered that might affect the meaning of the program",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 369,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wtype-hiding",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 370,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wtype-limits",
    "Warn if a comparison is always true or always false due to the limited range of the data type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 371,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_type_limits), 0, CLVC_BOOLEAN, 0 },
  { "-Wuncheck",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 372,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wundeclared-selector",
    "Warn about @selector()s without previously declared methods",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 373,
    CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_undeclared_selector), 0, CLVC_BOOLEAN, 0 },
  { "-Wundef",
    "Warn if an undefined macro is used in an #if directive",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 374,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunderflow",
    "Warn about underflow of numerical constant expressions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 375,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wuninitialized",
    "Warn about uninitialized automatic variables",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 376,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_uninitialized), 0, CLVC_BOOLEAN, 0 },
  { "-Wunknown-pragmas",
    "Warn about unrecognized pragmas",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 377,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unknown_pragmas), 0, CLVC_BOOLEAN, 0 },
  { "-Wunnecessary-else",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 378,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunqualified-field",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 379,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunreachable-code",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, 380,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunsafe-loop-optimizations",
    "Warn if the loop cannot be optimized due to nontrivial assumptions.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 381,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unsafe_loop_optimizations), 0, CLVC_BOOLEAN, 0 },
  { "-Wunsuffixed-float-constants",
    "Warn about unsuffixed float constants",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, 382,
    CL_C | CL_ObjC | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unsuffixed_float_constants), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused",
    "Enable all -Wunused- warnings",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 383,
    CL_C | CL_CXX | CL_Java | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-argument",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 384,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-but-set-parameter",
    "Warn when a function parameter is only set, otherwise unused",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 385,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_but_set_parameter), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-but-set-variable",
    "Warn when a variable is only set, otherwise unused",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 386,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_but_set_variable), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-dummy-argument",
    "Warn about unused dummy arguments.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 387,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-function",
    "Warn when a function is unused",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 388,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_function), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-import",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 389,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-label",
    "Warn when a label is unused",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 390,
    CL_Java | CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_label), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-local",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 391,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-local-typedefs",
    "Warn when typedefs locally defined in a function are not used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 392,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_local_typedefs), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-macros",
    "Warn about macros defined in the main file that are not used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 393,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_unused_macros), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-parameter",
    "Warn when a function parameter is unused",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 394,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_parameter), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-private",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 395,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-result",
    "Warn if a caller of a function, marked with attribute warn_unused_result, does not use its return value",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 396,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_result), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-thrown",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 397,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-value",
    "Warn when an expression value is unused",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 398,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_value), 0, CLVC_BOOLEAN, 0 },
  { "-Wunused-variable",
    "Warn when a variable is unused",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 399,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_unused_variable), 0, CLVC_BOOLEAN, 0 },
  { "-Wuseless-cast",
    "Warn about useless casts",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 400,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_useless_cast), 0, CLVC_BOOLEAN, 0 },
  { "-Wuseless-type-check",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 401,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wvarargs",
    "Warn about questionable usage of the macros used to retrieve variable arguments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 402,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_varargs), 0, CLVC_BOOLEAN, 0 },
  { "-Wvarargs-cast",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 403,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wvariadic-macros",
    "Warn about using variadic macros",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 404,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_cpp_warn_variadic_macros), 0, CLVC_BOOLEAN, 0 },
  { "-Wvector-operation-performance",
    "Warn when a vector operation is compiled outside the SIMD",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 29, 405,
    CL_COMMON | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_vector_operation_performance), 0, CLVC_BOOLEAN, 0 },
  { "-Wvirtual-move-assign",
    "Warn if a virtual base has a non-trivial move assignment operator",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 406,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_virtual_move_assign), 0, CLVC_BOOLEAN, 0 },
  { "-Wvla",
    "Warn if a variable length array is used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 407,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_vla), 0, CLVC_BOOLEAN, 0 },
  { "-Wvolatile-register-var",
    "Warn when a register variable is declared volatile",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 408,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_volatile_register_var), 0, CLVC_BOOLEAN, 0 },
  { "-Wwarning-token",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 409,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Wwrite-strings",
    "In C++, nonzero means warn about deprecated conversion from string literals to 'char *'.  In C, similar warning, except that the conversion is of course not deprecated by the ISO C standard.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 410,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_write_strings), 0, CLVC_BOOLEAN, 0 },
  { "-Wzero-as-null-pointer-constant",
    "Warn when a literal '0' is used as null pointer",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 30, 411,
    CL_CXX | CL_ObjCXX | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_warn_zero_as_null_pointer_constant), 0, CLVC_BOOLEAN, 0 },
  { "-Wzerotrip",
    "Warn about zero-trip DO loops",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 412,
    CL_Fortran | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-Xassembler",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Xlinker",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Xpreprocessor",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-Z",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ansi",
    "A synonym for -std=c89 (for C) or -std=c++98 (for C++)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-aux-info",
    "-aux-info <file>	Emit declaration information into <file>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_aux_info_file_name), 0, CLVC_STRING, 0 },
  { "-aux-info=",
    0,
    0,
    0,
    NULL, NULL, OPT_aux_info, N_OPTS, 9, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-auxbase",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_aux_base_name), 0, CLVC_STRING, 0 },
  { "-auxbase-strip",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-bootclasspath",
    0,
    0,
    0,
    NULL, NULL, OPT_fbootclasspath_, N_OPTS, 13, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-c",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-classpath",
    0,
    0,
    0,
    NULL, NULL, OPT_fclasspath_, N_OPTS, 9, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-coverage",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-cpp",
    "Enable preprocessing",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 1193,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-cpp=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1193,
    CL_Fortran | CL_JOINED | CL_UNDOCUMENTED | CL_NO_DWARF_RECORD,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-d",
    "-d<letters>	Enable dumps from specific passes of the compiler",
    0,
    0,
    NULL, NULL, OPT_foutput_class_dir_, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Java | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_JOINED | CL_SEPARATE,
    0, 0, 1 /* SeparateAlias */, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-dumpbase",
    "-dumpbase <file>	Set the file basename to be used for dumps",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_d, 8, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dump_base_name), 0, CLVC_STRING, 0 },
  { "-dumpdir",
    "-dumpdir <dir>	Set the directory name to be used for dumps",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_d, 7, -1,
    CL_COMMON | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dump_dir_name), 0, CLVC_STRING, 0 },
  { "-dumpmachine",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_d, 11, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-dumpspecs",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_d, 9, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-dumpversion",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_d, 11, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-e",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-encoding",
    0,
    0,
    0,
    NULL, NULL, OPT_fencoding_, OPT_e, 8, -1,
    CL_Java | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-export-dynamic",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_e, 14, -1,
    CL_DRIVER | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-extdirs",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_e, 7, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fCLASSPATH=",
    "--CLASSPATH	Deprecated; use --classpath instead",
    0,
    0,
    NULL, NULL, OPT_fclasspath_, N_OPTS, 11, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fPIC",
    "Generate position-independent code if possible (large mode)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 440,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_pic), 0, CLVC_EQUAL, 2 },
  { "-fPIE",
    "Generate position-independent code for executables if possible (large mode)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 789,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_pie), 0, CLVC_EQUAL, 2 },
  { "-fRTS=",
    "Select the runtime",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fabi-version=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_abi_version), 0, CLVC_BOOLEAN, 0 },
  { "-faccess-control",
    "Enforce class member access control semantics",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 443,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_access_control), 0, CLVC_BOOLEAN, 0 },
  { "-fada-spec-parent=",
    "-fada-spec-parent=unit  Dump Ada specs as child units of given parent",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ada_specs_parent), 0, CLVC_STRING, 0 },
  { "-faggressive-function-elimination",
    "Eliminate multiple function invokations also for impure functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 32, 445,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-faggressive-loop-optimizations",
    "Aggressively optimize loops using language constraints",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 30, 446,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_aggressive_loop_optimizations), 0, CLVC_BOOLEAN, 0 },
  { "-falign-commons",
    "Enable alignment of COMMON blocks",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 447,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-falign-functions",
    "Align the start of functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 448,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_align_functions), 0, CLVC_EQUAL, 0 },
  { "-falign-functions=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_align_functions), 0, CLVC_BOOLEAN, 0 },
  { "-falign-jumps",
    "Align labels which are only reached by jumping",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 450,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_align_jumps), 0, CLVC_EQUAL, 0 },
  { "-falign-jumps=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_align_jumps), 0, CLVC_BOOLEAN, 0 },
  { "-falign-labels",
    "Align all labels",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 452,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_align_labels), 0, CLVC_EQUAL, 0 },
  { "-falign-labels=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_align_labels), 0, CLVC_BOOLEAN, 0 },
  { "-falign-loops",
    "Align the start of loops",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 454,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_align_loops), 0, CLVC_EQUAL, 0 },
  { "-falign-loops=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_align_loops), 0, CLVC_BOOLEAN, 0 },
  { "-fall-intrinsics",
    "All intrinsics procedures are available regardless of selected standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fall-virtual",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 12, 457,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fallow-leading-underscore",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 458,
    CL_Fortran | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fallow-parameterless-variadic-functions",
    "Allow variadic functions without named parameter",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 39, 459,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_allow_parameterless_variadic_functions), 0, CLVC_BOOLEAN, 0 },
  { "-falt-external-templates",
    "No longer supported",
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 23, 460,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fargument-alias",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, 461,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fargument-noalias",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, 462,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fargument-noalias-anything",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 26, 463,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fargument-noalias-global",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 24, 464,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fasm",
    "Recognize the \"asm\" keyword",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 465,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_asm), 0, CLVC_EQUAL, 0 },
  { "-fassert",
    "Permit the use of the assert keyword",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 466,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_assert), 0, CLVC_BOOLEAN, 0 },
  { "-fassociative-math",
    "Allow optimization for floating-point arithmetic which may change the result of the operation due to rounding.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 467,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_associative_math), 0, CLVC_BOOLEAN, 0 },
  { "-fassume-compiled",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 468,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fassume-compiled=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 469,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fasynchronous-unwind-tables",
    "Generate unwind tables that are exact at each instruction boundary",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, 470,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_asynchronous_unwind_tables), 0, CLVC_BOOLEAN, 0 },
  { "-fauto-inc-dec",
    "Generate auto-inc/dec instructions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 471,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_auto_inc_dec), 0, CLVC_BOOLEAN, 0 },
  { "-fautomatic",
    "Do not treat local variables and COMMON blocks as if they were named in SAVE statements",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 472,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-faux-classpath",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_Java | CL_SEPARATE | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fbackslash",
    "Specify that backslash in string introduces an escape character",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 474,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fbacktrace",
    "Produce a backtrace when a runtime error is encountered",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 475,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fblas-matmul-limit=",
    "-fblas-matmul-limit=<n>	Size of the smallest matrix for which matmul will use BLAS",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fbootclasspath=",
    "--bootclasspath=<path>	Replace system path",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fbootstrap-classes",
    "Generated should be loaded by bootstrap loader",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 478,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_bootstrap_classes), 0, CLVC_BOOLEAN, 0 },
  { "-fbounds-check",
    "Generate code to check bounds before indexing arrays",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 479,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_bounds_check), 0, CLVC_BOOLEAN, 0 },
  { "-fbranch-count-reg",
    "Replace add, compare, branch with branch on count register",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 480,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_branch_on_count_reg), 0, CLVC_BOOLEAN, 0 },
  { "-fbranch-probabilities",
    "Use profiling information for branch probabilities",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 481,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_branch_probabilities), 0, CLVC_BOOLEAN, 0 },
  { "-fbranch-target-load-optimize",
    "Perform branch target load optimization before prologue / epilogue threading",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, 482,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_branch_target_load_optimize), 0, CLVC_BOOLEAN, 0 },
  { "-fbranch-target-load-optimize2",
    "Perform branch target load optimization after prologue / epilogue threading",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 29, 483,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_branch_target_load_optimize2), 0, CLVC_BOOLEAN, 0 },
  { "-fbtr-bb-exclusive",
    "Restrict target load migration not to re-use registers in any basic block",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 484,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_btr_bb_exclusive), 0, CLVC_BOOLEAN, 0 },
  { "-fbuilding-libgcc",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 485,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_building_libgcc), 0, CLVC_BOOLEAN, 0 },
  { "-fbuiltin",
    "Recognize built-in functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 486,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_builtin), 0, CLVC_EQUAL, 0 },
  { "-fbuiltin-",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 487,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fcall-saved-",
    "-fcall-saved-<register>	Mark <register> as being preserved across functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fcall-used-",
    "-fcall-used-<register>	Mark <register> as being corrupted by function calls",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fcaller-saves",
    "Save registers around function calls",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 490,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_caller_saves), 0, CLVC_BOOLEAN, 0 },
  { "-fcanonical-system-headers",
    "Where shorter, use canonicalized paths to systems headers.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 491,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fcheck-array-temporaries",
    "Produce a warning at runtime if a array temporary has been created for a procedure argument",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 492,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fcheck-data-deps",
    "Compare the results of several data dependence analyzers.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 493,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_check_data_deps), 0, CLVC_BOOLEAN, 0 },
  { "-fcheck-new",
    "Check the return value of new in C++",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 494,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_check_new), 0, CLVC_BOOLEAN, 0 },
  { "-fcheck-references",
    "Generate checks for references to NULL",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 495,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_check_references), 0, CLVC_BOOLEAN, 0 },
  { "-fcheck=",
    "-fcheck=[...]	Specify which runtime checks are to be performed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fcilkplus",
    "Enable Cilk Plus",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 497,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_cilkplus), 0, CLVC_BOOLEAN, 0 },
  { "-fclasspath=",
    "--classpath=<path>	Set class path",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fcoarray=",
    "-fcoarray=[...]	Specify which coarray parallelization should be used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fcombine-stack-adjustments",
    "Looks for opportunities to reduce stack adjustments and stack references.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 500,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_combine_stack_adjustments), 0, CLVC_BOOLEAN, 0 },
  { "-fcommon",
    "Do not put uninitialized globals in the common section",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 501,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_no_common), 0, CLVC_EQUAL, 0 },
  { "-fcompare-debug",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 502,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fcompare-debug-second",
    "Run only the second compilation of -fcompare-debug",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_compare_debug), 0, CLVC_BOOLEAN, 0 },
  { "-fcompare-debug=",
    "-fcompare-debug[=<opts>]	Compile with and without e.g. -gtoggle, and compare the final-insns dump",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_compare_debug_opt), 0, CLVC_STRING, 0 },
  { "-fcompare-elim",
    "Perform comparison elimination after register allocation has finished",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 505,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_compare_elim_after_reload), 0, CLVC_BOOLEAN, 0 },
  { "-fcompile-resource=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fcond-mismatch",
    "Allow the arguments of the '?' operator to have different types",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 507,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fconserve-space",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 508,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_conserve_space), 0, CLVC_BOOLEAN, 0 },
  { "-fconserve-stack",
    "Do not perform optimizations increasing noticeably stack usage",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 509,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_conserve_stack), 0, CLVC_BOOLEAN, 0 },
  { "-fconstant-string-class=",
    "-fconst-string-class=<name>	Use class <name> for constant strings",
    "no class name specified with %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 510,
    CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fconstexpr-depth=",
    "-fconstexpr-depth=<number>	Specify maximum constexpr recursion depth",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_max_constexpr_depth), 0, CLVC_BOOLEAN, 0 },
  { "-fconvert=big-endian",
    "Use big-endian format for unformatted files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fconvert=little-endian",
    "Use little-endian format for unformatted files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fconvert=native",
    "Use native format for unformatted files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fconvert=swap",
    "Swap endianness for unformatted files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fcprop-registers",
    "Perform a register copy-propagation optimization pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 516,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_cprop_registers), 0, CLVC_BOOLEAN, 0 },
  { "-fcray-pointer",
    "Use the Cray Pointer extension",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 517,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fcrossjumping",
    "Perform cross-jumping optimization",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 518,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_crossjumping), 0, CLVC_BOOLEAN, 0 },
  { "-fcse-follow-jumps",
    "When running CSE, follow jumps to their targets",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 519,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_cse_follow_jumps), 0, CLVC_BOOLEAN, 0 },
  { "-fcse-skip-blocks",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 16, 520,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fcx-fortran-rules",
    "Complex multiplication and division follow Fortran rules",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 521,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_cx_fortran_rules), 0, CLVC_BOOLEAN, 0 },
  { "-fcx-limited-range",
    "Omit range reduction step when performing complex division",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 522,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_cx_limited_range), 0, CLVC_BOOLEAN, 0 },
  { "-fd-lines-as-code",
    "Ignore 'D' in column one in fixed form",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fd-lines-as-comments",
    "Treat lines with 'D' in column one as comments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdata-sections",
    "Place data items into their own section",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 525,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_data_sections), 0, CLVC_BOOLEAN, 0 },
  { "-fdbg-cnt-list",
    "List all available debugging counters with their limits and counts.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 526,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fdbg-cnt=",
    "-fdbg-cnt=<counter>:<limit>[,<counter>:<limit>,...]	Set the debug counter limit.   ",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fdce",
    "Use the RTL dead code elimination pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 528,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dce), 0, CLVC_BOOLEAN, 0 },
  { "-fdebug-cpp",
    "Emit debug annotations during preprocessing",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 529,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdebug-prefix-map=",
    "Map one directory name to another in debug information",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fdebug-types-section",
    "Output .debug_types section when using DWARF v4 debuginfo.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 531,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_debug_types_section), 0, CLVC_BOOLEAN, 0 },
  { "-fdeclone-ctor-dtor",
    "Factor complex constructors and destructors to favor space over speed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 532,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_declone_ctor_dtor), 0, CLVC_BOOLEAN, 0 },
  { "-fdeduce-init-list",
    "-fdeduce-init-list	enable deduction of std::initializer_list for a template type parameter from a brace-enclosed initializer-list",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 533,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_deduce_init_list), 0, CLVC_BOOLEAN, 0 },
  { "-fdefault-double-8",
    "Set the default double precision kind to an 8 byte wide type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 534,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdefault-inline",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, 535,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdefault-integer-8",
    "Set the default integer kind to an 8 byte wide type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 536,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdefault-real-8",
    "Set the default real kind to an 8 byte wide type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 537,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdefer-pop",
    "Defer popping functions args from stack until later",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 538,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_defer_pop), 0, CLVC_BOOLEAN, 0 },
  { "-fdelayed-branch",
    "Attempt to fill delay slots of branch instructions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 539,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_delayed_branch), 0, CLVC_BOOLEAN, 0 },
  { "-fdelete-dead-exceptions",
    "Delete dead instructions that may throw exceptions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 540,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_delete_dead_exceptions), 0, CLVC_BOOLEAN, 0 },
  { "-fdelete-null-pointer-checks",
    "Delete useless null pointer checks",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, 541,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_delete_null_pointer_checks), 0, CLVC_BOOLEAN, 0 },
  { "-fdevirtualize",
    "Try to convert virtual calls to direct ones.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 542,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_devirtualize), 0, CLVC_BOOLEAN, 0 },
  { "-fdevirtualize-speculatively",
    "Perform speculative devirtualization",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, 543,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_devirtualize_speculatively), 0, CLVC_BOOLEAN, 0 },
  { "-fdiagnostics-color",
    0,
    0,
    0,
    "always", "never", OPT_fdiagnostics_color_, N_OPTS, 18, 544,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdiagnostics-color=",
    "-fdiagnostics-color=[never|always|auto]	Colorize diagnostics",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_color), 3, CLVC_ENUM, 0 },
  { "-fdiagnostics-show-caret",
    "Show the source line with a caret indicating the column",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 546,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_caret), 0, CLVC_BOOLEAN, 0 },
  { "-fdiagnostics-show-location=",
    "-fdiagnostics-show-location=[once|every-line]	How often to emit source location at the beginning of line-wrapped diagnostics",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 4, CLVC_ENUM, 0 },
  { "-fdiagnostics-show-option",
    "Amend appropriate diagnostic messages with the command line option that controls them",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 548,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_diagnostics_show_option), 0, CLVC_BOOLEAN, 0 },
  { "-fdirectives-only",
    "Preprocess directives only.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 549,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdisable-",
    "-fdisable-[tree|rtl|ipa]-<pass>=range1+range2 disables an optimization pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fdisable-assertions",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdisable_, 19, 551,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdisable-assertions=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdisable_, 20, 552,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fdollar-ok",
    "Allow dollar signs in entity names",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 553,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdollars-in-identifiers",
    "Permit '$' as an identifier character",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 554,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdse",
    "Use the RTL dead store elimination pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 555,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dse), 0, CLVC_BOOLEAN, 0 },
  { "-fdump-",
    "-fdump-<type>	Dump various compiler internals to a file",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fdump-ada-spec",
    "Write all declarations as Ada code transitively",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 14, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_ada_spec), 0, CLVC_BOOLEAN, 0 },
  { "-fdump-ada-spec-slim",
    "Write all declarations as Ada code for the given file only",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 19, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_ada_spec_slim), 0, CLVC_BOOLEAN, 0 },
  { "-fdump-core",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, OPT_fdump_, 10, 559,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdump-final-insns",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 17, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdump-final-insns=",
    "-fdump-final-insns=filename	Dump to filename the insns at the end of translation",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 18, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_final_insns), 0, CLVC_STRING, 0 },
  { "-fdump-fortran-optimized",
    "Display the code tree after front end optimization",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 23, 562,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdump-fortran-original",
    "Display the code tree after parsing",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 22, 563,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdump-go-spec=",
    "-fdump-go-spec=filename	Write all declarations to file as Go code",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 14, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_go_spec), 0, CLVC_STRING, 0 },
  { "-fdump-noaddr",
    "Suppress output of addresses in debugging dumps",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 12, 565,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_dump_noaddr), 0, CLVC_BOOLEAN, 0 },
  { "-fdump-parse-tree",
    "Display the code tree after parsing; deprecated option",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 16, 566,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fdump-passes",
    "Dump optimization passes",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 12, 567,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dump_passes), 0, CLVC_BOOLEAN, 0 },
  { "-fdump-unnumbered",
    "Suppress output of instruction numbers, line number notes and addresses in debugging dumps",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 16, 568,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_dump_unnumbered), 0, CLVC_BOOLEAN, 0 },
  { "-fdump-unnumbered-links",
    "Suppress output of previous and next insn numbers in debugging dumps",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fdump_, 22, 569,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_dump_unnumbered_links), 0, CLVC_BOOLEAN, 0 },
  { "-fdwarf2-cfi-asm",
    "Enable CFI tables via GAS assembler directives.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 570,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_dwarf2_cfi_asm), 0, CLVC_BOOLEAN, 0 },
  { "-fearly-inlining",
    "Perform early inlining",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 571,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_early_inlining), 0, CLVC_BOOLEAN, 0 },
  { "-felide-constructors",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 572,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_elide_constructors), 0, CLVC_BOOLEAN, 0 },
  { "-feliminate-dwarf2-dups",
    "Perform DWARF2 duplicate elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 573,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_eliminate_dwarf2_dups), 0, CLVC_BOOLEAN, 0 },
  { "-feliminate-unused-debug-symbols",
    "Perform unused type elimination in debug info",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 31, 574,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_debug_only_used_symbols), 0, CLVC_BOOLEAN, 0 },
  { "-feliminate-unused-debug-types",
    "Perform unused type elimination in debug info",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 29, 575,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_eliminate_unused_debug_types), 0, CLVC_BOOLEAN, 0 },
  { "-femit-class-debug-always",
    "Do not suppress C++ class debug information.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 576,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_emit_class_debug_always), 0, CLVC_BOOLEAN, 0 },
  { "-femit-class-file",
    "Output a class file",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 577,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_emit_class_files), 0, CLVC_BOOLEAN, 0 },
  { "-femit-class-files",
    "Alias for -femit-class-file",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 578,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_emit_class_files), 0, CLVC_BOOLEAN, 0 },
  { "-femit-struct-debug-baseonly",
    "-femit-struct-debug-baseonly	Aggressive reduced debug info for structs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, 579,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-femit-struct-debug-detailed=",
    "-femit-struct-debug-detailed=<spec-list>	Detailed reduced debug info for structs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, 580,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-femit-struct-debug-reduced",
    "-femit-struct-debug-reduced	Conservative reduced debug info for structs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 581,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fenable-",
    "-fenable-[tree|rtl|ipa]-<pass>=range1+range2 enables an optimization pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fenable-assertions",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fenable_, 18, 583,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fenable-assertions=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_fenable_, 19, 584,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fencoding=",
    "--encoding=<encoding>	Choose input encoding (defaults from your locale)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fenforce-eh-specs",
    "Generate code to check exception specifications",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 586,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_enforce_eh_specs), 0, CLVC_BOOLEAN, 0 },
  { "-fenum-int-equiv",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, 587,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fexceptions",
    "Enable exception handling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 588,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_exceptions), 0, CLVC_BOOLEAN, 0 },
  { "-fexcess-precision=",
    "-fexcess-precision=[fast|standard]	Specify handling of excess floating-point precision",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_excess_precision_cmdline), 5, CLVC_ENUM, 0 },
  { "-fexec-charset=",
    "-fexec-charset=<cset>	Convert all strings and character constants to character set <cset>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fexpensive-optimizations",
    "Perform a number of minor, expensive optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 591,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_expensive_optimizations), 0, CLVC_BOOLEAN, 0 },
  { "-fext-numeric-literals",
    "Interpret imaginary, fixed-point, or other gnu number suffix as the corresponding number literal rather than a user-defined number literal.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 592,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fextdirs=",
    "--extdirs=<path>	Set the extension directory path",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fextended-identifiers",
    "Permit universal character names (\\u and \\U) in identifiers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 594,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fextern-tls-init",
    "Support dynamic initialization of thread-local variables in a different translation unit",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 595,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_extern_tls_init), 0, CLVC_BOOLEAN, 0 },
  { "-fexternal-blas",
    "Specify that an external BLAS library should be used for matmul calls on large-size arrays",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 596,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fexternal-templates",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 19, 597,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ff2c",
    "Use f2c calling convention",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 598,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffast-math",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 599,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffat-lto-objects",
    "Output lto objects containing both the intermediate language and binary output.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 600,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fat_lto_objects), 0, CLVC_BOOLEAN, 0 },
  { "-ffilelist-file",
    "Input file is a file with a list of filenames to compile",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 601,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_filelist_file), 0, CLVC_BOOLEAN, 0 },
  { "-ffinite-math-only",
    "Assume no NaNs or infinities are generated",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 602,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_finite_math_only), 0, CLVC_BOOLEAN, 0 },
  { "-ffixed-",
    "-ffixed-<register>	Mark <register> as being unavailable to the compiler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-ffixed-form",
    "Assume that the source file is fixed form",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_ffixed_, 11, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffixed-line-length-",
    "-ffixed-line-length-<n>	Use n as character line width in fixed mode",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_ffixed_, 19, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffixed-line-length-none",
    "Allow arbitrary character line width in fixed mode",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_ffixed_line_length_, 23, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffloat-store",
    "Don't allocate floats and doubles in extended-precision registers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 607,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_float_store), 0, CLVC_BOOLEAN, 0 },
  { "-ffor-scope",
    "Scope of for-init-statement variables is local to the loop",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 608,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_new_for_scope), 0, CLVC_BOOLEAN, 0 },
  { "-fforce-addr",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 11, 609,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fforce-classes-archive-check",
    "Always check for non gcj generated classes archives",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, 610,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_force_classes_archive_check), 0, CLVC_BOOLEAN, 0 },
  { "-fforward-propagate",
    "Perform a forward propagation pass on RTL",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 611,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_forward_propagate), 0, CLVC_BOOLEAN, 0 },
  { "-ffp-contract=",
    "-ffp-contract=[off|on|fast] Perform floating-point expression contraction.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_fp_contract_mode), 6, CLVC_ENUM, 0 },
  { "-ffpe-summary=",
    "-ffpe-summary=[...]	Print summary of floating point exceptions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-ffpe-trap=",
    "-ffpe-trap=[...]	Stop on following floating point exceptions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-ffree-form",
    "Assume that the source file is free form",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffree-line-length-",
    "-ffree-line-length-<n>	Use n as character line width in free mode",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffree-line-length-none",
    "Allow arbitrary character line width in free mode",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_ffree_line_length_, 22, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffreestanding",
    "Do not assume that standard C libraries and \"main\" exist",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 618,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffriend-injection",
    "Inject friend functions into enclosing namespace",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 619,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_friend_injection), 0, CLVC_BOOLEAN, 0 },
  { "-ffrontend-optimize",
    "Enable front end optimization",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 620,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ffunction-cse",
    "Allow function addresses to be held in registers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 621,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_no_function_cse), 0, CLVC_EQUAL, 0 },
  { "-ffunction-sections",
    "Place each function into its own section",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 622,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_function_sections), 0, CLVC_BOOLEAN, 0 },
  { "-fgcse",
    "Perform global common subexpression elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 623,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_gcse), 0, CLVC_BOOLEAN, 0 },
  { "-fgcse-after-reload",
    "Perform global common subexpression elimination after register allocation has finished",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 624,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_gcse_after_reload), 0, CLVC_BOOLEAN, 0 },
  { "-fgcse-las",
    "Perform redundant load after store elimination in global common subexpression elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 625,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_gcse_las), 0, CLVC_BOOLEAN, 0 },
  { "-fgcse-lm",
    "Perform enhanced load motion during global common subexpression elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 626,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_gcse_lm), 0, CLVC_BOOLEAN, 0 },
  { "-fgcse-sm",
    "Perform store motion after global common subexpression elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 627,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_gcse_sm), 0, CLVC_BOOLEAN, 0 },
  { "-fgnu-keywords",
    "Recognize GNU-defined keywords",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 628,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_gnu_keywords), 0, CLVC_EQUAL, 0 },
  { "-fgnu-runtime",
    "Generate code for GNU runtime environment",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_next_runtime), 0, CLVC_EQUAL, 0 },
  { "-fgnu-tm",
    "Enable support for GNU transactional memory",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 630,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tm), 0, CLVC_BOOLEAN, 0 },
  { "-fgnu-unique",
    "Use STB_GNU_UNIQUE if supported by the assembler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 631,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_gnu_unique), 0, CLVC_BOOLEAN, 0 },
  { "-fgnu89-inline",
    "Use traditional GNU semantics for inline functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 632,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gnu89_inline), 0, CLVC_BOOLEAN, 0 },
  { "-fgo-check-divide-overflow",
    "Add explicit checks for division overflow in INT_MIN / -1",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 633,
    CL_Go,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_check_divide_overflow), 0, CLVC_BOOLEAN, 0 },
  { "-fgo-check-divide-zero",
    "Add explicit checks for division by zero",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 634,
    CL_Go,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_check_divide_zero), 0, CLVC_BOOLEAN, 0 },
  { "-fgo-dump-",
    "-fgo-dump-<type>	Dump Go frontend internal information",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fgo-optimize-",
    "-fgo-optimize-<type>	Turn on optimization passes in the frontend",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fgo-pkgpath=",
    "-fgo-pkgpath=<string>	Set Go package path",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fgo-prefix=",
    "-fgo-prefix=<string>	Set package-specific prefix for exported Go names",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fgo-relative-import-path=",
    "-fgo-relative-import-path=<path> Treat a relative import as relative to path",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, -1,
    CL_Go | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fgraphite",
    "Enable in and out of Graphite representation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 640,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_graphite), 0, CLVC_BOOLEAN, 0 },
  { "-fgraphite-identity",
    "Enable Graphite Identity transformation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 641,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_graphite_identity), 0, CLVC_BOOLEAN, 0 },
  { "-fguess-branch-probability",
    "Enable guessing of branch probabilities",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 642,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_guess_branch_prob), 0, CLVC_BOOLEAN, 0 },
  { "-fguiding-decls",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 14, 643,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fhandle-exceptions",
    0,
    0,
    "-fhandle-exceptions has been renamed -fexceptions (and is now on by default)",
    NULL, NULL, OPT_fexceptions, N_OPTS, 18, 644,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fhash-synchronization",
    "Assume the runtime uses a hash table to map an object to its synchronization structure",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 645,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_hash_synchronization), 0, CLVC_BOOLEAN, 0 },
  { "-fhelp",
    0,
    0,
    0,
    NULL, NULL, OPT__help, N_OPTS, 5, 646,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fhelp=",
    0,
    0,
    0,
    NULL, NULL, OPT__help_, N_OPTS, 6, 647,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fhoist-adjacent-loads",
    "Enable hoisting adjacent loads to encourage generating conditional move instructions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 648,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_hoist_adjacent_loads), 0, CLVC_BOOLEAN, 0 },
  { "-fhonor-std",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 10, 649,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fhosted",
    "Assume normal C execution environment",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 650,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fhuge-objects",
    "No longer supported",
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 13, 651,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fident",
    "Process #ident directives",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 652,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_no_ident), 0, CLVC_EQUAL, 0 },
  { "-fif-conversion",
    "Perform conversion of conditional jumps to branchless equivalents",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 653,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_if_conversion), 0, CLVC_BOOLEAN, 0 },
  { "-fif-conversion2",
    "Perform conversion of conditional jumps to conditional execution",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 654,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_if_conversion2), 0, CLVC_BOOLEAN, 0 },
  { "-fimplement-inlines",
    "Export functions even if they can be inlined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 655,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_implement_inlines), 0, CLVC_BOOLEAN, 0 },
  { "-fimplicit-inline-templates",
    "Emit implicit instantiations of inline templates",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 656,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_implicit_inline_templates), 0, CLVC_BOOLEAN, 0 },
  { "-fimplicit-none",
    "Specify that no implicit typing is allowed, unless overridden by explicit IMPLICIT statements",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 657,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fimplicit-templates",
    "Emit implicit instantiations of templates",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 658,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_implicit_templates), 0, CLVC_BOOLEAN, 0 },
  { "-findirect-classes",
    "Generate instances of Class at runtime",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 659,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_indirect_classes), 0, CLVC_BOOLEAN, 0 },
  { "-findirect-dispatch",
    "Use offset tables for virtual method calls",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 660,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_indirect_dispatch), 0, CLVC_BOOLEAN, 0 },
  { "-findirect-inlining",
    "Perform indirect inlining",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 661,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_indirect_inlining), 0, CLVC_BOOLEAN, 0 },
  { "-finhibit-size-directive",
    "Do not generate .size directives",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 662,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_inhibit_size_directive), 0, CLVC_BOOLEAN, 0 },
  { "-finit-character=",
    "-finit-character=<n>	Initialize local character variables to ASCII value n",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-finit-integer=",
    "-finit-integer=<n>	Initialize local integer variables to n",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-finit-local-zero",
    "Initialize local variables to zero (from g77)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 665,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-finit-logical=",
    "-finit-logical=<true|false>	Initialize local logical variables",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-finit-real=",
    "-finit-real=<zero|nan|inf|-inf>	Initialize local real variables",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-finline",
    "Enable inlining of function declared \"inline\", disabling disables all inlining",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 668,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_no_inline), 0, CLVC_EQUAL, 0 },
  { "-finline-atomics",
    "Inline __atomic operations when a lock free instruction sequence is available.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 669,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_inline_atomics), 0, CLVC_BOOLEAN, 0 },
  { "-finline-functions",
    "Integrate functions not declared \"inline\" into their callers when profitable",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 670,
    CL_Java | CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_inline_functions), 0, CLVC_BOOLEAN, 0 },
  { "-finline-functions-called-once",
    "Integrate functions only required by their single caller",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 29, 671,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_inline_functions_called_once), 0, CLVC_BOOLEAN, 0 },
  { "-finline-limit-",
    0,
    0,
    0,
    NULL, NULL, OPT_finline_limit_, N_OPTS, 14, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-finline-limit=",
    "-finline-limit=<number>	Limit the size of inlined functions to <number>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-finline-small-functions",
    "Integrate functions into their callers when code size is known not to grow",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 674,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_inline_small_functions), 0, CLVC_BOOLEAN, 0 },
  { "-finput-charset=",
    "-finput-charset=<cset>	Specify the default character set for source files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-finstrument-functions",
    "Instrument function entry and exit with profiling calls",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 676,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_instrument_function_entry_exit), 0, CLVC_BOOLEAN, 0 },
  { "-finstrument-functions-exclude-file-list=",
    "-finstrument-functions-exclude-file-list=filename,...  Do not instrument functions listed in files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 40, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-finstrument-functions-exclude-function-list=",
    "-finstrument-functions-exclude-function-list=name,...  Do not instrument listed functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 44, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-finteger-4-integer-8",
    "Interpret any INTEGER(4) as an INTEGER(8)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fintrinsic-modules-path",
    "Specify where to find the compiled intrinsic modules",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, -1,
    CL_Fortran | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fintrinsic-modules-path=",
    "Specify where to find the compiled intrinsic modules",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fipa-cp",
    "Perform interprocedural constant propagation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 682,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ipa_cp), 0, CLVC_BOOLEAN, 0 },
  { "-fipa-cp-clone",
    "Perform cloning to make Interprocedural constant propagation stronger",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 683,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ipa_cp_clone), 0, CLVC_BOOLEAN, 0 },
  { "-fipa-matrix-reorg",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, 684,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fipa-profile",
    "Perform interprocedural profile propagation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 685,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ipa_profile), 0, CLVC_BOOLEAN, 0 },
  { "-fipa-pta",
    "Perform interprocedural points-to analysis",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 686,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ipa_pta), 0, CLVC_BOOLEAN, 0 },
  { "-fipa-pure-const",
    "Discover pure and const functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 687,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ipa_pure_const), 0, CLVC_BOOLEAN, 0 },
  { "-fipa-reference",
    "Discover readonly and non addressable static variables",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 688,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ipa_reference), 0, CLVC_BOOLEAN, 0 },
  { "-fipa-sra",
    "Perform interprocedural reduction of aggregates",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 689,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ipa_sra), 0, CLVC_BOOLEAN, 0 },
  { "-fipa-struct-reorg",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, 690,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fira-algorithm=",
    "-fira-algorithm=[CB|priority] Set the used IRA algorithm",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_algorithm), 8, CLVC_ENUM, 0 },
  { "-fira-hoist-pressure",
    "Use IRA based register pressure calculation in RTL hoist optimizations.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 692,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ira_hoist_pressure), 0, CLVC_BOOLEAN, 0 },
  { "-fira-loop-pressure",
    "Use IRA based register pressure calculation in RTL loop optimizations.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 693,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ira_loop_pressure), 0, CLVC_BOOLEAN, 0 },
  { "-fira-region=",
    "-fira-region=[one|all|mixed] Set regions for IRA",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_region), 9, CLVC_ENUM, 0 },
  { "-fira-share-save-slots",
    "Share slots for saving different hard registers.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 695,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ira_share_save_slots), 0, CLVC_BOOLEAN, 0 },
  { "-fira-share-spill-slots",
    "Share stack slots for spilled pseudo-registers.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 696,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ira_share_spill_slots), 0, CLVC_BOOLEAN, 0 },
  { "-fira-verbose=",
    "-fira-verbose=<number>	Control IRA's level of diagnostic messages.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ira_verbose), 0, CLVC_BOOLEAN, 0 },
  { "-fisolate-erroneous-paths-attribute",
    "Detect paths which trigger erroneous or undefined behaviour due a NULL value being used in a way which is forbidden by a returns_nonnull or nonnull attribute.  Isolate those paths from the main control flow and turn the statement with erroneous or undefined behaviour into a trap. ",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 34, 698,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_isolate_erroneous_paths_attribute), 0, CLVC_BOOLEAN, 0 },
  { "-fisolate-erroneous-paths-dereference",
    "Detect paths which trigger erroneous or undefined behaviour due to dereferencing a NULL pointer.  Isolate those paths from the main control flow and turn the statement with erroneous or undefined behaviour into a trap.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 36, 699,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_isolate_erroneous_paths_dereference), 0, CLVC_BOOLEAN, 0 },
  { "-fivopts",
    "Optimize induction variables on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 700,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ivopts), 0, CLVC_BOOLEAN, 0 },
  { "-fjni",
    "Assume native functions are implemented using JNI",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 701,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_jni), 0, CLVC_BOOLEAN, 0 },
  { "-fjump-tables",
    "Use jump tables for sufficiently large switch statements",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 702,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_jump_tables), 0, CLVC_BOOLEAN, 0 },
  { "-fkeep-inline-dllexport",
    "Don't emit dllexported inline functions unless needed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 703,
#if TARGET_DLLIMPORT_DECL_ATTRIBUTES
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
#else
    0,
    1 /* Disabled.  */, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#endif
    offsetof (struct gcc_options, x_flag_keep_inline_dllexport), 0, CLVC_BOOLEAN, 0 },
  { "-fkeep-inline-functions",
    "Generate code for functions even if they are fully inlined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 704,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_keep_inline_functions), 0, CLVC_BOOLEAN, 0 },
  { "-fkeep-static-consts",
    "Emit static const variables even if they are not used",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 705,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_keep_static_consts), 0, CLVC_BOOLEAN, 0 },
  { "-flabels-ok",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 10, 706,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-flax-vector-conversions",
    "Allow implicit conversions between vectors with differing numbers of subparts and/or differing element types.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 707,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lax_vector_conversions), 0, CLVC_BOOLEAN, 0 },
  { "-fleading-underscore",
    "Give external symbols a leading underscore",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 708,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_leading_underscore), 0, CLVC_BOOLEAN, 0 },
  { "-flive-range-shrinkage",
    "Relief of register pressure through live range shrinkage",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 709,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_live_range_shrinkage), 0, CLVC_BOOLEAN, 0 },
  { "-floop-block",
    "Enable Loop Blocking transformation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 710,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_loop_block), 0, CLVC_BOOLEAN, 0 },
  { "-floop-flatten",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 13, 711,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-floop-interchange",
    "Enable Loop Interchange transformation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 712,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_loop_interchange), 0, CLVC_BOOLEAN, 0 },
  { "-floop-nest-optimize",
    "Enable the ISL based loop nest optimizer",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 713,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_loop_optimize_isl), 0, CLVC_BOOLEAN, 0 },
  { "-floop-optimize",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 14, 714,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-floop-parallelize-all",
    "Mark all loops as parallel",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 715,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_loop_parallelize_all), 0, CLVC_BOOLEAN, 0 },
  { "-floop-strip-mine",
    "Enable Loop Strip Mining transformation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 716,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_loop_strip_mine), 0, CLVC_BOOLEAN, 0 },
  { "-flto",
    "Enable link-time optimization.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 717,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-flto-compression-level=",
    "-flto-compression-level=<number>	Use zlib compression level <number> for IL",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_compression_level), 0, CLVC_BOOLEAN, 0 },
  { "-flto-partition=1to1",
    "Partition symbols and vars at linktime based on object files they originate from",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 719,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_partition_1to1), 0, CLVC_BOOLEAN, 0 },
  { "-flto-partition=balanced",
    "Partition functions and vars at linktime into approximately same sized buckets",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 720,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_partition_balanced), 0, CLVC_BOOLEAN, 0 },
  { "-flto-partition=max",
    "Put every symbol into separate partition",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 721,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_partition_max), 0, CLVC_BOOLEAN, 0 },
  { "-flto-partition=none",
    "Disable partioning and streaming",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 722,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto_partition_none), 0, CLVC_BOOLEAN, 0 },
  { "-flto-report",
    "Report various link-time optimization statistics",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 723,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_lto_report), 0, CLVC_BOOLEAN, 0 },
  { "-flto-report-wpa",
    "Report various link-time optimization statistics for WPA only",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 724,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_lto_report_wpa), 0, CLVC_BOOLEAN, 0 },
  { "-flto=",
    "Link-time optimization with number of parallel jobs or jobserver.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_lto), 0, CLVC_STRING, 0 },
  { "-fltrans",
    "Run the link-time optimizer in local transformation (LTRANS) mode.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 726,
    CL_LTO,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ltrans), 0, CLVC_BOOLEAN, 0 },
  { "-fltrans-output-list=",
    "Specify a file to which a list of files output by LTRANS is written.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 727,
    CL_LTO | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ltrans_output_list), 0, CLVC_STRING, 0 },
  { "-fmain=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fmath-errno",
    "Set errno after built-in math functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 729,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_errno_math), 0, CLVC_BOOLEAN, 0 },
  { "-fmax-array-constructor=",
    "-fmax-array-constructor=<n>	Maximum number of objects in an array constructor",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmax-errors=",
    "-fmax-errors=<number>	Maximum number of errors to report",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_max_errors), 0, CLVC_BOOLEAN, 0 },
  { "-fmax-identifier-length=",
    "-fmax-identifier-length=<n>	Maximum identifier length",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmax-stack-var-size=",
    "-fmax-stack-var-size=<n>	Size in bytes of the largest array that will be put on the stack",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmax-subrecord-length=",
    "-fmax-subrecord-length=<n>	Maximum length for subrecords",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, -1,
    CL_Fortran | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmem-report",
    "Report on permanent memory allocation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 735,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_mem_report), 0, CLVC_BOOLEAN, 0 },
  { "-fmem-report-wpa",
    "Report on permanent memory allocation in WPA only",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 736,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_mem_report_wpa), 0, CLVC_BOOLEAN, 0 },
  { "-fmerge-all-constants",
    "Attempt to merge identical constants and constant variables",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 737,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_merge_constants), 0, CLVC_EQUAL, 2 },
  { "-fmerge-constants",
    "Attempt to merge identical constants across compilation units",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 738,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_merge_constants), 0, CLVC_EQUAL, 1 },
  { "-fmerge-debug-strings",
    "Attempt to merge identical debug strings across compilation units",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 739,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_merge_debug_strings), 0, CLVC_BOOLEAN, 0 },
  { "-fmessage-length=",
    "-fmessage-length=<number>	Limit diagnostics to <number> characters per line.  0 suppresses line-wrapping",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmodule-private",
    "Set default accessibility of module entities to PRIVATE.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 741,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmodulo-sched",
    "Perform SMS based modulo scheduling before the first scheduling pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 742,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_modulo_sched), 0, CLVC_BOOLEAN, 0 },
  { "-fmodulo-sched-allow-regmoves",
    "Perform SMS based modulo scheduling with register moves allowed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, 743,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_modulo_sched_allow_regmoves), 0, CLVC_BOOLEAN, 0 },
  { "-fmove-loop-invariants",
    "Move loop invariant computations out of loops",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 744,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_move_loop_invariants), 0, CLVC_BOOLEAN, 0 },
  { "-fms-extensions",
    "Don't warn about uses of Microsoft extensions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 745,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_ms_extensions), 0, CLVC_BOOLEAN, 0 },
  { "-fmudflap",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 8, 746,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmudflapir",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 10, 747,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fmudflapth",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 10, 748,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fname-mangling-version-",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 23, 749,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fnew-abi",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 8, 750,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fnext-runtime",
    "Generate code for NeXT (Apple Mac OS X) runtime environment",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_next_runtime), 0, CLVC_BOOLEAN, 0 },
  { "-fnil-receivers",
    "Assume that receivers of Objective-C messages may be nil",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 752,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_nil_receivers), 0, CLVC_BOOLEAN, 0 },
  { "-fno-vect-cost-model",
    "Enables the unlimited vectorizer cost model.  Preserved for backward compatibility.",
    0,
    0,
    "unlimited", NULL, OPT_fvect_cost_model_, N_OPTS, 19, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fnon-call-exceptions",
    "Support synchronous non-call exceptions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 754,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_non_call_exceptions), 0, CLVC_BOOLEAN, 0 },
  { "-fnonansi-builtins",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 755,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_no_nonansi_builtin), 0, CLVC_EQUAL, 0 },
  { "-fnonnull-objects",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 16, 756,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fnothrow-opt",
    "Treat a throw() exception specification as noexcept to improve code size",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 757,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_nothrow_opt), 0, CLVC_BOOLEAN, 0 },
  { "-fobjc-abi-version=",
    "Specify which ABI to use for Objective-C family code and meta-data generation.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_LTO | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_objc_abi), 0, CLVC_BOOLEAN, 0 },
  { "-fobjc-call-cxx-cdtors",
    "Generate special Objective-C methods to initialize/destroy non-POD C++ ivars, if needed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 759,
    CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_call_cxx_cdtors), 0, CLVC_BOOLEAN, 0 },
  { "-fobjc-direct-dispatch",
    "Allow fast jumps to the message dispatcher",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 760,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_direct_dispatch), 0, CLVC_BOOLEAN, 0 },
  { "-fobjc-exceptions",
    "Enable Objective-C exception and synchronization syntax",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 761,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_exceptions), 0, CLVC_BOOLEAN, 0 },
  { "-fobjc-gc",
    "Enable garbage collection (GC) in Objective-C/Objective-C++ programs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 762,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_gc), 0, CLVC_BOOLEAN, 0 },
  { "-fobjc-nilcheck",
    "Enable inline checks for nil receivers with the NeXT runtime and ABI version 2.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 763,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_nilcheck), 0, CLVC_EQUAL, 1 },
  { "-fobjc-sjlj-exceptions",
    "Enable Objective-C setjmp exception handling runtime",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 764,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc_sjlj_exceptions), 0, CLVC_BOOLEAN, 0 },
  { "-fobjc-std=objc1",
    "Conform to the Objective-C 1.0 language as implemented in GCC 4.0",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 765,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_objc1_only), 0, CLVC_BOOLEAN, 0 },
  { "-fomit-frame-pointer",
    "When possible do not generate stack frames",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 766,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_omit_frame_pointer), 0, CLVC_BOOLEAN, 0 },
  { "-fopenmp",
    "Enable OpenMP (implies -frecursive in Fortran)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 767,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_openmp), 0, CLVC_BOOLEAN, 0 },
  { "-fopenmp-simd",
    "Enable OpenMP's SIMD directives",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 768,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_openmp_simd), 0, CLVC_BOOLEAN, 0 },
  { "-foperator-names",
    "Recognize C++ keywords like \"compl\" and \"xor\"",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 769,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fopt-info",
    "Enable all optimization info dumps on stderr",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 770,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_opt_info), 0, CLVC_BOOLEAN, 0 },
  { "-fopt-info-",
    "-fopt-info[-<type>=filename]	Dump compiler optimization details",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-foptimize-register-move",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 23, 772,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-foptimize-sibling-calls",
    "Optimize sibling and tail recursive calls",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 773,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_optimize_sibling_calls), 0, CLVC_BOOLEAN, 0 },
  { "-foptimize-static-class-initialization",
    "Enable optimization of static class initialization code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 37, 774,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_optimize_sci), 0, CLVC_BOOLEAN, 0 },
  { "-foptimize-strlen",
    "Enable string length optimizations on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 775,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_optimize_strlen), 0, CLVC_BOOLEAN, 0 },
  { "-foptional-diags",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, 776,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-foutput-class-dir=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fpack-derived",
    "Try to lay out derived types as compactly as possible",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 778,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fpack-struct",
    "Pack structure members together without holes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 779,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_pack_struct), 0, CLVC_BOOLEAN, 0 },
  { "-fpack-struct=",
    "-fpack-struct=<number>	Set initial maximum structure member alignment",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fpartial-inlining",
    "Perform partial inlining",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 781,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_partial_inlining), 0, CLVC_BOOLEAN, 0 },
  { "-fpcc-struct-return",
    "Return small aggregates in memory, not registers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 782,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_pcc_struct_return), 0, CLVC_EQUAL, 1 },
  { "-fpch-deps",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 783,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fpch-preprocess",
    "Look for and use PCH files even when preprocessing",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 784,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fpeel-loops",
    "Perform loop peeling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 785,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_peel_loops), 0, CLVC_BOOLEAN, 0 },
  { "-fpeephole",
    "Enable machine specific peephole optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 786,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_no_peephole), 0, CLVC_EQUAL, 0 },
  { "-fpeephole2",
    "Enable an RTL peephole pass before sched2",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 787,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_peephole2), 0, CLVC_BOOLEAN, 0 },
  { "-fpermissive",
    "Downgrade conformance errors to warnings",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 788,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_permissive), 0, CLVC_BOOLEAN, 0 },
  { "-fpic",
    "Generate position-independent code if possible (small mode)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 790,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_pic), 0, CLVC_EQUAL, 1 },
  { "-fpie",
    "Generate position-independent code for executables if possible (small mode)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 439,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_pie), 0, CLVC_EQUAL, 1 },
  { "-fplan9-extensions",
    "Enable Plan 9 language extensions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 791,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_plan9_extensions), 0, CLVC_BOOLEAN, 0 },
  { "-fplugin-arg-",
    "-fplugin-arg-<name>-<key>[=<value>]	Specify argument <key>=<value> for plugin <name>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fplugin=",
    "Specify a plugin to load",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fpost-ipa-mem-report",
    "Report on memory allocation before interprocedural optimization",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 794,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_post_ipa_mem_report), 0, CLVC_BOOLEAN, 0 },
  { "-fpre-ipa-mem-report",
    "Report on memory allocation before interprocedural optimization",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 795,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_pre_ipa_mem_report), 0, CLVC_BOOLEAN, 0 },
  { "-fpredictive-commoning",
    "Run predictive commoning optimization.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 796,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_predictive_commoning), 0, CLVC_BOOLEAN, 0 },
  { "-fprefetch-loop-arrays",
    "Generate prefetch instructions, if available, for arrays in loops",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 797,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_prefetch_loop_arrays), 0, CLVC_BOOLEAN, 0 },
  { "-fpreprocessed",
    "Treat the input file as already preprocessed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 798,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fpretty-templates",
    "-fno-pretty-templates Do not pretty-print template specializations as the template signature followed by the arguments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 799,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pretty_templates), 0, CLVC_BOOLEAN, 0 },
  { "-fprofile",
    "Enable basic program profiling code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 800,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_profile_flag), 0, CLVC_BOOLEAN, 0 },
  { "-fprofile-arcs",
    "Insert arc-based program profiling code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 801,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_profile_arc_flag), 0, CLVC_BOOLEAN, 0 },
  { "-fprofile-correction",
    "Enable correction of flow inconsistent profile data input",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 802,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_profile_correction), 0, CLVC_BOOLEAN, 0 },
  { "-fprofile-dir=",
    "Set the top-level directory for storing the profile data. The default is 'pwd'.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_data_prefix), 0, CLVC_STRING, 0 },
  { "-fprofile-generate",
    "Enable common options for generating profile info for profile feedback directed optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 804,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fprofile-generate=",
    "Enable common options for generating profile info for profile feedback directed optimizations, and set -fprofile-dir=",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fprofile-reorder-functions",
    "Enable function reordering that improves code placement",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 806,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_profile_reorder_functions), 0, CLVC_BOOLEAN, 0 },
  { "-fprofile-report",
    "Report on consistency of profile",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 807,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_profile_report), 0, CLVC_BOOLEAN, 0 },
  { "-fprofile-use",
    "Enable common options for performing profile feedback directed optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 808,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_profile_use), 0, CLVC_BOOLEAN, 0 },
  { "-fprofile-use=",
    "Enable common options for performing profile feedback directed optimizations, and set -fprofile-dir=",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fprofile-values",
    "Insert code to profile values of expressions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 810,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_profile_values), 0, CLVC_BOOLEAN, 0 },
  { "-fprotect-parens",
    "Protect parentheses in expressions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 811,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-frandom-seed",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 812,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-frandom-seed=",
    "-frandom-seed=<string>	Make compile reproducible using <string>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-frange-check",
    "Enable range checking during compilation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 814,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freal-4-real-10",
    "Interpret any REAL(4) as a REAL(10)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freal-4-real-16",
    "Interpret any REAL(4) as a REAL(16)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freal-4-real-8",
    "Interpret any REAL(4) as a REAL(8)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freal-8-real-10",
    "Interpret any REAL(8) as a REAL(10)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freal-8-real-16",
    "Interpret any REAL(8) as a REAL(16)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freal-8-real-4",
    "Interpret any REAL(8) as a REAL(4)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-frealloc-lhs",
    "Reallocate the LHS in assignments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 821,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freciprocal-math",
    "Same as -fassociative-math for expressions which include division.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 822,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_reciprocal_math), 0, CLVC_BOOLEAN, 0 },
  { "-frecord-gcc-switches",
    "Record gcc command line switches in the object file.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 823,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_record_gcc_switches), 0, CLVC_BOOLEAN, 0 },
  { "-frecord-marker=4",
    "Use a 4-byte record marker for unformatted files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-frecord-marker=8",
    "Use an 8-byte record marker for unformatted files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-frecursive",
    "Allocate local variables on the stack to allow indirect recursion",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 826,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freduced-reflection",
    "Reduce the amount of reflection meta-data generated",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 827,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_reduced_reflection), 0, CLVC_BOOLEAN, 0 },
  { "-free",
    "Turn on Redundant Extensions Elimination pass.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 828,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ree), 0, CLVC_BOOLEAN, 0 },
  { "-freg-struct-return",
    "Return small aggregates in registers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 829,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_pcc_struct_return), 0, CLVC_EQUAL, 0 },
  { "-fregmove",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 8, 830,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-frename-registers",
    "Perform a register renaming optimization pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 831,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_rename_registers), 0, CLVC_BOOLEAN, 0 },
  { "-freorder-blocks",
    "Reorder basic blocks to improve code placement",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 832,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_reorder_blocks), 0, CLVC_BOOLEAN, 0 },
  { "-freorder-blocks-and-partition",
    "Reorder basic blocks and partition into hot and cold sections",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 29, 833,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_reorder_blocks_and_partition), 0, CLVC_BOOLEAN, 0 },
  { "-freorder-functions",
    "Reorder functions to improve code placement",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 834,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_reorder_functions), 0, CLVC_BOOLEAN, 0 },
  { "-frepack-arrays",
    "Copy array sections into a contiguous block on procedure entry",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 835,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freplace-objc-classes",
    "Used in Fix-and-Continue mode to indicate that object files may be swapped in at runtime",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 836,
    CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_replace_objc_classes), 0, CLVC_BOOLEAN, 0 },
  { "-frepo",
    "Enable automatic template instantiation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 837,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-frequire-return-statement",
    "Functions which return values must end with return statements",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 838,
    CL_Go | CL_WARNING,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_go_require_return_statement), 0, CLVC_BOOLEAN, 0 },
  { "-frerun-cse-after-loop",
    "Add a common subexpression elimination pass after loop optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 839,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_rerun_cse_after_loop), 0, CLVC_BOOLEAN, 0 },
  { "-frerun-loop-opt",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, 840,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-freschedule-modulo-scheduled-loops",
    "Enable/Disable the traditional scheduling in loops that already passed modulo scheduling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 34, 841,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_resched_modulo_sched), 0, CLVC_BOOLEAN, 0 },
  { "-fresolution=",
    "The resolution file",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 842,
    CL_LTO | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-frounding-math",
    "Disable optimizations that assume default FP rounding behavior",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 843,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_rounding_math), 0, CLVC_BOOLEAN, 0 },
  { "-frtti",
    "Generate run time type descriptor information",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 844,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_rtti), 0, CLVC_BOOLEAN, 0 },
  { "-fsanitize=",
    "Select what to sanitize",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 845,
    CL_COMMON | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    -1, 0, CLVC_STRING, 0 },
  { "-fsaw-java-file",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_Java | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fsched-critical-path-heuristic",
    "Enable the critical path heuristic in the scheduler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 30, 847,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_critical_path_heuristic), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-dep-count-heuristic",
    "Enable the dependent count heuristic in the scheduler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 848,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_dep_count_heuristic), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-group-heuristic",
    "Enable the group heuristic in the scheduler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 849,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_group_heuristic), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-interblock",
    "Enable scheduling across basic blocks",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 850,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_schedule_interblock), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-last-insn-heuristic",
    "Enable the last instruction heuristic in the scheduler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 851,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_last_insn_heuristic), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-pressure",
    "Enable register pressure sensitive insn scheduling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 852,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_pressure), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-rank-heuristic",
    "Enable the rank heuristic in the scheduler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 853,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_rank_heuristic), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-spec",
    "Allow speculative motion of non-loads",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 854,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_schedule_speculative), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-spec-insn-heuristic",
    "Enable the speculative instruction heuristic in the scheduler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 855,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_spec_insn_heuristic), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-spec-load",
    "Allow speculative motion of some loads",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 856,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_schedule_speculative_load), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-spec-load-dangerous",
    "Allow speculative motion of more loads",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 857,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_schedule_speculative_load_dangerous), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-stalled-insns",
    "Allow premature scheduling of queued insns",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 858,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_stalled_insns), 0, CLVC_BOOLEAN, 0 },
  { "-fsched-stalled-insns-dep",
    "Set dependence distance checking in premature scheduling of queued insns",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 859,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched_stalled_insns_dep), 0, CLVC_EQUAL, 1 },
  { "-fsched-stalled-insns-dep=",
    "-fsched-stalled-insns-dep=<number>	Set dependence distance checking in premature scheduling of queued insns",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fsched-stalled-insns=",
    "-fsched-stalled-insns=<number>	Set number of queued insns that can be prematurely scheduled",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fsched-verbose=",
    "-fsched-verbose=<number>	Set the verbosity level of the scheduler",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_sched_verbose_param), 0, CLVC_BOOLEAN, 0 },
  { "-fsched2-use-superblocks",
    "If scheduling post reload, do superblock scheduling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 863,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sched2_use_superblocks), 0, CLVC_BOOLEAN, 0 },
  { "-fsched2-use-traces",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 18, 864,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fschedule-insns",
    "Reschedule instructions before register allocation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 865,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_schedule_insns), 0, CLVC_BOOLEAN, 0 },
  { "-fschedule-insns2",
    "Reschedule instructions after register allocation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 866,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_schedule_insns_after_reload), 0, CLVC_BOOLEAN, 0 },
  { "-fsecond-underscore",
    "Append a second underscore if the name already contains an underscore",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 867,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fsection-anchors",
    "Access data in the same section from shared anchor points",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 868,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_section_anchors), 0, CLVC_BOOLEAN, 0 },
  { "-fsee",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 4, 869,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fsel-sched-pipelining",
    "Perform software pipelining of inner loops during selective scheduling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 870,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sel_sched_pipelining), 0, CLVC_BOOLEAN, 0 },
  { "-fsel-sched-pipelining-outer-loops",
    "Perform software pipelining of outer loops during selective scheduling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 33, 871,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sel_sched_pipelining_outer_loops), 0, CLVC_BOOLEAN, 0 },
  { "-fsel-sched-reschedule-pipelined",
    "Reschedule pipelined regions without pipelining",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 31, 872,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sel_sched_reschedule_pipelined), 0, CLVC_BOOLEAN, 0 },
  { "-fselective-scheduling",
    "Schedule instructions using selective scheduling algorithm",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 873,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_selective_scheduling), 0, CLVC_BOOLEAN, 0 },
  { "-fselective-scheduling2",
    "Run selective scheduling after reload",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 874,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_selective_scheduling2), 0, CLVC_BOOLEAN, 0 },
  { "-fshort-double",
    "Use the same size for double as for float",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 875,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_short_double), 0, CLVC_BOOLEAN, 0 },
  { "-fshort-enums",
    "Use the narrowest integer type possible for enumeration types",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 876,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_short_enums), 0, CLVC_BOOLEAN, 0 },
  { "-fshort-wchar",
    "Force the underlying type for \"wchar_t\" to be \"unsigned short\"",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 877,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_short_wchar), 0, CLVC_BOOLEAN, 0 },
  { "-fshow-column",
    "Show column numbers in diagnostics, when available.  Default on",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 878,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_show_column), 0, CLVC_BOOLEAN, 0 },
  { "-fshrink-wrap",
    "Emit function prologues only before parts of the function that need it, rather than at the top of the function.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 879,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_shrink_wrap), 0, CLVC_BOOLEAN, 0 },
  { "-fsign-zero",
    "Apply negative sign to zero values",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 880,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fsignaling-nans",
    "Disable optimizations observable by IEEE signaling NaNs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 881,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_signaling_nans), 0, CLVC_BOOLEAN, 0 },
  { "-fsigned-bitfields",
    "When \"signed\" or \"unsigned\" is not given make the bitfield signed",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 882,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_bitfields), 0, CLVC_BOOLEAN, 0 },
  { "-fsigned-char",
    "Make \"char\" signed by default",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 883,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_char), 0, CLVC_BOOLEAN, 0 },
  { "-fsigned-zeros",
    "Disable floating point optimizations that ignore the IEEE signedness of zero",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 884,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_signed_zeros), 0, CLVC_BOOLEAN, 0 },
  { "-fsimd-cost-model=",
    "Specifies the vectorization cost model for code marked with a simd directive",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_simd_cost_model), 18, CLVC_ENUM, 0 },
  { "-fsingle-precision-constant",
    "Convert floating point constants to single precision constants",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 886,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_single_precision_constant), 0, CLVC_BOOLEAN, 0 },
  { "-fsource-filename=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 887,
    CL_Java | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fsource=",
    "Set the source language version",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 888,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fsplit-ivs-in-unroller",
    "Split lifetimes of induction variables when loops are unrolled",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 889,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_split_ivs_in_unroller), 0, CLVC_BOOLEAN, 0 },
  { "-fsplit-stack",
    "Generate discontiguous stack frames",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 890,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_split_stack), 0, CLVC_BOOLEAN, 0 },
  { "-fsplit-wide-types",
    "Split wide types into independent registers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 891,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_split_wide_types), 0, CLVC_BOOLEAN, 0 },
  { "-fsquangle",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 9, 892,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fstack-arrays",
    "Put all local arrays on stack.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 893,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fstack-check",
    "Insert stack checking code into the program.  Same as -fstack-check=specific",
    0,
    0,
    "specific", "no", OPT_fstack_check_, N_OPTS, 12, 894,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fstack-check=",
    "-fstack-check=[no|generic|specific]	Insert stack checking code into the program",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    -1, 0, CLVC_STRING, 0 },
  { "-fstack-limit",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 896,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fstack-limit-register=",
    "-fstack-limit-register=<register>	Trap if the stack goes past <register>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fstack-limit-symbol=",
    "-fstack-limit-symbol=<name>	Trap if the stack goes past symbol <name>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_common_deferred_options), 0, CLVC_DEFER, 0 },
  { "-fstack-protector",
    "Use propolice as a stack protection method",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 899,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_stack_protect), 0, CLVC_EQUAL, 1 },
  { "-fstack-protector-all",
    "Use a stack protection method for every function",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_stack_protect), 0, CLVC_EQUAL, 2 },
  { "-fstack-protector-strong",
    "Use a smart stack protection method for certain functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_stack_protect), 0, CLVC_EQUAL, 3 },
  { "-fstack-reuse=",
    "-fstack-reuse=[all|named_vars|none] Set stack reuse level for local variables.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_reuse), 13, CLVC_ENUM, 0 },
  { "-fstack-usage",
    "Output stack usage information on a per-function basis",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_stack_usage), 0, CLVC_BOOLEAN, 0 },
  { "-fstats",
    "Display statistics accumulated during compilation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 904,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_detailed_statistics), 0, CLVC_BOOLEAN, 0 },
  { "-fstore-check",
    "Enable assignability checks for stores into object arrays",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 905,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_store_check), 0, CLVC_BOOLEAN, 0 },
  { "-fstrength-reduce",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 16, 906,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fstrict-aliasing",
    "Assume strict aliasing rules apply",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 907,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_strict_aliasing), 0, CLVC_BOOLEAN, 0 },
  { "-fstrict-enums",
    "Assume that values of enumeration type are always within the minimum range of that type",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 908,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_strict_enums), 0, CLVC_BOOLEAN, 0 },
  { "-fstrict-overflow",
    "Treat signed overflow as undefined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 909,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_strict_overflow), 0, CLVC_BOOLEAN, 0 },
  { "-fstrict-prototype",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, 910,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fstrict-volatile-bitfields",
    "Force bitfield accesses to match their type width",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 911,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_strict_volatile_bitfields), 0, CLVC_BOOLEAN, 0 },
  { "-fsync-libcalls",
    "Implement __atomic operations via libcalls to legacy __sync functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 912,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_sync_libcalls), 0, CLVC_BOOLEAN, 0 },
  { "-fsyntax-only",
    "Check for syntax errors, then stop",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 913,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_syntax_only), 0, CLVC_BOOLEAN, 0 },
  { "-ftabstop=",
    "-ftabstop=<number>	Distance between tab stops for column reporting",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftarget-help",
    0,
    0,
    0,
    NULL, NULL, OPT__target_help, N_OPTS, 12, 915,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftarget=",
    "Set the target VM version",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 916,
    CL_Java | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-ftemplate-backtrace-limit=",
    "Set the maximum number of template instantiation notes for a single warning or error",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_template_backtrace_limit), 0, CLVC_BOOLEAN, 0 },
  { "-ftemplate-depth-",
    0,
    0,
    0,
    NULL, NULL, OPT_ftemplate_depth_, N_OPTS, 16, -1,
    CL_CXX | CL_ObjCXX | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-ftemplate-depth=",
    "-ftemplate-depth=<number>	Specify maximum template instantiation depth",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_CXX | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftest-coverage",
    "Create data files needed by \"gcov\"",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 920,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_test_coverage), 0, CLVC_BOOLEAN, 0 },
  { "-fthis-is-variable",
    0,
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 17, 921,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fthread-jumps",
    "Perform jump threading optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 922,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_thread_jumps), 0, CLVC_BOOLEAN, 0 },
  { "-fthreadsafe-statics",
    "-fno-threadsafe-statics	Do not generate thread-safe code for initializing local statics",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 923,
    CL_CXX | CL_ObjCXX | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_threadsafe_statics), 0, CLVC_BOOLEAN, 0 },
  { "-ftime-report",
    "Report the time taken by each compiler pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 924,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_time_report), 0, CLVC_BOOLEAN, 0 },
  { "-ftls-model=",
    "-ftls-model=[global-dynamic|local-dynamic|initial-exec|local-exec]	Set the default thread-local storage code generation model",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_tls_default), 17, CLVC_ENUM, 0 },
  { "-ftoplevel-reorder",
    "Reorder top level functions, variables, and asms",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 926,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_toplevel_reorder), 0, CLVC_BOOLEAN, 0 },
  { "-ftracer",
    "Perform superblock formation via tail duplication",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 927,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tracer), 0, CLVC_BOOLEAN, 0 },
  { "-ftrack-macro-expansion",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftrack-macro-expansion=",
    "-ftrack-macro-expansion=<0|1|2>  Track locations of tokens coming from macro expansion and display them in error messages",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_ftrack_macro_expansion, 23, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 1 /* JoinedOrMissing */, 1 /* UInteger */, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftrapping-math",
    "Assume floating-point operations can trap",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 930,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_trapping_math), 0, CLVC_BOOLEAN, 0 },
  { "-ftrapv",
    "Trap for signed overflow in addition, subtraction and multiplication",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 931,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_trapv), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-bit-ccp",
    "Enable SSA-BIT-CCP optimization on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 932,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_bit_ccp), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-builtin-call-dce",
    "Enable conditional dead code elimination for builtin calls",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 933,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_builtin_call_dce), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-ccp",
    "Enable SSA-CCP optimization on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 934,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_ccp), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-ch",
    "Enable loop header copying on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 935,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_ch), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-coalesce-inlined-vars",
    "Enable coalescing of copy-related user variables that are inlined",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 27, -1,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ssa_coalesce_vars), 0, CLVC_EQUAL, 1 },
  { "-ftree-coalesce-vars",
    "Enable coalescing of all copy-related user variables",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 937,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_ssa_coalesce_vars), 0, CLVC_EQUAL, 2 },
  { "-ftree-copy-prop",
    "Enable copy propagation on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 938,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_copy_prop), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-copyrename",
    "Replace SSA temporaries with better names in copies",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 939,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_copyrename), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-cselim",
    "Transform condition stores into unconditional ones",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 940,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_cselim), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-dce",
    "Enable SSA dead code elimination optimization on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 941,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_dce), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-dominator-opts",
    "Enable dominator optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 942,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_dom), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-dse",
    "Enable dead store elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 943,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_dse), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-forwprop",
    "Enable forward propagation on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 944,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_forwprop), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-fre",
    "Enable Full Redundancy Elimination (FRE) on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 945,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_fre), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-distribute-patterns",
    "Enable loop distribution for patterns transformed into a library call",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 30, 946,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_distribute_patterns), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-distribution",
    "Enable loop distribution on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 947,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_distribution), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-if-convert",
    "Convert conditional jumps in innermost loops to branchless equivalents",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 948,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_if_convert), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-if-convert-stores",
    "Also if-convert conditional jumps containing memory writes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, 949,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_if_convert_stores), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-im",
    "Enable loop invariant motion on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 950,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_im), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-ivcanon",
    "Create canonical induction variables in loops",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 951,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_ivcanon), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-linear",
    "Enable loop interchange transforms.  Same as -floop-interchange",
    0,
    0,
    NULL, NULL, OPT_floop_interchange, N_OPTS, 17, 952,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-optimize",
    "Enable loop optimizations on tree level",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 953,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_optimize), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-loop-vectorize",
    "Enable loop vectorization on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 954,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_loop_vectorize), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-lrs",
    "Perform live range splitting during the SSA->normal pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 955,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_live_range_split), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-parallelize-loops=",
    "Enable automatic parallelization of loops",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_parallelize_loops), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-partial-pre",
    "In SSA-PRE optimization on trees, enable partial-partial redundancy elimination",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 957,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_partial_pre), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-phiprop",
    "Enable hoisting loads from conditional pointers.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 958,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_phiprop), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-pre",
    "Enable SSA-PRE optimization on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 959,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_pre), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-pta",
    "Perform function-local points-to analysis on trees.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 960,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_pta), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-reassoc",
    "Enable reassociation on tree level",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 961,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_reassoc), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-salias",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 12, 962,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftree-scev-cprop",
    "Enable copy propagation of scalar-evolution information.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 963,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_scev_cprop), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-sink",
    "Enable SSA code sinking on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 964,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_sink), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-slp-vectorize",
    "Enable basic block vectorization (SLP) on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 965,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_slp_vectorize), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-slsr",
    "Perform straight-line strength reduction",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 966,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_slsr), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-sra",
    "Perform scalar replacement of aggregates",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 967,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_sra), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-store-ccp",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 15, 968,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftree-store-copy-prop",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 21, 969,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftree-switch-conversion",
    "Perform conversions of switch initializations.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, 970,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_switch_conversion), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-tail-merge",
    "Enable tail merging on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 971,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_tail_merge), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-ter",
    "Replace temporary expressions in the SSA->normal pass",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 972,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_ter), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-vect-loop-version",
    "Does nothing. Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 23, 973,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-ftree-vectorize",
    "Enable vectorization on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 974,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_vectorize), 0, CLVC_BOOLEAN, 0 },
  { "-ftree-vectorizer-verbose=",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 25, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-ftree-vrp",
    "Perform Value Range Propagation on trees",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 976,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_tree_vrp), 0, CLVC_BOOLEAN, 0 },
  { "-funderscoring",
    "Append underscores to externally visible names",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 977,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-funit-at-a-time",
    "Compile whole compilation unit at a time",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 978,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_unit_at_a_time), 0, CLVC_BOOLEAN, 0 },
  { "-funroll-all-loops",
    "Perform loop unrolling for all loops",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 979,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_unroll_all_loops), 0, CLVC_BOOLEAN, 0 },
  { "-funroll-loops",
    "Perform loop unrolling when iteration count is known",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 980,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_unroll_loops), 0, CLVC_BOOLEAN, 0 },
  { "-funsafe-loop-optimizations",
    "Allow loop optimizations to assume that the loops behave in normal way",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 981,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_unsafe_loop_optimizations), 0, CLVC_BOOLEAN, 0 },
  { "-funsafe-math-optimizations",
    "Allow math optimizations that may violate IEEE or ISO standards",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 982,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_unsafe_math_optimizations), 0, CLVC_BOOLEAN, 0 },
  { "-funsigned-bitfields",
    "When \"signed\" or \"unsigned\" is not given make the bitfield unsigned",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, 983,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_bitfields), 0, CLVC_EQUAL, 0 },
  { "-funsigned-char",
    "Make \"char\" unsigned by default",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 984,
    CL_C | CL_CXX | CL_LTO | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_signed_char), 0, CLVC_EQUAL, 0 },
  { "-funswitch-loops",
    "Perform loop unswitching",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 985,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_unswitch_loops), 0, CLVC_BOOLEAN, 0 },
  { "-funwind-tables",
    "Just generate unwind tables for exception handling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 986,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_unwind_tables), 0, CLVC_BOOLEAN, 0 },
  { "-fuse-atomic-builtins",
    "Generate code for built-in atomic operations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 987,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_atomic_builtins), 0, CLVC_BOOLEAN, 0 },
  { "-fuse-boehm-gc",
    "Generate code for the Boehm GC",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 988,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_boehm_gc), 0, CLVC_BOOLEAN, 0 },
  { "-fuse-cxa-atexit",
    "Use __cxa_atexit to register destructors",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 989,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_cxa_atexit), 0, CLVC_BOOLEAN, 0 },
  { "-fuse-cxa-get-exception-ptr",
    "Use __cxa_get_exception_ptr in exception handling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 990,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_cxa_get_exception_ptr), 0, CLVC_BOOLEAN, 0 },
  { "-fuse-divide-subroutine",
    "Call a library routine to do integer divisions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, 991,
    CL_Java,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_divide_subroutine), 0, CLVC_BOOLEAN, 0 },
  { "-fuse-ld=bfd",
    "Use the bfd linker instead of the default linker",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 993,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fuse-ld=gold",
    "Use the gold linker instead of the default linker",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 992,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fuse-linker-plugin",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 994,
    CL_COMMON | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_use_linker_plugin), 0, CLVC_BOOLEAN, 0 },
  { "-fvar-tracking",
    "Perform variable tracking",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 995,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_var_tracking), 0, CLVC_BOOLEAN, 0 },
  { "-fvar-tracking-assignments",
    "Perform variable tracking by annotating assignments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 996,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_var_tracking_assignments), 0, CLVC_BOOLEAN, 0 },
  { "-fvar-tracking-assignments-toggle",
    "Toggle -fvar-tracking-assignments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 32, 997,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_var_tracking_assignments_toggle), 0, CLVC_BOOLEAN, 0 },
  { "-fvar-tracking-uninit",
    "Perform variable tracking and also tag variables that are uninitialized",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 998,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_var_tracking_uninit), 0, CLVC_BOOLEAN, 0 },
  { "-fvariable-expansion-in-unroller",
    "Apply variable expansion when loops are unrolled",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 31, 999,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_variable_expansion_in_unroller), 0, CLVC_BOOLEAN, 0 },
  { "-fvect-cost-model",
    "Enables the dynamic vectorizer cost model.  Preserved for backward compatibility.",
    0,
    0,
    "dynamic", NULL, OPT_fvect_cost_model_, N_OPTS, 16, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fvect-cost-model=",
    "Specifies the cost model for vectorization",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vect_cost_model), 18, CLVC_ENUM, 0 },
  { "-fverbose-asm",
    "Add extra commentary to assembler output",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 1002,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_verbose_asm), 0, CLVC_BOOLEAN, 0 },
  { "-fversion",
    0,
    0,
    0,
    NULL, NULL, OPT__version, N_OPTS, 8, 1003,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fvisibility-inlines-hidden",
    "Marks all inlined functions and methods as having hidden visibility",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, 1004,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fvisibility-ms-compat",
    "Changes visibility to match Microsoft Visual Studio by default",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 1005,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_visibility_ms_compat), 0, CLVC_BOOLEAN, 0 },
  { "-fvisibility=",
    "-fvisibility=[default|internal|hidden|protected]	Set the default symbol visibility",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_default_visibility), 15, CLVC_ENUM, 0 },
  { "-fvpt",
    "Use expression value profiles in optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1007,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_value_profile_transformations), 0, CLVC_BOOLEAN, 0 },
  { "-fvtable-gc",
    "No longer supported",
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 10, 1008,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fvtable-thunks",
    "No longer supported",
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 14, 1009,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fvtable-verify=",
    "Validate vtable pointers before using them.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vtable_verify), 19, CLVC_ENUM, 0 },
  { "-fvtv-counts",
    "Output vtable verification counters.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 1011,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vtv_counts), 0, CLVC_BOOLEAN, 0 },
  { "-fvtv-debug",
    "Output vtable verification pointer sets information.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 1012,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_vtv_debug), 0, CLVC_BOOLEAN, 0 },
  { "-fweak",
    "Emit common-like symbols as weak symbols",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1013,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_weak), 0, CLVC_BOOLEAN, 0 },
  { "-fweb",
    "Construct webs and split unrelated uses of single variable",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1014,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_web), 0, CLVC_BOOLEAN, 0 },
  { "-fwhole-file",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 11, 1015,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fwhole-program",
    "Perform whole program optimizations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 1016,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_whole_program), 0, CLVC_BOOLEAN, 0 },
  { "-fwide-exec-charset=",
    "-fwide-exec-charset=<cset>	Convert all wide strings and character constants to character set <cset>",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-fworking-directory",
    "Generate a #line directive pointing at the current working directory",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, 1018,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_working_directory), 0, CLVC_BOOLEAN, 0 },
  { "-fwpa",
    "Run the link-time optimizer in whole program analysis (WPA) mode.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1019,
    CL_LTO | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fwpa=",
    "Whole program analysis (WPA) mode with number of parallel jobs specified.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_LTO | CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_wpa), 0, CLVC_STRING, 0 },
  { "-fwrapv",
    "Assume signed arithmetic overflow wraps around",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1021,
    CL_COMMON | CL_OPTIMIZATION,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_wrapv), 0, CLVC_BOOLEAN, 0 },
  { "-fxref",
    "No longer supported",
    0,
    "switch %qs is no longer supported",
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 5, 1022,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fzee",
    "Does nothing.  Preserved for backward compatibility.",
    0,
    0,
    NULL, NULL, OPT_SPECIAL_ignore, N_OPTS, 4, 1023,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-fzero-initialized-in-bss",
    "Put zero initialized data in the bss section",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 1024,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_zero_initialized_in_bss), 0, CLVC_BOOLEAN, 0 },
  { "-fzero-link",
    "Generate lazy class lookup (via objc_getClass()) for use in Zero-Link mode",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 1025,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_zero_link), 0, CLVC_BOOLEAN, 0 },
  { "-g",
    "Generate debug information in default format",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gant",
    "Catch typos",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 4, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gcoff",
    "Generate debug information in COFF format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 5, 1029,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gdwarf",
    "Generate debug information in default version of DWARF format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 6, 1030,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gdwarf-",
    "Generate debug information in DWARF v2 (or later) format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_gdwarf, 7, 1043,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_version), 0, CLVC_BOOLEAN, 0 },
  { "-gen-decls",
    "Dump declarations to a .decl file",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 9, -1,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_gen_declaration), 0, CLVC_BOOLEAN, 0 },
  { "-ggdb",
    "Generate debug information in default extended format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 4, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-ggnu-pubnames",
    "Generate DWARF pubnames and pubtypes sections with GNU extensions.",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 13, 1036,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_generate_pub_sections), 0, CLVC_EQUAL, 2 },
  { "-gnat",
    "-gnat<options>	Specify options to GNAT",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 4, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gnatO",
    "Set name of output ALI file (internal switch)",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_gnat, 5, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gno-pubnames",
    "Don't generate DWARF pubnames and pubtypes sections.",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 12, 1040,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_generate_pub_sections), 0, CLVC_EQUAL, 0 },
  { "-gno-record-gcc-switches",
    "Don't record gcc command line switches in DWARF DW_AT_producer.",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 23, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_record_gcc_switches), 0, CLVC_EQUAL, 0 },
  { "-gno-split-dwarf",
    "Don't generate debug information in separate .dwo files",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 15, -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_split_debug_info), 0, CLVC_EQUAL, 0 },
  { "-gno-strict-dwarf",
    "Emit DWARF additions beyond selected version",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 16, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_strict), 0, CLVC_EQUAL, 0 },
  { "-gpubnames",
    "Generate DWARF pubnames and pubtypes sections.",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 9, 1033,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_debug_generate_pub_sections), 0, CLVC_EQUAL, 1 },
  { "-grecord-gcc-switches",
    "Record gcc command line switches in DWARF DW_AT_producer.",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 20, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_record_gcc_switches), 0, CLVC_EQUAL, 1 },
  { "-gsplit-dwarf",
    "Generate debug information in separate .dwo files",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 12, -1,
    CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_dwarf_split_debug_info), 0, CLVC_EQUAL, 1 },
  { "-gstabs",
    "Generate debug information in STABS format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 6, 1044,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gstabs+",
    "Generate debug information in extended STABS format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_gstabs, 7, 1047,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gstrict-dwarf",
    "Don't emit DWARF additions beyond selected version",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 13, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_dwarf_strict), 0, CLVC_EQUAL, 1 },
  { "-gtoggle",
    "Toggle debug information generation",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 7, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_gtoggle), 0, CLVC_BOOLEAN, 0 },
  { "-gvms",
    "Generate debug information in VMS format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 4, 1048,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gxcoff",
    "Generate debug information in XCOFF format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_g, 6, 1049,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-gxcoff+",
    "Generate debug information in extended XCOFF format",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_gxcoff, 7, 1028,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-h",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-idirafter",
    "-idirafter <dir>	Add <dir> to the end of the system include path",
    "missing path after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-imacros",
    "-imacros <file>	Accept definition of macros in <file>",
    "missing filename after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-imultiarch",
    "-imultiarch <dir>	Set <dir> to be the multiarch include subdirectory",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_COMMON | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_imultiarch), 0, CLVC_STRING, 0 },
  { "-imultilib",
    "-imultilib <dir>	Set <dir> to be the multilib include subdirectory",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-include",
    "-include <file>	Include the contents of <file> before other files",
    "missing filename after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-iplugindir=",
    "-iplugindir=<dir>	Set <dir> to be the default plugin directory",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_COMMON | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_plugindir_string), 0, CLVC_STRING, 0 },
  { "-iprefix",
    "-iprefix <path>	Specify <path> as a prefix for next two options",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-iquote",
    "-iquote <dir>	Add <dir> to the end of the quote include path",
    "missing path after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-isysroot",
    "-isysroot <dir>	Set <dir> to be the system root directory",
    "missing path after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-isystem",
    "-isystem <dir>	Add <dir> to the start of the system include path",
    "missing path after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-iwithprefix",
    "-iwithprefix <dir>	Add <dir> to the end of the system include path",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-iwithprefixbefore",
    "-iwithprefixbefore <dir>	Add <dir> to the end of the main include path",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_iwithprefix, 17, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-k8",
    "Synonym of -gnatk8",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-l",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-lang-asm",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, OPT_l, 8, -1,
    CL_C | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-m128bit-long-double",
    "sizeof(long double) is 16",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_128BIT_LONG_DOUBLE },
  { "-m16",
    "Generate 16bit i386 code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 1068,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_CODE16 },
  { "-m32",
    "Generate 32bit i386 code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 1071,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_CLEAR, OPTION_MASK_ISA_64BIT },
  { "-m3dnow",
    "Support 3DNow! built-in functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1069,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_3DNOW },
  { "-m3dnowa",
    "Support Athlon 3Dnow! built-in functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1070,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 0,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_3DNOW_A },
  { "-m64",
    "Generate 64bit x86-64 code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 1186,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ABI_64 },
  { "-m80387",
    "Use hardware fp",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1072,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_80387 },
  { "-m8bit-idiv",
    "Expand 32bit/64bit integer divide into 8bit unsigned integer divide with run-time check",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 1073,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_USE_8BIT_IDIV },
  { "-m96bit-long-double",
    "sizeof(long double) is 12",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_128BIT_LONG_DOUBLE },
  { "-mabi=",
    "Generate code that conforms to the given ABI",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_abi), 1, CLVC_ENUM, 0 },
  { "-mabm",
    "Support code generation of Advanced Bit Manipulation (ABM) instructions.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1076,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_ABM },
  { "-maccumulate-outgoing-args",
    "Reserve space for outgoing arguments in the function prologue",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, 1077,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_ACCUMULATE_OUTGOING_ARGS },
  { "-maddress-mode=",
    "Use given address mode",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_pmode), 11, CLVC_ENUM, 0 },
  { "-madx",
    "Support flag-preserving add-carry instructions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1079,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_ADX },
  { "-maes",
    "Support AES built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1080,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_AES },
  { "-malign-double",
    "Align some doubles on dword boundary",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 1081,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_ALIGN_DOUBLE },
  { "-malign-functions=",
    "Function starts are aligned to this power of 2",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_VAR_malign_functions_), 0, CLVC_BOOLEAN, 0 },
  { "-malign-jumps=",
    "Jump targets are aligned to this power of 2",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_VAR_malign_jumps_), 0, CLVC_BOOLEAN, 0 },
  { "-malign-loops=",
    "Loop code aligned to this power of 2",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_VAR_malign_loops_), 0, CLVC_BOOLEAN, 0 },
  { "-malign-stringops",
    "Align destination of the string operations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_NO_ALIGN_STRINGOPS },
  { "-march=",
    "Generate code for given CPU",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_arch_string), 0, CLVC_STRING, 0 },
  { "-masm=",
    "Use given assembler dialect",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_asm_dialect), 0, CLVC_ENUM, 0 },
  { "-mavx",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1, SSE4.2 and AVX built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1088,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_AVX },
  { "-mavx2",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1, SSE4.2, AVX and AVX2 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1089,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_AVX2 },
  { "-mavx256-split-unaligned-load",
    "Split 32-byte AVX unaligned load",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, 1090,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_AVX256_SPLIT_UNALIGNED_LOAD },
  { "-mavx256-split-unaligned-store",
    "Split 32-byte AVX unaligned store",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 29, 1091,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_AVX256_SPLIT_UNALIGNED_STORE },
  { "-mavx512cd",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1, SSE4.2, AVX, AVX2 and AVX512F and AVX512CD built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 1092,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_AVX512CD },
  { "-mavx512er",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1, SSE4.2, AVX, AVX2 and AVX512F and AVX512ER built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 1093,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_AVX512ER },
  { "-mavx512f",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1, SSE4.2, AVX, AVX2 and AVX512F built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 1094,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_AVX512F },
  { "-mavx512pf",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1, SSE4.2, AVX, AVX2 and AVX512F and AVX512PF built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 1095,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_AVX512PF },
  { "-mbmi",
    "Support BMI built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1096,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_BMI },
  { "-mbmi2",
    "Support BMI2 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1097,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_BMI2 },
  { "-mbranch-cost=",
    "Branches are this expensive (1-5, arbitrary units)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_branch_cost), 0, CLVC_BOOLEAN, 0 },
  { "-mcld",
    "Generate cld instruction in the function prologue.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1099,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_CLD },
  { "-mcmodel=",
    "Use given x86-64 code model",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_cmodel), 2, CLVC_ENUM, 0 },
  { "-mcpu=",
    0,
    0,
    "%<-mcpu=%> is deprecated; use %<-mtune=%> or %<-march=%> instead",
    NULL, NULL, OPT_mtune_, N_OPTS, 5, -1,
    CL_TARGET | CL_JOINED | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-mcrc32",
    "Support code generation of crc32 instruction.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1102,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_CRC32 },
  { "-mcx16",
    "Support code generation of cmpxchg16b instruction.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1103,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_CX16 },
  { "-mdispatch-scheduler",
    "Do dispatch scheduling if processor is bdver1 or bdver2 or bdver3 or bdver4 and Haifa scheduling is selected.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_dispatch_scheduler), 0, CLVC_BOOLEAN, 0 },
  { "-mdump-tune-features",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_dump_tunes), 0, CLVC_BOOLEAN, 0 },
  { "-mf16c",
    "Support F16C built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1106,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_F16C },
  { "-mfancy-math-387",
    "Generate sin, cos, sqrt for FPU",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_NO_FANCY_MATH_387 },
  { "-mfentry",
    "Emit profiling counter call at function entry before prologue.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1108,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_flag_fentry), 0, CLVC_BOOLEAN, 0 },
  { "-mfma",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1, SSE4.2, AVX and FMA built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1109,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_FMA },
  { "-mfma4",
    "Support FMA4 built-in functions and code generation ",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1110,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_FMA4 },
  { "-mforce-drap",
    "Always use Dynamic Realigned Argument Pointer (DRAP) to realign stack",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 1111,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_force_drap), 0, CLVC_BOOLEAN, 0 },
  { "-mfp-ret-in-387",
    "Return values of functions in FPU registers",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 1112,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_FLOAT_RETURNS },
  { "-mfpmath=",
    "Generate floating point mathematics using given instruction set",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_fpmath), 7, CLVC_ENUM, 0 },
  { "-mfsgsbase",
    "Support FSGSBASE built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 1114,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_FSGSBASE },
  { "-mfused-madd",
    0,
    0,
    "%<-mfused-madd%> is deprecated; use %<-ffp-contract=%> instead",
    "fast", "off", OPT_ffp_contract_, N_OPTS, 11, 1115,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-mfxsr",
    "Support FXSAVE and FXRSTOR instructions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1116,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_FXSR },
  { "-mhard-float",
    "Use hardware fp",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_80387 },
  { "-mhle",
    "Support Hardware Lock Elision prefixes",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1118,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_HLE },
  { "-mieee-fp",
    "Use IEEE math for fp comparisons",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 1119,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_IEEE_FP },
  { "-mincoming-stack-boundary=",
    "Assume incoming stack aligned to this power of 2",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 25, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_incoming_stack_boundary_arg), 0, CLVC_BOOLEAN, 0 },
  { "-minline-all-stringops",
    "Inline all known string operations",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, 1121,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_INLINE_ALL_STRINGOPS },
  { "-minline-stringops-dynamically",
    "Inline memset/memcpy string operations, but perform inline version only for small blocks",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 29, 1122,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_INLINE_STRINGOPS_DYNAMICALLY },
  { "-mintel-syntax",
    0,
    0,
    "%<-mintel-syntax%> and %<-mno-intel-syntax%> are deprecated; use %<-masm=intel%> and %<-masm=att%> instead",
    "intel", "att", OPT_masm_, N_OPTS, 13, 1123,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-mlarge-data-threshold=",
    "Data greater than given threshold will go into .ldata section in x86-64 medium model",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_section_threshold), 0, CLVC_BOOLEAN, 0 },
  { "-mlong-double-128",
    "Use 128-bit long double",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 1127,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_LONG_DOUBLE_128 },
  { "-mlong-double-64",
    "Use 64-bit long double",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 1125,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_LONG_DOUBLE_64 },
  { "-mlong-double-80",
    "Use 80-bit long double",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, 1126,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_LONG_DOUBLE_64 },
  { "-mlwp",
    "Support LWP built-in functions and code generation ",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1128,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_LWP },
  { "-mlzcnt",
    "Support LZCNT built-in function and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1129,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_LZCNT },
  { "-mmemcpy-strategy=",
    "Specify memcpy expansion strategy when expected size is known",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_tune_memcpy_strategy), 0, CLVC_STRING, 0 },
  { "-mmemset-strategy=",
    "Specify memset expansion strategy when expected size is known",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_tune_memset_strategy), 0, CLVC_STRING, 0 },
  { "-mmmx",
    "Support MMX built-in functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1132,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_MMX },
  { "-mmovbe",
    "Support code generation of movbe instruction.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1133,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_MOVBE },
  { "-mms-bitfields",
    "Use native (MS) bitfield layout",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 1134,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_MS_BITFIELD_LAYOUT },
  { "-mno-align-stringops",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_NO_ALIGN_STRINGOPS },
  { "-mno-default",
    "Clear all tune features",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_tune_no_default), 0, CLVC_BOOLEAN, 0 },
  { "-mno-fancy-math-387",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_NO_FANCY_MATH_387 },
  { "-mno-push-args",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_NO_PUSH_ARGS },
  { "-mno-red-zone",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_NO_RED_ZONE },
  { "-mno-sse4",
    "Do not support SSE4.1 and SSE4.2 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_CLEAR, OPTION_MASK_ISA_SSE4_1 },
  { "-momit-leaf-frame-pointer",
    "Omit the frame pointer in leaf functions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, 1141,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_OMIT_LEAF_FRAME_POINTER },
  { "-mpc32",
    "Set 80387 floating-point precision to 32-bit",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_VAR_mpc32), 0, CLVC_BOOLEAN, 0 },
  { "-mpc64",
    "Set 80387 floating-point precision to 64-bit",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_VAR_mpc64), 0, CLVC_BOOLEAN, 0 },
  { "-mpc80",
    "Set 80387 floating-point precision to 80-bit",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_VAR_mpc80), 0, CLVC_BOOLEAN, 0 },
  { "-mpclmul",
    "Support PCLMUL built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1145,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_PCLMUL },
  { "-mpopcnt",
    "Support code generation of popcnt instruction.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1146,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_POPCNT },
  { "-mprefer-avx128",
    "Use 128-bit AVX instructions instead of 256-bit AVX instructions in the auto-vectorizer.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, 1147,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_PREFER_AVX128 },
  { "-mpreferred-stack-boundary=",
    "Attempt to keep stack aligned to this power of 2",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 26, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_preferred_stack_boundary_arg), 0, CLVC_BOOLEAN, 0 },
  { "-mprefetchwt1",
    "Support PREFETCHWT1 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, 1149,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_PREFETCHWT1 },
  { "-mprfchw",
    "Support PREFETCHW instruction",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1150,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_PRFCHW },
  { "-mpush-args",
    "Use push instructions to save outgoing arguments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, 1151,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_NO_PUSH_ARGS },
  { "-mrdrnd",
    "Support RDRND built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1152,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_RDRND },
  { "-mrdseed",
    "Support RDSEED instruction",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1153,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_RDSEED },
  { "-mrecip",
    "Generate reciprocals instead of divss and sqrtss.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1154,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_RECIP },
  { "-mrecip=",
    "Control generation of reciprocal estimates.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_recip_name), 0, CLVC_STRING, 0 },
  { "-mred-zone",
    "Use red-zone in the x86-64 code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_NO_RED_ZONE },
  { "-mregparm=",
    "Number of registers used to pass integer arguments",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 1 /* UInteger */, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_regparm), 0, CLVC_BOOLEAN, 0 },
  { "-mrtd",
    "Alternate calling convention",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1158,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_RTD },
  { "-mrtm",
    "Support RTM built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1159,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_RTM },
  { "-msahf",
    "Support code generation of sahf instruction in 64bit x86-64 code.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1160,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SAHF },
  { "-msha",
    "Support SHA1 and SHA256 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1161,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SHA },
  { "-msoft-float",
    "Do not use hardware fp",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 1162,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_CLEAR, MASK_80387 },
  { "-msse",
    "Support MMX and SSE built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1163,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSE },
  { "-msse2",
    "Support MMX, SSE and SSE2 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1164,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSE2 },
  { "-msse2avx",
    "Encode SSE instructions with VEX prefix",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, 1165,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_sse2avx), 0, CLVC_BOOLEAN, 0 },
  { "-msse3",
    "Support MMX, SSE, SSE2 and SSE3 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 1166,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSE3 },
  { "-msse4",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1 and SSE4.2 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSE4_2 },
  { "-msse4.1",
    "Support MMX, SSE, SSE2, SSE3, SSSE3 and SSE4.1 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1168,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSE4_1 },
  { "-msse4.2",
    "Support MMX, SSE, SSE2, SSE3, SSSE3, SSE4.1 and SSE4.2 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, 1169,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSE4_2 },
  { "-msse4a",
    "Support MMX, SSE, SSE2, SSE3 and SSE4A built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1170,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSE4A },
  { "-msse5",
    0,
    0,
    "%<-msse5%> was removed",
    NULL, NULL, OPT_mavx, N_OPTS, 5, 1171,
    CL_TARGET | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-msseregparm",
    "Use SSE register passing conventions for SF and DF mode",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_SSEREGPARM },
  { "-mssse3",
    "Support MMX, SSE, SSE2, SSE3 and SSSE3 built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1173,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_SSSE3 },
  { "-mstack-arg-probe",
    "Enable stack probing",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, 1174,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_STACK_PROBE },
  { "-mstack-protector-guard=",
    "Use given stack-protector guard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_stack_protector_guard), 12, CLVC_ENUM, 0 },
  { "-mstackrealign",
    "Realign stack in prologue",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, 1176,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_force_align_arg_pointer), 0, CLVC_BOOLEAN, 0 },
  { "-mstringop-strategy=",
    "Chose strategy to generate stringop using",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 19, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_stringop_alg), 14, CLVC_ENUM, 0 },
  { "-mtbm",
    "Support TBM built-in functions and code generation",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1178,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_TBM },
  { "-mtls-dialect=",
    "Use given thread-local storage dialect",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_tls_dialect), 16, CLVC_ENUM, 0 },
  { "-mtls-direct-seg-refs",
    "Use direct references against %gs when accessing tls data",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 20, 1180,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_TLS_DIRECT_SEG_REFS },
  { "-mtune-ctrl=",
    "Fine grain control of tune features",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_tune_ctrl_string), 0, CLVC_STRING, 0 },
  { "-mtune=",
    "Schedule code for given CPU",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_tune_string), 0, CLVC_STRING, 0 },
  { "-mveclibabi=",
    "Vector library ABI to use",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_TARGET | CL_JOINED,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_ix86_veclibabi_type), 10, CLVC_ENUM, 0 },
  { "-mvect8-ret-in-mem",
    "Return 8-byte vectors in memory",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, 1184,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_VECT8_RETURNS },
  { "-mvzeroupper",
    "Generate vzeroupper instruction before a transfer of control flow out of the function.",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, 1185,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_target_flags), 0, CLVC_BIT_SET, MASK_VZEROUPPER },
  { "-mx32",
    "Generate 32bit x86-64 code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1067,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ABI_X32 },
  { "-mxop",
    "Support XOP built-in functions and code generation ",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, 1187,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_XOP },
  { "-mxsave",
    "Support XSAVE and XRSTOR instructions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1188,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_XSAVE },
  { "-mxsaveopt",
    "Support XSAVEOPT instruction",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, 1189,
    CL_TARGET,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /* Host_Wide_Int */, 0, 1 /* Report */,
    offsetof (struct gcc_options, x_ix86_isa_flags), 0, CLVC_BIT_SET, OPTION_MASK_ISA_XSAVEOPT },
  { "-n",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-no-canonical-prefixes",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-no-integrated-cpp",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-nocpp",
    "Disable preprocessing",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, 426,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-nodefaultlibs",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-nostartfiles",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-nostdinc",
    "Do not search standard system include directories (those specified with -isystem will still be used)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-nostdinc++",
    "Do not search standard system include directories for C++",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-nostdlib",
    "Do not look for object files in standard path",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_Ada | CL_AdaSCIL | CL_AdaWhy | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-o",
    "-o <file>	Place output into <file>",
    "missing filename after %qs",
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_Go | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_asm_file_name), 0, CLVC_STRING, 0 },
  { "-p",
    "Enable function profiling",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_profile_flag), 0, CLVC_BOOLEAN, 0 },
  { "-pass-exit-codes",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_pass_exit_codes), 0, CLVC_BOOLEAN, 0 },
  { "-pedantic",
    0,
    0,
    0,
    NULL, NULL, OPT_Wpedantic, N_OPTS, 8, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-pedantic-errors",
    "Like -pedantic but issue them as errors",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_pedantic_errors), 0, CLVC_BOOLEAN, 0 },
  { "-pg",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 2, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-pie",
    "Create a position independent executable",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 3, 1226,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-pipe",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_use_pipes), 0, CLVC_BOOLEAN, 0 },
  { "-posix",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-print-file-name=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_file_name), 0, CLVC_STRING, 0 },
  { "-print-libgcc-file-name",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 22, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-print-multi-directory",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 21, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multi_directory), 0, CLVC_BOOLEAN, 0 },
  { "-print-multi-lib",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multi_lib), 0, CLVC_BOOLEAN, 0 },
  { "-print-multi-os-directory",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 24, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multi_os_directory), 0, CLVC_BOOLEAN, 0 },
  { "-print-multiarch",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_multiarch), 0, CLVC_BOOLEAN, 0 },
  { "-print-objc-runtime-info",
    "Generate C header of platform-specific features",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 23, -1,
    CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-print-prog-name=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_prog_name), 0, CLVC_STRING, 0 },
  { "-print-search-dirs",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 17, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_search_dirs), 0, CLVC_BOOLEAN, 0 },
  { "-print-sysroot",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_sysroot), 0, CLVC_BOOLEAN, 0 },
  { "-print-sysroot-headers-suffix",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 28, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_print_sysroot_headers_suffix), 0, CLVC_BOOLEAN, 0 },
  { "-quiet",
    "Do not display functions compiled or elapsed time",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_COMMON,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_quiet_flag), 0, CLVC_BOOLEAN, 0 },
  { "-r",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-remap",
    "Remap file names when including files",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-s",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-s-bc-abi",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-save-temps",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-save-temps=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-shared",
    "Create a shared library",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, 1205,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 1 /* RejectNegative */, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-shared-libgcc",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-specs",
    0,
    0,
    0,
    NULL, NULL, OPT_specs_, N_OPTS, 5, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-specs=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-static",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 6, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libasan",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libgcc",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libgcj",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 13, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libgfortran",
    "Statically link the GNU Fortran helper library (libgfortran)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_Fortran | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libgo",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 12, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-liblsan",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libstdc++",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 16, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libtsan",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 14, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-static-libubsan",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c++03",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum",
    0,
    0,
    NULL, NULL, OPT_std_c__98, N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c++0x",
    "Deprecated in favor of -std=c++11",
    0,
    0,
    NULL, NULL, OPT_std_c__11, N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c++11",
    "Conform to the ISO 2011 C++ standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c++14",
    0,
    0,
    0,
    NULL, NULL, OPT_std_c__1y, N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c++1y",
    "Conform to the ISO 2014(?) C++ draft standard (experimental and incomplete support)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c++98",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c11",
    "Conform to the ISO 2011 C standard (experimental and incomplete support)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c1x",
    "Deprecated in favor of -std=c11",
    0,
    0,
    NULL, NULL, OPT_std_c11, N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c89",
    "Conform to the ISO 1990 C standard",
    0,
    0,
    NULL, NULL, OPT_std_c90, N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c90",
    "Conform to the ISO 1990 C standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c99",
    "Conform to the ISO 1999 C standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=c9x",
    "Deprecated in favor of -std=c99",
    0,
    0,
    NULL, NULL, OPT_std_c99, N_OPTS, 7, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=f2003",
    "Conform to the ISO Fortran 2003 standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=f2008",
    "Conform to the ISO Fortran 2008 standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=f2008ts",
    "Conform to the ISO Fortran 2008 standard including TS 29113",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=f95",
    "Conform to the ISO Fortran 95 standard",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu",
    "Conform to nothing in particular",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++03",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum with GNU extensions",
    0,
    0,
    NULL, NULL, OPT_std_gnu__98, N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++0x",
    "Deprecated in favor of -std=gnu++11",
    0,
    0,
    NULL, NULL, OPT_std_gnu__11, N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++11",
    "Conform to the ISO 2011 C++ standard with GNU extensions (experimental and incomplete support)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++14",
    0,
    0,
    0,
    NULL, NULL, OPT_std_gnu__1y, N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX | CL_UNDOCUMENTED,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++1y",
    "Conform to the ISO 201y(7?) C++ draft standard with GNU extensions (experimental and incomplete support)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu++98",
    "Conform to the ISO 1998 C++ standard revised by the 2003 technical corrigendum with GNU extensions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_CXX | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu11",
    "Conform to the ISO 2011 C standard with GNU extensions (experimental and incomplete support)",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu1x",
    "Deprecated in favor of -std=gnu11",
    0,
    0,
    NULL, NULL, OPT_std_gnu11, N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu89",
    "Conform to the ISO 1990 C standard with GNU extensions",
    0,
    0,
    NULL, NULL, OPT_std_gnu90, N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu90",
    "Conform to the ISO 1990 C standard with GNU extensions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu99",
    "Conform to the ISO 1999 C standard with GNU extensions",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=gnu9x",
    "Deprecated in favor of -std=gnu99",
    0,
    0,
    NULL, NULL, OPT_std_gnu99, N_OPTS, 9, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:1990",
    "Conform to the ISO 1990 C standard",
    0,
    0,
    NULL, NULL, OPT_std_c90, N_OPTS, 16, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:199409",
    "Conform to the ISO 1990 C standard as amended in 1994",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 18, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:1999",
    "Conform to the ISO 1999 C standard",
    0,
    0,
    NULL, NULL, OPT_std_c99, N_OPTS, 16, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:199x",
    "Deprecated in favor of -std=iso9899:1999",
    0,
    0,
    NULL, NULL, OPT_std_c99, N_OPTS, 16, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=iso9899:2011",
    "Conform to the ISO 2011 C standard (experimental and incomplete support)",
    0,
    0,
    NULL, NULL, OPT_std_c11, N_OPTS, 16, -1,
    CL_C | CL_ObjC,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-std=legacy",
    "Accept extensions to support legacy code",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 10, -1,
    CL_Fortran,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-symbolic",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 8, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-t",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-time",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 4, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_report_times), 0, CLVC_BOOLEAN, 0 },
  { "-time=",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 5, -1,
    CL_DRIVER | CL_JOINED,
    0, 0, 0, 0, 0, 0, 0, 1 /* JoinedOrMissing */, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-traditional",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 11, -1,
    CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-traditional-cpp",
    "Enable traditional preprocessing",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 15, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-trigraphs",
    "-trigraphs	Support ISO C trigraphs",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 9, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_BOOLEAN, 0 },
  { "-u",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-undef",
    "Do not predefine system-specific and GCC-specific macros",
    0,
    0,
    NULL, NULL, N_OPTS, OPT_u, 5, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_flag_undef), 0, CLVC_BOOLEAN, 0 },
  { "-v",
    "Enable verbose output",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_Fortran | CL_ObjC | CL_ObjCXX | CL_COMMON | CL_DRIVER,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_verbose_flag), 0, CLVC_BOOLEAN, 0 },
  { "-version",
    "Display the compiler's version",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_Java | CL_COMMON,
    0, 0, 0, 0, 0, 1 /* RejectDriver */, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_version_flag), 0, CLVC_BOOLEAN, 0 },
  { "-w",
    "Suppress warnings",
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_C | CL_CXX | CL_ObjC | CL_ObjCXX | CL_COMMON,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_inhibit_warnings), 0, CLVC_BOOLEAN, 0 },
  { "-wrapper",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 7, -1,
    CL_DRIVER | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    offsetof (struct gcc_options, x_wrapper_string), 0, CLVC_STRING, 0 },
  { "-x",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 },
  { "-z",
    0,
    0,
    0,
    NULL, NULL, N_OPTS, N_OPTS, 1, -1,
    CL_DRIVER | CL_JOINED | CL_SEPARATE,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, CLVC_STRING, 0 }
};



bool                                                                  
common_handle_option_auto (struct gcc_options *opts,                  
                           struct gcc_options *opts_set,              
                           const struct cl_decoded_option *decoded,   
                           unsigned int lang_mask, int kind,          
                           location_t loc,                            
                           const struct cl_option_handlers *handlers, 
                           diagnostic_context *dc)                    
{                                                                     
  size_t scode = decoded->opt_index;                                  
  int value = decoded->value;                                         
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  gcc_assert (decoded->canonical_option_num_elements <= 2);           
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wextra:
      if (!opts_set->x_warn_clobbered)
        handle_generated_option (opts, opts_set,
                                 OPT_Wclobbered, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_empty_body)
        handle_generated_option (opts, opts_set,
                                 OPT_Wempty_body, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_ignored_qualifiers)
        handle_generated_option (opts, opts_set,
                                 OPT_Wignored_qualifiers, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_missing_field_initializers)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_field_initializers, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_missing_parameter_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_parameter_type, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_old_style_declaration)
        handle_generated_option (opts, opts_set,
                                 OPT_Wold_style_declaration, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_override_init)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverride_init, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sign_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_type_limits)
        handle_generated_option (opts, opts_set,
                                 OPT_Wtype_limits, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_but_set_parameter && (opts->x_warn_unused && opts->x_extra_warnings))
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_but_set_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_parameter && (opts->x_warn_unused && opts->x_extra_warnings))
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wuninitialized:
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wunused:
      if (!opts_set->x_warn_unused_but_set_parameter && (opts->x_warn_unused && opts->x_extra_warnings))
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_but_set_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_but_set_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_but_set_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_function)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_function, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_label)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_label, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_local_typedefs)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_local_typedefs, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_parameter && (opts->x_warn_unused && opts->x_extra_warnings))
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_parameter, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_value)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_value, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused_variable)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused_variable, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
Ada_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
AdaSCIL_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
AdaWhy_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
C_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_implicit)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_missing_braces)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_braces, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_openmp_simd)
        handle_generated_option (opts, opts_set,
                                 OPT_Wopenmp_simd, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wc___compat:
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sign_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wimplicit:
      if (!opts_set->x_warn_implicit_function_declaration)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_function_declaration, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_implicit_int)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_int, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
CXX_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_cxx0x_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__0x_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_init_self)
        handle_generated_option (opts, opts_set,
                                 OPT_Winit_self, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_openmp_simd)
        handle_generated_option (opts, opts_set,
                                 OPT_Wopenmp_simd, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_reorder)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreorder, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sign_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Weffc__:
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnon_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wc__0x_compat:
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
Fortran_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
Go_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
Java_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
LTO_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
ObjC_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_implicit)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_missing_braces)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmissing_braces, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wc___compat:
      if (!opts_set->x_warn_enum_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wenum_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sign_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wimplicit:
      if (!opts_set->x_warn_implicit_function_declaration)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_function_declaration, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_implicit_int)
        handle_generated_option (opts, opts_set,
                                 OPT_Wimplicit_int, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_sign)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_sign, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               



bool                                                                  
ObjCXX_handle_option_auto (struct gcc_options *opts ATTRIBUTE_UNUSED,              
                           struct gcc_options *opts_set ATTRIBUTE_UNUSED,              
                           size_t scode ATTRIBUTE_UNUSED, const char *arg ATTRIBUTE_UNUSED, int value ATTRIBUTE_UNUSED,  
                           unsigned int lang_mask ATTRIBUTE_UNUSED, int kind ATTRIBUTE_UNUSED,          
                           location_t loc ATTRIBUTE_UNUSED,                            
                           const struct cl_option_handlers *handlers ATTRIBUTE_UNUSED, 
                           diagnostic_context *dc ATTRIBUTE_UNUSED)                    
{                                                                     
  enum opt_code code = (enum opt_code) scode;                         
                                                                      
  switch (code)                                                       
    {                                                                 
    case OPT_Wall:
      if (!opts_set->x_warn_address)
        handle_generated_option (opts, opts_set,
                                 OPT_Waddress, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_array_bounds)
        handle_generated_option (opts, opts_set,
                                 OPT_Warray_bounds, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_cxx0x_compat)
        handle_generated_option (opts, opts_set,
                                 OPT_Wc__0x_compat, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_char_subscripts)
        handle_generated_option (opts, opts_set,
                                 OPT_Wchar_subscripts, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_init_self)
        handle_generated_option (opts, opts_set,
                                 OPT_Winit_self, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_maybe_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmaybe_uninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_parentheses)
        handle_generated_option (opts, opts_set,
                                 OPT_Wparentheses, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_reorder)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreorder, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_return_type)
        handle_generated_option (opts, opts_set,
                                 OPT_Wreturn_type, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sequence_point)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsequence_point, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sign_compare)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsign_compare, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_sizeof_pointer_memaccess)
        handle_generated_option (opts, opts_set,
                                 OPT_Wsizeof_pointer_memaccess, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_aliasing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_aliasing_, NULL, value ? 3 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_strict_overflow)
        handle_generated_option (opts, opts_set,
                                 OPT_Wstrict_overflow_, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_switch)
        handle_generated_option (opts, opts_set,
                                 OPT_Wswitch, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_uninitialized)
        handle_generated_option (opts, opts_set,
                                 OPT_Wuninitialized, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unknown_pragmas)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunknown_pragmas, NULL, value ? 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_unused)
        handle_generated_option (opts, opts_set,
                                 OPT_Wunused, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_volatile_register_var)
        handle_generated_option (opts, opts_set,
                                 OPT_Wvolatile_register_var, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Weffc__:
      if (!opts_set->x_warn_delnonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wdelete_non_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonvdtor)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnon_virtual_dtor, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wconversion:
      if (!opts_set->x_warn_float_conversion)
        handle_generated_option (opts, opts_set,
                                 OPT_Wfloat_conversion, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wformat_:
      if (!opts_set->x_warn_format_contains_nul)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_contains_nul, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_extra_args)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_extra_args, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_nonliteral)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_nonliteral, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_security)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_security, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_y2k)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_y2k, NULL, value ? warn_format >= 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_format_zero_length)
        handle_generated_option (opts, opts_set,
                                 OPT_Wformat_zero_length, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_nonnull)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnonnull, NULL, value ? warn_format >= 1 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wpedantic:
      if (!opts_set->x_warn_main)
        handle_generated_option (opts, opts_set,
                                 OPT_Wmain, NULL, value ? 2 : 0,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_overlength_strings)
        handle_generated_option (opts, opts_set,
                                 OPT_Woverlength_strings, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      if (!opts_set->x_warn_pointer_arith)
        handle_generated_option (opts, opts_set,
                                 OPT_Wpointer_arith, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    case OPT_Wc__0x_compat:
      if (!opts_set->x_warn_narrowing)
        handle_generated_option (opts, opts_set,
                                 OPT_Wnarrowing, NULL, value,
                                 lang_mask, kind, loc, handlers, dc);
      break;

    default:    
      break;    
    }           
  return true;  
}               
